/*
 * Decompiled with CFR 0.152.
 */
package utility.notifications;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import resources.TApplication;
import scripts.TExecScript;
import utility.TFormulaEvaluator;
import utility.TScriptSocket;
import utility.charutil;
import utility.counters.TEventCounter;
import utility.customers.TCustomer;
import utility.dosutil;
import utility.notifications.TNotification;
import utility.notifications.TNotificationTrace;
import utility.notifications.TNotification_ClientSide;
import utility.notifications.TNotification_ServerSide;
import utility.security.TPasswordService;
import utility.ziputil;

public class TNotificationServer
extends Thread {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    public static Hashtable hashDirectSocket = null;
    Date dtLastCustomerCommit = new Date();
    boolean Terminate = false;
    boolean bTerminateThread = false;
    public static long countServiceDirectSockets = 0L;
    public static long countsendNotifications = 0L;
    public static long durationServiceDirectSockets = 0L;
    public static long durationsendNotifications = 0L;
    public static int iMaxAttachmentSize = 15000000;
    public static boolean NotificationServerInitiated = false;
    public static Date tmNotificationServerInitialized = new Date();
    public static Date tmNotificationServerLastLoop = new Date();
    public static int cThreadCount = 0;
    private static long tmDirectSocketExpire = 600000L;
    public static TNotification_ServerSide Notification_ServerSide = null;
    public String CurrentAction = "None";
    private TNotificationServerLog NotificationServerLog;
    private String HashID = "";
    private boolean IsAspectServer = false;
    private boolean IsDevelopment = this.Application.getTokenValue("ExecMode").equalsIgnoreCase("Development");
    public static boolean AllowAllAccess = false;
    public static TEventCounter EventCounter = new TEventCounter("Notification Server", 3600000L);
    public static String SupportHashID = "4CDJWSW7D|CKSBSSQH9|MT8MLHUWU|4IDCZSE67|4IDCZSE68|4IDCZSE69|Z6P4IZLYG|C2DXGDRYB|V8K3EY5Q1";
    private byte[] b = new byte[4];
    private static String PingReceipt = null;
    private static Hashtable hashSending = new Hashtable();

    public TNotificationServer() {
        super("TNotificationServer" + Integer.toString(cThreadCount++));
        this.setPriority(1);
        this.NotificationServerLog = new TNotificationServerLog();
        this.NotificationServerLog.appendToLog("NotificationServer initialized");
        TFormulaEvaluator.hashCounter.put("Notification Server", EventCounter);
    }

    public void terminate() {
        this.Terminate = true;
    }

    public String getHashIDFromIPAddress(String string) {
        if (hashDirectSocket == null) {
            return "Error: No sockets open";
        }
        String string2 = "";
        Enumeration enumeration = hashDirectSocket.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            TScriptSocket tScriptSocket = (TScriptSocket)hashDirectSocket.get(string3);
            if (!tScriptSocket.getIPAddress().equals(string)) continue;
            if (string2.length() > 0) {
                string2 = string2 + "|";
            }
            string2 = string2 + string3;
        }
        if (string2.length() > 0) {
            return string2;
        }
        return "Error: Hash ID not found for " + string;
    }

    public int getCustomerRecord(String string) {
        return Notification_ServerSide.getCustomerRecord(string);
    }

    public String getCustomerField(String string, String string2) {
        return Notification_ServerSide.getCustomerField(string, string2);
    }

    private void serviceSocket(TScriptSocket tScriptSocket, int n, String string, boolean bl) {
        if (!bl) {
            this.NotificationServerLog.appendToLog("Service socket: " + string + " Len=" + n);
        }
        int n2 = 0;
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        long l = new Date().getTime();
        long l2 = -1L;
        try {
            tScriptSocket.socket.setReceiveBufferSize(Math.min(131072, n + 4));
            n2 = tScriptSocket.socket.getReceiveBufferSize();
            tScriptSocket.socket.setSoTimeout(180000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl2 = false;
        long l3 = new Date().getTime();
        long l4 = new Date().getTime();
        do {
            block49: {
                try {
                    do {
                        n5 = Math.min(n - n3, n2);
                        n6 = tScriptSocket.socketInputStream.read(byArray, n3, n5);
                        n3 += n6;
                        n4 += n6;
                        if (n6 <= 0) continue;
                        l3 = new Date().getTime();
                    } while (n3 < n);
                }
                catch (Exception exception) {
                    long l5 = new Date().getTime();
                    long l6 = l5 - l;
                    long l7 = l5 - l3;
                    String string2 = "Error reading notification [" + string + "] Len=" + n + " TtlBytesRead=" + n4 + " Ttl Elapsed=" + l6 + " ms since read=" + l7;
                    this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 4, "Notification Server+: " + string2 + " " + exception.toString());
                    this.NotificationServerLog.appendToLog("Service socket: " + string + " Len=" + n + " TtlBytesRead=" + n4 + " Elapsed=" + (new Date().getTime() - l));
                    if (exception.toString().toUpperCase().indexOf("SOCKETTIMEOUTEXCEPTION") >= 0) break block49;
                    this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 4, "Service socket: " + string + " Failed: " + exception.toString());
                    bl2 = true;
                }
            }
            if (n4 < n && !bl2) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            l4 = new Date().getTime();
        } while (!bl2 && n4 < n && (l4 - l < 360000L || l4 - l3 < 60000L));
        if (n4 < n) {
            this.NotificationServerLog.appendToLog("Service socket: " + string + " Error reading data.");
            this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 4, "Service socket: " + string + " Removing socket. Timed Out [" + string + "] Len=" + n + " TtlBytesRead=" + n4 + " MS=" + (new Date().getTime() - l));
            hashDirectSocket.remove(string);
            tScriptSocket.bServicing = false;
            tScriptSocket.dispose();
            return;
        }
        this.NotificationServerLog.appendToLog("Service socket: " + string + " Got " + n4 + " bytes");
        TNotification tNotification = null;
        try {
            String string3 = ziputil.gunzipString(byArray);
            if (string3.length() <= 0) {
                this.NotificationServerLog.appendToLog("Service socket: " + string + " Invalid zip string");
                this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 4, "Service socket: " + string + " Invalid zip string");
                tScriptSocket.bServicing = false;
                return;
            }
            tNotification = new TNotification(string3);
            this.NotificationServerLog.appendToLog("Service socket: " + string + " got " + tNotification.toString());
        }
        catch (Exception exception) {
            this.NotificationServerLog.appendToLog("Service socket: " + string + " Invalid zip string(2)");
            this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 4, "Service socket: " + string + " Invalid zip string(2)");
            tScriptSocket.bServicing = false;
            return;
        }
        boolean bl3 = false;
        if (!bl3) {
            if (tNotification != null && tNotification.IsValid) {
                this.NotificationServerLog.appendToLog("Service socket: " + string + " Notification ID=" + tNotification.ID);
                if (tNotification.Type == TNotification.NOTIFICATION_PING) {
                    if (!bl) {
                        this.NotificationServerLog.appendToLog("Service socket: " + string + " complete.  Ping.");
                    }
                    if (TFormulaEvaluator.NotificationTrace != null) {
                        TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_PING, tNotification);
                    }
                } else {
                    if (TNotification.DebugNotifications && tNotification.Type != TNotification.NOTIFICATION_RECEIPT) {
                        this.MainWin.appendToLog("TNotificationServer", "addNotification", Thread.currentThread(), null, 3, "Notification Server: Received " + tNotification.toString());
                    }
                    if (tNotification.isDiagnostic()) {
                        if (tNotification.Type == TNotification.NOTIFICATION_RECEIPT) {
                            this.MainWin.appendToLog("TNotificationServer", "addNotification", Thread.currentThread(), null, 3, "Notification Server+: Received " + tNotification.toString());
                        } else {
                            this.MainWin.appendToLog("TNotificationServer", "addNotification", Thread.currentThread(), null, 3, "Notification Server+: Received " + tNotification.toString());
                        }
                    }
                    if (TFormulaEvaluator.NotificationTrace != null) {
                        TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_RECV, tNotification);
                    }
                    if (tNotification.AttachedFilename.trim().length() > 0) {
                        String string4;
                        if (TFormulaEvaluator.NotificationTrace != null) {
                            TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_RECVATTACHSTART, tNotification);
                        }
                        this.NotificationServerLog.appendToLog("Service socket: " + string + " Get attachment name=" + tNotification.AttachedFilename);
                        tNotification.AttachedFilename = string4 = this.Application.getHomeDir() + "greenlight/notifications/" + TPasswordService.generateSalt(16) + ".$$$";
                        int n7 = 0;
                        try {
                            tScriptSocket.socket.setSoTimeout(120000);
                            n7 = tScriptSocket.socketInputStream.readInt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.NotificationServerLog.appendToLog("Service socket: " + string + " Begin get attachment.  Size=" + n7 + " bytes");
                        if (n7 > iMaxAttachmentSize) {
                            this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server: Ignored attachment over size limit.  Size=" + n7);
                            if (TFormulaEvaluator.NotificationTrace != null) {
                                TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_SIZEEXCEEDED, tNotification);
                            }
                            TNotification tNotification2 = new TNotification(tNotification);
                            tNotification2.Type = TNotification.NOTIFICATION_SERVER_RECEIPT;
                            tNotification2.Data = "";
                            tNotification2.AttachedFilename = "";
                            tScriptSocket.writeZipString(tNotification2.toSendString(), true);
                            hashDirectSocket.remove(string);
                            tScriptSocket.dispose();
                            this.NotificationServerLog.appendToLog("Service socket: " + string + " complete.  Attachment too large.");
                        } else {
                            this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server: Getting attached file for: " + tNotification.ID + " Size=" + n7);
                            if (n7 > 0) {
                                long l8 = tScriptSocket.writeToFile(string4, n7);
                                long l9 = dosutil.getChecksum(string4);
                                if (l8 == (long)n7) {
                                    this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server: Got attached file for: " + tNotification.ID + " Size=" + Integer.toString(n7) + " Filename=" + string4 + " CRC=" + l9);
                                    this.NotificationServerLog.appendToLog("Service socket: " + string + " Got attached file for: " + tNotification.ID + " Size=" + Integer.toString(n7) + " Filename=" + string4 + " CRC=" + l9);
                                } else {
                                    this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 4, "Notification Server: Got attached file for: " + tNotification.ID + " Size=" + l8 + " Reported Size=" + n7 + " Filename=" + string4 + " CRC=" + l9);
                                    this.NotificationServerLog.appendToLog("Service socket: " + string + " Got attached file for: " + tNotification.ID + " Size=" + l8 + " Reported Size=" + n7 + " Filename=" + string4 + " CRC=" + l9);
                                }
                            }
                            Notification_ServerSide.addNotification(tNotification);
                            if (tNotification != null) {
                                EventCounter.addEvent("Receive", "Type=" + TNotification.getTypeName(tNotification.Type) + "&From=" + tNotification.From + "&To=" + tNotification.To);
                            }
                            if (TFormulaEvaluator.NotificationTrace != null) {
                                TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_RECVATTACHEND, tNotification);
                            }
                            if (tNotification.Type != TNotification.NOTIFICATION_RECEIPT) {
                                TNotification tNotification3 = new TNotification(tNotification);
                                tNotification3.From = this.Application.getAspectHashID();
                                tNotification3.To = tNotification.From;
                                tNotification3.FromName = "";
                                tNotification3.ToName = "";
                                tNotification3.Type = TNotification.NOTIFICATION_SERVER_RECEIPT;
                                tNotification3.TimeToLive = 5;
                                tNotification3.Data = "";
                                tNotification3.AttachedFilename = "";
                                if (TNotification.DebugNotifications) {
                                    this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server: Sending server receipt for: " + tNotification3.toString());
                                }
                                if (tNotification.isDiagnostic()) {
                                    this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server+: Sending server receipt for: " + tNotification3.toString());
                                }
                                tScriptSocket.writeZipString(tNotification3.toSendString(), true);
                                if (TFormulaEvaluator.NotificationTrace != null) {
                                    TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_SENDRECEIPT, tNotification3);
                                }
                            }
                            tScriptSocket.tmLastService = 0L;
                            this.NotificationServerLog.appendToLog("Service socket: " + string + " complete.  Ok.  Attachment Ok.");
                        }
                    } else {
                        Notification_ServerSide.addNotification(tNotification);
                        if (tNotification != null) {
                            EventCounter.addEvent("Receive", "Type=" + TNotification.getTypeName(tNotification.Type) + "&From=" + tNotification.From + "&To=" + tNotification.To);
                        }
                        if (tNotification.Type != TNotification.NOTIFICATION_RECEIPT) {
                            TNotification tNotification4 = new TNotification(tNotification);
                            tNotification4.From = this.Application.getAspectHashID();
                            tNotification4.To = tNotification.From;
                            tNotification4.FromName = "";
                            tNotification4.ToName = "";
                            tNotification4.Type = TNotification.NOTIFICATION_SERVER_RECEIPT;
                            tNotification4.TimeToLive = 5;
                            tNotification4.Data = "";
                            tNotification4.AttachedFilename = "";
                            if (TNotification.DebugNotifications) {
                                this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server: Sending " + tNotification4.toString());
                            }
                            if (tNotification.isDiagnostic()) {
                                this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server+: Sending " + tNotification4.toString());
                            }
                            tScriptSocket.writeZipString(tNotification4.toSendString(), true);
                            if (TFormulaEvaluator.NotificationTrace != null) {
                                TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_SENDRECEIPT, tNotification4);
                            }
                        }
                        tScriptSocket.tmLastService = 0L;
                        this.NotificationServerLog.appendToLog("Service socket: " + string + " complete.  Ok.");
                    }
                }
                tScriptSocket.tmLastRead = new Date().getTime();
            } else {
                hashDirectSocket.remove(string);
                tScriptSocket.dispose();
                this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server: Closed socket [" + string + "][" + tScriptSocket.getIPAddress() + "] because data was invalid Len=" + n);
                this.NotificationServerLog.appendToLog("Service socket: " + string + " complete.  Closed.  Invalid length.");
            }
        } else {
            this.NotificationServerLog.appendToLog("serviceDirectSockets reading notification complete");
            System.out.println("Ignored direct socket data from: " + tScriptSocket.getIPAddress() + " " + tNotification.From);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(new Date());
            gregorianCalendar.add(13, 30);
            tScriptSocket.tmLastService = gregorianCalendar.getTime().getTime();
            this.NotificationServerLog.appendToLog("Service socket: " + string + " complete.  Ignored");
        }
        tScriptSocket.bServicing = false;
    }

    public void serviceDirectSockets() {
        if (hashDirectSocket == null || hashDirectSocket.size() == 0) {
            return;
        }
        this.NotificationServerLog.appendToLog("serviceDirectSockets started  Sockets: " + hashDirectSocket.size() + " Queued: " + TFormulaEvaluator.SocketQueue.getQueue().size() + " Scripts: " + TExecScript.countScripts(null) + " Threads: " + Thread.activeCount());
        long l = new Date().getTime();
        ++countServiceDirectSockets;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 40;
        int n7 = Thread.activeCount();
        if (n7 >= n6) {
            this.NotificationServerLog.appendToLog("Aborting serviceDirectSockets thread count=" + n7);
        }
        Enumeration enumeration = hashDirectSocket.keys();
        while (n7 < n6 && enumeration.hasMoreElements()) {
            long l2;
            final String string = (String)enumeration.nextElement();
            boolean bl = true;
            if (!AllowAllAccess && !TCustomer.getCompanyID(string).toUpperCase().startsWith("5GIAV")) {
                try {
                    bl = TCustomer.getAllowAccess(string);
                    if (!bl) {
                        this.NotificationServerLog.appendToLog("Access Denied: " + string + " " + TCustomer.getOrganization(string) + " CompanyID: " + TCustomer.getCompanyID(string));
                    }
                }
                catch (Exception exception) {
                    this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), exception, 4, "Notification Server: " + exception.toString());
                    bl = true;
                }
            }
            if (!bl) continue;
            final TScriptSocket tScriptSocket = (TScriptSocket)hashDirectSocket.get(string);
            boolean bl2 = l - tScriptSocket.tmLastNotificationSentFromServer < 720000L;
            boolean bl3 = false;
            if (SupportHashID.indexOf(string.toUpperCase()) >= 0) {
                bl3 = true;
            }
            if (bl2) {
                ++n2;
            }
            if ((l2 = l - tScriptSocket.tmLastService) <= 30000L) {
                ++n3;
            }
            if (tScriptSocket.bInWriteToFile) {
                ++n4;
            }
            if (tScriptSocket.bServicing) {
                this.NotificationServerLog.appendToLog("ServiceDirectSockets: already servicing " + string);
            }
            if (!tScriptSocket.bServicing && !tScriptSocket.bInWriteToFile && (bl3 || bl2 || l2 > 30000L)) {
                int n8;
                boolean bl4;
                block32: {
                    ++n;
                    tScriptSocket.tmLastService = l;
                    bl4 = false;
                    n8 = 0;
                    try {
                        if (bl2) {
                            tScriptSocket.socket.setSoTimeout(1);
                        } else {
                            tScriptSocket.socket.setSoTimeout(1);
                        }
                        this.b[0] = 0;
                        this.b[1] = 0;
                        this.b[2] = 0;
                        this.b[3] = 0;
                        this.b[0] = tScriptSocket.socketInputStream.readByte();
                        tScriptSocket.socket.setSoTimeout(1000);
                        this.b[1] = tScriptSocket.socketInputStream.readByte();
                        this.b[2] = tScriptSocket.socketInputStream.readByte();
                        this.b[3] = tScriptSocket.socketInputStream.readByte();
                        n8 = (this.b[0] & 0xFF) << 24 | (this.b[1] & 0xFF) << 16 | (this.b[2] & 0xFF) << 8 | this.b[3] & 0xFF;
                    }
                    catch (IOException iOException) {
                        if (l - tScriptSocket.tmLastRead <= tmDirectSocketExpire) break block32;
                        this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server: Removing inactive direct socket [" + string + "] [" + tScriptSocket.getIPAddress() + "]");
                        hashDirectSocket.remove(string);
                        tScriptSocket.dispose();
                        bl4 = true;
                    }
                }
                if (n8 > 1) {
                    this.NotificationServerLog.appendToLog("ServiceDirectSockets: " + string + " Len=" + n8);
                }
                if (!bl4) {
                    if (n8 == 1) {
                        tScriptSocket.tmLastRead = new Date().getTime();
                        ++n5;
                        this.NotificationServerLog.appendToLog("ServiceDirectSockets: " + string + " Received 1-byte ping");
                        if (PingReceipt == null) {
                            TNotification tNotification = new TNotification("", "", "", TNotification.NOTIFICATION_PING, "", 0, "", "", new Date(), "", 5);
                            PingReceipt = tNotification.toSendString();
                        }
                        try {
                            tScriptSocket.writeZipString(PingReceipt, true);
                            tScriptSocket.flush();
                            this.NotificationServerLog.appendToLog("ServiceDirectSockets: " + string + " Sent ping receipt");
                        }
                        catch (Exception exception) {
                            this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), exception, 4, "Notification Server: Error sending ping receipt to [" + string + "]" + " " + exception.toString());
                            this.NotificationServerLog.appendToLog("ServiceDirectSockets: " + string + " Error sending ping receipt");
                        }
                    } else if (n8 < iMaxAttachmentSize + 8192 && n8 > 0) {
                        if (n8 == 80 || n8 == 81) {
                            this.serviceSocket(tScriptSocket, n8, string, true);
                            ++n5;
                        } else {
                            tScriptSocket.bServicing = true;
                            final int n9 = n8;
                            Thread thread = new Thread(){

                                @Override
                                public void run() {
                                    TNotificationServer.this.serviceSocket(tScriptSocket, n9, string, false);
                                }
                            };
                            thread.setName("TNotificationServer_" + thread.getName());
                            thread.setPriority(1);
                            thread.start();
                        }
                    } else if (n8 > 0) {
                        hashDirectSocket.remove(string);
                        tScriptSocket.dispose();
                        this.NotificationServerLog.appendToLog("Closed socket [" + string + "][" + tScriptSocket.getIPAddress() + "] because length of data is invalid Len=" + n8);
                        this.MainWin.appendToLog("TNotificationServer", "serviceDirectSockets", Thread.currentThread(), null, 3, "Notification Server: Closed socket [" + string + "][" + tScriptSocket.getIPAddress() + "] because length of data is invalid Len=" + n8);
                    }
                }
            }
            try {
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((n7 = Thread.activeCount()) < n6) continue;
            this.NotificationServerLog.appendToLog("Aborting serviceDirectSockets thread count=" + n7);
            System.out.println("Aborting serviceDirectSockets thread count=" + n7);
        }
        if (l - this.dtLastCustomerCommit.getTime() > 900000L) {
            Notification_ServerSide.updateDateLastModified();
            this.dtLastCustomerCommit.setTime(l);
        }
        long l3 = new Date().getTime() - l;
        this.NotificationServerLog.appendToLog("serviceDirectSockets complete (" + l3 + "ms) Serviced: " + n + " Priority: " + n2 + " Sleeping: " + n3 + " Busy: " + n4 + " Ping: " + n5);
        durationServiceDirectSockets += l3;
    }

    public void sendNotifications() {
        if (hashDirectSocket == null || hashDirectSocket.size() == 0) {
            return;
        }
        if (Notification_ServerSide == null) {
            return;
        }
        this.NotificationServerLog.appendToLog("sendNotifications started");
        long l = new Date().getTime();
        ++countsendNotifications;
        if (TNotification_ServerSide.arPendingNotifications.size() > 50) {
            this.MainWin.appendToLog("TFormulaEvaluator", "sendNotifications", Thread.currentThread(), null, 4, "Notification Server: Removing all pending notifications because count is " + TNotification_ServerSide.arPendingNotifications.size());
            while (true) {
                if (TNotification_ServerSide.arPendingNotifications.size() <= 0) break;
                TNotification_ServerSide.arPendingNotifications.remove(0);
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (n5 >= TNotification_ServerSide.arPendingNotifications.size()) break;
            TNotification tNotification = (TNotification)TNotification_ServerSide.arPendingNotifications.get(n5);
            if (!hashSending.containsKey(tNotification.To.toUpperCase())) {
                if (tNotification.isExpired()) {
                    TNotification_ServerSide.arPendingNotifications.remove(n5);
                    if (tNotification != null) {
                        EventCounter.addEvent("Expire", "Type=" + TNotification.getTypeName(tNotification.Type) + "&From=" + tNotification.From + "&To=" + tNotification.To);
                    }
                    if (tNotification.Type != TNotification.NOTIFICATION_EXPIRED && tNotification.Type != TNotification.NOTIFICATION_GET_RECIPIENT_LIST && !tNotification.isCompanyBreakout && !Notification_ServerSide.isCompany(tNotification.ReplyTo)) {
                        String string = tNotification.ID;
                        if (tNotification.ParentID.length() > 0) {
                            string = tNotification.ParentID;
                        }
                        tNotification.Type = TNotification.NOTIFICATION_EXPIRED;
                        this.NotificationServerLog.appendToLog("sendNotifications send expire notice ID=" + tNotification.ID);
                        TNotification tNotification2 = TNotification_ClientSide.sendNotification(tNotification.ReplyTo, TNotification.NOTIFICATION_EXPIRED, "Notification expired without delivery", string, 5, "", "");
                        this.NotificationServerLog.appendToLog("sendNotifications send expire notice complete ID=" + tNotification.ID);
                        if (TFormulaEvaluator.NotificationTrace != null) {
                            TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_EXPIRED, tNotification2);
                        }
                        if (TNotification.DebugNotifications) {
                            this.MainWin.appendToLog("TFormulaEvaluator", "sendNotifications", Thread.currentThread(), null, 3, "Notification Server: Created and sent expire notice for: " + tNotification.toString());
                        }
                        if (tNotification.isDiagnostic()) {
                            this.MainWin.appendToLog("TFormulaEvaluator", "sendNotifications", Thread.currentThread(), null, 3, "Notification Server+: Created and sent expire notice for: " + tNotification.toString());
                        }
                    }
                    if (TNotification.DebugNotifications) {
                        this.MainWin.appendToLog("TFormulaEvaluator", "sendNotifications", Thread.currentThread(), null, 3, "Notification Server: Removed expired notification: " + tNotification.toString());
                    }
                    if (tNotification.isDiagnostic()) {
                        this.MainWin.appendToLog("TFormulaEvaluator", "sendNotifications", Thread.currentThread(), null, 3, "Notification Server+: Removed expired notification: " + tNotification.toString());
                    }
                    this.MainWin.appendToLog("TNotificationServer", "sendNotifications", Thread.currentThread(), null, 23, "Server notification expired:" + tNotification.ID, tNotification.ID, tNotification.ParentID, tNotification.Type, tNotification.TimeToLive, tNotification.From, tNotification.To, tNotification.Data.substring(0, Math.min(tNotification.Data.length(), 256)), 0L, tNotification.Data.length(), tNotification.AttachedFilename, 0L);
                    ++n;
                } else if (hashDirectSocket.containsKey(tNotification.To)) {
                    long l2 = new Date().getTime() - tNotification.dtLastAttempt.getTime();
                    if (l2 <= 60000L) {
                        ++n3;
                    }
                    if (tNotification.Attempts == 0 || l2 > 60000L) {
                        final TScriptSocket tScriptSocket = (TScriptSocket)hashDirectSocket.get(tNotification.To);
                        if (!tScriptSocket.bInSendFile) {
                            if (tNotification.Data != null) {
                                ++n2;
                                ++tNotification.Attempts;
                                tNotification.dtLastAttempt = new Date();
                                if (tNotification != null) {
                                    EventCounter.addEvent("Send", "Type=" + TNotification.getTypeName(tNotification.Type) + "&From=" + tNotification.From + "&To=" + tNotification.To);
                                }
                                this.NotificationServerLog.appendToLog("sendNotifications sending notification " + tNotification.toString());
                                Notification_ServerSide.recordLastAttempt(tNotification);
                                if (TNotification.DebugNotifications) {
                                    this.MainWin.appendToLog("TFormulaEvaluator", "sendNotifications", Thread.currentThread(), null, 3, "Notification Server: Sending " + tNotification.toString());
                                }
                                if (tNotification.isDiagnostic()) {
                                    this.MainWin.appendToLog("TFormulaEvaluator", "sendNotifications", Thread.currentThread(), null, 3, "Notification Server+: Sending " + tNotification.toString());
                                }
                                tScriptSocket.setTimeout(1);
                                if (tNotification.Data.length() > 8192 || tNotification.AttachedFilename.trim().length() > 0) {
                                    Object object;
                                    hashSending.put(tNotification.To.toUpperCase(), tNotification.ID);
                                    if (tNotification.AttachedFilename.trim().length() > 0 && !((File)(object = new File(tNotification.AttachedFilename))).exists()) {
                                        this.NotificationServerLog.appendToLog("sendNotifications cannot find attachment for " + tNotification.ID + ": " + tNotification.AttachedFilename);
                                        this.MainWin.appendToLog("TFormulaEvaluator", "sendNotifications", Thread.currentThread(), null, 3, "Notification Server: cannot find attachment for " + tNotification.ID + ": " + tNotification.AttachedFilename);
                                        tNotification.AttachedFilename = "";
                                    }
                                    object = new TNotification(tNotification);
                                    if (TFormulaEvaluator.NotificationTrace != null) {
                                        TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_SENDSTART, (TNotification)object);
                                    }
                                    Thread thread = new Thread((TNotification)object){
                                        final /* synthetic */ TNotification val$Notification2;
                                        {
                                            this.val$Notification2 = tNotification;
                                        }

                                        @Override
                                        public void run() {
                                            if (tScriptSocket.writeZipString(this.val$Notification2.toSendString(), true)) {
                                                TNotificationServer.this.NotificationServerLog.appendToLog("sendNotifications sending notification complete ID=" + this.val$Notification2.ID);
                                                if (this.val$Notification2.AttachedFilename.trim().length() > 0) {
                                                    TNotificationServer.this.NotificationServerLog.appendToLog("sendNotifications send attachment ID=" + this.val$Notification2.ID);
                                                    File file = new File(this.val$Notification2.AttachedFilename);
                                                    int n = (int)file.length();
                                                    TNotificationServer.this.MainWin.appendToLog("TFormulaEvaluator", "sendNotifications", Thread.currentThread(), null, 3, "Notification Server: Sending attachment for " + this.val$Notification2.ID + " (" + Integer.toString(n) + " bytes)");
                                                    tScriptSocket.writeInt(n, false);
                                                    if (file.exists()) {
                                                        String string = this.val$Notification2.AttachedFilename;
                                                        String string2 = this.val$Notification2.ID;
                                                        try {
                                                            tScriptSocket.socket.setSoTimeout(20000);
                                                        }
                                                        catch (Exception exception) {
                                                            // empty catch block
                                                        }
                                                        tScriptSocket.sendFile(string);
                                                        tScriptSocket.flush();
                                                        TNotificationServer.this.NotificationServerLog.appendToLog("sendNotifications send attachment complete ID=" + this.val$Notification2.ID + " FileSize=" + n);
                                                    } else {
                                                        TNotificationServer.this.NotificationServerLog.appendToLog("sendNotifications could not find attachment: " + this.val$Notification2.AttachedFilename);
                                                    }
                                                }
                                                if (TFormulaEvaluator.NotificationTrace != null) {
                                                    TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_SENDEND, this.val$Notification2);
                                                }
                                                tScriptSocket.tmLastNotificationSentFromServer = new Date().getTime();
                                            } else {
                                                TNotificationServer.this.NotificationServerLog.appendToLog("sendNotifications sending notification error ID=" + this.val$Notification2.ID);
                                                hashDirectSocket.remove(this.val$Notification2.To);
                                                tScriptSocket.dispose();
                                                TNotificationServer.this.MainWin.appendToLog("TNotificationServer", "sendNotifications", Thread.currentThread(), null, 17, "Error sending notification", this.val$Notification2.ID, this.val$Notification2.ParentID, this.val$Notification2.Type, this.val$Notification2.TimeToLive, this.val$Notification2.From, this.val$Notification2.To, this.val$Notification2.Data, 0L, this.val$Notification2.Data.length(), this.val$Notification2.AttachedFilename, 0L);
                                                if (TFormulaEvaluator.NotificationTrace != null) {
                                                    TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_SENDERROR, this.val$Notification2);
                                                }
                                            }
                                            hashSending.remove(this.val$Notification2.To.toUpperCase());
                                        }
                                    };
                                    thread.setName("TNotificationServer_Sending_" + tNotification + "_to_" + tNotification.To);
                                    thread.setPriority(1);
                                    thread.start();
                                } else {
                                    if (TFormulaEvaluator.NotificationTrace != null) {
                                        TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_SENDSTART, tNotification);
                                    }
                                    if (tScriptSocket.writeZipString(tNotification.toSendString(), true)) {
                                        this.NotificationServerLog.appendToLog("sendNotifications sending notification complete ID=" + tNotification.ID);
                                        if (TFormulaEvaluator.NotificationTrace != null) {
                                            TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_SENDEND, tNotification);
                                        }
                                        tScriptSocket.tmLastNotificationSentFromServer = new Date().getTime();
                                    } else {
                                        this.NotificationServerLog.appendToLog("sendNotifications sending notification error ID=" + tNotification.ID);
                                        hashDirectSocket.remove(tNotification.To);
                                        tScriptSocket.dispose();
                                        this.MainWin.appendToLog("TNotificationServer", "sendNotifications", Thread.currentThread(), null, 17, "Error sending notification", tNotification.ID, tNotification.ParentID, tNotification.Type, tNotification.TimeToLive, tNotification.From, tNotification.To, tNotification.Data.substring(0, Math.min(tNotification.Data.length(), 256)), 0L, tNotification.Data.length(), tNotification.AttachedFilename, 0L);
                                        if (TFormulaEvaluator.NotificationTrace != null) {
                                            TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_SENDERROR, tNotification);
                                        }
                                    }
                                }
                            } else {
                                if (TFormulaEvaluator.NotificationTrace != null) {
                                    TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_SERVER_NODATA, tNotification);
                                }
                                TNotification_ServerSide.arPendingNotifications.remove(n5);
                                this.MainWin.appendToLog("TNotificationServer", "sendNotifications", Thread.currentThread(), null, 4, "Null data value in notification: " + tNotification.ID, tNotification.ID, tNotification.ParentID, tNotification.Type, tNotification.TimeToLive, tNotification.From, tNotification.To, tNotification.Data.substring(0, Math.min(tNotification.Data.length(), 256)), 0L, tNotification.Data.length(), tNotification.AttachedFilename, 0L);
                            }
                        } else {
                            ++n4;
                        }
                    }
                }
            } else {
                this.NotificationServerLog.appendToLog("sendNotifications skipping notification " + tNotification.ID + " because alredy sending " + hashSending.get(tNotification.To.toUpperCase()) + " to " + tNotification.To);
            }
            ++n5;
        }
        long l3 = new Date().getTime() - l;
        this.NotificationServerLog.appendToLog("sendNotifications complete (" + l3 + "ms) Expired: " + n + " Attempts: " + n2 + " Sleeping: " + n3 + " Busy: " + n4);
        durationsendNotifications += l3;
    }

    public int getEventCount(String string) {
        return EventCounter.getEventCount(string);
    }

    public int archiveNotifications() {
        if (Notification_ServerSide == null) {
            return -1;
        }
        return Notification_ServerSide.archiveNotifications();
    }

    public int getAverageServiceTime() {
        if (countServiceDirectSockets == 0L) {
            return 0;
        }
        return (int)(durationServiceDirectSockets / countServiceDirectSockets);
    }

    public int getAverageSendTime() {
        if (countsendNotifications == 0L) {
            return 0;
        }
        return (int)(durationsendNotifications / countsendNotifications);
    }

    public int getAverageLoopTime() {
        if (countServiceDirectSockets == 0L) {
            return 0;
        }
        return (int)((new Date().getTime() - tmNotificationServerInitialized.getTime()) / countServiceDirectSockets);
    }

    @Override
    public String toString() {
        String string = this.getName() + "\t";
        string = string + "\t Service: " + countServiceDirectSockets + " / " + this.getAverageServiceTime() + "ms";
        string = string + "\t Send: " + countsendNotifications + " / " + this.getAverageSendTime() + "ms";
        string = string + "\t Current Action: " + this.CurrentAction;
        string = string + "\t Loop Duration: " + this.getAverageLoopTime() + "ms";
        string = string + "\t Last Call: " + (new Date().getTime() - tmNotificationServerLastLoop.getTime()) + "ms ago";
        return string;
    }

    @Override
    public void run() {
        NotificationServerInitiated = true;
        while (Notification_ServerSide == null) {
            if (this.Application.getTokenValue("Aspect_Initialized").equalsIgnoreCase("true")) {
                Notification_ServerSide = new TNotification_ServerSide();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        do {
            tmNotificationServerLastLoop = new Date();
            try {
                this.CurrentAction = "serviceDirectSockets";
                this.serviceDirectSockets();
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TNotificationServer", "run", Thread.currentThread(), null, 4, "Error in TNotificationServer1: " + exception.toString());
            }
            try {
                this.CurrentAction = "sendNotifications";
                this.sendNotifications();
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TNotificationServer", "run", Thread.currentThread(), null, 4, "Error in TNotificationServer2: " + exception.toString());
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.HashID.length() != 0) continue;
            this.HashID = this.Application.getAspectHashID().trim();
            if (!this.MainWin.isRunningOnServer()) continue;
            this.setPriority(10);
            this.IsAspectServer = true;
        } while (!this.Terminate);
    }

    private class TNotificationServerLog {
        StringBuilder sLog = new StringBuilder();
        DateFormat dateFormat1 = DateFormat.getInstance();
        DateFormat dateFormat2 = DateFormat.getInstance();
        Long tmLastWrite = new Date().getTime();

        TNotificationServerLog() {
            ((SimpleDateFormat)this.dateFormat1).applyPattern("MM-dd-yyyy HH:mm:ss:SSS");
            ((SimpleDateFormat)this.dateFormat2).applyPattern("MMddyyyy_HH");
        }

        synchronized void appendToLog(String string) {
            this.appendToLog(string, "");
        }

        synchronized void appendToLog(String string, String string2) {
            Date date = new Date();
            this.sLog.append(TNotificationServer.this.getName() + ",");
            this.sLog.append(this.dateFormat1.format(date) + ",");
            this.sLog.append(string + ",");
            if (string2.length() > 0) {
                string2 = charutil.removeChar(string2, '\r');
                string2 = charutil.removeChar(string2, '\n');
                string2 = charutil.removeChar(string2, '\"');
            }
            this.sLog.append("\"" + string2 + "\"\r\n");
            if (date.getTime() - this.tmLastWrite > 10000L && (TNotificationServer.this.IsAspectServer || TNotificationServer.this.IsDevelopment)) {
                this.writeToFile(this.sLog.toString());
                this.sLog.setLength(0);
                this.tmLastWrite = date.getTime();
            }
        }

        void writeToFile(String string) {
            String string2 = TNotificationServer.this.Application.getTemporaryFiles() + "notification_server_" + this.dateFormat2.format(new Date()) + ".$$$";
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rwd");
                randomAccessFile.seek(randomAccessFile.length());
                randomAccessFile.writeBytes(string);
                randomAccessFile.close();
            }
            catch (Exception exception) {
                System.out.println("Error writing notification server log: " + exception.toString());
            }
        }
    }
}

