/*
 * Decompiled with CFR 0.152.
 */
package utility.notifications;

import aspect.TMainWin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Timer;
import utility.charutil;
import utility.notifications.TNotification;
import utility.security.TPasswordService;

public class TNotificationTrace
implements ActionListener {
    public static int TRACETYPE_SERVER_RECV = 0;
    public static int TRACETYPE_SERVER_RECVATTACHSTART = 1;
    public static int TRACETYPE_SERVER_RECVATTACHEND = 2;
    public static int TRACETYPE_SERVER_RECVERROR = 3;
    public static int TRACETYPE_SERVER_SENDSTART = 4;
    public static int TRACETYPE_SERVER_SENDEND = 5;
    public static int TRACETYPE_SERVER_EXPIRED = 6;
    public static int TRACETYPE_SERVER_SENDERROR = 7;
    public static int TRACETYPE_SERVER_PING = 8;
    public static int TRACETYPE_SERVER_SENDRECEIPT = 9;
    public static int TRACETYPE_SERVER_RECVRECEIPT = 10;
    public static int TRACETYPE_SERVER_SIZEEXCEEDED = 11;
    public static int TRACETYPE_SERVER_NODATA = 12;
    public static int TRACETYPE_CLIENT_RECV = 100;
    public static int TRACETYPE_CLIENT_RECVATTACHSTART = 101;
    public static int TRACETYPE_CLIENT_RECVATTACHEND = 102;
    public static int TRACETYPE_CLIENT_RECVERROR = 103;
    public static int TRACETYPE_CLIENT_SENDSTART = 104;
    public static int TRACETYPE_CLIENT_SENDEND = 105;
    public static int TRACETYPE_CLIENT_EXPIRED = 106;
    public static int TRACETYPE_CLIENT_SENDERROR = 107;
    public static int TRACETYPE_CLIENT_PING = 108;
    public static int TRACETYPE_CLIENT_SENDRECEIPT = 109;
    public static int TRACETYPE_CLIENT_RECVRECEIPT = 110;
    public static int TRACETYPE_CLIENT_SIZEEXCEEDED = 111;
    public static int TRACETYPE_CLIENT_NODATA = 112;
    public static int TRACETYPE_CLIENT_PROCESSSTART = 113;
    public static int TRACETYPE_CLIENT_PROCESSEND = 114;
    private Hashtable hashTrace = new Hashtable();
    DateFormat df1 = DateFormat.getInstance();
    DateFormat df2 = DateFormat.getInstance();
    private static Timer CallbackTimer = null;

    public TNotificationTrace() {
        ((SimpleDateFormat)this.df1).applyPattern("MM-dd-yyyy HH:mm:ss:SSS");
        ((SimpleDateFormat)this.df2).applyPattern("yyyyMMdd");
        CallbackTimer = new Timer(60000, this);
        CallbackTimer.start();
    }

    public boolean dispose() {
        this.hashTrace.clear();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.writeToFile();
    }

    public synchronized void addTrace(int n, TNotification tNotification) {
        String string = tNotification.ParentID.toUpperCase();
        if (string.trim().length() == 0) {
            string = tNotification.ID.toUpperCase();
        }
        String string2 = tNotification.Data;
        string2 = string2.substring(0, Math.min(384, string2.length()));
        string2 = charutil.replaceAllSubstrings(string2, ",", "&#44; ");
        string2 = charutil.removeChar(string2, '\n');
        string2 = charutil.removeChar(string2, '\r');
        string2 = charutil.removeChar(string2, '\"');
        TNotificationHistory tNotificationHistory = (TNotificationHistory)this.hashTrace.get(string);
        if (tNotificationHistory == null) {
            tNotificationHistory = (TNotificationHistory)this.hashTrace.get(tNotification.ID.toUpperCase());
            if (tNotificationHistory == null) {
                tNotificationHistory = new TNotificationHistory(n, tNotification, string, string2);
                this.hashTrace.put(string, tNotificationHistory);
            } else {
                string = tNotification.ID.toUpperCase();
            }
        }
        tNotificationHistory.addHistoryItem(n, tNotification, string, string2);
    }

    private String getSummaryTextForLog(TNotificationHistory tNotificationHistory, Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TPasswordService.generateSalt(6) + ",");
        stringBuilder.append(tNotificationHistory.TraceType + ",");
        stringBuilder.append(tNotificationHistory.ParentID + ",");
        stringBuilder.append(tNotificationHistory.Type + ",");
        stringBuilder.append(tNotificationHistory.From + ",");
        stringBuilder.append(tNotificationHistory.To + ",");
        stringBuilder.append(this.df1.format(tNotificationHistory.tStart) + ",");
        stringBuilder.append(this.df1.format(tNotificationHistory.tEnd) + ",");
        stringBuilder.append(tNotificationHistory.Ttl + ",");
        stringBuilder.append(tNotificationHistory.Data + ",");
        stringBuilder.append(this.df1.format(date) + "\r\n");
        return stringBuilder.toString();
    }

    private String getDetailTextForLog(TNotificationHistory tNotificationHistory, Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Date date2 = null;
        for (int i = 0; i < tNotificationHistory.arHistoryItem.size(); ++i) {
            TNotificationHistoryItem tNotificationHistoryItem = (TNotificationHistoryItem)tNotificationHistory.arHistoryItem.get(i);
            stringBuilder.append(TPasswordService.generateSalt(6) + ",");
            stringBuilder.append(tNotificationHistoryItem.TraceType + ",");
            stringBuilder.append(tNotificationHistoryItem.ParentID + ",");
            stringBuilder.append(tNotificationHistoryItem.ID + ",");
            stringBuilder.append(tNotificationHistoryItem.Type + ",");
            stringBuilder.append(this.df1.format(tNotificationHistoryItem.t) + ",");
            stringBuilder.append(tNotificationHistoryItem.From + ",");
            stringBuilder.append(tNotificationHistoryItem.To + ",");
            stringBuilder.append(tNotificationHistory.Ttl + ",");
            stringBuilder.append(tNotificationHistoryItem.Data + ",");
            long l = 0L;
            if (date2 != null) {
                l = tNotificationHistoryItem.t.getTime() - date2.getTime();
                n = (int)((long)n + l);
            }
            date2 = tNotificationHistoryItem.t;
            stringBuilder.append(l + ",");
            stringBuilder.append(n + ",");
            stringBuilder.append(this.df1.format(date) + "\r\n");
        }
        return stringBuilder.toString();
    }

    public synchronized void writeToFile() {
        this.writeToFile("");
    }

    public synchronized void writeToFile(String string) {
        Object object;
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Date date = new Date();
        Enumeration enumeration = this.hashTrace.keys();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            string2 = (String)enumeration.nextElement();
            object = (TNotificationHistory)this.hashTrace.get(string2);
            boolean bl2 = string.length() > 0 ? ((TNotificationHistory)object).ParentID.equalsIgnoreCase(string) : (bl = date.getTime() - ((TNotificationHistory)object).tEnd.getTime() > 300000L);
            if (string.length() > 0 && !bl) {
                for (int i = 0; i < ((TNotificationHistory)object).arHistoryItem.size(); ++i) {
                    TNotificationHistoryItem tNotificationHistoryItem = (TNotificationHistoryItem)((TNotificationHistory)object).arHistoryItem.get(i);
                    bl |= tNotificationHistoryItem.ID.equalsIgnoreCase(string) || tNotificationHistoryItem.ParentID.equalsIgnoreCase(string);
                }
            }
            if (!bl) continue;
            stringBuilder.append(this.getSummaryTextForLog((TNotificationHistory)object, date));
            stringBuilder2.append(this.getDetailTextForLog((TNotificationHistory)object, date));
            this.hashTrace.remove(string2);
        }
        if (stringBuilder.length() > 0) {
            string2 = TMainWin.Application.getHomeDir() + "Greenlight/Notifications/archive/" + this.df2.format(new Date()) + "_notification_summary.txt";
            try {
                object = new RandomAccessFile(string2, "rwd");
                ((RandomAccessFile)object).seek(((RandomAccessFile)object).length());
                ((RandomAccessFile)object).writeBytes(stringBuilder.toString());
                ((RandomAccessFile)object).close();
            }
            catch (Exception exception) {
                System.out.println("Error writing notification summary log: " + exception.toString());
            }
            string2 = TMainWin.Application.getHomeDir() + "Greenlight/Notifications/archive/" + this.df2.format(new Date()) + "_notification_detail.txt";
            try {
                object = new RandomAccessFile(string2, "rwd");
                ((RandomAccessFile)object).seek(((RandomAccessFile)object).length());
                ((RandomAccessFile)object).writeBytes(stringBuilder2.toString());
                ((RandomAccessFile)object).close();
            }
            catch (Exception exception) {
                System.out.println("Error writing notification summary log: " + exception.toString());
            }
        }
    }

    private class TNotificationHistoryItem
    implements Comparable {
        int TraceType;
        String ParentID;
        String ID;
        Date t;
        int Type;
        String From;
        String To;
        String Data;
        int Ttl;

        private TNotificationHistoryItem(int n, TNotification tNotification, String string, String string2) {
            this.TraceType = n;
            this.ParentID = string;
            this.ID = tNotification.ID;
            this.t = new Date();
            this.Type = tNotification.Type;
            this.From = tNotification.From;
            this.To = tNotification.To;
            this.Data = string2;
            this.Ttl = tNotification.TimeToLive;
        }

        public int compareTo(Object object) {
            if (this.t.getTime() > ((TNotificationHistoryItem)object).t.getTime()) {
                return 1;
            }
            return -1;
        }
    }

    private class TNotificationHistory {
        int TraceType;
        String ParentID;
        String From;
        String To;
        int Type;
        String Data;
        Date tStart;
        Date tEnd;
        int Ttl;
        ArrayList arHistoryItem;

        private TNotificationHistory(int n, TNotification tNotification, String string, String string2) {
            this.TraceType = n;
            this.ParentID = string;
            this.tStart = new Date();
            this.tEnd = new Date();
            this.Type = tNotification.Type;
            this.From = tNotification.From;
            this.To = tNotification.To;
            this.Data = string2;
            this.Ttl = tNotification.TimeToLive;
            this.arHistoryItem = new ArrayList();
        }

        private void addHistoryItem(int n, TNotification tNotification, String string, String string2) {
            this.tEnd = new Date();
            TNotificationHistoryItem tNotificationHistoryItem = new TNotificationHistoryItem(n, tNotification, string, string2);
            int n2 = 0;
            try {
                n2 = Collections.binarySearch(this.arHistoryItem, tNotificationHistoryItem);
                this.arHistoryItem.add(Math.abs(n2 + 1), tNotificationHistoryItem);
            }
            catch (Exception exception) {
                System.out.println("TNotificationTrace: error adding history item.");
                this.arHistoryItem.add(tNotificationHistoryItem);
            }
        }
    }
}

