/*
 * Decompiled with CFR 0.152.
 */
package utility.notifications;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TDriverStructRecord;
import drivers.files.TBinaryFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.notifications.TNotification;
import utility.objectutil;
import utility.security.TPasswordService;
import utility.transport.TTransport;
import utility.transport.TTransportRecord;

public class TNotification_ServerSide {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private static TBinaryFile drvServerNotification = null;
    private static TDriverStructRecord DSRecNotificationUsed = null;
    private static TDriverStructRecord DSRecNotificationTime = null;
    private static TDriverStructRecord DSRecNotificationID = null;
    private static TDriverStructRecord DSRecNotificationDelivered = null;
    private static TDriverStructRecord DSRecNotificationTo = null;
    private static TDriverStructRecord DSRecNotificationFrom = null;
    private static TDriverStructRecord DSRecNotificationToName = null;
    private static TDriverStructRecord DSRecNotificationFromName = null;
    private static TDriverStructRecord DSRecNotificationDiskIndex = null;
    private static TDriverStructRecord DSRecNotificationType = null;
    private static TDriverStructRecord DSRecNotificationData = null;
    private static TDriverStructRecord DSRecNotificationDeliveryConfirmed = null;
    private static TDriverStructRecord DSRecNotificationDeliveryTime = null;
    private static TDriverStructRecord DSRecNotificationDeliveryTimeLocal = null;
    private static TDriverStructRecord DSRecNotificationIsOutgoing = null;
    private static TDriverStructRecord DSRecNotificationReplyTo = null;
    private static TDriverStructRecord DSRecNotificationParentID = null;
    private static TDriverStructRecord DSRecNotificationEncryptedPassword = null;
    private static TDriverStructRecord DSRecNotificationTimeToLive = null;
    private static TDriverStructRecord DSRecNotificationExternalFilename = null;
    private static TDriverStructRecord DSRecNotificationAttachedFilename = null;
    private static TDriverStructRecord DSRecNotificationOriginalFilename = null;
    private static TDriverStructRecord DSRecNotificationIsCompanyBreakout = null;
    private static TDriverStructRecord DSRecNotificationBreakoutID = null;
    private static TDriverStructRecord DSRecNotificationServerTime = null;
    private static TDriverStructRecord DSRecNotificationServerDate = null;
    private static TDriverStructRecord DSRecNotificationIsExpired = null;
    private static TBinaryFile drvCustomer = null;
    private static TDriverStructRecord DSRecCustomerUsed = null;
    private static TDriverStructRecord DSRecCustomerHashID = null;
    private static TDriverStructRecord DSRecCustomerHashIDIsValid = null;
    private static TDriverStructRecord DSRecCustomerCompanyID = null;
    private static TDriverStructRecord DSRecCustomerOrganization = null;
    private static TDriverStructRecord DSRecCustomerPolling_Location = null;
    private static TDriverStructRecord DSRecCustomerAspect7_Store_Directory = null;
    private static TDriverStructRecord DSRecCustomerAspect7_Store_Code = null;
    private static TDriverStructRecord DSRecCustomerAspect6_Store_Code = null;
    private static TDriverStructRecord DSRecCustomerName = null;
    private static TDriverStructRecord DSRecDate_Last_Modified = null;
    private static TBinaryFile drvCompany = null;
    private static TDriverStructRecord DSRecCompanyUsed = null;
    private static TDriverStructRecord DSRecCompanyID = null;
    private static TDriverStructRecord DSRecCompanyName = null;
    private static TBinaryFile drvNotes = null;
    private static TDriverStructRecord DSRecNoteTime = null;
    private static TDriverStructRecord DSRecNoteCustomerID = null;
    private static TDriverStructRecord DSRecNoteAddedBy = null;
    private static TDriverStructRecord DSRecNoteNoteType = null;
    private static TDriverStructRecord DSRecNoteNotes = null;
    public static ArrayList arPendingNotifications = new ArrayList();
    public Hashtable hashCustomer = new Hashtable();
    public Hashtable hashCompanyName = new Hashtable();

    public TNotification_ServerSide() {
        this.openServerNotificationDriver();
        this.openCustomerDriver();
        this.openCompanyDriver();
        this.openNotesDriver();
    }

    private void openCustomerDriver() {
        TAppDriversObject tAppDriversObject = TNotification_ServerSide.Application.AppDrivers.getAppDriversObject("Aspect_Support_Customer_Profile");
        if (tAppDriversObject != null) {
            drvCustomer = new TBinaryFile(Application, tAppDriversObject, 1, false);
            try {
                drvCustomer.makeEditableFile();
                DSRecCustomerUsed = TNotification_ServerSide.drvCustomer.DriverStruct.getField("used");
                DSRecCustomerHashID = TNotification_ServerSide.drvCustomer.DriverStruct.getField("HashID");
                DSRecCustomerHashIDIsValid = TNotification_ServerSide.drvCustomer.DriverStruct.getField("HashID_Is_Valid");
                DSRecCustomerCompanyID = TNotification_ServerSide.drvCustomer.DriverStruct.getField("Company_ID");
                DSRecCustomerOrganization = TNotification_ServerSide.drvCustomer.DriverStruct.getField("Organization");
                DSRecCustomerPolling_Location = TNotification_ServerSide.drvCustomer.DriverStruct.getField("Polling_Location");
                DSRecCustomerAspect7_Store_Directory = TNotification_ServerSide.drvCustomer.DriverStruct.getField("Aspect7_Store_Directory");
                DSRecCustomerAspect7_Store_Code = TNotification_ServerSide.drvCustomer.DriverStruct.getField("Aspect7_Store_Code");
                DSRecCustomerAspect6_Store_Code = TNotification_ServerSide.drvCustomer.DriverStruct.getField("Aspect6_Store_Code");
                DSRecCustomerName = TNotification_ServerSide.drvCustomer.DriverStruct.getField("Organization");
                DSRecDate_Last_Modified = TNotification_ServerSide.drvCustomer.DriverStruct.getField("Date_Last_Modified");
            }
            catch (Exception exception) {
                System.out.println("Error in TNotification_ServerSide opening customer driver: " + exception.toString());
            }
        }
    }

    private void openCompanyDriver() {
        TAppDriversObject tAppDriversObject = TNotification_ServerSide.Application.AppDrivers.getAppDriversObject("Aspect_Support_Company_Profile");
        if (tAppDriversObject != null) {
            drvCompany = new TBinaryFile(Application, tAppDriversObject, 0, false);
            try {
                drvCompany.makeEditableFile();
                DSRecCompanyUsed = TNotification_ServerSide.drvCompany.DriverStruct.getField("used");
                DSRecCompanyID = TNotification_ServerSide.drvCompany.DriverStruct.getField("ID");
                DSRecCompanyName = TNotification_ServerSide.drvCompany.DriverStruct.getField("Name");
            }
            catch (Exception exception) {
                System.out.println("Error in TNotification_ServerSide opening company driver: " + exception.toString());
            }
        }
    }

    private void openNotesDriver() {
        TAppDriversObject tAppDriversObject = TNotification_ServerSide.Application.AppDrivers.getAppDriversObject("Aspect_Support_Notes");
        if (tAppDriversObject != null) {
            drvNotes = new TBinaryFile(Application, tAppDriversObject, 1, false);
            try {
                drvNotes.makeEditableFile();
                DSRecNoteTime = TNotification_ServerSide.drvNotes.DriverStruct.getField("Time");
                DSRecNoteCustomerID = TNotification_ServerSide.drvNotes.DriverStruct.getField("Customer_ID");
                DSRecNoteAddedBy = TNotification_ServerSide.drvNotes.DriverStruct.getField("Added_By");
                DSRecNoteNoteType = TNotification_ServerSide.drvNotes.DriverStruct.getField("Note_Type");
                DSRecNoteNotes = TNotification_ServerSide.drvNotes.DriverStruct.getField("Notes");
            }
            catch (Exception exception) {
                System.out.println("Error in TNotification_ServerSide opening company driver: " + exception.toString());
            }
        }
    }

    private void openServerNotificationDriver() {
        Comparable comparable;
        if (MainWin.isRunningOnServer()) {
            if (TMainWin.IsRestart && ((File)(comparable = new File(Application.getHomeDir() + "server_notifications.dta"))).exists()) {
                File file = new File("c:\\aspect7\\aspectlogs\\server_notifications_" + dateutil.formatDate(new Date(), "MMddyyyy_HHmmss") + ".dta");
                ((File)comparable).renameTo(file);
            }
        }
        comparable = TNotification_ServerSide.Application.AppDrivers.getAppDriversObject("GreenLight_Notification_Server");
        drvServerNotification = new TBinaryFile(Application, (TAppDriversObject)comparable, 1, false);
        try {
            drvServerNotification.makeEditableFile();
            DSRecNotificationUsed = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("used");
            DSRecNotificationTime = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("time");
            DSRecNotificationID = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("ID");
            DSRecNotificationDelivered = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("delivered");
            DSRecNotificationTo = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("to");
            DSRecNotificationFrom = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("from");
            DSRecNotificationToName = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("to_name");
            DSRecNotificationFromName = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("from_name");
            DSRecNotificationDiskIndex = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("diskindex");
            DSRecNotificationType = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("type");
            DSRecNotificationData = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("data");
            DSRecNotificationDeliveryConfirmed = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Delivery_Confirmed");
            DSRecNotificationDeliveryTime = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Delivery_Time");
            DSRecNotificationDeliveryTimeLocal = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Delivery_Time_Local");
            DSRecNotificationIsOutgoing = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("IsOutgoing");
            DSRecNotificationReplyTo = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("ReplyTo");
            DSRecNotificationParentID = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("ParentID");
            DSRecNotificationEncryptedPassword = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Encrypted_Password");
            DSRecNotificationTimeToLive = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Time_To_Live");
            DSRecNotificationExternalFilename = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("External_Filename");
            DSRecNotificationAttachedFilename = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Attached_Filename");
            DSRecNotificationOriginalFilename = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Original_Filename");
            DSRecNotificationIsCompanyBreakout = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Is_Company_Breakout");
            DSRecNotificationBreakoutID = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Breakout_ID");
            DSRecNotificationServerTime = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Server_Time");
            DSRecNotificationServerDate = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("Server_Date");
            DSRecNotificationIsExpired = TNotification_ServerSide.drvServerNotification.DriverStruct.getField("isExpired");
            int n = drvServerNotification.getRecordCount();
            for (int i = 0; i < n; ++i) {
                String string;
                boolean bl = (Boolean)drvServerNotification.getField(DSRecNotificationUsed, i);
                boolean bl2 = (Boolean)drvServerNotification.getField(DSRecNotificationDelivered, i);
                if (!bl || bl2) continue;
                String string2 = (String)drvServerNotification.getField(DSRecNotificationID, i);
                Date date = (Date)drvServerNotification.getField(DSRecNotificationTime, i);
                String string3 = (String)drvServerNotification.getField(DSRecNotificationTo, i);
                String string4 = (String)drvServerNotification.getField(DSRecNotificationFrom, i);
                int n2 = (Integer)drvServerNotification.getField(DSRecNotificationType, i);
                String string5 = (String)drvServerNotification.getField(DSRecNotificationData, i);
                String string6 = (String)drvServerNotification.getField(DSRecNotificationReplyTo, i);
                String string7 = (String)drvServerNotification.getField(DSRecNotificationParentID, i);
                String string8 = (String)drvServerNotification.getField(DSRecNotificationEncryptedPassword, i);
                int n3 = (Integer)drvServerNotification.getField(DSRecNotificationTimeToLive, i);
                Date date2 = (Date)drvServerNotification.getField(DSRecNotificationServerTime, i);
                TNotification tNotification = new TNotification(string2, string4, string3, n2, string5, i, string6, string7, date, string8, n3);
                tNotification.Server_Time = date2;
                if (tNotification.isExpired()) continue;
                tNotification.ExternalFilename = (String)drvServerNotification.getField(DSRecNotificationExternalFilename, i);
                if (tNotification.ExternalFilename.length() > 0) {
                    tNotification.Data = TAsciiInput.getContent(tNotification.ExternalFilename);
                }
                if ((string = (String)drvServerNotification.getField(DSRecNotificationAttachedFilename, i)).trim().length() > 0) {
                    tNotification.AttachedFilename = string;
                    tNotification.OriginalFilename = (String)drvServerNotification.getField(DSRecNotificationOriginalFilename, i);
                }
                arPendingNotifications.add(tNotification);
                if (!TNotification.DebugNotifications) continue;
                MainWin.appendToLog("TNofification_ServerSide", "openServerNotificationDriver", Thread.currentThread(), null, 3, "Notification Server: Read pending notification: " + tNotification.toString());
            }
        }
        catch (Exception exception) {
            System.out.println("Error in openServerNotificationDriver: " + exception.toString());
        }
    }

    public boolean addCustomerToHashtable(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        drvCustomer.clearBuffer();
        int n = drvCustomer.getMatchingRecord("HashID=\"" + string + "\"", 0);
        if (n < 0) {
            MainWin.appendToLog("TNofification_ServerSide", "recordPing", Thread.currentThread(), null, 3, "Notification Server: Invalid customer ID: " + string + " Record count=" + drvCustomer.getRecordCount());
            return false;
        }
        this.hashCustomer.put(string, new TCustomerInfo(n));
        return true;
    }

    public TCustomerInfo getCustomerInfo(String string) {
        if (!this.hashCustomer.containsKey(string) && !this.addCustomerToHashtable(string)) {
            return null;
        }
        return (TCustomerInfo)this.hashCustomer.get(string);
    }

    public String getFullCompanyID(String string) {
        if (string.length() < 8) {
            MainWin.appendToLog("TNofification_ServerSide", "getFullCompanyID", Thread.currentThread(), null, 4, "getFullCompanyID: Too few characters in company ID: " + string);
            return "";
        }
        String string2 = string.substring(0, 8);
        int n = drvCustomer.getMatchingRecord("(left(Company_ID,8)=\"" + string2 + "\")", 0);
        if (n >= 0) {
            return (String)drvCustomer.getField("Company_ID", n);
        }
        MainWin.appendToLog("TNofification_ServerSide", "validateLogin", Thread.currentThread(), null, 4, "getFullCompanyID: No match for CompanyID=" + string2);
        return "";
    }

    public boolean validateLogin(String string, String string2) {
        String string3 = TPasswordService.encrypt(string2, "123", 768).substring(0, 6);
        if (string.length() < 8) {
            return false;
        }
        String string4 = string.substring(0, 8);
        int n = drvCustomer.getMatchingRecord("(left(Company_ID,8)=\"" + string4 + "\") and (Polling_Password=\"" + string3 + "\")", 0);
        if (n < 0) {
            MainWin.appendToLog("TNofification_ServerSide", "validateLogin", Thread.currentThread(), null, 4, "validateLogin: No match for CompanyID=" + string4);
            return false;
        }
        if (n >= 0) {
            String string5 = (String)drvCustomer.getField("Polling_Password", n);
            if (string3.equals(string5)) {
                return true;
            }
            MainWin.appendToLog("TNofification_ServerSide", "validateLogin", Thread.currentThread(), null, 4, "validateLogin: Password mismatch");
        }
        return false;
    }

    public boolean recordLastAttempt(TNotification tNotification) {
        if (tNotification.DiskIndex < 0) {
            return false;
        }
        drvServerNotification.putField("Delivery_Attempts", tNotification.DiskIndex, (Object)new Integer(tNotification.Attempts));
        drvServerNotification.putField("Last_Attempt", tNotification.DiskIndex, (Object)new Date());
        drvServerNotification.clearWriteBuffer();
        return true;
    }

    public String getCustomerField(String string, String string2) {
        if (!this.hashCustomer.containsKey(string) && !this.addCustomerToHashtable(string)) {
            return null;
        }
        int n = ((TCustomerInfo)this.hashCustomer.get((Object)string)).RecordIndex;
        TDriverStructRecord tDriverStructRecord = TNotification_ServerSide.drvCustomer.DriverStruct.getField(string2);
        Object object = drvCustomer.getField(tDriverStructRecord, n);
        return objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
    }

    public int getCustomerRecord(String string) {
        if (!this.hashCustomer.containsKey(string) && !this.addCustomerToHashtable(string)) {
            return -1;
        }
        return ((TCustomerInfo)this.hashCustomer.get((Object)string)).RecordIndex;
    }

    public String getCompanyInfo(String string, String string2) {
        if (string.trim().length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = TPasswordService.encrypt(string2, "abc", 16);
        boolean bl = string.toUpperCase().startsWith("5GIAV") && string3.substring(0, 6).equalsIgnoreCase(Application.getTokenValue("AspectSupportNotificationPass").substring(0, 6));
        for (int i = 0; i < drvCustomer.getRecordCount(); ++i) {
            boolean bl2;
            String string4 = (String)drvCustomer.getField(DSRecCustomerCompanyID, i);
            if (!string4.equalsIgnoreCase(string) && !bl || !(bl2 = ((Boolean)drvCustomer.getField(DSRecCustomerHashIDIsValid, i)).booleanValue())) continue;
            stringBuilder.append("\n" + drvCustomer.getField(DSRecCustomerHashID, i) + "|");
            stringBuilder.append(drvCustomer.getField(DSRecCustomerOrganization, i) + "|");
            stringBuilder.append(drvCustomer.getField(DSRecCustomerPolling_Location, i) + "|");
            stringBuilder.append(drvCustomer.getField(DSRecCustomerAspect7_Store_Directory, i) + "|");
            stringBuilder.append(drvCustomer.getField(DSRecCustomerAspect7_Store_Code, i) + "|");
            stringBuilder.append(drvCustomer.getField(DSRecCustomerAspect6_Store_Code, i) + "|");
            stringBuilder.append(string4 + "|");
            String string5 = (String)this.hashCompanyName.get(string4.toUpperCase());
            if (string5 == null) {
                int n = drvCompany.getMatchingRecord("ID=\"" + string4 + "\"", 0);
                string5 = n >= 0 ? (String)drvCompany.getField(DSRecCompanyName, n) : "";
                this.hashCompanyName.put(string4.toUpperCase(), string5);
            }
            stringBuilder.append(string5 + "|");
            stringBuilder.append(drvCustomer.getField("Days_Since_Active", i) + "|");
            stringBuilder.append(drvCustomer.getField("Status", i));
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(0);
        }
        return stringBuilder.toString();
    }

    public void updateDateLastModified() {
    }

    public boolean isCompany(String string) {
        return drvCompany.getMatchingRecord("ID=\"" + string + "\"", 0) >= 0;
    }

    public void addNotification(TNotification tNotification) {
        if (!tNotification.IsValid) {
            return;
        }
        if (tNotification.Type == TNotification.NOTIFICATION_RECEIPT) {
            boolean bl = false;
            for (int i = 0; !bl && i < arPendingNotifications.size(); ++i) {
                TNotification tNotification2 = (TNotification)arPendingNotifications.get(i);
                if (!tNotification2.ID.equalsIgnoreCase(tNotification.ID) || !tNotification2.To.equalsIgnoreCase(tNotification.From)) continue;
                if (TNotification.DebugNotifications) {
                    MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server: Removed from queue: " + tNotification2.ID);
                }
                if (tNotification.isDiagnostic()) {
                    MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server+: Removed from queue: " + tNotification2.ID);
                }
                drvServerNotification.putField(DSRecNotificationDelivered, tNotification2.DiskIndex, (Object)Boolean.TRUE);
                drvServerNotification.putField(DSRecNotificationDeliveryConfirmed, tNotification2.DiskIndex, (Object)Boolean.TRUE);
                drvServerNotification.putField(DSRecNotificationDeliveryTime, tNotification2.DiskIndex, (Object)new Date());
                drvServerNotification.putField(DSRecNotificationDeliveryTimeLocal, tNotification2.DiskIndex, (Object)new Date());
                drvServerNotification.clearWriteBuffer();
                boolean bl2 = arPendingNotifications.remove(tNotification2);
                if (!bl2) {
                    if (TNotification.DebugNotifications) {
                        MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server: Could not remove pending notification: " + tNotification2.ID);
                    }
                    if (tNotification.isDiagnostic()) {
                        MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server+: Could not remove pending notification: " + tNotification2.ID);
                    }
                }
                if (TNotification.DebugNotifications) {
                    // empty if block
                }
                if (tNotification2.Type != TNotification.NOTIFICATION_DELIVERY_CONFIRMED && tNotification2.Type != TNotification.NOTIFICATION_PING) {
                    TNotification tNotification3 = new TNotification(tNotification2);
                    tNotification3.To = tNotification2.From;
                    tNotification3.From = tNotification2.To;
                    tNotification3.Type = TNotification.NOTIFICATION_DELIVERY_CONFIRMED;
                    tNotification3.Data = dateutil.formatDate(new Date(), "MMddyyyy HHmmss");
                    tNotification3.TimeToLive = 5;
                    tNotification3.AttachedFilename = "";
                    int n = drvServerNotification.initializeNewRecord(true);
                    drvServerNotification.putField(DSRecNotificationID, n, (Object)tNotification3.ID);
                    drvServerNotification.putField(DSRecNotificationFrom, n, (Object)tNotification3.From);
                    drvServerNotification.putField(DSRecNotificationTo, n, (Object)tNotification3.To);
                    drvServerNotification.putField(DSRecNotificationType, n, (Object)tNotification3.Type);
                    drvServerNotification.putField(DSRecNotificationTimeToLive, n, (Object)tNotification3.TimeToLive);
                    drvServerNotification.putField(DSRecNotificationIsOutgoing, n, (Object)Boolean.TRUE);
                    drvServerNotification.putField(DSRecNotificationParentID, n, (Object)tNotification3.ParentID);
                    tNotification3.DiskIndex = n;
                    if (TNotification.DebugNotifications) {
                        MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server: Creating " + tNotification3.toString());
                    }
                    if (tNotification3.isDiagnostic()) {
                        MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server+: Creating " + tNotification3.toString());
                    }
                    arPendingNotifications.add(tNotification3);
                }
                bl = true;
            }
            if (!bl) {
                if (TNotification.DebugNotifications) {
                    MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server: Notification not found for receipt: " + tNotification.toString());
                }
                if (tNotification.isDiagnostic()) {
                    MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server+: Notification not found for receipt: " + tNotification.toString());
                }
            }
        } else {
            int n;
            int n2;
            String string;
            CharSequence charSequence;
            int n3 = drvServerNotification.getMatchingRecord("ID=\"" + tNotification.ID + "\"", 0);
            if (n3 >= 0) {
                return;
            }
            TCustomerInfo tCustomerInfo = tNotification.From.equalsIgnoreCase("proxy") ? null : this.getCustomerInfo(tNotification.From);
            TCustomerInfo tCustomerInfo2 = this.getCustomerInfo(tNotification.To);
            if (tCustomerInfo != null) {
                tNotification.FromName = (String)drvCustomer.getField(DSRecCustomerName, tCustomerInfo.RecordIndex);
            }
            if (tCustomerInfo2 != null) {
                tNotification.ToName = (String)drvCustomer.getField(DSRecCustomerName, tCustomerInfo2.RecordIndex);
            }
            if (tNotification.Type == TNotification.NOTIFICATION_GET_RECIPIENT_LIST) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("5giaVJp4RHUYyuIZqOtT98Tc,Aspect Support\t");
                if (tCustomerInfo != null && (string = (String)drvCustomer.getField(DSRecCustomerCompanyID, tCustomerInfo.RecordIndex)).length() > 0) {
                    int n4 = drvCompany.getMatchingRecord("ID=\"" + string + "\"", 0);
                    if (n4 >= 0) {
                        String string2 = (String)drvCompany.getField(DSRecCompanyName, n4);
                        ((StringBuilder)charSequence).append(string + "," + string2 + " (Company)\t");
                    }
                    n2 = drvCustomer.getRecordCount();
                    for (n = 0; n < n2; ++n) {
                        if (!((Boolean)drvCustomer.getField(DSRecCustomerUsed, n)).booleanValue() || !((String)drvCustomer.getField(DSRecCustomerCompanyID, n)).equalsIgnoreCase(string)) continue;
                        ((StringBuilder)charSequence).append((String)drvCustomer.getField(DSRecCustomerHashID, n) + "," + (String)drvCustomer.getField(DSRecCustomerName, n) + "\t");
                    }
                }
                tNotification.Data = ((StringBuilder)charSequence).toString();
            }
            if (tNotification.Data.length() >= 1024) {
                tNotification.ExternalFilename = Application.getHomeDir() + "greenlight/notifications/" + TPasswordService.generateSalt(16) + ".$$$";
                TAsciiOutput.writeContent(tNotification.ExternalFilename, tNotification.Data);
                if (TNotification.DebugNotifications) {
                    MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server: Saved notification to file: " + tNotification.ID + " Filename=" + tNotification.ExternalFilename);
                }
                if (tNotification.isDiagnostic()) {
                    MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server+: Saved notification to file: " + tNotification.ID + " Filename=" + tNotification.ExternalFilename);
                }
            }
            charSequence = "";
            string = "";
            String string3 = "";
            n2 = charutil.boolval(charutil.getParamValue(tNotification.Data, "SendMail", '&'));
            if (TNotification.DebugNotifications) {
                MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server: SendMail=" + (n2 != 0));
            }
            if (n2 != 0) {
                string3 = charutil.getParamValue(tNotification.Data, "EmailBody", '&');
                charSequence = charutil.getParamValue(tNotification.Data, "Text", '&');
                if (((String)charSequence).length() == 0) {
                    charSequence = charutil.getParamValue(tNotification.Data, "AltText", '&');
                }
                charSequence = "<html><body>" + charutil.tokenizeSpecialChars((String)charSequence, false) + "</body></html>";
                string = charutil.getParamValue(tNotification.Data, "Subject", '&');
                if (string.length() == 0) {
                    string = "Aspect Notification";
                }
            }
            if ((n = drvCompany.getMatchingRecord("ID=\"" + tNotification.To + "\"", 0)) >= 0) {
                n3 = drvServerNotification.initializeNewRecord(true);
                drvServerNotification.putField(DSRecNotificationID, n3, (Object)tNotification.ID);
                drvServerNotification.putField(DSRecNotificationTime, n3, (Object)tNotification.Time);
                drvServerNotification.putField(DSRecNotificationServerTime, n3, (Object)tNotification.Server_Time);
                drvServerNotification.putField(DSRecNotificationFrom, n3, (Object)tNotification.From);
                drvServerNotification.putField(DSRecNotificationTo, n3, (Object)tNotification.From);
                drvServerNotification.putField(DSRecNotificationType, n3, (Object)tNotification.Type);
                drvServerNotification.putField(DSRecNotificationTimeToLive, n3, (Object)tNotification.TimeToLive);
                drvServerNotification.putField(DSRecNotificationData, n3, (Object)tNotification.Data);
                drvServerNotification.putField(DSRecNotificationReplyTo, n3, (Object)tNotification.From);
                drvServerNotification.putField(DSRecNotificationParentID, n3, (Object)tNotification.ParentID);
                drvServerNotification.putField(DSRecNotificationEncryptedPassword, n3, (Object)tNotification.EncryptedPassword);
                drvServerNotification.putField(DSRecNotificationExternalFilename, n3, (Object)tNotification.ExternalFilename);
                drvServerNotification.putField(DSRecNotificationAttachedFilename, n3, (Object)tNotification.AttachedFilename);
                drvServerNotification.putField(DSRecNotificationOriginalFilename, n3, (Object)tNotification.OriginalFilename);
                drvServerNotification.putField(DSRecNotificationDelivered, n3, (Object)true);
                drvServerNotification.putField(DSRecNotificationIsCompanyBreakout, n3, (Object)true);
                drvServerNotification.putField(DSRecNotificationIsOutgoing, n3, (Object)Boolean.TRUE);
                drvServerNotification.putField(DSRecNotificationBreakoutID, n3, (Object)tNotification.ID);
                int n5 = drvCustomer.getRecordCount();
                for (int i = 0; i < n5; ++i) {
                    if (!((Boolean)drvCustomer.getField(DSRecCustomerUsed, i)).booleanValue() || !((String)drvCustomer.getField(DSRecCustomerCompanyID, i)).equalsIgnoreCase(tNotification.To)) continue;
                    TNotification tNotification4 = new TNotification(tNotification);
                    tNotification4.ID = TPasswordService.generateSalt(16);
                    tNotification4.To = (String)drvCustomer.getField(DSRecCustomerHashID, i);
                    tNotification4.ToName = (String)drvCompany.getField(DSRecCompanyName, n);
                    tNotification4.ReplyTo = tNotification.From;
                    n3 = drvServerNotification.initializeNewRecord(true);
                    drvServerNotification.putField(DSRecNotificationID, n3, (Object)tNotification4.ID);
                    drvServerNotification.putField(DSRecNotificationTime, n3, (Object)tNotification.Time);
                    drvServerNotification.putField(DSRecNotificationServerTime, n3, (Object)tNotification.Server_Time);
                    drvServerNotification.putField(DSRecNotificationFrom, n3, (Object)tNotification4.From);
                    drvServerNotification.putField(DSRecNotificationTo, n3, (Object)tNotification4.To);
                    drvServerNotification.putField(DSRecNotificationType, n3, (Object)tNotification4.Type);
                    drvServerNotification.putField(DSRecNotificationIsOutgoing, n3, (Object)Boolean.TRUE);
                    drvServerNotification.putField(DSRecNotificationTimeToLive, n3, (Object)tNotification4.TimeToLive);
                    drvServerNotification.putField(DSRecNotificationData, n3, (Object)tNotification4.Data);
                    drvServerNotification.putField(DSRecNotificationReplyTo, n3, (Object)tNotification4.From);
                    drvServerNotification.putField(DSRecNotificationParentID, n3, (Object)tNotification4.ParentID);
                    drvServerNotification.putField(DSRecNotificationEncryptedPassword, n3, (Object)tNotification.EncryptedPassword);
                    drvServerNotification.putField(DSRecNotificationExternalFilename, n3, (Object)tNotification.ExternalFilename);
                    drvServerNotification.putField(DSRecNotificationAttachedFilename, n3, (Object)tNotification.AttachedFilename);
                    drvServerNotification.putField(DSRecNotificationOriginalFilename, n3, (Object)tNotification.OriginalFilename);
                    tNotification4.DiskIndex = n3;
                    tNotification4.isCompanyBreakout = true;
                    arPendingNotifications.add(tNotification4);
                    if (n2 == 0) continue;
                    TTransportRecord tTransportRecord = new TTransportRecord(null, "");
                    tTransportRecord.Description = "Aspect notification";
                    tTransportRecord.ID = tNotification.ID;
                    tTransportRecord.TransportMethod = 10;
                    tTransportRecord.Destination = "keith_mc@mindspring.com";
                    tTransportRecord.EmailSubject = string;
                    tTransportRecord.EmailBody = charSequence;
                    tTransportRecord.EmailBodyFileName = string3;
                    tTransportRecord.Source = "notifications@aspect-software.net";
                    TTransport.addTransport(tTransportRecord);
                }
            } else if (tCustomerInfo2 != null) {
                Object object;
                n3 = drvServerNotification.initializeNewRecord(true);
                drvServerNotification.putField(DSRecNotificationID, n3, (Object)tNotification.ID);
                drvServerNotification.putField(DSRecNotificationTime, n3, (Object)tNotification.Time);
                drvServerNotification.putField(DSRecNotificationServerTime, n3, (Object)tNotification.Server_Time);
                drvServerNotification.putField(DSRecNotificationFrom, n3, (Object)tNotification.From);
                drvServerNotification.putField(DSRecNotificationTo, n3, (Object)tNotification.To);
                drvServerNotification.putField(DSRecNotificationType, n3, (Object)tNotification.Type);
                drvServerNotification.putField(DSRecNotificationIsOutgoing, n3, (Object)Boolean.TRUE);
                drvServerNotification.putField(DSRecNotificationTimeToLive, n3, (Object)tNotification.TimeToLive);
                drvServerNotification.putField(DSRecNotificationData, n3, (Object)tNotification.Data);
                drvServerNotification.putField(DSRecNotificationReplyTo, n3, (Object)tNotification.ReplyTo);
                drvServerNotification.putField(DSRecNotificationParentID, n3, (Object)tNotification.ParentID);
                drvServerNotification.putField(DSRecNotificationEncryptedPassword, n3, (Object)tNotification.EncryptedPassword);
                drvServerNotification.putField(DSRecNotificationExternalFilename, n3, (Object)tNotification.ExternalFilename);
                drvServerNotification.putField(DSRecNotificationAttachedFilename, n3, (Object)tNotification.AttachedFilename);
                drvServerNotification.putField(DSRecNotificationOriginalFilename, n3, (Object)tNotification.OriginalFilename);
                tNotification.DiskIndex = n3;
                if (n2 != 0) {
                    object = new TTransportRecord(null, "");
                    ((TTransportRecord)object).Description = "Aspect notification";
                    ((TTransportRecord)object).ID = tNotification.ID;
                    ((TTransportRecord)object).TransportMethod = 10;
                    ((TTransportRecord)object).Destination = "keith_mc@mindspring.com";
                    ((TTransportRecord)object).EmailSubject = string;
                    ((TTransportRecord)object).EmailBody = charSequence;
                    ((TTransportRecord)object).EmailBodyFileName = string3;
                    ((TTransportRecord)object).Source = "notifications@aspect-software.net";
                    TTransport.addTransport((TTransportRecord)object);
                }
                if (!TFormulaEvaluator.isDirectSocketOpen(tNotification.To)) {
                    if (TNotification.DebugNotifications) {
                        MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server: Creating 'Recipient not available' notification to " + tNotification.From + " for " + tNotification.ID);
                    }
                    if (tNotification.isDiagnostic()) {
                        MainWin.appendToLog("TNofification_ServerSide", "addNotification", Thread.currentThread(), null, 3, "Notification Server+: Creating 'Recipient not available' notification to " + tNotification.From + " for " + tNotification.ID);
                    }
                    object = new TNotification(tNotification);
                    ((TNotification)object).ID = "NoCon-" + TPasswordService.generateSalt(10);
                    ((TNotification)object).From = Application.getAspectHashID();
                    ((TNotification)object).To = tNotification.From;
                    ((TNotification)object).Type = TNotification.NOTIFICATION_RECIPIENT_NOT_CONNECTED;
                    ((TNotification)object).Data = tNotification.ToName + " [" + tNotification.To + "] is not available.";
                    ((TNotification)object).TimeToLive = 5;
                    ((TNotification)object).AttachedFilename = "";
                    ((TNotification)object).ParentID = tNotification.ID;
                    if (tNotification.ParentID.length() > 0) {
                        ((TNotification)object).ParentID = tNotification.ParentID;
                    }
                    n3 = drvServerNotification.initializeNewRecord(true);
                    drvServerNotification.putField(DSRecNotificationID, n3, (Object)((TNotification)object).ID);
                    drvServerNotification.putField(DSRecNotificationTimeToLive, n3, (Object)((TNotification)object).TimeToLive);
                    drvServerNotification.putField(DSRecNotificationTime, n3, (Object)((TNotification)object).Time);
                    drvServerNotification.putField(DSRecNotificationServerTime, n3, (Object)((TNotification)object).Server_Time);
                    drvServerNotification.putField(DSRecNotificationFrom, n3, (Object)((TNotification)object).From);
                    drvServerNotification.putField(DSRecNotificationTo, n3, (Object)((TNotification)object).To);
                    drvServerNotification.putField(DSRecNotificationType, n3, (Object)((TNotification)object).Type);
                    drvServerNotification.putField(DSRecNotificationData, n3, (Object)((TNotification)object).Data);
                    drvServerNotification.putField(DSRecNotificationIsOutgoing, n3, (Object)Boolean.TRUE);
                    drvServerNotification.putField(DSRecNotificationReplyTo, n3, (Object)((TNotification)object).ReplyTo);
                    drvServerNotification.putField(DSRecNotificationParentID, n3, (Object)((TNotification)object).ParentID);
                    drvServerNotification.putField(DSRecNotificationEncryptedPassword, n3, (Object)((TNotification)object).EncryptedPassword);
                    drvServerNotification.putField(DSRecNotificationExternalFilename, n3, (Object)((TNotification)object).ExternalFilename);
                    drvServerNotification.putField(DSRecNotificationAttachedFilename, n3, (Object)((TNotification)object).AttachedFilename);
                    drvServerNotification.putField(DSRecNotificationOriginalFilename, n3, (Object)((TNotification)object).OriginalFilename);
                    ((TNotification)object).DiskIndex = n3;
                    arPendingNotifications.add(object);
                } else {
                    arPendingNotifications.add(tNotification);
                }
            } else {
                n3 = drvServerNotification.initializeNewRecord(true);
                TNotification tNotification5 = new TNotification(tNotification);
                tNotification5.ID = TPasswordService.generateSalt(16);
                tNotification5.To = tNotification.From;
                tNotification5.From = Application.getAspectHashID();
                tNotification5.Type = TNotification.NOTIFICATION_TEXT;
                tNotification5.Data = "Text=Invalid recipient: " + tNotification.To + ".  Could not be delivered";
                tNotification5.ReplyTo = tNotification.From;
                tNotification5.ParentID = tNotification.ID;
                drvServerNotification.putField(DSRecNotificationID, n3, (Object)tNotification5.ID);
                drvServerNotification.putField(DSRecNotificationTime, n3, (Object)tNotification5.Time);
                drvServerNotification.putField(DSRecNotificationServerTime, n3, (Object)tNotification5.Server_Time);
                drvServerNotification.putField(DSRecNotificationFrom, n3, (Object)tNotification5.From);
                drvServerNotification.putField(DSRecNotificationTo, n3, (Object)tNotification5.From);
                drvServerNotification.putField(DSRecNotificationType, n3, (Object)tNotification5.Type);
                drvServerNotification.putField(DSRecNotificationIsOutgoing, n3, (Object)Boolean.TRUE);
                drvServerNotification.putField(DSRecNotificationData, n3, (Object)tNotification5.Data);
                drvServerNotification.putField(DSRecNotificationReplyTo, n3, (Object)tNotification5.ReplyTo);
                drvServerNotification.putField(DSRecNotificationParentID, n3, (Object)tNotification5.ParentID);
                drvServerNotification.putField(DSRecNotificationEncryptedPassword, n3, (Object)tNotification5.EncryptedPassword);
                tNotification5.DiskIndex = n3;
                arPendingNotifications.add(tNotification5);
            }
            drvServerNotification.clearWriteBuffer();
        }
    }

    public int archiveNotifications() {
        int n = 0;
        long l = new Date().getTime();
        ArrayList<Date> arrayList = new ArrayList<Date>();
        int n2 = drvServerNotification.getRecordCount();
        for (int i = 0; i < n2; ++i) {
            Date date;
            if (!((Boolean)drvServerNotification.getField(DSRecNotificationUsed, i)).booleanValue() || arrayList.contains(date = (Date)drvServerNotification.getField(DSRecNotificationServerDate, i))) continue;
            arrayList.add(date);
        }
        TAppDriversObject tAppDriversObject = TNotification_ServerSide.Application.AppDrivers.getAppDriversObject("GreenLight_Notification_By_Filename");
        for (int i = 0; i < arrayList.size(); ++i) {
            Date date = (Date)arrayList.get(i);
            TAppDriversObject tAppDriversObject2 = new TAppDriversObject(tAppDriversObject);
            tAppDriversObject2.FileName.setLength(0);
            tAppDriversObject2.FileName.append(Application.getHomeDir() + "Greenlight/notifications/archive/server/server_notifications_" + dateutil.formatDate(date, "MMddyyyy") + ".dta");
            TBinaryFile tBinaryFile = new TBinaryFile(Application, tAppDriversObject2, 1, false);
            try {
                tBinaryFile.makeEditableFile();
                for (int j = 0; j < n2; ++j) {
                    if (!((Boolean)drvServerNotification.getField(DSRecNotificationUsed, j)).booleanValue() || ((Date)drvServerNotification.getField(DSRecNotificationServerDate, j)).getTime() != date.getTime() || !((Boolean)drvServerNotification.getField(DSRecNotificationDelivered, j)).booleanValue() && !((Boolean)drvServerNotification.getField(DSRecNotificationIsExpired, j)).booleanValue()) continue;
                    byte[] byArray = drvServerNotification.getRecord(j);
                    tBinaryFile.putRecord(tBinaryFile.initializeNewRecord(false), byArray);
                    drvServerNotification.putField(DSRecNotificationUsed, j, (Object)Boolean.FALSE);
                    ++n;
                }
                tBinaryFile.dispose();
                continue;
            }
            catch (Exception exception) {
                MainWin.appendToLog("TNofification_ServerSide", "archiveNotifications", Thread.currentThread(), null, 3, "Notification Server: Error archiving notifications: " + exception.toString());
            }
        }
        drvServerNotification.clearBuffer();
        arrayList.clear();
        return n;
    }

    public String dumpPendingNotifications() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th align='left'>ID</th>");
        stringBuilder.append("<th align='left'>Parent ID</th>");
        stringBuilder.append("<th align='left'>Time (MST)</th>");
        stringBuilder.append("<th align='left'>Type</th>");
        stringBuilder.append("<th align='left'>From</th>");
        stringBuilder.append("<th align='left'>To</th>");
        stringBuilder.append("<th align='left'>TTL</th>");
        stringBuilder.append("<th align='left'>Reply To</th>");
        stringBuilder.append("<th align='left'>Attached Filename</th>");
        stringBuilder.append("<th align='left'>Data</th>");
        stringBuilder.append("</tr>");
        for (int i = 0; i < arPendingNotifications.size(); ++i) {
            TNotification tNotification = (TNotification)arPendingNotifications.get(i);
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>" + tNotification.ID + "</td>");
            stringBuilder.append("<td>" + tNotification.ParentID + "</td>");
            stringBuilder.append("<td>" + dateutil.formatDate(tNotification.Server_Time, "MM-dd-yyyy HH:mm:ss") + "</td>");
            stringBuilder.append("<td>" + tNotification.getTypeName() + "</td>");
            stringBuilder.append("<td>" + tNotification.From + "</td>");
            stringBuilder.append("<td>" + tNotification.To + "</td>");
            stringBuilder.append("<td>" + tNotification.TimeToLive + "</td>");
            stringBuilder.append("<td>" + tNotification.ReplyTo + "</td>");
            stringBuilder.append("<td>" + tNotification.AttachedFilename + "</td>");
            String string = tNotification.Data;
            if (string.length() > 64) {
                string = string.substring(0, 64) + "...";
            }
            boolean bl = true;
            for (int j = 0; j < string.length(); ++j) {
                if ((byte)string.charAt(j) >= 0 && (byte)string.charAt(j) <= 127) continue;
                bl = false;
            }
            if (bl) {
                stringBuilder.append("<td>" + string + "</td>");
            } else {
                stringBuilder.append("<td>(Binary data)</td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private class TCustomerInfo {
        Date dtLastPing = new Date();
        int RecordIndex = -1;

        TCustomerInfo(int n) {
            this.RecordIndex = n;
        }
    }
}

