/*
 * Decompiled with CFR 0.152.
 */
package utility.security;

import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.util.ArrayList;
import java.util.Collections;

public class TIPAddressChecker {
    private static TIPAddressChecker instance = null;
    private static ArrayList arIPAddress = null;
    private static TAspectDriver FIPAddress = null;
    private static TDriverStructRecord DSRecAddress = null;
    private static TDriverStructRecord DSRecApproval = null;

    public TIPAddressChecker() {
        arIPAddress = new ArrayList();
        FIPAddress = new TAspectDriver("Aspect_Security_IP_Addresses", 1, true, false, "");
        FIPAddress.setActiveFilter("true", true);
        DSRecAddress = FIPAddress.getDriverStructRecord("IP_Address");
        DSRecApproval = FIPAddress.getDriverStructRecord("Approval");
    }

    public void reset() {
        FIPAddress.clearBuffer();
        arIPAddress.clear();
    }

    public void clearCache() {
        TIPAddressChecker.getInstance().reset();
    }

    public static TIPAddressChecker getInstance() {
        if (instance == null) {
            instance = new TIPAddressChecker();
        }
        return instance;
    }

    public TIPAddress findIPAddress(String string) {
        int n = -1;
        try {
            n = Collections.binarySearch(arIPAddress, new TIPAddress(string, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n >= 0) {
            return (TIPAddress)arIPAddress.get(n);
        }
        int n2 = FIPAddress.getRecordCount();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)FIPAddress.getField(DSRecAddress, i);
            if (!string2.equalsIgnoreCase(string)) continue;
            int n3 = (Integer)FIPAddress.getField(DSRecApproval, i);
            TIPAddress tIPAddress = new TIPAddress(string, n3);
            n = Collections.binarySearch(arIPAddress, tIPAddress);
            if (n < 0) {
                arIPAddress.add(Math.abs(n + 1), tIPAddress);
            }
            return tIPAddress;
        }
        return null;
    }

    public int getApproval(String string) {
        TIPAddress tIPAddress = this.findIPAddress(string);
        if (tIPAddress == null) {
            return -1;
        }
        return tIPAddress.Approval;
    }

    private class TIPAddress
    implements Comparable {
        String Address;
        int Approval;

        public TIPAddress(String string, int n) {
            this.Address = string;
            this.Approval = n;
        }

        public int compareTo(Object object) {
            int n = this.Address.compareToIgnoreCase(((TIPAddress)object).Address);
            return n;
        }
    }
}

