/*
 * Decompiled with CFR 0.152.
 */
package utility.taskscheduler;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Timer;
import resources.TAppActionObject;
import resources.TApplication;
import scripts.TExecScript;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.objectutil;
import utility.security.TPasswordService;
import utility.taskscheduler.TScheduledTask;
import utility.transport.TTransport;

public class TTaskScheduler
implements ActionListener {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTTaskScheduler");
    private static TApplication Application = TMainWin.Application;
    private String DriverID = "";
    public TAspectDriver AspectDriver = null;
    private ArrayList arTasks = new ArrayList();
    private boolean Enabled = false;
    private boolean ExecutingTasks = false;
    private long tmLastExecution = 0L;
    private String LastMessage = "Initialized";
    private Date dtInitialized = new Date();
    private String ID = TPasswordService.generateSalt(24);
    private Timer CallbackTimer = null;
    public static long tmLastCallbackTimerEvent = 0L;
    private int RequestLoadTasks = 0;
    private boolean RunExclusive = false;
    private static long cExecutingTasks = 0L;
    private static long TotalElapsedTime = 0L;
    private long cExecutingTasksThis = 0L;
    private long TotalElapsedTimeThis = 0L;
    private static Hashtable hashTaskScheduler = new Hashtable();
    boolean bProgramInitialized = false;

    public TTaskScheduler(String string, boolean bl, boolean bl2) {
        if (this.CallbackTimer == null) {
            this.CallbackTimer = new Timer(30000, this);
            this.CallbackTimer.start();
        } else {
            this.CallbackTimer.addActionListener(this);
        }
        this.DriverID = string;
        this.Enabled = bl;
        this.RunExclusive = bl2;
        this.AspectDriver = new TAspectDriver(this.DriverID, 1, true, false, "");
        this.AspectDriver.setActiveFilter("true", true);
        if (Debug) {
            System.out.println("TaskScheduler initialized.  ID=" + this.ID + " Driver=" + this.DriverID);
        }
        if (this.Enabled) {
            MainWin.appendToLog("TTaskScheduler", "init", Thread.currentThread(), null, 3, "Starting task scheduler (" + this.DriverID + ")");
            this.loadTasks();
        }
        hashTaskScheduler.put(this.ID, this);
    }

    public void dispose() {
        hashTaskScheduler.remove(this.ID);
        this.AspectDriver.dispose();
        this.CallbackTimer.removeActionListener(this);
        this.arTasks.clear();
        if (Debug) {
            System.out.println("TaskScheduler terminated.  ID=" + this.ID + " Driver=" + this.DriverID);
        }
    }

    public static String toHtmlStats() {
        StringBuilder stringBuilder = new StringBuilder();
        DateFormat dateFormat = DateFormat.getInstance();
        ((SimpleDateFormat)dateFormat).applyPattern("MM-dd-yyyy HH:mm:ss:SSS");
        int n = 0;
        int n2 = 0;
        long l = 0L;
        stringBuilder.append("<table>\n");
        stringBuilder.append("\t<tr><th align='left'>Driver</th><th align='left'>Enabled</th><th align='left'>Exclusive</th><th align='left'>Tasks</th><th align='left'>Loops</th><th align='left'>Avg Time (ms)</th><th align='left'>Last Execution</th><th align='left'>Last Message</th></tr>\n");
        Hashtable hashtable = TFormulaEvaluator.getTaskSchedulers();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            TTaskScheduler tTaskScheduler = (TTaskScheduler)hashtable.get(string);
            stringBuilder.append("\t<tr><td>" + tTaskScheduler.getDriverID() + "</td>");
            stringBuilder.append("\t<td>" + tTaskScheduler.isEnabled() + "</td>");
            stringBuilder.append("\t<td>" + tTaskScheduler.getRunExclusive() + "</td>");
            stringBuilder.append("\t<td align='right'>" + tTaskScheduler.arTasks.size() + "</td>");
            stringBuilder.append("\t<td align='right'>" + tTaskScheduler.getExecutionCount() + "</td>");
            stringBuilder.append("\t<td align='right'>" + tTaskScheduler.getAverageElapsedTime() + "</td>");
            stringBuilder.append("\t<td>" + dateFormat.format(tTaskScheduler.getLastExecutionTime()) + "</td>");
            stringBuilder.append("\t<td>" + tTaskScheduler.getLastMessage() + "</td></tr>\n");
            n += tTaskScheduler.arTasks.size();
            n2 = (int)((long)n2 + tTaskScheduler.getExecutionCount());
            l += tTaskScheduler.getTotalElapsedTime();
        }
        if (n2 > 0) {
            stringBuilder.append("\t<tr><td>Total</td>");
            stringBuilder.append("\t<td>&nbsp;</td>");
            stringBuilder.append("\t<td>&nbsp;</td>");
            stringBuilder.append("\t<td align='right'>" + n + "</td>");
            stringBuilder.append("\t<td align='right'>" + n2 + "</td>");
            stringBuilder.append("\t<td align='right'>" + (int)(l / (long)n2) + "</td>");
            stringBuilder.append("\t<td>&nbsp;</td>");
            stringBuilder.append("\t<td>&nbsp;</td></tr>\n");
        }
        stringBuilder.append("</table>\n");
        return stringBuilder.toString();
    }

    public long getExecutionCount() {
        return this.cExecutingTasksThis;
    }

    public long getTotalElapsedTime() {
        return this.TotalElapsedTimeThis;
    }

    public long getAverageElapsedTime() {
        if (this.cExecutingTasksThis == 0L) {
            return 0L;
        }
        return this.TotalElapsedTimeThis / this.cExecutingTasksThis;
    }

    public void setRunExclusive(boolean bl) {
        this.RunExclusive = bl;
    }

    public String getDriverID() {
        return this.DriverID;
    }

    public void setEnabled(boolean bl) {
        this.Enabled = bl;
        if (this.Enabled) {
            this.loadTasks();
        }
    }

    public boolean isEnabled() {
        return this.Enabled;
    }

    public String getLastMessage() {
        return this.LastMessage;
    }

    public Date getLastExecutionTime() {
        return new Date(this.tmLastExecution);
    }

    public boolean getRunExclusive() {
        return this.RunExclusive;
    }

    public String getEnabledTasks() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.AspectDriver.getAbsoluteRecordCount();
        for (int i = 0; i < n; ++i) {
            if (!((Boolean)this.AspectDriver.getFieldAbsolute("TaskEnabled", i)).booleanValue() || !((Boolean)this.AspectDriver.getFieldAbsolute("used", i)).booleanValue()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(Integer.toString(i));
        }
        return stringBuilder.toString();
    }

    public void setEnabledTasks(String string) {
        String[] stringArray = charutil.getSubStringArray(string, '|', true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.AspectDriver.putFieldAbsolute("TaskEnabled", charutil.ival(stringArray[i]), (Object)Boolean.TRUE);
            }
        }
    }

    public void getTaskInfo(TAspectDriver tAspectDriver) {
        for (int i = 0; i < this.arTasks.size(); ++i) {
            String string;
            TScheduledTask tScheduledTask = (TScheduledTask)this.arTasks.get(i);
            int n = tAspectDriver.initializeNewRecord();
            tAspectDriver.putFieldAbsolute("DriverID", n, (Object)this.DriverID);
            tAspectDriver.putFieldAbsolute("TaskName", n, (Object)tScheduledTask.getTaskName());
            tAspectDriver.putFieldAbsolute("Category1", n, (Object)tScheduledTask.getTaskCategory1());
            tAspectDriver.putFieldAbsolute("Category2", n, (Object)tScheduledTask.getTaskCategory2());
            tAspectDriver.putFieldAbsolute("TaskDescription", n, (Object)tScheduledTask.getTaskDescription());
            tAspectDriver.putFieldAbsolute("TaskEventType", n, (Object)tScheduledTask.getTaskEventType());
            tAspectDriver.putFieldAbsolute("TaskTarget", n, (Object)tScheduledTask.getTaskTarget());
            tAspectDriver.putFieldAbsolute("TaskParams", n, (Object)tScheduledTask.getTaskParams());
            tAspectDriver.putFieldAbsolute("TaskInitialStartTime", n, (Object)tScheduledTask.TaskInitialStartTime);
            tAspectDriver.putFieldAbsolute("TaskLastExecuted", n, (Object)tScheduledTask.getTaskLastExecuted());
            tAspectDriver.putFieldAbsolute("TaskNextExecution", n, (Object)tScheduledTask.getNextExecTime());
            tAspectDriver.putFieldAbsolute("TaskIntervalType", n, (Object)tScheduledTask.TaskIntervalType);
            tAspectDriver.putFieldAbsolute("TaskYearsBetweenExecution", n, (Object)tScheduledTask.TaskYearsBetweenExecution);
            tAspectDriver.putFieldAbsolute("TaskMonthsBetweenExecution", n, (Object)tScheduledTask.TaskMonthsBetweenExecution);
            tAspectDriver.putFieldAbsolute("TaskDaysBetweenExecution", n, (Object)tScheduledTask.TaskDaysBetweenExecution);
            tAspectDriver.putFieldAbsolute("TaskHoursBetweenExecution", n, (Object)tScheduledTask.TaskHoursBetweenExecution);
            tAspectDriver.putFieldAbsolute("TaskMinutesBetweenExecution", n, (Object)tScheduledTask.TaskMinutesBetweenExecution);
            tAspectDriver.putFieldAbsolute("TaskSecondsBetweenExecution", n, (Object)tScheduledTask.TaskSecondsBetweenExecution);
            tAspectDriver.putFieldAbsolute("TaskResult", n, (Object)tScheduledTask.TaskResult);
            tAspectDriver.putFieldAbsolute("TaskFinish_Time", n, (Object)tScheduledTask.TaskFinish_Time);
            tAspectDriver.putFieldAbsolute("TaskMessage", n, (Object)tScheduledTask.TaskMessage);
            tAspectDriver.putFieldAbsolute("TaskAltName", n, (Object)tScheduledTask.TaskAltName);
            tAspectDriver.putFieldAbsolute("TaskLast_State", n, (Object)tScheduledTask.TaskLast_State);
            tAspectDriver.putFieldAbsolute("TaskContent", n, (Object)tScheduledTask.TaskContent);
            tAspectDriver.putFieldAbsolute("TaskLast_Content_Update", n, (Object)tScheduledTask.TaskLast_Content_Update);
            tAspectDriver.putFieldAbsolute("TaskContent_Is_External", n, (Object)tScheduledTask.TaskContent_Is_External);
            if (tAspectDriver.DriverStruct.containsField("Post_To_Ftp_Host")) {
                tAspectDriver.putFieldAbsolute("Post_To_Ftp_Host", n, tScheduledTask.getField("Post_To_Ftp_Host"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_Ftp_Enabled")) {
                tAspectDriver.putFieldAbsolute("Post_To_Ftp_Enabled", n, tScheduledTask.getField("Post_To_Ftp_Enabled"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_Ftp_Filename")) {
                tAspectDriver.putFieldAbsolute("Post_To_Ftp_Filename", n, tScheduledTask.getField("Post_To_Ftp_Filename"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_Email_Enabled")) {
                tAspectDriver.putFieldAbsolute("Post_To_Email_Enabled", n, tScheduledTask.getField("Post_To_Email_Enabled"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_Email_AddressTo")) {
                tAspectDriver.putFieldAbsolute("Post_To_Email_AddressTo", n, tScheduledTask.getField("Post_To_Email_AddressTo"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_Email_AsAttachment")) {
                tAspectDriver.putFieldAbsolute("Post_To_Email_AsAttachment", n, tScheduledTask.getField("Post_To_Email_AsAttachment"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_Email_Body")) {
                tAspectDriver.putFieldAbsolute("Post_To_Email_Body", n, tScheduledTask.getField("Post_To_Email_Body"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_Email_Subject")) {
                tAspectDriver.putFieldAbsolute("Post_To_Email_Subject", n, tScheduledTask.getField("Post_To_Email_Subject"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_File_Enabled")) {
                tAspectDriver.putFieldAbsolute("Post_To_File_Enabled", n, tScheduledTask.getField("Post_To_File_Enabled"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_File_Filename")) {
                tAspectDriver.putFieldAbsolute("Post_To_File_Filename", n, tScheduledTask.getField("Post_To_File_Filename"));
            }
            if (tAspectDriver.DriverStruct.containsField("Post_To_File_Overwrite")) {
                tAspectDriver.putFieldAbsolute("Post_To_File_Overwrite", n, tScheduledTask.getField("Post_To_File_Overwrite"));
            }
            if (tAspectDriver.DriverStruct.containsField("TaskPost_To_Email_FileExt")) {
                tAspectDriver.putFieldAbsolute("TaskPost_To_Email_FileExt", n, tScheduledTask.getField("TaskPost_To_Email_FileExt"));
            }
            if (tAspectDriver.DriverStruct.containsField("TaskLast_State_Check")) {
                tAspectDriver.putFieldAbsolute("TaskLast_State_Check", n, tScheduledTask.getField("TaskLast_State_Check"));
            }
            if (tAspectDriver.DriverStruct.containsField("TaskLastResultMessage")) {
                tAspectDriver.putFieldAbsolute("TaskLastResultMessage", n, tScheduledTask.getField("TaskLastResultMessage"));
            }
            if (tAspectDriver.DriverStruct.containsField("TaskState_Expression_Description")) {
                tAspectDriver.putFieldAbsolute("TaskState_Expression_Description", n, tScheduledTask.getField("TaskState_Expression_Description"));
            }
            if (tAspectDriver.DriverStruct.containsField("TaskConditional_Expression_Description")) {
                tAspectDriver.putFieldAbsolute("TaskConditional_Expression_Description", n, tScheduledTask.getField("TaskConditional_Expression_Description"));
            }
            if (tAspectDriver.DriverStruct.containsField("Elapse_Time_Eval_Condition")) {
                tAspectDriver.putFieldAbsolute("Elapse_Time_Eval_Condition", n, tScheduledTask.getField("Elapse_Time_Eval_Condition"));
            }
            if (tAspectDriver.DriverStruct.containsField("Elapse_Time_Eval_State")) {
                tAspectDriver.putFieldAbsolute("Elapse_Time_Eval_State", n, tScheduledTask.getField("Elapse_Time_Eval_State"));
            }
            if (tAspectDriver.DriverStruct.containsField("Specific_Day_Of_Month")) {
                tAspectDriver.putFieldAbsolute("Specific_Day_Of_Month", n, tScheduledTask.getField("Specific_Day_Of_Month"));
            }
            if ((string = (String)tScheduledTask.getField("TaskConditional_Expression")) != null) {
                if (string.startsWith("=")) {
                    string = string.substring(1);
                }
                tAspectDriver.putFieldAbsolute("TaskConditional_Expression", n, (Object)string);
            }
            if ((string = (String)tScheduledTask.getField("TaskState_Function")) != null) {
                if (string.startsWith("=")) {
                    string = string.substring(1);
                }
                tAspectDriver.putFieldAbsolute("TaskState_Function", n, (Object)string);
            }
            if ((string = (String)tScheduledTask.getField("TaskExpression")) == null) continue;
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            tAspectDriver.putFieldAbsolute("TaskExpression", n, (Object)string);
        }
    }

    public String setTaskParams(String string, boolean bl, String string2) {
        int n;
        int n2 = this.AspectDriver.getAbsoluteRecordCount();
        for (n = 0; n < n2; ++n) {
            System.out.println(n + ": " + this.AspectDriver.getFieldAbsolute("TaskName", n) + " " + this.AspectDriver.getFieldAbsolute("TaskEnabled", n));
        }
        String string3 = "TaskName=\"" + string + "\"";
        int n3 = this.AspectDriver.getMatchingRecordAbsolute(string3, 0);
        System.out.println("setTaskParams: intRecord=" + n3 + " sFilter=" + string3);
        if (n3 < 0) {
            if (!bl) {
                String string4 = "Error in setTaskParams.  Task named " + string + " does not exist";
                System.out.println(string4);
                return string4;
            }
            n3 = this.AspectDriver.initializeNewRecord(this.AspectDriver.AppDriverObj.InsertMode, -1);
            this.AspectDriver.putFieldAbsolute("TaskName", n3, (Object)string);
            System.out.println("setTaskParams: created new task: intRecord=" + n3);
        }
        this.AspectDriver.putFieldAbsolute("used", n3, (Object)Boolean.TRUE);
        String[] stringArray = charutil.getSubStringArray(string2, ',', true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', true);
                if (stringArray2 == null || stringArray2.length <= 1) continue;
                String string5 = stringArray2[1];
                for (int j = 2; j < stringArray2.length; ++j) {
                    string5 = string5 + "=" + stringArray2[j];
                }
                TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStruct().getField(stringArray2[0]);
                if (tDriverStructRecord == null) {
                    object = "Invalid field in setTaskParams: " + stringArray2[0];
                    MainWin.appendToLog("TTaskScheduler", "setTaskParams", Thread.currentThread(), null, 4, (String)object);
                    continue;
                }
                System.out.println("Setting task field: " + tDriverStructRecord.ID + " = " + string5 + " r=" + n3);
                object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string5, -1);
                this.AspectDriver.putFieldAbsolute(stringArray2[0], n3, object);
            }
        }
        this.AspectDriver.clearWriteBuffer();
        System.out.println("setTaskParams: TaskEnabled=" + this.AspectDriver.getFieldAbsolute("TaskEnabled", n3));
        n2 = this.AspectDriver.getAbsoluteRecordCount();
        for (n = 0; n < n2; ++n) {
            System.out.println(n + ": " + this.AspectDriver.getFieldAbsolute("TaskName", n) + " " + this.AspectDriver.getFieldAbsolute("TaskEnabled", n));
        }
        this.loadTasks();
        return "ok";
    }

    public TScheduledTask getTask(String string) {
        for (int i = 0; i < this.arTasks.size(); ++i) {
            TScheduledTask tScheduledTask = (TScheduledTask)this.arTasks.get(i);
            if (!tScheduledTask.getTaskName().equalsIgnoreCase(string)) continue;
            return tScheduledTask;
        }
        return null;
    }

    public String getTaskTooltip(String string) {
        int n = this.AspectDriver.getMatchingRecordAbsolute("TaskName=\"" + string + "\"", 0);
        if (n < 0) {
            String string2 = "Error in getTaskTooltip.  Task named '" + string + "' not found'";
            MainWin.appendToLog("TTaskScheduler", "getTaskTooltip", Thread.currentThread(), null, 4, string2);
            return "";
        }
        String string3 = (String)this.AspectDriver.getFieldAbsolute("TaskExpression", n);
        String string4 = (String)this.AspectDriver.getFieldAbsolute("TaskState_Function", n);
        String string5 = (String)this.AspectDriver.getFieldAbsolute("TaskConditional_Expression", n);
        String string6 = (String)this.AspectDriver.getFieldAbsolute("tooltipWithToken", n);
        if (string6 == null) {
            return "";
        }
        if (string3.startsWith("=")) {
            string3 = string3.substring(1);
        }
        if (string4.startsWith("=")) {
            string4 = string4.substring(1);
        }
        if (string5.startsWith("=")) {
            string5 = string5.substring(1);
        }
        string3 = charutil.replaceAllSubstrings(string3, "<", "#60");
        string4 = charutil.replaceAllSubstrings(string4, "<", "#60");
        string5 = charutil.replaceAllSubstrings(string5, "<", "#60");
        string3 = charutil.replaceAllSubstrings(string3, ">", "#62");
        string4 = charutil.replaceAllSubstrings(string4, ">", "#62");
        string5 = charutil.replaceAllSubstrings(string5, ">", "#62");
        string6 = charutil.replaceSubstring(string6, "~TaskState_Function~", string4);
        string6 = charutil.replaceSubstring(string6, "~TaskExpression~", string3);
        string6 = charutil.replaceSubstring(string6, "~TaskConditional_Expression~", string5);
        return string6;
    }

    public boolean isTaskDefined(String string) {
        return this.getTask(string) != null;
    }

    public boolean isTaskEnabled(String string) {
        for (int i = 0; i < this.arTasks.size(); ++i) {
            TScheduledTask tScheduledTask = (TScheduledTask)this.arTasks.get(i);
            if (!tScheduledTask.getTaskName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String enableTask(String string, boolean bl) {
        int n = this.AspectDriver.getMatchingRecordAbsolute("TaskName=\"" + string + "\"", 0);
        if (n < 0) {
            String string2 = "Error in enableTask.  Task named '" + string + "' not found'";
            MainWin.appendToLog("TTaskScheduler", "enableTask", Thread.currentThread(), null, 4, string2);
            return string2;
        }
        this.AspectDriver.putFieldAbsolute("TaskEnabled", n, (Object)bl);
        this.loadTasks();
        return "ok";
    }

    public String execTask(String string) {
        TScheduledTask tScheduledTask = this.getTask(string);
        if (tScheduledTask == null) {
            String string2 = "Error in execTask.  Task not found: " + string;
            MainWin.appendToLog("TTaskScheduler", "recordTaskResult", Thread.currentThread(), null, 4, string2);
            return string2;
        }
        TExecTaskThread tExecTaskThread = new TExecTaskThread(tScheduledTask, true);
        tExecTaskThread.start();
        if (this.DriverID.equalsIgnoreCase("Aspect_File_Set")) {
            Application.setTokenValue("FileSetTaskExecuted", Long.toString(new Date().getTime()));
        }
        return "ok";
    }

    public String getTaskContent(String string) {
        TScheduledTask tScheduledTask = this.getTask(string);
        if (tScheduledTask == null) {
            return null;
        }
        String string2 = tScheduledTask.stateChanged();
        if (string2 != null) {
            tScheduledTask.setTaskLast_State(string2);
            TExecTaskThread tExecTaskThread = new TExecTaskThread(tScheduledTask, true);
            tExecTaskThread.start();
            while (tExecTaskThread.isAlive()) {
                Thread.yield();
                if (!(Math.random() < 0.1)) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        }
        return tScheduledTask.getTaskContent();
    }

    public void loadTasks() {
        MainWin.appendToLog("TTaskScheduler", "processloadTasksRequest", Thread.currentThread(), null, 3, "TTaskScheduler:" + this.DriverID + " loadTasks requested");
        ++this.RequestLoadTasks;
    }

    public void processloadTasksRequest() {
        MainWin.appendToLog("TTaskScheduler", "processloadTasksRequest", Thread.currentThread(), null, 3, "TTaskScheduler:" + this.DriverID + " processloadTasksRequest started. RequestLoadTasks=" + this.RequestLoadTasks);
        int n = this.RequestLoadTasks;
        try {
            TScheduledTask tScheduledTask;
            int n2;
            Hashtable<String, TScheduledTask> hashtable = new Hashtable<String, TScheduledTask>();
            for (n2 = 0; n2 < this.arTasks.size(); ++n2) {
                tScheduledTask = (TScheduledTask)this.arTasks.get(n2);
                hashtable.put(tScheduledTask.getTaskName().toUpperCase(), tScheduledTask);
            }
            this.AspectDriver.clearBuffer();
            this.AspectDriver.setActiveFilter("true", true);
            this.arTasks.clear();
            for (n2 = 0; n2 < this.AspectDriver.getRecordCount(); ++n2) {
                tScheduledTask = new TScheduledTask(this.AspectDriver.F, this.AspectDriver.getAbsoluteDiskIndex(n2));
                if (!tScheduledTask.getIsEnabled()) continue;
                if (hashtable.containsKey(tScheduledTask.getTaskName().toUpperCase())) {
                    TScheduledTask tScheduledTask2 = (TScheduledTask)hashtable.get(tScheduledTask.getTaskName().toUpperCase());
                    tScheduledTask.TaskNextExecution = tScheduledTask2.TaskNextExecution;
                }
                this.arTasks.add(tScheduledTask);
            }
        }
        catch (Exception exception) {
            MainWin.appendToLog("TTaskScheduler", "processloadTasksRequest", Thread.currentThread(), null, 3, "TTaskScheduler:" + this.DriverID + " processloadTasksRequest " + exception.toString());
            exception.printStackTrace();
        }
        this.RequestLoadTasks = this.RequestLoadTasks == n ? 0 : 1;
        MainWin.appendToLog("TTaskScheduler", "processloadTasksRequest", Thread.currentThread(), null, 3, "TTaskScheduler:" + this.DriverID + " processloadTasksRequest complete. RequestLoadTasks=" + this.RequestLoadTasks);
    }

    public boolean recordResult(String string, int n, String string2, String string3) {
        int n2 = this.AspectDriver.getMatchingRecordAbsolute("TaskName=\"" + string + "\"", 0);
        if (n2 < 0) {
            MainWin.appendToLog("TTaskScheduler", "recordTaskResult", Thread.currentThread(), null, 4, "Invalid task name in recordTaskResult: " + string);
            return false;
        }
        TScheduledTask tScheduledTask = null;
        for (int i = 0; i < this.arTasks.size(); ++i) {
            TScheduledTask tScheduledTask2 = (TScheduledTask)this.arTasks.get(i);
            if (!tScheduledTask2.TaskName.equalsIgnoreCase(string)) continue;
            tScheduledTask = tScheduledTask2;
        }
        if (tScheduledTask == null) {
            System.out.println("Cannot locate task named " + string + " in recordResult()");
            return false;
        }
        Date date = new Date();
        tScheduledTask.setTaskResult(n);
        tScheduledTask.setTaskFinish_Time(date);
        tScheduledTask.setTaskMessage(string2);
        if (string3 != null && this.AspectDriver.isFieldDefined("TaskContent")) {
            tScheduledTask.setTaskContent(string3);
            tScheduledTask.setTaskLast_Content_Update(date);
            tScheduledTask.setTaskLast_State(tScheduledTask.getCurrentState());
            tScheduledTask.setTaskLastResultMessage(string2);
            tScheduledTask.executeTransport();
        }
        return true;
    }

    public static TTaskScheduler getTaskScheduler(String string) {
        return (TTaskScheduler)hashTaskScheduler.get(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (!this.bProgramInitialized) {
            if (TMainWin.Application.getTokenValue("AspectCommonCachedWidgetsComplete").equalsIgnoreCase("yes")) {
                this.bProgramInitialized = true;
            } else {
                return;
            }
        }
        tmLastCallbackTimerEvent = new Date().getTime();
        if (this.DriverID.equalsIgnoreCase("TaskScheduler")) {
            if (MainWin.isRunningOnServer()) {
                object = new TFormulaEvaluator().testNotificationServer();
            }
            object = new TFormulaEvaluator().testNotificationClient();
        }
        if (this.ExecutingTasks) {
            this.LastMessage = "Already executing tasks";
            return;
        }
        this.ExecutingTasks = true;
        if (Debug) {
            System.out.println("TaskScheduler executing.  ID=" + this.ID + " Driver=" + this.DriverID);
        }
        if (!this.Enabled) {
            this.LastMessage = "Not enabled";
            this.ExecutingTasks = false;
            return;
        }
        this.tmLastExecution = new Date().getTime();
        if (this.RequestLoadTasks > 0) {
            this.processloadTasksRequest();
        }
        if (this.arTasks.size() == 0) {
            if (Debug) {
                MainWin.appendToLog("TTaskScheduler", "actionPerformed", Thread.currentThread(), null, 10, "There are no tasks enabled for execution by the task scheduler (" + this.DriverID + ")");
            }
            this.LastMessage = "No tasks to execute";
            this.ExecutingTasks = false;
            return;
        }
        if (Thread.activeCount() >= 25) {
            MainWin.appendToLog("TTaskScheduler", "actionPerformed", Thread.currentThread(), null, 3, "TTaskScheduler:" + this.DriverID + " actionPerformed aborting because threads exceed 30");
            System.out.println("Not dumping state");
            this.LastMessage = "Too many threads: " + Integer.toString(Thread.activeCount());
            this.ExecutingTasks = false;
            return;
        }
        this.LastMessage = "Executing tasks";
        object = new Thread(){

            @Override
            public void run() {
                Date date = new Date();
                for (int i = 0; i < TTaskScheduler.this.arTasks.size(); ++i) {
                    if (Thread.activeCount() <= 25) {
                        Object object;
                        TScheduledTask tScheduledTask = (TScheduledTask)TTaskScheduler.this.arTasks.get(i);
                        if (!tScheduledTask.shouldExecute()) continue;
                        int n = MainWin.MultipleInstanceCheck.getListeningOnPort();
                        String string = MainWin.MultipleInstanceCheck.sendLocalMessage("=isTaskSchedulerEnabled()", true, 100, false);
                        if (string.length() > 0 && (object = charutil.getSubStringArray(string, '|', true)) != null) {
                            for (int j = 0; j < ((String[])object).length; ++j) {
                                int n2 = charutil.ival((String)object[j]);
                                if (n2 <= 0 || n2 >= n) continue;
                                TTaskScheduler.this.loadTasks();
                                TTaskScheduler.this.ExecutingTasks = false;
                                TTaskScheduler.this.LastMessage = "Deferring to another instance";
                                return;
                            }
                        }
                        TFormulaEvaluator.waitForThreadCount();
                        object = new TExecTaskThread(tScheduledTask, false);
                        ((Thread)object).start();
                        if (TTaskScheduler.this.RunExclusive) {
                            TTaskScheduler.this.LastMessage = "Waiting for exclusive task to complete";
                            while (((Thread)object).isAlive()) {
                                Thread.yield();
                                if (!(Math.random() < 0.1)) continue;
                                try {
                                    Thread.sleep(1L);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (!TTaskScheduler.this.DriverID.equalsIgnoreCase("Aspect_File_Set")) continue;
                        Application.setTokenValue("FileSetTaskExecuted", Long.toString(new Date().getTime()));
                        continue;
                    }
                    MainWin.appendToLog("TTaskScheduler", "actionPerformed", Thread.currentThread(), null, 10, "Skipping scheduled task because thread count is exceeded.  Count=" + Thread.activeCount());
                }
                cExecutingTasks++;
                TTaskScheduler.this.cExecutingTasksThis++;
                long l = new Date().getTime() - date.getTime();
                TotalElapsedTime += l;
                TTaskScheduler.this.TotalElapsedTimeThis += l;
                Application.setTokenValue("TaskSchedulerActionPerformedCount", Long.toString(cExecutingTasks));
                Application.setTokenValue("TaskSchedulerActionPerformedAverageTime", Long.toString(TotalElapsedTime / cExecutingTasks));
                TTaskScheduler.this.LastMessage = "Executing tasks complete.";
                TTaskScheduler.this.ExecutingTasks = false;
            }
        };
        this.LastMessage = "Starting thread to execute tasks";
        ((Thread)object).setPriority(1);
        ((Thread)object).setName("ExecTasks-" + this.DriverID);
        ((Thread)object).start();
    }

    class TExecTaskThread
    extends Thread {
        TScheduledTask ScheduledTask;
        boolean ManualExec;
        Date tmStart;

        public TExecTaskThread(TScheduledTask tScheduledTask, boolean bl) {
            super("Task_" + tScheduledTask.getDriverID() + "-" + tScheduledTask.getTaskName());
            this.tmStart = new Date();
            this.ScheduledTask = tScheduledTask;
            this.ScheduledTask.setTaskLastExecuted(new Date());
            this.ManualExec = bl;
            if (!this.ManualExec) {
                this.ScheduledTask.setNextExecTime();
            }
            this.setPriority(1);
        }

        @Override
        public void run() {
            Date date = new Date();
            long l = TExecScript.getNewScriptInstance();
            MainWin.appendToLog("TTaskScheduler", "run", Thread.currentThread(), null, 13, this.ScheduledTask.getTaskName(), TTaskScheduler.this.DriverID, this.ScheduledTask.getTaskName(), 1, this.ManualExec, 0L, l);
            if (this.ScheduledTask.getTaskEventType() == 0) {
                TAppActionObject tAppActionObject = Application.AppAction.getAppActionObject(this.ScheduledTask.getTaskTarget());
                MainWin.executeActionObject(tAppActionObject.ActionObject, null);
                MainWin.appendToLog("TTaskScheduler", "run", Thread.currentThread(), null, 14, this.ScheduledTask.getTaskName(), TTaskScheduler.this.DriverID, this.ScheduledTask.getTaskName(), 1, this.ManualExec, new Date().getTime() - this.tmStart.getTime(), l);
            } else if (this.ScheduledTask.getTaskEventType() == 1) {
                if (Application.AppScripts.isResourceDefined(this.ScheduledTask.getTaskTarget())) {
                    TExecScript tExecScript = new TExecScript(this.ScheduledTask.getTaskTarget(), null, null);
                    String string = this.ScheduledTask.getTaskParams();
                    if (string.length() > 0) {
                        tExecScript.setParameters(string);
                    }
                    tExecScript.setScheduledTask(TTaskScheduler.this.ID, this.ScheduledTask.getTaskName(), this.ManualExec, l);
                    tExecScript.start();
                    if (TTaskScheduler.this.RunExclusive) {
                        while (tExecScript.isAlive()) {
                            Thread.yield();
                            if (!(Math.random() < 0.1)) continue;
                            try {
                                Thread.sleep(1L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    MainWin.appendToLog("TTaskScheduler", "run", Thread.currentThread(), null, 14, this.ScheduledTask.getTaskName(), TTaskScheduler.this.DriverID, this.ScheduledTask.getTaskName(), 1, this.ManualExec, new Date().getTime() - this.tmStart.getTime(), l);
                } else {
                    MainWin.appendToLog("TTaskScheduler", "init", Thread.currentThread(), null, 4, "Invalid script \"" + this.ScheduledTask.getTaskTarget() + "\" while executing task " + this.ScheduledTask.getTaskName() + " in driver " + TTaskScheduler.this.DriverID);
                }
            } else if (this.ScheduledTask.getTaskEventType() == 2) {
                TTransport.execTransport(this.ScheduledTask.getTaskTarget(), this.ScheduledTask.getTaskParams());
                MainWin.appendToLog("TTaskScheduler", "run", Thread.currentThread(), null, 14, this.ScheduledTask.getTaskName(), TTaskScheduler.this.DriverID, this.ScheduledTask.getTaskName(), 1, this.ManualExec, new Date().getTime() - this.tmStart.getTime(), l);
            } else if (this.ScheduledTask.getTaskEventType() == 3) {
                MainWin;
                String string = TMainWin.Application.parse_tokens(this.ScheduledTask.getTaskExpression());
                TFormulaEvaluator tFormulaEvaluator = new TFormulaEvaluator();
                tFormulaEvaluator.TaskSchedulerID = TTaskScheduler.this.DriverID;
                tFormulaEvaluator.TaskSchedulerTaskName = this.ScheduledTask.getTaskName();
                string = TFormulaEvaluator.convertToString(tFormulaEvaluator.getFormulaValue(string, -1, -1));
                Date date2 = new Date();
                this.ScheduledTask.setTaskResult(1);
                this.ScheduledTask.setTaskFinish_Time(date2);
                String string2 = "Updated content";
                this.ScheduledTask.setTaskMessage(string2);
                MainWin.appendToLog("TTaskScheduler", "run", Thread.currentThread(), null, 14, this.ScheduledTask.getTaskName() + ":" + string, TTaskScheduler.this.DriverID, this.ScheduledTask.getTaskName(), 1, this.ManualExec, new Date().getTime() - this.tmStart.getTime(), l);
                if (string != null && TTaskScheduler.this.AspectDriver.isFieldDefined("TaskContent")) {
                    this.ScheduledTask.setTaskContent(string);
                    this.ScheduledTask.setTaskLast_Content_Update(date2);
                    this.ScheduledTask.setTaskLast_State(this.ScheduledTask.getCurrentState());
                    if (string.length() < 128) {
                        this.ScheduledTask.setTaskLastResultMessage(string);
                    } else {
                        this.ScheduledTask.setTaskLastResultMessage("Executed.");
                    }
                    this.ScheduledTask.executeTransport();
                }
            }
        }
    }
}

