/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.charset;

import com.sybase.jdbcx.CharsetConverter;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;

public class TruncationConverter
implements CharsetConverter {
    private static final short SEVEN_BITS = 127;
    private static final short EIGHT_BITS = 255;
    private short _mask = (short)127;

    @Override
    public void setEncoding(String string) throws UnsupportedEncodingException {
        this._mask = string.equals("ISO8859_1") ? (short)255 : (short)127;
    }

    @Override
    public byte[] fromUnicode(String string) throws CharConversionException {
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            short s = (short)string.charAt(i);
            if ((s & this._mask) != s) {
                throw new CharConversionException(String.valueOf(string.charAt(i)));
            }
            byArray[i] = (byte)(s & this._mask);
        }
        return byArray;
    }

    @Override
    public String toUnicode(byte[] byArray) throws CharConversionException {
        return new String(byArray, 0);
    }
}

