/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobClientInputStream;
import com.sybase.jdbc4.jdbc.LobClientOutputStream;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.utils.HexConverts;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybBinaryClientLob
extends SybLob
implements Blob {
    private static Logger LOG = Logger.getLogger(SybBinaryClientLob.class.getName());
    private static volatile long _logIdCounter = 0L;
    private byte[] data;

    public SybBinaryClientLob(String string, ProtocolContext protocolContext, byte[] byArray) throws SQLException {
        this._logId = string + "_Bc" + _logIdCounter++;
        this.data = byArray;
        this._lobType = SybLob.LOB_TYPE.IMAGE;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getBinaryStream()");
        }
        this.checkClientLOBValidity();
        return new BufferedInputStream(new LobClientInputStream(this, 1L, this.length()), 16384);
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBinaryStream(long = [" + l + "], long = [" + l2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBinaryStream(long, long)");
            }
        }
        this.checkClientLOBValidity();
        long l3 = this.length();
        if (l < 1L || l > l3 || l + l2 > l3 + 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedInputStream(new LobClientInputStream(this, l, l2), 16384);
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getBytes()");
        }
        this.checkClientLOBValidity();
        return this.data;
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBytes(long = [" + l + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBytes(long, int)");
            }
        }
        this.checkClientLOBValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        } else if (n < 0) {
            ErrorMessage.raiseError("JZ038");
        }
        long l2 = this.length();
        if (this.data == null || l > l2) {
            return null;
        }
        if (n == 0) {
            return new byte[0];
        }
        if (l + (long)n - 1L > l2) {
            n = (int)(l2 - l + 1L);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, (int)l - 1, byArray, 0, n);
        return byArray;
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " position", new Object[]{byArray, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " position", new Object[]{byArray, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " position(byte[], long)");
            }
        }
        this.checkClientLOBValidity();
        int n = (int)this.indexOf(this.getBytes(l, (int)((long)this.data.length - l)), byArray);
        return n == -1 ? (long)n : (long)n + l;
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " position", new Object[]{blob, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " position(Blob, long)");
            }
        }
        this.checkClientLOBValidity();
        return this.position(((SybBinaryClientLob)blob).getBytes(), l);
    }

    @Override
    public long length() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " length()");
        }
        this.checkClientLOBValidity();
        if (this.data == null) {
            return 0L;
        }
        return this.data.length;
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBytes", new Object[]{l, byArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBytes", new Object[]{l, byArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBytes(long, byte[])");
            }
        }
        this.checkClientLOBValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        if (byArray != null) {
            long l2 = this.length();
            if (l > l2 + 1L) {
                ErrorMessage.raiseError("JZ037");
            }
            if (l2 > l + (long)byArray.length) {
                for (int i = 0; i < byArray.length; ++i) {
                    this.data[i + (int)l - 1] = byArray[i];
                }
            } else {
                byte[] byArray2 = new byte[(int)(l + (long)byArray.length - 1L)];
                if (l2 > 0L) {
                    System.arraycopy(this.data, 0, byArray2, 0, (int)(l - 1L));
                }
                if (byArray.length > 0) {
                    System.arraycopy(byArray, 0, byArray2, (int)l - 1, byArray.length);
                }
                this.data = byArray2;
            }
            return byArray.length;
        }
        return 0;
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, "setBytes", new Object[]{l, byArray, n, n2}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "setBytes", new Object[]{l, byArray, n, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBytes(long, byte[], int, int)");
            }
        }
        this.checkClientLOBValidity();
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n - 1, byArray2, 0, n2);
            return this.setBytes(l, byArray2);
        }
        return 0;
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setBinaryStream(long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBinaryStream(long)");
            }
        }
        this.checkClientLOBValidity();
        if (l < 1L || l > this.length()) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedOutputStream(new LobClientOutputStream(this, l), 16384);
    }

    @Override
    public String getString() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getString()");
        }
        this.checkClientLOBValidity();
        if (this.data != null) {
            return HexConverts.hexConvert(this.data);
        }
        return null;
    }

    @Override
    public void free() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " free()");
        }
        if (!this._freeCalled) {
            this.data = null;
            this._freeCalled = true;
        }
    }

    @Override
    public void truncate(long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " truncate(long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " truncate(long)");
            }
        }
        this.checkClientLOBValidity();
        if (l < 0L) {
            ErrorMessage.raiseError("JZ038");
        }
        if (this.data == null) {
            ErrorMessage.raiseError("JZ036");
        } else {
            byte[] byArray = new byte[(int)l];
            System.arraycopy(this.data, 0, byArray, 0, (int)l);
            this.data = byArray;
        }
    }

    private void checkClientLOBValidity() throws SQLException {
        if (this._freeCalled) {
            ErrorMessage.raiseError("JZ036");
        }
    }

    public long indexOf(byte[] byArray, byte[] byArray2) {
        int[] nArray = this.computeFailure(byArray2);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            while (n > 0 && byArray2[n] != byArray[i]) {
                n = nArray[n - 1];
            }
            if (byArray2[n] == byArray[i]) {
                ++n;
            }
            if (n != byArray2.length) continue;
            return i - byArray2.length + 1;
        }
        return -1L;
    }

    private int[] computeFailure(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        for (int i = 1; i < byArray.length; ++i) {
            while (n > 0 && byArray[n] != byArray[i]) {
                n = nArray[n - 1];
            }
            if (byArray[n] == byArray[i]) {
                // empty if block
            }
            nArray[i] = ++n;
        }
        return nArray;
    }
}

