/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.JdbcDataObject;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.utils.CacheManager;
import com.sybase.jdbc4.utils.Cacheable;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.LogUtil;
import com.sybase.jdbcx.TextPointer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybResultSet
implements com.sybase.jdbcx.SybResultSet,
Cacheable {
    private static Logger LOG = Logger.getLogger(SybResultSet.class.getName());
    protected String _logId = null;
    private static volatile long _logIdCounter = 0L;
    protected static final int BEFORE_FIRST = -1;
    protected static final int AFTER_LAST = -2;
    protected static final int INSERT_ROW = -3;
    protected static final int UNDEFINED = -4;
    protected ProtocolResultSet _prs;
    protected JdbcDataObject _currentColumn;
    protected SybStatement _statement;
    protected ProtocolContext _pc = null;
    protected IConstants.CONNECTION_STATE _state = IConstants.CONNECTION_STATE.BUSY;
    private Hashtable _nameToColumn = null;
    private Hashtable _labelToColumn = null;
    protected CacheManager _cm;
    protected int _rowIndex;
    protected int _lastRowIndex = -4;
    protected int _concurType = 1007;
    protected String _concurTypeString = "CONCUR_READ_ONLY";
    protected int _scrollType = 1003;
    protected int _fetchSize = 0;
    protected int _fetchDirection = 1000;
    protected boolean _usedForParams = false;
    protected SQLWarning _savedWarnings = null;
    protected int _currentStatus = 1;

    public SybResultSet(String string, SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        this._logId = string + "_Rs" + _logIdCounter++;
        this._statement = sybStatement;
        this._prs = protocolResultSet;
        this._rowIndex = -1;
        if (this._prs != null) {
            this._scrollType = this._prs.getType();
        }
        if (this._statement != null) {
            this._pc = this._statement._context;
        }
    }

    public SybResultSet(String string, ProtocolResultSet protocolResultSet, ProtocolContext protocolContext) throws SQLException {
        this._logId = string + "_Rs" + _logIdCounter++;
        this._prs = protocolResultSet;
        this._rowIndex = -1;
        if (this._prs != null) {
            this._scrollType = this._prs.getType();
        }
        this._pc = protocolContext;
    }

    protected String getLogIdName() {
        return "Rs";
    }

    @Override
    public boolean next() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " next()");
        }
        this.checkResultSet();
        this.clearWarnings();
        this.moveToCurrentRow();
        if (this.checkRowIndexBeforeProtocolNext()) {
            return false;
        }
        boolean bl = this._prs.next();
        if (!bl) {
            if (this._statement != null && this._prs != null) {
                this._statement.setRowCount(this._prs.getCount());
            }
            this.adjustRowIndexesAfterProtocolNext();
        }
        this._currentColumn = null;
        return bl;
    }

    protected boolean checkRowIndexBeforeProtocolNext() {
        boolean bl = false;
        switch (this._rowIndex) {
            case -2: {
                bl = true;
                break;
            }
            case -1: {
                this._rowIndex = 1;
                break;
            }
            default: {
                if (this._rowIndex <= 0) break;
                ++this._rowIndex;
            }
        }
        return bl;
    }

    protected void adjustRowIndexesAfterProtocolNext() {
        if (this._rowIndex == 1) {
            this._lastRowIndex = 0;
            this._rowIndex = -1;
        } else {
            this._lastRowIndex = this._rowIndex - 1;
            this._rowIndex = -2;
        }
    }

    @Override
    public void close() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " close()");
        }
        this.close(false);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " wasNull()");
        }
        this.checkResultSet();
        if (this._currentColumn == null) {
            ErrorMessage.raiseError("JZ0NC");
        }
        return this._currentColumn.isNull();
    }

    @Override
    public String getString(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getString(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getString(int)");
            }
        }
        return this.getColumn(n).getString();
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBoolean(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBoolean(int)");
            }
        }
        return this.getColumn(n).getBoolean();
    }

    @Override
    public byte getByte(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getByte(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getByte(int)");
            }
        }
        return this.getColumn(n).getByte();
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBytes(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBytes(int)");
            }
        }
        return this.getColumn(n).getBytes();
    }

    @Override
    public TextPointer getSybTextPointer(int n) throws SQLException {
        return this.getColumn(n).getTextPtr();
    }

    @Override
    public short getShort(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getShort(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getShort(int)");
            }
        }
        return this.getColumn(n).getShort();
    }

    @Override
    public int getInt(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getInt(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getInt(int)");
            }
        }
        return this.getColumn(n).getInt();
    }

    @Override
    public long getLong(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getLong(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getLong(int)");
            }
        }
        return this.getColumn(n).getLong();
    }

    @Override
    public float getFloat(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getFloat(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getFloat(int)");
            }
        }
        return this.getColumn(n).getFloat();
    }

    @Override
    public double getDouble(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getDouble(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDouble(int)");
            }
        }
        return this.getColumn(n).getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBigDecimal(int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBigDecimal(int, int)");
            }
        }
        return this.getColumn(n).getBigDecimal(n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBigDecimal(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBigDecimal(int)");
            }
        }
        return this.getBigDecimal(n, -1);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getDate(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDate(int)");
            }
        }
        return Convert.objectToDate(this.getColumn(n).getDateObject(91, null));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getTime(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTime(int)");
            }
        }
        return Convert.objectToTime(this.getColumn(n).getDateObject(92, null));
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getTimestamp(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTimestamp(int)");
            }
        }
        return Convert.objectToTimestamp(this.getColumn(n).getDateObject(93, null));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getAsciiStream(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getAsciiStream(int)");
            }
        }
        return this.getColumn(n).getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getUnicodeStream(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getUnicodeStream(int)");
            }
        }
        return this.getColumn(n).getUnicodeStream();
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBinaryStream(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBinaryStream(int)");
            }
        }
        return this.getColumn(n).getBinaryStream();
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getObject(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getObject(int)");
            }
        }
        return this.getColumn(n).getObject();
    }

    @Override
    public String getString(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getString(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getString(String)");
            }
        }
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBoolean(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBoolean(String)");
            }
        }
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getByte(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getByte(String)");
            }
        }
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getShort(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getShort(String)");
            }
        }
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getInt(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getInt(String)");
            }
        }
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getLong(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getLong(String)");
            }
        }
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getFloat(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getFloat(String)");
            }
        }
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getDouble(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDouble(String)");
            }
        }
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBigDecimal(String = [" + string + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBigDecimal(String, int)");
            }
        }
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBigDecimal(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBigDecimal(String)");
            }
        }
        return this.getBigDecimal(string, -1);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBytes(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBytes(String)");
            }
        }
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public TextPointer getSybTextPointer(String string) throws SQLException {
        return this.getSybTextPointer(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getDate(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDate(String)");
            }
        }
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getTime(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTime(String)");
            }
        }
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getTimestamp(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTimestamp(String)");
            }
        }
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getAsciiStream(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getAsciiStream(String)");
            }
        }
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getUnicodeStream(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getUnicodeStream(String)");
            }
        }
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBinaryStream(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBinaryStream(String)");
            }
        }
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Object getObject(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getObject(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getObject(String)");
            }
        }
        return this.getObject(this.findColumn(string));
    }

    @Override
    public URL getURL(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getURL(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getURL(int)");
            }
        }
        Debug.notImplemented(this, "getURL(int)");
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getURL(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getURL(String)");
            }
        }
        Debug.notImplemented(this, "getURL(String)");
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getWarnings()");
        }
        SQLWarning sQLWarning = null;
        if (this._prs != null) {
            if (this._savedWarnings != null) {
                this._savedWarnings.setNextWarning(this._prs.getWarnings());
                this._prs.clearWarnings();
                sQLWarning = this._savedWarnings;
            } else {
                sQLWarning = this._prs.getWarnings();
            }
        } else if (this._savedWarnings != null) {
            sQLWarning = this._savedWarnings;
        }
        return sQLWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " clearWarnings()");
        }
        if (this._prs != null) {
            this._prs.clearWarnings();
        }
        this._savedWarnings = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getCursorName()");
        }
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMetaData()");
        }
        this.checkResultSet();
        return this._prs.getMetaData();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        Integer n;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " findColumn(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " findColumn(String)");
            }
        }
        if (this._pc._conn._props.getBoolean(40)) {
            Integer n2;
            if (this._labelToColumn == null) {
                this._labelToColumn = new Hashtable();
            }
            if ((n2 = (Integer)this._labelToColumn.get(string)) != null) {
                return n2;
            }
            int n3 = this._prs.findColumnByLabel(string);
            this._labelToColumn.put(string, new Integer(n3));
            return n3;
        }
        if (this._nameToColumn == null) {
            this._nameToColumn = new Hashtable();
        }
        if ((n = (Integer)this._nameToColumn.get(string)) != null) {
            return n;
        }
        int n4 = this._prs.findColumn(string);
        this._nameToColumn.put(string, new Integer(n4));
        return n4;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getCharacterStream(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getCharacterStream(int)");
            }
        }
        return this.getColumn(n).getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getCharacterStream(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getCharacterStream(String)");
            }
        }
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public int getRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getRow()");
        }
        if (this._rowIndex <= 0) {
            return 0;
        }
        return this._rowIndex;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isBeforeFirst()");
        }
        return this._rowIndex == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isAfterLast()");
        }
        return this._rowIndex == -2;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isFirst()");
        }
        return this._rowIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isLast()");
        }
        if (this._lastRowIndex != -4) {
            return this._rowIndex == this._lastRowIndex;
        }
        Debug.notImplemented(this, "isLast()");
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " previous()");
        }
        this.checkForScrollability("previous()");
        this.clearWarnings();
        boolean bl = true;
        switch (this._rowIndex) {
            case -1: {
                return false;
            }
            case 1: {
                this._rowIndex = -1;
                bl = false;
                break;
            }
            case -2: {
                this._rowIndex = this._lastRowIndex;
                break;
            }
            default: {
                --this._rowIndex;
            }
        }
        this._prs.previous();
        return bl;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        int n2;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " absolute(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " absolute(int)");
            }
        }
        this.checkForScrollability("absolute(int)");
        this.clearWarnings();
        if (this._lastRowIndex == 0) {
            return false;
        }
        if (n == 0) {
            ErrorMessage.raiseError("JZ0I3", String.valueOf(n), "absolute(int)");
        }
        if (n < 0) {
            if (this._lastRowIndex == -4 && !this.last()) {
                return false;
            }
            if ((n += this._lastRowIndex + 1) <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (n <= (n2 = this._prs.getNumRowsCached())) {
            this._rowIndex = n;
            this._prs.absolute(n);
            return true;
        }
        if (n2 > 0) {
            this._rowIndex = n2;
            this._prs.absolute(this._rowIndex);
        }
        while (this._rowIndex < n && this.next()) {
        }
        return this._rowIndex == n;
    }

    @Override
    public void afterLast() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " afterLast()");
        }
        this.checkForScrollability("afterLast()");
        this.clearWarnings();
        if (this.last()) {
            this.next();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " beforeFirst()");
        }
        this.checkForScrollability("beforeFirst()");
        this.clearWarnings();
        if (this.first()) {
            this.previous();
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " first()");
        }
        this.checkForScrollability("first()");
        this.clearWarnings();
        this.moveToCurrentRow();
        if (this._rowIndex == 1) {
            return true;
        }
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " last()");
        }
        this.checkForScrollability("last()");
        this.clearWarnings();
        this.moveToCurrentRow();
        if (this._lastRowIndex == -4) {
            if (this._prs.getNumRowsCached() > 0) {
                this._rowIndex = this._prs.getNumRowsCached();
                this._prs.absolute(this._rowIndex);
            }
            while (this.next()) {
            }
            this.previous();
        } else if (this._lastRowIndex != 0) {
            this._rowIndex = this._lastRowIndex;
            this._prs.absolute(this._rowIndex);
        }
        return this._lastRowIndex != 0;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " relative(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " relative(int)");
            }
        }
        this.checkForScrollability("relative(int)");
        this.clearWarnings();
        this.moveToCurrentRow();
        boolean bl = false;
        if (this._rowIndex != -1 && this._rowIndex != -2) {
            int n2 = this._rowIndex + n;
            if (n2 <= 0) {
                this.beforeFirst();
            } else {
                bl = this.absolute(n2);
            }
        }
        return bl;
    }

    @Override
    public void refreshRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " refreshRow()");
        }
        switch (this._scrollType) {
            case 1003: 
            case 1004: {
                break;
            }
            case 1005: {
                Debug.notImplemented(this, "refreshRow() FOR TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " moveToCurrentRow()");
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " moveToInsertRow()");
        }
        ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setFetchDirection(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setFetchDirection(int)");
            }
        }
        block0 : switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", "setFetchDirection(int)", "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: 
            case 1005: {
                switch (n) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this._fetchDirection = n;
                        break block0;
                    }
                }
                ErrorMessage.raiseError("JZ0I3", String.valueOf(n), "setFetchDirection(int)");
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getFetchDirection()");
        }
        return this._fetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setFetchSize(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setFetchSize(int)");
            }
        }
        if (n == 0) {
            return;
        }
        int n2 = this._pc._protocol.getIntOption(this._pc, 4);
        if (n < 0 || n2 > 0 && n > n2) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this._fetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getFetchSize()");
        }
        return this._fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getType()");
        }
        return this._scrollType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getConcurrency()");
        }
        return this._concurType;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " rowUpdated()");
        }
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " rowInserted()");
        }
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " rowDeleted()");
        }
        return false;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateNull(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNull(int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNull(int)", this._concurTypeString);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updatedBoolean(int = [" + n + "], boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBoolean(int, boolean)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(int, boolean)", this._concurTypeString);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateByte(int = [" + n + "], byte = [" + by + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateByte(int, byte)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateByte(int, byte)", this._concurTypeString);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateShort(int = [" + n + "], short = [" + s + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateShort(int, short)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateShort(int, short)", this._concurTypeString);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateInt(int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateInt(int, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateInt(int, int)", this._concurTypeString);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateLong(int = [" + n + "], long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateLong(int, long)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateLong(int, long)", this._concurTypeString);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateFloat(int = [" + n + "], float = [" + f + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateFloat(int, float)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateFloat(int, float)", this._concurTypeString);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateDouble(int = [" + n + "], double = [" + d + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateDouble(int, double)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateDouble(int, double)", this._concurTypeString);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateBigDecimal(int = [" + n + "], BigDecimal = [" + bigDecimal + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBigDecimal(int, BigDecimal)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(int, BigDecimal)", this._concurTypeString);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateString(int = [" + n + "], String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateString(int, String)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateString(int, String)", this._concurTypeString);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, "updateBytes", new Object[]{n, byArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "updateBytes", new Object[]{n, byArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBytes(int, byte)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBytes(int, byte[])", this._concurTypeString);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateDate", new Object[]{n, date}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateDate(int, java.sql.Date)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateDate(int, java.sql.Date)", this._concurTypeString);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateTime", new Object[]{n, time}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateTime(int, java.sql.Time)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateTime(int, java.sql.Time)", this._concurTypeString);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateTimestamp", new Object[]{n, timestamp}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateTimestamp(int, java.sql.Timestamp)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(int, java.sql.Timestamp)", this._concurTypeString);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(int, java.io.InputStream, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(int, java.io.InputStream, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{n, reader, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateChracterStream(int, java.io.Redear, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(int, java.io.Reader, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateObject", new Object[]{n, object, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateObject(int, Object, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateObject", new Object[]{n, object}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateObject(int, Object)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object)", this._concurTypeString);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateNull(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNull(String)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNull(String)", this._concurTypeString);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateBoolean(String = [" + string + "], boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBoolean(String, boolean)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(String, boolean)", this._concurTypeString);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateByte(String = [" + string + "], byte = [" + by + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateByte(String, byte)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateByte(String, byte)", this._concurTypeString);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateShort(String = [" + string + "], short = [" + s + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateShort(String, short)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateShort(String, short)", this._concurTypeString);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateInt(String = [" + string + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateInt(String, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateInt(String, int)", this._concurTypeString);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateLong(String = [" + string + "], long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateLong(String, long)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateLong(String, long)", this._concurTypeString);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateFloat(String = [" + string + "], float = [" + f + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateFloat(String, float)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateFloat(String, float)", this._concurTypeString);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateDouble(String = [" + string + "], double = [" + d + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateDouble(String, double)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateDouble(String, double)", this._concurTypeString);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateBigDecimal(String = [" + string + "], BigDecimal = [" + bigDecimal + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBigDecimal(String, BigDecimal)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(String, BigDecimal)", this._concurTypeString);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateString(String = [" + string + "], String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateString(String, String)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateString(String, String)", this._concurTypeString);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBytes", new Object[]{string, byArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBytes", new Object[]{string, byArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBytes(String, byte)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBytes(String, byte[])", this._concurTypeString);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateDate", new Object[]{string, date}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateDate(String, java.sql.Date)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateDate(String, java.sql.Date)", this._concurTypeString);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateTime", new Object[]{string, time}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateTime(String, java.sql.Time)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateTime(String, java.sql.Time)", this._concurTypeString);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateTimestamp", new Object[]{string, timestamp}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateTimestamp(String, java.sql.Timestamp)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(String, java.sql.Timestamp)", this._concurTypeString);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(String, java.io.InputStream, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(String, java.io.InputStream, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{string, reader, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(String, java.io.Reader, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(String, java.io.Reader, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateObject", new Object[]{string, object, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateObject(String, Object, int)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateObject", new Object[]{string, object}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateObject(String, Object)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object)", this._concurTypeString);
    }

    @Override
    public void insertRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " insertRow()");
        }
        ErrorMessage.raiseError("JZ0BT", "insertRow()", this._concurTypeString);
    }

    @Override
    public void updateRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " updateRow()");
        }
        ErrorMessage.raiseError("JZ0BT", "updateRow()", this._concurTypeString);
    }

    @Override
    public void deleteRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " deleteRow()");
        }
        ErrorMessage.raiseError("JZ0BT", "deleteRow()", this._concurTypeString);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " cancelRowUpdates()");
        }
        ErrorMessage.raiseError("JZ0BT", "cancelRowUpdates()", this._concurTypeString);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getStatement()");
        }
        return this._statement;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getRef(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getRef(int)");
            }
        }
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBlob(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBlob(int)");
            }
        }
        return this.getColumn(n).getBlob();
    }

    protected Blob getInitializedBlob(int n) throws SQLException {
        return this.getColumn(n).getInitializedBlob();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, "updateBlob", new Object[]{n, blob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "updateBlob", new Object[]{n, blob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(int, Blob)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBlob(int, Blob)", this._concurTypeString);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{string, blob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{string, blob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(String, Blob)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBlob(String, Blob)", this._concurTypeString);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateClob(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(int)");
            }
        }
        return this.getColumn(n).getClob();
    }

    protected Clob getInitializedClob(int n) throws SQLException {
        return this.getColumn(n).getInitializedClob();
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, "updateClob", new Object[]{n, clob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "updateClob", new Object[]{n, clob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(int, Clob)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateClob(int, Clob)", this._concurTypeString);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateClob", new Object[]{string, clob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateClob", new Object[]{string, clob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(String, Clob)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateClob(String, Clob)", this._concurTypeString);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getArray(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getArray(int)");
            }
        }
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateArray", new Object[]{n, array}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateArray(int, Array)");
            }
        }
        Debug.notSupported(this, "updateArray(int, Array)");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateArray", new Object[]{string, array}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateArray(String, Array)");
            }
        }
        Debug.notSupported(this, "updateArray(String, Array)");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getRef(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getRef(String)");
            }
        }
        Debug.notSupported(this, "getRef(String)");
        return null;
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateRef", new Object[]{n, ref}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateRef", new Object[]{n, ref}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateRef(int, Ref)");
            }
        }
        Debug.notSupported(this, "updateRef(int, Ref)");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateRef", new Object[]{string, ref}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateRef", new Object[]{string, ref}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateRef(String, Ref)");
            }
        }
        Debug.notSupported(this, "updateRef(String, Ref)");
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBlob(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBlob(String)");
            }
        }
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getClob(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getClob(String)");
            }
        }
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getArray(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getArray(String)");
            }
        }
        Debug.notSupported(this, "getArray(String)");
        return null;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getDate", new Object[]{n, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDate(int, Calendar)");
            }
        }
        return Convert.objectToDate(this.getColumn(n).getDateObject(91, calendar));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getDate", new Object[]{string, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDate(String, Calendar)");
            }
        }
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getTime", new Object[]{n, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTime(int, Calendar)");
            }
        }
        return Convert.objectToTime(this.getColumn(n).getDateObject(92, calendar));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getTime", new Object[]{string, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTime(String, Calendar)");
            }
        }
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getTimestamp", new Object[]{n, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTimestamp(int, Calendar)");
            }
        }
        return Convert.objectToTimestamp(this.getColumn(n).getDateObject(93, calendar));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getTimestamp", new Object[]{string, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTimestamp(String, Calendar)");
            }
        }
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public void clear() throws IOException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " clear()");
        }
        try {
            this.close(false);
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
    }

    @Override
    public void setManager(CacheManager cacheManager) {
        this._cm = cacheManager;
    }

    @Override
    public void reset() throws IOException {
        Debug.notSupported(this, "reset()");
    }

    @Override
    public void resetInputStream(InputStream inputStream) {
        Debug.notSupported(this, "resetInputStream(InputStream is)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cache() throws IOException {
        try {
            switch (this._currentStatus) {
                case 2: {
                    if (this._rowIndex == -2) return;
                    if (this._scrollType != 1004) {
                        this._prs.setType(1004);
                    }
                    while (this._prs.next()) {
                    }
                    if (this._rowIndex == -1) {
                        this._prs.absolute(1);
                        this._prs.previous();
                    } else {
                        this._prs.absolute(this._rowIndex);
                    }
                    this._statement._currentOpenRS.addElement(this);
                    return;
                }
                case 3: {
                    Enumeration enumeration = this._statement._currentOpenRS.elements();
                    while (enumeration.hasMoreElements()) {
                        ((SybResultSet)enumeration.nextElement()).close();
                    }
                    this._statement._currentOpenRS.clear();
                }
                case 1: {
                    this.close();
                    return;
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
            return;
        }
        finally {
            if (this._cm != null) {
                this._cm.doneReading();
                this._cm.dead(this);
                this._cm = null;
            }
        }
    }

    @Override
    public void open(boolean bl) {
    }

    @Override
    public int getState() {
        if (this._state == IConstants.CONNECTION_STATE.DEAD) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void markDead(boolean bl) throws SQLException {
        block9: {
            if (this._state == IConstants.CONNECTION_STATE.DEAD) {
                return;
            }
            this._state = IConstants.CONNECTION_STATE.DEAD;
            try {
                if (this._prs == null) break block9;
                this._prs.close(bl);
                if (this._statement == null) break block9;
                try {
                    SQLWarning sQLWarning = this._prs.getWarnings();
                    if (sQLWarning != null) {
                        this._statement.handleSQLE(sQLWarning);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this._statement.setRowCount(this._prs.getCount());
            }
            finally {
                if (this._cm != null) {
                    this._cm.doneReading();
                    this._cm.dead(this);
                    this._cm = null;
                }
                if (this._statement != null) {
                    this._statement._currentRS = null;
                    this._statement = null;
                }
                this._nameToColumn = null;
                this._prs = null;
            }
        }
    }

    protected void checkResultSet() throws SQLException {
        if (this._state != IConstants.CONNECTION_STATE.BUSY) {
            ErrorMessage.raiseError("JZ0R0");
        }
    }

    protected void close(boolean bl) throws SQLException {
        this.markDead(bl);
    }

    protected JdbcDataObject getColumn(int n) throws SQLException {
        this.checkResultSet();
        this.checkIfReadableRow();
        this._currentColumn = this._prs.getColumn(n);
        return this._currentColumn;
    }

    protected void checkIfReadableRow() throws SQLException {
        if (this._rowIndex == -1 && !this._usedForParams) {
            ErrorMessage.raiseError("JZ0R1");
        } else if (this._rowIndex == -2) {
            ErrorMessage.raiseError("JZ0R5");
        }
    }

    public void setHoldsParams(boolean bl) {
        this._usedForParams = bl;
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        Debug.notImplemented(this, "updateBigDecimal");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal, int n, int n2) throws SQLException {
        Debug.notImplemented(this, "updateBigDecimal");
    }

    protected void checkForScrollability(String string) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", string, "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: {
                break;
            }
            case 1005: {
                Debug.notImplemented(this, string + " for TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getHoldability()");
        }
        return this._statement.getResultSetHoldability();
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNCharacterStream(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNCharacterStream(int)");
            }
        }
        return this.getColumn(n).getCharacterStream();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNCharacterStream(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNCharacterStream(String)");
            }
        }
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNClob(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNClob(int)");
            }
        }
        Debug.notImplemented(this, "getNClob(int columnIndex)");
        return null;
    }

    protected NClob getInitializedNClob(int n) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getInitializedNClob()");
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNClob(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNClob(String)");
            }
        }
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(String)");
        return null;
    }

    @Override
    public String getNString(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNString(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNString(int)");
            }
        }
        return this.getColumn(n).getString();
    }

    @Override
    public String getNString(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNString(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNString(String)");
            }
        }
        return this.getNString(this.findColumn(string));
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isClosed()");
        }
        return this._state == IConstants.CONNECTION_STATE.DEAD;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " getObject", new Object[]{n, map}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getObject", new Object[]{n, map}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getObject(int, Map<String, Class<?>>)");
            }
        }
        Debug.notImplemented(this, "getObject(int columnIndex, Map<String, Class<?>> map)");
        return null;
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " getObject", new Object[]{string, map}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getObject", new Object[]{string, map}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getObject(String, Map<String, Class<?>>)");
            }
        }
        Debug.notImplemented(this, "getObject(String columnLabel, Map<String, Class<?>> map)");
        return null;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getRowId(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getRowId(int)");
            }
        }
        Debug.notImplemented(this, "getRowId(int columnIndex)");
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getRowId(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getRowId(String)");
            }
        }
        Debug.notImplemented(this, "getRowId(String columnLabel)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getSQLXML(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getSQLXML(int)");
            }
        }
        Debug.notImplemented(this, "getSQLXML(int columnIndex)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getSQLXML(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getSQLXML(String)");
            }
        }
        Debug.notImplemented(this, "getSQLXML(String columnLabel)");
        return null;
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(int, InputStream)");
            }
        }
        Debug.notImplemented(this, "updateAsciiStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(String, InputStream)");
            }
        }
        Debug.notImplemented(this, "updateAsciiStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(int, InputStream, long)");
            }
        }
        Debug.notImplemented(this, "updateAsciiStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(String, InputStream, long)");
            }
        }
        Debug.notImplemented(this, "updateAsciiStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(int, InputStream)");
            }
        }
        Debug.notImplemented(this, "updateBinaryStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(String, InputStream)");
            }
        }
        Debug.notImplemented(this, "updateBinaryStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(int, InputStream, long)");
            }
        }
        Debug.notImplemented(this, "updateBinaryStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(String, InputStream, long)");
            }
        }
        Debug.notImplemented(this, "updateBinaryStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(int, InputStream)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBlob(int, InputStream)", this._concurTypeString);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(String, InputStream)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBlob(String, InputStream)", this._concurTypeString);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(int, InputStream, long)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBlob(int, InputStream, long)", this._concurTypeString);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(String, InputStream, long)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateBlob(String, InputStream, long)", this._concurTypeString);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(int, Reader)");
            }
        }
        Debug.notImplemented(this, "updateCharacterStream(int columnIndex, Reader x)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(String, Reader)");
            }
        }
        Debug.notImplemented(this, "updateCharacterStream(String columnLabel, Reader reader)");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(int, Reader, long)");
            }
        }
        Debug.notImplemented(this, "updateCharacterStream(int columnIndex, Reader x, long length)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(String, Reader, long)");
            }
        }
        Debug.notImplemented(this, "updateCharacterStream(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateClob", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(int, Reader)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateClob(int, Reader)", this._concurTypeString);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateClob", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(String, Reader)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateClob(String, Readear)", this._concurTypeString);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateClob", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(int, Reader, long)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateClob(int, Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(String, Reader)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateClob(String, Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNCharacterStream", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNCharacterStream(int, Reader)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(int, java.io.Reader)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNCharacterStream", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNCharacterStream(String, Reader)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(String, java.io.Reader)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNCharacterStream", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNCharacterStream(int, Reader, long)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(int, java.io.Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNCharacterStream", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNCharacterStream(String, Reader, long)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(String, java.io.Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateNClob", new Object[]{n, nClob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNClob", new Object[]{n, nClob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNClob(int, NClob)");
            }
        }
        Debug.notImplemented(this, "public void updateNClob(int columnIndex, NClob clob)");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateNClob", new Object[]{string, nClob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNClob", new Object[]{string, nClob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNClob(String, NClob)");
            }
        }
        Debug.notImplemented(this, "public void updateNClob(String columnLabel, NClob clob)");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNClob", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNClob(int, Reader)");
            }
        }
        Debug.notImplemented(this, "public void updateNClob(int columnIndex, Reader reader)");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNClob", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNClob(String, Reader)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNClob(String, Reader)", this._concurTypeString);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNClob", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNClob(int, Reader, long)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNClob(int, Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNClob", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNClob(String, Reader, long)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNClob(String, Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateNString(int = [" + n + "], String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNString(int, String)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNString(int, String)", this._concurTypeString);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateNString(String = [" + string + "], String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNString(String, String)");
            }
        }
        ErrorMessage.raiseError("JZ0BT", "updateNString(String, String)", this._concurTypeString);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateRowId", new Object[]{n, rowId}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateRowId(int, RowId)");
            }
        }
        Debug.notImplemented(this, "updateRowId(int columnIndex, RowId x)");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateRowId", new Object[]{string, rowId}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateRowId(String, RowId)");
            }
        }
        Debug.notImplemented(this, "updateRowId(String columnLabel, RowId x)");
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateSQLXML", new Object[]{n, sQLXML}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateSQLXML(int, SQLXML)");
            }
        }
        Debug.notImplemented(this, "updateSQLXML(int columnIndex, SQLXML xmlObject)");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateSQLXML", new Object[]{string, sQLXML}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateSQLXML(String, SQLXML)");
            }
        }
        Debug.notImplemented(this, "updateSQLXML(String columnLabel, SQLXML xmlObject)");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " isWrapperFor", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " isWrapperFor(Class<?>)");
            }
        }
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " unwrap", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " unwrap(Class<T>)");
            }
        }
        T t = null;
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName());
        }
        return t;
    }
}

