/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.jdbc.SybUrlManager;
import com.sybase.jdbc4.jdbc.SybUrlProviderImplBase;
import com.sybase.jdbc4.utils.SybInterfacesEntry;
import com.sybase.jdbc4.utils.SybSqlIniParser;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class SybSqlIniProvider
extends SybUrlProviderImplBase {
    private static final int ADDRESS = 0;
    private static final int HASERVER = 1;
    private static final int KERBEROS = 2;
    private static final int PROTOCOL = 4;
    private static final int PROPERTY = 5;
    private static final String[] KERBEROS_OID = new String[]{"1.3.6.1.4.1.897.4.6.6", "csfkrb5", "secmech"};
    private static final String[] PROTOCOL_TABLE = new String[]{"tli", "tcp", "nlwnsck"};
    private static final String[] ATTRIBUTE_TABLE = new String[]{"query", "hafailover", "secmech"};
    private static final String SYBASE_ADDRESS_PREFIX = "TCP#1#";
    private static final char SYBASE_ADDRESS_DELIMITER = ' ';
    private static final String PLACEHOLDER = "placeholder";
    private static final char HOSTPORT_DELIMITER = ':';
    private SybSqlIniParser _sqlIniParser = null;
    private SybInterfacesEntry _entry = null;

    public SybSqlIniProvider() {
        this._hostportList = new Vector();
        this._secondaryHostportList = new Vector();
    }

    @Override
    public void init(String string, String string2, Properties properties, SybProperty sybProperty) throws SQLException {
        int n;
        this._sybProps = sybProperty;
        int n2 = string2.indexOf("?");
        String string3 = "";
        if (n2 == -1) {
            ErrorMessage.raiseError("JZ019", string3);
        }
        if ((n = string2.indexOf("&")) == -1) {
            string3 = string2.substring(n2 + 1, string2.length());
        } else {
            string3 = string2.substring(n2 + 1, n);
            String string4 = string2.substring(n + 1, string2.length());
            this._sybProps.parsePropertyString(string4);
        }
        if (string3.equals("") || string3 == null) {
            ErrorMessage.raiseError("JZ019", string3);
        }
        string2 = string2.substring(string2.indexOf(":") + 3, n2);
        this._sqlIniParser = new SybSqlIniParser();
        if (string2.equals("") || string2 == null) {
            ErrorMessage.raiseError("JZ021", string2);
        }
        try {
            this._sqlIniParser.open(string2);
        }
        catch (Exception exception) {
            ErrorMessage.raiseError("JZ021", exception.toString());
        }
        this._entry = this.getServerEntrys(string3);
        this.processAttrs(string2);
    }

    private SybInterfacesEntry getServerEntrys(String string) {
        return this._sqlIniParser.getEntry(string);
    }

    private void processAttrs(String string) throws SQLException {
        String string2 = null;
        String[] stringArray = this._sqlIniParser.getVariables(this._entry.getName());
        if (stringArray.length == 0) {
            ErrorMessage.raiseError("JZ024", this._entry.getName(), string);
        }
        block5: for (int i = 0; i < stringArray.length; ++i) {
            switch (this.mapAttribute(stringArray[i])) {
                case 0: {
                    for (int j = 0; j < this._entry.getQuerySize(); ++j) {
                        this.isValidProtocol(this._entry.getProtocol(j), string);
                        String string3 = this._entry.getHostPort(j);
                        if (this._hostportList.contains(string3)) continue;
                        this._hostportList.addElement(string3);
                    }
                    if (this._hostportList.size() != 0) continue block5;
                    ErrorMessage.raiseError("JZ024", this._entry.getName(), string);
                    continue block5;
                }
                case 1: {
                    String string4 = this._entry.getHaFailOver();
                    this._entry = this.getServerEntrys(string4);
                    for (int j = 0; j < this._entry.getQuerySize(); ++j) {
                        this.isValidProtocol(this._entry.getProtocol(j), string);
                        String string5 = this._entry.getHostPort(j);
                        if (this._hostportList.contains(string5)) continue;
                        this._secondaryHostportList.addElement(string5);
                    }
                    if (this._secondaryHostportList.size() == 0) {
                        ErrorMessage.raiseError("JZ024", string4, string);
                    }
                    this._sybProps.setProperty(34, "true");
                    continue block5;
                }
                case 2: {
                    String string6 = this._entry.getKerberosEntry();
                    this.isValidKerberos(string6, string);
                    this._sybProps.setProperty(48, "true");
                    this._sybProps.setProperty(49, this._entry.getName());
                    continue block5;
                }
            }
        }
        if (string2 == null) {
            string2 = "Tds";
        }
        this._protocol = SybUrlManager.loadProtocol(string2);
        this._dbName = this._sybProps.getString(60);
    }

    private boolean isValidKerberos(String string, String string2) throws SQLException {
        String string3 = string;
        int n = string.indexOf(",");
        Vector<String> vector = new Vector<String>();
        while (n != -1) {
            String string4 = string.substring(0, n);
            vector.addElement(string4);
            string = string.substring(n + 1, string.length());
            n = string.indexOf(",");
        }
        if (!vector.contains(string)) {
            vector.addElement(string);
        }
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            string = (String)vector.elementAt(i);
            for (int j = 0; j < KERBEROS_OID.length; ++j) {
                if (!string.equalsIgnoreCase(KERBEROS_OID[i])) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            return true;
        }
        ErrorMessage.raiseError("JZ027", string3, this._entry.getName(), string2);
        return false;
    }

    private boolean isValidProtocol(String string, String string2) throws SQLException {
        for (int i = 0; i < PROTOCOL_TABLE.length; ++i) {
            if (!string.equalsIgnoreCase(PROTOCOL_TABLE[i])) continue;
            return true;
        }
        ErrorMessage.raiseError("JZ026", string, this._entry.getName(), string2);
        return false;
    }

    private int mapAttribute(String string) {
        for (int i = 0; i < ATTRIBUTE_TABLE.length; ++i) {
            if (!string.equalsIgnoreCase(ATTRIBUTE_TABLE[i])) continue;
            return i;
        }
        return -1;
    }
}

