/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.SybBinaryLob;
import com.sybase.jdbc4.jdbc.SybCharLob;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.tds.CapabilitySet;
import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.Tds;
import com.sybase.jdbc4.tds.TdsDataOutputStream;
import com.sybase.jdbc4.tds.TdsJdbcInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsParam
extends Param {
    private static final String NULL = "null";
    private static final String ZERO = "0";
    private static final String QUOTE = "'";
    private static final String HEX_START = "0x";
    private static final String ASCII_ENCODING = "ISO8859_1";
    private static final int DATE = 1;
    private static final int DATETIME = 2;
    protected DataFormat _inDataFmt;
    byte[] _cvtString = null;
    protected String _parameterAsAString = null;
    protected boolean _paramIsLittleEndian = false;
    protected boolean _parameterHoldsUnicharData = false;
    protected TdsDataOutputStream _tdos = null;

    public TdsParam(TdsDataOutputStream tdsDataOutputStream) {
        this._tdos = tdsDataOutputStream;
    }

    protected TdsParam() {
    }

    @Override
    protected void clear(boolean bl) throws IOException {
        this._sendAsLiteral = false;
        this._cvtString = null;
        this._parameterAsAString = null;
        this._parameterHoldsUnicharData = false;
        if (bl) {
            this._sqlType = -999;
            this._regType = -999;
            this._inValue = null;
            this._scale = -999;
        }
        if (this._outValue != null) {
            ((TdsJdbcInputStream)this._outValue).clear();
            this._outValue = null;
        }
    }

    @Override
    protected void normalizeForSend(int n) throws SQLException {
        if (this._sqlType == -999) {
            ErrorMessage.raiseError("JZ0SA", "" + n);
        }
        if (this._targetType != -999 && this._targetType != this._sqlType) {
            if (!(this._inValue instanceof SybCharLob) && !(this._inValue instanceof SybBinaryLob)) {
                this._sqlType = this._targetType;
            }
            switch (this._sqlType) {
                case -5: {
                    this._inValue = Convert.objectToLong(this._inValue);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this._inValue = Convert.objectToBytes(this._inValue);
                    break;
                }
                case -7: 
                case 16: {
                    this._inValue = Convert.objectToBoolean(this._inValue);
                    break;
                }
                case 2004: 
                case 2005: {
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    this._inValue = Convert.objectToString(this._inValue);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    this._inValue = Convert.objectToDateObject(this._inValue, this._targetType, null);
                    break;
                }
                case 2: 
                case 3: {
                    this._inValue = Convert.objectToBigDecimal(this._inValue);
                    break;
                }
                case 8: {
                    this._inValue = Convert.objectToDouble(this._inValue);
                    break;
                }
                case 6: 
                case 7: {
                    this._inValue = Convert.objectToFloat(this._inValue);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    this._inValue = Convert.objectToInt(this._inValue);
                    break;
                }
                case 2000: {
                    break;
                }
            }
        }
    }

    @Override
    protected void prepareForSend(Protocol protocol, int n, boolean bl) throws SQLException {
        Object[] objectArray;
        Tds tds = (Tds)protocol;
        CapabilitySet capabilitySet = tds._capT._reqCaps;
        if (this._sqlType == -999) {
            this._inValue = null;
            this._sqlType = this._regType;
        }
        if (this._sqlType == -999) {
            ErrorMessage.raiseError("JZ0SA", "" + n);
        }
        block4 : switch (this._sqlType) {
            case 2004: 
            case 2005: {
                SybLob sybLob = (SybLob)this._inValue;
                if (sybLob == null || sybLob.getLocator() != null) break;
                switch (sybLob.getLobType()) {
                    case IMAGE: {
                        this._sqlType = -4;
                        objectArray = sybLob.getBytes();
                        this._inValue = objectArray.length == 0 ? null : objectArray;
                        break block4;
                    }
                    case TEXT: {
                        this._sqlType = -1;
                        String string = sybLob.getString();
                        this._inValue = string == null || string.trim().equals("") ? null : string;
                        break block4;
                    }
                    case UNITEXT: {
                        this._sqlType = -16;
                        String string = sybLob.getString();
                        this._inValue = string == null || string.trim().equals("") ? null : string;
                    }
                }
            }
        }
        switch (this._regType) {
            case -4: {
                if (tds._sendLongAnyway) {
                    this._sendAsLiteral = false;
                }
            }
            case -1: {
                this._sqlType = this._regType;
                break;
            }
        }
        if (!bl && tds._sendLiterals) {
            this._sendAsLiteral = true;
            return;
        }
        boolean bl2 = false;
        switch (this._sqlType) {
            case -5: {
                if (capabilitySet.get(51)) break;
                if (this._inValue != null) {
                    long l = (Long)this._inValue;
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE || bl && this._regType != -999) {
                        this._inValue = new BigDecimal(String.valueOf(l));
                        this._sqlType = 2;
                        if (capabilitySet.get(24)) break;
                        this._sendAsLiteral = true;
                        break;
                    }
                    this._inValue = new Integer((int)l);
                } else if (bl && this._regType != -999) {
                    this._sqlType = 2;
                    if (capabilitySet.get(24)) break;
                    this._sendAsLiteral = true;
                    break;
                }
                this._sqlType = 4;
            }
            case 4: {
                if (capabilitySet.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -7: {
                if (capabilitySet.get(13)) break;
                if (this._inValue != null) {
                    this._inValue = new Integer((Boolean)this._inValue != false ? 1 : 0);
                }
                this._sqlType = -6;
            }
            case -6: {
                if (this._inValue != null && (Integer)this._inValue >= 0 && capabilitySet.get(10)) break;
                this._sqlType = 5;
            }
            case 5: {
                if (capabilitySet.get(11)) break;
                this._sqlType = 4;
                if (capabilitySet.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                objectArray = new int[4];
                try {
                    this._tdos.convertString(this, (int[])objectArray);
                    if (this._parameterHoldsUnicharData) {
                        this.decideUnicodeSendingType(tds);
                        break;
                    }
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
                if (objectArray[1] <= 255) {
                    if (this._sqlType == 1 && capabilitySet.get(14)) break;
                    if (capabilitySet.get(15)) {
                        this._sqlType = 12;
                        break;
                    }
                }
                bl2 = true;
            }
            case -16: 
            case -1: {
                boolean bl3;
                boolean bl4 = bl3 = this._inValue instanceof InputStream || this._inValue instanceof Reader;
                if (!bl2 && !bl3) {
                    objectArray = new int[4];
                    try {
                        this._tdos.convertString(this, (int[])objectArray);
                    }
                    catch (IOException iOException) {
                        ErrorMessage.raiseErrorCheckDead(iOException);
                    }
                    if (this._inValue == null || this._inValue instanceof String) {
                        if (this._parameterHoldsUnicharData) {
                            this.decideUnicodeSendingType(tds);
                            break;
                        }
                        if (capabilitySet.get(28) && this.sendingLongcharIsOK(protocol)) break;
                        if (objectArray[1] <= 255) {
                            if (capabilitySet.get(15)) {
                                this._sqlType = 12;
                                break;
                            }
                            if (capabilitySet.get(14)) {
                                this._sqlType = 1;
                                break;
                            }
                            this._sendAsLiteral = true;
                            break;
                        }
                    }
                }
                if (bl3) {
                    if (this._scale != -1 && this._scale <= 255 && capabilitySet.get(15)) {
                        objectArray = new int[4];
                        try {
                            this._tdos.convertString(this, (int[])objectArray);
                        }
                        catch (IOException iOException) {
                            ErrorMessage.raiseErrorCheckDead(iOException);
                        }
                        if (this._parameterHoldsUnicharData) {
                            this.decideUnicodeSendingType(tds);
                            break;
                        }
                        if (objectArray[1] <= 255) {
                            this._sqlType = 12;
                            break;
                        }
                    }
                    if (capabilitySet.get(55)) {
                        if (capabilitySet.get(84)) {
                            this._sqlType = 9221;
                            break;
                        }
                        if (this._tdos._tds.isUnicharEnabled()) {
                            objectArray = new int[4];
                            try {
                                this._tdos.convertString(this, (int[])objectArray);
                            }
                            catch (IOException iOException) {
                                ErrorMessage.raiseErrorCheckDead(iOException);
                            }
                            if (this._parameterHoldsUnicharData) {
                                this.decideUnicodeSendingType(tds);
                                break;
                            }
                        }
                        this._sqlType = 9219;
                        break;
                    }
                }
                if (capabilitySet.get(28) && this.sendingLongcharIsOK(protocol)) {
                    this._sqlType = -1;
                    break;
                }
                if (capabilitySet.get(55)) {
                    this.convertParamToUnicodeInputStream();
                    this._sqlType = 9219;
                    break;
                }
                this._sendAsLiteral = true;
                break;
            }
            case -4: {
                if (tds._sendLongAnyway) break;
                if (this._inValue == null) {
                    if (capabilitySet.get(29) && this.sendingLongbinIsOK(protocol)) break;
                    if (capabilitySet.get(17)) {
                        this._sqlType = -3;
                        break;
                    }
                    if (capabilitySet.get(16)) {
                        this._sqlType = -2;
                        break;
                    }
                    this._sendAsLiteral = true;
                    break;
                }
                if (this._inValue instanceof InputStream && capabilitySet.get(57)) {
                    this._sqlType = 9220;
                    break;
                }
                if (capabilitySet.get(29) && this.sendingLongbinIsOK(protocol)) break;
                if (capabilitySet.get(57)) {
                    this.convertBytesParamToInputStream();
                    this._sqlType = 9220;
                    break;
                }
                this._sendAsLiteral = true;
                break;
            }
            case 2004: 
            case 2005: {
                if (capabilitySet.get(17)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -2: {
                if (capabilitySet.get(16)) break;
                this._sqlType = -3;
            }
            case -3: {
                if (capabilitySet.get(17)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 3: {
                if (capabilitySet.get(27)) break;
                this._sqlType = 2;
            }
            case 2: {
                if (capabilitySet.get(24)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 7: {
                if (capabilitySet.get(22)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 6: 
            case 8: {
                if (capabilitySet.get(23)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 91: {
                if (capabilitySet.get(71)) {
                    if (this._inValue == null) break;
                    this.checkDateRange(1);
                    break;
                }
            }
            case 93: {
                if (!capabilitySet.get(20)) {
                    this._sendAsLiteral = true;
                    break;
                }
                if (this._inValue == null) break;
                if (capabilitySet.get(93) && capabilitySet.get(94)) {
                    this.checkDateRange(1);
                } else {
                    this.checkDateRange(2);
                }
                this._sqlType = 93;
                break;
            }
            case 92: {
                if (capabilitySet.get(72)) break;
                if (!capabilitySet.get(20)) {
                    this._sendAsLiteral = true;
                    break;
                }
                this._sqlType = 93;
                break;
            }
            case 2000: {
                if (capabilitySet.get(54) && !this._sendAsLiteral) break;
                ErrorMessage.raiseError("JZ0ST");
                break;
            }
        }
        if (bl && this._sendAsLiteral) {
            ErrorMessage.raiseError("JZ0SM");
        }
    }

    @Override
    protected void send(OutputStream outputStream, int n) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            ((TdsDataOutputStream)outputStream).writeParam(this, n);
        }
    }

    @Override
    protected int getLength() {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            return this._inDataFmt.length();
        }
        return 0;
    }

    @Override
    protected boolean makeFormat(Protocol protocol, IConstants.STATEMENT_EXECUTION_MODE sTATEMENT_EXECUTION_MODE) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt = new DataFormat(this, ((Tds)protocol)._out, sTATEMENT_EXECUTION_MODE);
            return true;
        }
        return false;
    }

    public void setPrecision(int n) {
        this._inDataFmt._precision = n;
    }

    @Override
    protected void sendFormat(DataOutput dataOutput) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt.send((TdsOutputStream)dataOutput);
        }
    }

    @Override
    public String literalValue(Protocol protocol, int n, int n2) throws IOException {
        Tds tds = (Tds)protocol;
        switch (this._sqlType) {
            case -7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return (Boolean)this._inValue != false ? "1" : ZERO;
            }
            case -6: 
            case 4: 
            case 5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Integer)this._inValue).toString();
            }
            case -5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Long)this._inValue).toString();
            }
            case 2: 
            case 3: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((BigDecimal)this._inValue).toString();
            }
            case 7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Float)this._inValue).toString();
            }
            case 6: 
            case 8: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Double)this._inValue).toString();
            }
            case 91: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                String string = null;
                string = this._tdos._tds.serverAcceptsDateData() ? QUOTE + ((DateObject)this._inValue).format(false, false) + QUOTE : QUOTE + ((DateObject)this._inValue).format(false, true) + QUOTE;
                return string;
            }
            case 92: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                boolean bl = false;
                try {
                    bl = tds.getSybProperty().getBoolean(52);
                }
                catch (SQLException sQLException) {
                    ErrorMessage.raiseIOECheckDead(sQLException);
                }
                String string = null;
                string = this._tdos._tds.serverAcceptsTimeData() && bl ? QUOTE + ((DateObject)this._inValue).format(true, false) + QUOTE : QUOTE + ((DateObject)this._inValue).format(true, true) + QUOTE;
                return string;
            }
            case 93: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                if (tds.isAse()) {
                    DateObject dateObject = (DateObject)this._inValue;
                    int n3 = dateObject.getNanos();
                    String string = dateObject.format(false, false);
                    int n4 = n3 / 1000000;
                    String string2 = n4 < 10 ? string + ".00" : (n4 < 100 ? string + ".0" : string + ".");
                    string2 = string2 + String.valueOf(n4);
                    return QUOTE + string2 + QUOTE;
                }
                return QUOTE + ((DateObject)this._inValue).format(true, false) + QUOTE;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                int n5;
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                int[] nArray = new int[4];
                this._tdos.convertString(this, nArray);
                if (this._parameterHoldsUnicharData) {
                    return this.literalizeUnicharData();
                }
                StringBuffer stringBuffer = null;
                if (this._inValue instanceof String) {
                    n5 = ((String)this._inValue).length();
                    stringBuffer = new StringBuffer(n5 + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(((String)this._inValue).substring(0, n5));
                } else if (this._inValue instanceof InputStream) {
                    n5 = this.getCharCount();
                    stringBuffer = new StringBuffer(n5 + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(this._parameterAsAString);
                } else if (this._inValue instanceof Reader) {
                    stringBuffer = new StringBuffer(nArray[1] + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(this._parameterAsAString);
                }
                n5 = 1;
                int n6 = stringBuffer.length();
                while ((n5 = stringBuffer.toString().indexOf(39, n5)) != -1) {
                    stringBuffer.insert(n5, '\'');
                    if ((n5 += 2) <= ++n6) continue;
                }
                stringBuffer.append(QUOTE);
                return stringBuffer.toString();
            }
            case -4: {
                if (this._parameterHoldsUnicharData && this._sendAsLiteral) {
                    if (this._inValue == null) {
                        return NULL;
                    }
                    return this.literalizeUnicharData();
                }
            }
            case -3: 
            case -2: {
                int n7;
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                if (this._inValue instanceof byte[]) {
                    if (((byte[])this._inValue).length == 0 && this._tdos._tds.serverAcceptsColumnStatusByte()) {
                        return "''";
                    }
                    return HEX_START + HexConverts.hexConvert((byte[])this._inValue);
                }
                InputStream inputStream = (InputStream)this._inValue;
                int n8 = this._scale;
                if (this._scale == -1) {
                    n8 = inputStream.available();
                }
                if (n8 == 0 && this._tdos._tds.serverAcceptsColumnStatusByte()) {
                    return "''";
                }
                byte[] byArray = new byte[n8];
                for (int i = 0; i < n8 && (n7 = inputStream.read(byArray, i, n8 - i)) != -1; i += n7) {
                }
                return HEX_START + HexConverts.hexConvert(byArray);
            }
            case 2004: 
            case 2005: {
                if (!this._sendAsLiteral || !SybLob.class.isInstance(this._inValue)) break;
                return HEX_START + HexConverts.hexConvert(((SybLob)SybLob.class.cast(this._inValue)).getLocator());
            }
            case 2000: {
                if (!this._sendAsLiteral) break;
                ErrorMessage.raiseIOException("JZ0ST");
            }
        }
        return "@p" + n;
    }

    protected int getCharCount() throws IOException {
        InputStream inputStream = (InputStream)this._inValue;
        int n = this._scale;
        if (this._scale == -1) {
            n = inputStream.available();
            n /= 2;
        }
        return n;
    }

    protected String literalizeUnicharData() throws IOException {
        if (this._cvtString.length == 0 && this._tdos._tds.serverAcceptsColumnStatusByte()) {
            return "''";
        }
        return HEX_START + HexConverts.hexConvert(this._cvtString);
    }

    protected String getStringFromStream(int n) throws IOException {
        int n2;
        int n3;
        InputStream inputStream = (InputStream)this._inValue;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = this._scale;
        if (n4 != -1 && n4 % 2 != 0) {
            --n4;
        }
        while (n4 != 0 && (n3 = inputStream.read()) != -1 && (n2 = inputStream.read()) != -1) {
            char c = (char)(n3 << 8 | n2);
            stringBuffer.append(c);
            n4 -= 2;
        }
        return stringBuffer.toString();
    }

    private boolean sendingLongcharIsOK(Protocol protocol) throws SQLException {
        boolean bl = true;
        int[] nArray = new int[4];
        try {
            this._tdos.convertString(this, nArray);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        int n = ((Tds)protocol).getMaxLongvarcharLength();
        if (nArray[1] > n) {
            bl = false;
        }
        return bl;
    }

    private boolean sendingLongbinIsOK(Protocol protocol) throws SQLException {
        int n;
        boolean bl = true;
        boolean bl2 = false;
        int n2 = 0;
        if (this._inValue != null) {
            if (this._inValue instanceof byte[]) {
                n2 = ((byte[])this._inValue).length;
            } else if (this._inValue instanceof InputStream) {
                if (this._scale == -1) {
                    bl2 = true;
                } else {
                    n2 = this._scale;
                }
            }
        }
        if (n2 > (n = ((Tds)protocol).getMaxLongvarbinaryLength()) || bl2 && n != Integer.MAX_VALUE) {
            bl = false;
        }
        return bl;
    }

    private void checkDateRange(int n) throws SQLException {
        int n2 = ((DateObject)this._inValue).getCalendar().get(1);
        if (n == 1) {
            if (n2 < 1 || n2 > 9999) {
                ErrorMessage.raiseError("JZ0SU", String.valueOf(n2), String.valueOf(1), String.valueOf(9999));
            }
        } else if (n2 < 1753 || n2 > 9999) {
            ErrorMessage.raiseError("JZ0SU", String.valueOf(n2), String.valueOf(1753), String.valueOf(9999));
        }
    }

    protected byte[] stringToUnicodeBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = this._tdos.getBigEndian() ? string.getBytes("UnicodeBigUnmarked") : string.getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    protected void convertParamToUnicodeInputStream() {
        this._cvtString = this.stringToUnicodeBytes(this._parameterAsAString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._cvtString);
        this._inValue = byteArrayInputStream;
        this._scale = this._parameterAsAString.length();
        if (!this._tdos.getBigEndian()) {
            this._paramIsLittleEndian = true;
        }
    }

    protected void convertBytesParamToInputStream() {
        if (this._inValue instanceof byte[]) {
            byte[] byArray = (byte[])this._inValue;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this._inValue = byteArrayInputStream;
            this._scale = byArray.length;
        }
    }

    protected void decideUnicodeSendingType(Tds tds) throws SQLException {
        CapabilitySet capabilitySet = tds._capT._reqCaps;
        if (capabilitySet.get(29) && this.sendingLongbinIsOK(tds)) {
            return;
        }
        if (capabilitySet.get(55) && capabilitySet.get(84)) {
            this.convertParamToUnicodeInputStream();
            this._sqlType = 9221;
            return;
        }
    }
}

