String.prototype.startsWith = function(str){
    return (this.toUpperCase().indexOf(str.toUpperCase()) === 0);
}

function aspectinit()
{
	refreshWidgets();
	positionDebugConsole();
};

function positionDebugConsole()
{
	e = document.getElementById("debug_console");
/*	
	if (e!=null) {
		w = documentWidth();
		e.style.top = "-10px";
		e.style.bottom = "100px";
		e.style.left = (w-220)+"px";
		e.style.right = w+"px";
		e.style.width = "210px";
		appendToLog("left = "+e.style.left);
		appendToLog("right = "+e.style.right);
	};
*/	
};

function appendToLog(msg,boolClear) {
	var e = document.getElementById("debug_console");
	if (e) {
		if (boolClear) {
			e.innerHTML = msg+"<br>";
		}
		else {
			e.innerHTML += msg+"<br>";
		};
	};
};

var intRefreshingWidgets = 0;

function refreshWidgets() {
	if (intRefreshingWidgets>0) {
		alert("aborting refreshWidgets");
		return;
	};
	
	intRefreshingWidgets++;
	//appendToLog("refreshWidgets",true);

	var arTagNames = new Array(2);
	arTagNames[0] = "span";
	arTagNames[1] = "div";
	
	for(var i=0;i<arTagNames.length;i++) {
		var e=document.getElementsByTagName(arTagNames[i]);
		for (var j=0;j<e.length;j++) {
			var strUrl = e[j].getAttribute("url");
			if (strUrl) {
				var intInterval = e[j].getAttribute("interval");
				
				if (!intInterval) {
					e[j].setAttribute("interval","5");
					intInterval = 60;
				};
				
				var intCntr = e[j].getAttribute("counter");
				if (!intCntr) {
					e[j].setAttribute("counter","0");
					intCntr = 0;
				};
				
				var boolUpdating = e[j].getAttribute("updating");
				//appendToLog("Counter="+intCntr+" updating="+boolUpdating+" url="+strUrl);
				
				if ((boolUpdating==null) || (boolUpdating=="false") || (boolUpdating==false))
				{
					if (intCntr<=0) {
						//clientSideInclude(e[j],strUrl);
						e[j].setAttribute("counter",intInterval);
						e[j].setAttribute("updating",true);
						asynchInclude(e[j],strUrl);
					}
					else {
						intCntr--;
						e[j].setAttribute("counter",intCntr);
					};
				}
				else {
					intCntr--;
					e[j].setAttribute("counter",intCntr);
					//alert("already updating");
				};
			};
		};
	};

	intRefreshingWidgets--;
	if (intRefreshingWidgets==0) {
		setTimeout("refreshWidgets()",1000);
	};
};

function asynchInclude(element,url)
{
	//appendToLog("asynchInclude: "+url);
	var req = false;

	// For Safari, Firefox, and other non-MS browsers
	if (window.XMLHttpRequest) {
		try {
			req = new XMLHttpRequest();
		} 
		catch (e) {
			req = false;
		}
	} 
	else if (window.ActiveXObject) {
		// For Internet Explorer on Windows
		try {
			req = new ActiveXObject("Msxml2.XMLHTTP");
		} 
		catch (e) {
			try {
				req = new ActiveXObject("Microsoft.XMLHTTP");
			} 
			catch (e) {
				req = false;
			}
		}
	}

	if (req) {
		url += "&random="+Math.floor(Math.random()*99999999);

		req.onreadystatechange  = function()
		{ 
			//alert("readystate="+req.readyState);
			if(req.readyState==4) {
				if (req.status==200) {
					if (element!=null) {
						//appendToLog("Setting innerHTML to "+req.responseText);
						element.innerHTML = req.responseText;
						element.setAttribute("updating",false);
					};
				}
				else {
					//Remember: Browser security prevents request across different domains
					appendToLog("server returned status: "+req.status);
					//element.innerHTML = req.responseText;
					if (element!=null) {
						element.setAttribute("updating",false);
						element.setAttribute("counter",60);
					};
				};
			}
		}; 
		
		req.open('GET',url, true);
		req.send(null);
	} 
	else {
		element.innerHTML = "Sorry, your browser does not support XMLHTTPRequest objects. This page requires Internet Explorer 5 or better for Windows, or Firefox for any system, or Safari. Other compatible browsers may also exist.";
	}
};

function clientSideInclude(element,url) 
{
	var req = false;
	// For Safari, Firefox, and other non-MS browsers
	if (window.XMLHttpRequest) {
		try {
			req = new XMLHttpRequest();
		} 
		catch (e) {
			req = false;
		}
	} 
	else if (window.ActiveXObject) {
		// For Internet Explorer on Windows
		try {
			req = new ActiveXObject("Msxml2.XMLHTTP");
		} 
		catch (e) {
			try {
				req = new ActiveXObject("Microsoft.XMLHTTP");
			} 
			catch (e) {
				req = false;
			}
		}
	}

	if (req) {
		// Synchronous request, wait till we have it all
		//url += "&ms="+(new Date()).getMilliseconds();
		url += "&random="+Math.floor(Math.random()*99999999)
		//alert("url="+url);
		req.open('GET',url, false);
		req.send(null);
		element.innerHTML = req.responseText;
		//alert("innerhtml="+req.responseText);
	} 
	else {
		element.innerHTML = "Sorry, your browser does not support XMLHTTPRequest objects. This page requires Internet Explorer 5 or better for Windows, or Firefox for any system, or Safari. Other compatible browsers may also exist.";
	}
}

function clientSideIncludeByID(id, url) 
{
	var req = false;
	// For Safari, Firefox, and other non-MS browsers
	if (window.XMLHttpRequest) {
		try {
			req = new XMLHttpRequest();
		} 
		catch (e) {
			req = false;
		}
	} 
	else if (window.ActiveXObject) {
		// For Internet Explorer on Windows
		try {
			req = new ActiveXObject("Msxml2.XMLHTTP");
		} 
		catch (e) {
			try {
				req = new ActiveXObject("Microsoft.XMLHTTP");
			} 
			catch (e) {
				req = false;
			}
		}
	}

	var element = document.getElementById(id);
	if (!element) {
		alert("Bad id " + id + "passed to clientSideInclude.  You need a div or span element with this id in your page.");
		return;
	}
	if (req) {
		// Synchronous request, wait till we have it all
		//url += "&ms="+(new Date()).getMilliseconds();
		url += "&random="+Math.floor(Math.random()*99999999)
		//alert("url="+url);
		req.open('GET',url, false);
		req.send(null);
		element.innerHTML = req.responseText;
		//alert("innerhtml="+req.responseText);
	}
	else {
		element.innerHTML = "Sorry, your browser does not support XMLHTTPRequest objects. This page requires Internet Explorer 5 or better for Windows, or Firefox for any system, or Safari. Other compatible browsers may also exist.";
	}
}

function showTooltip(e,Msg,OffsetX,OffsetY,MaxWidth)
{
	if (OffsetX==0) OffsetX = 10;
	if (OffsetY==0) OffsetY = 10;
	
	if ((MaxWidth==null) || (MaxWidth==0)) MaxWidth = 400;
	
	div = document.getElementById("tooltip");
	
	if (div==null) {
		tagBody=document.getElementsByTagName('BODY')[0];
		div = document.createElement('div');
		div.id="tooltip";
		div.className="tooltip"; //apparantly setAttrubute("class"...) doesn't work in IE
		tagBody.appendChild(div);		
	};
	
	div.innerHTML=Msg;

	//don't use the event (e) if just hiding with a blank message.  This allows the showTooltip method to be called
	//without an event if it needs to be cleared manually.  One example of this is when a div is made visible under
	//a tooltip that is being displayed.  
	if (Msg.length>0) {
		W = div.offsetWidth;
		H = div.offsetHeight;
		X = e.clientX;
		Y = e.clientY;
		Top	 = Y+OffsetY;
		Left = X+OffsetX;
		div.style.border="1pt solid";
		div.style.top = Top+"px";
		div.style.left = Left+"px";
		appendToLog("tooltip left="+Left+" top="+Top,true);
		if (div.offsetWidth>MaxWidth) {
			div.style.width=MaxWidth+"px";
		};
		
		div.style.padding=5;
		div.style.border=5;
	}
	else {
		div.style.padding=0;
		//alert("border="+div.style.border);
		div.style.border="none";
		div.style.width="auto";
	};

	//div.innerHTML = "W:"+W+" H:"+H+" ScreenX:"+e.screenX+" ScreenY:"+e.screenY+" clientX="+e.clientX+" clientY="+e.clientY;
};

function documentWidth() {
	var w = 630;

	if (parseInt(navigator.appVersion)>3) {
		if (navigator.appName=="Netscape") w = window.innerWidth;
		if (navigator.appName.indexOf("Microsoft")!=-1) w = document.body.offsetWidth;
	};
	
	return(w);
};

function documentHeight() {
	var h = 460;

	if (parseInt(navigator.appVersion)>3) {
		if (navigator.appName=="Netscape") h = window.innerHeight;
		if (navigator.appName.indexOf("Microsoft")!=-1) h = document.body.offsetHeight;
	};

	return(h);
};

