/*
 * Decompiled with CFR 0.152.
 */
package net.AspectSoftware;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public class AspectServiceMethods {
    public static String Version = "1.057";
    public static String HomeDir = "";
    public static boolean Enabled = true;
    public static boolean IsSupport = false;
    public static boolean IsDevelopment = false;
    public static boolean IsServer = false;
    public static int MaxMem = 0;
    public static int MinimumMaxMem = 190;
    public static boolean PrefsInitialized = false;
    public static String ServerHost1 = "http://72.167.255.169";
    public static String ServerHost2 = "https://72.167.255.169";
    public static final int DRIVE = 0;
    public static final int DIR = 1;
    public static final int NAME = 2;
    public static final int EXT = 3;
    public static String[] arAspect7BetaFiles = new String[]{"Aspect7Beta.jar"};
    public static String[] arAspect7Files = new String[]{"Aspect7.jar"};
    public static final int IntervalBetweenCheckForResponse = 60;
    public static final int ServiceLoopDelay = 10;
    public static final int NotificationServerPermissibleDelay = 300;
    public static final int ClientServerPermissibleDelay = 300;
    public static final int SocketQueuePermissibleDelay = 300;
    public static final int TaskSchedulerPermissibleDelay = 300;
    public static final int TransportQueuePermissibleDelay = 600;
    private static String LogFilename = null;
    private static String LastLogDate = "";

    public int getServiceLoopDelay() {
        return 10;
    }

    public int getIntervalBetweenCheckForResponse() {
        return 60;
    }

    public int getNotificationServerPermissibleDelay() {
        return 300;
    }

    public int getClientServerPermissibleDelay() {
        return 300;
    }

    public int getSocketQueuePermissibleDelay() {
        return 300;
    }

    public int getTaskSchedulerPermissibleDelay() {
        return 300;
    }

    public static String formatDate(Date date, String string) {
        DateFormat dateFormat = DateFormat.getInstance();
        ((SimpleDateFormat)dateFormat).applyPattern(string);
        return dateFormat.format(date);
    }

    public static Date parseTime(String string, String string2) {
        Object var2_2 = null;
        if (string.trim().length() == 0) {
            return new Date(0L);
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.applyPattern(string2);
            Date date = simpleDateFormat.parse(string);
            return date;
        }
        catch (Exception exception) {
            return new Date(0L);
        }
    }

    public static int ival(String string) {
        if (string.startsWith("0x") || string.startsWith("#")) {
            try {
                Integer n = Integer.decode(string.toUpperCase());
                return n;
            }
            catch (Exception exception) {}
        } else {
            try {
                return (int)Double.parseDouble(string.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static double dval(String string) {
        try {
            return Double.parseDouble(AspectServiceMethods.removeChar(string, ','));
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static String replaceChar(String string, char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != c) continue;
            stringBuilder.setCharAt(i, c2);
        }
        return stringBuilder.toString();
    }

    public static String removeChar(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String tokenize(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            if (string.startsWith("%%%%")) {
                return string;
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append("%");
                String string2 = Integer.toHexString(c);
                if (string2.length() < 2) {
                    string2 = "0" + string2;
                }
                stringBuilder.append(string2.toUpperCase());
            }
            return "%%%%" + stringBuilder.toString();
        }
        String string3 = string.startsWith("%%%%") ? string.substring(4) : string;
        for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            if (c == '%') {
                if (string3.length() <= i + 2) continue;
                try {
                    String string4 = string3.substring(i + 1, i + 3);
                    if (string4.equals("FF")) {
                        string4 = string3.substring(i + 1, i + 5);
                        stringBuilder.append((char)Integer.parseInt(string4, 16));
                        i += 4;
                        continue;
                    }
                    stringBuilder.append((char)Integer.parseInt(string4, 16));
                    i += 2;
                }
                catch (Exception exception) {
                    System.out.println("parse error");
                    stringBuilder.append(c);
                }
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String[] getSubStringArray(String string, char c, boolean bl) {
        return AspectServiceMethods.getSubStringArray(new StringBuilder(string), c, bl);
    }

    public static String[] getSubStringArray(StringBuilder stringBuilder, char c, boolean bl) {
        int n;
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = stringBuilder.length();
        if (n2 == 0) {
            return null;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            n = stringBuilder.charAt(i);
            if (n == 34) {
                bl2 = !bl2;
                continue;
            }
            if (n != c || bl2) continue;
            nArray[n3] = i;
            ++n3;
        }
        nArray[n3] = n2;
        String[] stringArray = new String[++n3];
        n = 0;
        for (int i = 0; i < n3; ++i) {
            stringBuilder2.setLength(0);
            if (nArray[i] > n) {
                stringBuilder2.append(stringBuilder.substring(n, nArray[i]));
                if (bl && stringBuilder2.length() > 0 && stringBuilder2.charAt(0) == '\"') {
                    stringBuilder2.deleteCharAt(0);
                    if (stringBuilder2.length() > 0 && stringBuilder2.charAt(stringBuilder2.length() - 1) == '\"') {
                        stringBuilder2.setLength(stringBuilder2.length() - 1);
                    }
                }
                while (stringBuilder2.length() > 0 && stringBuilder2.charAt(0) == ' ') {
                    stringBuilder2.deleteCharAt(0);
                }
                while (stringBuilder2.length() > 0 && stringBuilder2.charAt(stringBuilder2.length() - 1) == ' ') {
                    stringBuilder2.setLength(stringBuilder2.length() - 1);
                }
                stringArray[i] = stringBuilder2.toString();
            } else {
                stringArray[i] = "";
            }
            n = nArray[i] + 1;
        }
        return stringArray;
    }

    public static String replaceSubstring(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder(string);
        AspectServiceMethods.replaceSubstring(stringBuilder, stringBuilder2, string2, string3);
        return stringBuilder.toString();
    }

    public static String replaceSubstring(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, String string2) {
        int n = 0;
        if (string.length() == 0 && string2.length() == 0) {
            stringBuilder.setLength(0);
            stringBuilder.append((CharSequence)stringBuilder2);
            return stringBuilder.toString();
        }
        String string3 = stringBuilder2.toString().toUpperCase();
        String string4 = string.toUpperCase();
        int n2 = -1;
        int n3 = -1;
        do {
            if ((n3 = string3.indexOf(string4, n3 + 1)) < 0) continue;
            n2 = n3;
        } while (n3 >= 0);
        if (n2 < 0) {
            if (!stringBuilder.equals(stringBuilder2)) {
                stringBuilder.setLength(0);
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            return stringBuilder.toString();
        }
        if (string2.toUpperCase().indexOf(string.toUpperCase()) >= 0) {
            if (!string.startsWith("__")) {
                String string5 = "a*&jHg";
                StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
                AspectServiceMethods.replaceSubstring(stringBuilder3, stringBuilder3, string, string5);
                AspectServiceMethods.replaceSubstring(stringBuilder3, stringBuilder3, string5, string2);
                stringBuilder.setLength(0);
                stringBuilder.append((CharSequence)stringBuilder3);
                return stringBuilder.toString();
            }
            stringBuilder.setLength(0);
            stringBuilder.append((CharSequence)stringBuilder2);
            return stringBuilder.toString();
        }
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] < 97 || byArray[i] > 122) continue;
            int n4 = i;
            byArray[n4] = (byte)(byArray[n4] - 32);
        }
        StringBuilder stringBuilder4 = new StringBuilder();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n2 + string.length();
        while (n7 < n8 && n7 < stringBuilder2.length()) {
            char c = stringBuilder2.charAt(n7);
            if (c >= 'a' && c <= 'z') {
                c = (char)((byte)c - 32);
            }
            if ((byte)c == byArray[n6]) {
                if (++n6 == byArray.length) {
                    int n9 = n7 - byArray.length + 1;
                    if (n9 > n5) {
                        stringBuilder4.append(stringBuilder2.substring(n5, n9));
                    }
                    stringBuilder4.append(string2);
                    n5 = n7 + 1;
                    n6 = 0;
                    ++n7;
                    ++n;
                    continue;
                }
                ++n7;
                continue;
            }
            if (n6 > 0) {
                n7 -= n6 - 1;
                n6 = 0;
                continue;
            }
            ++n7;
        }
        if (n5 < stringBuilder2.length()) {
            stringBuilder4.append(stringBuilder2.substring(n5));
        }
        stringBuilder.setLength(0);
        stringBuilder.append((CharSequence)stringBuilder4);
        return stringBuilder.toString();
    }

    public static String getParamValue(String[] stringArray, String string) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                int n = stringArray[i].indexOf(61);
                if (n < 0 || !(string2 = stringArray[i].substring(0, n)).equalsIgnoreCase(string)) continue;
                String string3 = "";
                if (stringArray[i].length() > n + 1) {
                    string3 = stringArray[i].substring(n + 1);
                }
                return string3;
            }
        }
        return "";
    }

    public static String getParamValue(String string, String string2, char c) {
        String[] stringArray = AspectServiceMethods.getSubStringArray(string, c, false);
        return AspectServiceMethods.getParamValue(stringArray, string2);
    }

    public static Object arrayGrow(Object object, int n) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        Class<?> clazz2 = clazz.getComponentType();
        int n2 = Array.getLength(object);
        Object object2 = Array.newInstance(clazz2, n);
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    public static String removeTrailingSlash(String string) {
        if (string.length() < 1) {
            return string;
        }
        if (string.endsWith("\\") || string.endsWith("/")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String addTrailingSlash(String string) {
        if (string.length() < 1) {
            return string;
        }
        char c = string.charAt(string.length() - 1);
        if (c == '\\' || c == '/') {
            return string;
        }
        return string + "\\";
    }

    public static String[] splitPath(String string) {
        String[] stringArray = new String[4];
        if (string == null || string.length() < 1) {
            return stringArray;
        }
        String string2 = string.replace('/', '\\');
        if (string2.indexOf("\\") < 0) {
            stringArray[0] = null;
            stringArray[1] = null;
            if (string2.indexOf(".") < 0) {
                stringArray[2] = string2;
                stringArray[3] = null;
            } else {
                int n = string2.lastIndexOf(46);
                stringArray[2] = string2.substring(0, n);
                stringArray[3] = string2.substring(n);
            }
            return stringArray;
        }
        int n = string2.indexOf(35);
        if (n >= 0 && n < string2.length() - 1 && (string2.toUpperCase().startsWith("WWW.") || string2.toUpperCase().startsWith("HTTP:") || string2.toUpperCase().startsWith("HTTPS:"))) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf(63)) >= 0 && n < string2.length() - 1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf(58)) >= 0) {
            stringArray[0] = string2.substring(0, ++n);
        } else {
            n = 0;
        }
        int n2 = string2.lastIndexOf(46);
        if (n2 >= 0) {
            stringArray[3] = string2.substring(n2);
        } else {
            n2 = string2.length() - 1;
        }
        int n3 = string2.indexOf(92);
        int n4 = string2.lastIndexOf(92);
        if (n3 != n4) {
            stringArray[1] = string2.substring(n, n4 + 1);
        } else if (n == 0 && n3 > 0) {
            stringArray[1] = string2.substring(n, n3 + 1);
        }
        if (n4 >= 0 && n4 < string2.length() - 1) {
            if (string2.indexOf(".") < 0) {
                stringArray[2] = string2.substring(n4 + 1);
            } else if (n4 + 1 <= n2) {
                stringArray[2] = string2.substring(n4 + 1, n2);
            }
        }
        return stringArray;
    }

    public static String fileDrive(String string) {
        String[] stringArray = AspectServiceMethods.splitPath(string);
        if (stringArray != null && stringArray[0] != null) {
            return stringArray[0];
        }
        return "";
    }

    public static String fileDir(String string) {
        String[] stringArray = AspectServiceMethods.splitPath(string);
        if (stringArray != null && stringArray[1] != null) {
            return stringArray[1];
        }
        return "";
    }

    public static String fileName(String string) {
        String[] stringArray = AspectServiceMethods.splitPath(string);
        if (stringArray != null && stringArray[2] != null) {
            return stringArray[2];
        }
        return "";
    }

    public static String fileExt(String string) {
        String[] stringArray = AspectServiceMethods.splitPath(string);
        if (stringArray != null && stringArray[3] != null) {
            return stringArray[3];
        }
        return "";
    }

    public static boolean fileExists(String string) {
        try {
            File file = new File(string);
            return file.exists();
        }
        catch (Exception exception) {
            System.out.println("fileExists: " + exception.toString());
            return false;
        }
    }

    public static boolean fileIsDirectory(String string) {
        try {
            File file = new File(string);
            return file.isDirectory();
        }
        catch (Exception exception) {
            System.out.println("fileExists: " + exception.toString());
            return false;
        }
    }

    public static long fileSize(String string) {
        if (AspectServiceMethods.fileExists(string) && !AspectServiceMethods.fileIsDirectory(string)) {
            File file = new File(string);
            return file.length();
        }
        return -1L;
    }

    public static long fileModified(String string) {
        if (AspectServiceMethods.fileExists(string) && !AspectServiceMethods.fileIsDirectory(string)) {
            File file = new File(string);
            return file.lastModified();
        }
        return -1L;
    }

    public static boolean deleteFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        file.delete();
        if (file.exists()) {
            System.gc();
            file.delete();
        }
        return !file.exists();
    }

    public static byte[] readInputStream(InputStream inputStream) {
        long l = new Date().getTime();
        try {
            byte[] byArray = new byte[65536];
            byte[] byArray2 = null;
            int n = 0;
            int n2 = 0;
            do {
                if ((n = inputStream.read(byArray)) > 0) {
                    byArray2 = byArray2 == null ? (byArray2 = new byte[n]) : (byte[])AspectServiceMethods.arrayGrow(byArray2, byArray2.length + n);
                    System.arraycopy(byArray, 0, byArray2, n2, n);
                    n2 += n;
                    continue;
                }
                if (new Date().getTime() - l <= 60000L) continue;
                AspectServiceMethods.appendToLog("Timeout in readInputStream");
                return null;
            } while (n >= 0);
            return byArray2;
        }
        catch (Exception exception) {
            System.out.println("readInputStream: " + exception.toString());
            return null;
        }
    }

    public static byte[] getURL(String string) {
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(30000);
            uRLConnection.setReadTimeout(30000);
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = AspectServiceMethods.readInputStream(uRLConnection.getInputStream());
            inputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] oldgetURL(String string) {
        try {
            URL uRL = new URL(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            byte[] byArray = AspectServiceMethods.readInputStream(bufferedInputStream);
            bufferedInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getFile(String string) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.read(byArray);
            randomAccessFile.close();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("getFile: " + exception.toString());
            return null;
        }
    }

    public static byte[] getJarEntry(String string, String string2) {
        try {
            URL uRL = new URL("jar:file:/" + string + "!/" + AspectServiceMethods.replaceChar(string2, '\\', '/'));
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                System.out.println("getJarEntry: Cannot get inputstream: " + string2 + " in jar " + string);
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = AspectServiceMethods.readInputStream(bufferedInputStream);
            bufferedInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("getJarEntry: " + exception.toString());
            return null;
        }
    }

    public static byte[] getZipEntry(String string, String string2) {
        return AspectServiceMethods.getJarEntry(string, string2);
    }

    public static boolean writeFile(String string, byte[] byArray) {
        return AspectServiceMethods.writeFile(string, byArray, false);
    }

    public static boolean writeFile(String string, byte[] byArray, boolean bl) {
        try {
            File file;
            String string2;
            String[] stringArray = AspectServiceMethods.splitPath(string);
            String string3 = string2 = stringArray[0] != null ? stringArray[0] : "\\";
            if (stringArray[1] != null) {
                string2 = string2 + stringArray[1];
            }
            if (!(file = new File(AspectServiceMethods.replaceChar(AspectServiceMethods.removeTrailingSlash(string2), '\\', '/'))).exists()) {
                file.mkdirs();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            if (bl) {
                randomAccessFile.seek(randomAccessFile.length());
            } else {
                randomAccessFile.setLength(0L);
            }
            randomAccessFile.write(byArray);
            randomAccessFile.close();
            return true;
        }
        catch (Exception exception) {
            System.out.println("writeFile: " + exception.toString());
            return false;
        }
    }

    public static String byteToString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }

    public static byte[] stringToByte(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public static boolean copyResource(String string, String string2) {
        if (string.toUpperCase().startsWith("HTTP")) {
            byte[] byArray = AspectServiceMethods.getURL(string);
            if (byArray != null) {
                return AspectServiceMethods.writeFile(string2, byArray);
            }
        } else {
            int n = string.toUpperCase().indexOf(".ZIP");
            if (n < 0) {
                n = string.toUpperCase().indexOf(".JAR");
            }
            if (n > 0) {
                String string3;
                String string4 = string.substring(0, n + 4);
                byte[] byArray = AspectServiceMethods.getJarEntry(string4, string3 = string.substring(n + 5));
                if (byArray != null) {
                    return AspectServiceMethods.writeFile(string2, byArray);
                }
            } else {
                byte[] byArray = AspectServiceMethods.getFile(string);
                if (byArray != null) {
                    return AspectServiceMethods.writeFile(string2, byArray);
                }
            }
        }
        return false;
    }

    public static String getLocalPrefDirectory() {
        if (AspectServiceMethods.fileExists("c:\\Aspect7")) {
            return "c:\\Aspect7";
        }
        Properties properties = System.getProperties();
        String string = (String)properties.get("user.home");
        String string2 = AspectServiceMethods.addTrailingSlash(string) + "aspect";
        if (AspectServiceMethods.fileExists(string2) && AspectServiceMethods.fileIsDirectory(string2)) {
            return string2;
        }
        return "c:\\Aspect7";
    }

    public static String[] getLocalPref() {
        String string = AspectServiceMethods.getLocalPrefDirectory();
        String string2 = AspectServiceMethods.addTrailingSlash(string) + "localprefs.csv";
        if (AspectServiceMethods.fileExists(string2)) {
            byte[] byArray = AspectServiceMethods.getFile(string2);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
            return AspectServiceMethods.getSubStringArray(stringBuilder, ',', true);
        }
        return null;
    }

    public static String getHomeDirectory() {
        return "c:\\aspect7\\";
    }

    public static String getHashID() {
        String[] stringArray = AspectServiceMethods.getLocalPref();
        if (stringArray == null) {
            return "";
        }
        if (stringArray.length < 13) {
            return "";
        }
        return stringArray[12].trim();
    }

    public static String getLogFilename() {
        String string = AspectServiceMethods.formatDate(new Date(), "MM-dd-yyyy");
        if (!string.equalsIgnoreCase(LastLogDate)) {
            LastLogDate = string;
            LogFilename = AspectServiceMethods.getHomeDirectory() + "bin\\service\\Servicelog_" + string + ".txt";
        }
        return LogFilename;
    }

    public static void appendToLog(String string) {
        String string2 = AspectServiceMethods.formatDate(new Date(), "MM-dd-yyyy HH:mm:ss:SSS") + "," + string;
        System.out.println(string2);
        string2 = string2 + "\r\n";
        byte[] byArray = new byte[string2.length()];
        for (int i = 0; i < string2.length(); ++i) {
            byArray[i] = (byte)string2.charAt(i);
        }
        AspectServiceMethods.writeFile(AspectServiceMethods.getLogFilename(), byArray, true);
    }

    public static String getJavaModel() {
        return System.getProperty("sun.arch.data.model");
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static String listProcesses() {
        try {
            String string;
            Process process = Runtime.getRuntime().exec("tasklist.exe /v /fo csv");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\r\n");
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            System.out.println("listProcesses: " + exception.toString());
            return null;
        }
    }

    public static String listServices() {
        try {
            String string;
            Process process = Runtime.getRuntime().exec("net.exe start");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() <= 0 || string.toUpperCase().indexOf("THESE WINDOWS") >= 0 || string.toUpperCase().indexOf("THE COMMAND") >= 0) continue;
                stringBuilder.append(string + "\r\n");
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            System.out.println("listServices: " + exception.toString());
            return null;
        }
    }

    public static Boolean killProcess(Integer n) {
        if (n > 0) {
            AspectServiceMethods.appendToLog("Terminating process: " + n.toString());
            String string = AspectServiceMethods.replaceChar(AspectServiceMethods.addTrailingSlash(System.getenv("windir")), '/', '\\') + "system32\\taskkill.exe";
            String[] stringArray = new String[]{string, "/T", "/F", "/PID", Integer.toString(n)};
            try {
                String string2 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                }
                Process process = Runtime.getRuntime().exec(stringArray, null, new File(System.getenv("windir")));
                if (process != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    string2 = null;
                    boolean bl = false;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.toUpperCase().indexOf("SUCCESS") >= 0) {
                            bl = true;
                        }
                        AspectServiceMethods.appendToLog(string2);
                        Thread.yield();
                    }
                    AspectServiceMethods.appendToLog("Successfully terminated PID: " + n.toString());
                    return bl;
                }
                AspectServiceMethods.appendToLog("Unable to execute command to kill process: " + n.toString());
            }
            catch (Exception exception) {
                AspectServiceMethods.appendToLog("Unable to launch taskkill: " + exception.toString());
            }
        } else {
            AspectServiceMethods.appendToLog("Invalid PID in killProcess: " + n.toString());
        }
        return false;
    }

    public static ArrayList getProcessPIDs(String string) {
        try {
            String string2;
            Process process = Runtime.getRuntime().exec("tasklist.exe /v /fo csv");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2 + "\n");
            }
            bufferedReader.close();
            String[] stringArray = AspectServiceMethods.getSubStringArray(stringBuilder, '\n', false);
            if (stringArray != null && stringArray.length > 0) {
                int n = -1;
                int n2 = -1;
                String string3 = stringArray[0].trim();
                if (string3.length() == 0 && stringArray.length > 1) {
                    string3 = stringArray[1].trim();
                }
                String[] stringArray2 = AspectServiceMethods.getSubStringArray(string3, ',', true);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i].equalsIgnoreCase("Image Name")) {
                        n = i;
                    }
                    if (!stringArray2[i].equalsIgnoreCase("PID")) continue;
                    n2 = i;
                }
                if (n >= 0 && n2 >= 0) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringArray2 = AspectServiceMethods.getSubStringArray(stringArray[i], ',', true);
                        if (stringArray2 == null || stringArray2.length <= Math.max(n, n2) || !stringArray2[n].equalsIgnoreCase(string)) continue;
                        arrayList.add(new Integer(AspectServiceMethods.ival(stringArray2[n2])));
                    }
                    return arrayList;
                }
                AspectServiceMethods.appendToLog("getProcessPIDs cannot get index of Image Name and PID");
                return null;
            }
        }
        catch (Exception exception) {
            System.out.println("getProcessPIDs: " + exception.toString());
        }
        return null;
    }

    public static ArrayList getJavaPIDs() {
        String string = AspectServiceMethods.listProcesses();
        if (string.trim().length() == 0) {
            return null;
        }
        String[] stringArray = AspectServiceMethods.getSubStringArray(string = AspectServiceMethods.removeChar(string, '\r'), '\n', false);
        if (stringArray != null && stringArray.length > 0) {
            int n = -1;
            int n2 = -1;
            String string2 = stringArray[0].trim();
            if (string2.length() == 0 && stringArray.length > 1) {
                string2 = stringArray[1].trim();
            }
            String[] stringArray2 = AspectServiceMethods.getSubStringArray(string2, ',', true);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].equalsIgnoreCase("Image Name")) {
                    n = i;
                }
                if (!stringArray2[i].equalsIgnoreCase("PID")) continue;
                n2 = i;
            }
            if (n >= 0 && n2 >= 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 1; i < stringArray.length; ++i) {
                    String string3;
                    stringArray2 = AspectServiceMethods.getSubStringArray(stringArray[i], ',', true);
                    if (stringArray2 == null || stringArray2.length <= Math.max(n, n2) || !(string3 = stringArray2[n]).equalsIgnoreCase("JAVA.EXE") && !string3.equalsIgnoreCase("JAVAW.EXE") && !string3.equalsIgnoreCase("JP2LAUNCHER.EXE")) continue;
                    arrayList.add(new Integer(AspectServiceMethods.ival(stringArray2[n2])));
                }
                return arrayList;
            }
            AspectServiceMethods.appendToLog("getProcessPIDs cannot get index of Image Name and PID");
            return null;
        }
        return null;
    }

    public static ArrayList getRunningAspect7PIDs() {
        int n;
        Integer n2;
        int n3;
        String string;
        String string2;
        ArrayList arrayList = AspectServiceMethods.getJavaPIDs();
        if (arrayList == null) {
            AspectServiceMethods.appendToLog("getRunningAspect7PIDs: arJavaPIDs=null");
            return null;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n4 = AspectServiceMethods.getGreenlightPort();
        if (n4 > 0 && (string2 = AspectServiceMethods.byteToString(AspectServiceMethods.getURL("http://127.0.0.1:" + Integer.toString(n4) + "/?Network=Greenlight&ID=getPID"))).trim().length() > 0) {
            AspectServiceMethods.appendToLog("getRunningAspect7PIDs adding GreenLight server: " + string2);
            arrayList2.add(new Integer(AspectServiceMethods.ival(string2)));
        }
        if ((string2 = AspectServiceMethods.byteToString(AspectServiceMethods.getFile(AspectServiceMethods.getHomeDirectory() + "bin/service/pid.csv"))).trim().length() == 0) {
            AspectServiceMethods.appendToLog("getRunningAspect7PIDs found no recorded Aspect7 PIDs");
            return arrayList2;
        }
        String[] stringArray = AspectServiceMethods.getSubStringArray(string2 = AspectServiceMethods.removeChar(string2, '\r'), '\n', false);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Integer n5;
                int n6;
                String[] stringArray2 = AspectServiceMethods.getSubStringArray(stringArray[i], ',', false);
                if (stringArray2 == null || stringArray2.length <= 1 || (n6 = AspectServiceMethods.ival(stringArray2[1])) <= 0 || !arrayList.contains(n5 = new Integer(n6)) || arrayList2.contains(n5)) continue;
                arrayList2.add(n5);
            }
        }
        if ((string = AspectServiceMethods.byteToString(AspectServiceMethods.getFile(AspectServiceMethods.getHomeDirectory() + "bin/service/LastPID.txt"))).trim().length() > 0 && (n3 = AspectServiceMethods.ival(string)) > 0 && arrayList.contains(n2 = new Integer(n3)) && !arrayList2.contains(n2)) {
            arrayList2.add(n2);
        }
        string2 = "Java PIDs: ";
        for (n = 0; n < arrayList.size(); ++n) {
            string2 = string2 + ((Integer)arrayList.get(n)).toString() + " ";
        }
        AspectServiceMethods.appendToLog(string2);
        string2 = "Running Aspect7 PIDs: ";
        for (n = 0; n < arrayList2.size(); ++n) {
            string2 = string2 + ((Integer)arrayList2.get(n)).toString() + " ";
        }
        AspectServiceMethods.appendToLog(string2);
        return arrayList2;
    }

    public static Boolean killAllAspect7Processes() {
        AspectServiceMethods.appendToLog("Terminating all Aspect7 processes");
        ArrayList arrayList = AspectServiceMethods.getRunningAspect7PIDs();
        if (arrayList == null) {
            AspectServiceMethods.appendToLog("Unable to get list of running Aspect7 processes");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = (Integer)arrayList.get(i);
            Boolean bl2 = AspectServiceMethods.killProcess(n);
            if (bl2.booleanValue()) continue;
            bl = false;
        }
        if (bl) {
            AspectServiceMethods.deleteFile(AspectServiceMethods.getHomeDirectory() + "bin/service/pid.csv");
        }
        return Boolean.TRUE;
    }

    public static boolean isServiceRunning() {
        String string = AspectServiceMethods.listServices();
        return string.toUpperCase().indexOf("ASPECTSERVICE") >= 0;
    }

    public static int getGreenlightPort() {
        String string = AspectServiceMethods.getHomeDirectory() + "GreenLight\\preferences.txt";
        if (AspectServiceMethods.fileExists(string)) {
            String string2 = AspectServiceMethods.byteToString(AspectServiceMethods.getFile(string));
            String[] stringArray = AspectServiceMethods.getSubStringArray(string2, ',', false);
            if (stringArray == null) {
                return -1;
            }
            if (stringArray.length < 7) {
                return -1;
            }
            return AspectServiceMethods.ival(stringArray[6]);
        }
        return -1;
    }

    public static boolean isGreenlightResponding() {
        int n = AspectServiceMethods.getGreenlightPort();
        if (n > 0) {
            String string = AspectServiceMethods.byteToString(AspectServiceMethods.getURL("http://127.0.0.1:" + Integer.toString(n) + "/?Network=Greenlight&ID=Ping"));
            return string.equalsIgnoreCase("ok");
        }
        return false;
    }

    public static String getThreadResponse() {
        int n = AspectServiceMethods.getGreenlightPort();
        if (n > 0) {
            String string = "Network=Greenlight&ID=getWidget&DocumentID=K4Ui6j3Y1rwlvukPkOqn25Em&Widget=Notification%20Queries&query=CheckThreadResponse";
            byte[] byArray = AspectServiceMethods.getURL("http://127.0.0.1:" + Integer.toString(n) + "/?" + string);
            if (byArray == null) {
                return "";
            }
            return AspectServiceMethods.byteToString(byArray);
        }
        return "";
    }

    public static boolean oldisAspect7Responsive() {
        boolean bl = false;
        boolean bl2 = AspectServiceMethods.isGreenlightResponding();
        for (int i = 0; i < 2; ++i) {
            if (bl2) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl2 = AspectServiceMethods.isGreenlightResponding();
        }
        if (bl2) {
            bl = true;
            String string = AspectServiceMethods.getThreadResponse();
            if (string.length() > 0) {
                AspectServiceMethods.appendToLog("Thread response: " + string);
                String[] stringArray = AspectServiceMethods.getSubStringArray(string, '|', false);
                double d = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "NotificationServer"));
                double d2 = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "NotificationClient"));
                double d3 = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "SocketQueue"));
                double d4 = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "TaskScheduler"));
                double d5 = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "TransportQueue"));
                int n = AspectServiceMethods.ival(AspectServiceMethods.getParamValue(stringArray, "PID"));
                if (d > 300.0) {
                    AspectServiceMethods.appendToLog("Notification server not responsive");
                    bl = false;
                }
                if (d2 > 300.0) {
                    AspectServiceMethods.appendToLog("Notificatoin client not responsive");
                    bl = false;
                }
                if (d3 > 300.0) {
                    AspectServiceMethods.appendToLog("Socket queue not responsive");
                    bl = false;
                }
                if (d4 > 300.0) {
                    AspectServiceMethods.appendToLog("Task scheduler not responsive");
                    bl = false;
                }
                if (d5 > 600.0) {
                    AspectServiceMethods.appendToLog("Transport queue not responsive");
                    bl = false;
                }
            } else {
                AspectServiceMethods.appendToLog("Unable to get thread response information");
                String string2 = AspectServiceMethods.getHashID();
                if (string2.equalsIgnoreCase("mt8mlhuwu")) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static boolean isAspect7Responsive() {
        boolean bl = false;
        String string = "";
        int n = 0;
        long l = new Date().getTime();
        while (string.length() == 0 && new Date().getTime() - l < 300000L) {
            string = AspectServiceMethods.getThreadResponse();
            if (string.length() == 0) {
                AspectServiceMethods.appendToLog("Unable to get thread response");
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (string.length() > 0) {
            bl = true;
            AspectServiceMethods.appendToLog("Thread response: " + string);
            String[] stringArray = AspectServiceMethods.getSubStringArray(string, '|', false);
            double d = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "NotificationServer"));
            double d2 = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "NotificationClient"));
            double d3 = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "SocketQueue"));
            double d4 = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "TaskScheduler"));
            double d5 = AspectServiceMethods.dval(AspectServiceMethods.getParamValue(stringArray, "TransportQueue"));
            int n2 = AspectServiceMethods.ival(AspectServiceMethods.getParamValue(stringArray, "PID"));
            if (d > 300.0) {
                AspectServiceMethods.appendToLog("Notification server not responsive");
                bl = false;
            }
            if (d2 > 300.0) {
                AspectServiceMethods.appendToLog("Notificatoin client not responsive");
                bl = false;
            }
            if (d3 > 300.0) {
                AspectServiceMethods.appendToLog("Socket queue not responsive");
                bl = false;
            }
            if (d4 > 300.0) {
                AspectServiceMethods.appendToLog("Task scheduler not responsive");
                bl = false;
            }
            if (d5 > 600.0) {
                AspectServiceMethods.appendToLog("Transport queue not responsive");
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isDirectSocketConnected() {
        String string = AspectServiceMethods.getHashID();
        if (string.length() == 0) {
            return false;
        }
        String string2 = AspectServiceMethods.byteToString(AspectServiceMethods.getURL("http://72.167.255.169:4446/?Network=Aspect_Support&ID=IsDirectSocketConnected&HashID=" + string));
        if (string2.length() == 0) {
            string2 = AspectServiceMethods.byteToString(AspectServiceMethods.getURL("https://72.167.255.169:4447/?Network=Aspect_Support&ID=IsDirectSocketConnected&HashID=" + string));
        }
        if (string2.trim().length() > 0) {
            return string2.trim().toUpperCase().startsWith("OPENED");
        }
        return false;
    }

    public static void getPreferences() {
        if (PrefsInitialized) {
            return;
        }
        HomeDir = AspectServiceMethods.getHomeDirectory();
        String string = HomeDir + "bin\\service\\servicepref.txt";
        String string2 = AspectServiceMethods.removeChar(AspectServiceMethods.byteToString(AspectServiceMethods.getFile(string)), '\r');
        Enabled = !AspectServiceMethods.getParamValue(string2, "Enabled", '\n').equalsIgnoreCase("false");
        IsSupport = AspectServiceMethods.getParamValue(string2, "IsSupport", '\n').equalsIgnoreCase("true");
        IsDevelopment = AspectServiceMethods.getParamValue(string2, "IsDevelopment", '\n').equalsIgnoreCase("true");
        IsServer = AspectServiceMethods.getParamValue(string2, "IsServer", '\n').equalsIgnoreCase("true");
        try {
            MaxMem = Integer.parseInt(AspectServiceMethods.getParamValue(string2, "MaxMem", '\n'));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MaxMem = Math.max(MinimumMaxMem, MaxMem);
        PrefsInitialized = true;
    }

    public static Boolean isServiceEnabled() {
        AspectServiceMethods.getPreferences();
        return new Boolean(Enabled);
    }

    public static Boolean isAspect7Installed() {
        AspectServiceMethods.getPreferences();
        String string = AspectServiceMethods.addTrailingSlash(HomeDir) + "Aspect7.jar";
        if (!AspectServiceMethods.fileExists(string)) {
            return false;
        }
        if (AspectServiceMethods.fileSize(string) == 0L) {
            return false;
        }
        return true;
    }

    public static boolean getServerIP() {
        String[] stringArray;
        String string = AspectServiceMethods.byteToString(AspectServiceMethods.getURL("http://www.aspect-software.net/serverip.txt"));
        if (string.trim().length() > 0 && (stringArray = AspectServiceMethods.getSubStringArray(string, ',', false)) != null && stringArray.length > 1 && stringArray[1].length() > 0) {
            ServerHost1 = "http://" + stringArray[1];
            ServerHost2 = "https://" + stringArray[1];
            return true;
        }
        return false;
    }

    public static boolean validateFileSet(String string, String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + stringArray[i];
            if (AspectServiceMethods.fileExists(string2)) {
                if (AspectServiceMethods.fileSize(string2) == 0L) {
                    bl = false;
                }
                AspectServiceMethods.appendToLog("Validate: " + string2 + "," + AspectServiceMethods.fileSize(string2) + "," + AspectServiceMethods.formatDate(new Date(AspectServiceMethods.fileModified(string2)), "MM-dd-yyyy HH:mm:ss"));
                continue;
            }
            AspectServiceMethods.appendToLog("Validate: " + string2 + " not found");
            bl = false;
        }
        return bl;
    }

    public static boolean updateFiles(String string, String[] stringArray, String string2, String string3) {
        boolean bl = AspectServiceMethods.validateFileSet(string, stringArray);
        if (!bl) {
            byte[] byArray = AspectServiceMethods.getURL(string2);
            if (byArray == null && string3.length() > 0) {
                byArray = AspectServiceMethods.getURL(string3);
            }
            if (byArray != null && byArray.length > 0) {
                String string4 = AspectServiceMethods.byteToString(byArray);
                string4 = AspectServiceMethods.tokenize(string4, false);
                byArray = AspectServiceMethods.stringToByte(string4);
                String string5 = string + AspectServiceMethods.fileName(string2) + ".zip";
                AspectServiceMethods.writeFile(string5, byArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    AspectServiceMethods.copyResource(string5 + "/" + stringArray[i], string + stringArray[i]);
                }
                bl = AspectServiceMethods.validateFileSet(string, stringArray);
            }
        }
        return bl;
    }

    public static Boolean installAspect7() {
        if (AspectServiceMethods.isAspect7Installed().booleanValue()) {
            return true;
        }
        AspectServiceMethods.getPreferences();
        AspectServiceMethods.getServerIP();
        String string = AspectServiceMethods.addTrailingSlash(HomeDir);
        boolean bl = false;
        if (IsSupport || IsServer) {
            bl = AspectServiceMethods.updateFiles(string, arAspect7BetaFiles, ServerHost1 + "/Aspect7/packages/aspect7beta.html", ServerHost2 + "/Aspect7/packages/aspect7beta.html");
            if (bl) {
                String string2 = AspectServiceMethods.addTrailingSlash(HomeDir) + "Aspect7beta.jar";
                String string3 = AspectServiceMethods.addTrailingSlash(HomeDir) + "Aspect7.jar";
                AspectServiceMethods.writeFile(string3, AspectServiceMethods.getFile(string2));
            }
        } else {
            bl = AspectServiceMethods.updateFiles(string, arAspect7Files, ServerHost1 + "/Aspect7/packages/aspect7.html", ServerHost2 + "/Aspect7/packages/aspect7.html");
        }
        return bl;
    }

    public static Boolean installAspect7Update() {
        AspectServiceMethods.getPreferences();
        String string = AspectServiceMethods.addTrailingSlash(HomeDir) + "Aspect7Update.jar";
        if (AspectServiceMethods.fileExists(string)) {
            String string2 = AspectServiceMethods.byteToString(AspectServiceMethods.getJarEntry(string, "packages/aspect/core/main.asp"));
            if (string2.trim().length() == 0) {
                AspectServiceMethods.appendToLog("Aborting update because Aspect7Update.jar file appears to be corrupt");
                return Boolean.FALSE;
            }
            String string3 = AspectServiceMethods.addTrailingSlash(HomeDir) + "Aspect7.jar";
            AspectServiceMethods.appendToLog("Updating Aspect7 jar");
            AspectServiceMethods.appendToLog("Current: " + string3 + " " + AspectServiceMethods.fileModified(string3) + " " + AspectServiceMethods.fileSize(string3) + " bytes");
            AspectServiceMethods.appendToLog("Update: " + string + " " + AspectServiceMethods.fileModified(string) + " " + AspectServiceMethods.fileSize(string) + " bytes");
            byte[] byArray = AspectServiceMethods.getFile(string);
            if (byArray != null && byArray.length > 0) {
                AspectServiceMethods.writeFile(string3, byArray);
                AspectServiceMethods.appendToLog("Updated Aspect7");
                AspectServiceMethods.deleteFile(string);
                return true;
            }
            AspectServiceMethods.appendToLog("Unable to update Aspect7");
            return false;
        }
        return true;
    }

    public static Process launchAspect7() {
        int n;
        AspectServiceMethods.getPreferences();
        if (!AspectServiceMethods.isAspect7Installed().booleanValue()) {
            AspectServiceMethods.installAspect7();
            if (!AspectServiceMethods.isAspect7Installed().booleanValue()) {
                return null;
            }
        }
        AspectServiceMethods.installAspect7Update();
        ArrayList arrayList = AspectServiceMethods.getProcessPIDs("javaw.exe");
        String string = AspectServiceMethods.addTrailingSlash(AspectServiceMethods.getJavaHome()) + "bin\\javaw.exe";
        String string2 = "http://www.aspect-software.net/Aspect7/packages/aspect_backoffice/Aspect_BackOffice_packages.csv";
        if (IsDevelopment) {
            string2 = "http://www.aspect-software.net/Aspect7/packages/Aspect_Support/Aspect_Support_packages.csv";
        } else if (IsSupport) {
            string2 = "http://www.aspect-software.net/Aspect7/packages/Aspect_Support/Aspect_Support_packages.csv";
        } else if (IsServer) {
            string2 = "http://www.aspect-software.net/Aspect7/packages/Aspect_Server/Aspect_Server_packages.csv";
        }
        int n2 = n = IsSupport ? 256 : 190;
        if (IsServer) {
            n = 512;
        }
        n = Math.max(n, MaxMem);
        System.out.println("MaxMem=" + n);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string);
        arrayList2.add("-Xms32m");
        arrayList2.add("-Xmx" + Integer.toString(n) + "m");
        arrayList2.add("-Xss16m");
        arrayList2.add("-jar");
        arrayList2.add("Aspect7.jar");
        arrayList2.add("packageurl=" + string2);
        if (IsDevelopment) {
            arrayList2.add("-development");
        }
        String[] stringArray = new String[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            stringArray[i] = (String)arrayList2.get(i);
        }
        try {
            String string3 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = string3 + stringArray[i] + " ";
            }
            AspectServiceMethods.appendToLog("Starting process: " + string3);
            Process process = Runtime.getRuntime().exec(stringArray, null, new File(AspectServiceMethods.addTrailingSlash(AspectServiceMethods.getHomeDirectory())));
            ArrayList arrayList3 = AspectServiceMethods.getProcessPIDs("javaw.exe");
            if (arrayList != null && arrayList3 != null) {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    Object e = arrayList3.get(i);
                    if (arrayList.contains(e)) continue;
                    int n3 = (Integer)e;
                    AspectServiceMethods.writeFile(AspectServiceMethods.getHomeDirectory() + "bin/service/LastPID.txt", AspectServiceMethods.stringToByte(Integer.toString(n3)));
                }
            }
            return process;
        }
        catch (Exception exception) {
            AspectServiceMethods.appendToLog("launchAspect7: " + exception.toString());
            return null;
        }
    }

    public static String getVersion() {
        return Version;
    }

    public static void main(String[] stringArray) {
        String string = AspectServiceMethods.byteToString(AspectServiceMethods.getURL("http://72.167.255.169:4446"));
        System.out.println(string);
    }
}

