/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.tds.CachedTdsInt;
import com.sybase.jdbc3.tds.TdsDataObject;
import com.sybase.jdbc3.tds.TdsProtocolContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsInt
extends TdsDataObject {
    long _value;

    public TdsInt(TdsProtocolContext tdsProtocolContext) throws IOException {
        super(tdsProtocolContext);
    }

    protected TdsDataObject createCachedCopy() throws IOException, SQLException {
        return new CachedTdsInt(this);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.doRead();
        BigDecimal bigDecimal = null;
        if (!this._isNull) {
            bigDecimal = new BigDecimal(String.valueOf(this._value));
        }
        bigDecimal = Convert.setScale(bigDecimal, n2);
        return bigDecimal;
    }

    public boolean getBoolean() throws SQLException {
        this.doRead();
        return 0L != this._value;
    }

    public byte getByte() throws SQLException {
        this.doRead();
        Convert.checkByteOflo(this._value);
        return (byte)this._value;
    }

    public double getDouble() throws SQLException {
        this.doRead();
        return this._value;
    }

    public float getFloat() throws SQLException {
        this.doRead();
        return this._value;
    }

    public int getInt() throws SQLException {
        this.doRead();
        Convert.checkIntOflo(this._value);
        return (int)this._value;
    }

    public long getLong() throws SQLException {
        this.doRead();
        return this._value;
    }

    public short getShort() throws SQLException {
        this.doRead();
        Convert.checkShortOflo(this._value);
        return (short)this._value;
    }

    public Object getObject() throws SQLException {
        this.doRead();
        Number number = null;
        if (!this._isNull) {
            number = this._dataLength == 8 ? (Number)new Long(this._value) : (Number)new Integer((int)this._value);
        }
        return number;
    }

    public String getString() throws SQLException {
        this.doRead();
        String string = null;
        if (!this._isNull) {
            string = String.valueOf(this._value);
        }
        return string;
    }

    public void cache() throws IOException {
        this.beginRead();
    }

    public void clear() throws IOException {
        if (this._state == 0) {
            this.getSize();
            this.skip(this._dataLength);
        }
        this.initialize();
    }

    protected void beginRead() throws IOException {
        this.startRead();
        switch (this._state) {
            case 1: {
                if (this._isNull) {
                    this._value = 0L;
                } else {
                    switch (this._dataFmt._datatype) {
                        case 48: {
                            this._value = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            this._value = this.readShort();
                            break;
                        }
                        case 65: {
                            this._value = this.readUnsignedShortAsInt();
                            break;
                        }
                        case 56: {
                            this._value = this.readInt();
                            break;
                        }
                        case 66: {
                            this._value = this.readUnsignedIntAsLong();
                            break;
                        }
                        case 191: {
                            this._value = this.readLong();
                            break;
                        }
                        case 68: {
                            this._value = this.readUINTN();
                            break;
                        }
                        case 38: {
                            this._value = this.readINTN();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseIOException("JZ0TC");
                        }
                    }
                }
                this._state = 3;
            }
        }
    }
}

