/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.utils;

public class HexConverts {
    public static final int[] HEX_INTS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final String a = "0123456789ABCDEF";

    private HexConverts() {
    }

    public static String hexConvert(byte[] byArray, int n2) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(2 * n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(a.charAt((byArray[i2] & 0xF0) >> 4));
            stringBuffer.append(a.charAt(byArray[i2] & 0xF));
        }
        return stringBuffer.toString();
    }

    public static String hexConvert(byte[] byArray) {
        return HexConverts.hexConvert(byArray, byArray.length);
    }

    public static String binaryConvert(long l2, int n2) {
        String string = Long.toBinaryString(l2);
        int n3 = n2 * 8 - string.length();
        if (n3 < 0) {
            throw new IllegalArgumentException("The value translates to more than the specified number of digits");
        }
        while (n3-- > 0) {
            string = "0" + string;
        }
        return string;
    }

    public static String hexConvert(long l2, int n2) {
        String string = Long.toHexString(l2).toUpperCase();
        int n3 = n2 * 2 - string.length();
        if (n3 < 0) {
            if (string.regionMatches(0, "FFFFFFFFFFFFFFFF", 0, -n3)) {
                string = string.substring(-n3, string.length());
            } else {
                throw new IllegalArgumentException("The value translates to more than the specified number of digits");
            }
        }
        while (n3-- > 0) {
            string = "0" + string;
        }
        return string;
    }

    public static String hexConvert(int n2, int n3) {
        String string = Integer.toHexString(n2).toUpperCase();
        int n4 = n3 * 2 - string.length();
        if (n4 < 0) {
            if (string.regionMatches(0, "FFFFFFFFFFFFFFFF", 0, -n4)) {
                string = string.substring(-n4, string.length());
            } else {
                throw new IllegalArgumentException("The value translates to more than the specified number of digits");
            }
        }
        while (n4-- > 0) {
            string = "0" + string;
        }
        return string;
    }
}

