/*
 * Decompiled with CFR 0.152.
 */
package agent;

import agent.TAction;
import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dosutil;
import utility.security.TPasswordService;

public class TActionList {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private static boolean Debug = false;
    private static Hashtable hashActions = new Hashtable();
    private static ArrayList arEditFilenames = new ArrayList();
    private static long LastUpdate = 0L;
    private static boolean Updating = false;

    public static void initializeHashtable() {
        MainWin.appendToLog("TActionList", "getAction", Thread.currentThread(), null, 3, "Initializing action list");
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Agent_Action", 1, true, false, "");
        int n = tAspectDriver.getAbsoluteRecordCount();
        for (int i = 0; i < n; ++i) {
            if (((Boolean)tAspectDriver.getFieldAbsolute("Deleted", i)).booleanValue()) continue;
            String string = (String)tAspectDriver.getFieldAbsolute("Name", i);
            if (hashActions.containsKey(string.toUpperCase())) {
                tAspectDriver.putFieldAbsolute("Deleted", i, (Object)new Boolean(true));
                continue;
            }
            TAction tAction = new TAction();
            tAction.DiskIndex = i;
            tAction.Name = string;
            tAction.Document_ID = (String)tAspectDriver.getFieldAbsolute("Document_ID", i);
            tAction.Widget_Name = (String)tAspectDriver.getFieldAbsolute("Widget_Name", i);
            tAction.Container_Item_ID = (String)tAspectDriver.getFieldAbsolute("Container_Item_ID", i);
            tAction.Params = (String)tAspectDriver.getFieldAbsolute("Params", i);
            tAction.Visibility = (String)tAspectDriver.getFieldAbsolute("Visibility", i);
            hashActions.put(tAction.Name.toUpperCase(), tAction);
            if (!Debug) continue;
            System.out.println("Added action: " + tAction.toString());
        }
        tAspectDriver.dispose();
    }

    public static TAction getAction(String string) {
        String string2;
        if (hashActions.size() == 0) {
            TActionList.initializeHashtable();
        }
        if (hashActions.containsKey(string2 = string.toUpperCase())) {
            return (TAction)hashActions.get(string2);
        }
        MainWin.appendToLog("TActionList", "getAction", Thread.currentThread(), null, 4, "Error: Could not locate action: " + string + ".  Forcing update of action list.");
        TFormulaEvaluator.getCache().purgeExpiredObjects(true);
        TActionList.updateActionList(true);
        string2 = string.toUpperCase();
        if (hashActions.containsKey(string2)) {
            return (TAction)hashActions.get(string2);
        }
        return null;
    }

    public static boolean updateActionList(boolean bl) {
        Object object;
        boolean bl2;
        if (Updating) {
            MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 3, "updateActionList aborted because another instance is running");
            return false;
        }
        Updating = true;
        if (Debug) {
            System.out.println("Check for update action list");
        }
        boolean bl3 = bl2 = LastUpdate == 0L;
        if (!bl2) {
            boolean bl4 = bl2 = !dosutil.fileExists(Application.getHomeDir() + "agents/agent_actions1.dta");
            if (Debug && bl2) {
                System.out.println("Updating action list because table does not exist");
            }
        }
        if (!bl2) {
            long l = charutil.ival(Application.getTokenValue("Widget_Library_Metadata_Updated"));
            boolean bl5 = bl2 = l > LastUpdate;
            if (Debug && bl2) {
                System.out.println("Updating action list because metadata has been updated");
            }
        }
        if (MainWin.isDevelopmentMode()) {
            if (Debug) {
                System.out.println("Checking for action list in open widgets.  Files to check =" + arEditFilenames.size());
            }
            for (int i = 0; i < arEditFilenames.size(); ++i) {
                File file;
                if (arEditFilenames.get(i) == null || !(file = new File((String)arEditFilenames.get(i))).exists() || file.lastModified() <= LastUpdate) continue;
                bl2 = true;
                if (!Debug) continue;
                System.out.println("Updating action list because widget has been modified: " + (String)arEditFilenames.get(i));
            }
        }
        if (!bl && !bl2) {
            if (Debug) {
                System.out.println("Action list is up to date");
            }
            Updating = false;
            return true;
        }
        MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 3, "updateActionList started.  ForceUpdate=" + bl);
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Agent_Action", 1, true, false, "");
        if (Debug) {
            System.out.println("Creating table of existing actions");
        }
        hashActions.clear();
        int n = tAspectDriver.getAbsoluteRecordCount();
        for (int i = 0; i < n; ++i) {
            if (((Boolean)tAspectDriver.getFieldAbsolute("Deleted", i)).booleanValue()) continue;
            String string = (String)tAspectDriver.getFieldAbsolute("Name", i);
            if (hashActions.containsKey(string.toUpperCase())) {
                tAspectDriver.putFieldAbsolute("Deleted", i, (Object)new Boolean(true));
                continue;
            }
            TAction tAction = new TAction();
            tAction.DiskIndex = i;
            tAction.Name = string;
            tAction.Document_ID = (String)tAspectDriver.getFieldAbsolute("Document_ID", i);
            tAction.Widget_Name = (String)tAspectDriver.getFieldAbsolute("Widget_Name", i);
            tAction.Container_Item_ID = (String)tAspectDriver.getFieldAbsolute("Container_Item_ID", i);
            tAction.Params = (String)tAspectDriver.getFieldAbsolute("Params", i);
            tAction.Visibility = (String)tAspectDriver.getFieldAbsolute("Visibility", i);
            hashActions.put(tAction.Name.toUpperCase(), tAction);
            if (!Debug) continue;
            System.out.println("Added action: " + tAction.toString());
        }
        if (Debug) {
            System.out.println("Found " + hashActions.size() + " existing actions");
        }
        arEditFilenames.clear();
        TAspectDriver tAspectDriver2 = new TAspectDriver("Widget_Library_Metadata", 0, true, false, "");
        n = tAspectDriver2.getAbsoluteRecordCount();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            boolean bl6 = (Boolean)tAspectDriver2.getFieldAbsolute("ContainsAgenTActions", i);
            if (!bl6) continue;
            object = (String)tAspectDriver2.getFieldAbsolute("Library_ID", i);
            String string = (String)tAspectDriver2.getFieldAbsolute("Name", i);
            String string2 = "DocumentID=" + (String)object + "&Widget=" + string + "&ContainerItemID=action_list&action_list=true";
            String string3 = TFormulaEvaluator.getCache().getCachedContent(0, Application.getAspectHashID(), string2, false, "127.0.0.1", "").trim();
            if (string3.toUpperCase().indexOf("INVALID RECIPIENT") >= 0) {
                MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 4, "Invalid content for params: " + string2);
                MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 4, "Content: " + string3);
                MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 4, "Making another attempt");
                string2 = string2 + "&RAND=" + TPasswordService.generateSalt(4);
                string3 = TFormulaEvaluator.getCache().getCachedContent(0, Application.getAspectHashID(), string2, false, "127.0.0.1", "").trim();
                if (string3.toUpperCase().indexOf("INVALID RECIPIENT") >= 0) {
                    MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 4, "Content is invalid after retry: " + string3);
                } else {
                    MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 4, "Content is valid after retry: " + string3);
                }
            }
            if (MainWin.isDevelopmentMode()) {
                arEditFilenames.add(Application.getHomeDir() + "cache/WidgetEdit_" + (String)object + "_" + string + ".html");
            }
            if (Debug) {
                System.out.println("Found action list in " + (String)object + "_" + string);
                System.out.println("Contents");
                System.out.println("-----------------------------");
                System.out.println(string3);
                System.out.println("-----------------------------");
            }
            if ((stringArray = charutil.getSubStringArray(string3 = charutil.removeChar(string3, '\r'), '\n', true)) != null && stringArray.length > 0) {
                for (int j = 0; j < stringArray.length; ++j) {
                    String[] stringArray2 = charutil.getSubStringArray(stringArray[j], ',', true);
                    if (stringArray2 != null && stringArray2.length >= 4) {
                        String string4 = stringArray2[0].trim();
                        String string5 = stringArray2[1].toUpperCase().trim();
                        String string6 = stringArray2[1].trim();
                        String string7 = stringArray2[2].trim();
                        string2 = stringArray2[3].trim();
                        String string8 = stringArray2.length > 4 ? stringArray2[4] : "public";
                        TAction tAction = null;
                        int n2 = -1;
                        if (hashActions.containsKey(string5)) {
                            tAction = (TAction)hashActions.get(string5);
                            n2 = tAction.DiskIndex;
                            if (Debug) {
                                System.out.println("Action already exists: " + stringArray2[1]);
                            }
                        } else {
                            n2 = tAspectDriver.initializeNewRecord();
                            tAction = new TAction();
                            tAction.Name = stringArray2[0];
                            tAction.DiskIndex = n2;
                            hashActions.put(stringArray2[1].toUpperCase(), tAction);
                            if (Debug) {
                                System.out.println("Adding new action: " + stringArray2[1]);
                            }
                        }
                        if (!tAction.Group.equalsIgnoreCase(string4)) {
                            tAction.Group = string4;
                            tAspectDriver.putFieldAbsolute("Group", n2, (Object)string4);
                        }
                        if (!tAction.Name.equalsIgnoreCase(string6)) {
                            tAction.Name = string6;
                            tAspectDriver.putFieldAbsolute("Name", n2, (Object)string6);
                        }
                        if (!tAction.Document_ID.equalsIgnoreCase((String)object)) {
                            tAction.Document_ID = object;
                            tAspectDriver.putFieldAbsolute("Document_ID", n2, object);
                        }
                        if (!tAction.Widget_Name.equalsIgnoreCase(string)) {
                            tAction.Widget_Name = string;
                            tAspectDriver.putFieldAbsolute("Widget_Name", n2, (Object)string);
                        }
                        if (!tAction.Container_Item_ID.equalsIgnoreCase(string7)) {
                            tAction.Container_Item_ID = string7;
                            tAspectDriver.putFieldAbsolute("Container_Item_ID", n2, (Object)string7);
                        }
                        if (!tAction.Params.equalsIgnoreCase(string2)) {
                            tAction.Params = string2;
                            tAspectDriver.putFieldAbsolute("Params", n2, (Object)string2);
                        }
                        if (!tAction.Visibility.equalsIgnoreCase(string8)) {
                            tAction.Visibility = string8;
                            tAspectDriver.putFieldAbsolute("Visibility", n2, (Object)string8);
                        }
                        tAction.Exists = true;
                        continue;
                    }
                    MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 4, "Invalid action in content: " + stringArray[j]);
                    MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 3, "Params=" + string2);
                }
                continue;
            }
            MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 3, "No actions in: " + string2);
        }
        if (Debug) {
            System.out.println("Removing unused actions");
        }
        Enumeration enumeration = hashActions.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object = (TAction)hashActions.get(string);
            if (Debug) {
                System.out.println("Checking action: " + ((TAction)object).toString());
            }
            if (((TAction)object).Exists) continue;
            tAspectDriver.putFieldAbsolute("Deleted", ((TAction)object).DiskIndex, (Object)new Boolean(true));
            if (Debug) {
                System.out.println("Removing: " + string);
            }
            MainWin.appendToLog("TActionList", "updateActionList", Thread.currentThread(), null, 3, "Removing action: " + ((TAction)object).toString());
            hashActions.remove(string);
        }
        tAspectDriver.dispose();
        tAspectDriver2.dispose();
        LastUpdate = new Date().getTime();
        Updating = false;
        return true;
    }
}

