/*
 * Decompiled with CFR 0.152.
 */
package agent;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Timer;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dateutil;
import utility.objectutil;

public class TAgentStatus
implements ActionListener {
    private TMainWin MainWin = Aspect.MainWin;
    private TAspectDriver FSummary;
    private TAspectDriver FLog;
    private String BusinessDate;
    private Timer CallbackTimer = null;
    private boolean Modified = false;
    private boolean bReportToServer = true;
    ArrayList arQueuedStatusReports = new ArrayList();
    private Hashtable hashSummary = new Hashtable();
    private Hashtable hSentNotifications = new Hashtable();
    private static boolean bInActionPerformed = false;

    public TAgentStatus() {
        this.BusinessDate = dateutil.formatDate(new Date(), "MMddyyyy");
        this.FLog = new TAspectDriver("Aspect_Agent_Status_Log", 1, true, false, "");
        this.FSummary = new TAspectDriver("Aspect_Agent_Status", 1, true, false, "");
        int n = this.FSummary.getAbsoluteRecordCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = (Boolean)this.FSummary.getFieldAbsolute("Deleted", i);
            if (bl) continue;
            this.hashSummary.put(((String)this.FSummary.getField("ID", i)).toUpperCase(), new Integer(i));
        }
        this.CallbackTimer = new Timer(5000, this);
        this.CallbackTimer.start();
    }

    public boolean reportAgentStatus(String string, String string2, int n, String string3, String string4, String string5, boolean bl, int n2, String string6) {
        Aspect.MainWin.appendToLog("TAgentStatus", "reportAgentStatus", Thread.currentThread(), null, 3, "reportAgentStatus AgentName=" + string + " FoceReport=" + bl);
        int n3 = string.indexOf(95);
        String string7 = string.substring(0, n3);
        String string8 = string.substring(n3 + 1);
        String string9 = "CustomerID=" + TMainWin.Application.getAspectHashID();
        string9 = string9 + "&AgentDocID=" + string7;
        string9 = string9 + "&AgentName=" + charutil.tokenize(string8, true);
        string9 = string9 + "&NodeID=" + string2;
        string9 = string9 + "&TermType=" + n;
        string9 = string9 + "&Comment=" + charutil.tokenize(string4, true);
        string9 = string9 + "&ElapsedTime=" + n2;
        string9 = string9 + "&PArgs=" + charutil.tokenize(string6, true);
        string9 = string9 + "&NodeData=" + charutil.tokenize(string5, true);
        boolean bl2 = true;
        TNotificationSent tNotificationSent = null;
        if (this.hSentNotifications.containsKey(string.toUpperCase())) {
            tNotificationSent = (TNotificationSent)this.hSentNotifications.get(string.toUpperCase());
            bl2 = !tNotificationSent.To.equalsIgnoreCase(string3) || !tNotificationSent.NodeID.equalsIgnoreCase(string2) || !tNotificationSent.Data.equalsIgnoreCase(string5);
            tNotificationSent.NodeID = string2;
            tNotificationSent.To = string3;
            tNotificationSent.Data = string5;
            if (bl2) {
                Aspect.MainWin.appendToLog("TAgentStatus", "reportAgentStatus", Thread.currentThread(), null, 3, "reportAgentStatus AgentName=" + string + " To: " + tNotificationSent.To + " : " + string3);
                Aspect.MainWin.appendToLog("TAgentStatus", "reportAgentStatus", Thread.currentThread(), null, 3, "reportAgentStatus AgentName=" + string + " NodeID: " + tNotificationSent.NodeID + " : " + string2);
                Aspect.MainWin.appendToLog("TAgentStatus", "reportAgentStatus", Thread.currentThread(), null, 3, "reportAgentStatus AgentName=" + string + " Data: " + tNotificationSent.Data + " : " + string5);
            } else {
                Aspect.MainWin.appendToLog("TAgentStatus", "reportAgentStatus", Thread.currentThread(), null, 3, "reportAgentStatus AgentName=" + string + " Status has not changed: " + string5);
            }
        } else {
            tNotificationSent = new TNotificationSent(string2, string3, string5);
            this.hSentNotifications.put(string.toUpperCase(), tNotificationSent);
            Aspect.MainWin.appendToLog("TAgentStatus", "reportAgentStatus", Thread.currentThread(), null, 3, "reportAgentStatus AgentName=" + string + " Previous status not found");
        }
        if (bl) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (bl2) {
            boolean bl4 = bl3 = string3.toUpperCase().indexOf(TMainWin.Application.getTokenValue("AspectServerHashID").toUpperCase()) >= 0;
        }
        if (bl3) {
            Aspect.MainWin.appendToLog("TAgentStatus", "reportAgentStatus", Thread.currentThread(), null, 3, "reportAgentStatus AgentName=" + string + " bSend=" + bl2 + " bReportToServer=" + bl3);
        }
        this.recordAgentStatusLocally(string9, bl3);
        return bl2;
    }

    public synchronized void recordAgentStatus(String string) {
        this.arQueuedStatusReports.add(string);
    }

    public synchronized void recordAgentStatusLocally(String string, boolean bl) {
        String[] stringArray = charutil.getSubStringArray(string, '&', true);
        String string2 = charutil.getParamValue(stringArray, "CustomerID");
        String string3 = charutil.getParamValue(stringArray, "AgentDocId");
        String string4 = charutil.tokenize(charutil.getParamValue(stringArray, "AgentName"), false);
        String string5 = charutil.getParamValue(stringArray, "NodeID");
        int n = charutil.ival(charutil.getParamValue(stringArray, "TermType"));
        String string6 = charutil.tokenize(charutil.getParamValue(stringArray, "Comment"), false);
        int n2 = charutil.ival(charutil.getParamValue(stringArray, "ElapsedTime"));
        String string7 = charutil.tokenize(charutil.replaceChar(charutil.getParamValue(stringArray, "PArgs"), '~', '&'), false);
        String string8 = charutil.tokenize(charutil.getParamValue(stringArray, "NodeData"), false);
        if (string4.startsWith("%") && string4.length() > 4) {
            if ((string4 = string4.substring(4)).toUpperCase().startsWith("KNOWLEDGE")) {
                string4 = charutil.replaceSubstring(string4, "KNOWLEDGE", "Acknowledge");
            }
            if (string4.toUpperCase().startsWith("CKUP")) {
                string4 = charutil.replaceSubstring(string4, "CKUP", "Backup");
            }
        }
        Date date = new Date();
        int n3 = this.FLog.initializeNewRecord();
        this.FLog.putFieldAbsolute("HashID", n3, (Object)string2);
        this.FLog.putFieldAbsolute("DocumentID", n3, (Object)string3);
        this.FLog.putFieldAbsolute("Widget", n3, (Object)string4);
        this.FLog.putFieldAbsolute("Time", n3, (Object)date);
        this.FLog.putFieldAbsolute("NodeID", n3, (Object)string5);
        this.FLog.putFieldAbsolute("Terminate_Type", n3, (Object)new Integer(n));
        this.FLog.putFieldAbsolute("Node_Comment", n3, (Object)string6);
        this.FLog.putFieldAbsolute("Node_Data", n3, (Object)string8);
        this.FLog.putFieldAbsolute("ElapsedTime", n3, (Object)n2);
        this.FLog.putFieldAbsolute("PageArgs", n3, (Object)string7);
        if (bl && !this.MainWin.isRunningOnServer()) {
            this.FLog.putFieldAbsolute("Report_To_Server", n3, (Object)Boolean.TRUE);
            this.bReportToServer = true;
        }
        String string9 = string2.toUpperCase() + string3.toUpperCase() + string4.toUpperCase();
        n3 = -1;
        if (this.hashSummary.containsKey(string9)) {
            n3 = (Integer)this.hashSummary.get(string9);
        } else {
            n3 = this.FSummary.initializeNewRecord();
            this.hashSummary.put(string9, new Integer(n3));
            this.FSummary.putFieldAbsolute("HashID", n3, (Object)string2);
            this.FSummary.putFieldAbsolute("DocumentID", n3, (Object)string3);
            this.FSummary.putFieldAbsolute("Widget", n3, (Object)string4);
        }
        this.FSummary.putFieldAbsolute("ElapsedTime", n3, (Object)n2);
        this.FSummary.putFieldAbsolute("PageArgs", n3, (Object)string7);
        if (n == 0) {
            this.FSummary.putFieldAbsolute("Success_Node_ID", n3, (Object)string5);
            this.FSummary.putFieldAbsolute("Success_Node_Comment", n3, (Object)string6);
            this.FSummary.putFieldAbsolute("Success_Node_Time", n3, (Object)date);
            this.FSummary.putFieldAbsolute("Success_Node_Data", n3, (Object)string8);
        } else if (n == 1) {
            this.FSummary.putFieldAbsolute("Fail_Node_ID", n3, (Object)string5);
            this.FSummary.putFieldAbsolute("Fail_Node_Comment", n3, (Object)string6);
            this.FSummary.putFieldAbsolute("Fail_Node_Time", n3, (Object)date);
            this.FSummary.putFieldAbsolute("Fail_Node_Data", n3, (Object)string8);
        } else {
            this.FSummary.putFieldAbsolute("Other_Node_ID", n3, (Object)string5);
            this.FSummary.putFieldAbsolute("Other_Node_Comment", n3, (Object)string6);
            this.FSummary.putFieldAbsolute("Other_Node_Time", n3, (Object)date);
            this.FSummary.putFieldAbsolute("Other_Node_Data", n3, (Object)string8);
        }
        this.Modified = true;
    }

    public static boolean reportToServer(String string) {
        Aspect.MainWin.appendToLog("TAgentStatus", "reportToServer", Thread.currentThread(), null, 3, "reportToServer s=" + string);
        String string2 = "/?Network=Aspect_Support_Server&ID=recordAgentStatus&" + string;
        string2 = charutil.replaceAllSubstrings(string2, " ", "%20");
        string2 = charutil.replaceAllSubstrings(string2, ".", "%2E");
        boolean bl = false;
        String string3 = TAsciiInput.getContent("http://" + TMainWin.Application.getTokenValue("AspectServerIP2") + string2);
        Aspect.MainWin.appendToLog("TAgentStatus", "reportToServer", Thread.currentThread(), null, 3, "reportToServer http result=" + string3);
        if (string3.toUpperCase().startsWith("OK")) {
            bl = true;
        } else {
            string3 = TAsciiInput.getContent("https://" + TMainWin.Application.getTokenValue("AspectServerIP1") + string2);
            Aspect.MainWin.appendToLog("TAgentStatus", "reportToServer", Thread.currentThread(), null, 3, "reportToServer https result=" + string3);
            if (string3.toUpperCase().startsWith("OK")) {
                bl = true;
            }
        }
        if (!bl && TFormulaEvaluator.isConnected()) {
            String string4 = string + "&Source=" + TMainWin.Application.getTokenValue("AspectServerHashID");
            string4 = string4 + "&DocumentID=K4Ui6j3Y1rwlvukPkOqn25Em";
            string4 = string4 + "&Widget=Notification Queries";
            string4 = string4 + "&query=recordAgentStatus";
            string4 = string4 + "&suppressdisplay=true";
            Object object = new TFormulaEvaluator().getFormulaValue("getWidget(\"" + string4 + "\")");
            string3 = objectutil.convertToString(object);
            System.out.println("reportToServer notification result=" + string3);
            if (string3 != null && string3.equalsIgnoreCase("ok")) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (bInActionPerformed) {
            return;
        }
        bInActionPerformed = true;
        Thread thread = new Thread(){

            @Override
            public void run() {
                String string = dateutil.formatDate(new Date(), "MMddyyyy");
                if (!string.equalsIgnoreCase(TAgentStatus.this.BusinessDate)) {
                    TAgentStatus.this.BusinessDate = string;
                    TAgentStatus.this.FLog.dispose();
                    TAgentStatus.this.FLog = new TAspectDriver("Aspect_Agent_Status_Log", 1, true, false, "");
                }
                while (TAgentStatus.this.arQueuedStatusReports.size() > 0) {
                    TAgentStatus.this.recordAgentStatusLocally((String)TAgentStatus.this.arQueuedStatusReports.get(0), false);
                    TAgentStatus.this.arQueuedStatusReports.remove(0);
                }
                if (TFormulaEvaluator.isConnected() && TAgentStatus.this.bReportToServer && !TAgentStatus.this.MainWin.isRunningOnServer()) {
                    TAgentStatus.this.bReportToServer = false;
                    TAgentStatus.this.FLog.setActiveFilter("Do_Report_To_Server", true);
                    int n = TAgentStatus.this.FLog.getRecordCount();
                    if (n > 0) {
                        for (int i = 0; i < n && !TAgentStatus.this.bReportToServer; ++i) {
                            String string2 = (String)TAgentStatus.this.FLog.getField("Data_for_Report_To_Server", i);
                            int n2 = (Integer)TAgentStatus.this.FLog.getField("Report_To_Server_Attempts", i);
                            TAgentStatus.this.FLog.putField("Report_To_Server_Attempts", i, (Object)new Integer(n2 + 1));
                            if (TAgentStatus.reportToServer(string2)) {
                                TAgentStatus.this.FLog.putField("Time_Reported_To_Server", i, (Object)new Date());
                            } else {
                                TAgentStatus.this.bReportToServer = true;
                            }
                            TAgentStatus.this.Modified = true;
                        }
                    }
                }
                if (TAgentStatus.this.Modified) {
                    ((TAgentStatus)TAgentStatus.this).FSummary.F.updateSourceFile();
                    ((TAgentStatus)TAgentStatus.this).FLog.F.updateSourceFile();
                    TAgentStatus.this.Modified = false;
                }
                bInActionPerformed = false;
            }
        };
        TFormulaEvaluator.waitForThreadCount();
        thread.setPriority(1);
        thread.start();
    }

    private class TNotificationSent {
        String NodeID = "";
        String To = "";
        String Data = "";
        long LastSend = 0L;

        public TNotificationSent(String string, String string2, String string3) {
            this.NodeID = string;
            this.To = string2;
            this.Data = string3;
        }
    }
}

