/*
 * Decompiled with CFR 0.152.
 */
package agent;

import agent.TSensor;
import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dosutil;
import utility.security.TPasswordService;

public class TSensorList {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private static boolean Debug = false;
    private static Hashtable hashSensors = new Hashtable();
    private static ArrayList arEditFilenames = new ArrayList();
    private static long LastUpdate = 0L;
    private static boolean Updating = false;

    public static void initializeHashtable() {
        MainWin.appendToLog("TSensorList", "initializeHashtable", Thread.currentThread(), null, 3, "Initializing sensor list");
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Agent_Sensor", 1, true, false, "");
        int n = tAspectDriver.getAbsoluteRecordCount();
        for (int i = 0; i < n; ++i) {
            if (((Boolean)tAspectDriver.getFieldAbsolute("Deleted", i)).booleanValue()) continue;
            String string = (String)tAspectDriver.getFieldAbsolute("Name", i);
            if (hashSensors.containsKey(string.toUpperCase())) {
                tAspectDriver.putFieldAbsolute("Deleted", i, (Object)new Boolean(true));
                continue;
            }
            TSensor tSensor = new TSensor();
            tSensor.DiskIndex = i;
            tSensor.Name = string;
            tSensor.Document_ID = (String)tAspectDriver.getFieldAbsolute("Document_ID", i);
            tSensor.Widget_Name = (String)tAspectDriver.getFieldAbsolute("Widget_Name", i);
            tSensor.Container_Item_ID = (String)tAspectDriver.getFieldAbsolute("Container_Item_ID", i);
            tSensor.Params = (String)tAspectDriver.getFieldAbsolute("Params", i);
            tSensor.Visibility = (String)tAspectDriver.getFieldAbsolute("Visibility", i);
            tSensor.DataType = (String)tAspectDriver.getFieldAbsolute("DataType", i);
            hashSensors.put(tSensor.Name.toUpperCase(), tSensor);
            if (!Debug) continue;
            System.out.println("Added sensor: " + tSensor.toString());
        }
        tAspectDriver.dispose();
    }

    public static TSensor getSensor(String string) {
        String string2;
        if (hashSensors.size() == 0) {
            TSensorList.initializeHashtable();
        }
        if (hashSensors.containsKey(string2 = string.toUpperCase())) {
            return (TSensor)hashSensors.get(string2);
        }
        MainWin.appendToLog("TSensorList", "getSensor", Thread.currentThread(), null, 4, "Error: Could not locate sensor: " + string + ".  Forcing update of sensor list.");
        TFormulaEvaluator.getCache().purgeExpiredObjects(true);
        TSensorList.updateSensorList(true);
        string2 = string.toUpperCase();
        if (hashSensors.containsKey(string2)) {
            return (TSensor)hashSensors.get(string2);
        }
        return null;
    }

    public static boolean updateSensorList(boolean bl) {
        Object object;
        boolean bl2;
        if (Updating) {
            MainWin.appendToLog("TSensorList", "updateSensorList", Thread.currentThread(), null, 3, "updateSensorList aborted because another instance is running");
            return false;
        }
        Updating = true;
        boolean bl3 = bl2 = LastUpdate == 0L;
        if (!bl2) {
            boolean bl4 = bl2 = !dosutil.fileExists(Application.getHomeDir() + "agents/agent_sensors1.dta");
            if (Debug && bl2) {
                System.out.println("Updating sensor list because table does not exist");
            }
        }
        if (!bl2) {
            long l = charutil.ival(Application.getTokenValue("Widget_Library_Metadata_Updated"));
            boolean bl5 = bl2 = l > LastUpdate;
            if (Debug && bl2) {
                System.out.println("Updating sensor list because metadata has been updated");
            }
        }
        if (MainWin.isDevelopmentMode()) {
            if (Debug) {
                System.out.println("Checking for sensor list in open widgets.  Files to check =" + arEditFilenames.size());
            }
            for (int i = 0; i < arEditFilenames.size(); ++i) {
                File file;
                if (arEditFilenames.get(i) == null || !(file = new File((String)arEditFilenames.get(i))).exists() || file.lastModified() <= LastUpdate) continue;
                bl2 = true;
                if (!Debug) continue;
                System.out.println("Updating sensor list because widget has been modified: " + (String)arEditFilenames.get(i));
            }
        }
        if (!bl && !bl2) {
            if (Debug) {
                System.out.println("Sensor list is up to date");
            }
            Updating = false;
            return true;
        }
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Agent_Sensor", 1, true, false, "");
        if (Debug) {
            System.out.println("Creating table of existing sensors");
        }
        hashSensors.clear();
        int n = tAspectDriver.getAbsoluteRecordCount();
        for (int i = 0; i < n; ++i) {
            if (((Boolean)tAspectDriver.getFieldAbsolute("Deleted", i)).booleanValue()) continue;
            String string = (String)tAspectDriver.getFieldAbsolute("Name", i);
            if (hashSensors.containsKey(string.toUpperCase())) {
                tAspectDriver.putFieldAbsolute("Deleted", i, (Object)new Boolean(true));
                continue;
            }
            TSensor tSensor = new TSensor();
            tSensor.DiskIndex = i;
            tSensor.Name = string;
            tSensor.Document_ID = (String)tAspectDriver.getFieldAbsolute("Document_ID", i);
            tSensor.Widget_Name = (String)tAspectDriver.getFieldAbsolute("Widget_Name", i);
            tSensor.Container_Item_ID = (String)tAspectDriver.getFieldAbsolute("Container_Item_ID", i);
            tSensor.Params = (String)tAspectDriver.getFieldAbsolute("Params", i);
            tSensor.Visibility = (String)tAspectDriver.getFieldAbsolute("Visibility", i);
            tSensor.DataType = (String)tAspectDriver.getFieldAbsolute("DataType", i);
            hashSensors.put(tSensor.Name.toUpperCase(), tSensor);
            if (!Debug) continue;
            System.out.println("Added sensor: " + tSensor.toString());
        }
        if (Debug) {
            System.out.println("Found " + hashSensors.size() + " existing sensors");
        }
        arEditFilenames.clear();
        TAspectDriver tAspectDriver2 = new TAspectDriver("Widget_Library_Metadata", 0, true, false, "");
        n = tAspectDriver2.getAbsoluteRecordCount();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            boolean bl6 = (Boolean)tAspectDriver2.getFieldAbsolute("ContainsAgentSensors", i);
            if (!bl6) continue;
            object = (String)tAspectDriver2.getFieldAbsolute("Library_ID", i);
            String string = (String)tAspectDriver2.getFieldAbsolute("Name", i);
            String string2 = "DocumentID=" + (String)object + "&Widget=" + string + "&ContainerItemID=sensor_list&sensor_list=true";
            String string3 = TFormulaEvaluator.getCache().getCachedContent(0, Application.getAspectHashID(), string2, false, "127.0.0.1", "").trim();
            if (string3.toUpperCase().indexOf("INVALID RECIPIENT") >= 0) {
                MainWin.appendToLog("TSensorList", "updateSensorList", Thread.currentThread(), null, 4, "Invalid content for params: " + string2);
                MainWin.appendToLog("TSensorList", "updateSensorList", Thread.currentThread(), null, 4, "Content: " + string3);
                MainWin.appendToLog("TSensorList", "updateSensorList", Thread.currentThread(), null, 4, "Making another attempt");
                string2 = string2 + "&RAND=" + TPasswordService.generateSalt(4);
                string3 = TFormulaEvaluator.getCache().getCachedContent(0, Application.getAspectHashID(), string2, false, "127.0.0.1", "").trim();
                if (string3.toUpperCase().indexOf("INVALID RECIPIENT") >= 0) {
                    MainWin.appendToLog("TSensorList", "updateSensorList", Thread.currentThread(), null, 4, "Content is invalid after retry: " + string3);
                } else {
                    MainWin.appendToLog("TSensorList", "updateSensorList", Thread.currentThread(), null, 4, "Content is valid after retry: " + string3);
                }
            }
            if (MainWin.isDevelopmentMode()) {
                arEditFilenames.add(Application.getHomeDir() + "cache/WidgetEdit_" + (String)object + "_" + string + ".html");
            }
            if (Debug) {
                System.out.println("Found sensor list in " + (String)object + "_" + string);
                System.out.println("Contents");
                System.out.println("-----------------------------");
                System.out.println(string3);
                System.out.println("-----------------------------");
            }
            if ((stringArray = charutil.getSubStringArray(string3 = charutil.removeChar(string3, '\r'), '\n', true)) != null && stringArray.length > 0) {
                for (int j = 0; j < stringArray.length; ++j) {
                    String[] stringArray2 = charutil.getSubStringArray(stringArray[j], ',', true);
                    if (stringArray2 != null && stringArray2.length >= 4) {
                        String string4 = stringArray2[0].trim();
                        String string5 = stringArray2[1].toUpperCase().trim();
                        String string6 = stringArray2[1].trim();
                        String string7 = stringArray2[2].trim();
                        string2 = stringArray2[3].trim();
                        String string8 = stringArray2.length > 4 ? stringArray2[4] : "public";
                        String string9 = stringArray2.length > 5 ? stringArray2[5] : "text";
                        TSensor tSensor = null;
                        int n2 = -1;
                        if (hashSensors.containsKey(string5)) {
                            tSensor = (TSensor)hashSensors.get(string5);
                            n2 = tSensor.DiskIndex;
                            if (Debug) {
                                System.out.println("Sensor already exists: " + stringArray2[1] + " Visibility=" + string8);
                            }
                        } else {
                            n2 = tAspectDriver.initializeNewRecord();
                            tSensor = new TSensor();
                            tSensor.Name = stringArray2[0];
                            tSensor.DiskIndex = n2;
                            hashSensors.put(stringArray2[1].toUpperCase(), tSensor);
                            if (Debug) {
                                System.out.println("Adding new sensor: " + stringArray2[1] + " Visibility=" + string8);
                            }
                        }
                        if (!tSensor.Group.equalsIgnoreCase(string4)) {
                            tSensor.Group = string4;
                            tAspectDriver.putFieldAbsolute("Group", n2, (Object)string4);
                        }
                        if (!tSensor.Name.equalsIgnoreCase(string6)) {
                            tSensor.Name = string6;
                            tAspectDriver.putFieldAbsolute("Name", n2, (Object)string6);
                        }
                        if (!tSensor.Document_ID.equalsIgnoreCase((String)object)) {
                            tSensor.Document_ID = object;
                            tAspectDriver.putFieldAbsolute("Document_ID", n2, object);
                        }
                        if (!tSensor.Widget_Name.equalsIgnoreCase(string)) {
                            tSensor.Widget_Name = string;
                            tAspectDriver.putFieldAbsolute("Widget_Name", n2, (Object)string);
                        }
                        if (!tSensor.Container_Item_ID.equalsIgnoreCase(string7)) {
                            tSensor.Container_Item_ID = string7;
                            tAspectDriver.putFieldAbsolute("Container_Item_ID", n2, (Object)string7);
                        }
                        if (!tSensor.Params.equalsIgnoreCase(string2)) {
                            tSensor.Params = string2;
                            tAspectDriver.putFieldAbsolute("Params", n2, (Object)string2);
                        }
                        if (!tSensor.Visibility.equalsIgnoreCase(string8)) {
                            tSensor.Visibility = string8;
                            tAspectDriver.putFieldAbsolute("Visibility", n2, (Object)string8);
                        }
                        if (!tSensor.DataType.equalsIgnoreCase(string9)) {
                            tSensor.DataType = string9;
                            tAspectDriver.putFieldAbsolute("DataType", n2, (Object)string9);
                        }
                        tSensor.Exists = true;
                        continue;
                    }
                    MainWin.appendToLog("TSensorList", "updateSensorList", Thread.currentThread(), null, 4, "Invalid sensor in content: " + stringArray[j]);
                    MainWin.appendToLog("TSensorList", "updateSensorList", Thread.currentThread(), null, 3, "Params=" + string2);
                }
                continue;
            }
            MainWin.appendToLog("TSensorList", "updateSensorList", Thread.currentThread(), null, 3, "No sensors in: " + string2);
        }
        if (Debug) {
            System.out.println("Removing unused sensors");
        }
        Enumeration enumeration = hashSensors.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object = (TSensor)hashSensors.get(string);
            if (Debug) {
                System.out.println("Checking sensor: " + ((TSensor)object).toString());
            }
            if (((TSensor)object).Exists) continue;
            tAspectDriver.putFieldAbsolute("Deleted", ((TSensor)object).DiskIndex, (Object)new Boolean(true));
            if (Debug) {
                System.out.println("Removing: " + string);
            }
            hashSensors.remove(string);
        }
        tAspectDriver.dispose();
        tAspectDriver2.dispose();
        LastUpdate = new Date().getTime();
        Updating = false;
        return true;
    }
}

