/*
 * Decompiled with CFR 0.152.
 */
package aspect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class AKDockLayout
extends BorderLayout {
    private ArrayList north = new ArrayList(1);
    private ArrayList south = new ArrayList(1);
    private ArrayList east = new ArrayList(1);
    private ArrayList west = new ArrayList(1);
    public Component center = null;
    private int northHeight;
    private int southHeight;
    private int eastWidth;
    private int westWidth;
    public Object[] curImbeddedTBRs = new Object[4];
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;

    public AKDockLayout() {
        this.curImbeddedTBRs[0] = this.north;
        this.curImbeddedTBRs[1] = this.south;
        this.curImbeddedTBRs[2] = this.west;
        this.curImbeddedTBRs[3] = this.east;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object != null) {
                String string = object.toString();
                component.setVisible(true);
                if (string.equals("North")) {
                    this.north.add(component);
                } else if (string.equals("South")) {
                    this.south.add(component);
                } else if (string.equals("East")) {
                    this.east.add(component);
                } else if (string.equals("West")) {
                    this.west.add(component);
                } else if (string.equals("Center")) {
                    this.center = component;
                }
                component.getParent().validate();
            }
        }
    }

    public void clearAll() {
        this.north.clear();
        this.south.clear();
        this.east.clear();
        this.west.clear();
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.north.remove(component);
        this.south.remove(component);
        this.east.remove(component);
        this.west.remove(component);
        if (component == this.center) {
            this.center = null;
        }
        this.flipSeparators(component, 1);
        if (component.getParent() != null) {
            component.getParent().validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = insets.top;
            int n2 = container.getHeight() - insets.bottom;
            int n3 = insets.left;
            int n4 = container.getWidth() - insets.right;
            this.northHeight = this.getPreferredDimension((ArrayList)this.north).height;
            this.southHeight = this.getPreferredDimension((ArrayList)this.south).height;
            this.eastWidth = this.getPreferredDimension((ArrayList)this.east).width;
            this.westWidth = this.getPreferredDimension((ArrayList)this.west).width;
            this.placeComponents(container, this.north, n3, n, n4 - n3, this.northHeight, 1);
            this.placeComponents(container, this.south, n3, n2 - this.southHeight, n4 - n3, this.southHeight, 3);
            this.placeComponents(container, this.east, n4 - this.eastWidth, n += this.northHeight + this.getVgap(), this.eastWidth, (n2 -= this.southHeight + this.getVgap()) - n, 4);
            n4 -= this.eastWidth + this.getHgap();
            this.placeComponents(container, this.west, n3, n, this.westWidth, n2 - n, 2);
            n3 += this.westWidth + this.getHgap();
            if (this.center != null) {
                this.center.setBounds(n3, n, n4 - n3, n2 - n);
            }
        }
    }

    private Dimension getPreferredDimension(ArrayList arrayList) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Component component = (Component)arrayList.get(i);
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        return new Dimension(n, n2);
    }

    private void placeComponents(Container container, ArrayList arrayList, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        Component component = null;
        if (n5 == 1 || n5 == 3) {
            n6 = n;
            int n7 = 0;
            int n8 = 0;
            int n9 = arrayList.size();
            for (int i = 0; i < n9; ++i) {
                component = (Component)arrayList.get(i);
                this.flipSeparators(component, 1);
                int n10 = n7;
                int n11 = n8;
                n8 = component.getPreferredSize().width;
                if (n3 < (n7 += n8) && i != 0) {
                    Component component2 = (Component)arrayList.get(i - 1);
                    Rectangle rectangle = component2.getBounds();
                    component2.setBounds(rectangle.x, rectangle.y, n3 - n10 + n11, rectangle.height);
                    n6 = n;
                    if (n5 == 1) {
                        n2 += n4;
                        this.northHeight += n4;
                    } else if (n5 == 3) {
                        this.southHeight += n4;
                        n2 -= n4;
                    }
                    n7 = n8;
                }
                if (i + 1 == n9) {
                    component.setBounds(n + n6, n2, n3 - n7 + n8, n4);
                    continue;
                }
                component.setBounds(n + n6, n2, n8, n4);
                n6 += n8;
            }
            this.flipSeparators(component, 1);
        } else {
            int n12 = 0;
            int n13 = 0;
            int n14 = arrayList.size();
            for (int i = 0; i < n14; ++i) {
                component = (Component)arrayList.get(i);
                int n15 = n12;
                int n16 = n13;
                n13 = component.getPreferredSize().height;
                if (n4 < (n12 += n13) && i != 0) {
                    Component component3 = (Component)arrayList.get(i - 1);
                    Rectangle rectangle = component3.getBounds();
                    component3.setBounds(rectangle.x, rectangle.y, rectangle.width, n4 - n15 + n16);
                    if (n5 == 2) {
                        n += n3;
                        this.westWidth += n3;
                    } else if (n5 == 4) {
                        this.eastWidth += n3;
                        n -= n3;
                    }
                    n12 = n13;
                    n6 = 0;
                }
                if (n12 > n4) {
                    // empty if block
                }
                if (i + 1 == n14) {
                    component.setBounds(n, n2 + n6, n3, n4 - n12 + n13);
                    continue;
                }
                component.setBounds(n, n2 + n6, n3, n13);
                n6 += n13;
            }
            this.flipSeparators(component, 0);
        }
    }

    private void flipSeparators(Component component, int n) {
        JToolBar jToolBar;
        Component[] componentArray;
        if (component != null && component instanceof JToolBar && UIManager.getLookAndFeel().getName().toLowerCase().indexOf("windows") != -1 && (componentArray = (jToolBar = (JToolBar)component).getComponents()) != null && componentArray.length > 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                try {
                    Component component2 = componentArray[i];
                    if (component2 == null) continue;
                    if (component2 instanceof JSeparator) {
                        boolean bl = component2.isVisible();
                        jToolBar.remove(component2);
                        JSeparator jSeparator = new JSeparator();
                        jSeparator.setVisible(bl);
                        if (n == 1) {
                            jSeparator.setOrientation(1);
                            jSeparator.setMinimumSize(new Dimension(2, 6));
                            jSeparator.setPreferredSize(new Dimension(2, 6));
                            jSeparator.setMaximumSize(new Dimension(2, 100));
                        } else {
                            jSeparator.setOrientation(0);
                            jSeparator.setMinimumSize(new Dimension(6, 2));
                            jSeparator.setPreferredSize(new Dimension(6, 2));
                            jSeparator.setMaximumSize(new Dimension(100, 2));
                        }
                        jToolBar.add((Component)jSeparator, i);
                        continue;
                    }
                    if (!(component2 instanceof JProgressBar)) continue;
                    if (n == 1) {
                        ((JProgressBar)component2).setOrientation(0);
                        continue;
                    }
                    ((JProgressBar)component2).setOrientation(1);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public boolean containsImbeddedComp(Component component) {
        for (int i = 0; i < this.curImbeddedTBRs.length; ++i) {
            if (!((ArrayList)this.curImbeddedTBRs[i]).contains(component)) continue;
            return true;
        }
        return false;
    }

    public boolean containsImbeddedComp(Component component, int n) {
        return n > 0 && n < 5 && ((ArrayList)this.curImbeddedTBRs[n + 1]).contains(component);
    }
}

