/*
 * Decompiled with CFR 0.152.
 */
package aspect;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import java.util.Date;
import java.util.Properties;
import java.util.prefs.Preferences;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.dateutil;
import utility.dosutil;

public class TLocalPrefs {
    private TAspectDriver driverLocalPrefs = null;
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;

    public TLocalPrefs() {
        String string;
        String string2;
        TAppDriversObject tAppDriversObject = this.Application.AppDrivers.getAppDriversObject("ReadLocalPreferences");
        if (tAppDriversObject == null) {
            Aspect.MainWin.appendToLog("TLocalPrefs", "init", Thread.currentThread(), null, 4, "Cannot locate driver for local preferences");
        } else {
            this.driverLocalPrefs = new TAspectDriver(this.Application, tAppDriversObject, 1, false, "");
            if (this.driverLocalPrefs.getRecordCount() == 0) {
                this.initializeLocalPrefs();
            }
        }
        Preferences preferences = Preferences.systemRoot();
        try {
            string2 = "AspectHashId".toUpperCase();
            string = preferences.get(string2, "");
            if (string.length() > 0) {
                if (!string.equalsIgnoreCase(this.getHashID())) {
                    this.setHashID(string);
                }
            } else {
                preferences.put(string2, this.getHashID());
                String string3 = preferences.get(string2, "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string2 = "AspectInstallDt".toUpperCase();
            string = preferences.get(string2, "");
            if (string.length() == 0) {
                preferences.put(string2, dateutil.formatDate(new Date(), "MM-dd-yyyy"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.driverLocalPrefs != null) {
            this.driverLocalPrefs.dispose();
        }
    }

    public void initializeLocalPrefs() {
        Properties properties = System.getProperties();
        this.driverLocalPrefs.initializeNewRecord();
        String string = "c:\\aspect7\\";
        this.setHomeDirectory(string);
        this.driverLocalPrefs.putFieldAbsolute("HomeDirectory", 0, (Object)string);
    }

    public String getHomeDirectory() {
        if (this.driverLocalPrefs == null) {
            return "";
        }
        Object object = this.driverLocalPrefs.getFieldAbsolute("HomeDirectory", 0);
        if (object == null) {
            return "";
        }
        String string = this.Application.parse_tokens((String)object);
        return string.trim();
    }

    public void setHomeDirectory(String string) {
        if (this.driverLocalPrefs != null) {
            this.driverLocalPrefs.putFieldAbsolute("HomeDirectory", 0, (Object)string);
        }
    }

    public boolean getPromptForHomeDirectory() {
        return (Boolean)this.driverLocalPrefs.getFieldAbsolute("PromptForHomeDirectory", 0);
    }

    public void setPromptForHomeDirectory(boolean bl) {
        this.driverLocalPrefs.putFieldAbsolute("PromptForHomeDirectory", 0, (Object)new Boolean(bl));
    }

    public boolean getAutoUpdatePackageList() {
        return (Boolean)this.driverLocalPrefs.getFieldAbsolute("AutoUpdatePackageList", 0);
    }

    public void setAutoUpdatePackageList(boolean bl) {
        this.driverLocalPrefs.putFieldAbsolute("AutoUpdatePackageList", 0, (Object)new Boolean(bl));
    }

    public boolean getRunInSystemTray() {
        return (Boolean)this.driverLocalPrefs.getFieldAbsolute("RunInSystemTray", 0);
    }

    public boolean getCloseConsoleAfterLoading() {
        return (Boolean)this.driverLocalPrefs.getFieldAbsolute("CloseConsoleAfterLoading", 0);
    }

    public boolean getVerboseMode() {
        return (Boolean)this.driverLocalPrefs.getFieldAbsolute("VerboseMode", 0);
    }

    public boolean getAllowMultipleInstances() {
        return (Boolean)this.driverLocalPrefs.getFieldAbsolute("AllowMultipleInstances", 0);
    }

    public boolean getStartAutomatically() {
        return (Boolean)this.driverLocalPrefs.getFieldAbsolute("Start_Automatically", 0);
    }

    public boolean getStartMinimized() {
        return (Boolean)this.driverLocalPrefs.getFieldAbsolute("Start_Minimized", 0);
    }

    public boolean getEnableTaskScheduler() {
        return true;
    }

    public String getDefaultTextEditor() {
        return (String)this.driverLocalPrefs.getFieldAbsolute("DefaultTextEditor", 0);
    }

    public String getDefaultHtmlEditor() {
        String string = (String)this.driverLocalPrefs.getFieldAbsolute("DefaultHtmlEditor", 0);
        if (!dosutil.fileExists(string) && !dosutil.fileExists(string = "C:\\Program Files (x86)\\Notepad++\\notepad++.exe")) {
            string = "c:\\windows\\notepad.exe";
        }
        return string;
    }

    public String getDefaultNavigator() {
        return (String)this.driverLocalPrefs.getFieldAbsolute("DefaultNavigator", 0);
    }

    public void setDefaultNavigator(String string) {
        if (this.driverLocalPrefs != null) {
            this.driverLocalPrefs.putFieldAbsolute("DefaultNavigator", 0, (Object)string);
        }
    }

    public static String generateHashID() {
        String string = "abcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            int n = (int)Math.floor(Math.random() * 36.0);
            stringBuilder.append(string.charAt(n));
        }
        return stringBuilder.toString();
    }

    public String getHashID() {
        if (this.driverLocalPrefs == null) {
            return "";
        }
        return (String)this.driverLocalPrefs.getFieldAbsolute("HashID", 0);
    }

    public String getOrganizationName() {
        if (this.driverLocalPrefs == null) {
            return "";
        }
        return (String)this.driverLocalPrefs.getFieldAbsolute("Organization_Name", 0);
    }

    public void setHashID(String string) {
        if (this.driverLocalPrefs != null) {
            this.driverLocalPrefs.putFieldAbsolute("HashID", 0, (Object)string);
            String string2 = (String)this.driverLocalPrefs.getFieldAbsolute("HashID", 0);
        }
    }

    public int getHashCount() {
        if (this.driverLocalPrefs == null) {
            return 0;
        }
        return (Integer)this.driverLocalPrefs.getFieldAbsolute("HashCount", 0);
    }

    public void setHashCount(int n) {
        if (this.driverLocalPrefs != null) {
            this.driverLocalPrefs.putFieldAbsolute("HashCount", 0, (Object)new Integer(n));
        }
    }

    public void incrementHashCount() {
        this.setHashCount(this.getHashCount() + 1);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 5; ++i) {
            System.out.println("HashID = " + TLocalPrefs.generateHashID());
        }
    }
}

