/*
 * Decompiled with CFR 0.152.
 */
package aspect;

import aspect.AKDockLayout;
import aspect.Aspect;
import aspect.TActivityLogWriter;
import aspect.TExecDialog;
import aspect.TLocalPrefs;
import aspect.TMultipleInstanceCheck;
import aspect.TSystemTrayIcon;
import controls.TConsole;
import controls.TDesktopNavigator;
import controls.TDesktopPane;
import controls.TFrame;
import controls.TInternalFrame;
import controls.TMenuBar;
import controls.TToolBar;
import controls.ui.WrappedToolTipUI;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TPackage;
import extensions.TClassLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import networking.TNetworkSettings;
import networking.dnsserver.TDnsServerSocket;
import networking.driverserver.TDriverServer;
import networking.nameserver.TNameServer;
import pub.exec;
import reportwin.TReportWin;
import resources.TActionObject;
import resources.TAppAction;
import resources.TAppActionObject;
import resources.TAppDriversObject;
import resources.TAppMainObject;
import resources.TAppReportsObject;
import resources.TAppTablesObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import scripts.TExecScript;
import scrollwin.TScrollDialog;
import scrollwin.TScrollWin;
import scrollwin.dialogpanel.TScrollDialogPanel;
import scrollwin.filtertree.TScrollFilterTree;
import scrollwin.filtertree.TScrollFilterTreeNode;
import scrollwin.filtertree.TScrollFilterTreeNodeEvent;
import scrollwin.filtertree.TScrollFilterTreeNodeListenerInterface;
import scrollwin.table.TScrollTable;
import scrollwin.table.TScrollTablePanel;
import scrollwin.toolbar.TScrollToolbar;
import scrollwin.toolbar.TScrollToolbarDriverCmdButton;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.imageutil;
import utility.netutil;
import utility.objectutil;
import utility.taskscheduler.TTaskScheduler;

public class TMainWin
extends TFrame
implements ActionListener,
TScrollFilterTreeNodeListenerInterface {
    public static final String VERSION = "7.1129";
    public static boolean AllConnectionsLocal = false;
    public static int NextWindowID = 0;
    public static final int MAINWIN_NONE = 0;
    public static final int MAINWIN_MDI = 1;
    public static final int MAINWIN_DIALOG = 2;
    public static final int MAINWIN_FRAME = 3;
    public static final int MAINWIN_APPLET = 4;
    public TMultipleInstanceCheck MultipleInstanceCheck = null;
    ArrayList arScrollWinDriversToShow = new ArrayList();
    public static TApplication Application;
    public static TDesktopPane Desktop;
    public static TDesktopNavigator DesktopNavigator;
    public static TDesktopNavigator DesktopMessageLog;
    public static TMenuBar MainMenu;
    private static TSystemTrayIcon SystemTrayIcon;
    public static TNetworkSettings NetworkSettings;
    public static String OriginalUserDir;
    public static TDriverServer DriverServer;
    public static TNameServer NameServer;
    public static TTaskScheduler TaskScheduler;
    private static TConsole Console;
    private static Image LargeLogo;
    private static Image SmallLogo;
    public static boolean RunInSystemTray;
    public static boolean AllowMultipleInstances;
    public static boolean StartAutomatically;
    public static boolean StartMinimized;
    public static boolean EnableTaskScheduler;
    public static boolean StartNameServer;
    public static boolean StartDriverServer;
    public static boolean IsClosing;
    public static boolean CloseConsoleAfterLoading;
    public static boolean VerboseMode;
    public static boolean IsReloading;
    public static int MainWinType;
    public static boolean IsRestart;
    private static TActivityLogWriter LogDriver;
    private static int LogDriverDayOfYear;
    public static String AspectServerIP;
    public static String AspectServerPort;
    public static String AspectSSLServerPort;
    public static Date ProgramStartTime;
    public static Boolean RunningOnServer;
    public static Boolean DevelopmentMode;
    private static Boolean IsAspectServer;
    private static ArrayList arPackageID;
    private static ArrayList arDefinedPackageID;
    private static final Border DefaultButtonBorder;
    private static final Color DefaultButtonBackground;
    TAspectDriver DesktopDriver = null;
    TDesktopSplitPane NavigatorSplitPane = null;
    TDesktopSplitPane MessageLogSplitPane = null;
    private static boolean boolInRefreshPackages;
    private int ActivityLogStartIndex = 0;
    public static boolean InShowGui;
    private static boolean SettingDesktop;
    private static boolean SettingDesktopNavigator;
    private static boolean SettingDesktopMessageLog;

    public TMainWin(String string) {
        super("Aspect Software");
        this.setIconImage(this.getLargeLogo());
        Application = new TApplication(this);
        TMainWin.Application.AspectCoreUrl = string;
        this.addWindowListener(new ShutDown());
    }

    public TMainWin(String[] stringArray, String string) {
        super("Aspect Software");
        Application = new TApplication(this, stringArray);
        TMainWin.Application.AspectCoreUrl = string;
        this.addWindowListener(new ShutDown());
    }

    @Override
    public void dispose() {
        if (this.MultipleInstanceCheck != null) {
            this.MultipleInstanceCheck.dispose();
        }
        if (TaskScheduler != null) {
            TaskScheduler.dispose();
        }
        super.dispose();
    }

    public void listLookAndFeelKeys() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String)) continue;
            System.out.println("O=[" + k + "]");
        }
    }

    public void customizeLookAndFeel() {
        UIManager.put("ToolBar.border", BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    public void restoreDefaultButtons() {
        UIManager.put("Button.border", DefaultButtonBorder);
    }

    public int showConfirmDialog(Component component, Object object, String string, int n) {
        this.restoreDefaultButtons();
        int n2 = JOptionPane.showConfirmDialog(component, object, string, n);
        this.customizeLookAndFeel();
        return n2;
    }

    public int showConfirmDialog(Component component, Object object, String string, int n, int n2) {
        this.restoreDefaultButtons();
        int n3 = JOptionPane.showConfirmDialog(component, object, string, n, n2);
        this.customizeLookAndFeel();
        return n3;
    }

    public int showConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon) {
        this.restoreDefaultButtons();
        int n3 = JOptionPane.showConfirmDialog(component, object, string, n, n2, icon);
        this.customizeLookAndFeel();
        return n3;
    }

    public void startMultipleInstanceChecker() {
        this.MultipleInstanceCheck = new TMultipleInstanceCheck();
        this.MultipleInstanceCheck.start();
        while (!this.MultipleInstanceCheck.isInitialized()) {
            Thread.yield();
        }
    }

    public int isTaskSchedulerEnabled() {
        if (TaskScheduler != null && TaskScheduler.isEnabled() && this.MultipleInstanceCheck != null) {
            return this.MultipleInstanceCheck.getListeningOnPort();
        }
        return -1;
    }

    public void updateTaskScheduler() {
        if (TaskScheduler != null) {
            TaskScheduler.loadTasks();
        }
    }

    public void setExecDir(String string) {
        TMainWin.Application.ExecDirectory = string;
        String string2 = string;
        if (string2.startsWith("/") || string2.startsWith("\\")) {
            string2 = string2.substring(1, string2.length());
        }
        OriginalUserDir = System.getProperty("user.dir");
        System.setProperty("user.dir", string2);
    }

    public void setHomeDir(String string) {
        TMainWin.Application.HomeDirectory = string;
    }

    public int initializeHomeDirectory() {
        Object object;
        Object object2;
        Serializable serializable;
        TLocalPrefs tLocalPrefs = new TLocalPrefs();
        String string = tLocalPrefs.getHomeDirectory();
        boolean bl = this.isHomeDirectoryValid(string);
        if (!bl) {
            JOptionPane.showMessageDialog(null, "The home directory \n\n" + string + "\n\nis not valid.", "Information", 1);
            serializable = System.getProperties();
            object2 = (String)((Properties)serializable).get("user.home") + "\\aspect\\";
            tLocalPrefs.setHomeDirectory((String)object2);
        }
        if (!bl || tLocalPrefs.getPromptForHomeDirectory()) {
            do {
                tLocalPrefs.dispose();
                if (!TMainWin.executeDialog("EditLocalPreferences", 0).equalsIgnoreCase("ok")) {
                    return -1;
                }
                tLocalPrefs = new TLocalPrefs();
                string = tLocalPrefs.getHomeDirectory();
                bl = this.isHomeDirectoryValid(string);
                if (bl) continue;
                JOptionPane.showMessageDialog(null, "The home directory \n\n" + string + "\n\nis not valid.", "Information", 1);
            } while (!bl);
        }
        tLocalPrefs.dispose();
        Application.setHomeDirectory(string);
        try {
            serializable = new File(dosutil.addTrailingSlash(string) + "bin/service");
            ((File)serializable).mkdirs();
            object2 = new RandomAccessFile(dosutil.addTrailingSlash(string) + "bin/service/pid.csv", "rwd");
            ((RandomAccessFile)object2).seek(((RandomAccessFile)object2).length());
            object = dateutil.formatDate(new Date(), "MM-dd-yyyy HH:mm:ss") + "," + Integer.toString(dosutil.getWinPID());
            ((RandomAccessFile)object2).writeBytes((String)object + "\n");
            ((RandomAccessFile)object2).close();
        }
        catch (Exception exception) {
            System.out.println("Error writing PID");
        }
        serializable = new File(dosutil.addTrailingSlash(string) + "temporary_files");
        if (!((File)serializable).exists()) {
            ((File)serializable).mkdir();
        } else if (!((File)serializable).isDirectory()) {
            ((File)serializable).delete();
            ((File)serializable).mkdir();
        }
        TMainWin.Application.AppMain.initializePackageHashtables();
        IsRestart = new File(dosutil.addTrailingSlash(string) + "restart.txt").exists();
        if (IsRestart) {
            object2 = dosutil.addTrailingSlash(string) + "widget_library_metadata1.dta";
            object = new File((String)object2);
            if (((File)object).exists()) {
                ((File)object).delete();
                if (((File)object).exists()) {
                    System.gc();
                    ((File)object).delete();
                }
            }
            if (((File)object).exists()) {
                System.out.println("Could not delete " + (String)object2 + " after restart");
            } else {
                System.out.println("Deleted " + (String)object2 + " after restart");
            }
        }
        return 0;
    }

    public boolean isHomeDirectoryValid(String string) {
        if (string.length() == 0) {
            return false;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            return true;
        }
        if (file.isFile()) {
            return false;
        }
        try {
            boolean bl = file.mkdir();
            return bl;
        }
        catch (Exception exception) {
            this.appendToLog("TMainWin", "isHomeDirectoryValid", Thread.currentThread(), exception, 4, "Invalid home directory - " + string);
            return false;
        }
    }

    public void setExecutionMode(int n) {
        Application.setExecutionMode(n);
    }

    public boolean isEventDispatchingThread(Thread thread) {
        return thread.getName().toUpperCase().startsWith("AWT-EVENTQUEUE");
    }

    public void extractSSLCertificate() {
        String string = TMainWin.Application.AspectCoreUrl + "aspectsslcert";
        System.out.println("copy " + string + " to " + TMainWin.Application.ExecDirectory + "aspectsslcert");
        dosutil.copyFile(string, TMainWin.Application.ExecDirectory + "aspectsslcert", false);
        System.setProperty("javax.net.ssl.trustStore", TMainWin.Application.ExecDirectory + "aspectsslcert");
        System.setProperty("javax.net.ssl.keyStore", TMainWin.Application.ExecDirectory + "aspectsslcert");
        System.setProperty("javax.net.ssl.trustStorePassword", "a1g4r5");
        System.setProperty("javax.net.ssl.keyStorePassword", "a1g4r5");
    }

    public void cleanUp() {
        IsClosing = true;
        System.out.println("\n---------------------------------");
        System.out.println("* Shutting Down *");
        System.out.println("---------------------------------");
        System.out.println("Writing state...");
        this.dumpState("TMainWin", "Shut down");
        System.out.println("Shutting down open windows...");
        this.closeAllWindows();
        System.out.println("Shutting down desktop...");
        Desktop.dispose();
        System.out.println("Shutting down servers...");
        this.closeServers();
        System.out.println("Shutting down toolbars...");
        this.disposeToolbars();
        System.out.println("Deleting temporary files...");
        dosutil.deleteTempFiles();
        if (TDnsServerSocket.getInstance() != null) {
            System.out.println("Closing dns server socket...");
            TDnsServerSocket.getInstance().closeSocket();
        }
        System.out.println("Appending to log...");
        System.out.println("Closing log file...");
        if (LogDriver != null) {
            LogDriver.dispose();
        }
        LogDriver = null;
    }

    public void disposeToolbars() {
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof TToolBar)) continue;
            ((TToolBar)componentArray[i]).dispose();
        }
    }

    public void initializeSystemTokens() {
        Application.setTokenValue("$EditClickCount", "2");
        TNameServer.initializeTokens(Application);
        TDriverServer.initializeTokens(Application);
    }

    public void addToPackageList(String string) {
        for (int i = 0; i < arPackageID.size(); ++i) {
            if (!((String)arPackageID.get(i)).equalsIgnoreCase(string)) continue;
            return;
        }
        arPackageID.add(string);
    }

    public ArrayList getPackageIDs() {
        return arPackageID;
    }

    public ArrayList getDefinedPackageIDs() {
        return arDefinedPackageID;
    }

    public void updatePackageList(String string, boolean bl) {
        TPackage tPackage;
        int n;
        Object object;
        Object object2;
        if (string == null) {
            return;
        }
        TAspectDriver tAspectDriver = null;
        TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("AlternatePackageList");
        boolean bl2 = false;
        try {
            object2 = new URL(dosutil.formatURL(string));
            object = ((URL)object2).openConnection();
            if (((URLConnection)object).getContentLength() > 0) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (bl2) {
            tAspectDriver = new TAspectDriver(Application, tAppDriversObject, 0, false, string);
        }
        if (tAspectDriver == null || !tAspectDriver.isValid() || tAspectDriver.getRecordCount() == 0) {
            if (tAspectDriver != null) {
                tAspectDriver.dispose();
            }
            object2 = charutil.replaceSubstring(dosutil.getFileName(string), "_packages", "");
            object = Application.getTokenValue("packageurl_" + (String)object2) + "webfiles/" + (String)object2 + "_packages.csv";
            if (object != null) {
                bl2 = dosutil.fileExists((String)object);
                if (bl2) {
                    this.appendToLog("TMainWin", "updatePackageList", Thread.currentThread(), null, 4, "Loading local package list");
                    tAspectDriver = new TAspectDriver(Application, tAppDriversObject, 0, false, (String)object);
                    if (!tAspectDriver.isValid() || tAspectDriver.getRecordCount() == 0) {
                        tAspectDriver.dispose();
                        this.appendToLog("TMainWin", "updatePackageList", Thread.currentThread(), null, 4, "Cannot open package list from " + string + " or " + (String)object);
                        return;
                    }
                }
            } else {
                this.appendToLog("TMainWin", "updatePackageList", Thread.currentThread(), null, 4, "Cannot open package list from " + string + " or " + (String)object);
                return;
            }
        }
        tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("PackageWrapper");
        object2 = new TAspectDriver(Application, tAppDriversObject, 1, false, "");
        object = new Hashtable();
        for (n = 0; n < ((TAspectDriver)object2).getRecordCount(); ++n) {
            tPackage = new TPackage((TAspectDriver)object2, n);
            ((Hashtable)object).put(tPackage.getPackageID(), new Integer(n));
            if (!bl) continue;
            tPackage.setEnabled(false);
        }
        for (n = 0; n < tAspectDriver.getRecordCount(); ++n) {
            String[] stringArray;
            Object object3;
            tPackage = new TPackage(tAspectDriver, n);
            for (int i = 0; i < ((TAspectDriver)object2).getRecordCount(); ++i) {
                object3 = new TPackage((TAspectDriver)object2, i);
                if (!tPackage.getPackageID().equalsIgnoreCase(((TPackage)object3).getPackageID()) || tPackage.getSourceLocation().equalsIgnoreCase(((TPackage)object3).getSourceLocation())) continue;
                ((TPackage)object3).setEnabled(false);
            }
            TPackage tPackage2 = null;
            if (!tPackage.isDeleted()) {
                if (!((Hashtable)object).containsKey(tPackage.getPackageID())) {
                    tPackage2 = new TPackage((TAspectDriver)object2, ((TAspectDriver)object2).initializeNewRecord());
                    tPackage2.setPackageID(tPackage.getPackageID());
                    tPackage2.setEnabled(tPackage.getEnabled());
                    if (Application.getDevelopmentMode() == 0 && tPackage.isCorePackage()) {
                        tPackage2.setLocalLocation(Application.getTokenValue("coredir"));
                    }
                } else {
                    object3 = (Integer)((Hashtable)object).get(tPackage.getPackageID());
                    tPackage2 = new TPackage((TAspectDriver)object2, (Integer)object3);
                    if (tPackage.getEnabled()) {
                        tPackage2.setEnabled(tPackage.getEnabled());
                    }
                }
            }
            if (tPackage2 == null) continue;
            tPackage2.setSourceLocation(tPackage.getSourceLocation());
            tPackage2.setNotes(tPackage.getNotes());
            tPackage2.setPackageName(tPackage.getPackageName());
            tPackage2.setNavigatorDriverID(tPackage.getNavigatorDriverID());
            object3 = tPackage2.getLocalLocation();
            if (object3 != null && ((String)object3).length() != 0) continue;
            if (tPackage.isCorePackage()) {
                stringArray = tPackage.getPackageID();
                String string2 = stringArray.substring(new String("aspect-software.net/").length(), stringArray.length());
                tPackage2.setLocalLocation("{coredir}" + string2);
                continue;
            }
            object3 = tPackage.getSourceLocation().trim();
            if (((String)object3).length() <= 0) continue;
            stringArray = dosutil.splitPath((String)object3);
            tPackage2.setLocalLocation("{homedir}packages/" + stringArray[2] + stringArray[3]);
        }
        tAspectDriver.dispose();
        ((TAspectDriver)object2).dispose();
        TMainWin.Application.AppMain.initializePackageHashtables();
    }

    public void oldupdatePackageList(String string) {
        TPackage tPackage;
        int n;
        TAppDriversObject tAppDriversObject;
        TAspectDriver tAspectDriver;
        String string2;
        boolean bl = false;
        if (string.equalsIgnoreCase("AlternatePackageList") && (string2 = Aspect.getArg("Exclusive")) != null && string2.equalsIgnoreCase("true")) {
            bl = true;
        }
        if (!(tAspectDriver = new TAspectDriver(Application, tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject(string), 0, false, "")).isValid()) {
            this.appendToLog("TMainWin", "updatePackageList", Thread.currentThread(), null, 4, "Cannot open package list from " + tAspectDriver.FileName);
        } else if (tAspectDriver.getRecordCount() == 0) {
            this.appendToLog("TMainWin", "updatePackageList", Thread.currentThread(), null, 4, "Package list does not contain any records.");
        }
        tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("PackageWrapper");
        TAspectDriver tAspectDriver2 = new TAspectDriver(Application, tAppDriversObject, 1, false, "");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (n = 0; n < tAspectDriver2.getRecordCount(); ++n) {
            tPackage = new TPackage(tAspectDriver2, n);
            hashtable.put(tPackage.getPackageID(), new Integer(n));
            if (!bl) continue;
            tPackage.setEnabled(false);
        }
        for (n = 0; n < tAspectDriver.getRecordCount(); ++n) {
            String[] stringArray;
            TPackage tPackage2 = new TPackage(tAspectDriver, n);
            for (int i = 0; i < tAspectDriver2.getRecordCount(); ++i) {
                tPackage = new TPackage(tAspectDriver2, i);
                if (!tPackage2.getPackageID().equalsIgnoreCase(tPackage.getPackageID()) || tPackage2.getSourceLocation().equalsIgnoreCase(tPackage.getSourceLocation())) continue;
                tPackage.setEnabled(false);
            }
            tPackage = null;
            if (!tPackage2.isDeleted()) {
                if (!hashtable.containsKey(tPackage2.getPackageID())) {
                    tPackage = new TPackage(tAspectDriver2, tAspectDriver2.initializeNewRecord());
                    tPackage.setPackageID(tPackage2.getPackageID());
                    tPackage.setEnabled(tPackage2.getEnabled());
                    if (Application.getDevelopmentMode() == 0 && tPackage2.isCorePackage()) {
                        tPackage.setLocalLocation(Application.getTokenValue("coredir"));
                    }
                } else {
                    stringArray = (Integer)hashtable.get(tPackage2.getPackageID());
                    tPackage = new TPackage(tAspectDriver2, stringArray.intValue());
                    if (string.equalsIgnoreCase("AlternatePackageList") && tPackage2.getEnabled()) {
                        tPackage.setEnabled(tPackage2.getEnabled());
                    }
                }
            }
            if (tPackage == null) continue;
            tPackage.setSourceLocation(tPackage2.getSourceLocation());
            tPackage.setNotes(tPackage2.getNotes());
            tPackage.setPackageName(tPackage2.getPackageName());
            tPackage.setNavigatorDriverID(tPackage2.getNavigatorDriverID());
            string2 = tPackage.getLocalLocation();
            if (string2 != null && string2.length() != 0) continue;
            if (tPackage2.isCorePackage()) {
                stringArray = tPackage2.getPackageID();
                String string3 = stringArray.substring(new String("aspect-software.net/").length(), stringArray.length());
                tPackage.setLocalLocation("{coredir}" + string3);
                continue;
            }
            string2 = tPackage2.getSourceLocation().trim();
            if (string2.length() <= 0) continue;
            stringArray = dosutil.splitPath(string2);
            tPackage.setLocalLocation("{homedir}packages/" + stringArray[2] + stringArray[3]);
        }
        tAspectDriver.dispose();
        tAspectDriver2.dispose();
        TMainWin.Application.AppMain.initializePackageHashtables();
    }

    public void addResource(String string, int n, String string2) {
        Application.addResource(string, n, string2);
    }

    public void reloadResource(int n, String string) {
        Application.reloadResource(n, string);
    }

    public void loadLocalPackage() {
        String string = "Local";
        String string2 = Application.getHomeDir() + "packages/local/";
        Application.addResource(string, 0, string2 + "main.asp");
        Application.addResource(string, 3, string2 + "tokens.asp");
        Application.addResource(string, 1, string2 + "actions.asp");
        Application.addResource(string, 2, string2 + "menu.asp");
        Application.addResource(string, 4, string2 + "struct.asp");
        Application.addResource(string, 5, string2 + "drivers.asp");
        Application.addResource(string, 6, string2 + "collctn.asp");
        Application.addResource(string, 7, string2 + "displays.asp");
        Application.addResource(string, 8, string2 + "filters.asp");
        Application.addResource(string, 9, string2 + "dialogs.asp");
        Application.addResource(string, 13, string2 + "tables.asp");
        Application.addResource(string, 15, string2 + "reports.asp");
        Application.addResource(string, 10, string2 + "scripts.asp");
        Application.addResource(string, 11, string2 + "toolbar.asp");
        Application.addResource(string, 12, string2 + "function.asp");
        Application.addResource(string, 14, string2 + "drivercmd.asp");
        boolean bl = true;
        for (int i = 0; i < arPackageID.size(); ++i) {
            if (!((String)arPackageID.get(i)).equalsIgnoreCase("local")) continue;
            bl = false;
        }
        if (bl) {
            arPackageID.add("local");
        }
        TMainWin.Application.AppMain.initializePackageHashtables();
    }

    public void loadPackage(TPackage tPackage, boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String string = tPackage.getLocalLocation();
        String string2 = tPackage.getPackageName();
        String string3 = tPackage.getPackageID();
        boolean bl2 = false;
        if (string.trim().length() == 0) {
            return;
        }
        if (new File(string).exists()) {
            bl2 = true;
        }
        if (!bl2 || bl) {
            n = tPackage.updatePackage(stringBuilder, false);
        } else {
            stringBuilder.append("Ok");
        }
        if (!tPackage.verifyPackage() && tPackage.downloadFromServer()) {
            n = 3;
            stringBuilder.setLength(0);
            stringBuilder.append("Ok");
        }
        String string4 = dosutil.addTrailingSlash(string);
        string4 = charutil.replaceChar(string4, '\\', '/');
        if (VerboseMode) {
            this.appendToLog("TMainWin", "loadPackage", Thread.currentThread(), null, 7, "\nLoading package: " + string + " (" + stringBuilder + ")");
        } else {
            this.appendToLog("TMainWin", "loadPackage", Thread.currentThread(), null, 7, "Loading " + string2 + " (" + stringBuilder + ")");
        }
        Application.addResource(string3, 0, string4 + "main.asp");
        Application.addResource(string3, 3, string4 + "tokens.asp");
        Application.addResource(string3, 1, string4 + "actions.asp");
        Application.addResource(string3, 2, string4 + "menu.asp");
        Application.addResource(string3, 4, string4 + "struct.asp");
        Application.addResource(string3, 5, string4 + "drivers.asp");
        Application.addResource(string3, 6, string4 + "collctn.asp");
        Application.addResource(string3, 7, string4 + "displays.asp");
        Application.addResource(string3, 8, string4 + "filters.asp");
        Application.addResource(string3, 9, string4 + "dialogs.asp");
        Application.addResource(string3, 13, string4 + "tables.asp");
        Application.addResource(string3, 15, string4 + "reports.asp");
        Application.addResource(string3, 10, string4 + "scripts.asp");
        Application.addResource(string3, 11, string4 + "toolbar.asp");
        Application.addResource(string3, 12, string4 + "function.asp");
        Application.addResource(string3, 14, string4 + "drivercmd.asp");
    }

    public void loadMainResource() {
        String string = TMainWin.Application.AspectCoreUrl + "core/main.asp";
        System.out.println("\n--------------------------------------");
        System.out.println("Loading Main: " + string);
        System.out.println("--------------------------------------");
        Application.addResource("aspect_software_net_core", 0, string);
        this.initializeSystemTokens();
    }

    public void loadAspectPackage(String string) {
        this.appendToLog("TMainWin", "loadPackage", Thread.currentThread(), null, 7, "Loading " + string + " resources...");
        Application.addResource("aspect_software_net_" + string, 3, TMainWin.Application.AspectCoreUrl + string + "/tokens.asp");
        Application.addResource("aspect_software_net_" + string, 1, TMainWin.Application.AspectCoreUrl + string + "/actions.asp");
        Application.addResource("aspect_software_net_" + string, 2, TMainWin.Application.AspectCoreUrl + string + "/menu.asp");
        Application.addResource("aspect_software_net_" + string, 4, TMainWin.Application.AspectCoreUrl + string + "/struct.asp");
        Application.addResource("aspect_software_net_" + string, 5, TMainWin.Application.AspectCoreUrl + string + "/drivers.asp");
        Application.addResource("aspect_software_net_" + string, 6, TMainWin.Application.AspectCoreUrl + string + "/collctn.asp");
        Application.addResource("aspect_software_net_" + string, 7, TMainWin.Application.AspectCoreUrl + string + "/displays.asp");
        Application.addResource("aspect_software_net_" + string, 8, TMainWin.Application.AspectCoreUrl + string + "/filters.asp");
        Application.addResource("aspect_software_net_" + string, 9, TMainWin.Application.AspectCoreUrl + string + "/dialogs.asp");
        Application.addResource("aspect_software_net_" + string, 13, TMainWin.Application.AspectCoreUrl + string + "/tables.asp");
        Application.addResource("aspect_software_net_" + string, 15, TMainWin.Application.AspectCoreUrl + string + "/reports.asp");
        Application.addResource("aspect_software_net_" + string, 10, TMainWin.Application.AspectCoreUrl + string + "/scripts.asp");
        Application.addResource("aspect_software_net_" + string, 11, TMainWin.Application.AspectCoreUrl + string + "/toolbar.asp");
        Application.addResource("aspect_software_net_" + string, 12, TMainWin.Application.AspectCoreUrl + string + "/function.asp");
        Application.addResource("aspect_software_net_" + string, 14, TMainWin.Application.AspectCoreUrl + string + "/drivercmd.asp");
        if (string.equalsIgnoreCase("core")) {
            // empty if block
        }
    }

    public void loadOtherPackages(boolean bl) {
        TPackage tPackage;
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("PackageWrapper");
        if (tAppDriversObject == null) {
            return;
        }
        TAspectDriver tAspectDriver = new TAspectDriver(Application, tAppDriversObject, 0, false, "");
        arDefinedPackageID.clear();
        arDefinedPackageID.add("aspect_software_net");
        for (n = 0; n < tAspectDriver.getRecordCount(); ++n) {
            tPackage = new TPackage(tAspectDriver, n);
            if (!arDefinedPackageID.contains(tPackage.getPackageID())) {
                if (tPackage.getEnabled() && !tPackage.isDeleted() && !tPackage.isCorePackage()) {
                    arrayList.add(new Integer(tPackage.getVirtualIndex()));
                }
                if (tPackage.isDeleted()) continue;
                arDefinedPackageID.add(tPackage.getPackageID());
                continue;
            }
            this.appendToLog("TMainWin", "loadOtherPackages", Thread.currentThread(), null, 3, "Not loading duplicate package[" + n + "]: " + tPackage.getPackageID());
        }
        Collections.sort(arrayList);
        arPackageID.clear();
        arPackageID.add("aspect_software_net");
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
                tPackage = new TPackage(tAspectDriver, i);
                if (tPackage.getVirtualIndex() != ((Integer)arrayList.get(n)).intValue()) continue;
                this.loadPackage(tPackage, bl);
                arPackageID.add(tPackage.getPackageID());
            }
        }
        if (!arPackageID.contains("aspect_software_net_core")) {
            arPackageID.add("aspect_software_net_core");
        }
        tAspectDriver.dispose();
    }

    public String enablePackage(String string) {
        TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("PackageWrapper");
        if (tAppDriversObject != null) {
            TAspectDriver tAspectDriver = new TAspectDriver(Application, tAppDriversObject, 0, false, "");
            for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
                TPackage tPackage = new TPackage(tAspectDriver, i);
                if (!tPackage.getEnabled() || tPackage.isDeleted() || tPackage.isCorePackage() || !tPackage.getPackageID().equalsIgnoreCase(string)) continue;
                TExecScript tExecScript = new TExecScript("Aspect_Core_reloadPackage", null, new TFormulaEvaluator(Application));
                String[] stringArray = new String[]{"PackageID=" + tPackage.getPackageID()};
                tExecScript.setParameters(stringArray);
                tExecScript.start();
                return "ok";
            }
        } else {
            return "Cannot locate driver: PackageWrapper";
        }
        return "Package not found: " + string;
    }

    public String refreshPackages() {
        if (boolInRefreshPackages) {
            return "Already refreshing packages";
        }
        boolInRefreshPackages = true;
        Thread thread = new Thread(){

            @Override
            public void run() {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                String string = "";
                int n = 0;
                TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("PackageWrapper");
                if (tAppDriversObject != null) {
                    int n2;
                    TAspectDriver tAspectDriver = new TAspectDriver(Application, tAppDriversObject, 0, false, "");
                    for (n2 = 0; n2 < tAspectDriver.getRecordCount(); ++n2) {
                        TPackage tPackage = new TPackage(tAspectDriver, n2);
                        if (!tPackage.getEnabled() || tPackage.isDeleted() || tPackage.isCorePackage()) continue;
                        arrayList.add(new Integer(tPackage.getVirtualIndex()));
                    }
                    Collections.sort(arrayList);
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
                            String[] stringArray;
                            TPackage tPackage = new TPackage(tAspectDriver, i);
                            if (tPackage.getVirtualIndex() != ((Integer)arrayList.get(n2)).intValue()) continue;
                            StringBuilder stringBuilder = new StringBuilder();
                            int n3 = tPackage.updatePackage(stringBuilder, false);
                            boolean bl = false;
                            if (!tPackage.verifyPackage()) {
                                bl = tPackage.downloadFromServer();
                            }
                            if (!bl && n3 != 3) continue;
                            Hashtable<String, String> hashtable = new Hashtable<String, String>();
                            for (int j = 0; j < TMainWin.Application.AppToken.ResourceColl.size(); ++j) {
                                stringArray = (String[])TMainWin.Application.AppToken.ResourceColl.get(j);
                                if (!stringArray.Persist) continue;
                                hashtable.put(stringArray.TokenID, stringArray.Value.toString());
                            }
                            TExecScript tExecScript = new TExecScript("Aspect_Core_reloadPackage", null, new TFormulaEvaluator(Application));
                            stringArray = new String[]{"PackageID=" + tPackage.getPackageID()};
                            tExecScript.setParameters(stringArray);
                            tExecScript.executeScript();
                            Enumeration enumeration = hashtable.keys();
                            while (enumeration.hasMoreElements()) {
                                String string2 = (String)enumeration.nextElement();
                                Application.setTokenValue(string2, (String)hashtable.get(string2));
                            }
                            if (string.length() > 0) {
                                string = string + "|";
                            }
                            string = string + tPackage.getPackageID();
                            ++n;
                        }
                    }
                    tAspectDriver.dispose();
                    if (n > 0) {
                        TDriverStruct.clearHashedStructures();
                        TExecScript tExecScript = new TExecScript("Aspect_Common_Merge_Supporting_Drivers", null, new TFormulaEvaluator(Application));
                        tExecScript.start();
                    }
                }
                boolInRefreshPackages = false;
            }
        };
        thread.setPriority(1);
        thread.start();
        return "ok";
    }

    public void oldloadOtherPackages(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("PackageWrapper");
        if (tAppDriversObject == null) {
            return;
        }
        TAspectDriver tAspectDriver = new TAspectDriver(Application, tAppDriversObject, 0, false, "");
        for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
            TPackage tPackage = new TPackage(tAspectDriver, i);
            if (!tPackage.getEnabled() || tPackage.isDeleted() || tPackage.isCorePackage()) continue;
            this.loadPackage(tPackage, bl);
        }
        tAspectDriver.dispose();
    }

    public void updateLocalDisplays() {
        Application.updateLocalDisplays();
    }

    public String getActivityLogContents(int n, String string) {
        return LogDriver.getActivityLogContents(n, string);
    }

    public void showConsole(boolean bl) {
        if (Console == null) {
            Console = new TConsole();
            Console.init();
            Console.pack();
            Console.setLocationRelativeTo(null);
            Console.setDefaultCloseOperation(1);
        }
        if (Console.isVisible() != bl) {
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Console.setVisible(true);
                    }
                });
            } else {
                Console.setVisible(false);
            }
        } else if (bl) {
            Console.toFront();
        }
    }

    public void clearConsole() {
        Console.clearText();
    }

    public void appendToConsole(String string) {
        if (Console != null && Console.isVisible()) {
            Console.appendText(string + "\n");
        }
    }

    public static void httpRequest(String string) {
        TExecScript tExecScript = new TExecScript("Aspect_Core_HttpRequest", null, new TFormulaEvaluator(Application));
        String[] stringArray = new String[]{"Network=Aspect&ID=Aspect&Message=" + string};
        tExecScript.setParameters(stringArray);
        tExecScript.start();
    }

    public boolean _isAspectServer() {
        if (IsAspectServer == null) {
            IsAspectServer = Boolean.FALSE;
            for (int i = 0; i < arPackageID.size(); ++i) {
                if (!((String)arPackageID.get(i)).equalsIgnoreCase("aspect_server")) continue;
                IsAspectServer = Boolean.TRUE;
            }
        }
        return IsAspectServer;
    }

    public boolean isRunningOnServer() {
        if (RunningOnServer == null) {
            return false;
        }
        return RunningOnServer;
    }

    public boolean isDevelopmentMode() {
        if (DevelopmentMode == null) {
            return false;
        }
        return DevelopmentMode;
    }

    public boolean isSupport() {
        ArrayList arrayList = this.getPackageIDs();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!((String)arrayList.get(i)).equalsIgnoreCase("aspect_support")) continue;
            return true;
        }
        return false;
    }

    public String dumpState(String string, String string2) {
        String string3 = "";
        if (LogDriver != null) {
            string3 = LogDriver.dumpState(string, string2);
        }
        return string3;
    }

    public TActivityLogWriter getLogDriver() {
        return LogDriver;
    }

    public void openLogDriver() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        LogDriverDayOfYear = gregorianCalendar.get(6);
        DateFormat dateFormat = DateFormat.getInstance();
        ((SimpleDateFormat)dateFormat).applyPattern("yyyyMMdd");
        String string = dateFormat.format(date);
        Application.setTokenValue("AspectCoreActivityLogDate", string);
        LogDriver = new TActivityLogWriter(date);
        this.appendToLog("TMainWin", "openLogDriver", Thread.currentThread(), null, 1, "Aspect started");
    }

    public boolean clearActivityLog() {
        if (LogDriver == null) {
            return false;
        }
        return LogDriver.clear();
    }

    public synchronized int appendToLog(String string, String string2, Thread thread, Throwable throwable, int n, String string3) {
        return this.appendToLog(string, string2, thread, throwable, n, string3, "", "", 0, false, 0L, 0L);
    }

    public synchronized int appendToLog(String string, String string2, Thread thread, Throwable throwable, int n, String string3, String string4, String string5, int n2, String string6, long l, long l2) {
        return this.appendToLog(string, string2, thread, throwable, n, string3, "", "", 0, false, "", (int)l2, (int)l, string6, 0, "", "", 0, 0, "", "", "", 0, "", "", string4, string5, n2, "", "", "", "");
    }

    public synchronized int appendToLog(String string, String string2, Thread thread, Throwable throwable, int n, String string3, String string4, String string5, long l, long l2, String string6, String string7, String string8, String string9) {
        return this.appendToLog(string, string2, thread, throwable, n, string3, "", "", 0, false, "", (int)l2, (int)l, string5, 0, "", "", 0, 0, "", "", "", 0, "", string4, "", "", 0, string6, string7, string8, string9);
    }

    public synchronized int appendToLog(String string, String string2, Thread thread, Throwable throwable, int n, String string3, String string4, String string5, int n2, boolean bl, long l, long l2) {
        return this.appendToLog(string, string2, thread, throwable, n, string3, string4, string5, n2, bl, "", (int)l2, (int)l, "", 0, "", "", 0, 0, "", "", "", 0, "", "", "", "", 0, "", "", "", "");
    }

    public synchronized int appendToLog(String string, String string2, Thread thread, Throwable throwable, int n, String string3, String string4, String string5, int n2, int n3, String string6, String string7, String string8, long l, int n4, String string9, long l2) {
        return this.appendToLog(string, string2, thread, throwable, n, string3, "", "", 0, false, "", (int)l2, (int)l, "", 0, string4, string5, n2, n3, string6, string7, string8, n4, string9, "", "", "", 0, "", "", "", "");
    }

    public synchronized int appendToLog(String string, String string2, Thread thread, Throwable throwable, int n, String string3, String string4, String string5, int n2, boolean bl, String string6, int n3, int n4, String string7, int n5) {
        return this.appendToLog(string, string2, thread, throwable, n, string3, "", "", 0, false, string6, n3, n4, string7, n5, "", "", 0, 0, "", "", "", 0, "", "", "", "", 0, "", "", "", "");
    }

    public synchronized int appendToLog(String string, String string2, Thread thread, Throwable throwable, int n, String string3, String string4, String string5, int n2, boolean bl, String string6, int n3, int n4, String string7, int n5, String string8, String string9, int n6, int n7, String string10, String string11, String string12, int n8, String string13, String string14, String string15, String string16, int n9, String string17, String string18, String string19, String string20) {
        if (string3.length() == 0) {
            if (!IsClosing) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Application.setTokenValue("$ActivityLogLastWrite", "");
                    }
                });
            }
            return -1;
        }
        if (Console != null) {
            Console.appendText(string3 + "\n");
        }
        if (LogDriver != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(new Date());
            if (gregorianCalendar.get(6) != LogDriverDayOfYear) {
                LogDriver.dispose();
                this.openLogDriver();
            }
            LogDriver.appendToLog(string, string2, thread, throwable, n, string3, string4, string5, n2, bl, string6, n3, n4, string7, n5, string8, string9, n6, n7, string10, string11, string12, n8, string13, string14, string15, string16, n9, string17, string18, string19, string20);
            return 1;
        }
        if (!IsClosing && n != 11) {
            StringBuilder stringBuilder = new StringBuilder(string3);
            StringBuilder stringBuilder2 = new StringBuilder();
            while (stringBuilder.charAt(0) == '\n') {
                stringBuilder.deleteCharAt(0);
                System.out.println();
            }
            while (stringBuilder.charAt(0) == '\t') {
                stringBuilder.deleteCharAt(0);
            }
            if (throwable != null) {
                stringBuilder2.append(" [Exception: " + throwable.toString() + "] ");
            }
            stringBuilder2.append((CharSequence)stringBuilder);
            System.out.println(stringBuilder2);
        }
        return -1;
    }

    public void clearStatusMessage() {
        Application.setTokenValue("$ActivityLogLastWrite", "");
    }

    public void closeServers() {
        if (DriverServer != null) {
            System.out.println("  Closing Driver server");
            DriverServer.endTask();
            while (true) {
                if (TDriverServer.IsTerminated) break;
                dosutil.sleep(Thread.currentThread(), 10);
            }
            DriverServer = null;
        }
        if (NameServer != null) {
            System.out.println("  Closing DNS server");
            NameServer.endTask();
            while (true) {
                if (TNameServer.IsTerminated) break;
                dosutil.sleep(Thread.currentThread(), 10);
            }
            NameServer = null;
        }
    }

    public Image getLargeLogo() {
        if (LargeLogo != null) {
            return LargeLogo;
        }
        String string = Aspect.getArg("Logo32Url");
        if (string != null) {
            string = Application.parse_tokens(string);
        }
        if (!(string != null && string.length() != 0 && dosutil.fileExists(string) || (string = Aspect.getArg("Logo32UrlAlt")) != null && string.length() != 0 && dosutil.fileExists(string))) {
            string = "/images/pyramid32x32.gif";
        }
        LargeLogo = imageutil.getScaledImage(this.getClass(), string, -1, -1);
        return LargeLogo;
    }

    public Image getSmallLogo() {
        if (SmallLogo != null) {
            return SmallLogo;
        }
        String string = Aspect.getArg("Logo16Url");
        if (!(string != null && string.length() != 0 && dosutil.fileExists(string) || (string = Aspect.getArg("Logo16UrlAlt")) != null && string.length() != 0 && dosutil.fileExists(string))) {
            string = "/images/pyramid16x16.gif";
        }
        SmallLogo = imageutil.getScaledImage(this.getClass(), string, -1, -1);
        return SmallLogo;
    }

    public void setTooltipLookAndFeel() {
        ((WrappedToolTipUI)WrappedToolTipUI.createUI(null)).setMaxWidth(300);
        UIManager.put("ToolTipUI", "controls.ui.WrappedToolTipUI");
        UIManager.put("ToolTip.font", new Font("Arial", 0, 12));
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        ToolTipManager.sharedInstance().setEnabled(true);
        Border border = BorderFactory.createLineBorder(Color.BLACK, 1);
        Border border2 = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
        UIManager.put("ToolTip.border", compoundBorder);
    }

    public void setLookAndFeel() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "java|windows|gtk|motif|system";
        this.setTooltipLookAndFeel();
        try {
            if (Application.getTokenValue(stringBuilder, "LookAndFeel") > 0) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                int n = charutil.get_substring_index(stringBuilder, string.toString(), '|');
                switch (n) {
                    case 0: {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                        break;
                    }
                    case 1: {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                        break;
                    }
                    case 2: {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                        break;
                    }
                    case 3: {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        UIManager.setLookAndFeel(stringBuilder.toString());
                        break;
                    }
                }
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void refreshViewTree() {
        if (DesktopNavigator == null) {
            return;
        }
        if (DesktopNavigator.getDesktopPanel() == null) {
            return;
        }
        Component[] componentArray = DesktopNavigator.getDesktopPanel().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JScrollPane)) continue;
            Component[] componentArray2 = ((JScrollPane)componentArray[i]).getViewport().getComponents();
            for (int j = 0; j < componentArray2.length; ++j) {
                if (!(componentArray2[j] instanceof TScrollFilterTree)) continue;
                ((TScrollFilterTree)componentArray2[j]).initializeTree();
            }
        }
    }

    public void showDesktopPane(boolean bl) {
        if (this.NavigatorSplitPane == null) {
            return;
        }
        if (bl) {
            if (this.NavigatorSplitPane.getDividerLocation() < 100) {
                this.NavigatorSplitPane.setDividerLocation(250);
            }
        } else {
            this.NavigatorSplitPane.setDividerLocation(0);
        }
    }

    public void toggleDesktopPane() {
        if (this.NavigatorSplitPane == null) {
            return;
        }
        int n = this.NavigatorSplitPane.getDividerLocation();
        if (n <= 1) {
            this.showDesktopPane(true);
        } else {
            this.showDesktopPane(false);
        }
    }

    public void showStatusPane(boolean bl) {
        if (this.MessageLogSplitPane == null) {
            return;
        }
        if (bl) {
            this.MessageLogSplitPane.setDividerLocation(0);
        } else {
            this.MessageLogSplitPane.setDividerLocation(TMainWin.Desktop.getSize().height + TMainWin.DesktopMessageLog.getSize().height);
        }
    }

    public void createAndShowGUI(boolean bl) {
        Object object;
        int n;
        TLocalPrefs tLocalPrefs = new TLocalPrefs();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 640;
        int n3 = 480;
        Dimension dimension = null;
        boolean bl2 = true;
        if (!Application.isValid()) {
            return;
        }
        Application.getTokenValue(stringBuilder, "MainWinType");
        MainWinType = 1;
        if (!charutil.nullstr(stringBuilder) && (n = charutil.get_substring_index(stringBuilder, "None|MDI|Dialog|Frame|Applet", '|')) >= 0) {
            MainWinType = n;
        }
        if (MainWinType == 0) {
            return;
        }
        this.setLookAndFeel();
        RunInSystemTray = tLocalPrefs.getRunInSystemTray();
        if (Application.getDevelopmentMode() == 0) {
            // empty if block
        }
        if (RunInSystemTray) {
            this.setDefaultCloseOperation(1);
            if (!bl) {
                // empty if block
            }
        } else {
            this.setDefaultCloseOperation(3);
        }
        if (!bl) {
            object = Toolkit.getDefaultToolkit().getScreenSize();
            n2 = (int)((double)((Dimension)object).width * 0.8);
            n3 = (int)((double)((Dimension)object).height * 0.8);
            if (Application.getTokenValue(stringBuilder, "MainWinWidth") > 0) {
                n2 = Integer.parseInt(stringBuilder.toString());
            }
            if (Application.getTokenValue(stringBuilder, "MainWinHeight") > 0) {
                n3 = Integer.parseInt(stringBuilder.toString());
            }
            if ((double)n2 > (double)((Dimension)object).width * 0.8) {
                n2 = (int)((double)((Dimension)object).width * 0.8);
            }
            if ((double)n3 > (double)((Dimension)object).height * 0.8) {
                n3 = (int)((double)((Dimension)object).height * 0.8);
            }
            if (Application.getTokenValue("Aspect_Common_EnableViewTree").equalsIgnoreCase("false")) {
                bl2 = false;
            }
            if (Application.getDevelopmentMode() == 0) {
                bl2 = true;
            }
            this.setSize(n2, n3);
            this.setPreferredSize(new Dimension(n2, n3));
        }
        dimension = new Dimension(n2, n3);
        if (this.isRunningOnServer()) {
            this.setTitle("Aspect Software - Server v" + Application.getTokenValue("AspectCoreVersion"));
        } else if (Application.getTokenValue(stringBuilder, "MainWinTitle") > 0) {
            String string = charutil.removeQuotes(stringBuilder.toString());
            if (Application.getDevelopmentMode() == 0) {
                string = string + " (Development Mode)";
            }
            this.setTitle(string);
        }
        object = new Thread(){

            @Override
            public void run() {
                TMainWin.this.setIconImage(TMainWin.this.getLargeLogo());
            }
        };
        ((Thread)object).setPriority(1);
        ((Thread)object).start();
        if (!bl) {
            this.getContentPane().setLayout(new AKDockLayout());
        }
        Application.parse_tokens(stringBuilder, "{MainWinMenu}");
        MainMenu = TMainWin.Application.AppMenu.createMainMenu(stringBuilder.toString());
        this.setJMenuBar(MainMenu);
        Container container = this.getContentPane();
        if (this.NavigatorSplitPane != null) {
            container = Desktop.getContentPanel();
        }
        String string = "";
        Iterator iterator = Application.getIterator(11);
        while (iterator.hasNext()) {
            TAppToolbarObject tAppToolbarObject = (TAppToolbarObject)iterator.next();
            if (charutil.strcmpi(tAppToolbarObject.ToolbarID, string) == 0) continue;
            if (tAppToolbarObject.IncludeInMain && (bl2 || !tAppToolbarObject.ToolbarID.equalsIgnoreCase("Aspect_Common_Toolbar_Header"))) {
                TScrollToolbar tScrollToolbar = TMainWin.Application.AppToolbar.makeToolbar(this, tAppToolbarObject.ToolbarID);
                switch (tAppToolbarObject.Location) {
                    case 0: 
                    case 1: {
                        container.add((Component)tScrollToolbar, "North");
                        break;
                    }
                    case 2: {
                        tScrollToolbar.setOrientation(1);
                        tScrollToolbar.updateUI();
                        container.add((Component)tScrollToolbar, "West");
                        break;
                    }
                    case 3: {
                        container.add((Component)tScrollToolbar, "South");
                        break;
                    }
                    case 4: {
                        tScrollToolbar.setOrientation(1);
                        tScrollToolbar.updateUI();
                        container.add((Component)tScrollToolbar, "East");
                        break;
                    }
                    case 5: {
                        this.getContentPane().add((Component)tScrollToolbar, "North");
                        break;
                    }
                    case 6: {
                        this.getContentPane().add((Component)tScrollToolbar, "South");
                    }
                }
            }
            string = tAppToolbarObject.ToolbarID.toString();
        }
        if (!bl) {
            this.appendToLog("TMainWin", "createAndShowGUI", Thread.currentThread(), null, 3, "Initializing desktop");
            Desktop = new TDesktopPane(this);
            Desktop.setPreferredSize(new Dimension(n2, n3));
            Desktop.setBackground(this.getBackground());
            Desktop.setDoubleBuffered(true);
            if (bl2) {
                TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("Aspect_Common_Desktop");
                DesktopNavigator = new TDesktopNavigator(this);
                DesktopNavigator.setSize(dimension);
                DesktopNavigator.setPreferredSize(new Dimension(n2, n3));
                DesktopNavigator.addBackgroundPanel(tAppDriversObject.DriverID.toString());
                this.NavigatorSplitPane = new TDesktopSplitPane(1);
                this.NavigatorSplitPane.setUI(new TDesktopSplitPaneUI(1));
                this.NavigatorSplitPane.setDividerLocation(0);
                this.NavigatorSplitPane.setDividerSize(7);
                this.NavigatorSplitPane.setOneTouchExpandable(true);
                this.NavigatorSplitPane.setContinuousLayout(true);
                boolean bl3 = false;
                if (bl3) {
                    this.MessageLogSplitPane = new TDesktopSplitPane(0);
                    this.MessageLogSplitPane.setUI(new TDesktopSplitPaneUI(0));
                    this.MessageLogSplitPane.setDividerLocation(dimension.height);
                    this.MessageLogSplitPane.setDividerSize(7);
                    this.MessageLogSplitPane.setOneTouchExpandable(true);
                    this.MessageLogSplitPane.setContinuousLayout(true);
                }
                this.NavigatorSplitPane.setTopComponent(DesktopNavigator);
                this.NavigatorSplitPane.setBottomComponent(Desktop);
                if (bl3) {
                    this.MessageLogSplitPane.setTopComponent(this.NavigatorSplitPane);
                    this.MessageLogSplitPane.setBottomComponent(DesktopMessageLog);
                    this.getContentPane().add((Component)this.MessageLogSplitPane, "Center");
                } else {
                    this.getContentPane().add((Component)this.NavigatorSplitPane, "Center");
                }
            } else {
                Desktop.setSize(dimension);
                Desktop.setPreferredSize(new Dimension(n2, n3));
                this.getContentPane().add((Component)Desktop, "Center");
            }
        }
        Desktop.addBackgroundPanel(Application.getTokenValue("DefaultNavigator"));
        this.enableScrollwinCommands(false);
        this.enableMainWinToolbarDriverCommands(false, null);
    }

    public void showGUI() {
        this.setLocationRelativeTo(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InShowGui = true;
                TMainWin.this.pack();
                String string = Application.getHomeDir() + "restart.txt";
                File file = new File(string);
                if (file.exists()) {
                    TMainWin.this.setState(1);
                } else if (StartMinimized) {
                    TMainWin.this.setState(1);
                }
                TMainWin.this.setVisible(true);
                Application.setTokenValue("AspectGuiDisplayed", "yes");
                InShowGui = false;
            }
        });
    }

    public void initializeSystemTray() {
        this.appendToLog("TMainWin", "initializeSystemTray", Thread.currentThread(), null, 3, "initializeSystemTray() started");
        try {
            if (RunInSystemTray) {
                SystemTrayIcon = new TSystemTrayIcon(this);
            }
        }
        catch (Exception exception) {
            this.appendToLog("TMainWin", "initializeSystemTray", Thread.currentThread(), exception, 4, "Error in initializeSystemTray()");
        }
    }

    @Override
    public void filterTreeNodeChanged(TScrollFilterTreeNodeEvent tScrollFilterTreeNodeEvent) {
        TScrollFilterTreeNode tScrollFilterTreeNode = tScrollFilterTreeNodeEvent.getSource();
        String string = "TreeNodeSelected_" + tScrollFilterTreeNode.DriverID;
        if (TMainWin.Application.AppScripts.isResourceDefined(string)) {
            TExecScript tExecScript = new TExecScript(string, null, null);
            tExecScript.setParameters(Integer.toString(tScrollFilterTreeNode.Record));
            tExecScript.start();
        } else {
            System.out.println("Script not defined: " + string);
        }
    }

    public TScrollToolbar getToolbar(String string) {
        int n = this.getContentPane().getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getContentPane().getComponent(i);
            if (!(component instanceof TScrollToolbar)) continue;
            TScrollToolbar tScrollToolbar = (TScrollToolbar)component;
            if (!tScrollToolbar.ID.equalsIgnoreCase(string)) continue;
            return (TScrollToolbar)component;
        }
        if (Desktop != null) {
            return Desktop.getToolbar(string);
        }
        return null;
    }

    public ArrayList getActiveToolbars() {
        ArrayList<Component> arrayList = null;
        int n = this.getContentPane().getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getContentPane().getComponent(i);
            if (!(component instanceof TScrollToolbar)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Component>();
            }
            arrayList.add(component);
        }
        return arrayList;
    }

    public String enableToolbar(String string, boolean bl) {
        if (bl) {
            if (this.getToolbar(string) != null) {
                return "ok";
            }
            ArrayList arrayList = Application.getResourceElements(11, string);
            if (arrayList == null || arrayList.size() == 0) {
                String string2 = "Unrecognized or empty toolbar ID: " + string;
                this.appendToLog("TMainWin", "enableToolbar", Thread.currentThread(), null, 4, string2);
                return string2;
            }
            Container container = this.getContentPane();
            if (this.NavigatorSplitPane != null) {
                container = Desktop.getContentPanel();
            }
            TScrollToolbar tScrollToolbar = TMainWin.Application.AppToolbar.makeToolbar(this, string);
            TAppToolbarObject tAppToolbarObject = (TAppToolbarObject)arrayList.get(0);
            switch (tAppToolbarObject.Location) {
                case 0: 
                case 1: {
                    container.add((Component)tScrollToolbar, "North");
                    break;
                }
                case 2: {
                    tScrollToolbar.setOrientation(1);
                    tScrollToolbar.updateUI();
                    container.add((Component)tScrollToolbar, "West");
                    break;
                }
                case 3: {
                    container.add((Component)tScrollToolbar, "South");
                    break;
                }
                case 4: {
                    tScrollToolbar.setOrientation(1);
                    tScrollToolbar.updateUI();
                    container.add((Component)tScrollToolbar, "East");
                    break;
                }
                case 5: {
                    this.getContentPane().add((Component)tScrollToolbar, "North");
                    break;
                }
                case 6: {
                    this.getContentPane().add((Component)tScrollToolbar, "South");
                    break;
                }
                default: {
                    System.out.println("Unrecognized toolbar layout");
                }
            }
            tScrollToolbar.setVisible(true);
            Desktop.resizeComponents();
            if (DesktopNavigator != null) {
                DesktopNavigator.resizeComponents();
            }
            if (DesktopMessageLog != null) {
                DesktopMessageLog.resizeComponents();
            }
        } else {
            if (string.equalsIgnoreCase("ActivityLogStatusBar") && Application.getDevelopmentMode() == 0) {
                return "ok";
            }
            TScrollToolbar tScrollToolbar = this.getToolbar(string);
            if (tScrollToolbar != null) {
                tScrollToolbar.setVisible(false);
                this.getContentPane().remove(tScrollToolbar);
                Desktop.getContentPanel().remove(tScrollToolbar);
                tScrollToolbar.dispose();
                Desktop.resizeComponents();
                if (DesktopNavigator != null) {
                    DesktopNavigator.resizeComponents();
                }
                if (DesktopMessageLog != null) {
                    DesktopMessageLog.resizeComponents();
                }
            }
        }
        return "ok";
    }

    public void refreshGUI() {
        int n;
        AKDockLayout aKDockLayout = (AKDockLayout)this.getContentPane().getLayout();
        aKDockLayout.clearAll();
        Component[] componentArray = this.getContentPane().getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            if (componentArray[n] instanceof TToolBar) {
                ((TToolBar)componentArray[n]).dispose();
                this.getContentPane().remove(componentArray[n]);
                continue;
            }
            if (!(componentArray[n] instanceof JMenuBar)) continue;
            this.getContentPane().remove(componentArray[n]);
        }
        Desktop.removeBackgroundPanel();
        this.createAndShowGUI(true);
        this.enableScrollwinCommands(false);
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        if (jInternalFrameArray.length > 0) {
            this.enableScrollwinCommands(true);
            JMenu jMenu = this.getWindowMenu();
            if (jMenu != null) {
                jMenu.addSeparator();
                for (n = 0; n < jInternalFrameArray.length; ++n) {
                    if (!(jInternalFrameArray[n] instanceof TScrollWin)) continue;
                    this.ScrollWinOpened((TScrollWin)jInternalFrameArray[n], ((TScrollWin)jInternalFrameArray[n]).WindowID);
                }
            }
            Desktop.setSelectedFrame(Desktop.getSelectedFrame());
        }
    }

    public void reloadResources() {
        if (IsReloading) {
            return;
        }
        IsReloading = true;
        Thread thread = new Thread(){

            @Override
            public void run() {
                Aspect.reloadResources();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Component[] componentArray = TMainWin.this.getContentPane().getComponents();
                        for (int i = 0; i < componentArray.length; ++i) {
                            ((JComponent)componentArray[i]).updateUI();
                        }
                        TMainWin.this.getContentPane().invalidate();
                        IsReloading = false;
                    }
                });
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public boolean isReloading() {
        return IsReloading;
    }

    public void startNetworkServers() {
    }

    public void startNameServer() {
        this.appendToLog("TMainWin", "startNameServer", Thread.currentThread(), null, 9, "Starting name server");
        StartNameServer = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NameServer = new TNameServer(Application, NetworkSettings);
                NameServer.start();
            }
        });
    }

    public void startDriverServer() {
    }

    public void refreshDesktop() {
        Desktop.refreshDesktop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder(actionEvent.getActionCommand());
        String string = stringBuilder.toString();
        boolean bl = true;
        if (bl) {
            System.out.println("Command=" + actionEvent.getActionCommand());
            System.out.println("Class=" + actionEvent.getClass());
            System.out.println("ID=" + actionEvent.getID());
            System.out.println("Modifier=" + actionEvent.getModifiers());
            System.out.println("Source=" + actionEvent.getSource());
        }
    }

    public Cursor setWaitCursor(Component component, Cursor cursor) {
        Cursor cursor2 = component.getCursor();
        if (cursor == null) {
            component.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            component.setCursor(cursor);
        }
        return cursor2;
    }

    public void executeDriverCommand(String string, String string2) {
        TScrollWin tScrollWin = (TScrollWin)Desktop.getSelectedFrame();
        if (tScrollWin == null) {
            return;
        }
        if (tScrollWin.isInDialog()) {
            return;
        }
        TScrollTable tScrollTable = tScrollWin.TablePanel.Table;
        tScrollTable.executeDriverCommand(string, string2);
    }

    public boolean executeActionObject(AbstractAction abstractAction, TScrollTablePanel tScrollTablePanel) {
        TInternalFrame tInternalFrame = null;
        TScrollWin tScrollWin = null;
        TScrollTable tScrollTable = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = true;
        int n = (Integer)abstractAction.getValue("ActionType");
        String string = (String)abstractAction.getValue("ActionDriverID");
        String string2 = (String)abstractAction.getValue("ActionDriverCmd");
        String string3 = (String)abstractAction.getValue("ActionParameters");
        String string4 = (String)abstractAction.getValue("ActionScriptID");
        String string5 = (String)abstractAction.getValue("ActionReportID");
        if (string3 != null) {
            string3 = Application.parse_tokens(stringBuilder, string3);
        }
        stringBuilder.setLength(0);
        stringBuilder.append("Action: " + TAppAction.AppActionDescription[n]);
        if (string != null && string.length() > 0) {
            stringBuilder.append("  Driver: " + string);
        }
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append("  Parameters: " + string3);
        }
        this.appendToLog("TMainWin", "executeActionObject", Thread.currentThread(), null, 12, stringBuilder.toString());
        tInternalFrame = (TInternalFrame)Desktop.getSelectedFrame();
        if (tInternalFrame != null && tInternalFrame instanceof TScrollWin && (tScrollWin = (TScrollWin)tInternalFrame).isInDialog()) {
            bl = true;
        }
        if (tScrollTablePanel == null) {
            if (tScrollWin != null) {
                tScrollTable = tScrollWin.TablePanel.Table;
            }
        } else {
            tScrollTable = tScrollTablePanel.Table;
        }
        TExecDialog tExecDialog = TExecDialog.getCurrentDialog();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                TMainWin.execClassMethod(string3);
                break;
            }
            case 3: {
                String[] stringArray = charutil.getSubStringArray(string3, '=', true);
                if (stringArray == null || stringArray.length != 2) break;
                Application.setTokenValue(stringArray[0], stringArray[1]);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.executeScrollWin(string);
                break;
            }
            case 41: {
                this.openReportWin(string5);
                break;
            }
            case 13: {
                if (tInternalFrame == null || tScrollWin != null && bl) break;
                this.cascadeWindows();
                break;
            }
            case 14: {
                if (tInternalFrame == null || tScrollWin != null && bl) break;
                this.tileWindows();
                break;
            }
            case 11: {
                if (tInternalFrame == null || tScrollWin != null && bl) break;
                tScrollWin.dispose();
                break;
            }
            case 15: {
                if (tInternalFrame == null || tScrollWin != null && bl) break;
                this.closeAllWindows();
                break;
            }
            case 16: {
                if (bl) break;
                this.reloadResources();
                break;
            }
            case 17: {
                int n2;
                if (bl || TMainWin.executeDialog(string, n2 = charutil.ival(string3)).equalsIgnoreCase("ok")) break;
                bl2 = false;
                break;
            }
            case 28: {
                exec.launchViewer(string3);
                break;
            }
            case 38: {
                exec.launchApplication(string3);
                break;
            }
            case 29: {
                exec.playMedia(string3);
                break;
            }
            case 30: {
                int n3 = (Integer)abstractAction.getValue("WindowID");
                this.activateWindowWithID(n3);
                break;
            }
            case 31: {
                if (tExecDialog != null) {
                    tExecDialog.executeDriverCommand(string2, string3);
                    break;
                }
                if (tScrollTable == null) break;
                tScrollTable.executeDriverCommand(string2, string3);
                break;
            }
            case 39: {
                if (tScrollTable == null || bl) break;
                System.out.println("Send driver command message: " + string2 + " Params=" + string3);
                tScrollTable.sendDriverCmdMsg(string2, string3);
                break;
            }
            case 40: {
                this.executeScript(string4);
                break;
            }
            case 42: {
                this.setDesktop(string);
            }
        }
        return bl2;
    }

    public void actionObjectSelected(final TActionObject tActionObject) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TMainWin.this.executeActionObject(tActionObject, null);
            }
        });
    }

    public void listMainCommands() {
        for (int i = 0; i < TMainWin.Application.AppMain.ResourceColl.size(); ++i) {
            TAppMainObject tAppMainObject = (TAppMainObject)TMainWin.Application.AppMain.ResourceColl.get(i);
            System.out.println("Name: " + tAppMainObject.TokenID + "\tValue: " + tAppMainObject.Value.toString());
        }
    }

    public void execute_main_commands(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < TMainWin.Application.AppMain.ResourceColl.size(); ++i) {
            TAppMainObject tAppMainObject = (TAppMainObject)TMainWin.Application.AppMain.ResourceColl.get(i);
            if (!tAppMainObject.TokenID.equalsIgnoreCase(string)) continue;
            stringBuilder = new StringBuilder(tAppMainObject.Value.toString());
            Application.parse_tokens(stringBuilder, stringBuilder);
            TActionObject tActionObject = TMainWin.Application.AppAction.getActionObject(stringBuilder.toString());
            if (tActionObject != null) {
                this.executeActionObject(tActionObject, null);
                continue;
            }
            TMainWin.execClassMethod(stringBuilder.toString());
        }
    }

    public void executeScript(String string) {
        TScrollTable tScrollTable = null;
        JInternalFrame jInternalFrame = Desktop.getSelectedFrame();
        if (jInternalFrame instanceof TScrollWin) {
            tScrollTable = ((TScrollWin)jInternalFrame).TablePanel.Table;
            tScrollTable.stopEditing();
        }
        TExecScript tExecScript = new TExecScript(string, tScrollTable, null);
        tExecScript.start();
    }

    public void openReportWin(String string) {
        TAppReportsObject tAppReportsObject = TMainWin.Application.AppReports.getAppReportsObject(string);
        if (tAppReportsObject == null) {
            this.appendToLog("MainWin", "openReportWin", Thread.currentThread(), null, 4, "Cannot locate report with ID '" + string + "'");
            return;
        }
        TReportWin tReportWin = new TReportWin(tAppReportsObject);
        tReportWin.createAndShowGUI();
    }

    public void executeScrollWin(String[] stringArray) {
        this.executeScrollWin(stringArray[0]);
    }

    public void executeScrollWin(String string) {
        TAppDriversObject tAppDriversObject = null;
        TScrollWin tScrollWin = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject(string);
        if (tAppDriversObject != null) {
            Application.parse_tokens(stringBuilder, tAppDriversObject.TableID);
            TAppTablesObject tAppTablesObject = (TAppTablesObject)TMainWin.Application.AppTables.getResourceElements(stringBuilder.toString()).get(0);
            if (tAppTablesObject.SingleInstance && (tScrollWin = this.getScrollWinWithDriverID(tAppDriversObject.DriverID.toString())) != null) {
                try {
                    tScrollWin.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            TExecScrollWinThread tExecScrollWinThread = new TExecScrollWinThread(tAppDriversObject, string);
            tExecScrollWinThread.start();
        } else {
            JOptionPane.showMessageDialog(null, "Cannot locate driver resource: " + string, "Information", 1);
        }
    }

    public void showScrollWin() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                while (TMainWin.this.arScrollWinDriversToShow.size() > 0) {
                    TAspectDriver tAspectDriver = (TAspectDriver)TMainWin.this.arScrollWinDriversToShow.get(0);
                    TMainWin.this.showScrollWin(tAspectDriver);
                    TMainWin.this.arScrollWinDriversToShow.remove(0);
                }
            }
        });
    }

    public void showScrollWin(TAspectDriver tAspectDriver) {
        TAppDriversObject tAppDriversObject = tAspectDriver.AppDriverObj;
        String string = this.makeUniqueWindowName(tAppDriversObject.Description.toString());
        TScrollWin tScrollWin = new TScrollWin(this, string, Desktop, Application, tAppDriversObject, tAspectDriver, this.getNextWindowID());
        tScrollWin.createAndShowGUI();
        this.ScrollWinOpened(tScrollWin, tScrollWin.WindowID);
    }

    public void executeDriverPreActions(TAppDriversObject tAppDriversObject) {
        Object object;
        int n;
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (tAppDriversObject.ExecuteOnOpenMethod.length() > 0) {
            Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnOpenMethod);
            stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
            if (stringArray != null) {
                for (n = 0; !bl && n < stringArray.length; ++n) {
                    object = TMainWin.execClassMethod(stringArray[n]);
                    if (object == null || !(object instanceof Boolean) || ((Boolean)object).booleanValue()) continue;
                    bl = true;
                }
            }
        }
        if (!bl && tAppDriversObject.ExecuteOnOpenAction.length() > 0) {
            Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnOpenAction);
            stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
            if (stringArray != null) {
                for (n = 0; !bl && n < stringArray.length; ++n) {
                    object = TMainWin.Application.AppAction.getAppActionObject(stringArray[n]);
                    if (object == null || this.executeActionObject(((TAppActionObject)object).ActionObject, null)) continue;
                    bl = true;
                }
            }
        }
        if (!bl && tAppDriversObject.ExecuteOnOpenScript.length() > 0) {
            object = new TExecScript(tAppDriversObject.ExecuteOnOpenScript, null, null);
            ((Thread)object).start();
            if (tAppDriversObject.WaitForScript) {
                while (((Thread)object).isAlive()) {
                    Thread.yield();
                    if (!(Math.random() < 0.1)) continue;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static String executeDialog(String string) {
        return TMainWin.executeDialog(string, 0);
    }

    public static String executeDialog(String string, int n) {
        TAppDriversObject tAppDriversObject = null;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject(string);
        if (tAppDriversObject != null) {
            Object object;
            Object object2;
            int n2;
            String[] stringArray;
            Cursor cursor = Aspect.MainWin.getCursor();
            Aspect.MainWin.setCursor(Cursor.getPredefinedCursor(3));
            if (tAppDriversObject.ExecuteOnOpenMethod.length() > 0) {
                Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnOpenMethod);
                stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
                if (stringArray != null) {
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        object2 = TMainWin.execClassMethod(stringArray[n2]);
                        if (object2 == null || !(object2 instanceof Boolean) || ((Boolean)object2).booleanValue()) continue;
                        return "Cancel";
                    }
                }
            }
            if (tAppDriversObject.ExecuteOnOpenAction.length() > 0) {
                Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnOpenAction);
                stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
                if (stringArray != null) {
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        object2 = TMainWin.Application.AppAction.getAppActionObject(stringArray[n2]);
                        if (object2 == null || Aspect.MainWin.executeActionObject(((TAppActionObject)object2).ActionObject, null)) continue;
                        return "Cancel";
                    }
                }
            }
            if (tAppDriversObject.ExecuteOnOpenScript.length() > 0) {
                object2 = new TExecScript(tAppDriversObject.ExecuteOnOpenScript, null, null);
                ((Thread)object2).start();
                if (tAppDriversObject.WaitForScript) {
                    while (((Thread)object2).isAlive()) {
                        Thread.yield();
                        if (!(Math.random() < 0.1)) continue;
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            Aspect.MainWin.setCursor(Cursor.getPredefinedCursor(0));
            object2 = new TExecDialog(tAppDriversObject, n);
            string2 = ((TExecDialog)object2).executeDialog();
            if (tAppDriversObject.ExecuteOnCloseMethod.length() > 0) {
                Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnCloseMethod);
                stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
                if (stringArray != null) {
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        TMainWin.execClassMethod(stringArray[n2]);
                    }
                }
            }
            if (tAppDriversObject.ExecuteOnCloseAction.length() > 0) {
                Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnCloseAction);
                stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
                if (stringArray != null) {
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        object = TMainWin.Application.AppAction.getAppActionObject(stringArray[n2]);
                        if (object == null) continue;
                        Aspect.MainWin.executeActionObject(((TAppActionObject)object).ActionObject, null);
                    }
                }
            }
            if (tAppDriversObject.ExecuteOnCloseScript.length() > 0) {
                object = new TExecScript(tAppDriversObject.ExecuteOnCloseScript, null, null);
                ((Thread)object).start();
            }
            if (Desktop != null) {
                Desktop.updateComboBoxCollections();
            }
            object = string2;
            Thread thread = new Thread((String)object){
                final /* synthetic */ String val$strFinalReturnValue;
                {
                    this.val$strFinalReturnValue = string;
                }

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String string;
                            String[] stringArray;
                            if (val$strFinalReturnValue.toUpperCase().startsWith("ACTION.")) {
                                String string2 = val$strFinalReturnValue.substring(7);
                                TAppActionObject tAppActionObject = TMainWin.Application.AppAction.getAppActionObject(string2);
                                if (tAppActionObject != null) {
                                    Aspect.MainWin.executeActionObject(tAppActionObject.ActionObject, null);
                                }
                            } else if (val$strFinalReturnValue.toUpperCase().startsWith("SCRIPT.")) {
                                String string3 = val$strFinalReturnValue.substring(7);
                                Aspect.MainWin.executeScript(string3);
                            } else if (val$strFinalReturnValue.toUpperCase().startsWith("DIALOG.")) {
                                String string4 = val$strFinalReturnValue.substring(7);
                                String[] stringArray2 = charutil.getSubStringArray(string4, '?', true);
                                if (stringArray2 != null && stringArray2.length > 0) {
                                    String string5 = stringArray2[0];
                                    int n = 0;
                                    if (stringArray2.length > 1) {
                                        n = charutil.ival(stringArray2[1]);
                                    }
                                    TMainWin.executeDialog(string5, n);
                                }
                            } else if (val$strFinalReturnValue.toUpperCase().startsWith("DRIVERCMD.") && (stringArray = charutil.getSubStringArray(string = val$strFinalReturnValue.substring(10), ',', true)) != null) {
                                if (stringArray.length == 1) {
                                    Aspect.MainWin.executeDriverCommand(stringArray[0], "");
                                } else {
                                    Aspect.MainWin.executeDriverCommand(stringArray[0], stringArray[1]);
                                }
                            }
                        }
                    });
                }
            };
            thread.setPriority(1);
            thread.start();
        } else {
            JOptionPane.showMessageDialog(null, "Cannot locate driver resource: " + string, "Information", 1);
        }
        return string2;
    }

    public static Object execClassMethod(String string) {
        TClassLoader tClassLoader;
        Class clazz;
        TFormulaEvaluator tFormulaEvaluator = new TFormulaEvaluator(Application);
        Object object = null;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String[] stringArray = null;
        boolean bl = false;
        StringBuilder stringBuilder3 = new StringBuilder(string);
        StringBuilder stringBuilder4 = new StringBuilder();
        if (bl) {
            System.out.println("AMethod = " + string);
        }
        boolean bl2 = false;
        while (!bl2) {
            int n = charutil.pos('.', stringBuilder3);
            int n2 = charutil.pos('(', stringBuilder3);
            if (n >= 0 && n < n2) {
                charutil.getsubstring(stringBuilder4, stringBuilder3, 0, '.', true);
                if (!charutil.nullstr(stringBuilder2)) {
                    stringBuilder2.append('.');
                }
                stringBuilder2.append((CharSequence)stringBuilder4);
                continue;
            }
            bl2 = true;
        }
        charutil.getsubstring(stringBuilder, stringBuilder3, 0, '(', true);
        if (stringBuilder3.charAt(stringBuilder3.length() - 1) == ')') {
            charutil.left(stringBuilder3, stringBuilder3, stringBuilder3.length() - 1);
        }
        char c = ',';
        String[] stringArray2 = charutil.getSubStringArray(stringBuilder3, c, false);
        int n = 0;
        if (stringArray2 != null) {
            n = stringArray2.length;
        }
        if (n > 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = TFormulaEvaluator.convertToString(tFormulaEvaluator.getFormulaValue(stringArray2[i], 0, 0));
            }
        }
        if ((clazz = (tClassLoader = new TClassLoader()).loadClass(stringBuilder2.toString())) != null) {
            object = n == 0 ? tClassLoader.executeMethod(clazz, stringBuilder.toString()) : tClassLoader.executeMethod(clazz, stringBuilder.toString(), stringArray);
        }
        return object;
    }

    public void setDesktop(String string) {
        if (SettingDesktop) {
            return;
        }
        if (Desktop != null) {
            SettingDesktop = true;
            Desktop.addBackgroundPanel(string);
            SettingDesktop = false;
        }
    }

    public void setDesktopNavigator(final String string) {
        if (SettingDesktopNavigator) {
            return;
        }
        if (DesktopNavigator != null && !DesktopNavigator.getDriverID().equalsIgnoreCase(string)) {
            SettingDesktopNavigator = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesktopNavigator.addBackgroundPanel(string);
                    SettingDesktopNavigator = false;
                }
            });
        }
    }

    public void setDesktopMessageLog(final String string) {
        if (SettingDesktopMessageLog) {
            return;
        }
        if (DesktopMessageLog != null && !DesktopMessageLog.getDriverID().equalsIgnoreCase(string)) {
            SettingDesktopMessageLog = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesktopMessageLog.addBackgroundPanel(string);
                    SettingDesktopMessageLog = false;
                }
            });
        }
    }

    public TDesktopPane getDesktop() {
        return Desktop;
    }

    public TScrollTable getTablePanelWithDriverID(String string) {
        TScrollWin tScrollWin = this.getScrollWinWithDriverID(string);
        TScrollTable tScrollTable = null;
        if (tScrollWin != null) {
            tScrollTable = tScrollWin.TablePanel.Table;
        } else {
            TScrollDialogPanel tScrollDialogPanel;
            TScrollTablePanel tScrollTablePanel;
            Object object;
            if (tScrollTable == null && (object = TExecDialog.getCurrentDialog()) != null && (tScrollTablePanel = (tScrollDialogPanel = ((TExecDialog)object).D.getScrollDialogPanel()).getTablePanelWithDriverID(string)) != null) {
                tScrollTable = tScrollTablePanel.Table;
            }
            if (tScrollTable == null && (object = TScrollDialog.getCurrentDialog()) != null && (tScrollTablePanel = (tScrollDialogPanel = ((TScrollDialog)object).getScrollDialogPanel()).getTablePanelWithDriverID(string)) != null) {
                tScrollTable = tScrollTablePanel.Table;
            }
            if (tScrollTable == null && Desktop != null && (object = Desktop.getTablePanelWithDriverID(string)) != null) {
                tScrollTable = ((TScrollTablePanel)object).Table;
            }
            if (tScrollTable == null && DesktopNavigator != null && (object = DesktopNavigator.getTablePanelWithDriverID(string)) != null) {
                tScrollTable = ((TScrollTablePanel)object).Table;
            }
            if (tScrollTable == null && DesktopMessageLog != null && (object = DesktopMessageLog.getTablePanelWithDriverID(string)) != null) {
                tScrollTable = ((TScrollTablePanel)object).Table;
            }
        }
        return tScrollTable;
    }

    public int getNextWindowID() {
        return NextWindowID++;
    }

    public int getWindowCount() {
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        return jInternalFrameArray.length;
    }

    public boolean isDriverWindowShowing(String string) {
        TScrollWin tScrollWin = this.getScrollWinWithDriverID(string);
        if (tScrollWin == null) {
            return false;
        }
        return tScrollWin.TablePanel.Table.isShowing();
    }

    public void activateWindowWithID(int n) {
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        for (int i = jInternalFrameArray.length - 1; i >= 0; --i) {
            if (!(jInternalFrameArray[i] instanceof TScrollWin) || ((TScrollWin)jInternalFrameArray[i]).WindowID != n) continue;
            try {
                jInternalFrameArray[i].setSelected(true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public TScrollWin getScrollWinWithID(int n) {
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!(jInternalFrameArray[i] instanceof TScrollWin) || ((TScrollWin)jInternalFrameArray[i]).getID() != n) continue;
            return (TScrollWin)jInternalFrameArray[i];
        }
        return null;
    }

    public TScrollWin getScrollWinWithDriverID(String string) {
        if (Desktop == null) {
            return null;
        }
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!(jInternalFrameArray[i] instanceof TScrollWin) || !((TScrollWin)jInternalFrameArray[i]).getFileID().equalsIgnoreCase(string)) continue;
            return (TScrollWin)jInternalFrameArray[i];
        }
        return null;
    }

    public JInternalFrame getWindowWithName(String string) {
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!jInternalFrameArray[i].getTitle().equalsIgnoreCase(string)) continue;
            return jInternalFrameArray[i];
        }
        return null;
    }

    public synchronized TScrollWin getActiveScrollWin() {
        TInternalFrame tInternalFrame = (TInternalFrame)Desktop.getSelectedFrame();
        if (tInternalFrame != null && tInternalFrame instanceof TScrollWin) {
            return (TScrollWin)tInternalFrame;
        }
        return null;
    }

    public String makeUniqueWindowName(String string) {
        String string2;
        int n = 1;
        do {
            string2 = string;
            if (n > 1) {
                string2 = string2 + " (" + Integer.toString(n) + ")";
            }
            ++n;
        } while (this.getWindowWithName(string2) != null);
        return string2;
    }

    public void enableMainWinToolbarDriverCommands(boolean bl, ArrayList arrayList) {
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof TToolBar)) continue;
            Component[] componentArray2 = ((TToolBar)componentArray[i]).getComponents();
            for (int j = 0; j < componentArray2.length; ++j) {
                if (!(componentArray2[j] instanceof TScrollToolbarDriverCmdButton)) continue;
                TScrollToolbarDriverCmdButton tScrollToolbarDriverCmdButton = (TScrollToolbarDriverCmdButton)componentArray2[j];
                tScrollToolbarDriverCmdButton.getAction().setEnabled(false);
                if (!bl || arrayList == null) continue;
                TAppToolbarObject tAppToolbarObject = tScrollToolbarDriverCmdButton.getAppToolbarObject();
                if (!arrayList.contains(tAppToolbarObject.DriverCmd)) continue;
                tScrollToolbarDriverCmdButton.getAction().setEnabled(true);
            }
        }
    }

    public void enableScrollwinCommands(boolean bl) {
        bl = true;
        TMainWin.Application.AppAction.enableActionType(31, bl);
        TMainWin.Application.AppAction.enableActionType(11, bl);
        TMainWin.Application.AppAction.enableActionType(15, bl);
        TMainWin.Application.AppAction.enableActionType(13, bl);
        TMainWin.Application.AppAction.enableActionType(14, bl);
    }

    public JMenu getWindowMenu() {
        for (int i = 0; i < MainMenu.getMenuCount(); ++i) {
            JMenu jMenu = MainMenu.getMenu(i);
            if (!jMenu.getText().equalsIgnoreCase("Window")) continue;
            return jMenu;
        }
        return null;
    }

    public void ScrollWinOpened(TInternalFrame tInternalFrame, int n) {
        JMenu jMenu = this.getWindowMenu();
        if (jMenu != null) {
            if (jMenu.getItemCount() > 0 && this.getWindowCount() == 0) {
                jMenu.addSeparator();
            }
            TActionObject tActionObject = new TActionObject(this);
            String string = tInternalFrame.getTitle();
            tActionObject.putValue("Name", string);
            tActionObject.putValue("ShortDescription", string);
            tActionObject.putValue("LongDescription", string);
            tActionObject.putValue("ActionType", new Integer(30));
            tActionObject.putValue("WindowID", new Integer(n));
            jMenu.add(new JMenuItem(tActionObject));
        }
    }

    public void ScrollWinClosed(TInternalFrame tInternalFrame, int n) {
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        int n2 = this.getWindowCount();
        Runtime.getRuntime().gc();
        Desktop.updateComboBoxCollections();
        JMenu jMenu = this.getWindowMenu();
        if (jMenu != null) {
            for (int i = 0; i < jMenu.getItemCount(); ++i) {
                JMenuItem jMenuItem = jMenu.getItem(i);
                if (jMenuItem == null || !jMenuItem.getText().equalsIgnoreCase(tInternalFrame.getTitle())) continue;
                jMenu.remove(i);
                if (n2 != 0 || i <= 1) continue;
                jMenu.remove(i - 1);
            }
        }
        if (n2 == 0) {
            this.enableScrollwinCommands(false);
            this.enableMainWinToolbarDriverCommands(false, null);
            TScrollWin.NewFrameLocation = 0;
            Application.setTokenValue("$ScrollWinID", "");
            Application.setTokenValue("$ScrollWinFileID", "");
            Application.setTokenValue("$ScrollWinDisplayName", "");
            Application.setTokenValue("$ScrollWinDisplayAutoResize", "");
            Application.setTokenValue("$ScrollWinDisplayAdvancedFilter", "");
            MainMenu.requestFocus();
        } else {
            try {
                jInternalFrameArray[0].setSelected(true);
                ((TScrollWin)jInternalFrameArray[0]).TablePanel.Table.requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 == 1) {
            TMainWin.Application.AppAction.enableActionType(13, false);
            TMainWin.Application.AppAction.enableActionType(14, false);
        }
    }

    public void cascadeWindows() {
        int n;
        JInternalFrame jInternalFrame = Desktop.getSelectedFrame();
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        Rectangle rectangle = Desktop.getBounds();
        int n2 = (int)((double)rectangle.width * 0.2);
        int n3 = (int)((double)rectangle.height * 0.2);
        int n4 = 0;
        int n5 = 0;
        int n6 = rectangle.width - n2 * 2;
        int n7 = rectangle.height - n3 * 2;
        System.out.println("TMainWin.cascadeWindows()");
        for (n = jInternalFrameArray.length - 1; n >= 0; --n) {
            try {
                jInternalFrameArray[n].setMaximum(false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = jInternalFrameArray.length - 1; n >= 0; --n) {
            if (jInternalFrameArray[n].isIcon()) continue;
            try {
                jInternalFrameArray[n].setMaximum(false);
                jInternalFrameArray[n].reshape(n4, n5, n6, n7);
                n5 += TScrollWin.FrameDistance;
                if ((n4 += TScrollWin.FrameDistance) + n6 > Desktop.getWidth()) {
                    n4 = 0;
                }
                if (n5 + n7 > Desktop.getHeight()) {
                    n5 = 0;
                }
                jInternalFrameArray[n].setSelected(true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            jInternalFrame.setSelected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tileWindows() {
        int n;
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < jInternalFrameArray.length; ++n) {
            if (jInternalFrameArray[n].isIcon()) continue;
            ++n4;
        }
        if (n4 == 2) {
            for (n = 0; n < jInternalFrameArray.length; ++n) {
                if (jInternalFrameArray[n].isIcon()) continue;
                try {
                    jInternalFrameArray[n].setMaximum(false);
                    jInternalFrameArray[n].reshape(0, n2 * Desktop.getHeight() / 2, Desktop.getWidth(), Desktop.getHeight() / 2);
                }
                catch (Exception exception) {
                    this.appendToLog("TMainWin", "tileWindows", Thread.currentThread(), exception, 4, "Error tiling windows");
                }
                ++n2;
            }
            return;
        }
        n = (int)Math.sqrt(n4);
        int n5 = n4 / n;
        int n6 = n4 % n;
        int n7 = Desktop.getWidth() / n5;
        int n8 = Desktop.getHeight() / n;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (jInternalFrameArray[i].isIcon()) continue;
            try {
                jInternalFrameArray[i].setMaximum(false);
                jInternalFrameArray[i].reshape(n3 * n7, n2 * n8, n7, n8);
                if (++n2 != n) continue;
                n2 = 0;
                if (++n3 != n5 - n6) continue;
                n8 = Desktop.getHeight() / ++n;
                continue;
            }
            catch (Exception exception) {
                this.appendToLog("TMainWin", "tileWindows", Thread.currentThread(), exception, 4, "Error tiling windows");
            }
        }
    }

    public void closeAllWindows() {
        JInternalFrame[] jInternalFrameArray = Desktop.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            jInternalFrameArray[i].dispose();
        }
    }

    public static void readLocalPrefs(boolean bl) {
        Object object;
        TLocalPrefs tLocalPrefs = new TLocalPrefs();
        CloseConsoleAfterLoading = tLocalPrefs.getCloseConsoleAfterLoading();
        VerboseMode = tLocalPrefs.getVerboseMode();
        AllowMultipleInstances = tLocalPrefs.getAllowMultipleInstances();
        StartAutomatically = tLocalPrefs.getStartAutomatically();
        StartMinimized = tLocalPrefs.getStartMinimized();
        EnableTaskScheduler = tLocalPrefs.getEnableTaskScheduler();
        Application.setTokenValue("DefaultTextEditor", tLocalPrefs.getDefaultTextEditor());
        Application.setTokenValue("DefaultHtmlEditor", tLocalPrefs.getDefaultHtmlEditor());
        Application.setTokenValue("DefaultNavigator", tLocalPrefs.getDefaultNavigator());
        String string = tLocalPrefs.getHashID();
        if (string.trim().length() == 0) {
            string = tLocalPrefs.generateHashID();
            tLocalPrefs.setHashID(string);
        }
        Application.setTokenValue("AspectHashID", string);
        Application.setTokenValue("AspectOrganizationName", tLocalPrefs.getOrganizationName());
        RunningOnServer = string.equalsIgnoreCase("mt8mlhuwu") || string.equalsIgnoreCase("v8k3ey5q1") ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl2 = DevelopmentMode = Application.getTokenValue("ExecMode").equalsIgnoreCase("Development") ? Boolean.TRUE : Boolean.FALSE;
        if (RunningOnServer.booleanValue()) {
            Application.setTokenValue("AspectServerIP1", netutil.getExternalIP() + ":4447");
            Application.setTokenValue("AspectServerIP1a", netutil.getExternalIP());
            Application.setTokenValue("AspectServerIP2", netutil.getExternalIP() + ":4446");
            Application.setTokenValue("AspectServerHashID", string);
        }
        if (bl) {
            tLocalPrefs.incrementHashCount();
        }
        Application.setTokenValue("AspectHashCount", objectutil.convertToString(new Integer(tLocalPrefs.getHashCount())));
        String string2 = tLocalPrefs.getHomeDirectory();
        if (!Aspect.MainWin.isHomeDirectoryValid(string2)) {
            object = System.getProperties();
            string2 = (String)((Properties)object).get("user.home") + "\\aspect\\";
        }
        Application.setHomeDirectory(dosutil.addTrailingSlash(string2));
        if (TaskScheduler != null) {
            TaskScheduler.setEnabled(EnableTaskScheduler);
        }
        object = new Thread(){

            @Override
            public void run() {
                Properties properties = System.getProperties();
                if (properties != null) {
                    String string = dosutil.addTrailingSlash(properties.getProperty("user.home"));
                    String string2 = string + "Start Menu/Programs/Startup/";
                    String string3 = string + "Desktop/";
                    String string4 = string3 + "Aspect Linked.lnk";
                    String string5 = string2 + "Aspect Linked.lnk";
                    if (StartAutomatically) {
                        File file = new File(string4);
                        File file2 = new File(string5);
                        if (file.exists() && (!file2.exists() || file.length() != file2.length() || file.lastModified() != file2.lastModified())) {
                            dosutil.copyFile(string4, string5, false);
                            file2.setLastModified(file.lastModified());
                        }
                    } else {
                        File file = new File(string5);
                        if (file.exists()) {
                            file.delete();
                        }
                    }
                }
            }
        };
        ((Thread)object).start();
        tLocalPrefs.dispose();
    }

    public static void checkForRestart() {
        IsRestart = new File(Application.getHomeDir() + "restart.txt").exists();
    }

    public static void getAspectServerIPAddress() {
        String[] stringArray;
        boolean bl = true;
        if (bl) {
            AspectServerIP = Application.getTokenValue("AspectServerStaticIP");
            AspectServerPort = Application.getTokenValue("AspectServerStaticIPPort");
            AspectSSLServerPort = Application.getTokenValue("AspectServerStaticIPSSLPort");
            return;
        }
        TAsciiInput tAsciiInput = new TAsciiInput("www.aspect-software.net/Aspect7/AspectServer.IP", '\u0000');
        byte[] byArray = tAsciiInput.get_entire_file();
        tAsciiInput.dispose();
        String string = "";
        if (byArray != null) {
            string = new String(byArray);
        }
        if ((stringArray = charutil.getSubStringArray(string, '|', true)) != null && stringArray.length > 1) {
            String[] stringArray2 = charutil.getSubStringArray(stringArray[0], ':', true);
            if (stringArray2 != null && stringArray2.length == 2) {
                AspectServerIP = stringArray2[0];
                AspectServerPort = stringArray2[1];
            }
            if ((stringArray2 = charutil.getSubStringArray(stringArray[1], ':', true)) != null && stringArray2.length == 2) {
                AspectServerIP = stringArray2[0];
                AspectSSLServerPort = stringArray2[1];
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("begin test");
        try {
            System.out.println("trustStore=" + System.getProperty("javax.net.ssl.trustStore"));
            System.out.println("keyStore=" + System.getProperty("javax.net.ssl.keyStore"));
            System.out.println("trustStorePassword=" + System.getProperty("javax.net.ssl.trustStorePassword"));
            System.out.println("keyStorePassword=" + System.getProperty("javax.net.ssl.keyStorePassword"));
            System.setProperty("javax.net.ssl.trustStore", "C:\\Aspect Software\\Development\\Java\\Aspect\\certificate\\2016 October changes for https\\codesignstore");
            System.setProperty("javax.net.ssl.keyStore", "C:\\Aspect Software\\Development\\Java\\Aspect\\certificate\\2016 October changes for https\\codesignstore");
            System.setProperty("javax.net.ssl.trustStorePassword", "sjeRT873d");
            System.setProperty("javax.net.ssl.keyStorePassword", "sjeRT873d");
            System.out.println("trustStore=" + System.getProperty("javax.net.ssl.trustStore"));
            System.out.println("keyStore=" + System.getProperty("javax.net.ssl.keyStore"));
            System.out.println("trustStorePassword=" + System.getProperty("javax.net.ssl.trustStorePassword"));
            System.out.println("keyStorePassword=" + System.getProperty("javax.net.ssl.keyStorePassword"));
            SSLServerSocketFactory sSLServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(4447);
            sSLServerSocket.setSoTimeout(120);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    static {
        Desktop = null;
        DesktopNavigator = null;
        DesktopMessageLog = null;
        NetworkSettings = null;
        OriginalUserDir = null;
        DriverServer = null;
        NameServer = null;
        TaskScheduler = null;
        Console = null;
        LargeLogo = null;
        SmallLogo = null;
        RunInSystemTray = false;
        AllowMultipleInstances = false;
        StartAutomatically = false;
        StartMinimized = false;
        EnableTaskScheduler = false;
        StartNameServer = false;
        StartDriverServer = false;
        IsClosing = false;
        CloseConsoleAfterLoading = true;
        VerboseMode = false;
        IsReloading = false;
        MainWinType = 1;
        IsRestart = false;
        LogDriver = null;
        LogDriverDayOfYear = -1;
        AspectServerIP = "";
        AspectServerPort = "";
        AspectSSLServerPort = "";
        ProgramStartTime = new Date();
        RunningOnServer = null;
        DevelopmentMode = null;
        IsAspectServer = null;
        arPackageID = new ArrayList();
        arDefinedPackageID = new ArrayList();
        DefaultButtonBorder = (Border)UIManager.get("Button.border");
        DefaultButtonBackground = UIManager.getColor("Button.background");
        boolInRefreshPackages = false;
        InShowGui = false;
        SettingDesktop = false;
        SettingDesktopNavigator = false;
        SettingDesktopMessageLog = false;
    }

    class TExecScrollWinThread
    extends Thread {
        TAppDriversObject AppDriversObj;
        String DriverID;
        StringBuilder Str1;
        boolean IsInitialized;

        public TExecScrollWinThread(TAppDriversObject tAppDriversObject, String string) {
            super("TExecScrollWinThread-" + string);
            this.AppDriversObj = null;
            this.DriverID = "";
            this.Str1 = new StringBuilder();
            this.IsInitialized = false;
            this.AppDriversObj = tAppDriversObject;
            this.DriverID = string;
        }

        @Override
        public void run() {
            Object object;
            int n;
            String[] stringArray;
            TAspectDriver tAspectDriver = null;
            boolean bl = false;
            if (this.AppDriversObj.ExecuteOnOpenMethod.length() > 0) {
                Application.parse_tokens(this.Str1, this.AppDriversObj.ExecuteOnOpenMethod);
                stringArray = charutil.getSubStringArray(this.Str1, '|', true);
                if (stringArray != null) {
                    for (n = 0; !bl && n < stringArray.length; ++n) {
                        object = TMainWin.execClassMethod(stringArray[n]);
                        if (object == null || !(object instanceof Boolean) || ((Boolean)object).booleanValue()) continue;
                        bl = true;
                    }
                }
            }
            if (!bl && this.AppDriversObj.ExecuteOnOpenAction.length() > 0) {
                Application.parse_tokens(this.Str1, this.AppDriversObj.ExecuteOnOpenAction);
                stringArray = charutil.getSubStringArray(this.Str1, '|', true);
                if (stringArray != null) {
                    for (n = 0; !bl && n < stringArray.length; ++n) {
                        object = TMainWin.Application.AppAction.getAppActionObject(stringArray[n]);
                        if (object == null || TMainWin.this.executeActionObject(((TAppActionObject)object).ActionObject, null)) continue;
                        bl = true;
                    }
                }
            }
            if (!bl && this.AppDriversObj.ExecuteOnOpenScript.length() > 0) {
                object = new TExecScript(this.AppDriversObj.ExecuteOnOpenScript, null, null);
                ((Thread)object).start();
                if (this.AppDriversObj.WaitForScript) {
                    while (((Thread)object).isAlive()) {
                        Thread.yield();
                        if (!(Math.random() < 0.1)) continue;
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (!bl) {
                object = TMainWin.this.setWaitCursor(Aspect.MainWin, null);
                tAspectDriver = new TAspectDriver(Application, this.AppDriversObj, 1, true, "");
                TMainWin.this.setWaitCursor(Aspect.MainWin, (Cursor)object);
                if (tAspectDriver != null && tAspectDriver.isValid()) {
                    tAspectDriver.initCollections();
                    tAspectDriver.createUndoManager();
                    TMainWin.this.arScrollWinDriversToShow.add(tAspectDriver);
                    TMainWin.this.showScrollWin();
                } else {
                    tAspectDriver.dispose();
                    tAspectDriver = null;
                }
            }
            this.IsInitialized = true;
        }
    }

    private class TDesktopSplitPane
    extends JSplitPane {
        public TDesktopSplitPane(int n) {
            super(n);
        }

        @Override
        public void setDividerLocation(int n) {
            super.setDividerLocation(n);
            Desktop.resizeComponents();
            if (DesktopNavigator != null) {
                DesktopNavigator.resizeComponents();
            }
            if (DesktopMessageLog != null) {
                DesktopMessageLog.resizeComponents();
            }
        }
    }

    private class TDesktopSplitPaneUI
    extends BasicSplitPaneUI {
        public TDesktopSplitPaneUI(int n) {
            this.setOrientation(n);
        }

        @Override
        protected void finishDraggingTo(int n) {
            super.finishDraggingTo(n);
            Desktop.resizeComponents();
            if (DesktopNavigator != null) {
                DesktopNavigator.resizeComponents();
            }
            if (DesktopMessageLog != null) {
                DesktopMessageLog.resizeComponents();
            }
        }
    }

    public class ShutDown
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }
    }
}

