/*
 * Decompiled with CFR 0.152.
 */
package aspect;

import aspect.Aspect;
import aspect.TMainWin;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import pub.exec;
import resources.TActionObject;
import resources.TAppMenuObject;
import utility.dosutil;

public class TSystemTrayIcon
implements ActionListener,
ItemListener {
    TMainWin MainWin;
    static SystemTray tray = null;
    static TrayIcon ti;

    public TSystemTrayIcon(TMainWin tMainWin) {
        this.MainWin = tMainWin;
        try {
            tray = SystemTray.getSystemTray();
        }
        catch (Exception exception) {
            System.out.println("Error initializing system tray: " + exception.toString());
        }
        if (Integer.parseInt(System.getProperty("java.version").substring(2, 3)) >= 5) {
            System.setProperty("javax.swing.adjustPopupLocationToFit", "false");
        }
        PopupMenu popupMenu = TMainWin.Application.AppMenu.createNoSwingPopupMenu("SystemTrayMenu", this);
        ImageIcon imageIcon = null;
        if (TMainWin.Application.AspectCoreUrl.toUpperCase().indexOf(".JAR") < 0) {
            StringBuilder stringBuilder = new StringBuilder();
            dosutil.findFile(stringBuilder, TMainWin.Application, "/images/pyramid32x32.gif");
            try {
                URL uRL = new URL(stringBuilder.toString());
                imageIcon = new ImageIcon(uRL);
            }
            catch (Exception exception) {}
        } else {
            imageIcon = new ImageIcon(Aspect.class.getResource("/images/pyramid32x32.gif"));
        }
        if (imageIcon.getImage() == null) {
            this.MainWin.appendToLog("TSystemTrayIcon", "init", Thread.currentThread(), null, 4, "Initializing tray icon with null image");
        } else {
            this.MainWin.appendToLog("TSystemTrayIcon", "init", Thread.currentThread(), null, 3, "Initializing tray icon with " + imageIcon.getImage().toString());
        }
        ti = new TrayIcon(imageIcon.getImage(), "Aspect Software", popupMenu);
        ti.setImageAutoSize(true);
        ti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TSystemTrayIcon.this.MainWin.setVisible(!TSystemTrayIcon.this.MainWin.isVisible());
            }
        });
        try {
            tray.add(ti);
        }
        catch (Exception exception) {
            System.out.println("TSystemTrayIcon: " + exception.toString());
        }
    }

    public static void showBalloon(String string, String string2, String string3) {
        if (ti == null) {
            return;
        }
        if (string3.equalsIgnoreCase("Information")) {
            ti.displayMessage(string, string2, TrayIcon.MessageType.INFO);
        } else if (string3.equalsIgnoreCase("Warning")) {
            ti.displayMessage(string, string2, TrayIcon.MessageType.WARNING);
        } else if (string3.equalsIgnoreCase("Error")) {
            ti.displayMessage(string, string2, TrayIcon.MessageType.ERROR);
        }
    }

    protected String getClassName(Object object) {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        String string = menuItem.getLabel();
        if (string.equalsIgnoreCase("_shutdown")) {
            exec.terminate();
        } else {
            TAppMenuObject tAppMenuObject = TMainWin.Application.AppMenu.getAppMenuObjectByName(string);
            if (tAppMenuObject != null) {
                TActionObject tActionObject = TMainWin.Application.AppAction.getActionObject(tAppMenuObject.Parameters);
                if (tActionObject != null) {
                    this.MainWin.executeActionObject(tActionObject, null);
                } else {
                    System.out.println("got AppActionobject for " + string);
                }
            } else {
                System.out.println("Cannot locate AppMenuObj with name " + string);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JMenuItem jMenuItem = (JMenuItem)itemEvent.getSource();
        String string = "Item event detected.\n    Event source: " + jMenuItem.getText() + " (an instance of " + this.getClassName(jMenuItem) + ")" + "\n" + "    New state: " + (itemEvent.getStateChange() == 1 ? "selected" : "unselected");
        System.out.println(string);
    }
}

