/*
 * Decompiled with CFR 0.152.
 */
package cache;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCache;
import cache.TCacheObj;
import collections.TComboBoxColl;
import java.util.Date;
import performance.TPerformanceCollectionMark;
import resources.TAppCollectionsObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.notifications.TNotification;
import utility.objectutil;
import utility.security.TPasswordService;
import utility.session.TSessionObj;

public class TCacheCollection {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    TCacheObj CacheObj;

    public TCacheCollection(TCacheObj tCacheObj) {
        this.CacheObj = tCacheObj;
    }

    public boolean collectionStateChanged(String string, String string2) {
        String string3 = this.getState(string, string2);
        return this.CacheObj.stateChanged(string3);
    }

    public String getState(String string, String string2) {
        String string3;
        String[] stringArray;
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "getState", Thread.currentThread(), null, 3, "Evaluating state.  DriverParams=" + string2);
        }
        TFormulaEvaluator tFormulaEvaluator = new TFormulaEvaluator(TMainWin.Application);
        if (string2.length() > 0 && (stringArray = charutil.getSubStringArray(string2, '|', false)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', false);
                if (stringArray2 == null || stringArray2.length < 2) continue;
                for (int j = 2; j < stringArray2.length; ++j) {
                    stringArray2[1] = stringArray2[1] + "=" + stringArray2[j];
                }
                tFormulaEvaluator.setConstant("#" + stringArray2[0], stringArray2[1]);
            }
        }
        if ((stringArray = tFormulaEvaluator.getFormulaValue(string)) == null) {
            MainWin.appendToLog("TCacheCollection", "getState", Thread.currentThread(), null, 4, "Error: null returned for state expression: " + string);
            return "";
        }
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "getState", Thread.currentThread(), null, 3, "State expression evaluates to=" + objectutil.convertToString(stringArray));
        }
        if ((string3 = TPasswordService.encrypt(objectutil.convertToString(stringArray), "AAA", 1)).length() > 24) {
            string3 = string3.substring(0, 24);
        }
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "getState", Thread.currentThread(), null, 3, "State=" + string3);
        }
        return string3;
    }

    public boolean update(TSessionObj tSessionObj, TFormulaEvaluator tFormulaEvaluator) {
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection:update[" + this.CacheObj.ID + "] Params=" + this.CacheObj.Params);
        }
        if (this.CacheObj.HashID.equalsIgnoreCase(Application.getAspectHashID())) {
            if (this.CacheObj.debugCache()) {
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheCollection:Update[" + this.CacheObj.ID + "] Updating locally");
            }
            return this.updateLocal(tSessionObj, tFormulaEvaluator);
        }
        return this.updateByNotification(tSessionObj);
    }

    private boolean updateByNotification(TSessionObj tSessionObj) {
        String string = TPasswordService.generateSalt(16);
        String string2 = this.CacheObj.Params;
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "updateByNotification", Thread.currentThread(), null, 10, "TCacheCollection:updateByNotification[" + this.CacheObj.ID + "] Data=" + string2);
        }
        TNotification tNotification = new TNotification(string, Application.getAspectHashID(), this.CacheObj.HashID, TNotification.NOTIFICATION_GETCOLLECTION, string2, -1, "", "", new Date(), tSessionObj.getPassword(), 5);
        TFormulaEvaluator.getNotificationClient().addProxyRequest(this.CacheObj, tNotification, "");
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection:updateByNotification[" + this.CacheObj.ID + "] Waiting for response");
        }
        Date date = this.CacheObj.Updated;
        int n = 0;
        boolean bl = false;
        while (n < TCache.CacheTimeoutSeconds && !bl) {
            if (this.CacheObj.Updated.getTime() == date.getTime()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
                continue;
            }
            bl = true;
        }
        if (this.CacheObj.debugCache()) {
            if (bl) {
                MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection:updateByNotification[" + this.CacheObj.ID + "] got response");
            } else {
                MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection:updateByNotification[" + this.CacheObj.ID + "] timed out");
            }
        }
        return bl;
    }

    public boolean updateLocal(TSessionObj tSessionObj, TFormulaEvaluator tFormulaEvaluator) {
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection.updateLocal[" + this.CacheObj.ID + "] started");
        }
        String[] stringArray = charutil.getSubStringArray(this.CacheObj.Params, '&', false);
        String string = charutil.getParamValue(stringArray, "CollectionID");
        StringBuilder stringBuilder = new StringBuilder(charutil.getParamValue(stringArray, "Filter"));
        String string2 = charutil.getParamValue(stringArray, "DriverParams");
        String string3 = charutil.getParamValue(stringArray, "SystemDriverName");
        TAppCollectionsObject tAppCollectionsObject = TCacheCollection.Application.AppCollections.getAppCollectionsObject(string);
        if (tAppCollectionsObject == null) {
            MainWin.appendToLog("TCacheCollection", "updateLocal", Thread.currentThread(), null, 4, "Error in TCacheCollection.updateLocal Invalid collection: " + string);
            MainWin.appendToLog("TCacheCollection", "updateLocal", Thread.currentThread(), null, 4, "Error in TCacheCollection.updateLocal Params=" + this.CacheObj.Params);
            return false;
        }
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection.updateLocal[" + this.CacheObj.ID + "] getting collection: " + string);
        }
        TPerformanceCollectionMark tPerformanceCollectionMark = new TPerformanceCollectionMark("Collection", string, tAppCollectionsObject.DriverID.toString(), string2, stringBuilder.toString());
        TFormulaEvaluator.Performance.addMark(tPerformanceCollectionMark);
        ++tPerformanceCollectionMark.cRead;
        String string4 = "";
        String string5 = this.CacheObj.getContent();
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection.updateLocal[" + this.CacheObj.ID + "] got last content.  Len=" + string5.length());
        }
        if (tAppCollectionsObject.StateExpression.trim().length() > 0) {
            if (this.CacheObj.debugCache()) {
                MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection.updateLocal[" + this.CacheObj.ID + "] evaluating state: " + tAppCollectionsObject.StateExpression);
            }
            string4 = this.getState(tAppCollectionsObject.StateExpression, string2);
            if (string5.length() > 0) {
                if (!this.CacheObj.stateChanged(string4)) {
                    if (this.CacheObj.debugCache()) {
                        MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection.updateLocal[" + this.CacheObj.ID + "] state has not changed");
                    }
                    ++tPerformanceCollectionMark.cCached;
                    tPerformanceCollectionMark.destroy();
                    return false;
                }
            } else if (this.CacheObj.debugCache()) {
                MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection.updateLocal[" + this.CacheObj.ID + "] got state: null");
            }
        } else if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 10, "TCacheCollection.updateLocal[" + this.CacheObj.ID + "] doe not have a state expression");
        }
        if (tAppCollectionsObject.StateExpression.trim().length() > 0) {
            if (this.CacheObj.debugCache()) {
                MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 3, "TCacheCollection.updateLocal[" + this.CacheObj.ID + "] State Expression:" + tAppCollectionsObject.StateExpression + " DriverParams: " + string2 + " Filter: " + stringBuilder);
            }
        } else if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheCollection", "update", Thread.currentThread(), null, 3, "TCacheCollection.updateLocal[" + this.CacheObj.ID + "] [No State Expression] DriverParams: " + string2 + " Filter: " + stringBuilder);
        }
        TComboBoxColl tComboBoxColl = TCacheCollection.Application.AppCollections.createCollection(string, stringBuilder, tFormulaEvaluator, string2, string3);
        this.CacheObj.setContent(tComboBoxColl.toString2(), string4);
        ++tPerformanceCollectionMark.cUpdated;
        tPerformanceCollectionMark.destroy();
        return true;
    }
}

