/*
 * Decompiled with CFR 0.152.
 */
package cache;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCache;
import cache.TCacheObj;
import cache.TDataCollection;
import cache.TDataObject;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStructRecord;
import drivers.files.TBinaryFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.notifications.TNotification;
import utility.objectutil;
import utility.security.TPasswordService;

public class TCacheDriver
extends TBinaryFile
implements TDriverInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    TCacheObj CacheObj = null;
    String HashID = "";

    public TCacheDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) throws IOException {
        super(tApplication, tAppDriversObject, 1, bl);
        System.out.println("TCacheDriver ID=" + tAppDriversObject + " Params=" + tAppDriversObject.DriverParams);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public synchronized int makeEditableFile() throws IOException {
        this.HashID = charutil.getParamValue(this.getDriverParams(), "HashID", '|');
        super.makeEditableFile();
        return 0;
    }

    public boolean updateCache() {
        Object object;
        String[] stringArray;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache started");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("1.0\n");
        stringBuilder.append(this.AppDriversObject.DriverID + "\n");
        stringBuilder.append(this.getKeyExpression() + "\n");
        stringBuilder.append(this.getDriverParams() + "\n");
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            stringArray = (String[])this.DriverStruct.FieldColl.get(i);
            if (stringArray.IsCalculated || stringArray.IsVirtual) continue;
            arrayList.add(stringArray.ID);
            if (i > 0) {
                stringBuilder.append("^");
            }
            stringBuilder.append(stringArray.ID);
        }
        stringBuilder.append("\n");
        String string = charutil.getParamValue(this.getDriverParams(), "filter", '|');
        if (string.length() > 0) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append("true");
        }
        stringBuilder.append("\n");
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache contains " + this.getRecordCount() + " records");
        }
        for (int i = 0; i < this.getRecordCount(); ++i) {
            Object object2;
            TDriverStructRecord tDriverStructRecord;
            int n;
            object = this.getKeyValue(i).toUpperCase();
            if (((String)object).trim().length() > 0) {
                if (hashtable.containsKey(object)) {
                    MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache removing duplicate record with key=" + (String)object);
                    for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
                        tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
                        object2 = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, tDriverStructRecord.DefaultOnDelete, i);
                        super.putField(tDriverStructRecord, i, object2);
                    }
                    continue;
                }
                hashtable.put((String)object, new Integer(i));
                n = this.getCheckSum(i, stringArray);
                stringBuilder.append(this.getKeyValue(i) + "^" + Integer.toString(n) + "\n");
                continue;
            }
            MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 4, "TCacheDriver:updateCache: removing record with blank key value in driver " + this.AppDriversObject.DriverID.toString());
            for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
                tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
                object2 = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, tDriverStructRecord.DefaultOnDelete, i);
                super.putField(tDriverStructRecord, i, object2);
            }
        }
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache sending notification");
            if (Application.getDevelopmentMode() == 0) {
                String string2 = Application.getHomeDir() + "cachedata\\cachedriver_request_" + dateutil.formatDate(new Date(), "MMddyyyy_HHmmss") + ".txt";
                MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache notification request written to " + string2);
                TAsciiOutput.writeContent(string2, stringBuilder.toString());
            }
        }
        String string3 = TPasswordService.generateSalt(16);
        object = new TNotification(string3, Application.getAspectHashID(), this.CacheObj.HashID, TNotification.NOTIFICATION_REQUESTDRIVERDATA, stringBuilder.toString(), -1, "", "", new Date(), TNotification.encryptPassword(), 5);
        TFormulaEvaluator.getNotificationClient().addProxyRequest(this.CacheObj, (TNotification)object, "");
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheDriver", "update", Thread.currentThread(), null, 10, "TCacheDriver: Waiting for response");
        }
        Date date = this.CacheObj.Updated;
        int n = 0;
        boolean bl = false;
        while (n < TCache.CacheTimeoutSeconds && !bl) {
            if (this.CacheObj.Updated.getTime() == date.getTime()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
                continue;
            }
            bl = true;
        }
        if (bl) {
            Object object3;
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache got response CachID=" + this.CacheObj.ID);
                if (Application.getDevelopmentMode() == 0) {
                    object3 = Application.getHomeDir() + "cachedata\\cachedriver_response_" + dateutil.formatDate(new Date(), "MMddyyyy_HHmmss") + ".txt";
                    TAsciiOutput.writeContent((String)object3, this.CacheObj.getContent());
                }
            }
            object3 = new TDataCollection(this.DriverStruct, this.CacheObj.getContent());
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache initialized key values collection with " + hashtable.size() + " values from existing records");
            }
            Hashtable hashtable2 = ((TDataCollection)object3).getRecords();
            arrayList = ((TDataCollection)object3).getFieldIDs();
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache found " + hashtable2.size() + " records in notification");
            }
            Hashtable<String, TDriverStructRecord> hashtable3 = new Hashtable<String, TDriverStructRecord>();
            Enumeration enumeration = hashtable2.keys();
            int n2 = 0;
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                int n4;
                String string4 = ((String)enumeration.nextElement()).toUpperCase();
                int n5 = n4 = hashtable.containsKey(string4) ? (Integer)hashtable.get(string4) : -1;
                if (n4 < 0) {
                    n4 = this.initializeNewCacheRecord();
                    ++n2;
                    hashtable.put(string4, new Integer(n4));
                } else {
                    ++n3;
                }
                ArrayList arrayList2 = (ArrayList)hashtable2.get(string4);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    TDataObject tDataObject = (TDataObject)arrayList2.get(i);
                    String string5 = tDataObject.getFieldID().toUpperCase();
                    TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)hashtable3.get(string5);
                    if (tDriverStructRecord == null) {
                        tDriverStructRecord = this.DriverStruct.getField(string5);
                        hashtable3.put(string5, tDriverStructRecord);
                    }
                    super.putField(tDriverStructRecord, n4, tDataObject.getValue());
                }
            }
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache updated: " + n3 + " added: " + n2);
            }
        } else {
            MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:updateCache timed out");
        }
        return true;
    }

    public synchronized int initializeNewCacheRecord() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        boolean bl = false;
        if (this.AppDriversObject != null && this.AppDriversObject.InsertMode == 0) {
            int n3 = this.getRecordCount();
            for (n = this.intNewRecordSeed; !bl && n < n3; ++n) {
                if (!this.isDeleted(n)) continue;
                n2 = n;
                bl = true;
            }
            this.clearBuffer();
        }
        if (!bl) {
            n2 = this.getRecordCount();
        }
        this.intNewRecordSeed = n2;
        this.putRecord(n2, new byte[this.RecordSize]);
        for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
            Object object;
            Object object2;
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
            if (tDriverStructRecord.IsVirtual || tDriverStructRecord.DefaultOnInsert.length() <= 0) continue;
            stringBuilder.setLength(0);
            if (this.FormulaEvaluator != null && tDriverStructRecord.DefaultOnInsert.length() > 0 && (object2 = this.FormulaEvaluator.getFormulaValue(tDriverStructRecord.DefaultOnInsert, n2, 0)) != null) {
                stringBuilder.append(TFormulaEvaluator.convertToString(object2));
            }
            if ((object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, stringBuilder.toString(), n2)) == null) {
                System.out.println("Error converting " + tDriverStructRecord.FullID);
            }
            super.putField(tDriverStructRecord, n2, object);
        }
        return n2;
    }

    @Override
    public synchronized int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        int n2;
        boolean bl = tDriverStructRecord.ID.equalsIgnoreCase("VirtualIndex");
        if (!bl) {
            // empty if block
        }
        if ((n2 = super.putField(tDriverStructRecord, n, object)) == 0) {
            MainWin.appendToLog("TCacheDriver", "putField", Thread.currentThread(), null, 10, "TCacheDriver:putField An error occurred writing field: " + tDriverStructRecord.ID);
            return 0;
        }
        if (!bl) {
            MainWin.appendToLog("TCacheDriver", "putField", Thread.currentThread(), null, 10, "TCacheDriver:putField adding data to cache");
            TCacheDriver tCacheDriver = this;
            tCacheDriver.FormulaEvaluator.getCache().addData(this.HashID, "", this.AppDriversObject.DriverID.toString(), this.getDriverParams(), this.getKeyValue(n), tDriverStructRecord.ID, tDriverStructRecord.FieldType, object);
        }
        return 0;
    }
}

