/*
 * Decompiled with CFR 0.152.
 */
package cache;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCache;
import drivers.files.TBinaryFile;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import resources.TAppCollectionsObject;
import resources.TApplication;
import utility.TFile;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.objectutil;
import utility.security.TPasswordService;
import utility.ziputil;

public class TCacheObj {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    public static boolean DebugCache = false;
    public static int DebugCacheType = 5;
    public static String DebugCacheName = "";
    public static final String[] TypeName = new String[]{"Widget", "ProcessItem", "WidgetItem", "Driver", "Display", "Collection", "Container-Item"};
    public String ID = "";
    int Type = -1;
    String HashID = "";
    int Index = -1;
    String State = "";
    Date Updated = new Date(0L);
    double Processing_Time = 0.0;
    int Update_Count = 0;
    int Update_Called_Count = 0;
    Date Last_Access = new Date();
    int Access_Count = 0;
    int TimeToLive = 0;
    int iMaxParamLen = 8192;
    String ParamsFilename = "";
    String NotificationID = "";
    String NotificationParentID = "";
    Date LastSend = new Date(0L);
    String Params = "";
    String[] arParams = null;

    public TCacheObj(int n, String string, String string2, int n2) {
        this.ID = TCacheObj.getID(n, string, string2);
        this.Type = n;
        this.HashID = string;
        this.Params = string2;
        this.Index = n2;
        this.TimeToLive = charutil.ival(charutil.getParamValue(this.Params, "CacheTtl", '&'));
    }

    public TCacheObj(String string, int n) {
        this.ID = string;
        this.Index = n;
    }

    public boolean debugCache() {
        boolean bl = false;
        if (this.Type == DebugCacheType) {
            switch (this.Type) {
                case 0: {
                    bl = this.getWidget().equalsIgnoreCase(DebugCacheName);
                    break;
                }
                case 5: {
                    bl = this.getCollection().equalsIgnoreCase(DebugCacheName);
                    break;
                }
                default: {
                    bl = this.Params.toUpperCase().indexOf(DebugCacheName) >= 0;
                }
            }
        }
        return bl;
    }

    public void setUpdated(Date date) {
        if (DebugCache) {
            MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 10, "TCacheObj:setUpdated to " + dateutil.formatDate(date, "MM-dd-yyyy HH:mm:ss"));
        }
        this.Updated = date;
    }

    public String getParameter(String string) {
        if (this.arParams == null) {
            this.arParams = charutil.getSubStringArray(this.Params, '&', true);
        }
        return charutil.getParamValue(this.arParams, string);
    }

    public boolean isBinary() {
        String string = this.getParameter("binary");
        if (string.length() > 0) {
            return charutil.boolval(string);
        }
        return false;
    }

    public String getParamString(char c) {
        if (this.arParams == null) {
            this.arParams = charutil.getSubStringArray(this.Params, '&', true);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.arParams.length; ++i) {
            stringBuilder.append(this.arParams[i]);
            if (i >= this.arParams.length - 1) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Hashtable getParameters() {
        if (this.arParams == null) {
            this.arParams = charutil.getSubStringArray(this.Params, '&', true);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < this.arParams.length; ++i) {
            int n = this.arParams[i].indexOf(61);
            if (n <= 0) continue;
            hashtable.put(this.arParams[i].substring(0, n), this.arParams[i].substring(n + 1));
        }
        return hashtable;
    }

    public String getContentFilename() {
        String string = charutil.replaceChar(charutil.replaceChar(this.ID, '\\', '_'), '/', '_');
        string = charutil.replaceChar(string, '+', '_');
        return dosutil.addTrailingSlash(TMainWin.Application.getHomeDir()) + "cachedata/" + string;
    }

    public boolean contentExists() {
        File file = new File(this.getContentFilename());
        if (file.exists() && file.length() > 0L) {
            return true;
        }
        file = new File(this.getContentFilename() + "+");
        return file.exists() && file.length() > 0L;
    }

    public long expires() {
        return this.Updated.getTime() + (long)(this.TimeToLive * 1000);
    }

    public boolean isExpired() {
        if (this.TimeToLive == 0) {
            return true;
        }
        if (!new File(this.getContentFilename()).exists() && !new File(this.getContentFilename() + "+").exists()) {
            return true;
        }
        if (this.TimeToLive > 0) {
            // empty if block
        }
        return this.expires() < new Date().getTime();
    }

    public boolean stateChanged(String string) {
        if (string.length() > 24) {
            return !this.State.equalsIgnoreCase(string.substring(0, 24));
        }
        return !this.State.equalsIgnoreCase(string);
    }

    public String getContent() {
        String string = "";
        String string2 = this.getContentFilename();
        File file = new File(string2);
        if (file.exists()) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
                randomAccessFile.seek(0L);
                byte[] byArray = new byte[(int)file.length()];
                randomAccessFile.read(byArray);
                randomAccessFile.close();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append((char)byArray[i]);
                }
                string = stringBuilder.toString();
            }
            catch (Exception exception) {
                string = "TCacheObj: Error getting uncompressed content";
            }
        } else {
            file = new File(string2 + "+");
            if (file.exists()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string2 + "+", "r");
                    randomAccessFile.seek(0L);
                    byte[] byArray = new byte[(int)randomAccessFile.length()];
                    randomAccessFile.read(byArray);
                    randomAccessFile.close();
                    string = ziputil.gunzipString(byArray, "utf-8");
                    if (DebugCache) {
                        MainWin.appendToLog("TCacheObj", "getContent", Thread.currentThread(), null, 10, "TCacheObj:getContent returning " + string.length() + " bytes from " + this.getContentFilename());
                    }
                }
                catch (Exception exception) {
                    Aspect.MainWin.appendToLog("TCache", "getContent", Thread.currentThread(), null, 4, "TCacheObj.getContent: " + exception.toString());
                    string = "TCacheObj: Error getting compressed content";
                    new Throwable().printStackTrace();
                }
            }
        }
        return string;
    }

    public void setNotificationID(String string) {
        this.NotificationID = string;
    }

    public void setNotificationParentID(String string) {
        this.NotificationParentID = string;
    }

    public synchronized boolean setState(String string) {
        this.State = string;
        if (TCache.drvCache != null) {
            TCache.drvCache.putField("State", this.Index, (Object)string);
        }
        return true;
    }

    public synchronized boolean setContent(String string, String string2) {
        if (this.setContent(string)) {
            this.State = string2;
            if (TCache.drvCache != null) {
                if (DebugCache) {
                    MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 10, "Recording state=" + string2 + " in cachobj ID=" + this.ID + " Params=" + this.Params);
                }
                TCache.drvCache.putField("State", this.Index, (Object)string2);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean setContentFromFile(String string) {
        dosutil.copyFile(string, this.getContentFilename(), 0, false, "", "", "");
        return true;
    }

    public synchronized boolean setContent(String string) {
        Object object;
        Object object2;
        byte[] byArray = null;
        String string2 = this.getContentFilename();
        boolean bl = false;
        if (!(MainWin.isRunningOnServer() || DebugCache || this.isBinary() || string.length() <= 0)) {
            byArray = ziputil.gzipString(string, "utf-8");
            object2 = "";
            try {
                object2 = ziputil.gunzipString(byArray, "utf-8");
            }
            catch (Exception exception) {
                MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 10, "TCacheObj:setContent error testing zip for " + this.toString());
            }
            if (((String)object2).compareTo(string) == 0) {
                bl = true;
                string2 = string2 + "+";
            } else {
                RandomAccessFile randomAccessFile;
                bl = false;
                int n = string.length();
                int n2 = ((String)object2).length();
                MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 10, "TCacheObj:setContent error zipping content " + this.Params);
                MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 10, "TCacheObj:setContent Originzl bytes=" + n + " Confirm bytes=" + n2);
                if (n == n2) {
                    for (int i = 0; i < n; ++i) {
                        if (string.charAt(i) == ((String)object2).charAt(i)) continue;
                        System.out.println(Integer.toString(i) + "\t" + string.charAt(i) + " [ " + (byte)string.charAt(i) + "]\t" + ((String)object2).charAt(i) + " [" + (byte)((String)object2).charAt(i) + "]");
                    }
                }
                System.out.println("Output files written to temporary_files/zip_error...");
                object = "";
                try {
                    object = Application.getTemporaryFiles() + "zip_error_original_content.txt";
                    new TFile((String)object).validatePathToFile(true);
                    randomAccessFile = new RandomAccessFile((String)object, "rwd");
                    randomAccessFile.setLength(0L);
                    randomAccessFile.writeBytes(string);
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    System.out.println("Error writing " + (String)object);
                }
                try {
                    object = Application.getTemporaryFiles() + "zip_error_zipped_content.txt";
                    new TFile((String)object).validatePathToFile(true);
                    randomAccessFile = new RandomAccessFile((String)object, "rwd");
                    randomAccessFile.setLength(0L);
                    randomAccessFile.writeBytes((String)object2);
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    System.out.println("Error writing " + (String)object);
                }
            }
        }
        if (bl) {
            try {
                if (DebugCache) {
                    MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 10, "TCacheObj:setContent writing " + string.length() + " bytes to " + string2 + " as zip content");
                }
                object2 = new TFile(string2);
                ((TFile)object2).validatePathToFile(true);
                RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rwd");
                randomAccessFile.setLength(0L);
                randomAccessFile.write(byArray);
                randomAccessFile.close();
                String string3 = string2.substring(0, string2.length() - 1);
                object = new TFile(string3);
                if (((File)object).exists()) {
                    dosutil.deleteFile((File)object);
                }
                this.Updated = new Date();
            }
            catch (Exception exception) {
                Aspect.MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 4, "TCacheObj.setContent2: " + exception.toString());
                Aspect.MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 4, "TCacheObj.setContent2: Params=" + this.Params);
                this.Updated = new Date();
                return false;
            }
        }
        if (DebugCache) {
            MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 10, "TCacheObj:setContent writing " + string.length() + " bytes to " + string2 + " with no compression");
        }
        try {
            object2 = new byte[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                object2[i] = (byte)string.charAt(i);
            }
            TFile tFile = new TFile(string2);
            tFile.validatePathToFile(true);
            dosutil.deleteFile(tFile);
            if (tFile.exists()) {
                MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 4, "TCacheObj:setContent cannot delete file: " + string2);
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rwd");
            randomAccessFile.write((byte[])object2);
            randomAccessFile.close();
            object = new File(string2 + "+");
            if (((File)object).exists()) {
                dosutil.deleteFile((File)object);
            }
            if (DebugCache) {
                MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 10, "TCacheObj:setContent writing " + string.length() + " bytes to " + string2 + " with no compression complete");
            }
        }
        catch (Exception exception) {
            Aspect.MainWin.appendToLog("TCacheObj", "setContent", Thread.currentThread(), null, 4, "TCacheObj.setContent3: " + exception.toString());
            return false;
        }
        return true;
    }

    public void readFromDriver(TBinaryFile tBinaryFile) {
        this.Type = (Integer)tBinaryFile.getField("Type", this.Index);
        this.HashID = (String)tBinaryFile.getField("HashID", this.Index);
        this.ParamsFilename = (String)tBinaryFile.getField("ParamsFilename", this.Index);
        if (this.ParamsFilename.trim().length() > 0) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.ParamsFilename, "r");
                randomAccessFile.seek(0L);
                byte[] byArray = new byte[(int)randomAccessFile.length()];
                randomAccessFile.read(byArray);
                randomAccessFile.close();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append((char)byArray[i]);
                }
                this.Params = stringBuilder.toString();
            }
            catch (Exception exception) {
                Aspect.MainWin.appendToLog("TCache", "getContent", Thread.currentThread(), null, 4, "TCacheObj.readFromDriver: " + exception.toString());
            }
        } else {
            this.Params = (String)tBinaryFile.getField("Params", this.Index);
        }
        this.State = (String)tBinaryFile.getField("State", this.Index);
        this.Updated = (Date)tBinaryFile.getField("Updated", this.Index);
        this.Last_Access = (Date)tBinaryFile.getField("Last_Access", this.Index);
        this.Access_Count = (Integer)tBinaryFile.getField("Access_Count", this.Index);
        this.TimeToLive = (Integer)tBinaryFile.getField("TimeToLive", this.Index);
        this.Processing_Time = (Double)tBinaryFile.getField("Processing_Time", this.Index);
        this.Update_Count = (Integer)tBinaryFile.getField("Update_Count", this.Index);
        this.Update_Called_Count = (Integer)tBinaryFile.getField("Update_Called_Count", this.Index);
        this.NotificationID = (String)tBinaryFile.getField("NotificationID", this.Index);
        this.NotificationParentID = (String)tBinaryFile.getField("NotificationParentID", this.Index);
    }

    public void writeToDriver(TBinaryFile tBinaryFile, boolean bl) {
        String string;
        if (bl) {
            tBinaryFile.putField("State", this.Index, (Object)this.State);
            tBinaryFile.putField("Updated", this.Index, (Object)this.Updated);
            tBinaryFile.putField("Last_Access", this.Index, (Object)this.Last_Access);
            tBinaryFile.putField("Access_Count", this.Index, (Object)this.Access_Count);
            tBinaryFile.putField("TimeToLive", this.Index, (Object)this.TimeToLive);
            tBinaryFile.putField("Processing_Time", this.Index, (Object)this.Processing_Time);
            tBinaryFile.putField("Update_Count", this.Index, (Object)this.Update_Count);
            tBinaryFile.putField("Update_Called_Count", this.Index, (Object)this.Update_Called_Count);
            tBinaryFile.putField("NotificationID", this.Index, (Object)this.NotificationID);
            tBinaryFile.putField("NotificationParentID", this.Index, (Object)this.NotificationParentID);
            return;
        }
        tBinaryFile.putField("ID", this.Index, (Object)this.ID);
        tBinaryFile.putField("Type", this.Index, (Object)new Integer(this.Type));
        tBinaryFile.putField("HashID", this.Index, (Object)this.HashID);
        tBinaryFile.putField("Params", this.Index, (Object)this.Params);
        tBinaryFile.putField("Last_Access", this.Index, (Object)this.Last_Access);
        tBinaryFile.putField("Access_Count", this.Index, (Object)this.Access_Count);
        if (this.Params.length() >= this.iMaxParamLen) {
            if (this.ParamsFilename.length() == 0) {
                string = charutil.replaceChar(charutil.replaceChar(this.ID, '\\', '_'), '/', '_');
                this.ParamsFilename = dosutil.addTrailingSlash(TMainWin.Application.getHomeDir()) + "cachedata/" + string + "_param.txt";
            }
            TAsciiOutput.writeContent(this.ParamsFilename, this.Params);
            tBinaryFile.putField("Params", this.Index, (Object)this.Params);
            tBinaryFile.putField("ParamsFilename", this.Index, (Object)this.ParamsFilename);
        } else {
            tBinaryFile.putField("Params", this.Index, (Object)this.Params);
        }
        if (this.Type == 5) {
            string = this.getParameter("CollectionID");
            tBinaryFile.putField("CollectionID", this.Index, (Object)string);
            tBinaryFile.putField("Description", this.Index, (Object)string);
        } else if (this.Type == 3) {
            string = this.getParameter("DriverID");
            tBinaryFile.putField("DriverID", this.Index, (Object)string);
            tBinaryFile.putField("Description", this.Index, (Object)string);
        } else if (this.Type == 4) {
            string = this.getParameter("DriverID");
            String string2 = this.getParameter("DisplayName");
            tBinaryFile.putField("DriverID", this.Index, (Object)string);
            tBinaryFile.putField("Description", this.Index, (Object)(string + ":" + string2));
        } else if (this.Type == 1) {
            string = this.Params.substring(0, Math.min(256, this.Params.length()));
            tBinaryFile.putField("Description", this.Index, (Object)string);
        } else {
            string = this.getParameter("DocumentID");
            String string3 = this.getParameter("Widget");
            String string4 = this.getParameter("ContainerItemID");
            if (string4.trim().length() == 0) {
                string4 = this.getParameter("ProcessedItemID");
            }
            String string5 = this.getParameter("Query");
            String string6 = this.getParameter("Action");
            if (string5.length() + string6.length() == 0) {
                String string7 = this.getParameter("Params");
                string5 = charutil.getParamValue(string7, "Query", '|');
                string6 = charutil.getParamValue(string7, "Action", '|');
            }
            tBinaryFile.putField("DocumentID", this.Index, (Object)string);
            tBinaryFile.putField("WidgetName", this.Index, (Object)string3);
            tBinaryFile.putField("WidgetItem", this.Index, (Object)string4);
            tBinaryFile.putField("Query", this.Index, (Object)(string5 + string6));
            tBinaryFile.putField("Description", this.Index, (Object)(string + ":" + string3 + ":" + string4 + ":" + string5 + string6));
        }
    }

    public String getWidget() {
        return charutil.getElementValue(this.Params, "Widget", '&');
    }

    public String getCollection() {
        return charutil.getElementValue(this.Params, "CollectionID", '&');
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.Type >= 0 && this.Type < TypeName.length) {
            stringBuilder.append("Type=" + TypeName[this.Type]);
        } else {
            stringBuilder.append("Type=Invalid");
        }
        stringBuilder.append(" ID=" + this.ID + " HashID=" + this.HashID + " Index=" + this.Index);
        String[] stringArray = charutil.getSubStringArray(this.Params, '&', false);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toUpperCase().startsWith("CONTENT=")) {
                int n = 128;
                if (stringArray[i].length() > n) {
                    stringBuilder.append(" " + stringArray[i].substring(0, n) + "...");
                    continue;
                }
                stringBuilder.append(" " + stringArray[i]);
                continue;
            }
            stringBuilder.append(" " + stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String toString(int n, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Type=" + TypeName[n] + " HashID=" + string);
        String[] stringArray = charutil.getSubStringArray(string2, '&', false);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].toUpperCase().startsWith("CONTENT=")) {
                    int n2 = 128;
                    if (stringArray[i].length() > n2) {
                        stringBuilder.append(" " + stringArray[i].substring(0, n2) + "...");
                        continue;
                    }
                    stringBuilder.append(" " + stringArray[i]);
                    continue;
                }
                stringBuilder.append(" " + stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public static StringBuilder getFilteredParams(String string) {
        Object[] objectArray = charutil.getSubStringArray(charutil.replaceChar(string.toUpperCase(), '|', '&'), '&', true);
        Arrays.sort(objectArray);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "DEBUGCACHEVIEW|CUSTOMERID|SOURCE|ISSUPPORT|BROWSER1|RANDOM|ATTACHFILENAME|COOKIE|SESSION1|PARENTID|USER-AGENT|CHAPTER|DEPLOYEDVIEWSONLY|HASHID|NOTIFICATIONREPLYTO|RECIPIENT|REMOTEIP|SOURCESERVER|SOURCESERVERHOST|SOURCESERVERHOSTNAME|SOURCESERVERID|SOURCESERVERPORT|SOURCESERVERPROTOCOL|SUPPRESSDISPLAY|USERPROFILEID|ISPROXYREQUEST";
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            if (((String)objectArray[i]).length() <= 0) continue;
            int n = ((String)objectArray[i]).indexOf("=");
            Object object2 = object = n > 0 ? ((String)objectArray[i]).substring(0, n) : objectArray[i];
            if (arrayList.contains(objectArray[i]) || ("|" + string2 + "|").indexOf("|" + ((String)object).toUpperCase() + "|") >= 0) continue;
            if (((String)objectArray[i]).toUpperCase().startsWith("DIMDRIVERPARAMS")) {
                objectArray[i] = "DimDriverParams=" + charutil.replaceChar(TCacheObj.getFilteredParams(charutil.replaceChar(((String)objectArray[i]).substring(16), '^', '&')).toString(), '&', '^');
            }
            arrayList.add(objectArray[i]);
            if (stringBuilder.length() == 0) {
                stringBuilder.append((String)objectArray[i]);
                continue;
            }
            stringBuilder.append("&" + (String)objectArray[i]);
        }
        return stringBuilder;
    }

    private static String toAscii(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && c != ' ') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getID(int n, String string, String string2) {
        Object object;
        CharSequence charSequence;
        if (string2.trim().length() == 0) {
            String string3 = TPasswordService.encrypt(Integer.toString(n) + string, "123", 11);
            string3 = TCacheObj.toAscii(string3);
            return string3.substring(0, Math.min(string3.length(), 24));
        }
        if (n == 5 && ((String)(charSequence = charutil.getParamValue(string2, "CollectionID", '&').trim())).length() > 0 && (object = TCacheObj.Application.AppCollections.getAppCollectionsObject((String)charSequence)) != null) {
            String string4;
            String string5 = (String)charSequence + string2;
            if (((TAppCollectionsObject)object).CacheIDExpression.trim().length() > 0) {
                String[] stringArray;
                string4 = "#CollectionID+" + ((TAppCollectionsObject)object).CacheIDExpression.trim();
                TFormulaEvaluator tFormulaEvaluator = new TFormulaEvaluator();
                tFormulaEvaluator.setConstant("#CollectionID", charSequence);
                String string6 = charutil.getParamValue(string2, "DriverParams", '&').trim();
                if (string6.length() > 0 && (stringArray = charutil.getSubStringArray(string6, '|', false)) != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', false);
                        if (stringArray2 == null || stringArray2.length <= 1) continue;
                        tFormulaEvaluator.setConstant("#" + stringArray2[0], stringArray2[1]);
                    }
                }
                string5 = objectutil.convertToString(tFormulaEvaluator.getFormulaValue(string4));
            }
            string5 = string5 + (string.trim().length() > 0 ? string : Application.getAspectHashID());
            string4 = charutil.getParamValue(string2, "Filter", '&').trim();
            string5 = string5 + (string4.equalsIgnoreCase("true") ? "" : string4);
            string5 = string5 + charutil.getParamValue(string2, "SystemDriverName", '&').trim();
            string5 = TPasswordService.encrypt(string5, "123", 11);
            string5 = TCacheObj.toAscii(string5);
            string5 = string5.substring(0, Math.min(string5.length(), 24));
            return string5;
        }
        charSequence = TCacheObj.getFilteredParams(string2);
        object = TPasswordService.encrypt(Integer.toString(n) + string + ((StringBuilder)charSequence).toString(), "123", 11);
        object = TCacheObj.toAscii((String)object);
        object = ((String)object).substring(0, Math.min(((String)object).length(), 24));
        if (DebugCache) {
            MainWin.appendToLog("TCacheObj", "getID", Thread.currentThread(), null, 3, "TCacheObj ID=" + (String)object + " for " + Integer.toString(n) + string + ((StringBuilder)charSequence).toString());
        }
        return object;
    }
}

