/*
 * Decompiled with CFR 0.152.
 */
package cache;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCacheObj;
import cache.TDataObject;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TApplication;
import scripts.TExecScript;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.objectutil;
import utility.security.TPasswordService;

public class TDataCollection {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private Hashtable hashRecords = new Hashtable();
    private static Hashtable hDiskIndexRecord = null;
    private static String DiskIndexFilename = null;
    private static long DiskIndexTtl = 86400000L;
    ArrayList arFieldID = new ArrayList();
    String KeyExpression = "";
    String TableID = "";
    String sVersion = "1.0";

    public TDataCollection(String string) {
        this.KeyExpression = string;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 3, "TDataCollection initialized with KeyExpression=" + string);
        }
    }

    public TDataCollection(String string, String string2) {
        this.KeyExpression = string;
        this.TableID = string2;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 3, "TDataCollection initialized with KeyExpression=" + string);
        }
    }

    public TDataCollection(TDriverStruct tDriverStruct, String string) {
        String[] stringArray;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 3, "TDataCollection initialized with DriverStruct and data");
        }
        if ((stringArray = charutil.getSubStringArray(string, '\n', false)) != null && stringArray.length > 3) {
            this.sVersion = stringArray[0];
            String string2 = stringArray[1];
            this.KeyExpression = stringArray[2];
            String[] stringArray2 = charutil.getSubStringArray(stringArray[3], '^', true);
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 3, "TDataCollection Version=" + this.sVersion + " Token=" + string2 + " KeyExpression=" + this.KeyExpression + " Record count=" + (stringArray.length - 4) + " Field count=" + stringArray2.length);
            }
            for (int i = 4; i < stringArray.length; ++i) {
                String[] stringArray3 = charutil.getSubStringArray(stringArray[i], '^', false);
                if (stringArray3 != null && stringArray3.length > 0) {
                    ArrayList<TDataObject> arrayList = new ArrayList<TDataObject>();
                    String string3 = TDataCollection.tokenize(stringArray3[0], string2, false);
                    for (int j = 1; j < stringArray3.length; ++j) {
                        int n = stringArray3[j].indexOf(61);
                        if (n > 0) {
                            String string4 = stringArray3[j].substring(0, n);
                            String string5 = stringArray3[j].substring(n + 1);
                            int n2 = -1;
                            try {
                                n2 = Integer.parseInt(string4);
                            }
                            catch (Exception exception) {
                                MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 4, "Error parsing field index: " + n2 + " in record [" + (i - 4) + "]");
                            }
                            if (n2 >= 0 && n2 < stringArray2.length) {
                                String string6 = stringArray2[n2];
                                TDriverStructRecord tDriverStructRecord = tDriverStruct.getField(string6);
                                if (tDriverStructRecord != null) {
                                    TDataObject tDataObject = new TDataObject(string6, tDriverStructRecord.FieldType, TDataCollection.tokenize(string5, string2, false));
                                    arrayList.add(tDataObject);
                                    continue;
                                }
                                MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 4, "Invalid field ID: " + string6 + " in record [" + (i - 4) + "]");
                                continue;
                            }
                            MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 4, "Invalid field index: " + n2 + " in record [" + (i - 4) + "]");
                            continue;
                        }
                        MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 4, "Invalid data: " + stringArray3[j] + " in record [" + i + "]");
                    }
                    this.hashRecords.put(string3, arrayList);
                    continue;
                }
                MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 4, "Invalid record [" + i + "] in collection");
            }
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 3, "TDataCollection: Parsed " + this.hashRecords.size() + " records");
            }
        } else if (stringArray != null && stringArray.length == 3) {
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 3, "TDataCollection: No data included in constructor.");
            }
        } else {
            MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 4, "TDataCollection: Invalid data in constructor");
        }
    }

    public String getTableID() {
        return this.TableID;
    }

    public void addField(String string, String string2, int n, Object object) {
        if (!this.arFieldID.contains(string2.toUpperCase())) {
            this.arFieldID.add(string2.toUpperCase());
        }
        ArrayList arrayList = null;
        if (this.hashRecords.containsKey(string)) {
            arrayList = (ArrayList)this.hashRecords.get(string);
        } else {
            arrayList = new ArrayList();
            this.hashRecords.put(string, arrayList);
        }
        arrayList.add(new TDataObject(string2, n, object));
    }

    public int getRecordCount() {
        return this.hashRecords.size();
    }

    public Hashtable getRecords() {
        return this.hashRecords;
    }

    public ArrayList getFieldIDs() {
        return this.arFieldID;
    }

    public String toString() {
        if (this.KeyExpression.trim().length() == 0) {
            MainWin.appendToLog("TDataCollection", "init", Thread.currentThread(), null, 3, "TDataCollection.toString() no Key Exprssion defined");
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.sVersion + "\n");
        String string = TPasswordService.generateSalt(4);
        stringBuilder.append(string + "\n");
        stringBuilder.append(this.KeyExpression + "\n");
        for (int i = 0; i < this.arFieldID.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("^");
            }
            stringBuilder.append((String)this.arFieldID.get(i));
        }
        stringBuilder.append("\n");
        Enumeration enumeration = this.hashRecords.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuilder.append(TDataCollection.tokenize(string2, string, true));
            ArrayList arrayList = (ArrayList)this.hashRecords.get(string2);
            for (int i = 0; i < arrayList.size(); ++i) {
                TDataObject tDataObject = (TDataObject)arrayList.get(i);
                stringBuilder.append("^" + this.arFieldID.indexOf(tDataObject.FieldID.toUpperCase()) + "=" + TDataCollection.tokenize(tDataObject.toString(), string, true));
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String tokenize(String string, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (bl) {
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "\"", string2 + "qu");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "^", string2 + "ca");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "=", string2 + "eq");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "\r\n", string2 + "crlf");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "\n", string2 + "lf");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "\r", string2 + "cr");
        } else {
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, string2 + "qu", "\"");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, string2 + "ca", "^");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, string2 + "eq", "=");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, string2 + "crlf", "\r\n");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, string2 + "lf", "\n");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, string2 + "cr", "\r");
        }
        return stringBuilder.toString();
    }

    private static String getDiskIndexFilename() {
        if (DiskIndexFilename != null) {
            return DiskIndexFilename;
        }
        DiskIndexFilename = Application == null ? "c:\\aspect7\\temporary_files\\diskindex_lookup.txt" : Application.getHomeDir() + "temporary_files/diskindex_lookup.txt";
        return DiskIndexFilename;
    }

    private static void initDiskIndexHashtable() {
        long l = new Date().getTime();
        if (hDiskIndexRecord != null) {
            hDiskIndexRecord.clear();
        }
        hDiskIndexRecord = new Hashtable();
        if (new File(TDataCollection.getDiskIndexFilename()).exists()) {
            System.out.println("DiskIndex Hashtable exists");
            String string = TAsciiInput.getEntireFile(TDataCollection.getDiskIndexFilename());
            String[] stringArray = charutil.getSubStringArray(string, '\n', false);
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].indexOf(44);
                System.out.println("a[" + i + "]=" + stringArray[i] + " n=" + n);
                if (n < 0) continue;
                String string2 = stringArray[i].substring(0, n);
                String[] stringArray2 = charutil.getSubStringArray(string2, '|', false);
                if (stringArray2 != null && stringArray2.length == 3) {
                    long l2 = charutil.lval(stringArray2[2]);
                    int n2 = charutil.ival(stringArray[i].substring(n + 1));
                    if (l - l2 < DiskIndexTtl) {
                        hDiskIndexRecord.put(string2, new Integer(n2));
                        System.out.println("added diskindex lookup: " + string2 + "\t" + n2);
                        continue;
                    }
                    System.out.println("discarded diskindex lookup: " + string2 + "\t" + n2);
                    continue;
                }
                System.out.println("Invalid key: " + stringArray[i]);
            }
            TDataCollection.writeDiskIndexHashtable();
        } else {
            System.out.println("DiskIndex Hashtable does not exist");
        }
    }

    private static void writeDiskIndexHashtable() {
        if (hDiskIndexRecord == null) {
            TDataCollection.initDiskIndexHashtable();
        }
        long l = new Date().getTime();
        StringBuilder stringBuilder = new StringBuilder();
        if (hDiskIndexRecord == null) {
            return;
        }
        Enumeration enumeration = hDiskIndexRecord.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = charutil.getSubStringArray(string, '|', false);
            if (stringArray == null || stringArray.length != 3) continue;
            long l2 = charutil.lval(stringArray[2]);
            int n = (Integer)hDiskIndexRecord.get(string);
            if (l2 <= l - DiskIndexTtl) continue;
            stringBuilder.append(string + "," + Integer.toString(n) + "\n");
        }
        TAsciiOutput.writeContent(TDataCollection.getDiskIndexFilename(), stringBuilder.toString());
    }

    public static int getDiskIndex(String string) {
        String string2;
        if (hDiskIndexRecord == null) {
            TDataCollection.initDiskIndexHashtable();
        }
        if (hDiskIndexRecord.containsKey(string2 = string.toUpperCase())) {
            return (Integer)hDiskIndexRecord.get(string2);
        }
        return -1;
    }

    public static void putDiskIndex(String string, int n) {
        if (hDiskIndexRecord == null) {
            TDataCollection.initDiskIndexHashtable();
        }
        String string2 = string.toUpperCase();
        hDiskIndexRecord.put(string2, new Integer(n));
        String string3 = string2 + "," + Integer.toString(n);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(TDataCollection.getDiskIndexFilename(), "rwd");
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.writeBytes(string3 + "\n");
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("Error writing notification server log: " + exception.toString());
        }
    }

    public boolean writeToDriver(String string, String string2, boolean bl) {
        TAspectDriver tAspectDriver;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection opening driver: " + string + " Params=" + string2);
        }
        if ((tAspectDriver = new TAspectDriver(string, 1, false, false, string2)).isValid()) {
            this.writeToDriver(tAspectDriver, bl);
        }
        tAspectDriver.dispose();
        return true;
    }

    public synchronized int writeToDriver(TAspectDriver tAspectDriver, boolean bl) {
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver started RemoveData=" + bl);
            new Throwable().printStackTrace();
        }
        int n = 0;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver hashRecords contains " + this.hashRecords.size() + " entries");
        }
        Enumeration enumeration = this.hashRecords.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            Object object;
            Object object2;
            ArrayList arrayList;
            String string2 = (String)enumeration.nextElement();
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver got KeyValue: " + string2);
            }
            if ((arrayList = (ArrayList)this.hashRecords.get(string2)) == null) {
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver arData is null");
                }
            } else if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver arData contains " + arrayList.size() + " entries");
            }
            int n2 = -1;
            boolean bl2 = false;
            if (string2.toUpperCase().startsWith("DISKINDEX^")) {
                Object object3;
                n2 = TDataCollection.getDiskIndex(string2);
                if (n2 < 0) {
                    n2 = tAspectDriver.initializeNewRecord();
                    TDataCollection.putDiskIndex(string2, n2);
                    bl2 = true;
                    if (TCacheObj.DebugCache) {
                        MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver could not locate record.  Added new record using diskindex r=" + n2);
                    }
                } else if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver located existing diskindex record at r=" + n2);
                }
                if ((object2 = tAspectDriver.F.getDriverStruct().getField("ID_RESERVED_DISKINDEX")) != null) {
                    object3 = objectutil.convertStringToFieldType(((TDriverStructRecord)object2).FieldType, Integer.toString(n2), n2);
                    tAspectDriver.putFieldAbsolute((TDriverStructRecord)object2, n2, object3);
                }
                if ((object2 = tAspectDriver.F.getDriverStruct().getField("ID_RESERVED_EMBEDDED_DISKINDEX")) != null) {
                    object3 = objectutil.convertStringToFieldType(((TDriverStructRecord)object2).FieldType, Integer.toString(n2), n2);
                    tAspectDriver.putFieldAbsolute((TDriverStructRecord)object2, n2, object3);
                }
            } else if (hashtable.containsKey(string2)) {
                n2 = (Integer)hashtable.get(string2);
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver located record in hashKeyValues.  r=" + n2);
                }
            } else {
                object2 = "(" + this.KeyExpression + ")=" + "\"" + string2 + "\"";
                n2 = tAspectDriver.getMatchingRecordAbsolute((String)object2, 0);
                if (n2 < 0) {
                    n2 = tAspectDriver.initializeNewRecord();
                    bl2 = true;
                    if (TCacheObj.DebugCache) {
                        MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver could not locate record using filter: " + (String)object2 + "  Added new record r=" + n2);
                    }
                } else if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver located record using expression: " + (String)object2 + " r=" + n2);
                }
                hashtable.put(string2, new Integer(n2));
            }
            object2 = tAspectDriver.AppDriverObj.DriverID.toString() + "_DataSubmitted";
            boolean bl3 = false;
            StringBuilder stringBuilder = null;
            StringBuilder stringBuilder2 = null;
            if (TDataCollection.Application.AppScripts.isResourceDefined((String)object2)) {
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver executing " + (String)object2);
                }
                bl3 = true;
                stringBuilder = new StringBuilder();
                stringBuilder2 = new StringBuilder();
            } else if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver did not find " + (String)object2);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (TDataObject)arrayList.get(i);
                if (((TDataObject)object).FieldID.toUpperCase().indexOf("DISKINDEX") >= 0) {
                    if (TCacheObj.DebugCache) {
                        MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver skipping field: " + ((TDataObject)object).FieldID + " Value=" + ((TDataObject)object).Value);
                    }
                    if (tAspectDriver.putFieldAbsolute(((TDataObject)object).FieldID, n2, objectutil.convertStringToFieldType(((TDataObject)object).FieldType, Integer.toString(n2), -1)) == 0) {
                        n = -1;
                    }
                } else {
                    if (TCacheObj.DebugCache) {
                        MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 3, "\t\tTDataCollection.writeToDriver writing field: " + ((TDataObject)object).FieldID + " Value=" + ((TDataObject)object).Value);
                    }
                    if (tAspectDriver.putFieldAbsolute(((TDataObject)object).FieldID, n2, ((TDataObject)object).Value) == 0) {
                        n = -1;
                    }
                }
                if (!bl3) continue;
                stringBuilder.append("|" + ((TDataObject)object).FieldID);
                string = objectutil.convertFieldTypeToString(((TDataObject)object).FieldType, ((TDataObject)object).Value);
                if (((TDataObject)object).FieldID.toUpperCase().indexOf("DISKINDEX") >= 0) {
                    string = Integer.toString(n2);
                }
                string = charutil.replaceAllSubstrings(string, "&", "//amp//");
                string = charutil.replaceAllSubstrings(string, "|", "//pipe//");
                stringBuilder2.append("|" + string);
            }
            if (bl) {
                arrayList.clear();
                this.hashRecords.remove(string2);
            }
            if (bl2 && this.KeyExpression.toUpperCase().indexOf("DISKINDEX") < 0) {
                tAspectDriver.getFormulaEvaluator();
                String string3 = TFormulaEvaluator.convertToString(tAspectDriver.getFormulaEvaluator().getFormulaValue(this.KeyExpression, n2, -1));
                if (!string3.equalsIgnoreCase(string2)) {
                    System.out.println("Key of new record does not match.  Calculated=" + string3 + " Recorded=" + string2);
                    object = "ERROR: Key value not fully initialized when adding new record in driver: " + tAspectDriver.AppDriverObj.DriverID.toString();
                    MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 4, "\t\t" + (String)object);
                    object = "If embedded fields are explicity specified, make sure fields used in the keyexpression are included";
                    MainWin.appendToLog("TDataCollection", "writeToDriver", Thread.currentThread(), null, 4, "\t\t" + (String)object);
                }
            }
            tAspectDriver.clearWriteBuffer();
            tAspectDriver.updateSourceFile();
            if (!bl3) continue;
            String string4 = TPasswordService.generateSalt(8);
            object = new TFormulaEvaluator();
            TFormulaEvaluator.addSystemDriver(string4, tAspectDriver);
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(0);
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder2.deleteCharAt(0);
            }
            string = "Driver=" + string4 + "&r=" + Integer.toString(n2) + "&Fields=" + stringBuilder.toString() + "&Values=" + stringBuilder2.toString();
            TExecScript tExecScript = new TExecScript((String)object2, null, (TFormulaEvaluator)object);
            tExecScript.setParameters(string);
            tExecScript.executeScript();
            TFormulaEvaluator.removeSystemDriver(string4);
        }
        return n;
    }
}

