/*
 * Decompiled with CFR 0.152.
 */
package controls;

import controls.TDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import utility.imageutil;

public class TDatePicker
extends JComponent {
    JPanel MainPanel = new JPanel();
    JPanel DatesPanel = new JPanel();
    JPanel TitlePanel = new JPanel();
    GregorianCalendar startingCalendar = new GregorianCalendar();
    int startingMonth = this.startingCalendar.get(2);
    int startingYear = this.startingCalendar.get(1);
    TDatePickerDialog newDialog;
    GregorianCalendar endingCalendar = new GregorianCalendar();
    JButton CancelButton = new JButton("Cancel");
    boolean Cancelled = false;
    private static String WinTitle = "Select Date";
    private static int DialogWidth = 200;
    private static int DialogHeight = 205;
    private static Border borderEmpty = new EmptyBorder(0, 0, 0, 0);
    private static Border borderLine = BorderFactory.createLineBorder(Color.red, 1);
    private Image imagePreviousMonth;
    private Image imageNextMonth;
    private Image imagePreviousYear;
    private Image imageNextYear;

    public TDatePicker(JFrame jFrame, Date date, int n, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.startingYear = gregorianCalendar.get(1);
        this.startingMonth = gregorianCalendar.get(2);
        this.initialize();
        this.newDialog = new TDatePickerDialog(jFrame, WinTitle, true);
        this.newDialog.setResizable(false);
        this.newDialog.setSize(DialogWidth, DialogHeight);
        this.MainPanel = this.drawMain();
        this.newDialog.add(this.MainPanel);
        if (n < 0) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.newDialog.setLocation((int)(dimension.getWidth() - (double)jFrame.getWidth()) / 2, (int)(dimension.getHeight() - (double)jFrame.getHeight()) / 2);
        } else {
            this.newDialog.setLocation(n, n2);
        }
        this.newDialog.setVisible(true);
    }

    public void initialize() {
        this.imagePreviousMonth = imageutil.getScaledImage(this.getClass(), "/images/previous_month.gif", -1, -1);
        this.imageNextMonth = imageutil.getScaledImage(this.getClass(), "/images/next_month.gif", -1, -1);
        this.imagePreviousYear = imageutil.getScaledImage(this.getClass(), "/images/previous_year.gif", -1, -1);
        this.imageNextYear = imageutil.getScaledImage(this.getClass(), "/images/next_year.gif", -1, -1);
    }

    public void setEndDate(int n) {
        this.endingCalendar.set(this.startingYear, this.startingMonth, n);
    }

    public GregorianCalendar getEndDate() {
        return this.endingCalendar;
    }

    public void exitDatePicker(boolean bl) {
        this.newDialog.setVisible(false);
        this.Cancelled = bl;
    }

    public JPanel drawMain() {
        this.MainPanel.setLayout(new BoxLayout(this.MainPanel, 3));
        this.TitlePanel.setLayout(new BoxLayout(this.TitlePanel, 2));
        this.TitlePanel.setPreferredSize(new Dimension(200, 20));
        this.MainPanel.add(this.drawButtons(this.TitlePanel));
        this.DatesPanel.setPreferredSize(new Dimension(200, 145));
        this.MainPanel.add(this.drawDates(this.DatesPanel, this.startingMonth, this.startingYear, 1));
        return this.MainPanel;
    }

    public JPanel drawButtons(JPanel jPanel) {
        jPanel.removeAll();
        JButton jButton = new JButton("");
        jButton.setIcon(new ImageIcon(this.imagePreviousMonth));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TDatePicker.this.startingMonth > 0) {
                    --TDatePicker.this.startingMonth;
                } else {
                    TDatePicker.this.startingMonth = 11;
                    --TDatePicker.this.startingYear;
                }
                TDatePicker.this.MainPanel = TDatePicker.this.drawMain();
            }
        });
        JButton jButton2 = new JButton("");
        jButton2.setIcon(new ImageIcon(this.imageNextMonth));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TDatePicker.this.startingMonth < 11) {
                    ++TDatePicker.this.startingMonth;
                } else {
                    TDatePicker.this.startingMonth = 0;
                    ++TDatePicker.this.startingYear;
                }
                TDatePicker.this.MainPanel = TDatePicker.this.drawMain();
            }
        });
        JButton jButton3 = new JButton("");
        jButton3.setIcon(new ImageIcon(this.imagePreviousYear));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                --TDatePicker.this.startingYear;
                TDatePicker.this.MainPanel = TDatePicker.this.drawMain();
            }
        });
        JButton jButton4 = new JButton("");
        jButton4.setIcon(new ImageIcon(this.imageNextYear));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ++TDatePicker.this.startingYear;
                TDatePicker.this.MainPanel = TDatePicker.this.drawMain();
            }
        });
        Insets insets = new Insets(1, 1, 1, 1);
        jButton.setMargin(insets);
        jButton2.setMargin(insets);
        jButton3.setMargin(insets);
        jButton4.setMargin(insets);
        jButton.setContentAreaFilled(true);
        jButton2.setContentAreaFilled(true);
        jButton3.setContentAreaFilled(true);
        jButton4.setContentAreaFilled(true);
        String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        StringBuilder stringBuilder = new StringBuilder(stringArray[this.startingMonth]);
        stringBuilder = stringBuilder.append(" ");
        stringBuilder = stringBuilder.append(this.startingYear);
        JTextField jTextField = new JTextField(stringBuilder.toString(), 10);
        jTextField.setHorizontalAlignment(0);
        jTextField.setPreferredSize(new Dimension(60, 25));
        jTextField.setEditable(false);
        jPanel.add(jButton3);
        jPanel.add(jButton);
        jPanel.add(jTextField);
        jPanel.add(jButton2);
        jPanel.add(jButton4);
        return jPanel;
    }

    public JPanel drawDates(JPanel jPanel, int n, int n2, int n3) {
        JButton jButton;
        int n4;
        jPanel.removeAll();
        jPanel.setVisible(false);
        jPanel.setLayout(null);
        Border border = BorderFactory.createEtchedBorder(1);
        jPanel.setBorder(border);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(n2, n, n3);
        int n5 = gregorianCalendar.get(7);
        String[] stringArray = new String[]{"S", "M", " T", "W", "T", "F", "S"};
        int n6 = 0;
        int n7 = 0;
        Insets insets = new Insets(1, 1, 1, 1);
        for (n4 = 0; n4 <= 6; ++n4) {
            jButton = new JButton(stringArray[n4]);
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
            jButton.setMargin(insets);
            jButton.setBounds(n6, n7, 27, 20);
            jPanel.add(jButton);
            n6 += 27;
        }
        n6 = (n5 - 1) * 27;
        n7 += 20;
        do {
            n4 = gregorianCalendar.get(5);
            jButton = new JButton(Integer.toString(n4));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
            jButton.setMargin(insets);
            jPanel.add(jButton);
            jButton.setBounds(n6, n7, 27, 20);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TDatePicker.this.setEndDate(n4);
                    TDatePicker.this.exitDatePicker(false);
                }
            });
            if ((n6 += 27) >= 189) {
                n7 += 20;
                n6 = 0;
            }
            gregorianCalendar.add(5, 1);
        } while (gregorianCalendar.get(2) == n);
        jPanel.setVisible(true);
        jPanel.setBackground(Color.WHITE);
        return jPanel;
    }

    public static Date selectDate(JFrame jFrame, Date date, int n, int n2) {
        TDatePicker tDatePicker = new TDatePicker(jFrame, date, n, n2);
        tDatePicker.setVisible(true);
        if (tDatePicker.Cancelled) {
            return null;
        }
        return tDatePicker.getEndDate().getTime();
    }

    private class TDatePickerDialog
    extends TDialog {
        public TDatePickerDialog(JFrame jFrame, String string, boolean bl) {
            super(jFrame, string, bl);
        }

        @Override
        public void escPressed() {
            TDatePicker.this.exitDatePicker(true);
        }
    }
}

