/*
 * Decompiled with CFR 0.152.
 */
package controls;

import aspect.Aspect;
import aspect.TMainWin;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JPanel;
import utility.imageutil;

public class TPanel
extends JPanel {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = false;
    private Image OriginalImage = null;
    private Image BackgroundImage = null;
    private boolean ScaleImage = false;

    public TPanel() {
        if (this.MainWin != null) {
            this.Debug = TMainWin.Application.getTokenValueAsBool("DebugTScrollDialogPanel");
        }
    }

    public void dispose() {
        if (this.OriginalImage != null) {
            this.OriginalImage.flush();
        }
        if (this.BackgroundImage != null) {
            this.BackgroundImage.flush();
        }
    }

    public void setImage(String string, boolean bl) {
        try {
            this.OriginalImage = imageutil.getScaledImage(this.getClass(), string, -1, -1);
            this.ScaleImage = bl;
        }
        catch (Exception exception) {
            if (this.MainWin != null) {
                this.MainWin.appendToLog("TPanel", "setImage", Thread.currentThread(), exception, 4, "Error loading image in TPanel.setImage() '" + string + "'");
            }
            System.out.println("Error loading image in TPanel.setImage(): " + string);
        }
    }

    public void setImage(Image image, boolean bl) {
        this.OriginalImage = image;
        this.ScaleImage = bl;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.OriginalImage != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.BackgroundImage == null) {
                this.BackgroundImage = this.OriginalImage;
            }
            Insets insets = new Insets(0, 0, 0, 0);
            if (this.ScaleImage) {
                if (this.BackgroundImage.getWidth(null) != this.getWidth() || this.BackgroundImage.getHeight(null) != this.getHeight()) {
                    if (this.getBorder() != null) {
                        insets = this.getBorder().getBorderInsets(this);
                        n -= insets.left + insets.right + 0;
                        n2 -= insets.top + insets.bottom + 0;
                    }
                    this.BackgroundImage = imageutil.createResizedCopy(this.BackgroundImage, n, n2, true);
                }
                graphics.drawImage(this.BackgroundImage, insets.top, insets.left, n, n2, this);
            } else {
                graphics.drawImage(this.BackgroundImage, insets.top, insets.left, this.BackgroundImage.getWidth(null), this.BackgroundImage.getHeight(null), this);
            }
        }
    }
}

