/*
 * Decompiled with CFR 0.152.
 */
package controls;

import aspect.Aspect;
import aspect.TMainWin;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.JProgressBar;
import resources.TAppMainObject;
import resources.TAppToolbar;
import resources.TApplication;
import resources.TApplicationListenerEvent;

public class TProgressBar {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    private JProgressBar ToolbarProgressBar = null;
    private String MsgText;
    private Date tmStart = null;
    private int ShowOnMillisecs = 500;
    private int TokenIndex = -1;
    private int MaxItems;
    private int Counter;
    private int Step = 1;
    private int SaveMax = 0;
    private int SaveValue = 0;
    private String SaveMsg = "";
    private boolean SaveIndeterminate = false;
    private boolean ShowProgress = false;
    private Rectangle bounds = null;

    public TProgressBar(String string) {
        this.init(string, 0);
    }

    public TProgressBar(String string, int n) {
        this.init(string, n);
    }

    public TProgressBar(String string, int n, int n2) {
        this.init(string, n);
        this.ShowOnMillisecs = n2;
    }

    public void init(String string, int n) {
        this.ToolbarProgressBar = TAppToolbar.ScrollToolbarProgressBar;
        this.Counter = 0;
        this.MaxItems = n;
        this.MsgText = string;
        this.SaveMsg = TMainWin.Application.getTokenValue("$ActivityLogLastWrite");
        if (this.ToolbarProgressBar != null) {
            this.SaveMax = this.ToolbarProgressBar.getMaximum();
            this.SaveValue = this.ToolbarProgressBar.getValue();
            this.SaveIndeterminate = this.ToolbarProgressBar.isIndeterminate();
        }
        if (this.MsgText.length() > 0) {
            this.setStatusBarToken(this.MsgText);
        }
        if (this.ToolbarProgressBar != null) {
            this.ToolbarProgressBar.setMinimum(0);
            this.ToolbarProgressBar.setMaximum(this.MaxItems);
            this.ToolbarProgressBar.setValue(0);
            if (this.MaxItems <= 0) {
                this.ToolbarProgressBar.setIndeterminate(true);
            }
        }
        this.Step = this.MaxItems / 25;
        if (this.Step < 1) {
            this.Step = 1;
        }
    }

    public void dispose() {
        if (this.ToolbarProgressBar != null) {
            while (this.Counter < this.MaxItems) {
                this.increment();
            }
            this.ToolbarProgressBar.setIndeterminate(this.SaveIndeterminate);
            this.ToolbarProgressBar.setValue(0);
            this.ToolbarProgressBar.setMaximum(this.SaveMax);
            if (this.MainWin.isEventDispatchingThread(Thread.currentThread())) {
                this.ToolbarProgressBar.paintImmediately(this.ToolbarProgressBar.getBounds());
            }
            this.setStatusBarToken(this.SaveMsg);
        }
    }

    public void setStatusBarToken(String string) {
        TAppMainObject tAppMainObject = null;
        boolean bl = false;
        if (this.TokenIndex >= 0 && this.TokenIndex <= this.Application.AppMain.ResourceColl.size()) {
            tAppMainObject = (TAppMainObject)this.Application.AppMain.ResourceColl.get(this.TokenIndex);
            if (!tAppMainObject.TokenID.equalsIgnoreCase("$ActivityLogLastWrite")) {
                tAppMainObject.Value.setLength(0);
                tAppMainObject.Value.append(string);
                bl = true;
            }
        }
        if (!bl) {
            for (int i = 0; i < this.Application.AppMain.ResourceColl.size(); ++i) {
                tAppMainObject = (TAppMainObject)this.Application.AppMain.ResourceColl.get(i);
                if (!tAppMainObject.TokenID.equalsIgnoreCase("$ActivityLogLastWrite")) continue;
                tAppMainObject.Value.setLength(0);
                tAppMainObject.Value.append(string);
                this.TokenIndex = i;
                bl = true;
            }
        }
        if (!bl) {
            tAppMainObject = new TAppMainObject("$ActivityLogLastWrite", "AMsg");
            this.Application.AppMain.ResourceColl.add(tAppMainObject);
            this.TokenIndex = this.Application.AppMain.ResourceColl.size() - 1;
        }
        this.Application.notifyListeners(new TApplicationListenerEvent(0, tAppMainObject.TokenID, tAppMainObject.Value.toString()));
    }

    public void checkTime() {
        if (this.ShowProgress || this.Counter < 1) {
            return;
        }
        if (this.MaxItems <= 0) {
            this.ShowProgress = true;
            return;
        }
        if (this.tmStart == null) {
            this.tmStart = new Date();
        } else {
            Date date = new Date();
            double d = (double)(date.getTime() - this.tmStart.getTime()) / (double)this.Counter;
            double d2 = (double)(this.MaxItems - this.Counter) * d;
            if (d2 > (double)this.ShowOnMillisecs) {
                this.ShowProgress = true;
            }
        }
    }

    public void setValue(int n) {
        this.Counter = n - 1;
        this.increment();
    }

    public void increment() {
        ++this.Counter;
        if (this.Counter > this.MaxItems) {
            this.Counter = 0;
        }
        if (this.Counter % this.Step == 0) {
            this.checkTime();
            if (this.ShowProgress && this.ToolbarProgressBar != null && this.MaxItems > 0) {
                this.ToolbarProgressBar.setValue(this.Counter);
                if (this.bounds == null) {
                    this.bounds = this.ToolbarProgressBar.getBounds();
                    this.bounds.x = 0;
                    this.bounds.y = 0;
                }
                if (this.MainWin.isEventDispatchingThread(Thread.currentThread())) {
                    this.ToolbarProgressBar.paintImmediately(this.bounds);
                }
            }
        }
    }
}

