/*
 * Decompiled with CFR 0.152.
 */
package controls.editors;

import aspect.TMainWin;
import controls.TCheckBox;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import utility.TFormulaEvaluator;

public class TCheckBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    TCheckBox checkbox;
    TAspectDriver AspectDriver;
    boolean isBordered;
    Border unselectedBorder = null;
    Border selectedBorder = null;

    public TCheckBoxCellEditor(boolean bl, TAspectDriver tAspectDriver) {
        this.isBordered = bl;
        this.AspectDriver = tAspectDriver;
        this.checkbox = new TCheckBox();
        this.checkbox.setOpaque(true);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.checkbox.setHorizontalAlignment(2);
        this.checkbox.setVerticalAlignment(0);
        this.checkbox.setIcon(null);
        this.checkbox.setSelected((Boolean)object);
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n2);
        if (tDriverStructRecord != null) {
            Object object2;
            switch (tDriverStructRecord.RendererHorzIconPosition) {
                case 0: 
                case 1: {
                    this.checkbox.setHorizontalTextPosition(4);
                    break;
                }
                case 3: {
                    this.checkbox.setHorizontalTextPosition(0);
                    break;
                }
                case 2: {
                    this.checkbox.setHorizontalTextPosition(2);
                    break;
                }
                case 4: {
                    this.checkbox.setHorizontalTextPosition(11);
                    break;
                }
                case 5: {
                    this.checkbox.setHorizontalTextPosition(10);
                }
            }
            switch (tDriverStructRecord.RendererVertIconPosition) {
                case 0: 
                case 3: {
                    this.checkbox.setVerticalTextPosition(0);
                    break;
                }
                case 1: {
                    this.checkbox.setVerticalTextPosition(3);
                    break;
                }
                case 2: {
                    this.checkbox.setVerticalTextPosition(1);
                }
            }
            TFormulaEvaluator tFormulaEvaluator = new TFormulaEvaluator(this.AspectDriver.getFormulaEvaluator());
            switch (tDriverStructRecord.RendererHorzLabelPosition) {
                case 0: 
                case 3: {
                    this.checkbox.setHorizontalAlignment(0);
                    break;
                }
                case 1: {
                    this.checkbox.setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    this.checkbox.setHorizontalAlignment(4);
                    break;
                }
                case 4: {
                    this.checkbox.setHorizontalAlignment(10);
                    break;
                }
                case 5: {
                    this.checkbox.setHorizontalAlignment(11);
                }
            }
            switch (tDriverStructRecord.RendererVertLabelPosition) {
                case 0: 
                case 3: {
                    this.checkbox.setVerticalAlignment(0);
                    break;
                }
                case 1: {
                    this.checkbox.setVerticalAlignment(1);
                    break;
                }
                case 2: {
                    this.checkbox.setVerticalAlignment(3);
                }
            }
            if (tDriverStructRecord.RendererLabel != null && tDriverStructRecord.RendererLabel.length() > 0 && (object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.RendererLabel, this.AspectDriver.getAbsoluteDiskIndex(n), n)) != null) {
                String string = TMainWin.Application.parse_tokens(TFormulaEvaluator.convertToString(object2));
                this.checkbox.setText("<html>" + string);
            }
        }
        if (this.isBordered) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, jTable.getSelectionBackground());
            }
            this.checkbox.setBorder(this.selectedBorder);
        }
        return this.checkbox;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= TMainWin.Application.getTokenValueAsInt("$EditClickCount");
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return new Boolean(this.checkbox.isSelected());
    }
}

