/*
 * Decompiled with CFR 0.152.
 */
package controls.editors;

import aspect.TMainWin;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import scrollwin.table.TScrollTable;
import utility.charutil;

public class TNumberSpinnerCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ChangeListener {
    TNumberSpinner NumberSpinner;
    boolean IgnoreFirstKeypress = false;

    public TNumberSpinnerCellEditor(int n, int n2, int n3) {
        this.NumberSpinner = new TNumberSpinner(n, n, n2, n3);
    }

    public TNumberSpinnerCellEditor(double d, double d2, double d3) {
        this.NumberSpinner = new TNumberSpinner(d, d, d2, d3);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.NumberSpinner.KeyCount = 0;
        if (this.IgnoreFirstKeypress) {
            this.NumberSpinner.KeyCount = 1;
            this.IgnoreFirstKeypress = false;
        }
        this.NumberSpinner.setTable((TScrollTable)jTable);
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.NumberSpinner.getModel();
        this.NumberSpinner.setValue(object);
        this.NumberSpinner.addChangeListener(this);
        return this.NumberSpinner;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            if (((MouseEvent)eventObject).getClickCount() >= TMainWin.Application.getTokenValueAsInt("$EditClickCount")) {
                this.IgnoreFirstKeypress = true;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        Object object = this.NumberSpinner.getValue();
        return object;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    public class TNumberSpinner
    extends JSpinner
    implements ActionListener {
        private TScrollTable table;
        public double MinValue;
        public double MaxValue;
        public double StepValue;
        private boolean IsFloatingPoint;
        private int KeyCount;

        public TNumberSpinner(int n, int n2, int n3, int n4) {
            this.table = null;
            this.IsFloatingPoint = false;
            this.KeyCount = 0;
            int n5 = n;
            this.MinValue = n2;
            this.MaxValue = n3;
            this.StepValue = n4;
            if ((double)n5 < this.MinValue) {
                n5 = (int)this.MinValue;
            }
            if (this.MaxValue < this.MinValue) {
                this.MaxValue = this.MinValue;
            }
            this.setModel(new SpinnerNumberModel(n5, (int)this.MinValue, (int)this.MaxValue, n4));
            this.setEditor(new JSpinner.NumberEditor((JSpinner)this, "#"));
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, false);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(9, 0, false);
            KeyStroke keyStroke4 = KeyStroke.getKeyStroke(9, 1, false);
            this.getTextField().registerKeyboardAction(this, "StopEditing", keyStroke, 0);
            this.getTextField().registerKeyboardAction(this, "CancelEditing", keyStroke2, 0);
            this.getTextField().registerKeyboardAction(this, "TabPressed", keyStroke3, 0);
            this.getTextField().registerKeyboardAction(this, "ShiftTabPressed", keyStroke4, 0);
        }

        public TNumberSpinner(double d, double d2, double d3, double d4) {
            this.table = null;
            this.IsFloatingPoint = false;
            this.KeyCount = 0;
            this.IsFloatingPoint = true;
            double d5 = d;
            this.MinValue = d2;
            this.MaxValue = d3;
            this.StepValue = d4;
            if (d5 < this.MinValue) {
                d5 = this.MinValue;
            }
            if (this.MaxValue < this.MinValue) {
                this.MaxValue = this.MinValue;
            }
            this.setModel(new SpinnerNumberModel(d5, this.MinValue, this.MaxValue, d4));
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumFractionDigits(2);
            decimalFormat.setMaximumFractionDigits(2);
            this.setEditor(new JSpinner.NumberEditor((JSpinner)this, decimalFormat.toPattern()));
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, false);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(9, 0, false);
            KeyStroke keyStroke4 = KeyStroke.getKeyStroke(9, 1, false);
            this.getTextField().registerKeyboardAction(this, "StopEditing", keyStroke, 0);
            this.getTextField().registerKeyboardAction(this, "CancelEditing", keyStroke2, 0);
            this.getTextField().registerKeyboardAction(this, "TabPressed", keyStroke3, 0);
            this.getTextField().registerKeyboardAction(this, "ShiftTabPressed", keyStroke4, 0);
        }

        @Override
        public void setOpaque(boolean bl) {
            if (this.getTextField() != null) {
                this.getTextField().setOpaque(bl);
                ((JComponent)this.getTextField().getParent()).setOpaque(bl);
            }
        }

        public void setTable(TScrollTable tScrollTable) {
            this.table = tScrollTable;
        }

        public JFormattedTextField getTextField() {
            JComponent jComponent = this.getEditor();
            if (jComponent instanceof JSpinner.DefaultEditor) {
                return ((JSpinner.DefaultEditor)jComponent).getTextField();
            }
            return null;
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            ++this.KeyCount;
            if (this.KeyCount == 1) {
                StringBuilder stringBuilder = new StringBuilder();
                char c = keyEvent.getKeyChar();
                boolean bl2 = true;
                if (c == '-' || c >= '0' && c <= '9' || c == '.' && this.IsFloatingPoint) {
                    stringBuilder.append(c);
                    bl2 = true;
                    if (c == '-') {
                        if (this.MinValue >= 0.0) {
                            bl2 = false;
                        }
                    } else {
                        int n2 = charutil.ival(stringBuilder);
                        if ((double)n2 < this.MinValue || (double)n2 > this.MaxValue) {
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        double d = charutil.dval(stringBuilder);
                        Object object = this.getModel().getValue();
                        if (object instanceof Byte) {
                            this.getModel().setValue(new Byte((byte)d));
                        } else if (object instanceof Short) {
                            this.getModel().setValue(new Short((short)d));
                        } else if (object instanceof Integer) {
                            this.getModel().setValue(new Integer((int)d));
                        } else if (object instanceof Long) {
                            this.getModel().setValue(new Long((long)d));
                        } else if (object instanceof Double) {
                            this.getModel().setValue(new Double(d));
                        }
                        this.getTextField().setText(stringBuilder.toString());
                        this.getTextField().setCaretPosition(1);
                        return true;
                    }
                }
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equalsIgnoreCase("StopEditing") || string.equalsIgnoreCase("TabPressed") || string.equalsIgnoreCase("ShiftTabPressed")) {
                try {
                    this.commitEdit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TNumberSpinnerCellEditor.this.stopCellEditing();
                if (this.table != null) {
                    if (string.equalsIgnoreCase("TabPressed")) {
                        this.table.advanceColumn();
                    } else if (string.equalsIgnoreCase("ShiftTabPressed")) {
                        this.table.previousColumn();
                    } else {
                        this.table.advanceRow();
                    }
                }
            } else if (string.equalsIgnoreCase("CancelEditing")) {
                this.KeyCount = 0;
                TNumberSpinnerCellEditor.this.cancelCellEditing();
            }
        }
    }
}

