/*
 * Decompiled with CFR 0.152.
 */
package controls.htmlviewer;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import controls.htmlviewer.THtmlConstant;
import controls.htmlviewer.THtmlContent;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverDisplay;
import drivers.aspect.TDriverStructRecord;
import drivers.aspect.TPivotTableDriver;
import drivers.consolidated.TConsolidatedHorzDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TAppActionObject;
import resources.TAppCollectionsObject;
import resources.TAppDriversObject;
import scripts.TExecScript;
import scrollwin.subtotaltree.TScrollSubtotalTree;
import scrollwin.subtotaltree.TScrollSubtotalTreeNode;
import utility.TFormulaEvaluator;
import utility.TGoogleChart;
import utility.THtmlTag;
import utility.TProfiler;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.notifications.TNotification;
import utility.objectutil;
import utility.security.TPasswordService;

public class THtmlInclude {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug;
    private Hashtable hashArguments;
    private StringBuilder strProcessedHtml;
    private ArrayList arConstants;
    private String strOriginalSource;
    private String strOriginalTag;
    private String sDocumentID;
    private String sWidget;
    private String sContainerItemID;
    private String sUserAgent;
    private String sRemoteIP;
    private boolean bIsMobileDoc;
    private String PageArgs;
    private boolean IsEmail;
    private String ThreadName;

    /*
     * Unable to fully structure code
     */
    public THtmlInclude(String var1_1, ArrayList var2_2, String var3_3, String var4_4, String var5_5, String var6_6, String var7_7, boolean var8_8, String var9_9, String var10_10, String var11_11) {
        super();
        if (Boolean.FALSE.booleanValue()) ** GOTO lbl-1000
        if (TMainWin.Application.getTokenValueAsBool("DebugTHtmlInclude")) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        this.Debug = v0;
        this.hashArguments = new Hashtable<K, V>();
        this.strProcessedHtml = new StringBuilder();
        this.strOriginalSource = "";
        this.strOriginalTag = "";
        this.sDocumentID = "";
        this.sWidget = "";
        this.sContainerItemID = "";
        this.sUserAgent = "";
        this.sRemoteIP = "";
        this.bIsMobileDoc = false;
        this.PageArgs = "";
        this.IsEmail = false;
        this.ThreadName = "";
        if (this.Debug) {
            this.MainWin.appendToLog("THtmlInclude", "init", Thread.currentThread(), null, 3, "Initializing include tag: '" + var1_1 + "'");
        }
        this.arConstants = var2_2;
        this.setIncludeTag(var1_1);
        this.strOriginalTag = var1_1;
        this.strOriginalSource = var3_3;
        this.sDocumentID = var4_4;
        this.sWidget = var5_5;
        this.sContainerItemID = var6_6;
        this.sUserAgent = var7_7;
        this.sRemoteIP = var10_10;
        this.bIsMobileDoc = var8_8;
        this.ThreadName = var9_9;
        this.PageArgs = var11_11;
        this.IsEmail = var11_11.toUpperCase().indexOf("PREPAREEMAIL=TRUE") >= 0;
        this.processTag();
    }

    public void setIncludeTag(String string) {
        String[] stringArray;
        boolean bl = false;
        this.hashArguments.clear();
        this.strProcessedHtml.setLength(0);
        String string2 = string.substring(1, string.length() - 1);
        if (string2.toUpperCase().startsWith("INCLUDE")) {
            string2 = string2.substring(7);
        } else {
            string2 = string2.substring(8);
            this.hashArguments.put("TYPE", "CONSTANT");
            bl = true;
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        charutil.remove_char(stringBuilder, stringBuilder, '\r');
        charutil.remove_char(stringBuilder, stringBuilder, '\t');
        if (!string2.toUpperCase().trim().startsWith("TYPE:SCRIPT")) {
            charutil.remove_char(stringBuilder, stringBuilder, '\n');
        }
        string2 = stringBuilder.toString();
        if ((string2 = TMainWin.Application.parse_tokens(string2)).endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((stringArray = charutil.getSubStringArray(string2, ';', false)) != null && stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().length() <= 0) continue;
                int n = stringArray[i].trim().indexOf(58);
                if (n > 0) {
                    string2 = stringArray[i].substring(0, n);
                    String string3 = stringArray[i].substring(n + 1);
                    if (bl) {
                        string2 = charutil.removeQuotes(string2);
                        string3 = charutil.removeQuotes(string3);
                    }
                    if (bl) {
                        if (string2.trim().equalsIgnoreCase("name")) {
                            if (string3.trim().length() > 0) {
                                this.hashArguments.put(string2.toUpperCase().trim(), string3.trim());
                                continue;
                            }
                            return;
                        }
                        this.hashArguments.put(string2.toUpperCase().trim(), string3.trim());
                        continue;
                    }
                    string3 = charutil.replaceAllSubstrings(string3, "~0x3B~", ";");
                    this.hashArguments.put(string2.toUpperCase().trim(), string3.trim());
                    continue;
                }
                this.MainWin.appendToLog("THtmlInclude", "setIncludeTag", Thread.currentThread(), null, 4, "Error in include tag expression " + stringArray[i] + " in include tag: " + string);
            }
        }
    }

    public void processConstant() {
        if (this.hashArguments.size() == 1) {
            return;
        }
        if (!this.hashArguments.containsKey("NAME") || !this.hashArguments.containsKey("VALUE")) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeFile", Thread.currentThread(), null, 3, "Missing name or value in constant tag.  Use 'NAME:name Value:value'");
            System.out.println("strOriginalTag=" + this.strOriginalTag);
            return;
        }
        String string = (String)this.hashArguments.get("NAME");
        String string2 = charutil.removeQuotes((String)this.hashArguments.get("VALUE"));
        if (this.arConstants != null) {
            this.arConstants.add(new THtmlConstant(string, string2));
        }
    }

    public void processScript() {
        if (!this.hashArguments.containsKey("COMMANDS")) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeFile", Thread.currentThread(), null, 3, "No commands specified for script include tag.  Use 'COMMANDS:[list of commands separated by pipes]");
            return;
        }
        String[] stringArray = charutil.getSubStringArray(charutil.removeQuotes((String)this.hashArguments.get("COMMANDS")), '\n', false);
        if (stringArray != null) {
            if (this.Debug) {
                System.out.println("script include tag commands:");
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println("\t" + stringArray[i]);
                }
            }
            String string = "";
            if (this.hashArguments.containsKey("NAME")) {
                string = (String)this.hashArguments.get("NAME");
                string = charutil.replaceAllSubstrings(string, "/", "\\");
            }
            if (string.trim().length() == 0) {
                string = this.sDocumentID + "_" + this.sWidget + "_" + this.sContainerItemID;
            }
            if (this.ThreadName.length() > 0) {
                string = this.ThreadName;
            }
            String string2 = TMainWin.Application.AppScripts.addScript(stringArray, string);
            TExecScript tExecScript = new TExecScript(string2, null, null);
            long l = new Date().getTime();
            tExecScript.start();
            while (tExecScript.isAlive() && !tExecScript.isFinished()) {
                try {
                    long l2 = new Date().getTime();
                    if (l2 - l > 60000L) {
                        this.MainWin.appendToLog("THtmlInclude", "processScript", Thread.currentThread(), null, 3, "THtmlInclude waiting on script: " + string2);
                        l = l2;
                    }
                    Thread.yield();
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            String string3 = objectutil.convertToString(tExecScript.getScriptResult());
            this.strProcessedHtml.append(string3);
            TMainWin.Application.AppScripts.removeScript(string2);
        }
    }

    public void processFile() {
        TAsciiInput tAsciiInput;
        Object object;
        String string;
        if (this.Debug) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeFile", Thread.currentThread(), null, 3, "Processing include tag.  Type = file.");
        }
        if (!this.hashArguments.containsKey("NAME") && !this.hashArguments.containsKey("EVALNAME")) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeFile", Thread.currentThread(), null, 3, "No file name specified.  Use 'NAME:FILENAME' or 'EVALNAME:FILENAME'");
            return;
        }
        byte[] byArray = null;
        if (this.hashArguments.containsKey("NAME")) {
            string = charutil.removeQuotes((String)this.hashArguments.get("NAME"));
            if (string.startsWith("=")) {
                object = new TFormulaEvaluator().getFormulaValue(string, 0, 0);
                string = objectutil.convertToString(object);
            }
        } else {
            object = new TFormulaEvaluator().getFormulaValue((String)this.hashArguments.get("EVALNAME"), 0, 0);
            string = objectutil.convertToString(object);
        }
        if (this.Debug) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeFile", Thread.currentThread(), null, 3, "Reading include file: " + string);
        }
        if ((tAsciiInput = new TAsciiInput(string, '\u0000', true)).isValid() && (byArray = tAsciiInput.get_entire_file()) != null) {
            object = new THtmlContent(new String(byArray), false, this.strOriginalSource);
            this.strProcessedHtml.append(((THtmlContent)object).getProcessedContent());
        }
        tAsciiInput.dispose();
    }

    private void processExpression() {
        if (this.Debug) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeExpression", Thread.currentThread(), null, 3, "Processing include tag.  Type = expression ");
        }
        if (!this.hashArguments.containsKey("EXPRESSION")) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeExpression", Thread.currentThread(), null, 3, "No expression specified.  Use 'EXPRESSION:expression'");
            return;
        }
        String string = charutil.removeQuotes((String)this.hashArguments.get("EXPRESSION"));
        string = charutil.replaceAllSubstrings(string, "\\'", "$#singlequote#$");
        string = charutil.replaceChar(string, '\'', '\"');
        if (this.Debug) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeExpression", Thread.currentThread(), null, 3, "Evaluating expression: " + string);
        }
        Object object = new TFormulaEvaluator().getFormulaValue(string, 0, 0);
        string = objectutil.convertToString(object);
        string = charutil.replaceAllSubstrings(string, "$#singlequote#$", "'");
        string = charutil.replaceAllSubstrings(string, "\\>", ">");
        string = charutil.replaceAllSubstrings(string, "\\<", "<");
        if (this.Debug) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeExpression", Thread.currentThread(), null, 3, "Result of expression: " + string);
        }
        this.strProcessedHtml.append(string);
    }

    private void executeDriverPreActions(TAppDriversObject tAppDriversObject) {
        Object object;
        int n;
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (tAppDriversObject.ExecuteOnOpenMethod.length() > 0) {
            TMainWin.Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnOpenMethod);
            stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
            if (stringArray != null) {
                for (n = 0; !bl && n < stringArray.length; ++n) {
                    object = TMainWin.execClassMethod(stringArray[n]);
                    if (object == null || !(object instanceof Boolean) || ((Boolean)object).booleanValue()) continue;
                    bl = true;
                }
            }
        }
        if (!bl && tAppDriversObject.ExecuteOnOpenAction.length() > 0) {
            TMainWin.Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnOpenAction);
            stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
            if (stringArray != null) {
                for (n = 0; !bl && n < stringArray.length; ++n) {
                    object = TMainWin.Application.AppAction.getAppActionObject(stringArray[n]);
                    if (object == null || this.MainWin.executeActionObject(((TAppActionObject)object).ActionObject, null)) continue;
                    bl = true;
                }
            }
        }
        if (!bl && tAppDriversObject.ExecuteOnOpenScript.length() > 0) {
            object = new TExecScript(tAppDriversObject.ExecuteOnOpenScript, null, null);
            ((Thread)object).start();
            if (tAppDriversObject.WaitForScript) {
                while (((Thread)object).isAlive()) {
                    Thread.yield();
                    if (!(Math.random() < 0.1)) continue;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void executeDriverPostActions(TAppDriversObject tAppDriversObject) {
        Object object;
        int n;
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (tAppDriversObject.ExecuteOnCloseMethod.length() > 0) {
            TMainWin.Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnCloseMethod);
            stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    TMainWin.execClassMethod(stringArray[n]);
                }
            }
        }
        if (tAppDriversObject.ExecuteOnCloseAction.length() > 0) {
            TMainWin.Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnCloseAction);
            stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    object = TMainWin.Application.AppAction.getAppActionObject(stringArray[n]);
                    if (object == null) continue;
                    this.MainWin.executeActionObject(((TAppActionObject)object).ActionObject, null);
                }
            }
        }
        if (tAppDriversObject.ExecuteOnCloseScript.length() > 0) {
            object = new TExecScript(tAppDriversObject.ExecuteOnCloseScript, null, null);
            ((Thread)object).start();
        }
    }

    private void processDriver() {
        Object object;
        String string;
        String string2;
        CharSequence charSequence;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        int n2;
        Object object6;
        Object object7;
        String string3;
        int n3;
        Object object8;
        int n4;
        Object object9;
        String[] stringArray;
        Object object10;
        Object object11;
        CharSequence charSequence2;
        String string4;
        String string5;
        Date date = new Date();
        TAspectDriver tAspectDriver = null;
        TAppDriversObject tAppDriversObject = null;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        String string6 = "";
        ArrayList<String> arrayList = null;
        if (this.hashArguments.containsKey("EXPORTTABLE") && charutil.removeQuotes((String)this.hashArguments.get("EXPORTTABLE")).equalsIgnoreCase("true")) {
            bl4 = true;
            string6 = charutil.removeQuotes((String)this.hashArguments.get("EXPORTFORMAT"));
        }
        if (this.Debug) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeDriver", Thread.currentThread(), null, 3, "Processing include tag.  Type = driver");
        }
        if (!this.hashArguments.containsKey("DRIVER")) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeExpression", Thread.currentThread(), null, 3, "No driver ID specified.  Use 'driver:driver ID'");
            return;
        }
        String string7 = charutil.removeQuotes(charutil.tokenizeSpecialChars((String)this.hashArguments.get("DRIVER"), false));
        Enumeration enumeration = this.hashArguments.keys();
        while (enumeration.hasMoreElements()) {
            string5 = (String)enumeration.nextElement();
            string4 = (String)this.hashArguments.get(string5);
            if (string4.toUpperCase().indexOf("//HASH//") < 0) continue;
            this.hashArguments.put(string5, charutil.replaceAllSubstrings(string4, "//HASH//", "#"));
        }
        string5 = "";
        if (this.hashArguments.containsKey("PARAMS")) {
            string5 = charutil.removeQuotes((String)this.hashArguments.get("PARAMS"));
        }
        string4 = charutil.getParamValue(string5, "metadata", '|');
        Hashtable<String, String> hashtable = null;
        enumeration = this.hashArguments.keys();
        while (enumeration.hasMoreElements()) {
            String[] stringArray2;
            charSequence2 = (String)enumeration.nextElement();
            if (!((String)charSequence2).toUpperCase().startsWith("XEXTERNALPARAM")) continue;
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            if ((stringArray2 = charutil.getSubStringArray((String)(object11 = charutil.removeQuotes((String)this.hashArguments.get(charSequence2))), '^', true)) != null && stringArray2.length == 2) {
                object10 = charutil.replaceAllSubstrings(stringArray2[0], "$value$", stringArray2[1]);
                stringArray = charutil.getSubStringArray((String)object10, '=', true);
                if (stringArray == null || stringArray.length != 2) continue;
                hashtable.put(stringArray[0].toUpperCase(), stringArray[1]);
                if (!stringArray[0].equalsIgnoreCase("metadata")) continue;
                string4 = stringArray[1];
                continue;
            }
            this.MainWin.appendToLog("tHtmlInclude", "processDriver", Thread.currentThread(), null, 10, "Invalid external driver param: " + (String)charSequence2 + "=" + (String)object11);
        }
        if (hashtable != null) {
            charSequence2 = new StringBuilder();
            object11 = charutil.getSubStringArray(string5, '|', false);
            if (object11 != null && ((String[])object11).length > 0) {
                for (int i = 0; i < ((String[])object11).length; ++i) {
                    int n5 = object11[i].indexOf(61);
                    if (n5 > 0) {
                        stringArray = new String[2];
                        stringArray[0] = object11[i].substring(0, n5);
                        if (object11[i].length() > n5) {
                            stringArray[1] = object11[i].substring(n5 + 1);
                        }
                        if (hashtable.containsKey(stringArray[0].toUpperCase())) {
                            ((StringBuilder)charSequence2).append("|" + stringArray[0] + "=" + hashtable.get(stringArray[0].toUpperCase()));
                            hashtable.remove(stringArray[0]);
                            continue;
                        }
                        if (stringArray[0].equalsIgnoreCase("DimDriverParams")) {
                            object9 = charutil.getSubStringArray(stringArray[1], '^', false);
                            StringBuilder stringBuilder = new StringBuilder();
                            if (object9 != null) {
                                for (n4 = 0; n4 < ((String[])object9).length; ++n4) {
                                    object8 = charutil.getSubStringArray(object9[n4], '=', false);
                                    if (object8 != null && ((String[])object8).length == 2) {
                                        if (hashtable.containsKey(object8[0].toUpperCase())) {
                                            stringBuilder.append("^" + object8[0] + "=" + hashtable.get(object8[0].toUpperCase()));
                                            continue;
                                        }
                                        stringBuilder.append("^" + object9[n4]);
                                        continue;
                                    }
                                    if (object8 != null) continue;
                                    System.out.println("b=null");
                                }
                            } else {
                                System.out.println("arDimDriverParams=null");
                            }
                            if (stringBuilder.length() > 0) {
                                stringBuilder.deleteCharAt(0);
                            }
                            ((StringBuilder)charSequence2).append("|DimDriverParams=" + stringBuilder.toString());
                            continue;
                        }
                        ((StringBuilder)charSequence2).append("|" + (String)object11[i]);
                        continue;
                    }
                    ((StringBuilder)charSequence2).append("|" + object11[i]);
                }
            }
            if (hashtable.size() > 0) {
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    String string8 = (String)enumeration2.nextElement();
                    ((StringBuilder)charSequence2).append("|" + string8 + "=" + hashtable.get(string8));
                }
            }
            if (((StringBuilder)charSequence2).length() > 0) {
                ((StringBuilder)charSequence2).deleteCharAt(0);
            }
            if (arrayList != null) {
                arrayList.add("Updated Params:\t" + ((StringBuilder)charSequence2).toString());
            }
            string5 = ((StringBuilder)charSequence2).toString();
        }
        if (this.hashArguments.containsKey("DEBUG") && charutil.removeQuotes((String)this.hashArguments.get("DEBUG")).equalsIgnoreCase("true")) {
            this.MainWin.appendToLog("THtmlInclude", "processDriver", Thread.currentThread(), null, 3, "DriverInclude: Debug include tag for driver: " + string7);
            this.MainWin.appendToLog("THtmlInclude", "processDriver", Thread.currentThread(), null, 3, "DriverInclude: Params: " + string5);
            arrayList = new ArrayList<String>();
        }
        if (arrayList != null) {
            arrayList.add("Time Start: " + dateutil.formatDate(new Date(), "HH:mm:ss"));
        }
        if (this.hashArguments.containsKey("SYSTEMDRIVER")) {
            bl3 = charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("SYSTEMDRIVER")));
            if (arrayList != null) {
                arrayList.add("SystemDriver: " + bl3);
            }
        }
        if (arrayList != null) {
            if (this.hashArguments.containsKey("EMBEDVALUES")) {
                arrayList.add("EmbedValues: " + charutil.removeQuotes((String)this.hashArguments.get("EMBEDVALUES")));
            } else {
                arrayList.add("EmbedValues: Not specified");
            }
        }
        CharSequence charSequence3 = charSequence2 = this.hashArguments.containsKey("HASHID") ? charutil.removeQuotes((String)this.hashArguments.get("HASHID")) : "";
        if (((String)charSequence2).trim().length() == 0) {
            charSequence2 = TMainWin.Application.getAspectHashID();
            this.hashArguments.put("HASHID", charSequence2);
        }
        if (!this.hashArguments.containsKey("ISMOBILEDOC")) {
            this.hashArguments.put("ISMOBILEDOC", new Boolean(this.bIsMobileDoc).toString());
        }
        if (arrayList != null) {
            arrayList.add("Include Driver:\t" + string7);
            arrayList.add("Driver Params:\t" + string5);
        }
        if (!bl3) {
            tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject(string7);
            if (tAppDriversObject == null) {
                this.MainWin.appendToLog("THtmlInclude", "processDriver", Thread.currentThread(), null, 3, "The driver ID '" + string7 + "' is not recognized.");
                return;
            }
            if (((String)charSequence2).trim().length() > 0) {
                if (arrayList != null) {
                    arrayList.add("TCacheDriver.  Params=" + string5);
                }
                tAspectDriver = TFormulaEvaluator.getCache().openCacheDriver((String)charSequence2, string7, 1, string5);
            } else {
                this.executeDriverPreActions(tAppDriversObject);
                if (arrayList != null) {
                    arrayList.add("Open Driver.  Params=" + string5);
                }
                tAspectDriver = new TAspectDriver(string7, 1, true, false, string5);
            }
            if (tAspectDriver == null) {
                this.MainWin.appendToLog("THtmlInclude", "processDriver", Thread.currentThread(), null, 3, "Error opening driver with ID=" + string7);
                return;
            }
        } else {
            tAspectDriver = TFormulaEvaluator.getSystemDriver(string7, false);
            if (arrayList != null) {
                arrayList.add("System Driver name=" + string7);
            }
            if (tAspectDriver == null) {
                this.MainWin.appendToLog("THtmlInclude", "processDriver", Thread.currentThread(), null, 3, "Error opening system driver with ID=" + string7);
                return;
            }
        }
        if (tAspectDriver.isValid() && arrayList != null) {
            tAspectDriver.F.enableFieldProfile();
            arrayList.add("DeleteMask=" + tAspectDriver.F.getAppDriversObject().DeleteMask.toString());
        }
        if (arrayList != null) {
            arrayList.add("DriverID:\t" + tAspectDriver.AppDriverObj.DriverID.toString());
            arrayList.add("Struct:\t" + tAspectDriver.AppDriverObj.StructureIndex.toString());
            arrayList.add("Driver Params:\t" + string5);
        }
        object11 = null;
        if (tAspectDriver.AppDriverObj.DriverID.toString().equalsIgnoreCase("Investing_TD_Ameritrade_Option_Contract")) {
            object11 = new TProfiler("THtmlInclude");
        }
        if (!tAspectDriver.isValid()) {
            if (object11 != null) {
                ((TProfiler)object11).addMark("complete");
            }
            return;
        }
        if (arrayList != null) {
            arrayList.add("Filename:\t" + tAspectDriver.F.getFileName());
        }
        String string9 = tAspectDriver.F.getAppDriversObject().DriverID.toString();
        object10 = new TDriverDisplay(string9, this.sDocumentID, this.sWidget, this.sContainerItemID, this.sUserAgent, this.hashArguments, string4);
        stringArray = ((TDriverDisplay)object10).getSelectedFields();
        if (tAspectDriver.F instanceof TConsolidatedHorzDriver) {
            stringArray = ((TConsolidatedHorzDriver)tAspectDriver.F).expandFieldList(stringArray);
            if (arrayList != null) {
                object9 = "Horz Fields: ";
                for (int i = 0; i < stringArray.length; ++i) {
                    object9 = (String)object9 + stringArray[i] + " ";
                }
                arrayList.add((String)object9);
            }
        }
        if (((String[])(object9 = ((TDriverDisplay)object10).getPivotFields("both"))).length > 0) {
            if (arrayList != null) {
                String string10 = "";
                for (n4 = 0; n4 < ((String[])object9).length; ++n4) {
                    string10 = string10 + object9[n4];
                    if (n4 >= ((String[])object9).length - 1) continue;
                    string10 = string10 + ",";
                }
                arrayList.add("Pivot Fields: " + string10);
            }
            TPivotTableDriver tPivotTableDriver = new TPivotTableDriver(tAspectDriver.F, (String[])object9);
            tAspectDriver.setDriver(tPivotTableDriver);
        }
        if (tAspectDriver.F instanceof TPivotTableDriver && (stringArray == null || stringArray.length == 0)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n4 = 0; n4 < ((TPivotTableDriver)tAspectDriver.F).DriverStruct.FieldColl.size(); ++n4) {
                object8 = (TDriverStructRecord)((TPivotTableDriver)tAspectDriver.F).DriverStruct.FieldColl.get(n4);
                if (!((TDriverStructRecord)object8).IsPivotField) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(((TDriverStructRecord)object8).ID);
            }
            for (n4 = 0; n4 < ((TPivotTableDriver)tAspectDriver.F).DriverStruct.FieldColl.size(); ++n4) {
                object8 = (TDriverStructRecord)((TPivotTableDriver)tAspectDriver.F).DriverStruct.FieldColl.get(n4);
                if (!((TDriverStructRecord)object8).IsPivotNameField) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(((TDriverStructRecord)object8).ID);
            }
            for (n4 = 0; n4 < ((TPivotTableDriver)tAspectDriver.F).DriverStruct.FieldColl.size(); ++n4) {
                object8 = (TDriverStructRecord)((TPivotTableDriver)tAspectDriver.F).DriverStruct.FieldColl.get(n4);
                if (!((TDriverStructRecord)object8).IsPivotTotal) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(((TDriverStructRecord)object8).ID);
            }
            stringArray = charutil.getSubStringArray(stringBuilder, ',', true);
        }
        if (stringArray != null && stringArray.length > 0) {
            tAspectDriver.setDisplayColumns(stringArray);
        }
        String[] stringArray3 = ((TDriverDisplay)object10).getSortOptions();
        if (tAspectDriver.F instanceof TPivotTableDriver && (stringArray3 == null || stringArray3.length == 0) && this.hashArguments.containsKey("PARAMS")) {
            String string11 = charutil.removeQuotes((String)this.hashArguments.get("PARAMS"));
            object8 = charutil.getParamValue(string11, "pivot", '|');
            stringArray3 = charutil.getSubStringArray((String)object8, '^', true);
        }
        if (stringArray3 != null && stringArray3.length > 0) {
            tAspectDriver.setSortOptions(stringArray3, false);
            bl2 = true;
        }
        if (arrayList != null) {
            arrayList.add("Filter=" + ((TDriverDisplay)object10).getFilter());
            arrayList.add("BaseFilter=" + tAspectDriver.AppDriverObj.BaseFilter + " (defined in driver)");
        }
        String string12 = ((TDriverDisplay)object10).getFilter().trim();
        if (this.hashArguments.containsKey("BASEFILTER") && ((String)(object8 = charutil.removeQuotes((String)this.hashArguments.get("BASEFILTER")))).length() > 0) {
            object8 = charutil.replaceChar((String)object8, '\'', '\"');
            if (string12.length() > 0) {
                string12 = "(" + string12 + ")";
            }
            string12 = string12 + " and (" + (String)object8 + ")";
        }
        tAspectDriver.setActiveFilter(string12, false);
        bl2 = true;
        if (object11 != null) {
            ((TProfiler)object11).addMark("set subtotals");
        }
        int n6 = 0;
        for (n3 = 0; n3 < 6; ++n3) {
            string3 = "SUBTOTALFIELDS" + Integer.toString(n3);
            if (!((TDriverDisplay)object10).hashDisplayOptions.containsKey(string3)) continue;
            if (n6 == 0) {
                tAspectDriver.enableSubtotals();
                object7 = new TScrollSubtotalTreeNode(-1, "", -1, false, null, true);
                if (object7 != null) {
                    object6 = new TScrollSubtotalTree((TScrollSubtotalTreeNode)object7, null, tAspectDriver);
                    tAspectDriver.setScrollSubtotalTree((TScrollSubtotalTree)object6);
                }
                tAspectDriver.SubtotalsDriver.clearSubtotalTemplates();
            }
            if (((String)(object7 = charutil.removeQuotes((String)((TDriverDisplay)object10).hashDisplayOptions.get(string3)))).length() <= 0 || ((String)object7).toUpperCase().indexOf("__SUBTOTALARGS") >= 0) continue;
            if (arrayList != null) {
                arrayList.add(string3 + "=" + (String)object7);
            }
            if ((object6 = charutil.getSubStringArray((String)object7, ',', true)) == null) continue;
            n2 = 0;
            if (object6[0].equalsIgnoreCase("sum")) {
                n2 = 0;
            } else if (((String)object6[0]).equalsIgnoreCase("min")) {
                n2 = 2;
            } else if (((String)object6[0]).equalsIgnoreCase("max")) {
                n2 = 3;
            } else if (((String)object6[0]).equalsIgnoreCase("count")) {
                n2 = 1;
            } else if (((String)object6[0]).equalsIgnoreCase("average")) {
                n2 = 4;
            } else if (((String)object6[0]).equalsIgnoreCase("stddev")) {
                n2 = 5;
            }
            if (((Object)object6).length > 1) {
                object5 = new String[((Object)object6).length - 1];
                for (n = 1; n < ((Object)object6).length; ++n) {
                    object5[n - 1] = object6[n];
                }
                tAspectDriver.SubtotalsDriver.addSubtotalTemplate(n6, n2, (String[])object5);
            }
            ++n6;
        }
        if (object11 != null) {
            ((TProfiler)object11).addMark("init subtotal tree");
        }
        if (n6 > 0) {
            tAspectDriver.AspectDriverFilter.SubtotalTree.initializeTree();
            tAspectDriver.SubtotalsDriver.calculateSubtotals();
            for (n3 = 0; n3 < 6; ++n3) {
                string3 = "SUBTOTALFIELDS" + Integer.toString(n3);
                if (!((TDriverDisplay)object10).hashDisplayOptions.containsKey(string3) || (object6 = charutil.getSubStringArray((String)(object7 = charutil.removeQuotes((String)((TDriverDisplay)object10).hashDisplayOptions.get(string3))), ',', true)) == null) continue;
                n2 = 0;
                if (object6[0].equalsIgnoreCase("sum")) {
                    n2 = 0;
                } else if (((String)object6[0]).equalsIgnoreCase("min")) {
                    n2 = 2;
                } else if (((String)object6[0]).equalsIgnoreCase("max")) {
                    n2 = 3;
                } else if (((String)object6[0]).equalsIgnoreCase("count")) {
                    n2 = 1;
                } else if (((String)object6[0]).equalsIgnoreCase("average")) {
                    n2 = 4;
                } else if (((String)object6[0]).equalsIgnoreCase("stddev")) {
                    n2 = 5;
                }
                if (((Object)object6).length > 1) {
                    object5 = new String[((Object)object6).length - 1];
                    for (n = 1; n < ((Object)object6).length; ++n) {
                        object5[n - 1] = object6[n];
                    }
                    tAspectDriver.AspectDriverFilter.SubtotalTree.enableSubtotal(3, n2, (String[])object5);
                    continue;
                }
                tAspectDriver.AspectDriverFilter.SubtotalTree.enableSubtotal(2, n2, null);
            }
        }
        if (tAspectDriver.AspectDriverFilter.SubtotalTree != null) {
            tAspectDriver.AspectDriverFilter.SubtotalTree.enableDetails(!((TDriverDisplay)object10).subtotalsOnly());
        }
        if (object11 != null) {
            ((TProfiler)object11).addMark("applySortAndFilter");
        }
        if (bl2) {
            tAspectDriver.applySortAndFilter();
            if (arrayList != null) {
                arrayList.add("Record count: " + tAspectDriver.getRecordCount() + " (" + tAspectDriver.getAbsoluteRecordCount() + " absolute)");
            }
            if (object11 != null) {
                ((TProfiler)object11).addMark("applySortAndFilter");
            }
        }
        if (object11 != null) {
            ((TProfiler)object11).addMark("applySortAndFilter complete ");
        }
        String string13 = "";
        if (this.hashArguments.containsKey("NAME")) {
            string13 = charutil.removeQuotes((String)this.hashArguments.get("NAME"));
        }
        int n7 = -1;
        if (this.hashArguments.containsKey("MAXRECORDS")) {
            n7 = charutil.ival(charutil.removeQuotes((String)this.hashArguments.get("MAXRECORDS")));
        }
        if (string7.equalsIgnoreCase("Greenlight_Dimensional_System_Driver")) {
            System.out.println(dateutil.formatDate(new Date(), "HH:mm:ss") + " THtmlInclude processDriver A:  " + string7);
        }
        if (n7 == 0) {
            this.MainWin.appendToLog("THtmlInclude", "processDriver", Thread.currentThread(), null, 4, "Invalid MaxRecords value for driver " + string7 + " value=" + charutil.removeQuotes((String)this.hashArguments.get("MAXRECORDS")));
            n7 = 25;
        }
        int n8 = 0;
        if (this.hashArguments.containsKey("STARTRECORD")) {
            object6 = charutil.removeQuotes((String)this.hashArguments.get("STARTRECORD"));
            if (((String)object6).equalsIgnoreCase("last")) {
                n8 = new Double(Math.floor((tAspectDriver.getRecordCount() - 1) / n7) * (double)n7).intValue();
            } else {
                n8 = charutil.ival((String)object6);
                if (n8 >= tAspectDriver.getRecordCount()) {
                    n8 = new Double(Math.floor((tAspectDriver.getRecordCount() - 1) / n7) * (double)n7).intValue();
                }
            }
        }
        if (n8 < 0) {
            n8 = 0;
        }
        boolean bl5 = false;
        String string14 = "";
        object5 = "";
        if (this.hashArguments.containsKey("PAGING") && !this.hashArguments.containsKey("VER")) {
            bl5 = charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("PAGING")));
            if (this.hashArguments.containsKey("PAGEARGS")) {
                object5 = charutil.removeQuotes((String)this.hashArguments.get("PAGEARGS"));
                if (charutil.getParamValue((String)object5, string13 + "nextpage", '&').equalsIgnoreCase("true")) {
                    n8 += n7;
                    n8 = Math.min(n8, new Double(Math.floor(tAspectDriver.getRecordCount() / n7) * (double)n7).intValue());
                } else if (charutil.getParamValue((String)object5, string13 + "prevpage", '&').equalsIgnoreCase("true")) {
                    n8 = Math.max(0, n8 - n7);
                } else if (charutil.getParamValue((String)object5, string13 + "firstpage", '&').equalsIgnoreCase("true")) {
                    n8 = 0;
                } else if (charutil.getParamValue((String)object5, string13 + "lastpage", '&').equalsIgnoreCase("true")) {
                    n8 = new Double(Math.floor(tAspectDriver.getRecordCount() / n7) * (double)n7).intValue();
                }
            } else {
                if (bl5) {
                    System.out.println("Missing 'pageargs' in driver include tag for driver: " + string7);
                }
                bl5 = false;
            }
            if (this.hashArguments.containsKey("URL")) {
                string14 = charutil.removeQuotes((String)this.hashArguments.get("URL"));
                string14 = string14.toUpperCase().indexOf("JAVASCRIPT") >= 0 ? string14.substring(0, string14.length() - 2) + "&" + string13 + "startRecord=" + n8 + string14.substring(string14.length() - 2) : string14 + "&" + string13 + "startRecord=" + n8;
                string14 = charutil.replaceAllSubstrings(string14, "%paging%", "|" + string13 + "startRecord=" + n8);
            } else {
                if (bl5) {
                    System.out.println("Missing 'url' in driver include tag for driver: " + string7);
                }
                bl5 = false;
            }
        }
        if (this.hashArguments.containsKey("CELLFORMATTING")) {
            bl = charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("CELLFORMATTING")));
        }
        String string15 = string7;
        if (this.hashArguments.containsKey("CLASS")) {
            string15 = charutil.removeQuotes((String)this.hashArguments.get("CLASS"));
        }
        String string16 = string7 + TPasswordService.generateSalt(6);
        if (this.hashArguments.containsKey("ID")) {
            string16 = charutil.removeQuotes((String)this.hashArguments.get("ID"));
        }
        if (this.hashArguments.containsKey("ID") && (string16 = charutil.removeQuotes((String)this.hashArguments.get("ID"))).trim().length() == 0) {
            string16 = "i" + TPasswordService.generateSalt(8);
        }
        String string17 = "";
        if (this.hashArguments.containsKey("TABLESTYLE")) {
            string17 = charutil.removeQuotes((String)this.hashArguments.get("TABLESTYLE"));
        }
        boolean bl6 = false;
        if (this.hashArguments.containsKey("TABLEBORDER")) {
            bl6 = charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("TABLEBORDER")));
        }
        boolean bl7 = true;
        if (this.hashArguments.containsKey("TABLEHEADER")) {
            bl7 = charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("TABLEHEADER")));
        }
        String string18 = ((TDriverDisplay)object10).getChartType();
        boolean bl8 = false;
        if (arrayList != null) {
            arrayList.add("sChartType=" + string18);
            if (string18 != "0" && !string18.equalsIgnoreCase("none")) {
                int n9;
                if (stringArray3 == null) {
                    arrayList.add("Sort=null");
                } else {
                    object4 = "Sort=";
                    for (n9 = 0; n9 < stringArray3.length; ++n9) {
                        object4 = (String)object4 + stringArray3[n9] + ",";
                    }
                    arrayList.add((String)object4);
                }
                if (stringArray == null) {
                    arrayList.add("Fields=null");
                } else {
                    object4 = "Fields=";
                    for (n9 = 0; n9 < stringArray.length; ++n9) {
                        object4 = (String)object4 + stringArray[n9] + ",";
                    }
                    arrayList.add((String)object4);
                }
            }
        }
        if (object11 != null) {
            ((TProfiler)object11).addMark("create chart");
        }
        if (string18.equalsIgnoreCase("line") || string18.equalsIgnoreCase("bar") || string18.equalsIgnoreCase("column") || string18.equalsIgnoreCase("line2") || string18.equalsIgnoreCase("scatter") || string18.equalsIgnoreCase("pie") || string18.equalsIgnoreCase("AspectLine") || string18.equalsIgnoreCase("AspectLineIndex") || string18.equalsIgnoreCase("AspectLine2") || string18.equalsIgnoreCase("AspectColumn") || string18.equalsIgnoreCase("AspectColumn2") || string18.equalsIgnoreCase("AspectScatter") || string18.equalsIgnoreCase("AspectScatter2")) {
            bl8 = true;
        }
        if (!bl4 && bl8 && stringArray3 != null && stringArray3.length > 0 && stringArray != null && stringArray.length > 0) {
            if (arrayList != null) {
                arrayList.add("Preparing chart");
            }
            object4 = "";
            String string19 = "";
            object3 = "";
            object2 = "";
            charSequence = "";
            string2 = stringArray3[0];
            if (string2.startsWith("-")) {
                string2 = string2.substring(1);
            }
            string = "COMPARISON";
            if (this.hashArguments.containsKey("CHARTSERIES") && (string = charutil.removeQuotes((String)this.hashArguments.get("CHARTSERIES")).toUpperCase()).trim().length() == 0) {
                string = "COMPARISON";
            }
            for (int i = 0; i < stringArray.length; ++i) {
                object = tAspectDriver.DriverStruct.getField(stringArray[i]);
                if (object == null) continue;
                if (!((TDriverStructRecord)object).FullID.equalsIgnoreCase(string2) || !string18.equalsIgnoreCase("scatter")) {
                    if (!objectutil.isNumberField(((TDriverStructRecord)object).FieldType)) continue;
                    boolean bl9 = true;
                    if (tAspectDriver.F instanceof TConsolidatedHorzDriver) {
                        if (((TDriverStructRecord)object).FullID.toUpperCase().indexOf("CONSOLIDATEDHORZDRIVERTOTAL") >= 0 && string.equals("COMPARISON")) {
                            bl9 = false;
                        }
                        if (((TDriverStructRecord)object).FullID.toUpperCase().indexOf("CONSOLIDATEDHORZDRIVERFIELD") >= 0 && string.equals("TOTALS")) {
                            bl9 = false;
                        }
                        if (((TDriverStructRecord)object).FullID.toUpperCase().indexOf("CONSOLIDATEDHORZDRIVER") < 0) {
                            bl9 = false;
                        }
                    }
                    if (!bl9) continue;
                    string19 = ((String)object2).length() == 0 ? ((TDriverStructRecord)object).Description : "";
                    object3 = (String)object3 + string2 + "|";
                    object2 = (String)object2 + stringArray[i] + "|";
                    charSequence = (String)charSequence + "true|";
                    continue;
                }
                object4 = ((TDriverStructRecord)object).Description;
            }
            if (((String)object2).length() > 0) {
                String string20 = "";
                object = "Down_45";
                String string21 = "false";
                int n10 = 640;
                int n11 = 480;
                boolean bl10 = true;
                if (this.hashArguments.containsKey("CHARTTITLE")) {
                    string20 = charutil.removeQuotes((String)this.hashArguments.get("CHARTTITLE"));
                }
                if (this.hashArguments.containsKey("CHARTWIDTH")) {
                    n10 = charutil.ival(charutil.removeQuotes((String)this.hashArguments.get("CHARTWIDTH")));
                }
                if (this.hashArguments.containsKey("CHARTHEIGHT")) {
                    n11 = charutil.ival(charutil.removeQuotes((String)this.hashArguments.get("CHARTHEIGHT")));
                }
                if (this.hashArguments.containsKey("CHARTLABELS")) {
                    object = charutil.removeQuotes((String)this.hashArguments.get("CHARTLABELS"));
                }
                if (this.hashArguments.containsKey("CHARTVISIBLE")) {
                    string21 = charutil.removeQuotes((String)this.hashArguments.get("CHARTVISIBLE"));
                }
                if (this.hashArguments.containsKey("CHARTCANCLOSE")) {
                    bl10 = charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("CHARTCANCLOSE")));
                }
                if (((String)object).equals("45")) {
                    object = "Down_45";
                }
                if (((String)object).equals("90")) {
                    object = "Down_90";
                }
                if (((String)object).equals("+45")) {
                    object = "Up_45";
                }
                if (((String)object).equals("+90")) {
                    object = "Up_90";
                }
                System.out.println("sChartVisible=" + string21);
                object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                charSequence = ((String)charSequence).substring(0, ((String)charSequence).length() - 1);
                String string22 = TMainWin.Application.getHomeDir() + "temporary_files/" + TPasswordService.generateSalt(8) + ".png";
                String string23 = "ChartType=" + string18 + "&ChartTitle=" + string20 + "&Width=" + n10 + "&height=" + n11 + "&ChartVisible=" + string21 + "&filename=" + string22;
                string23 = string23 + "&DomainAxisLabel=" + (String)object4 + "&ValueAxisLabel=" + string19;
                string23 = ((String)object).equalsIgnoreCase("none") ? string23 + "&DomainAxisDataLabelsVisible=false" : string23 + "&DomainAxisDataLabelOrientation=" + (String)object;
                string23 = string23 + "&Gradient1=0000FF|00003F&Gradient2=00FF00|003F00&Gradient3=FF0000|3F0000";
                string23 = string23 + "&ChartBackground=FFFFFF&PlotBackground=FFFFFF";
                if (arrayList != null) {
                    arrayList.add("Chart DataLabels=" + (String)object3);
                    arrayList.add("Chart Values=" + (String)object2);
                    arrayList.add("Chart Filter=" + (String)charSequence);
                    arrayList.add("Chart Params=" + string23);
                }
                THtmlTag tHtmlTag = new THtmlTag("div");
                tHtmlTag.setProperty("ID", "googlechartdata" + string16.toLowerCase());
                tHtmlTag.setProperty("class", "googlechartdata");
                tHtmlTag.setProperty("style", "display:none");
                if (((String)object3).equals("0")) {
                    tHtmlTag.addContent("Error: No sort option selected");
                    this.strProcessedHtml.append(tHtmlTag.toString());
                } else {
                    THtmlTag tHtmlTag2;
                    TGoogleChart tGoogleChart = new TGoogleChart(tAspectDriver, (String)object3, (String)object2, (String)charSequence, string23);
                    String string24 = tGoogleChart.getData();
                    tHtmlTag.addContent(string24);
                    THtmlTag tHtmlTag3 = new THtmlTag("div");
                    tHtmlTag3.setProperty("ID", "googlechartoutputwrapper" + string16.toLowerCase());
                    tHtmlTag3.setProperty("class", "googlechartoutputwrapper");
                    tHtmlTag3.setProperty("style", "display:none");
                    tHtmlTag3.setProperty("showchart", string21);
                    if (bl10) {
                        tHtmlTag2 = new THtmlTag("div");
                        tHtmlTag2.setProperty("class", "table_chart_close");
                        tHtmlTag2.setProperty("onClick", "setVisible('googlechartoutputwrapper" + string16.toLowerCase() + "',false);setVisible('" + string16.toLowerCase() + "Chart',false)");
                        tHtmlTag3.append(tHtmlTag2);
                    }
                    tHtmlTag2 = new THtmlTag("div");
                    tHtmlTag2.setProperty("ID", "googlechartoutput" + string16.toLowerCase());
                    tHtmlTag2.setProperty("class", "googlechartoutput");
                    tHtmlTag2.setProperty("width", n10);
                    tHtmlTag2.setProperty("height", n11);
                    tHtmlTag3.append(tHtmlTag2);
                    this.strProcessedHtml.append(tHtmlTag.toString());
                    this.strProcessedHtml.append(tHtmlTag3.toString());
                }
            }
        }
        if (object11 != null) {
            ((TProfiler)object11).addMark("create chart complete");
        }
        object4 = dosutil.createTempFile("$$$");
        String string25 = "";
        if (object11 != null) {
            ((TProfiler)object11).addMark("prior to export");
        }
        if (bl4) {
            tAspectDriver.exportHtmlToCsv(((File)object4).getPath(), bl, string15, string17, bl7, bl6, string13, n8, n7, string16, this.hashArguments, this.sDocumentID, this.sWidget, this.sContainerItemID, (TDriverDisplay)object10);
        } else {
            if (object11 != null) {
                ((TProfiler)object11).addMark("exportToHtml");
            }
            string25 = tAspectDriver.exportToHtml(((File)object4).getPath(), bl, string15, string17, bl7, bl6, string13, n8, n7, string16, this.hashArguments, this.sDocumentID, this.sWidget, this.sContainerItemID, (TDriverDisplay)object10, this.PageArgs);
            if (object11 != null) {
                ((TProfiler)object11).addMark("exportToHtml complete");
            }
            if (string13.length() == 0) {
                string13 = string7;
            }
            this.strProcessedHtml.append("<constant name:__" + string13 + "_RecordCount__; value:" + tAspectDriver.getRecordCount() + ">\r\n");
            if (n7 > 0) {
                this.strProcessedHtml.append("<constant name:__" + string13 + "_LastPrev__; Value:" + Math.max(0, new Double(Math.floor(tAspectDriver.getRecordCount() / n7) * (double)n7 - (double)n7).intValue()) + ";>\r\n");
            }
            if (n7 > 0) {
                this.strProcessedHtml.append("<constant name:__" + string13 + "_PageCount__; Value:" + (tAspectDriver.getRecordCount() / n7 + 1) + ";>\r\n");
            }
            if (n7 > 0) {
                this.strProcessedHtml.append("<constant name:__" + string13 + "_Page__; Value:" + (n8 / n7 + 1) + ";>\r\n");
            }
            if (n7 > 0) {
                this.strProcessedHtml.append("<constant name:__" + string13 + "_CalcStartRecord__; Value:" + n8 + ";>\r\n");
            }
            if (bl5) {
                object3 = TMainWin.Application.getTokenValue("packageurl_aspect_software_net_core") + "common/doc/template_for_driver_paging.html";
                object2 = new TAsciiInput((String)object3, '\u0000');
                charSequence = new StringBuilder(new String(((TAsciiInput)object2).get_entire_file()));
                charutil.replaceAllSubstrings((StringBuilder)charSequence, (StringBuilder)charSequence, "%drivername%", string13);
                charutil.replaceAllSubstrings((StringBuilder)charSequence, (StringBuilder)charSequence, "%url%", string14);
                charutil.replaceAllSubstrings((StringBuilder)charSequence, (StringBuilder)charSequence, "%maxrecords%", Integer.toString(n7));
                charutil.replaceAllSubstrings((StringBuilder)charSequence, (StringBuilder)charSequence, "%startrecord%", Integer.toString(n8));
                string2 = string14;
                string = string14;
                String string26 = string14;
                object = string14;
                if (string14.toUpperCase().indexOf("JAVASCRIPT") >= 0) {
                    string2 = string2.substring(0, string2.length() - 2) + "&" + string13 + "FirstPage=true" + string2.substring(string2.length() - 2);
                    string = string.substring(0, string.length() - 2) + "&" + string13 + "LastPage=true" + string.substring(string.length() - 2);
                    string26 = string26.substring(0, string26.length() - 2) + "&" + string13 + "PrevPage=true" + string26.substring(string26.length() - 2);
                    object = ((String)object).substring(0, ((String)object).length() - 2) + "&" + string13 + "NextPage=true" + ((String)object).substring(((String)object).length() - 2);
                } else {
                    string2 = string2 + "&" + string13 + "FirstPage=true";
                    string = string + "&" + string13 + "LastPage=true";
                    string26 = string26 + "&" + string13 + "PrevPage=true";
                    object = (String)object + "&" + string13 + "NextPage=true";
                }
                charutil.replaceAllSubstrings((StringBuilder)charSequence, (StringBuilder)charSequence, "%firstpage%", string2);
                charutil.replaceAllSubstrings((StringBuilder)charSequence, (StringBuilder)charSequence, "%lastpage%", string);
                charutil.replaceAllSubstrings((StringBuilder)charSequence, (StringBuilder)charSequence, "%prevpage%", string26);
                charutil.replaceAllSubstrings((StringBuilder)charSequence, (StringBuilder)charSequence, "%nextpage%", (String)object);
                this.strProcessedHtml.append(charSequence);
                ((TAsciiInput)object2).dispose();
            }
        }
        if (this.hashArguments.containsKey("JAVASCRIPT") && ((String)(object3 = charutil.removeQuotes((String)this.hashArguments.get("JAVASCRIPT")).trim())).length() > 0 && !((String)object3).trim().toUpperCase().startsWith("DOCUMENTID")) {
            object2 = charutil.getSubStringArray((String)object3, '|', true);
            if (object2 != null && ((String[])object2).length >= 3) {
                charSequence = ((String[])object2).length > 3 ? object2[3] : "";
                string2 = "DocumentID=" + (String)object2[0] + "&Widget=" + (String)object2[1] + "&ContainerItemID=" + (String)object2[2] + "&" + (String)charSequence;
                string = TFormulaEvaluator.getCache().getCachedContent(0, (String)charSequence2, string2, false, "", "");
                String string27 = "__RequestServer__/?Network=Greenlight&ID=getWidget&" + string2 + "&Source=" + (String)charSequence2;
                object = "<div style=\"display:none\" ID=\"_js" + string16.toLowerCase() + "\" _url=\"" + string27 + "\">\r\n";
                object = (String)object + string + "\r\n" + "</div>";
                this.strProcessedHtml.append((String)object);
            } else {
                this.MainWin.appendToLog("THtmlInclude", "processTypeExpression", Thread.currentThread(), null, 3, "Invalid javascript argument in driver include: " + (String)object3);
            }
        }
        System.out.println("THtmlInclude calling writeFieldProfile");
        tAspectDriver.F.writeFieldProfile();
        if (bl3) {
            if (this.hashArguments.containsKey("DISPOSE") && charutil.removeQuotes((String)this.hashArguments.get("DISPOSE")).equalsIgnoreCase("true")) {
                TFormulaEvaluator.removeSystemDriver(string7);
                tAspectDriver.dispose();
            }
        } else {
            tAspectDriver.dispose();
        }
        if (bl4) {
            object3 = new TAsciiInput(((File)object4).getPath(), '\u0000');
            object2 = ((TAsciiInput)object3).get_entire_file();
            ((TAsciiInput)object3).dispose();
            this.strProcessedHtml.append(new String((byte[])object2));
        } else {
            this.strProcessedHtml.append(string25);
        }
        if (arrayList != null) {
            arrayList.add("Elapsed time: " + (new Date().getTime() - date.getTime()));
            if (TMainWin.Application.getTokenValue("ExecMode").equalsIgnoreCase("Development")) {
                object3 = TMainWin.Application.getTemporaryFiles() + string7 + ".html";
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.MainWin.appendToLog("THtmlInclude", "processTypeExpression", Thread.currentThread(), null, 3, "DriverInclude: " + (String)arrayList.get(i));
            }
        }
        charutil.replaceAllSubstrings(this.strProcessedHtml, this.strProcessedHtml, "%calcstartrecord%", string13 + "StartRecord=" + n8);
        if (!bl4) {
            ((File)object4).delete();
        }
        if (!bl3) {
            this.executeDriverPostActions(tAppDriversObject);
        }
        if (object11 != null) {
            ((TProfiler)object11).addMark("complete");
        }
        if (string7.equalsIgnoreCase("Greenlight_Dimensional_System_Driver")) {
            System.out.println(dateutil.formatDate(new Date(), "HH:mm:ss") + " THtmlInclude processDriver complete for " + string7);
        }
    }

    private void processWidget() {
        String string;
        String string2 = "";
        String string3 = "";
        String string4 = "Network=Library&ID=getWidget";
        String string5 = "false";
        String string6 = "";
        String string7 = TNotification.encryptPassword();
        String string8 = TMainWin.Application.getTokenValue("ExternalIPAddress");
        if (!this.hashArguments.containsKey("SERVER")) {
            this.MainWin.appendToLog("THtmlInclude", "processTypeExpression", Thread.currentThread(), null, 3, "No server specified for widget in include tag: " + this.strOriginalTag + " Use 'server:address'");
            return;
        }
        string2 = charutil.removeQuotes((String)this.hashArguments.get("SERVER"));
        string4 = string4 + "&libraryserver=" + string2;
        if (this.hashArguments.containsKey("LIBRARY")) {
            string6 = charutil.removeQuotes((String)this.hashArguments.get("LIBRARY"));
            string4 = string4 + "&library=" + string6;
        }
        if (this.hashArguments.containsKey("NAME")) {
            string3 = charutil.removeQuotes((String)this.hashArguments.get("NAME"));
            string4 = string4 + "&Name=" + string3;
        }
        if (this.hashArguments.containsKey("DOCUMENTID")) {
            string4 = string4 + "&DocumentID=" + charutil.removeQuotes((String)this.hashArguments.get("DOCUMENTID"));
        }
        if (this.hashArguments.containsKey("WIDGET")) {
            string4 = string4 + "&Widget=" + charutil.removeQuotes((String)this.hashArguments.get("WIDGET"));
        }
        if (this.hashArguments.containsKey("PARAMS")) {
            string4 = string4 + "&Params=" + charutil.removeQuotes((String)this.hashArguments.get("PARAMS"));
        }
        if (this.hashArguments.containsKey("CONTAINERITEMID")) {
            string4 = string4 + "&ContainerItemID=" + charutil.removeQuotes((String)this.hashArguments.get("CONTAINERITEMID"));
        }
        if (this.hashArguments.containsKey("SECURE")) {
            string5 = charutil.removeQuotes((String)this.hashArguments.get("SECURE"));
            string4 = string4 + "&Secure=" + string5;
        }
        if (this.hashArguments.containsKey("DEBUG")) {
            string4 = string4 + "&Debug=" + charutil.removeQuotes((String)this.hashArguments.get("DEBUG"));
        }
        if (this.hashArguments.containsKey("P")) {
            string7 = charutil.removeQuotes((String)this.hashArguments.get("P"));
        }
        boolean bl = false;
        if (this.hashArguments.containsKey("TEXT")) {
            string = charutil.removeQuotes((String)this.hashArguments.get("TEXT"));
            string4 = string4 + "&Text=" + string;
            if (charutil.boolval(string)) {
                bl = true;
            }
        }
        if (this.IsEmail) {
            string4 = string4 + "&PrepareEmail=true";
        }
        string = null;
        if (string2.equalsIgnoreCase("cache")) {
            TExecScript tExecScript = new TExecScript("Aspect_Common_getCachedWidget", null, new TFormulaEvaluator());
            String[] stringArray = new String[]{string4};
            tExecScript.setParameters(stringArray);
            tExecScript.executeScript();
            if (tExecScript.getScriptResult() != null) {
                string = (String)tExecScript.getScriptResult();
            }
        } else if (string2.indexOf(":") > 0) {
            String[] stringArray = new String[6];
            String string9 = "-1";
            String[] stringArray2 = charutil.getSubStringArray(string2, ':', true);
            if (stringArray2 != null) {
                string2 = stringArray2[0];
                if (stringArray2.length > 0) {
                    string9 = stringArray2[1];
                }
            }
            stringArray[0] = string2;
            stringArray[1] = "/";
            stringArray[2] = string4;
            stringArray[3] = string9;
            stringArray[4] = "60000";
            stringArray[5] = string5;
            String string10 = "httpGet(\"" + stringArray[0] + "\",\"" + stringArray[1] + "\",\"" + stringArray[2] + "\"," + stringArray[3] + "," + stringArray[4] + ",true," + stringArray[5] + ")";
            string = (String)new TFormulaEvaluator().getFormulaValue(string10, -1, -1);
        } else {
            string = TFormulaEvaluator.getCache().getCachedContent(0, string2, string4, true, string8, this.sUserAgent);
        }
        if (string == null) {
            this.strProcessedHtml.append("Could not retrieve widget");
        } else if (!bl && string.toUpperCase().indexOf("__WIDGETID__") >= 0) {
            string = "<div ID='__WidgetID__'>" + string + "</div>";
            this.strProcessedHtml.append(charutil.replaceAllSubstrings(string, "__WidgetID__", "w" + TPasswordService.generateSalt(24)));
        } else {
            this.strProcessedHtml.append(string);
        }
    }

    private void processExternalDriverFilter() {
        String string;
        String[] stringArray = new String[]{"INPUTTYPE", "ID", "CONDITION", "EXPRESSION"};
        Enumeration enumeration = this.hashArguments.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.hashArguments.containsKey(stringArray[i])) continue;
            String string3 = "Error: Missing value in include tag: " + stringArray[i];
            System.out.println(string3);
            this.strProcessedHtml.append(string3);
            return;
        }
        String string4 = charutil.removeQuotes((String)this.hashArguments.get("INPUTTYPE"));
        String string5 = charutil.removeQuotes((String)this.hashArguments.get("ID"));
        String string6 = charutil.removeQuotes((String)this.hashArguments.get("CONDITION"));
        String string7 = charutil.removeQuotes((String)this.hashArguments.get("EXPRESSION"));
        String string8 = string = this.hashArguments.containsKey("HTMLPARAMS") ? charutil.removeQuotes((String)this.hashArguments.get("HTMLPARAMS")) : "";
        if (string4.equalsIgnoreCase("SELECT")) {
            if (!this.hashArguments.containsKey("COLLECTIONID")) {
                String string9 = "Error: Missing value in include tag: COLLECTIONID";
                System.out.println(string9);
                this.strProcessedHtml.append(string9);
                return;
            }
            String string10 = charutil.removeQuotes((String)this.hashArguments.get("COLLECTIONID"));
            String string11 = this.hashArguments.containsKey("SELECTED") ? charutil.removeQuotes((String)this.hashArguments.get("SELECTED")) : "";
            String string12 = this.hashArguments.containsKey("DRIVERPARAMS") ? charutil.removeQuotes((String)this.hashArguments.get("DRIVERPARAMS")) : "";
            String string13 = this.hashArguments.containsKey("FILTER") ? charutil.removeQuotes((String)this.hashArguments.get("FILTER")) : "";
            String string14 = this.hashArguments.containsKey("SYSTEMDRIVERNAME") ? charutil.removeQuotes((String)this.hashArguments.get("SYSTEMDRIVERNAME")) : "";
            boolean bl = this.hashArguments.containsKey("DATALIST") ? charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("DATALIST"))) : false;
            TComboBoxColl tComboBoxColl = TMainWin.Application.AppCollections.getCollection(string10, new StringBuilder(string13), new TFormulaEvaluator(), false, string12, string14);
            if (bl) {
                if (string5.trim().length() == 0) {
                    string5 = TPasswordService.generateSalt(6);
                }
                this.strProcessedHtml.append("<input type=\"text\"");
                this.strProcessedHtml.append(" ID=\"" + string5 + "_input\"");
                this.strProcessedHtml.append(" List=\"" + string5 + "\"");
                this.strProcessedHtml.append("onkeydown=\"return keyDown(event,this);\"");
                this.strProcessedHtml.append(" " + string);
                if (string.toUpperCase().indexOf("ONCHANGE") < 0) {
                    this.strProcessedHtml.append(" onChange=\"dataListInputChanged(this)\"");
                } else if (string.toUpperCase().indexOf("DATALISTINPUTCHANGED") < 0) {
                    this.MainWin.appendToLog("THtmlInclude", "processExternalDriverFilter", Thread.currentThread(), null, 3, "Error: : dataListInputChanged(this) required in onChange override for datalist");
                }
                this.strProcessedHtml.append("></input>");
                this.strProcessedHtml.append("<input type=\"hidden\" List=\"" + string5 + "\" ID=\"" + string5 + "_input_submit" + "\" style='display:none'></input>");
                this.strProcessedHtml.append("<datalist ");
                this.strProcessedHtml.append(" ID=\"" + string5 + "\"");
                this.strProcessedHtml.append(" Condition=\"" + string6 + "\"");
                this.strProcessedHtml.append(" Expression=\"" + string7 + "\"");
                this.strProcessedHtml.append(" CollectionID=\"" + string10 + "\"");
                TAppCollectionsObject tAppCollectionsObject = TMainWin.Application.AppCollections.getAppCollectionsObject(string10);
                if (tAppCollectionsObject != null) {
                    this.strProcessedHtml.append(" DriverID=\"" + tAppCollectionsObject.DriverID.toString() + "\"");
                }
                this.strProcessedHtml.append(" Source=\"" + TMainWin.Application.getAspectHashID() + "\"");
                this.strProcessedHtml.append(" Filter=\"" + charutil.replaceChar(string13, '\"', '\'') + "\"");
                this.strProcessedHtml.append(" Params=\"" + string12 + "\"");
                this.strProcessedHtml.append(" SysDriverName=\"" + string14 + "\"");
                this.strProcessedHtml.append(">");
                this.strProcessedHtml.append(tComboBoxColl.toHtmlDataList(string11));
                this.strProcessedHtml.append("</datalist>");
            } else {
                this.strProcessedHtml.append("<select ");
                this.strProcessedHtml.append(string);
                this.strProcessedHtml.append(" ID=\"" + string5 + "\"");
                this.strProcessedHtml.append(" Condition=\"" + string6 + "\"");
                this.strProcessedHtml.append(" Expression=\"" + string7 + "\"");
                this.strProcessedHtml.append(" CollectionID=\"" + string10 + "\"");
                TAppCollectionsObject tAppCollectionsObject = TMainWin.Application.AppCollections.getAppCollectionsObject(string10);
                if (tAppCollectionsObject != null) {
                    this.strProcessedHtml.append(" DriverID=\"" + tAppCollectionsObject.DriverID.toString() + "\"");
                }
                this.strProcessedHtml.append(" Source=\"" + TMainWin.Application.getAspectHashID() + "\"");
                this.strProcessedHtml.append(" Filter=\"" + string13 + "\"");
                this.strProcessedHtml.append(" Params=\"" + string12 + "\"");
                this.strProcessedHtml.append(" SysDriverName=\"" + string14 + "\"");
                this.strProcessedHtml.append(">");
                this.strProcessedHtml.append(tComboBoxColl.toHtmlSelect(string11));
                this.strProcessedHtml.append("</select>");
            }
        } else {
            Object object;
            String string15;
            String string16 = string15 = this.hashArguments.containsKey("SELECTED") ? charutil.removeQuotes((String)this.hashArguments.get("SELECTED")) : "";
            if (string4.equalsIgnoreCase("TEXT")) {
                this.strProcessedHtml.append("<input type=\"text\" ");
                if (string15.trim().length() > 0) {
                    this.strProcessedHtml.append("value=\"" + string15 + "\" ");
                }
            } else if (string4.equalsIgnoreCase("NUMBER")) {
                this.strProcessedHtml.append("<input type=\"number\" ");
                if (string15.trim().length() > 0) {
                    this.strProcessedHtml.append("value=\"" + string15 + "\" ");
                }
            } else if (string4.equalsIgnoreCase("CHECKBOX")) {
                this.strProcessedHtml.append("<input type=\"checkbox\" ");
                if (charutil.boolval(string15)) {
                    this.strProcessedHtml.append("Checked=\"checked\" ");
                }
            } else if (string4.equalsIgnoreCase("DATE")) {
                this.strProcessedHtml.append("<input type=\"date\" class='date' pattern=\"yyyy-MM-dd\" datatype=\"time\" name=\"" + TPasswordService.generateSalt(4) + "\" ");
                if (string15.trim().length() > 0) {
                    object = dateutil.parseDate(string15);
                    this.strProcessedHtml.append("value=\"" + dateutil.formatDate((Date)object, "yyyy-MM-dd") + "\" ");
                }
            } else if (string4.equalsIgnoreCase("TIME")) {
                if (string.length() == 0) {
                    string = "style=\"width:100px\"";
                }
                this.strProcessedHtml.append("<input type=\"text\" pattern=\"HH:mm\" datatype=\"time\" control=\"time\" ");
                if (string15.trim().length() > 0) {
                    this.strProcessedHtml.append("value=\"" + string15 + "\" ");
                }
            } else if (string4.equalsIgnoreCase("DATETIME")) {
                this.strProcessedHtml.append("<input type=\"datetime-local\" pattern=\"yyyy-MM-ddTHH:mm\" name=\"" + TPasswordService.generateSalt(4) + "\" ");
                if (string15.trim().length() > 0) {
                    object = dateutil.parseDateTime(string15);
                    System.out.println("sSelected=" + string15 + " t=" + object);
                    this.strProcessedHtml.append("value=\"" + charutil.replaceChar(dateutil.formatDate((Date)object, "yyyy-MM-dd HH:mm"), ' ', 'T') + "\" ");
                }
            } else if (string4.equalsIgnoreCase("HIDDEN")) {
                this.strProcessedHtml.append("<input type=\"hidden\" ");
                if (string15.trim().length() > 0) {
                    this.strProcessedHtml.append("value=\"" + string15 + "\" ");
                }
            } else {
                this.strProcessedHtml.append("Error: Unrecognized input type: " + string4);
                return;
            }
            this.strProcessedHtml.append(string);
            this.strProcessedHtml.append(" ID=\"" + string5 + "\"");
            this.strProcessedHtml.append(" Condition=\"" + string6 + "\"");
            this.strProcessedHtml.append(" Expression=\"" + string7 + "\"");
            this.strProcessedHtml.append(">");
            if (this.hashArguments.containsKey("PARAM")) {
                object = charutil.removeQuotes((String)this.hashArguments.get("PARAM"));
                this.strProcessedHtml.append(" Param=\"" + (String)object + "\"");
            }
        }
    }

    private void processExternalDriverParam() {
        String string;
        String[] stringArray = new String[]{"INPUTTYPE", "ID", "PARAM"};
        Enumeration enumeration = this.hashArguments.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.hashArguments.containsKey(stringArray[i])) continue;
            String string3 = "Error: Missing value in include tag: " + stringArray[i];
            System.out.println(string3);
            this.strProcessedHtml.append(string3);
            return;
        }
        String string4 = charutil.removeQuotes((String)this.hashArguments.get("INPUTTYPE"));
        String string5 = charutil.removeQuotes((String)this.hashArguments.get("ID"));
        String string6 = charutil.removeQuotes((String)this.hashArguments.get("PARAM"));
        String string7 = this.hashArguments.containsKey("HTMLPARAMS") ? charutil.removeQuotes((String)this.hashArguments.get("HTMLPARAMS")) : "";
        String string8 = string = this.hashArguments.containsKey("SELECTED") ? charutil.removeQuotes((String)this.hashArguments.get("SELECTED")) : "";
        if (string4.equalsIgnoreCase("SELECT")) {
            if (!this.hashArguments.containsKey("COLLECTIONID")) {
                String string9 = "Error: Missing value in include tag: COLLECTIONID";
                System.out.println(string9);
                this.strProcessedHtml.append(string9);
                return;
            }
            String string10 = charutil.removeQuotes((String)this.hashArguments.get("COLLECTIONID"));
            String string11 = this.hashArguments.containsKey("DRIVERPARAMS") ? charutil.removeQuotes((String)this.hashArguments.get("DRIVERPARAMS")) : "";
            String string12 = this.hashArguments.containsKey("FILTER") ? charutil.removeQuotes((String)this.hashArguments.get("FILTER")) : "";
            String string13 = this.hashArguments.containsKey("SYSTEMDRIVERNAME") ? charutil.removeQuotes((String)this.hashArguments.get("SYSTEMDRIVERNAME")) : "";
            boolean bl = this.hashArguments.containsKey("DATALIST") ? charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("DATALIST"))) : false;
            TComboBoxColl tComboBoxColl = TMainWin.Application.AppCollections.getCollection(string10, new StringBuilder(string12), new TFormulaEvaluator(), false, string11, string13);
            if (bl) {
                if (string5.trim().length() == 0) {
                    string5 = TPasswordService.generateSalt(6);
                }
                this.strProcessedHtml.append("<input type=\"text\"");
                this.strProcessedHtml.append(" ID=\"" + string5 + "_input\"");
                this.strProcessedHtml.append(" List=\"" + string5 + "\"");
                Object object = tComboBoxColl.getValueOfKey(string);
                if (object != null) {
                    this.strProcessedHtml.append(" Value=\"" + objectutil.convertToString(object) + "\"");
                }
                this.strProcessedHtml.append("onkeydown=\"return keyDown(event,this);\"");
                this.strProcessedHtml.append(" " + string7);
                if (string7.toUpperCase().indexOf("ONCHANGE") < 0) {
                    this.strProcessedHtml.append(" onChange=\"dataListInputChanged(this)\"");
                }
                this.strProcessedHtml.append("></input>");
                this.strProcessedHtml.append("<input type=\"hidden\" List=\"" + string5 + "\" ID=\"" + string5 + "_input_submit" + "\" style='display:none' value=\"" + string + "\"></input>");
                this.strProcessedHtml.append("<datalist ");
                this.strProcessedHtml.append(" ID=\"" + string5 + "\"");
                this.strProcessedHtml.append(" Param=\"" + string6 + "\"");
                this.strProcessedHtml.append(" CollectionID=\"" + string10 + "\"");
                TAppCollectionsObject tAppCollectionsObject = TMainWin.Application.AppCollections.getAppCollectionsObject(string10);
                if (tAppCollectionsObject != null) {
                    this.strProcessedHtml.append(" DriverID=\"" + tAppCollectionsObject.DriverID.toString() + "\"");
                }
                this.strProcessedHtml.append(" Source=\"" + TMainWin.Application.getAspectHashID() + "\"");
                this.strProcessedHtml.append(" Filter=\"" + charutil.replaceChar(string12, '\"', '\'') + "\"");
                this.strProcessedHtml.append(" Params=\"" + string11 + "\"");
                this.strProcessedHtml.append(" SysDriverName=\"" + string13 + "\"");
                this.strProcessedHtml.append(">");
                this.strProcessedHtml.append(tComboBoxColl.toHtmlDataList(string));
                this.strProcessedHtml.append("</datalist>");
            } else {
                this.strProcessedHtml.append("<select ");
                this.strProcessedHtml.append(string7);
                this.strProcessedHtml.append(" ID=\"" + string5 + "\"");
                this.strProcessedHtml.append(" Param=\"" + string6 + "\"");
                this.strProcessedHtml.append(" CollectionID=\"" + string10 + "\"");
                TAppCollectionsObject tAppCollectionsObject = TMainWin.Application.AppCollections.getAppCollectionsObject(string10);
                if (tAppCollectionsObject != null) {
                    this.strProcessedHtml.append(" DriverID=\"" + tAppCollectionsObject.DriverID.toString() + "\"");
                }
                this.strProcessedHtml.append(" Source=\"" + TMainWin.Application.getAspectHashID() + "\"");
                this.strProcessedHtml.append(" Filter=\"" + string12 + "\"");
                this.strProcessedHtml.append(" Params=\"" + string11 + "\"");
                this.strProcessedHtml.append(" SysDriverName=\"" + string13 + "\"");
                this.strProcessedHtml.append(">");
                this.strProcessedHtml.append(tComboBoxColl.toHtmlSelect(string));
                this.strProcessedHtml.append("</select>");
            }
        } else {
            Object object;
            if (string4.equalsIgnoreCase("TEXT")) {
                this.strProcessedHtml.append("<input type=\"text\" ");
            } else if (string4.equalsIgnoreCase("NUMBER")) {
                this.strProcessedHtml.append("<input type=\"number\" ");
            } else if (string4.equalsIgnoreCase("CHECKBOX")) {
                this.strProcessedHtml.append("<input type=\"checkbox\" ");
            } else if (string4.equalsIgnoreCase("DATE")) {
                this.strProcessedHtml.append("<input type=\"date\" pattern=\"yyyy-MM-dd\"");
                if (string.trim().length() > 0) {
                    object = dateutil.parseDate(string);
                    this.strProcessedHtml.append("value=\"" + dateutil.formatDate((Date)object, "yyyy-MM-dd") + "\" ");
                }
            } else if (string4.equalsIgnoreCase("DATETIME")) {
                this.strProcessedHtml.append("<input type=\"datetime-local\" pattern=\"yyyy-MM-dd HH:mm\"");
            } else if (string4.equalsIgnoreCase("TIME")) {
                if (string7.length() == 0) {
                    string7 = "style=\"width:100px\"";
                }
                this.strProcessedHtml.append("<input type=\"text\" pattern=\"HH:mm\" datatype=\"time\" control=\"time\" ");
            } else if (string4.equalsIgnoreCase("HIDDEN")) {
                this.strProcessedHtml.append("<input type=\"hidden\" ");
            } else {
                this.strProcessedHtml.append("Error: Unrecognized input type: " + string4);
                return;
            }
            this.strProcessedHtml.append(string7);
            this.strProcessedHtml.append(" ID=\"" + string5 + "\"");
            this.strProcessedHtml.append(" Param=\"" + string6 + "\"");
            if (string4.equalsIgnoreCase("CHECKBOX")) {
                if (charutil.boolval(string)) {
                    this.strProcessedHtml.append(" Checked=\"Checked\"");
                }
            } else {
                this.strProcessedHtml.append(" Value=\"" + string + "\"");
            }
            if (this.hashArguments.containsKey("CONDITION") && this.hashArguments.containsKey("EXPRESSION")) {
                object = charutil.removeQuotes((String)this.hashArguments.get("CONDITION"));
                String string14 = charutil.removeQuotes((String)this.hashArguments.get("EXPRESSION"));
                this.strProcessedHtml.append(" Condition=\"" + (String)object + "\"");
                this.strProcessedHtml.append(" Expression=\"" + string14 + "\"");
            }
            this.strProcessedHtml.append(">");
        }
    }

    private void processCollection() {
        boolean bl;
        String[] stringArray = new String[]{"COLLECTIONID"};
        Enumeration enumeration = this.hashArguments.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.hashArguments.containsKey(stringArray[i])) continue;
            String string = "Error: Missing value in include tag: " + stringArray[i];
            System.out.println(string);
            this.strProcessedHtml.append(string);
            return;
        }
        String string = this.hashArguments.containsKey("ID") ? charutil.removeQuotes((String)this.hashArguments.get("ID")) : "";
        String string2 = this.hashArguments.containsKey("NAME") ? charutil.removeQuotes((String)this.hashArguments.get("NAME")) : "";
        String string3 = charutil.removeQuotes((String)this.hashArguments.get("COLLECTIONID"));
        String string4 = this.hashArguments.containsKey("SELECTED") ? charutil.removeQuotes((String)this.hashArguments.get("SELECTED")) : "";
        String string5 = this.hashArguments.containsKey("DRIVERPARAMS") ? charutil.removeQuotes((String)this.hashArguments.get("DRIVERPARAMS")) : "";
        String string6 = this.hashArguments.containsKey("FILTER") ? charutil.removeQuotes((String)this.hashArguments.get("FILTER")) : "";
        string6 = charutil.replaceChar(string6, '\'', '\"');
        string6 = charutil.replaceAllSubstrings(string6, "\\\"", "\"");
        String string7 = this.hashArguments.containsKey("SYSTEMDRIVERNAME") ? charutil.removeQuotes((String)this.hashArguments.get("SYSTEMDRIVERNAME")) : "";
        String string8 = this.hashArguments.containsKey("HTMLPARAMS") ? charutil.removeQuotes((String)this.hashArguments.get("HTMLPARAMS")) : "";
        boolean bl2 = this.hashArguments.containsKey("HIDESINGLESELECTION") ? charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("HIDESINGLESELECTION"))) : false;
        boolean bl3 = this.hashArguments.containsKey("DEBUG") ? charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("DEBUG"))) : false;
        boolean bl4 = this.hashArguments.containsKey("DATALIST") ? charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("DATALIST"))) : false;
        boolean bl5 = bl = this.hashArguments.containsKey("SUBMITDIALOGCELL") ? charutil.boolval(charutil.removeQuotes((String)this.hashArguments.get("SUBMITDIALOGCELL"))) : true;
        if (bl3) {
            this.MainWin.appendToLog("THtmlInclude", "processCollection", Thread.currentThread(), null, 3, "processCollection: Collection=" + string3 + " Filter=" + string6);
            System.out.println("processCollection: Collection=" + string3 + " Filter=" + string6);
        }
        TComboBoxColl tComboBoxColl = TMainWin.Application.AppCollections.getCollection(string3, new StringBuilder(string6), new TFormulaEvaluator(), false, string5, string7);
        if (bl2 && tComboBoxColl.size() == 1) {
            bl4 = false;
        }
        if (bl4) {
            if (string.trim().length() == 0) {
                string = TPasswordService.generateSalt(6);
            }
            this.strProcessedHtml.append("<input type=\"text\"");
            this.strProcessedHtml.append(" ID=\"" + string + "_input\"");
            this.strProcessedHtml.append(" List=\"" + string + "\"");
            Object object = tComboBoxColl.getValueOfKey(string4);
            if (object != null) {
                this.strProcessedHtml.append(" Value=\"" + objectutil.convertToString(object) + "\"");
            }
            this.strProcessedHtml.append("onkeydown=\"return keyDown(event,this);\"");
            this.strProcessedHtml.append(" " + string8);
            if (string8.toUpperCase().indexOf("ONCHANGE") < 0) {
                this.strProcessedHtml.append(" onChange=\"dataListInputChanged(this)\"");
            }
            this.strProcessedHtml.append(" SubmitDialogCell=\"" + bl + "\"");
            this.strProcessedHtml.append("></input>");
            this.strProcessedHtml.append("<input type=\"hidden\" List=\"" + string + "\" ID=\"" + string + "_input_submit" + "\" style='display:none' name=\"" + string2 + "\"></input>");
            this.strProcessedHtml.append("<datalist ");
            this.strProcessedHtml.append(" ID=\"" + string + "\"");
            this.strProcessedHtml.append(" Name=\"" + string2 + "\"");
            this.strProcessedHtml.append(" CollectionID=\"" + string3 + "\"");
            TAppCollectionsObject tAppCollectionsObject = TMainWin.Application.AppCollections.getAppCollectionsObject(string3);
            if (tAppCollectionsObject != null) {
                this.strProcessedHtml.append(" DriverID=\"" + tAppCollectionsObject.DriverID.toString() + "\"");
            }
            this.strProcessedHtml.append(" Source=\"" + TMainWin.Application.getAspectHashID() + "\"");
            this.strProcessedHtml.append(" Filter=\"" + charutil.replaceChar(string6, '\"', '\'') + "\"");
            this.strProcessedHtml.append(" Params=\"" + string5 + "\"");
            this.strProcessedHtml.append(" SysDriverName=\"" + string7 + "\"");
            this.strProcessedHtml.append(" " + string8);
            this.strProcessedHtml.append(">");
            this.strProcessedHtml.append(tComboBoxColl.toHtmlDataList(string4));
            this.strProcessedHtml.append("</datalist>");
        } else {
            this.strProcessedHtml.append("<select ");
            if (bl2 && tComboBoxColl.size() == 1) {
                string4 = tComboBoxColl.getValueOfIndex(0);
                this.strProcessedHtml.append("style='display:none' ");
            }
            this.strProcessedHtml.append(string8);
            if (bl && string8.toUpperCase().indexOf("ONCHANGE") < 0) {
                this.strProcessedHtml.append(" onChange=\"submitDialogCell(this)\"");
            }
            this.strProcessedHtml.append(" ID=\"" + string + "\"");
            this.strProcessedHtml.append(" Name=\"" + string2 + "\"");
            this.strProcessedHtml.append(" CollectionID=\"" + string3 + "\"");
            TAppCollectionsObject tAppCollectionsObject = TMainWin.Application.AppCollections.getAppCollectionsObject(string3);
            if (tAppCollectionsObject != null) {
                this.strProcessedHtml.append(" DriverID=\"" + tAppCollectionsObject.DriverID.toString() + "\"");
            }
            this.strProcessedHtml.append(" Source=\"" + TMainWin.Application.getAspectHashID() + "\"");
            this.strProcessedHtml.append(" Filter=\"" + charutil.replaceChar(string6, '\"', '\'') + "\"");
            this.strProcessedHtml.append(" Params=\"" + string5 + "\"");
            this.strProcessedHtml.append(" SysDriverName=\"" + string7 + "\"");
            this.strProcessedHtml.append(">");
            if (bl3) {
                this.MainWin.appendToLog("THtmlInclude", "processCollection", Thread.currentThread(), null, 3, "processCollection: tag=" + this.strProcessedHtml.toString());
                System.out.println("processCollection: tag=" + this.strProcessedHtml.toString());
            }
            this.strProcessedHtml.append(tComboBoxColl.toHtmlSelect(string4));
            this.strProcessedHtml.append("</select>");
        }
    }

    private void processView() {
        Object object;
        String string;
        if (!this.hashArguments.containsKey("VIEWID")) {
            this.strProcessedHtml.append("Error: Missing View ID");
            return;
        }
        String string2 = charutil.removeQuotes((String)this.hashArguments.get("VIEWID"));
        String string3 = "ViewID=" + string2;
        if (this.hashArguments.containsKey("SOURCE") && (string = charutil.removeQuotes((String)this.hashArguments.get("SOURCE"))).trim().length() > 0) {
            string3 = string3 + "&Source=" + string;
        }
        if (this.hashArguments.containsKey("PARAMS") && (string = charutil.removeQuotes((String)this.hashArguments.get("PARAMS"))).trim().length() > 0) {
            object = new TFormulaEvaluator().getFormulaValue("lookup(\"Greenlight_UI_Lookup_IsDimensionalView_by_View_ID\",\"" + string2 + "\")");
            if (object != null && charutil.boolval(objectutil.convertToString(object))) {
                string3 = string3 + "&DimDriverParams=" + charutil.replaceChar(string, '&', '^');
                string3 = string3 + "&" + string;
            } else {
                string3 = string3 + "&" + string;
            }
        }
        if (this.IsEmail) {
            string3 = string3 + "&PrepareEmail=true";
        }
        string = TMainWin.Application.getTokenValue("ExternalIPAddress");
        object = TFormulaEvaluator.getCache().getCachedContent(0, TMainWin.Application.getAspectHashID(), string3, true, string, this.sUserAgent);
        this.strProcessedHtml.append((String)object);
    }

    public void processTag() {
        if (this.hashArguments.size() == 0) {
            return;
        }
        this.strProcessedHtml.setLength(0);
        if (!this.hashArguments.containsKey("TYPE")) {
            return;
        }
        String string = charutil.removeQuotes(((String)this.hashArguments.get("TYPE")).toUpperCase());
        if (this.Debug) {
            System.out.println("processTag started.  Type=" + string);
        }
        String string2 = "";
        if (this.hashArguments.containsKey("SCRIPT")) {
            String string3 = (String)this.hashArguments.get("SCRIPT");
            if (string3.length() == 0 || string3.equals("0")) {
                return;
            }
            TExecScript tExecScript = new TExecScript(string3, null, new TFormulaEvaluator());
            tExecScript.executeScript();
            string2 = objectutil.convertToString(tExecScript.getScriptResult());
        }
        if (string.equals("FILE")) {
            this.processFile();
        } else if (string.equals("EXPRESSION")) {
            this.processExpression();
        } else if (string.equals("DRIVER")) {
            this.processDriver();
        } else if (string.equals("CONSTANT")) {
            this.processConstant();
        } else if (string.equals("SCRIPT")) {
            if (this.hashArguments.containsKey("COMMANDS")) {
                if (this.Debug) {
                    System.out.println("Calling process script");
                }
                this.processScript();
                if (this.Debug) {
                    System.out.println("Calling process script complete");
                }
            } else {
                this.strProcessedHtml.append(string2);
            }
        } else if (string.equals("WIDGET")) {
            this.processWidget();
        } else if (string.equals("EXTERNALDRIVERFILTER")) {
            if (!this.IsEmail) {
                this.processExternalDriverFilter();
            }
        } else if (string.equals("EXTERNALDRIVERPARAM")) {
            if (!this.IsEmail) {
                this.processExternalDriverParam();
            }
        } else if (string.equals("COLLECTION")) {
            this.processCollection();
        } else if (string.equals("VIEW")) {
            this.processView();
        }
    }

    public String getText() {
        if (this.Debug) {
            System.out.println("getText() = " + this.strProcessedHtml.toString());
        }
        return this.strProcessedHtml.toString();
    }
}

