/*
 * Decompiled with CFR 0.152.
 */
package controls.renderers;

import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.awt.Component;
import java.awt.Image;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import scrollwin.table.TScrollTable;
import utility.TFormulaEvaluator;
import utility.imageutil;

public class TNumberRenderer
extends JFormattedTextField
implements TableCellRenderer {
    JLabel label = null;
    TAspectDriver AspectDriver;
    NumberFormat numberFormat = null;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;
    boolean SuppressZeros = false;

    public TNumberRenderer(boolean bl, TAspectDriver tAspectDriver) {
        this.isBordered = bl;
        this.AspectDriver = tAspectDriver;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(4);
        this.label.setOpaque(true);
        this.numberFormat = NumberFormat.getInstance();
    }

    public void applyPattern(String string) {
        if (this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).applyPattern(string);
        }
    }

    public void setMinimumFractionDigits(int n) {
        this.numberFormat.setMinimumFractionDigits(n);
    }

    public void setMaximumFractionDigits(int n) {
        this.numberFormat.setMaximumFractionDigits(n);
    }

    public void setSuppressZeros(boolean bl) {
        this.SuppressZeros = bl;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3 = false;
        this.label.setText("");
        this.label.setHorizontalAlignment(2);
        this.label.setVerticalAlignment(0);
        this.label.setOpaque(true);
        if (bl) {
            this.label.setBackground(((TScrollTable)jTable).colorSelectionBackground);
        } else {
            this.label.setBackground(((TScrollTable)jTable).colorTableBackground);
        }
        this.label.setIcon(null);
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n2);
        if (tDriverStructRecord != null) {
            TFormulaEvaluator tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
            if (object instanceof Double) {
                this.label.setText(this.numberFormat.format((Double)object) + "  ");
                bl3 = (Double)object == 0.0;
            } else if (object instanceof Float) {
                this.label.setText(this.numberFormat.format(((Float)object).doubleValue()) + "  ");
                bl3 = ((Float)object).doubleValue() == 0.0;
            } else if (object instanceof Byte) {
                this.label.setText(this.numberFormat.format(((Byte)object).byteValue()) + "  ");
                bl3 = (Byte)object == 0;
            } else if (object instanceof Short) {
                this.label.setText(this.numberFormat.format(((Short)object).shortValue()) + "  ");
                bl3 = (Short)object == 0;
            } else if (object instanceof Integer) {
                this.label.setText(this.numberFormat.format(((Integer)object).intValue()) + "  ");
                bl3 = (Integer)object == 0;
            } else if (object instanceof Long) {
                this.label.setText(this.numberFormat.format((Long)object) + "  ");
                bl3 = (Long)object == 0L;
            } else {
                this.label.setText("");
            }
            if (bl3 && this.SuppressZeros) {
                this.label.setText("");
            }
            switch (tDriverStructRecord.RendererHorzLabelPosition) {
                case 0: 
                case 2: {
                    this.label.setHorizontalAlignment(4);
                    break;
                }
                case 1: {
                    this.label.setHorizontalAlignment(2);
                    break;
                }
                case 3: {
                    this.label.setHorizontalAlignment(0);
                    break;
                }
                case 4: {
                    this.label.setHorizontalAlignment(10);
                    break;
                }
                case 5: {
                    this.label.setHorizontalAlignment(11);
                }
            }
            switch (tDriverStructRecord.RendererVertLabelPosition) {
                case 0: 
                case 3: {
                    this.label.setVerticalAlignment(0);
                    break;
                }
                case 1: {
                    this.label.setVerticalAlignment(1);
                    break;
                }
                case 2: {
                    this.label.setVerticalAlignment(3);
                }
            }
            if (tDriverStructRecord.RendererIcon != null && tDriverStructRecord.RendererIcon.length() > 0) {
                Object object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.RendererIcon, this.AspectDriver.getAbsoluteDiskIndex(n), n);
                if (object2 != null) {
                    ImageIcon imageIcon;
                    String string = TMainWin.Application.parse_tokens(TFormulaEvaluator.convertToString(object2));
                    Image image = imageutil.getScaledImage(this.getClass(), string, -1, (int)((double)jTable.getRowHeight() * 0.95));
                    if (image != null && (imageIcon = new ImageIcon(image)) != null) {
                        this.label.setIcon(imageIcon);
                        imageIcon.setImageObserver(this.label);
                    }
                }
                switch (tDriverStructRecord.RendererHorzIconPosition) {
                    case 0: 
                    case 1: {
                        this.label.setHorizontalTextPosition(4);
                        break;
                    }
                    case 3: {
                        this.label.setHorizontalTextPosition(0);
                        break;
                    }
                    case 2: {
                        this.label.setHorizontalTextPosition(2);
                        break;
                    }
                    case 4: {
                        this.label.setHorizontalTextPosition(11);
                        break;
                    }
                    case 5: {
                        this.label.setHorizontalTextPosition(10);
                    }
                }
                switch (tDriverStructRecord.RendererVertIconPosition) {
                    case 0: 
                    case 3: {
                        this.label.setVerticalTextPosition(0);
                        break;
                    }
                    case 1: {
                        this.label.setVerticalTextPosition(3);
                        break;
                    }
                    case 2: {
                        this.label.setVerticalTextPosition(1);
                    }
                }
            }
        }
        if (this.isBordered) {
            if (bl && !bl2) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, jTable.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, jTable.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        return this.label;
    }
}

