/*
 * Decompiled with CFR 0.152.
 */
package drivercmd.common;

import aspect.Aspect;
import aspect.TMainWin;
import drivercmd.TAbstractDriverCmd;
import drivercmd.TDriverCmdInterface;
import drivercmd.common.TDriverCmdEmailAuthenticator;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import resources.TApplication;
import utility.dosutil;

public class TDriverCmdEmailReceive
extends TAbstractDriverCmd
implements TDriverCmdInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDriverCmdEmailReceive");
    TAspectDriver driverEmailAccount = null;
    TDriverStructRecord DSRecEmailAccountName = null;
    TDriverStructRecord DSRecPOPServer = null;
    TDriverStructRecord DSRecPOPUserName = null;
    TDriverStructRecord DSRecPOPPassword = null;
    TDriverStructRecord DSRecPOPLeaveMail = null;
    boolean ErrorInInit = true;

    public TDriverCmdEmailReceive(String string, String string2) {
        super(string, "EmailSentDate,EmailAddressFrom,EmailSubject,EmailBody", "EmailAttachment", "AttachDir|*,EmailAccount|*", "", string2);
    }

    @Override
    public String getDriverCommandName() {
        return this.getClass().getName();
    }

    @Override
    public boolean getMultipleInstancesAllowed() {
        return false;
    }

    @Override
    public void initialize() {
        TDriverStructRecord tDriverStructRecord = this.DriverInterface.getDriverStructRecord("Selected");
        String string = this.getPropertyValue("Records");
        String string2 = this.getPropertyValue("Selection");
        this.ErrorInInit = false;
        this.driverEmailAccount = new TAspectDriver("EmailAccounts", 0, false, true, "");
        if (!this.driverEmailAccount.isValid()) {
            MainWin.appendToLog("TDriverCmdEmailReceive", "initialize", Thread.currentThread(), null, 3, "Could not open driver of email accounts using the driver ID 'EmailAccounts'");
            Application.setTokenValue("$EmailTransferStatus", "Count not open list of email accounts.");
            this.driverEmailAccount.dispose();
            this.ErrorInInit = true;
            return;
        }
        this.DSRecEmailAccountName = this.driverEmailAccount.getDriverStructRecord("AccountName");
        if (this.DSRecEmailAccountName == null) {
            MainWin.appendToLog("TDriverCmdEmailReceive", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'AccountName' in email account driver.");
            this.ErrorInInit = true;
        }
        this.DSRecPOPServer = this.driverEmailAccount.getDriverStructRecord("POPHostName");
        if (this.DSRecPOPServer == null) {
            MainWin.appendToLog("TDriverCmdEmailReceive", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'POPHostName' in email account driver.");
            this.ErrorInInit = true;
        }
        this.DSRecPOPUserName = this.driverEmailAccount.getDriverStructRecord("POPUserName");
        if (this.DSRecPOPUserName == null) {
            MainWin.appendToLog("TDriverCmdEmailReceive", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'POPUserName' in email account driver.");
            this.ErrorInInit = true;
        }
        this.DSRecPOPPassword = this.driverEmailAccount.getDriverStructRecord("POPPassword");
        if (this.DSRecPOPPassword == null) {
            MainWin.appendToLog("TDriverCmdEmailReceive", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'POPPassword' in email account driver.");
            this.ErrorInInit = true;
        }
        this.DSRecPOPLeaveMail = this.driverEmailAccount.getDriverStructRecord("POPLeaveMail");
        if (this.DSRecPOPLeaveMail == null) {
            MainWin.appendToLog("TDriverCmdEmailReceive", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'POPLeaveMail' in email account driver.");
            this.ErrorInInit = true;
        }
    }

    @Override
    public void run() {
        int n;
        if (this.ErrorInInit) {
            return;
        }
        TDriverCmdEmailAuthenticator tDriverCmdEmailAuthenticator = null;
        TDriverStructRecord tDriverStructRecord = this.DriverInterface.getDriverStructRecord("EmailAttachment");
        Session session = null;
        Store store = null;
        Folder folder = null;
        Message[] messageArray = null;
        Address[] addressArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl = true;
        String string6 = this.getPropertyValue("EmailAccount");
        if (string6.length() == 0 || string6.equalsIgnoreCase("all")) {
            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 3, "Receiving mail for all accounts");
        } else {
            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 3, "Receiving mail for " + string6);
        }
        if (this.Debug) {
            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 3, "Email account driver contains " + this.driverEmailAccount.getRecordCount() + " records.");
            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 3, "Email account driver contains " + this.driverEmailAccount.getAbsoluteRecordCount() + " absolute records.");
        }
        for (n = 0; n < this.driverEmailAccount.getRecordCount(); ++n) {
            string2 = (String)this.driverEmailAccount.getField(this.DSRecEmailAccountName, n);
            if (this.Debug) {
                MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 3, "Account #" + n + " name is " + string2);
            }
            if (string6.length() == 0 || string6.equalsIgnoreCase("all")) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
                continue;
            }
            if (!string2.equalsIgnoreCase(string6)) continue;
            arrayList.add(string2);
        }
        if (this.Debug) {
            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 3, "Found " + arrayList.size() + " accounts.");
        }
        int n2 = 0;
        while (!this.TerminateDriverCmd & n2 < arrayList.size()) {
            string = (String)arrayList.get(n2);
            boolean bl2 = false;
            for (n = 0; !bl2 && n < this.driverEmailAccount.getRecordCount(); ++n) {
                string2 = (String)this.driverEmailAccount.getField(this.DSRecEmailAccountName, n);
                if (!string2.equalsIgnoreCase(string)) continue;
                string3 = (String)this.driverEmailAccount.getField(this.DSRecPOPServer, n);
                string4 = (String)this.driverEmailAccount.getField(this.DSRecPOPUserName, n);
                string5 = (String)this.driverEmailAccount.getField(this.DSRecPOPPassword, n);
                bl = (Boolean)this.driverEmailAccount.getField(this.DSRecPOPLeaveMail, n);
                bl2 = true;
            }
            if (bl2) {
                string6 = "Connecting to " + string;
                Application.setTokenValue("$EmailTransferStatus", string6);
                MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 10, string6);
                Properties properties = System.getProperties();
                properties.put("mail.pop3.host", string3);
                properties.put("mail.pop3s.host", string3);
                properties.put("mail.pop3.connectiontimeout", Integer.toString(20000));
                properties.put("mail.pop3s.connectiontimeout", Integer.toString(20000));
                properties.put("mail.pop3.timeout", Integer.toString(20000));
                properties.put("mail.pop3s.timeout", Integer.toString(20000));
                messageArray = null;
                try {
                    tDriverCmdEmailAuthenticator = new TDriverCmdEmailAuthenticator(string4, string5);
                    session = Session.getInstance((Properties)properties, (Authenticator)tDriverCmdEmailAuthenticator);
                    store = session.getStore("pop3");
                    store.connect();
                    folder = store.getFolder("INBOX");
                    folder.open(2);
                    messageArray = folder.getMessages();
                }
                catch (Exception exception) {
                    MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception, 4, "Error occurred receiving mail.");
                    Application.setTokenValue("$EmailTransferStatus", "An error occurred: " + exception.toString());
                }
                for (n = 0; messageArray != null && n < messageArray.length; ++n) {
                    int n3;
                    try {
                        string6 = "Receiving message (" + (n + 1) + " of " + messageArray.length + ") from " + string;
                        Application.setTokenValue("$EmailTransferStatus", string6);
                        MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 10, string6);
                        int n4 = this.DriverInterface.initializeNewRecord(true);
                        this.DriverInterface.putField("EmailAccount", n4, (Object)string);
                        this.DriverInterface.putField("EmailSentDate", n4, (Object)messageArray[n].getSentDate());
                        try {
                            addressArray = messageArray[n].getFrom();
                            stringBuilder.setLength(0);
                            for (n3 = 0; n3 < addressArray.length; ++n3) {
                                stringBuilder.append(addressArray[n3].toString());
                                if (n3 >= addressArray.length - 1) continue;
                                stringBuilder.append(";");
                            }
                            this.DriverInterface.putField("EmailAddressFrom", n4, (Object)stringBuilder.toString());
                        }
                        catch (Exception exception) {
                            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception, 4, "Error in 'from' address");
                            Application.setTokenValue("$EmailTransferStatus", "Error in 'from' address");
                        }
                        addressArray = messageArray[n].getRecipients(Message.RecipientType.TO);
                        try {
                            if (addressArray != null) {
                                stringBuilder.setLength(0);
                                for (n3 = 0; n3 < addressArray.length; ++n3) {
                                    stringBuilder.append(addressArray[n3].toString());
                                    if (n3 >= addressArray.length - 1) continue;
                                    stringBuilder.append(";");
                                }
                                this.DriverInterface.putField("EmailAddressTo", n4, (Object)stringBuilder.toString());
                            }
                        }
                        catch (Exception exception) {
                            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception, 4, "Error in 'to' address");
                            Application.setTokenValue("$EmailTransferStatus", "Error in 'to' address");
                        }
                        addressArray = messageArray[n].getRecipients(Message.RecipientType.CC);
                        try {
                            if (addressArray != null) {
                                stringBuilder.setLength(0);
                                for (n3 = 0; n3 < addressArray.length; ++n3) {
                                    stringBuilder.append(addressArray[n3].toString());
                                    if (n3 >= addressArray.length - 1) continue;
                                    stringBuilder.append(";");
                                }
                                this.DriverInterface.putField("EmailAddressToCC", n4, (Object)stringBuilder.toString());
                            }
                        }
                        catch (Exception exception) {
                            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception, 4, "Error in 'cc' address");
                            Application.setTokenValue("$EmailTransferStatus", "Error in 'cc' address");
                        }
                        addressArray = messageArray[n].getRecipients(Message.RecipientType.BCC);
                        try {
                            if (addressArray != null) {
                                stringBuilder.setLength(0);
                                for (n3 = 0; n3 < addressArray.length; ++n3) {
                                    stringBuilder.append(addressArray[n3].toString());
                                    if (n3 >= addressArray.length - 1) continue;
                                    stringBuilder.append(";");
                                }
                                this.DriverInterface.putField("EmailAddressToBCC", n4, (Object)stringBuilder.toString());
                            }
                        }
                        catch (Exception exception) {
                            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception, 4, "Error in 'bcc' address");
                            Application.setTokenValue("$EmailTransferStatus", "Error in 'bcc' address");
                        }
                        this.DriverInterface.putField("EmailSubject", n4, (Object)messageArray[n].getSubject());
                        String string7 = messageArray[n].getContentType();
                        Object object = messageArray[n].getContent();
                        if (object instanceof String) {
                            this.DriverInterface.putField("EmailBody", n4, object);
                        } else if (object instanceof MimeMultipart) {
                            MimeMultipart mimeMultipart = (MimeMultipart)object;
                            if (this.Debug) {
                                MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 10, "Reading multipart content for message " + n);
                            }
                            for (n3 = 0; n3 < mimeMultipart.getCount(); ++n3) {
                                Object object2;
                                Object object3;
                                Object object4;
                                Object object5;
                                MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(n3);
                                String string8 = mimeBodyPart.getContentType();
                                if (n3 == 0) {
                                    object5 = mimeBodyPart.getContent();
                                    if (object5 instanceof String) {
                                        this.DriverInterface.putField("EmailBody", n4, object5);
                                        continue;
                                    }
                                    if (!(object5 instanceof MimeMultipart)) continue;
                                    object4 = (MimeMultipart)object5;
                                    if (this.Debug) {
                                        MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 10, "Getting content for first multipart");
                                    }
                                    for (int i = 0; i < object4.getCount(); ++i) {
                                        object3 = (MimeBodyPart)object4.getBodyPart(i);
                                        object2 = object3.getContentType().toUpperCase();
                                        if (!((String)object2).startsWith("TEXT/PLAIN")) continue;
                                        this.DriverInterface.putField("EmailBody", n4, object3.getContent());
                                    }
                                    continue;
                                }
                                if (string8.toUpperCase().startsWith("TEXT/PLAIN")) {
                                    if (this.Debug) {
                                        MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 10, "Getting text content for multipart");
                                    }
                                    object5 = mimeBodyPart.getContent();
                                    continue;
                                }
                                if (tDriverStructRecord == null) continue;
                                object5 = dosutil.addTrailingSlash(this.getPropertyValue("AttachDir"));
                                object4 = mimeBodyPart.getFileName();
                                if (object4 == null || ((String)object4).length() <= 0) continue;
                                try {
                                    int n5;
                                    if (this.Debug) {
                                        MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 10, "Getting attachment");
                                    }
                                    InputStream inputStream = mimeBodyPart.getInputStream();
                                    object4 = (String)object5 + dosutil.getTempFilename((String)object5, "_" + (String)object4, "");
                                    stringBuilder.setLength(0);
                                    stringBuilder.append((String)this.DriverInterface.getField(tDriverStructRecord, n4));
                                    if (stringBuilder.length() > 0) {
                                        stringBuilder.append(";");
                                    }
                                    stringBuilder.append((String)object4);
                                    this.DriverInterface.putField(tDriverStructRecord, n4, (Object)stringBuilder.toString());
                                    object3 = new FileOutputStream((String)object4);
                                    object2 = new byte[1024];
                                    do {
                                        if ((n5 = inputStream.read((byte[])object2)) <= 0) continue;
                                        ((FileOutputStream)object3).write((byte[])object2, 0, n5);
                                    } while (n5 > 0);
                                    inputStream.close();
                                    ((FileOutputStream)object3).close();
                                    continue;
                                }
                                catch (Exception exception) {
                                    MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception, 4, "Error occurred reading attachment.");
                                    Application.setTokenValue("$EmailTransferStatus", "Error occurred reading attachment.");
                                }
                            }
                        }
                        if (!bl) {
                            if (this.Debug) {
                                MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 10, "Deleting message " + (n + 1));
                            }
                            try {
                                messageArray[n].setFlag(Flags.Flag.DELETED, true);
                            }
                            catch (Exception exception) {
                                MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception, 4, "Error deleting message.");
                            }
                        }
                        if (this.ScrollTable == null) continue;
                        this.AspectDriver.addToFilterList(n4);
                        this.ScrollTable.getTableModel().fireTableDataChanged();
                        continue;
                    }
                    catch (Exception exception) {
                        MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 4, "Error occurred receiving message.");
                        Application.setTokenValue("$EmailTransferStatus", "Error occurred receiving message.");
                        boolean bl3 = false;
                        try {
                            if (folder != null) {
                                folder.close(true);
                            }
                            if (store != null) {
                                store.close();
                            }
                        }
                        catch (Exception exception2) {
                            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception2, 4, "Error occurred closing connection to email server after exception.");
                            Application.setTokenValue("$EmailTransferStatus", "Error occurred closing connection to email server after exception");
                            bl3 = true;
                        }
                        try {
                            tDriverCmdEmailAuthenticator = new TDriverCmdEmailAuthenticator(string4, string5);
                            session = Session.getInstance((Properties)properties, (Authenticator)tDriverCmdEmailAuthenticator);
                            store = session.getStore("pop3");
                            store.connect();
                            folder = store.getFolder("INBOX");
                            folder.open(2);
                            messageArray = folder.getMessages();
                            if (!bl3) continue;
                            for (n3 = 0; n3 <= n; ++n3) {
                                messageArray[n3].setFlag(Flags.Flag.DELETED, true);
                            }
                            continue;
                        }
                        catch (Exception exception3) {
                            MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception3, 4, "Error occurred re-opening connection to email server.");
                            Application.setTokenValue("$EmailTransferStatus", "Error occurred re-opening connection to email server");
                        }
                    }
                }
                try {
                    if (folder != null) {
                        folder.close(true);
                    }
                    if (store != null) {
                        store.close();
                    }
                }
                catch (Exception exception) {
                    MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), exception, 4, "Error occurred closing connection.");
                    Application.setTokenValue("$EmailTransferStatus", "Error occurred closing connection.");
                }
            } else {
                MainWin.appendToLog("TDriverCmdEmailReceive", "run", Thread.currentThread(), null, 3, "Could not locate account information for " + string);
            }
            ++n2;
        }
        this.driverEmailAccount.dispose();
        Application.setTokenValue("$EmailTransferStatus", "");
        this.notifyDriverCmdFinished("ok");
    }

    @Override
    public boolean cancel() {
        this.TerminateDriverCmd = true;
        return true;
    }
}

