/*
 * Decompiled with CFR 0.152.
 */
package drivercmd.common;

import aspect.Aspect;
import aspect.TMainWin;
import drivercmd.TAbstractDriverCmd;
import drivercmd.TDriverCmdInterface;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.util.ArrayList;
import utility.ftp.TFtpClient;

public class TDriverCmdFtpTransfer
extends TAbstractDriverCmd
implements TDriverCmdInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDriverCmdFtpTransfer");
    TAspectDriver driverFtpAccount = null;
    TDriverStructRecord DSRecFtpAccountName = null;
    TDriverStructRecord DSRecFtpAccountHostName = null;
    TDriverStructRecord DSRecFtpAccountUserName = null;
    TDriverStructRecord DSRecFtpAccountPassword = null;
    TDriverStructRecord DSRecFtpAccountPassive = null;
    ArrayList arRecsToTransfer = new ArrayList();
    boolean ErrorInInit = true;

    public TDriverCmdFtpTransfer(String string, String string2) {
        super(string, "FileName,FtpRemoteFileName,FTPAccount", "FtpTransferOptions", "Direction|Send|Receive,Selection|All|Selected|Focused,Records|All|Displayed", "", string2);
    }

    @Override
    public String getDriverCommandName() {
        return this.getClass().getName();
    }

    @Override
    public boolean getMultipleInstancesAllowed() {
        return false;
    }

    @Override
    public void initialize() {
        TDriverStructRecord tDriverStructRecord = this.DriverInterface.getDriverStructRecord("Selected");
        String string = this.getPropertyValue("Records");
        String string2 = this.getPropertyValue("Selection");
        this.ErrorInInit = false;
        this.driverFtpAccount = new TAspectDriver("FTPAccounts", 0, false, true, "");
        if (!this.driverFtpAccount.isValid()) {
            MainWin.appendToLog("TDriverCmdFtpTransfer", "initialize", Thread.currentThread(), null, 3, "Could not open driver of FTP accounts using the driver ID 'FtpAccounts'");
            this.Application.setTokenValue("$FtpTransferStatus", "Count not open list of FTP accounts.");
            this.driverFtpAccount.dispose();
            this.ErrorInInit = true;
            return;
        }
        this.DSRecFtpAccountName = this.driverFtpAccount.getDriverStructRecord("FTPName");
        if (this.DSRecFtpAccountName == null) {
            MainWin.appendToLog("TDriverCmdFtpTransfer", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'FTPName' in ftp account driver.");
            this.ErrorInInit = true;
        }
        this.DSRecFtpAccountHostName = this.driverFtpAccount.getDriverStructRecord("FTPHost");
        if (this.DSRecFtpAccountHostName == null) {
            MainWin.appendToLog("TDriverCmdFtpTransfer", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'FTPHost' in ftp account driver.");
            this.ErrorInInit = true;
        }
        this.DSRecFtpAccountUserName = this.driverFtpAccount.getDriverStructRecord("FTPUserName");
        if (this.DSRecFtpAccountUserName == null) {
            MainWin.appendToLog("TDriverCmdFtpTransfer", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'FTPUserName' in ftp account driver.");
            this.ErrorInInit = true;
        }
        this.DSRecFtpAccountPassword = this.driverFtpAccount.getDriverStructRecord("FTPPassword");
        if (this.DSRecFtpAccountPassword == null) {
            MainWin.appendToLog("TDriverCmdFtpTransfer", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'FTPPassword' in ftp account driver.");
            this.ErrorInInit = true;
        }
        this.DSRecFtpAccountPassive = this.driverFtpAccount.getDriverStructRecord("FTPPassive");
        if (this.DSRecFtpAccountPassive == null) {
            MainWin.appendToLog("TDriverCmdFtpTransfer", "initialize", Thread.currentThread(), null, 3, "Could not locate field 'FTPPassive' in ftp account driver.");
            this.ErrorInInit = true;
        }
        if (this.ErrorInInit) {
            return;
        }
        if (string2.equalsIgnoreCase("focused")) {
            int[] nArray = this.ScrollTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                this.arRecsToTransfer.add(new Integer(this.AspectDriver.getAbsoluteDiskIndex(nArray[i])));
            }
        } else if (string.equalsIgnoreCase("all")) {
            if (string2.equalsIgnoreCase("all")) {
                for (int i = 0; i < this.DriverInterface.getRecordCount(); ++i) {
                    if (this.DriverInterface.isDeleted(i)) continue;
                    this.arRecsToTransfer.add(new Integer(i));
                }
            } else if (string2.equalsIgnoreCase("selected")) {
                for (int i = 0; i < this.DriverInterface.getRecordCount(); ++i) {
                    boolean bl;
                    if (this.DriverInterface.isDeleted(i) || !(bl = ((Boolean)this.DriverInterface.getField(tDriverStructRecord, i)).booleanValue())) continue;
                    this.arRecsToTransfer.add(new Integer(i));
                }
            }
        } else if (string.equalsIgnoreCase("displayed")) {
            if (string2.equalsIgnoreCase("all")) {
                for (int i = 0; i < this.AspectDriver.getRecordCount(); ++i) {
                    this.arRecsToTransfer.add(new Integer(this.AspectDriver.getAbsoluteDiskIndex(i)));
                }
            } else if (string2.equalsIgnoreCase("selected")) {
                for (int i = 0; i < this.AspectDriver.getRecordCount(); ++i) {
                    boolean bl = (Boolean)this.AspectDriver.getField(tDriverStructRecord, i);
                    if (!bl) continue;
                    this.arRecsToTransfer.add(new Integer(this.AspectDriver.getAbsoluteDiskIndex(i)));
                }
            }
        }
        if (this.arRecsToTransfer.size() == 0) {
            MainWin.appendToLog("TDriverCmdFtpTransfer", "initialize", Thread.currentThread(), null, 3, "No records selected for FTP transfer.");
            this.ErrorInInit = true;
            return;
        }
        if (this.Debug) {
            MainWin.appendToLog("TDriverCmdFtpTransfer", "initialize", Thread.currentThread(), null, 10, "Records to transfer: " + this.arRecsToTransfer.size());
        }
    }

    @Override
    public void run() {
        int n;
        if (this.ErrorInInit) {
            return;
        }
        TDriverStructRecord tDriverStructRecord = this.DriverInterface.getDriverStructRecord("FTPAccount");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        boolean bl = false;
        for (n = 0; n < this.arRecsToTransfer.size(); ++n) {
            string = (String)this.DriverInterface.getField(tDriverStructRecord, (int)((Integer)this.arRecsToTransfer.get(n)));
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        n = 0;
        while (!this.TerminateDriverCmd & n < arrayList.size()) {
            int n2;
            string = (String)arrayList.get(n);
            if (this.Debug) {
                MainWin.appendToLog("TDriverCmdFtpTransfer", "run", Thread.currentThread(), null, 10, "Transferring files for account: '" + string + "'.");
            }
            boolean bl2 = false;
            for (n2 = 0; !bl2 && n2 < this.driverFtpAccount.getRecordCount(); ++n2) {
                string2 = (String)this.driverFtpAccount.getField(this.DSRecFtpAccountName, n2);
                if (!string2.equalsIgnoreCase(string)) continue;
                string3 = (String)this.driverFtpAccount.getField(this.DSRecFtpAccountHostName, n2);
                string4 = (String)this.driverFtpAccount.getField(this.DSRecFtpAccountUserName, n2);
                string5 = (String)this.driverFtpAccount.getField(this.DSRecFtpAccountPassword, n2);
                bl = (Boolean)this.driverFtpAccount.getField(this.DSRecFtpAccountPassive, n2);
                bl2 = true;
            }
            if (bl2) {
                this.Application.setTokenValue("$FtpTransferStatus", "Connecting to " + string3);
                TFtpClient tFtpClient = new TFtpClient(string3, string4, string5, bl, 0);
                for (n2 = 0; !this.TerminateDriverCmd && n2 < this.arRecsToTransfer.size(); ++n2) {
                    int n3 = (Integer)this.arRecsToTransfer.get(n2);
                    string6 = (String)this.DriverInterface.getField("FTPAccount", n3);
                    if (!string6.equalsIgnoreCase(string2)) continue;
                    string7 = this.Application.parse_tokens((String)this.DriverInterface.getField("FileName", n3));
                    string8 = this.Application.parse_tokens((String)this.DriverInterface.getField("FtpRemoteFileName", n3));
                    boolean bl3 = false;
                    if (bl3) continue;
                    if (this.getPropertyValue("Direction").equalsIgnoreCase("SEND")) {
                        tFtpClient.transferFile(string7, string8, true, 0);
                        continue;
                    }
                    tFtpClient.transferFile(string7, string8, true, 1);
                }
                tFtpClient.dispose();
            } else {
                MainWin.appendToLog("TDriverCmdFtpTransfer", "run", Thread.currentThread(), null, 4, "Could not locate account information for the account named '" + string + "'.");
            }
            ++n;
        }
        this.driverFtpAccount.dispose();
    }

    @Override
    public boolean cancel() {
        this.TerminateDriverCmd = true;
        return true;
    }
}

