/*
 * Decompiled with CFR 0.152.
 */
package drivercmd.core;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TProgressBar;
import drivercmd.TAbstractDriverCmd;
import drivercmd.TDriverCmdInterface;
import drivercmd.core.TDriverCmdEditRecordWizardComparator;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.JOptionPane;
import resources.TAppDialogsObject;
import resources.TAppDriversObject;
import resources.TApplication;
import scrollwin.TScrollDialog;
import utility.charutil;
import utility.objectutil;

public class TDriverCmdEditRecordWizard
extends TAbstractDriverCmd
implements TDriverCmdInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDriverCmdEditRecordWizard");
    ArrayList arAppDialogObj = null;
    ArrayList arFieldsInWizard = null;
    TDriverStruct DriverStruct = null;
    TDriverStructRecord DSRecVirtualIndex = null;
    TAppDialogsObject DlgObjExplanationObj = null;
    TAppDialogsObject DlgObjFieldName = null;
    TAppDialogsObject DlgObjInput = null;
    TAppDialogsObject DlgObjNextButton = null;
    Integer SelectedVirtualIndex = null;
    Hashtable hashOriginalValues = null;
    boolean IsInserting = false;
    boolean SingleAddOnly = false;
    int Placement = 0;
    int SelectedRow = 0;
    boolean Abort = false;

    public TDriverCmdEditRecordWizard(String string, String string2) {
        super(string, "", "", "", "Record|Selected|New,Mode|Append|Insert,Single|true|false", string2);
    }

    @Override
    public String getDriverCommandName() {
        return this.getClass().getName();
    }

    @Override
    public boolean getMultipleInstancesAllowed() {
        return false;
    }

    @Override
    public void initialize() {
        String string;
        this.DriverStruct = this.AspectDriver.getDriverStruct();
        if (!this.initFieldCollection()) {
            return;
        }
        this.DSRecVirtualIndex = this.AspectDriver.getVirtualIndexField();
        if (this.ScrollTable != null) {
            this.SelectedRow = this.ScrollTable.getSelectedRow();
        }
        if ((string = this.getPropertyValue("Single")) != null && string.equalsIgnoreCase("true")) {
            this.SingleAddOnly = true;
        }
        if ((string = this.getPropertyValue("Record")) == null) {
            TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("EditRecordWizardOptions");
            TAspectDriver tAspectDriver = new TAspectDriver(TMainWin.Application, tAppDriversObject, 1, false, "");
            if (this.ScrollTable != null && this.SelectedRow >= 0) {
                Application.setTokenValue("$EditRecordWizardOptions", "edit");
            } else {
                Application.setTokenValue("$EditRecordWizardOptions", "insert");
            }
            TScrollDialog tScrollDialog = new TScrollDialog(MainWin, "Test Dialog", Application, tAspectDriver, tAppDriversObject.DialogIDStart.toString(), tAppDriversObject, 2);
            tScrollDialog.createGui();
            tScrollDialog.execute();
            String string2 = tScrollDialog.getReturnValue();
            if (string2.toUpperCase().startsWith("INSERT")) {
                this.IsInserting = true;
                this.Placement = 1;
            } else if (string2.toUpperCase().startsWith("APPEND")) {
                this.IsInserting = true;
                this.Placement = 0;
            } else if (string2.toUpperCase().startsWith("EDIT")) {
                this.IsInserting = false;
                if (this.SelectedRow < 0) {
                    JOptionPane.showMessageDialog(null, "There is no record selected in the table.  Select the record you wish to edit and run the wizard again.", "No record selected.", 1);
                }
            } else {
                this.Abort = true;
            }
        } else {
            this.IsInserting = string != null && string.equalsIgnoreCase("new");
            string = this.getPropertyValue("Placement");
            this.Placement = string != null && string.equalsIgnoreCase("append") ? 0 : 1;
        }
    }

    public boolean getDialogResource() {
        this.arAppDialogObj = TDriverCmdEditRecordWizard.Application.AppDialogs.getResourceElements("EditRecordWizardDialog");
        if (this.arAppDialogObj.size() == 0) {
            MainWin.appendToLog("TDriverCmdEditRecordWizard", "run", Thread.currentThread(), null, 4, "Cannot locate default wizard dialog with ID of 'EditRecordWizardDialog'.");
            return false;
        }
        return true;
    }

    public boolean initReplaceableFields() {
        for (int i = 0; i < this.arAppDialogObj.size(); ++i) {
            TAppDialogsObject tAppDialogsObject = (TAppDialogsObject)this.arAppDialogObj.get(i);
            if (tAppDialogsObject.SectionDescription2.equalsIgnoreCase("Explanation")) {
                this.DlgObjExplanationObj = tAppDialogsObject;
                continue;
            }
            if (tAppDialogsObject.SectionDescription2.equalsIgnoreCase("FieldName")) {
                this.DlgObjFieldName = tAppDialogsObject;
                continue;
            }
            if (tAppDialogsObject.SectionDescription2.equalsIgnoreCase("Input")) {
                this.DlgObjInput = tAppDialogsObject;
                continue;
            }
            if (!tAppDialogsObject.SectionDescription2.equalsIgnoreCase("Next")) continue;
            this.DlgObjNextButton = tAppDialogsObject;
        }
        if (this.DlgObjExplanationObj == null || this.DlgObjFieldName == null || this.DlgObjInput == null || this.DlgObjNextButton == null) {
            MainWin.appendToLog("TDriverCmdEditRecordWizard", "run", Thread.currentThread(), null, 4, "Cannot locate default fields in wizard dialog.");
            return false;
        }
        return true;
    }

    public boolean initFieldCollection() {
        this.arFieldsInWizard = new ArrayList();
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            if (tDriverStructRecord.WizardFrame <= 0) continue;
            this.arFieldsInWizard.add(tDriverStructRecord);
        }
        if (this.arFieldsInWizard.size() == 0) {
            MainWin.appendToLog("TDriverCmdEditRecordWizard", "run", Thread.currentThread(), null, 4, "No fields are marked for inclusion in the wizard.");
            JOptionPane.showMessageDialog(null, "This wizard has not been created.", "Missing Wizard", 1);
            this.arFieldsInWizard.clear();
            if (this.arAppDialogObj != null) {
                this.arAppDialogObj.clear();
            }
            return false;
        }
        Collections.sort(this.arFieldsInWizard, new TDriverCmdEditRecordWizardComparator());
        return true;
    }

    public int initializeRecord() {
        if (!this.IsInserting) {
            if (this.SelectedRow >= 0) {
                this.hashOriginalValues = new Hashtable();
                for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
                    Object object;
                    TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                    if (tDriverStructRecord.IsCalculated || tDriverStructRecord.IsVirtual || (object = this.AspectDriver.getField(tDriverStructRecord, this.SelectedRow)) == null) continue;
                    this.hashOriginalValues.put(tDriverStructRecord.FullID, object);
                }
            }
            return this.SelectedRow;
        }
        if (this.AspectDriver.AppDriverObj.MaxRecords > 0 && this.AspectDriver.getAbsoluteRecordCount() >= this.AspectDriver.AppDriverObj.MaxRecords) {
            this.AspectDriver.showMaxRecordsReachedMessage();
            return -1;
        }
        this.AspectDriver.beginNewUndoOperation("Insert Record");
        if (this.DSRecVirtualIndex != null && this.SelectedRow >= 0) {
            this.SelectedVirtualIndex = (Integer)this.AspectDriver.getField(this.DSRecVirtualIndex, this.SelectedRow);
        }
        int n = this.AspectDriver.initializeNewRecord(this.AspectDriver.AppDriverObj.InsertMode, this.SelectedRow);
        int n2 = this.AspectDriver.addToFilterList(n, -1);
        if (this.ScrollTable != null) {
            this.ScrollTable.getTableModel().WizardTempRecordExists = true;
        }
        return n2;
    }

    public int finalizeNewRecord(int n) {
        int n2 = this.AspectDriver.getAbsoluteDiskIndex(n);
        this.AspectDriver.removeFromFilterList(n2);
        if (this.ScrollTable != null) {
            this.ScrollTable.getTableModel().WizardTempRecordExists = false;
        }
        if (this.DSRecVirtualIndex != null) {
            if (this.Placement == 0) {
                this.SelectedVirtualIndex = new Integer(this.AspectDriver.getNextVirtualIndex());
            } else if (this.SelectedVirtualIndex != null) {
                this.AspectDriver.createUnusedVirtualIndex(this.SelectedVirtualIndex);
            } else {
                this.SelectedVirtualIndex = new Integer(this.AspectDriver.getNextVirtualIndex());
            }
            this.AspectDriver.putFieldAbsolute(this.DSRecVirtualIndex, n2, (Object)this.SelectedVirtualIndex);
        }
        int n3 = this.Placement == 0 ? this.AspectDriver.addToFilterList(n2, -1) : this.AspectDriver.addToFilterList(n2, this.SelectedRow);
        return n3;
    }

    public void initializeField(int n, int n2, TDriverStructRecord tDriverStructRecord) {
        if (this.IsInserting && tDriverStructRecord.WizardInitField.length() > 0) {
            String string = Application.parse_tokens(tDriverStructRecord.WizardInitField);
            Object object = this.AspectDriver.getFormulaEvaluator().getFormulaValue(string, n, n2);
            string = objectutil.convertToString(object);
            if (object != null) {
                object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string, n);
                this.AspectDriver.putFieldAbsolute(tDriverStructRecord, n, object);
            }
        }
    }

    public int executeWizard(int n) {
        TScrollDialog tScrollDialog = null;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Stack<Integer> stack = new Stack<Integer>();
        double d = 0.0;
        int n2 = 0;
        int n3 = this.arFieldsInWizard.size();
        int n4 = 1;
        int n5 = this.DlgObjInput.ControlW;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = this.AspectDriver.getAbsoluteDiskIndex(n);
        TProgressBar tProgressBar = new TProgressBar("", n3);
        do {
            Object object;
            String string;
            String string2;
            tProgressBar.setValue(n2 + 1);
            tScrollDialog = null;
            TDriverStructRecord tDriverStructRecord = null;
            if (n2 < n3) {
                tDriverStructRecord = (TDriverStructRecord)this.arFieldsInWizard.get(n2);
                this.initializeField(n6, n, tDriverStructRecord);
                if (tDriverStructRecord.WizardAltDialog.length() == 0 || tDriverStructRecord.WizardAltDialog.equals("0")) {
                    stringBuilder.setLength(0);
                    stringBuilder.append(tDriverStructRecord.Description);
                    charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "\\", " ");
                    stringBuilder2.setLength(0);
                    stringBuilder2.append("<html>");
                    if (tDriverStructRecord.WizardExplanation.length() > 0) {
                        stringBuilder2.append(tDriverStructRecord.WizardExplanation);
                        charutil.replaceAllSubstrings(stringBuilder2, stringBuilder2, "\\n", "<br>");
                        charutil.replaceAllSubstrings(stringBuilder2, stringBuilder2, ". ", ".&nbsp &nbsp ");
                    } else if (tDriverStructRecord.Tooltip.length() > 0) {
                        stringBuilder2.append(tDriverStructRecord.Tooltip);
                        charutil.replaceAllSubstrings(stringBuilder2, stringBuilder2, "\\n", "<br>");
                        charutil.replaceAllSubstrings(stringBuilder2, stringBuilder2, ". ", ".&nbsp &nbsp ");
                    } else {
                        stringBuilder2.append((CharSequence)stringBuilder);
                    }
                    stringBuilder2.append("</html>");
                    this.DlgObjExplanationObj.ControlLabel.setLength(0);
                    this.DlgObjExplanationObj.ControlLabel.append((CharSequence)stringBuilder2);
                    if (this.DlgObjExplanationObj.ControlLabel.length() == 0) {
                        this.DlgObjExplanationObj.ControlLabel.append("Enter a value for the field named " + stringBuilder);
                    }
                    this.DlgObjFieldName.ControlLabel.setLength(0);
                    this.DlgObjFieldName.ControlLabel.append("<html><b>");
                    this.DlgObjFieldName.ControlLabel.append((CharSequence)stringBuilder);
                    this.DlgObjFieldName.ControlLabel.append("</html>");
                    if (tDriverStructRecord.IsLookup) {
                        this.DlgObjInput.ControlType = 5;
                        this.DlgObjInput.ControlW = n5;
                    } else {
                        switch (tDriverStructRecord.FieldType) {
                            case 1: 
                            case 19: 
                            case 25: {
                                this.DlgObjInput.ControlType = 3;
                                this.DlgObjInput.ControlLabel.setLength(0);
                                this.DlgObjInput.ControlLabel.append((CharSequence)stringBuilder);
                                this.DlgObjInput.ControlW = n5;
                                break;
                            }
                            case 8: 
                            case 9: 
                            case 12: {
                                this.DlgObjInput.ControlType = 19;
                                this.DlgObjInput.ControlW = 100;
                                break;
                            }
                            case 3: 
                            case 11: 
                            case 15: 
                            case 20: 
                            case 24: 
                            case 26: {
                                this.DlgObjInput.ControlType = 2;
                                this.DlgObjInput.ControlW = n5;
                                break;
                            }
                            case 2: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                this.DlgObjInput.ControlType = 18;
                                this.DlgObjInput.ControlW = 100;
                                break;
                            }
                            case 10: 
                            case 21: {
                                this.DlgObjInput.ControlType = 17;
                                this.DlgObjInput.ControlW = 150;
                                break;
                            }
                            case 13: {
                                this.DlgObjInput.ControlType = 25;
                                this.DlgObjInput.ControlW = 150;
                                break;
                            }
                            case 18: {
                                this.DlgObjInput.ControlType = 24;
                                this.DlgObjInput.ControlW = 150;
                            }
                        }
                    }
                    this.DlgObjInput.ControlID.setLength(0);
                    this.DlgObjInput.ControlID.append(tDriverStructRecord.FullID);
                    this.DlgObjNextButton.ControlLabel.setLength(0);
                    if (!this.IsInserting) {
                        if (n2 == n3 - 1) {
                            this.DlgObjNextButton.ControlLabel.append("Finish");
                            this.DlgObjNextButton.Mnemonic = (char)70;
                        } else {
                            this.DlgObjNextButton.ControlLabel.append("Next");
                            this.DlgObjNextButton.Mnemonic = (char)78;
                        }
                    } else if (this.SingleAddOnly && n2 == n3 - 1) {
                        this.DlgObjNextButton.ControlLabel.append("Finish");
                        this.DlgObjNextButton.Mnemonic = (char)70;
                    } else {
                        this.DlgObjNextButton.ControlLabel.append("Next");
                        this.DlgObjNextButton.Mnemonic = (char)78;
                    }
                    tScrollDialog = new TScrollDialog(MainWin, "Test Dialog", Application, this.AspectDriver, "", this.AspectDriver.AppDriverObj, 1);
                    tScrollDialog.setResourceElements(this.arAppDialogObj);
                } else {
                    tScrollDialog = new TScrollDialog(MainWin, "Test Dialog", Application, this.AspectDriver, tDriverStructRecord.WizardAltDialog, this.AspectDriver.AppDriverObj, 2);
                }
                tScrollDialog.createGui();
                tScrollDialog.transferValues(n, 0);
                tScrollDialog.execute();
                string2 = tScrollDialog.getReturnValue();
            } else if (!this.SingleAddOnly && this.IsInserting) {
                tScrollDialog = new TScrollDialog(MainWin, "Test Dialog", Application, this.AspectDriver, "EditRecordWizardDialogRepeat", this.AspectDriver.AppDriverObj, 2);
                tScrollDialog.createGui();
                tScrollDialog.execute();
                string2 = tScrollDialog.getReturnValue();
            } else {
                string2 = "finish";
            }
            if (string2 == "") {
                string2 = "cancel";
            }
            int n7 = n2;
            if (tDriverStructRecord != null) {
                tScrollDialog.transferValues(n, 1);
                if (!string2.equalsIgnoreCase("back") && !string2.equalsIgnoreCase("cancel") && tDriverStructRecord.WizardValidateField.length() > 0) {
                    bl2 = false;
                    string = Application.parse_tokens(tDriverStructRecord.WizardValidateField);
                    object = this.AspectDriver.getFormulaEvaluator().getFormulaValue(string, n6, n);
                    if (object instanceof Boolean) {
                        if (((Boolean)object).booleanValue()) {
                            bl2 = true;
                        } else {
                            JOptionPane.showMessageDialog(null, "The value entered is not valid.", "Not a valid entry.", 1);
                        }
                    } else if (object instanceof String) {
                        JOptionPane.showMessageDialog(null, (String)object, "Not a valid entry.", 1);
                    } else {
                        MainWin.appendToLog("TDriverCmdEditRecordWizard", "executeWizard", Thread.currentThread(), null, 4, "The expression used to validate the wizard entry for " + tDriverStructRecord.ID + " is not a boolean or string value.");
                    }
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (tScrollDialog != null) {
                tScrollDialog.dispose();
            }
            if (!bl2 && !string2.equalsIgnoreCase("cancel")) continue;
            if (string2.equalsIgnoreCase("back")) {
                if (!stack.empty()) {
                    Integer n8 = (Integer)stack.pop();
                    n2 = n8;
                }
            } else if (string2.equalsIgnoreCase("next")) {
                tDriverStructRecord = (TDriverStructRecord)this.arFieldsInWizard.get(n2);
                if (tDriverStructRecord.WizardSkipToFrame.length() > 0) {
                    string = Application.parse_tokens(tDriverStructRecord.WizardSkipToFrame);
                    object = this.AspectDriver.getFormulaEvaluator().getFormulaValue(string, n6, n);
                    d = object instanceof Double ? (Double)object : charutil.dval(objectutil.convertToString(object));
                    if (d > 0.0) {
                        for (int i = 0; i < this.arFieldsInWizard.size(); ++i) {
                            tDriverStructRecord = (TDriverStructRecord)this.arFieldsInWizard.get(i);
                            if ((double)tDriverStructRecord.WizardFrame == d) {
                                n2 = i;
                                continue;
                            }
                            this.initializeField(n6, n, tDriverStructRecord);
                        }
                    } else {
                        MainWin.appendToLog("TDriverCmdEditRecordWizard", "executeWizard", Thread.currentThread(), null, 4, "Expression '" + tDriverStructRecord.WizardSkipToFrame + "' does not resolve to a number.");
                    }
                } else if (n2 < n3) {
                    ++n2;
                }
            } else if (string2.equalsIgnoreCase("cancel")) {
                n4 = 1;
                bl = true;
            } else if (string2.equalsIgnoreCase("finish")) {
                n4 = 0;
                bl = true;
            } else if (string2.equalsIgnoreCase("Add another record")) {
                n4 = 2;
                bl = true;
            }
            if (n2 < n3 && !bl && !string2.equalsIgnoreCase("back")) {
                boolean bl3;
                do {
                    bl3 = false;
                    tDriverStructRecord = (TDriverStructRecord)this.arFieldsInWizard.get(n2);
                    if (tDriverStructRecord.WizardSkipFrame.length() <= 0) continue;
                    string = Application.parse_tokens(tDriverStructRecord.WizardSkipFrame);
                    object = this.AspectDriver.getFormulaEvaluator().getFormulaValue(string, n6, n);
                    if (object != null && object instanceof Boolean) {
                        if (!((Boolean)object).booleanValue()) continue;
                        this.initializeField(n6, n, tDriverStructRecord);
                        if (n2 >= n3 - 1) continue;
                        ++n2;
                        bl3 = true;
                        continue;
                    }
                    MainWin.appendToLog("TDriverCmdEditRecordWizard", "executeWizard", Thread.currentThread(), null, 4, "Expression '" + tDriverStructRecord.WizardSkipToFrame + "' does not resolve to a true or false value.");
                } while (bl3);
            }
            if (string2.equalsIgnoreCase("back")) continue;
            stack.push(new Integer(n7));
        } while (!bl);
        tProgressBar.dispose();
        stack.clear();
        return n4;
    }

    @Override
    public void run() {
        int n;
        if (this.arFieldsInWizard.size() == 0) {
            this.notifyDriverCmdFinished("No fields defined for wizard");
            return;
        }
        if (this.Abort) {
            this.notifyDriverCmdFinished("Cancel was pressed");
            return;
        }
        if (!this.getDialogResource()) {
            this.notifyDriverCmdFinished("Dialog resource was not defined");
            return;
        }
        if (!this.initReplaceableFields()) {
            this.notifyDriverCmdFinished("Dialog resources not defined");
            return;
        }
        do {
            int n2;
            if ((n2 = this.initializeRecord()) < 0) {
                return;
            }
            int n3 = this.AspectDriver.getAbsoluteDiskIndex(n2);
            n = this.executeWizard(n2);
            if (this.IsInserting) {
                if (n == 1) {
                    this.AspectDriver.deleteRecord(n2);
                    this.AspectDriver.removeLastUndo();
                    this.AspectDriver.removeFromFilterList(n3);
                    if (this.ScrollTable != null) {
                        this.ScrollTable.getTableModel().WizardTempRecordExists = false;
                        if (this.Placement == 0) {
                            this.ScrollTable.setSelectedRow(this.ScrollTable.getTableModel().getRowCount() - 1, true);
                        } else {
                            this.ScrollTable.setSelectedRow(this.SelectedRow - 1, true);
                        }
                    }
                } else {
                    n2 = this.finalizeNewRecord(n2);
                }
            } else if (n == 1 && this.hashOriginalValues != null) {
                Enumeration enumeration = this.hashOriginalValues.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.AspectDriver.putField(string, n2, this.hashOriginalValues.get(string));
                }
            }
            if (this.hashOriginalValues != null) {
                this.hashOriginalValues.clear();
            }
            if (n != 1) {
                if (this.ScrollTable != null) {
                    this.ScrollTable.getTableModel().fireTableRowsInserted(n2, n2);
                    this.ScrollTable.getTableModel().fireTableDataChanged();
                }
                if (n != 2) {
                    if (this.ScrollTable != null) {
                        this.ScrollTable.setSelectedRow(n2, true);
                    }
                    this.SelectedRow = n2;
                }
            }
            if (n != 2) continue;
            ++n2;
            if (this.ScrollTable != null) {
                int n4 = this.ScrollTable.getTableModel().getRowCount();
                if (n2 >= n4) {
                    n2 = n4 - 1;
                }
                this.ScrollTable.setSelectedRow(n2, true);
            }
            this.SelectedRow = n2;
        } while (n == 2);
        this.arFieldsInWizard.clear();
        this.arAppDialogObj.clear();
        this.notifyDriverCmdFinished("Ok");
    }

    @Override
    public boolean cancel() {
        this.TerminateDriverCmd = true;
        return true;
    }
}

