/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import utility.THtmlTag;
import utility.charutil;
import utility.objectutil;

public class TDriverInspect {
    String InspectMenuID = "";
    String[] arMenuItemID = null;
    String[] arName = null;
    String[] arDescription = null;
    String[] arViewTitle = null;
    String[] arViewID = null;
    String[] arParameters = null;
    String[] arCondition = null;
    boolean[] arHide = null;
    int cMenuItem = 0;

    public TDriverInspect(String string) {
        this.InspectMenuID = string;
        TAspectDriver tAspectDriver = new TAspectDriver("Greenlight_Driver_Inspect_Menu_Item_Consolidated", 0, true, true, "");
        tAspectDriver.setActiveFilter("Inspect_Menu_ID=\"" + this.InspectMenuID + "\"", false);
        String[] stringArray = new String[]{"Sort_Order"};
        tAspectDriver.setSortOptions(stringArray, true);
        this.cMenuItem = tAspectDriver.getRecordCount();
        this.arMenuItemID = new String[this.cMenuItem];
        this.arName = new String[this.cMenuItem];
        this.arDescription = new String[this.cMenuItem];
        this.arViewTitle = new String[this.cMenuItem];
        this.arViewID = new String[this.cMenuItem];
        this.arParameters = new String[this.cMenuItem];
        this.arCondition = new String[this.cMenuItem];
        this.arHide = new boolean[this.cMenuItem];
        for (int i = 0; i < this.cMenuItem; ++i) {
            this.arMenuItemID[i] = (String)tAspectDriver.getField("ID", i);
            this.arName[i] = (String)tAspectDriver.getField("Name", i);
            this.arDescription[i] = (String)tAspectDriver.getField("Description_Expression", i);
            this.arViewTitle[i] = (String)tAspectDriver.getField("Title_Expression", i);
            this.arViewID[i] = (String)tAspectDriver.getField("Inspect_View_ID", i);
            this.arParameters[i] = (String)tAspectDriver.getField("Inspect_View_Parameters", i);
            this.arCondition[i] = (String)tAspectDriver.getField("Enable_Expression", i);
            this.arHide[i] = (Boolean)tAspectDriver.getField("Hide_When_Disabled", i);
        }
        tAspectDriver.dispose();
    }

    public int menuItemCount() {
        return this.cMenuItem;
    }

    public String getMenuItemID(int n) {
        if (n < 0 || n >= this.cMenuItem) {
            return "error";
        }
        return this.arMenuItemID[n];
    }

    public String getInspectMenuHtml(TAspectDriver tAspectDriver, String string) {
        THtmlTag tHtmlTag = new THtmlTag("div");
        tHtmlTag.setProperty("ID", "InspectMenu" + string.toLowerCase());
        tHtmlTag.setProperty("class", "inspect_menu_container");
        tHtmlTag.setProperty("style", "display:none");
        tHtmlTag.setProperty("TDID", "");
        tHtmlTag.setProperty("source", TMainWin.Application.getAspectHashID());
        THtmlTag tHtmlTag2 = new THtmlTag("ul");
        tHtmlTag2.setProperty("class", "inspect_menu_ul");
        tHtmlTag2.setProperty("ID", "InspectUL" + string.toLowerCase());
        for (int i = 0; i < this.cMenuItem; ++i) {
            THtmlTag tHtmlTag3 = new THtmlTag("li");
            tHtmlTag3.setProperty("ID", this.arMenuItemID[i]);
            if (this.arViewID[i].length() > 1 || this.arParameters[i].length() != 0) {
                tHtmlTag3.setProperty("class", "inspect_menu_li");
                tHtmlTag3.setProperty("onClick", "inspectMenuItemSelected('" + string.toLowerCase() + "','" + this.arMenuItemID[i] + "')");
            }
            tHtmlTag2.addContent(tHtmlTag3);
        }
        tHtmlTag.addContent(tHtmlTag2);
        return tHtmlTag.toString();
    }

    public String getMenuItemDescription(TAspectDriver tAspectDriver, int n, int n2) {
        if (n2 < 0 || n2 >= this.cMenuItem) {
            return "Invalid MenuItemIndex: " + n2;
        }
        if (this.arViewID[n2].length() <= 1 && this.arParameters[n2].trim().length() == 0) {
            return "<hr>";
        }
        if (this.arDescription[n2].trim().length() == 0) {
            if (this.arName[n2].trim().length() > 0) {
                return this.arName[n2];
            }
            return "Menu Item " + (n2 + 1);
        }
        Object object = tAspectDriver.getFormulaEvaluator().getFormulaValue(this.arDescription[n2], n, -1);
        if (object == null) {
            System.out.println("TDriverInspect:getMenuItemDescription null returned for " + this.arDescription[n2] + " Record=" + n);
            return "Invalid description: " + this.arDescription[n2];
        }
        return objectutil.convertToString(object);
    }

    public String getMenuItemViewTitle(TAspectDriver tAspectDriver, int n, int n2) {
        if (n2 < 0 || n2 >= this.cMenuItem) {
            return "Invalid MenuItemIndex: " + n2;
        }
        if (this.arViewTitle[n2].trim().length() == 0) {
            if (this.arName[n2].trim().length() > 0) {
                return this.arName[n2];
            }
            return "Menu Item " + (n2 + 1);
        }
        Object object = tAspectDriver.getFormulaEvaluator().getFormulaValue(this.arViewTitle[n2], n, -1);
        if (object == null) {
            return "Invalid view title: " + this.arViewTitle[n2];
        }
        return objectutil.convertToString(object);
    }

    public String getMenuItemParams(TAspectDriver tAspectDriver, int n, int n2) {
        if (n2 < 0 || n2 >= this.cMenuItem) {
            return "Invalid MenuItemIndex: " + n2;
        }
        Object object = tAspectDriver.getFormulaEvaluator().getFormulaValue(this.arParameters[n2], n, -1);
        String string = object == null ? "" : objectutil.convertToString(object);
        String string2 = this.arViewID[n2].trim().equals("0") || this.arViewID[n2].trim().length() == 0 ? "" : "ViewID=" + this.arViewID[n2] + "&";
        return string2 + string;
    }

    public boolean isEnabled(TAspectDriver tAspectDriver, int n, int n2) {
        if (n2 < 0 || n2 >= this.cMenuItem) {
            return false;
        }
        if (this.arCondition[n2].trim().length() == 0) {
            return false;
        }
        Object object = tAspectDriver.getFormulaEvaluator().getFormulaValue(this.arCondition[n2], n, -1);
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            return charutil.boolval((String)object);
        }
        return (Boolean)object;
    }

    public boolean hideWhenDisabled(int n) {
        if (n < 0 || n >= this.cMenuItem) {
            return false;
        }
        return this.arHide[n];
    }
}

