/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.Date;
import utility.TFile;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.security.TPasswordService;
import utility.ziputil;

public class TPackage {
    TMainWin MainWin = Aspect.MainWin;
    TAspectDriver PackageDriver;
    int Record;

    public TPackage(TAspectDriver tAspectDriver, int n) {
        this.PackageDriver = tAspectDriver;
        this.Record = n;
    }

    public int getVirtualIndex() {
        return (Integer)this.PackageDriver.getField("VirtualIndex", this.Record);
    }

    public boolean isCorePackage() {
        String string = (String)this.PackageDriver.getField("PackageID", this.Record);
        return string.equalsIgnoreCase("aspect_software_net_common") || string.equalsIgnoreCase("aspect_software_net_core");
    }

    public boolean isReadOnly() {
        return !this.PackageDriver.isWriteable();
    }

    public String getPackageID() {
        return (String)this.PackageDriver.getField("PackageID", this.Record);
    }

    public void setPackageID(String string) {
        this.PackageDriver.putField("PackageID", this.Record, (Object)string);
    }

    public String getPackageName() {
        return (String)this.PackageDriver.getField("PackageName", this.Record);
    }

    public void setPackageName(String string) {
        this.PackageDriver.putField("PackageName", this.Record, (Object)string);
    }

    public boolean isDeleted() {
        return (Boolean)this.PackageDriver.getField("Deleted", this.Record);
    }

    public boolean getEnabled() {
        return (Boolean)this.PackageDriver.getField("selected", this.Record);
    }

    public void setEnabled(boolean bl) {
        this.PackageDriver.putField("selected", this.Record, (Object)new Boolean(bl));
    }

    public boolean getAutoUpdate() {
        return (Boolean)this.PackageDriver.getField("AutoUpdate", this.Record);
    }

    public String getLocalLocation() {
        return TMainWin.Application.parse_tokens((String)this.PackageDriver.getField("location", this.Record));
    }

    public void setLocalLocation(String string) {
        this.PackageDriver.putField("location", this.Record, (Object)string);
    }

    public String getSourceLocation() {
        return TMainWin.Application.parse_tokens((String)this.PackageDriver.getField("source", this.Record));
    }

    public void setSourceLocation(String string) {
        this.PackageDriver.putField("source", this.Record, (Object)string);
    }

    public String getNotes() {
        return TMainWin.Application.parse_tokens((String)this.PackageDriver.getField("notes", this.Record));
    }

    public void setNotes(String string) {
        this.PackageDriver.putField("notes", this.Record, (Object)string);
    }

    public String getNavigatorDriverID() {
        return TMainWin.Application.parse_tokens((String)this.PackageDriver.getField("NavigatorDriverID", this.Record));
    }

    public void setNavigatorDriverID(String string) {
        this.PackageDriver.putField("NavigatorDriverID", this.Record, (Object)string);
    }

    public int updatePackage(StringBuilder stringBuilder, boolean bl) {
        int n;
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        URL uRL = null;
        URLConnection uRLConnection = null;
        TFile tFile = null;
        Object var8_8 = null;
        String string = "";
        String string2 = "";
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n2 = 0;
        boolean bl2 = false;
        stringBuilder.setLength(0);
        if (!this.getAutoUpdate() && !bl) {
            stringBuilder.append("auto-update disabled");
            return 0;
        }
        String string3 = this.getPackageName();
        String string4 = this.getSourceLocation();
        String string5 = this.getLocalLocation();
        tFile = new TFile(string5);
        if (tFile.isDirectory()) {
            stringBuilder.append("Local package");
            return 1;
        }
        tFile.validatePathToFile(true);
        l3 = tFile.getLastModified();
        l4 = tFile.getContentLength();
        if (this.MainWin.isRunningOnServer()) {
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package [" + string3 + "] running on server.  Already updated");
            long l5 = new Date().getTime() - l3;
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package [" + string3 + "] tDiff=" + Long.toString(l5));
            if (l5 < 3600000L) {
                this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package [" + string3 + "] Returning UPDATED");
                return 3;
            }
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package [" + string3 + "] Returning UP_TO_DATE");
            return 2;
        }
        String string6 = charutil.replaceAllSubstrings(string4, ".zip", ".mod");
        this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package [" + string3 + "] Filename=" + string6);
        String string7 = TAsciiInput.getContent(string6);
        if (string7.trim().length() > 0 && (object3 = charutil.getSubStringArray(string7, '|', true)) != null && ((String[])object3).length > 1) {
            long l6 = charutil.lval((String)object3[0]);
            if (l6 > 0L) {
                int n3 = charutil.ival((String)object3[1]);
                if (n3 > 0) {
                    this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package time [" + string3 + "]: " + dateutil.formatDate(new Date(l6), "MM-dd-yyyy HH:mm:ss:SSS") + " Local package: " + dateutil.formatDate(new Date(l3), "MM-dd-yyyy HH:mm:ss:SSS"));
                    this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package size [" + string3 + "]: " + n3 + " Local size: " + l4);
                    if (l6 < l3 + 60000L && (long)n3 == l4) {
                        this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package [" + string3 + "] is up to date");
                        return 2;
                    }
                    this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package [" + string3 + "] is not up to date");
                } else {
                    this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 4, "Package size is not a number.");
                }
            } else {
                this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 4, "Package time modified is not a number.");
            }
        }
        if (((String)(object3 = TMainWin.Application.getTokenValue("AspectServerIP1a").trim())).length() == 0) {
            object3 = "192.169.215.186";
        }
        String string8 = dosutil.addTrailingSlash(TMainWin.Application.getHomeDir()) + "temporary_files/" + TPasswordService.generateSalt(8) + ".$$$";
        String string9 = "http://" + (String)object3 + "/Aspect7/packages/" + this.getPackageID() + ".zip";
        TAsciiInput tAsciiInput = new TAsciiInput(string9, '\u0000');
        if (!tAsciiInput.isValid()) {
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Unable to load package[1] [" + string3 + "] from " + (String)object3 + " using http.  Trying https.");
            tAsciiInput.dispose();
            string9 = "https://" + (String)object3 + "/Aspect7/packages/" + this.getPackageID() + ".zip";
            tAsciiInput = new TAsciiInput(string9, '\u0000');
        }
        if (tAsciiInput.isValid()) {
            object2 = tAsciiInput.get_entire_file();
            serializable = new TFile(string8);
            try {
                ((TFile)serializable).validatePathToFile(true);
                if (((File)serializable).exists()) {
                    ((File)serializable).delete();
                }
                object = new RandomAccessFile(string8, "rwd");
                ((RandomAccessFile)object).write((byte[])object2);
                ((RandomAccessFile)object).close();
                n = ziputil.verifyArchive(string8);
                if (n != 0) {
                    dosutil.copyFile(string8, string5, 0, false, "", "", "");
                    ((File)serializable).delete();
                    this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package [" + string3 + "] updated from " + (String)object3);
                    tAsciiInput.dispose();
                    return 3;
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        } else {
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package[1] [" + string3 + "] is not available from server");
        }
        tAsciiInput.dispose();
        try {
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Attempting to load package [" + string3 + "] from " + string4);
            uRL = new URL(dosutil.formatURL(string4));
            uRLConnection = uRL.openConnection();
        }
        catch (Exception exception) {
            string2 = "Error opening source package";
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), exception, 4, string2 + ": " + string4);
            stringBuilder.append(string2);
            n2 = 4;
            bl2 = true;
        }
        if (!bl2) {
            l = uRLConnection.getLastModified();
            l2 = uRLConnection.getContentLength();
            if (l2 <= 0L) {
                stringBuilder.append("Not Available");
                this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package is not available: " + this.getPackageName());
                return 2;
            }
            if (l2 == l4 && l3 >= l && l != 0L && l3 != 0L) {
                stringBuilder.append("Up to date");
                return 2;
            }
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Updating " + this.getPackageName() + "...");
            string7 = "tmSource=" + dateutil.formatDate(new Date(l), "MM-dd-yyyy HH:mm:ss:SSS") + " tmLocal=" + dateutil.formatDate(new Date(l3), "MM-dd-yyyy HH:mm:ss:SSS");
            string7 = "szSource=" + l2 + " szLocal=" + l4;
            try {
                bufferedInputStream = new BufferedInputStream(uRL.openStream());
            }
            catch (Exception exception) {
                string2 = "Error opening source package";
                this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), exception, 4, string2 + ": " + uRL.toString());
                stringBuilder.append(string2 + " " + exception.toString());
                n2 = 4;
                bl2 = true;
            }
        }
        object2 = new File(string8);
        if (!bl2) {
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object2));
            }
            catch (Exception exception) {
                string2 = "Error opening local package";
                this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), exception, 4, string2 + ": " + tFile.toString());
                stringBuilder.append(string2 + " " + exception.toString());
                n2 = 5;
                bl2 = true;
            }
        }
        if (!bl2) {
            serializable = NumberFormat.getInstance();
            object = "Updating " + this.getPackageName();
            n = 0;
            long l7 = 0L;
            int n4 = 0;
            int n5 = 0;
            byte[] byArray = new byte[4096];
            try {
                do {
                    if ((n = bufferedInputStream.read(byArray, 0, byArray.length)) > 0) {
                        l7 += (long)n;
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    if (l2 <= 0L || (n5 = (int)Math.floor((double)((int)l7) / (double)l2 * 100.0) + 1) <= n4) continue;
                    this.MainWin.appendToConsole((String)object + " (" + ((NumberFormat)serializable).format(n5) + "%)");
                    n4 = n5;
                } while (n >= 0);
                n2 = 3;
                stringBuilder.append("updated");
            }
            catch (Exception exception) {
                string2 = "Error while updating package";
                this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), exception, 4, string2 + ": " + tFile.toString());
                stringBuilder.append(string2 + " " + exception.toString());
                n2 = 6;
                bl2 = true;
            }
        }
        try {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl2) {
            if (((File)object2).exists()) {
                boolean bl3 = TPackage.verifyPackage(string8);
                if (bl3) {
                    dosutil.copyFile(string8, string5, 0, false, "", "", "");
                    ((File)object2).delete();
                } else {
                    string2 = " Package download was corrupt or blocked";
                    this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 4, string2 + ": " + tFile.toString());
                    stringBuilder.append(string2);
                    n2 = 6;
                    bl2 = true;
                }
            } else {
                string2 = "Cannot locate package download: " + string8;
                this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 4, string2 + ": " + tFile.toString());
                stringBuilder.append(string2);
                n2 = 6;
                bl2 = true;
            }
        }
        return n2;
    }

    public boolean verifyPackage() {
        String string = this.getLocalLocation();
        return TPackage.verifyPackage(string);
    }

    public static boolean verifyPackage(String string) {
        String string2 = string;
        TFile tFile = new TFile(string2);
        if (!tFile.exists()) {
            Aspect.MainWin.appendToLog("TMainWin", "verifyPackage", Thread.currentThread(), null, 3, "Verify package: " + string + " does not exist");
            return false;
        }
        if (tFile.isDirectory()) {
            Aspect.MainWin.appendToLog("TMainWin", "verifyPackage", Thread.currentThread(), null, 3, "Verify package: " + string + " is a directory.  Ok");
            return true;
        }
        boolean bl = ziputil.verifyArchive(string2);
        if (bl) {
            Aspect.MainWin.appendToLog("TMainWin", "verifyPackage", Thread.currentThread(), null, 3, "Verify package: " + string + " Ok");
            return true;
        }
        Aspect.MainWin.appendToLog("TMainWin", "verifyPackage", Thread.currentThread(), null, 4, "Verify package: " + string + " Not valid");
        return false;
    }

    public boolean downloadFromServer() {
        String string;
        TAsciiInput tAsciiInput;
        String string2 = this.getLocalLocation();
        TFile tFile = new TFile(string2);
        if (tFile.isDirectory()) {
            this.MainWin.appendToLog("TMainWin", "downloadFromServer", Thread.currentThread(), null, 3, "Update package from server: " + this.getPackageID() + " is a directory");
            return true;
        }
        String string3 = dosutil.addTrailingSlash(TMainWin.Application.getHomeDir()) + "temporary_files/" + TPasswordService.generateSalt(8) + ".$$$";
        String string4 = TMainWin.Application.getTokenValue("AspectServerIP1a").trim();
        if (string4.length() == 0) {
            string4 = "192.169.215.186";
        }
        if (!(tAsciiInput = new TAsciiInput(string = "http://" + string4 + "/Aspect7/packages/" + this.getPackageID() + ".zip", '\u0000')).isValid()) {
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Unable to load package[2] [" + this.getPackageID() + "] using http.  Trying https.");
            tAsciiInput.dispose();
            string = "https://" + string4 + "/Aspect7/packages/" + this.getPackageID() + ".zip";
            tAsciiInput = new TAsciiInput(string, '\u0000');
        }
        if (tAsciiInput.isValid()) {
            byte[] byArray = tAsciiInput.get_entire_file();
            TFile tFile2 = new TFile(string3);
            try {
                tFile2.validatePathToFile(true);
                if (tFile2.exists()) {
                    tFile2.delete();
                }
                RandomAccessFile randomAccessFile = new RandomAccessFile(string3, "rwd");
                randomAccessFile.write(byArray);
                randomAccessFile.close();
                boolean bl = TPackage.verifyPackage(string3);
                if (bl) {
                    dosutil.copyFile(string3, string2, 0, false, "", "", "");
                    tFile2.delete();
                    this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package [" + this.getPackageID() + "] updated from server2");
                    tAsciiInput.dispose();
                    return true;
                }
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), exception, 4, "Error updating package [" + this.getPackageID() + "] from server");
            }
        } else {
            this.MainWin.appendToLog("TMainWin", "updatePackage", Thread.currentThread(), null, 3, "Package[2] [" + this.getPackageID() + "] is not available from server");
        }
        tAsciiInput.dispose();
        return false;
    }
}

