/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.objectutil;

public class TPivotTableDriver
extends TAbstractDriver {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = false;
    TAspectDriver AspectDriver = null;
    TDriverInterface drvEmbed = null;
    String[] arPivotFields = null;
    String[] arOtherFields = null;
    String[] arNameFields = null;

    public TPivotTableDriver(TDriverInterface tDriverInterface, String[] stringArray) {
        this.Application = TMainWin.Application;
        this.drvEmbed = tDriverInterface;
        this.arNameFields = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.arNameFields[i] = stringArray[i];
        }
        this.FileName = this.drvEmbed.getFileName();
        this.DriverStruct = new TDriverStruct(TMainWin.Application, "PivotTable");
        this.RecordSize = this.DriverStruct.RecordSize;
        this.AppDriversObject = this.drvEmbed.getAppDriversObject();
        this.FormulaEvaluator = new TFormulaEvaluator(this.Application, this.DriverStruct, this);
        this.FormulaEvaluator.setAltFormulaEvaluator(this.drvEmbed.getFormulaEvaluator());
        this.makeEditableFile();
    }

    public TPivotTableDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        String[] stringArray;
        String string;
        if (this.Debug) {
            System.out.println("Opening pivot table driver. Params=AppDriversObject.DriverParams");
        }
        if ((string = charutil.getParamValue(stringArray = charutil.getSubStringArray(this.AppDriversObject.DriverParams, '|', true), "DriverID")).trim().length() > 0) {
            this.AspectDriver = new TAspectDriver(string, 1, true, true, this.AppDriversObject.DriverParams.toString());
            if (!this.AspectDriver.isValid()) {
                MainWin.appendToLog("TPivotTableDriver", "init", Thread.currentThread(), null, 3, "Error opening driver: " + string);
                this.AspectDriver.dispose();
                this.AspectDriver = null;
            }
        } else {
            string = charutil.getParamValue(stringArray, "SystemDriver");
            if (string.trim().length() > 0) {
                this.AspectDriver = TFormulaEvaluator.getSystemDriver(string);
                if (this.AspectDriver == null) {
                    MainWin.appendToLog("TPivotTableDriver", "init", Thread.currentThread(), null, 3, "Invalid SystemDriver: " + string);
                }
            } else {
                MainWin.appendToLog("TPivotTableDriver", "init", Thread.currentThread(), null, 3, "No source (DriverID or SystemDriver) defined");
            }
        }
        if (this.AspectDriver != null) {
            this.drvEmbed = this.AspectDriver.F;
            String string2 = charutil.getParamValue(this.AppDriversObject.DriverParams.toString(), "Pivot", '|');
            if (string2.trim().length() == 0) {
                MainWin.appendToLog("TPivotTableDriver", "makeEditableFile", Thread.currentThread(), null, 3, "No pivot fields specified in pivot table");
            }
            this.arPivotFields = charutil.getSubStringArray(string2, '^', true);
            if (("|" + this.AppDriversObject.DriverParams.toString()).toUpperCase().indexOf("|OTHER=") >= 0) {
                string2 = charutil.getParamValue(this.AppDriversObject.DriverParams.toString(), "Other", '|');
                this.arOtherFields = charutil.getSubStringArray(string2, '^', true);
            }
            string2 = charutil.getParamValue(this.AppDriversObject.DriverParams.toString(), "Fields", '|');
            this.arNameFields = charutil.getSubStringArray(string2, '^', true);
        }
    }

    @Override
    public void dispose() {
        if (this.AspectDriver != null) {
            this.AspectDriver.dispose();
        } else if (this.drvEmbed != null) {
            this.drvEmbed.dispose();
        }
        super.dispose();
    }

    public String makeAlphaNumeric(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && c != ' ') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Override
    public int makeEditableFile() {
        Object object;
        TDriverStructRecord tDriverStructRecord;
        int n;
        if (this.drvEmbed == null) {
            return 0;
        }
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.arPivotFields != null) {
            for (n = 0; n < this.arPivotFields.length; ++n) {
                TDriverStructRecord tDriverStructRecord2 = this.drvEmbed.getDriverStruct().getField(this.arPivotFields[n]);
                if (tDriverStructRecord2 != null) {
                    if (arrayList.contains(tDriverStructRecord2.FullID.toUpperCase())) continue;
                    tDriverStructRecord = new TDriverStructRecord(tDriverStructRecord2);
                    tDriverStructRecord.IsRootNode = true;
                    tDriverStructRecord.IsPivotField = true;
                    tDriverStructRecord.PivotTableValueField = tDriverStructRecord2.ID;
                    tDriverStructRecord.IsCalculated = false;
                    tDriverStructRecord.IsVirtual = false;
                    tDriverStructRecord.Offset = n4;
                    tDriverStructRecord.AbsoluteIndex = n2++;
                    tDriverStructRecord.PhysicalIndex = n3++;
                    n4 += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
                    if (!tDriverStructRecord.IsVirtual) {
                        // empty if block
                    }
                    this.DriverStruct.FieldColl.add(tDriverStructRecord);
                    this.DriverStruct.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                    object = new StringBuilder();
                    ((StringBuilder)object).setLength(0);
                    ((StringBuilder)object).append(tDriverStructRecord.Description.toUpperCase());
                    charutil.replace_char((StringBuilder)object, (StringBuilder)object, '\\', ' ');
                    this.DriverStruct.HashDescriptions.put(((StringBuilder)object).toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                    arrayList.add(tDriverStructRecord2.FullID.toUpperCase());
                    continue;
                }
                MainWin.appendToLog("TPivotTableDriver", "makeEditableFile", Thread.currentThread(), null, 3, "Invalid pivot field1: " + this.arPivotFields[n]);
            }
        }
        if (this.arOtherFields == null) {
            String string = "";
            for (int i = 0; i < this.drvEmbed.getDriverStruct().FieldColl.size(); ++i) {
                tDriverStructRecord = (TDriverStructRecord)this.drvEmbed.getDriverStruct().FieldColl.get(i);
                if (i > 0) {
                    string = string + "^";
                }
                string = string + tDriverStructRecord.FullID;
            }
            this.arOtherFields = charutil.getSubStringArray(string, '^', true);
        }
        if (this.arOtherFields != null) {
            for (n = 0; n < this.arOtherFields.length; ++n) {
                TDriverStructRecord tDriverStructRecord3 = this.drvEmbed.getDriverStruct().getField(this.arOtherFields[n]);
                if (tDriverStructRecord3 != null) {
                    if (arrayList.contains(tDriverStructRecord3.FullID.toUpperCase())) continue;
                    tDriverStructRecord = new TDriverStructRecord(tDriverStructRecord3);
                    tDriverStructRecord.IsRootNode = true;
                    tDriverStructRecord.IsPivotOtherField = true;
                    tDriverStructRecord.PivotTableValueField = tDriverStructRecord3.ID;
                    tDriverStructRecord.IsCalculated = false;
                    tDriverStructRecord.IsVirtual = false;
                    tDriverStructRecord.Offset = n4;
                    tDriverStructRecord.AbsoluteIndex = n2++;
                    tDriverStructRecord.PhysicalIndex = n3++;
                    n4 += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
                    if (!tDriverStructRecord.IsVirtual) {
                        // empty if block
                    }
                    this.DriverStruct.FieldColl.add(tDriverStructRecord);
                    this.DriverStruct.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                    object = new StringBuilder();
                    ((StringBuilder)object).setLength(0);
                    ((StringBuilder)object).append(tDriverStructRecord.Description.toUpperCase());
                    charutil.replace_char((StringBuilder)object, (StringBuilder)object, '\\', ' ');
                    this.DriverStruct.HashDescriptions.put(((StringBuilder)object).toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                    arrayList.add(tDriverStructRecord3.FullID.toUpperCase());
                    continue;
                }
                MainWin.appendToLog("TPivotTableDriver", "makeEditableFile", Thread.currentThread(), null, 3, "Invalid pivot field2: " + this.arOtherFields[n]);
            }
        }
        for (n = 0; n < this.arNameFields.length; ++n) {
            String[] stringArray = charutil.getSubStringArray(this.arNameFields[n], '$', true);
            if (stringArray != null && stringArray.length == 2) {
                Object object2;
                tDriverStructRecord = this.drvEmbed.getDriverStruct().getField(stringArray[0]);
                object = this.drvEmbed.getDriverStruct().getField(stringArray[1]);
                if (tDriverStructRecord == null) {
                    MainWin.appendToLog("TPivotTableDriver", "makeEditableFile", Thread.currentThread(), null, 3, "Invalid pivot table name field: " + stringArray[0]);
                }
                if (object == null) {
                    MainWin.appendToLog("TPivotTableDriver", "makeEditableFile", Thread.currentThread(), null, 3, "Invalid pivot table name field: " + stringArray[1]);
                }
                if (tDriverStructRecord == null || object == null) continue;
                String string = "";
                Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
                int n5 = this.drvEmbed.getRecordCount();
                for (int i = 0; i < n5; ++i) {
                    object2 = this.drvEmbed.getField(tDriverStructRecord, i);
                    if (object2 == null || hashtable.containsKey(object2)) continue;
                    hashtable.put(object2, "");
                }
                if (hashtable.size() >= 0) {
                    CharSequence charSequence;
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        charSequence = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object2);
                        if (tDriverStructRecord.FormatPattern.trim().length() > 0) {
                            charSequence = objectutil.applyPattern(object2, tDriverStructRecord.FormatPattern);
                        }
                        TDriverStructRecord tDriverStructRecord4 = new TDriverStructRecord((TDriverStructRecord)object);
                        tDriverStructRecord4.Description = ((TDriverStructRecord)object).Description + ": " + (String)charSequence;
                        tDriverStructRecord4.IsPivotNameField = true;
                        tDriverStructRecord4.FullID = tDriverStructRecord4.ID = ((TDriverStructRecord)object).ID + "_" + this.makeAlphaNumeric(charutil.replaceChar((String)charSequence, ' ', '_'));
                        tDriverStructRecord4.SuppressZeros = ((TDriverStructRecord)object).SuppressZeros;
                        tDriverStructRecord4.FormatPattern = ((TDriverStructRecord)object).FormatPattern;
                        tDriverStructRecord4.CalcSubtotal = ((TDriverStructRecord)object).CalcSubtotal;
                        tDriverStructRecord4.IsCalculated = false;
                        tDriverStructRecord4.IsVirtual = false;
                        tDriverStructRecord4.PivotTableValueField = ((TDriverStructRecord)object).ID;
                        tDriverStructRecord4.PivotTableNameField = tDriverStructRecord.ID;
                        tDriverStructRecord4.PivotTableName = charSequence;
                        tDriverStructRecord4.Offset = n4;
                        tDriverStructRecord4.AbsoluteIndex = n2++;
                        tDriverStructRecord4.PhysicalIndex = n3++;
                        n4 += tDriverStructRecord4.DataSize * tDriverStructRecord4.ArraySize;
                        if (!tDriverStructRecord4.IsVirtual) {
                            // empty if block
                        }
                        this.DriverStruct.FieldColl.add(tDriverStructRecord4);
                        this.DriverStruct.HashFields.put(tDriverStructRecord4.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.setLength(0);
                        stringBuilder.append(tDriverStructRecord4.Description.toUpperCase());
                        charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
                        this.DriverStruct.HashDescriptions.put(stringBuilder.toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                        if (!objectutil.isNumberField(tDriverStructRecord4.FieldType)) continue;
                        string = string + "+" + tDriverStructRecord4.ID;
                    }
                    if (string.length() <= 0) continue;
                    object2 = new TDriverStructRecord((TDriverStructRecord)object);
                    ((TDriverStructRecord)object2).FullID = ((TDriverStructRecord)object2).ID = "Total_" + tDriverStructRecord.ID + "_" + ((TDriverStructRecord)object).ID;
                    ((TDriverStructRecord)object2).Description = ((TDriverStructRecord)object).Description + ": Total";
                    ((TDriverStructRecord)object2).IsCalculated = true;
                    ((TDriverStructRecord)object2).IsVirtual = true;
                    ((TDriverStructRecord)object2).Formula = string;
                    ((TDriverStructRecord)object2).IsPivotTotal = true;
                    ((TDriverStructRecord)object2).Offset = n4;
                    ((TDriverStructRecord)object2).AbsoluteIndex = n2++;
                    ((TDriverStructRecord)object2).PhysicalIndex = n3++;
                    n4 += ((TDriverStructRecord)object2).DataSize * ((TDriverStructRecord)object2).ArraySize;
                    if (!((TDriverStructRecord)object2).IsVirtual) {
                        // empty if block
                    }
                    this.DriverStruct.FieldColl.add(object2);
                    this.DriverStruct.HashFields.put(((TDriverStructRecord)object2).FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).setLength(0);
                    ((StringBuilder)charSequence).append(((TDriverStructRecord)object2).Description.toUpperCase());
                    charutil.replace_char((StringBuilder)charSequence, (StringBuilder)charSequence, '\\', ' ');
                    this.DriverStruct.HashDescriptions.put(((StringBuilder)charSequence).toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                    continue;
                }
                MainWin.appendToLog("TPivotTableDriver", "makeEditableFile", Thread.currentThread(), null, 3, "No values for field: " + tDriverStructRecord.ID);
                continue;
            }
            MainWin.appendToLog("TPivotTableDriver", "makeEditableFile", Thread.currentThread(), null, 3, "Invalid field pair: " + this.arNameFields[n]);
        }
        if (this.Application.ExecutionMode == 0) {
            String string = this.Application.getTemporaryFiles() + this.AppDriversObject.DriverID + "_pivot.csv";
            System.out.println("Writing pivot table driver struct to " + string);
            this.DriverStruct.write_to_file(string);
        }
        return 1;
    }

    @Override
    public TAspectDriver getAspectDriver() {
        return this.drvEmbed.getAspectDriver();
    }

    @Override
    public TFormulaEvaluator getFormulaEvaluator() {
        return this.FormulaEvaluator;
    }

    @Override
    public void setFormulaEvaluator(TFormulaEvaluator tFormulaEvaluator) {
        this.drvEmbed.setFormulaEvaluator(tFormulaEvaluator);
    }

    @Override
    public void clearBuffer() {
        this.drvEmbed.clearBuffer();
    }

    @Override
    public void clearWriteBuffer() {
        this.drvEmbed.clearWriteBuffer();
    }

    @Override
    public int getRecordCount() {
        if (this.drvEmbed == null) {
            return 0;
        }
        return this.drvEmbed.getRecordCount();
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (this.drvEmbed == null) {
            return null;
        }
        Object object = null;
        if (tDriverStructRecord.IsToken) {
            String string = TMainWin.Application.getTokenValue(tDriverStructRecord.ID);
            object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string, 0);
            return object;
        }
        if (!tDriverStructRecord.IsVirtual && !tDriverStructRecord.IsCalculated) {
            if (tDriverStructRecord.PivotTableNameField.length() > 0) {
                TDriverStructRecord tDriverStructRecord2 = this.drvEmbed.getDriverStruct().getField(tDriverStructRecord.PivotTableNameField);
                TDriverStructRecord tDriverStructRecord3 = this.drvEmbed.getDriverStruct().getField(tDriverStructRecord.PivotTableValueField);
                Object object2 = this.drvEmbed.getField(tDriverStructRecord2, n);
                String string = objectutil.convertFieldTypeToString(tDriverStructRecord2.FieldType, object2);
                if (tDriverStructRecord2.FormatPattern.trim().length() > 0) {
                    string = objectutil.applyPattern(object2, tDriverStructRecord2.FormatPattern);
                }
                if (string.equalsIgnoreCase(tDriverStructRecord.PivotTableName)) {
                    return this.drvEmbed.getField(tDriverStructRecord3, n);
                }
                return objectutil.convertStringToFieldType(tDriverStructRecord3.FieldType, "", n);
            }
            TDriverStructRecord tDriverStructRecord4 = this.drvEmbed.getDriverStruct().getField(tDriverStructRecord.PivotTableValueField);
            return this.drvEmbed.getField(tDriverStructRecord4, n);
        }
        if (tDriverStructRecord.IsCalculated) {
            object = this.calculateField(tDriverStructRecord, n);
        }
        return object;
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        if (this.drvEmbed == null) {
            return 0;
        }
        if (tDriverStructRecord.IsVirtual || !tDriverStructRecord.IsCalculated) {
            return 1;
        }
        TDriverStructRecord tDriverStructRecord2 = this.drvEmbed.getDriverStruct().getField(tDriverStructRecord.PivotTableValueField);
        return this.drvEmbed.putField(tDriverStructRecord2, n, object);
    }
}

