/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.files.TBinaryBuffer;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import resources.TAppDisplaysObject;
import resources.TAppDriversObject;
import resources.TApplication;
import scrollwin.table.TScrollTable;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dosutil;
import utility.http.THttpRequest;
import utility.http.THttpResponse;
import utility.objectutil;
import utility.sockets.TSSLSocketWrapper;

public class TSocketDriver
extends TAbstractDriver {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTSocketDriver");
    public static final String[] ERRORMSG = new String[]{"Error sending driverID", "Error parsing filename", "Error requesting record count", "Error requesting driver structure", "Error sending field list", "Error receiving field list", "Error completing handshake", "Unrecognized request", "Invalid Driver ID", "Error receiving dialog resource", "Error receiving table resource", "Error receiving displays resource"};
    TSSLSocketWrapper socket = null;
    ArrayList arFieldID = new ArrayList();
    TDriverStructRecord[] arDriverStructRecord;
    TSocketManager SocketManager = null;
    TBinaryBuffer FBuffer;
    File BufferFile;
    String ServerName;
    String RemoteDriverID = null;
    int ConnectionPort;
    int RecordCount = 0;
    int ErrorNo = 0;
    boolean Disconnected = false;
    boolean IsValid = false;
    boolean PrimeFields = true;
    boolean UseRemoteResources = false;
    Hashtable hashReceivedColl = new Hashtable();

    public TSocketDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        Object object;
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "init", Thread.currentThread(), null, 10, "TSocketDriver init Filename=" + this.AppDriversObject.FileName + " Params=" + this.AppDriversObject.DriverParams);
        }
        if (tAppDriversObject.FileName.indexOf(":", 0) > 0) {
            object = charutil.getSubStringArray(tAppDriversObject.FileName, ':', true);
            this.ServerName = object[0];
            this.ConnectionPort = charutil.ival(object[1]);
            this.RemoteDriverID = ((String[])object).length > 2 ? object[2] : tAppDriversObject.RemoteDriverID;
        } else {
            this.ServerName = tAppDriversObject.FileName.toString();
            this.ConnectionPort = tAppDriversObject.ConnectionPort;
            this.RemoteDriverID = tAppDriversObject.RemoteDriverID;
        }
        object = null;
        if (TMainWin.DriverServer != null) {
            object = TMainWin.DriverServer.getRegistrantFromNameServer(this.ServerName);
        }
        if (object != null) {
            if (this.Debug) {
                MainWin.appendToLog("TSocketDriver", "makeEditableFile", Thread.currentThread(), null, 9, "Client: Opening socket: " + object.IPAddress + ", " + object.ConnectionPort);
            }
            this.socket = new TSSLSocketWrapper(this.Application, object.IPAddress, object.ConnectionPort);
        } else {
            if (this.Debug) {
                MainWin.appendToLog("TSocketDriver", "makeEditableFile", Thread.currentThread(), null, 9, "Client: Opening socket: " + this.ServerName + ", " + this.ConnectionPort);
            }
            this.socket = new TSSLSocketWrapper(this.Application, this.ServerName, this.ConnectionPort);
            THttpRequest tHttpRequest = new THttpRequest(this.socket.getSocket());
            tHttpRequest.setMethod(1);
            tHttpRequest.setURI("/");
            tHttpRequest.setArguments("Network=GreenLight&ID=getView&Package_Name=GreenLight&View=Service+Remote+Driver");
            tHttpRequest.send();
            THttpResponse tHttpResponse = new THttpResponse(this.socket.getSocket());
            tHttpResponse.receive();
        }
    }

    public TSocketDriver(int n, Socket socket, TAppDriversObject tAppDriversObject, String string) {
        super(TMainWin.Application, tAppDriversObject, n, false);
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "init", Thread.currentThread(), null, 3, "Initializing socket driver from existing socket");
        }
        this.socket = new TSSLSocketWrapper(TMainWin.Application, socket);
        this.RemoteDriverID = string;
        System.out.println("TSocketDriver AppDriversObject.DriverID=" + this.AppDriversObject.DriverID);
        if (this.AppDriversObject.DriverID.toString().trim().length() == 0 || this.AppDriversObject.DriverID.toString().equalsIgnoreCase("Aspect_Common_Mashup")) {
            this.UseRemoteResources = true;
        }
        System.out.println("TSocketDriver UseRemoteResources=" + this.UseRemoteResources);
    }

    @Override
    public void dispose() {
        if (this.Debug) {
            System.out.println("\t\t\t\tTSocketDriver: sending disconnect command");
        }
        this.socket.writeCommand(8, true);
        if (this.Debug) {
            System.out.println("\t\t\t\tTSocketDriver: closing socket");
        }
        this.socket.dispose();
        if (this.Debug) {
            System.out.println("\t\t\t\tTSocketDriver: disposing temp file");
        }
        this.FBuffer.dispose();
        this.BufferFile.delete();
    }

    @Override
    public int getRecordCount() {
        return this.RecordCount;
    }

    @Override
    public int makeEditableFile() throws IOException {
        boolean bl = false;
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "makeEditableFile", Thread.currentThread(), null, 3, "Client: Handshaking with server");
        }
        this.ErrorNo = this.handshakeSendDriverID();
        if (this.ErrorNo == 0) {
            this.ErrorNo = this.handshakeParseFilename();
        }
        if (this.ErrorNo == 0) {
            this.ErrorNo = this.handshakeGetRecordCount();
        }
        if (this.ErrorNo == 0) {
            this.ErrorNo = this.handshakeGetDriverStruct();
        }
        if (this.ErrorNo == 0) {
            this.ErrorNo = this.handshakeCoordinateFieldList();
        }
        if (this.ErrorNo == 0) {
            this.ErrorNo = this.handshakeGetTableResource();
        }
        if (this.ErrorNo == 0) {
            this.ErrorNo = this.handshakeGetDialogResource();
        }
        if (this.ErrorNo == 0) {
            this.ErrorNo = this.handshakeGetDisplayResources();
        }
        if (this.ErrorNo == 0) {
            this.ErrorNo = this.handshakeComplete();
        }
        if (this.ErrorNo == 0) {
            this.IsValid = true;
        } else {
            MainWin.appendToLog("TSocketDriver", "makeEditableFile", Thread.currentThread(), null, 9, "Socket Driver Handshake Failed.  Error: " + ERRORMSG[this.ErrorNo]);
        }
        this.BufferFile = dosutil.createTempFile("tmp");
        try {
            TAppDriversObject tAppDriversObject = new TAppDriversObject(this.BufferFile.getPath(), this.AppDriversObject.StructureIndex.toString());
            this.FBuffer = new TBinaryBuffer(this.Application, tAppDriversObject, 1, false);
            this.FBuffer.setDriverStruct(this.DriverStruct);
            this.FBuffer.makeEditableFile();
        }
        catch (Exception exception) {
            MainWin.appendToLog("TSocketDriver", "makeEditableFile", Thread.currentThread(), exception, 9, "Error opening buffer for socket.");
        }
        this.IsWriteable = true;
        this.SocketManager = new TSocketManager();
        this.SocketManager.start();
        return 0;
    }

    private int handshakeSendDriverID() {
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeSendDriverID", Thread.currentThread(), null, 3, "Client: Sending Driver ID: " + this.RemoteDriverID);
        }
        this.socket.writeCommand(1, false);
        this.socket.writeString(this.RemoteDriverID, true);
        int n = this.socket.readCommand();
        if (n == 1) {
            String string = this.socket.readString();
            if (this.UseRemoteResources) {
                if (this.AppDriversObject.DriverID.toString().equalsIgnoreCase("Aspect_Common_Mashup")) {
                    this.AppDriversObject = new TAppDriversObject(this.AppDriversObject);
                    this.AppDriversObject.DriverID.setLength(0);
                    this.AppDriversObject.DriverID.append(charutil.getParamValue(this.AppDriversObject.DriverParams, "Mashup", '|'));
                    this.AppDriversObject.UnparsedID = this.AppDriversObject.DriverID.toString();
                } else {
                    this.AppDriversObject = this.Application.AppDrivers.addResourceElement("TSocketDriver", string);
                }
                this.AppDriversObject.StructureIndex.setLength(0);
                this.AppDriversObject.DialogIDStart.setLength(0);
                this.AppDriversObject.TableID.setLength(0);
            }
            return 0;
        }
        if (n == 9) {
            MainWin.appendToLog("TSocketDriver", "handshakeSendDriverID", Thread.currentThread(), null, 4, "Client: The server does not have a driver with the ID " + this.RemoteDriverID);
            return 9;
        }
        return 1;
    }

    private int handshakeParseFilename() {
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeParseFilename", Thread.currentThread(), null, 3, "Client: Parsing Filename");
        }
        this.socket.writeCommand(2, true);
        int n = this.socket.readCommand();
        if (n != 2) {
            return 2;
        }
        String string = this.socket.readString();
        string = this.Application.preserveUserTokens(string);
        string = this.Application.parse_tokens(string);
        string = charutil.replaceAllSubstrings(string, "@_", "{");
        this.socket.writeString(string, false);
        this.socket.writeString(this.AppDriversObject.DriverParams, true);
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeParseFilename", Thread.currentThread(), null, 3, "Client: Parsed Filename = " + string);
        }
        if ((n = this.socket.readCommand()) == 2) {
            return 0;
        }
        return 2;
    }

    private int handshakeGetRecordCount() {
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeGetRecordCount", Thread.currentThread(), null, 3, "Client: Requesting Record Count");
        }
        this.socket.writeCommand(4, true);
        int n = this.socket.readCommand();
        if (n != 4) {
            return 3;
        }
        this.RecordCount = this.socket.readInt();
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeGetRecordCount", Thread.currentThread(), null, 3, "Client: Record Count = " + Integer.toString(this.RecordCount));
        }
        return 0;
    }

    private int handshakeGetDriverStruct() {
        if (this.AppDriversObject.StructureIndex.toString().trim().length() > 0) {
            return 0;
        }
        String string = this.socket.getIPAddress() + "_" + this.RemoteDriverID;
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeGetDriverStruct", Thread.currentThread(), null, 3, "Client: Requesting Driver Structure");
        }
        this.socket.writeCommand(5, true);
        int n = this.socket.readCommand();
        if (n != 5) {
            return 4;
        }
        int n2 = this.socket.readInt();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = this.socket.readString();
        }
        TDriverStruct tDriverStruct = new TDriverStruct(this.Application, string);
        tDriverStruct.addFields(stringArray);
        this.setDriverStruct(tDriverStruct);
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeGetDriverStruct", Thread.currentThread(), null, 3, "Client: Driver Structure Contains " + n2 + " records");
        }
        return 0;
    }

    private int handshakeCoordinateFieldList() {
        TDriverStructRecord tDriverStructRecord;
        int n;
        int n2;
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeCoordinateFieldList", Thread.currentThread(), null, 3, "Client: Coordinating driver structure");
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.DriverStruct.FieldColl.size(); ++n2) {
            TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n2);
            if (tDriverStructRecord2.IsVirtual) continue;
            ++n3;
        }
        this.socket.writeCommand(6, true);
        n2 = this.socket.readCommand();
        if (n2 != 6) {
            return 5;
        }
        this.socket.writeInt(n3, false);
        for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
            tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
            if (tDriverStructRecord.IsVirtual) continue;
            this.socket.writeString(tDriverStructRecord.FullID, false);
        }
        this.socket.flush();
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeCoordinateFieldList", Thread.currentThread(), null, 3, "Client: Requested " + n3 + " Fields");
        }
        if ((n2 = this.socket.readCommand()) == 6) {
            n2 = this.socket.readInt();
            for (n = 0; n < n2; ++n) {
                this.arFieldID.add(this.socket.readString());
            }
            if (this.Debug) {
                MainWin.appendToLog("TSocketDriver", "handshakeCoordinateFieldList", Thread.currentThread(), null, 3, "Client: Received " + n2 + " Fields");
            }
            for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
                tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
                if (tDriverStructRecord.IsVirtual || this.arFieldID.contains(tDriverStructRecord.FullID)) continue;
                tDriverStructRecord.Visible = false;
            }
            this.arDriverStructRecord = new TDriverStructRecord[this.arFieldID.size()];
            for (n = 0; n < this.arFieldID.size(); ++n) {
                this.arDriverStructRecord[n] = this.DriverStruct.getField((String)this.arFieldID.get(n));
            }
        } else {
            return 6;
        }
        return 0;
    }

    private int handshakeGetTableResource() {
        if (this.AppDriversObject.TableID.toString().trim().length() > 0) {
            return 0;
        }
        String string = this.socket.getIPAddress() + "_" + this.RemoteDriverID;
        if (TMainWin.Application.AppTables.isResourceDefined(string)) {
            return 0;
        }
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeGetDriverStruct", Thread.currentThread(), null, 3, "Client: Requesting Table Resource");
        }
        this.socket.writeCommand(15, true);
        int n = this.socket.readCommand();
        if (n != 15) {
            return 11;
        }
        TMainWin.Application.AppTables.addResourceElement("TSocketDriver", this.socket.readString(), string);
        this.AppDriversObject.TableID.setLength(0);
        this.AppDriversObject.TableID.append(string);
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeGetDriverStruct", Thread.currentThread(), null, 3, "Client: Table resource received");
        }
        return 0;
    }

    private int handshakeGetDialogResource() {
        if (this.AppDriversObject.DialogIDStart.toString().trim().length() > 0) {
            return 0;
        }
        String string = this.socket.getIPAddress() + "_" + this.RemoteDriverID;
        if (TMainWin.Application.AppDialogs.getResourceElements(string).size() > 0) {
            return 0;
        }
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeGetDriverStruct", Thread.currentThread(), null, 3, "Client: Requesting Dialog Resource");
        }
        this.socket.writeCommand(14, true);
        int n = this.socket.readCommand();
        if (n != 14) {
            return 10;
        }
        int n2 = this.socket.readInt();
        for (int i = 0; i < n2; ++i) {
            TMainWin.Application.AppDialogs.addResourceElement("TSocketDriver", this.socket.readString(), string);
        }
        this.AppDriversObject.DialogIDStart.setLength(0);
        this.AppDriversObject.DialogIDStart.append(string);
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeGetDriverStruct", Thread.currentThread(), null, 3, "Client: Dialog resource contains " + n2 + " records");
        }
        return 0;
    }

    private int handshakeGetDisplayResources() {
        if (!this.UseRemoteResources) {
            return 0;
        }
        this.socket.writeCommand(16, true);
        int n = this.socket.readCommand();
        if (n != 16) {
            return 12;
        }
        int n2 = this.socket.readInt();
        for (int i = 0; i < n2; ++i) {
            String string = this.socket.readString();
            int n3 = this.socket.readInt();
            ArrayList<TAppDisplaysObject> arrayList = new ArrayList<TAppDisplaysObject>();
            for (int j = 0; j < n3; ++j) {
                arrayList.add(new TAppDisplaysObject("TSocketDriver", j, this.socket.readString()));
            }
            System.out.println("TSocketDriver saving display \"" + string + "\" with " + arrayList.size() + " records");
            this.Application.AppDisplays.writeDisplayRecords(string, this.AppDriversObject.DriverID.toString(), arrayList, false);
        }
        return 0;
    }

    private int handshakeComplete() {
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeComplete", Thread.currentThread(), null, 3, "Client: Handshake Complete");
        }
        this.socket.writeCommand(7, true);
        int n = this.socket.readCommand();
        if (n != 7) {
            return 7;
        }
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeComplete", Thread.currentThread(), null, 3, "Bytes Sent: " + this.socket.getBytesWritten() + " Bytes Read: " + this.socket.getBytesRead() + " Flush: " + this.socket.getFlushCount());
        }
        return 0;
    }

    public void initializeBufferRecords(int n) {
        if (!this.IsValid) {
            return;
        }
        for (int i = this.FBuffer.getRecordCount(); i <= n; ++i) {
            for (int j = 0; j < this.DriverStruct.FieldColl.size(); ++j) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(j);
                Object object = objectutil.getErrorValue(tDriverStructRecord.FieldType);
                this.FBuffer.putField(tDriverStructRecord, i, object);
            }
        }
    }

    public void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int executeTimerEvent(TScrollTable tScrollTable) {
        if (!this.IsValid) {
            return 0;
        }
        return 1;
    }

    @Override
    public synchronized Object getField(String string, int n) {
        if (!this.IsValid) {
            return null;
        }
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public synchronized Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (!this.IsValid) {
            return null;
        }
        if (tDriverStructRecord == null) {
            return null;
        }
        Object object = null;
        if (tDriverStructRecord.IsCalculated) {
            object = this.calculateField(tDriverStructRecord, n);
            return object;
        }
        if (this.SocketManager.isFieldReceived(n, tDriverStructRecord)) {
            object = this.FBuffer.getField(tDriverStructRecord, n);
        } else {
            if (!this.SocketManager.isFieldRequested(n, tDriverStructRecord)) {
                this.SocketManager.requestData(tDriverStructRecord, n);
            }
            while (!this.SocketManager.isFieldReceived(n, tDriverStructRecord)) {
                this.sleep(500);
            }
            object = this.FBuffer.getField(tDriverStructRecord, n);
        }
        return object;
    }

    @Override
    public synchronized Object getFieldForTable(TDriverStructRecord tDriverStructRecord, int n) {
        if (!this.IsValid) {
            return null;
        }
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public int putField(String string, int n, Object object) {
        if (!this.IsValid) {
            return -1;
        }
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.putField(tDriverStructRecord, n, object);
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "putField", Thread.currentThread(), null, 3, "Client: Putting field ID=" + tDriverStructRecord.FullID + " Record=" + n + " Obj=" + object);
        }
        if (!this.IsValid) {
            return -1;
        }
        this.initializeBufferRecords(n);
        this.FBuffer.putField(tDriverStructRecord, n, object);
        int n2 = -1;
        for (int i = 0; n2 < 0 && i < this.arFieldID.size(); ++i) {
            if (((String)this.arFieldID.get(i)).compareToIgnoreCase(tDriverStructRecord.FullID) != 0) continue;
            n2 = i;
        }
        if (n2 >= 0) {
            if (this.Debug) {
                MainWin.appendToLog("TSocketDriver", "putField", Thread.currentThread(), null, 3, "Client: Sending data to server");
            }
            this.SocketManager.sendData(n, n2, tDriverStructRecord, object);
        } else if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "putField", Thread.currentThread(), null, 3, "Client: Cannot locate field in list of fields supported by server");
        }
        return 0;
    }

    @Override
    public TComboBoxColl getComboBoxColl(String string, StringBuilder stringBuilder, TFormulaEvaluator tFormulaEvaluator, boolean bl, boolean bl2, int n) {
        TDriverStructRecord tDriverStructRecord;
        TComboBoxColl tComboBoxColl = null;
        String string2 = "";
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.arComboBoxColl == null) {
            this.arComboBoxColl = new Hashtable();
        }
        if ((tDriverStructRecord = this.DriverStruct.getField(string)) != null) {
            String string3 = string2 = tDriverStructRecord.CollectionID;
            Object object = this.getField("__ConsolidatedVertDriver__Embedded_Driver_Number", n);
            if (object != null) {
                string3 = string3 + "|DriverNumber=" + ((Integer)object).toString();
            }
            if (tFormulaEvaluator != null && tDriverStructRecord.AlternateCollection.length() > 0) {
                Object object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.AlternateCollection, tFormulaEvaluator.getAltRecordNumber(), 0);
                if (object2 instanceof String) {
                    string2 = (String)object2;
                }
                if (string2.length() == 0) {
                    return new TComboBoxColl(false, 0);
                }
            }
            if (stringBuilder != null && !charutil.nullstr(stringBuilder)) {
                bl3 = true;
            }
            if (!bl2 && !bl3) {
                tComboBoxColl = (TComboBoxColl)this.arComboBoxColl.get(string3);
            }
            if (tComboBoxColl == null) {
                tComboBoxColl = this.makeCollection(string, string2, stringBuilder.toString(), this.getDriverParams(), n);
                if (!bl2 && !bl3 && tComboBoxColl != null) {
                    this.arComboBoxColl.put(string3, tComboBoxColl);
                }
            }
        }
        return tComboBoxColl;
    }

    @Override
    public TComboBoxColl getComboBoxColl(String string, String string2, TFormulaEvaluator tFormulaEvaluator, boolean bl, int n) {
        TComboBoxColl tComboBoxColl = null;
        boolean bl2 = false;
        if (this.arComboBoxColl == null) {
            this.arComboBoxColl = new Hashtable();
        }
        if (string2 != null && !charutil.nullstr(string2)) {
            bl2 = true;
        }
        String string3 = string;
        Object object = this.getField("__ConsolidatedVertDriver__Embedded_Driver_Number", n);
        if (object != null) {
            string3 = string3 + "|DriverNumber=" + ((Integer)object).toString();
        }
        if (!bl && !bl2) {
            tComboBoxColl = (TComboBoxColl)this.arComboBoxColl.get(string3);
        }
        if (tComboBoxColl == null) {
            tComboBoxColl = this.makeCollection("", string, string2.toString(), this.getDriverParams(), n);
            if (!bl && !bl2 && tComboBoxColl != null) {
                this.arComboBoxColl.put(string3, tComboBoxColl);
            }
        }
        return tComboBoxColl;
    }

    public synchronized TComboBoxColl makeCollection(String string, String string2, String string3, String string4, int n) {
        if (string4.trim().length() == 0) {
            this.SocketManager.requestCollection(string, string2, string3, this.getDriverParams(), n);
        } else {
            this.SocketManager.requestCollection(string, string2, string3, string4, n);
        }
        TComboBoxColl tComboBoxColl = null;
        while (tComboBoxColl == null) {
            if (this.hashReceivedColl.containsKey(string2)) {
                tComboBoxColl = (TComboBoxColl)this.hashReceivedColl.get(string2);
                this.hashReceivedColl.remove(string2);
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return tComboBoxColl;
    }

    private class TSocketManager
    extends Thread {
        private ArrayList arRecordStatus;

        public TSocketManager() {
            super("TSocketManager");
            this.arRecordStatus = new ArrayList();
        }

        public int getFieldIndex(String string) {
            for (int i = 0; i < TSocketDriver.this.arDriverStructRecord.length; ++i) {
                if (!TSocketDriver.this.arDriverStructRecord[i].FullID.equals(string)) continue;
                return i;
            }
            return -1;
        }

        public boolean isFieldRequested(int n, TDriverStructRecord tDriverStructRecord) {
            int n2;
            boolean bl = false;
            if (n < this.arRecordStatus.size() && (n2 = this.getFieldIndex(tDriverStructRecord.FullID)) >= 0) {
                bl = ((TRecordStatus)this.arRecordStatus.get((int)n)).arFieldRequested[n2];
            }
            if (TSocketDriver.this.Debug) {
                // empty if block
            }
            return bl;
        }

        public boolean isFieldRequested(int n, int n2) {
            if (n >= this.arRecordStatus.size()) {
                return false;
            }
            return ((TRecordStatus)this.arRecordStatus.get((int)n)).arFieldRequested[n2];
        }

        public boolean isFieldReceived(int n, TDriverStructRecord tDriverStructRecord) {
            if (n >= this.arRecordStatus.size()) {
                return false;
            }
            int n2 = this.getFieldIndex(tDriverStructRecord.FullID);
            if (n2 < 0) {
                System.out.println("FieldIndex out of bounds: " + tDriverStructRecord.FullID);
            }
            if (n2 < 0) {
                return false;
            }
            return ((TRecordStatus)this.arRecordStatus.get((int)n)).arFieldReceived[n2];
        }

        public boolean isFieldReceived(int n, int n2) {
            if (n >= this.arRecordStatus.size()) {
                return false;
            }
            return ((TRecordStatus)this.arRecordStatus.get((int)n)).arFieldReceived[n2];
        }

        private synchronized void primeFields() {
            if (TSocketDriver.this.AspectDriver != null && TSocketDriver.this.AspectDriver.AspectDriverFilter != null) {
                int n;
                int n2;
                int n3;
                String[] stringArray = TSocketDriver.this.AspectDriver.AspectDriverFilter.getDisplayedFields();
                String[] stringArray2 = TSocketDriver.this.AspectDriver.AspectDriverFilter.getSortFields();
                String[] stringArray3 = TSocketDriver.this.AspectDriver.AspectDriverFilter.getFilterTreeFields();
                if (TSocketDriver.this.Debug) {
                    int n4;
                    System.out.println("Priming Fields:");
                    System.out.print("Visible Fields: ");
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        System.out.print(stringArray[n4] + " ");
                    }
                    System.out.println();
                    System.out.print("Sort Fields: ");
                    for (n4 = 0; n4 < stringArray2.length; ++n4) {
                        System.out.print(stringArray2[n4] + " ");
                    }
                    System.out.println();
                    System.out.print("Node Fields: ");
                    for (n4 = 0; n4 < stringArray3.length; ++n4) {
                        System.out.print(stringArray3[n4] + " ");
                    }
                    System.out.println();
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    if (arrayList.contains(stringArray[n3])) continue;
                    arrayList.add(stringArray[n3]);
                }
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    if (arrayList.contains(stringArray2[n3])) continue;
                    arrayList.add(stringArray2[n3]);
                }
                for (n3 = 0; n3 < stringArray3.length; ++n3) {
                    if (arrayList.contains(stringArray3[n3])) continue;
                    arrayList.add(stringArray3[n3]);
                }
                if (TSocketDriver.this.Debug) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        stringBuilder.append((String)arrayList.get(n2) + " ");
                    }
                    MainWin.appendToLog("TSocketDriver", "primeFields", Thread.currentThread(), null, 3, "Priming fields: " + stringBuilder.toString());
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    n2 = this.getFieldIndex((String)arrayList.get(n));
                    if (n2 < 0) continue;
                    TSocketDriver.this.socket.writeCommand(12, false);
                    TSocketDriver.this.socket.writeInt(0, false);
                    TSocketDriver.this.socket.writeInt(this.getFieldIndex((String)arrayList.get(n)), false);
                    TSocketDriver.this.socket.writeInt(TSocketDriver.this.RecordCount, false);
                }
                TSocketDriver.this.socket.flush();
                while (this.arRecordStatus.size() < TSocketDriver.this.RecordCount) {
                    this.arRecordStatus.add(new TRecordStatus());
                }
                for (n = 0; n < TSocketDriver.this.RecordCount; ++n) {
                    TRecordStatus tRecordStatus = (TRecordStatus)this.arRecordStatus.get(n);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        int n5 = this.getFieldIndex((String)arrayList.get(i));
                        if (n5 < 0) continue;
                        tRecordStatus.arFieldRequested[n5] = true;
                    }
                }
            }
            TSocketDriver.this.PrimeFields = false;
        }

        public synchronized void requestData(TDriverStructRecord tDriverStructRecord, int n) {
            if (TSocketDriver.this.PrimeFields) {
                this.primeFields();
            }
            int n2 = this.getFieldIndex(tDriverStructRecord.FullID);
            int n3 = 0;
            n = 0;
            int n4 = 0;
            while (n4 + n < TSocketDriver.this.RecordCount) {
                if (!this.isFieldRequested(n + n4, n2) && !this.isFieldReceived(n + n4, n2)) {
                    ++n3;
                }
                ++n4;
            }
            if (n3 < 1) {
                return;
            }
            TSocketDriver.this.socket.writeCommand(12, false);
            TSocketDriver.this.socket.writeInt(n, false);
            TSocketDriver.this.socket.writeInt(n2, false);
            TSocketDriver.this.socket.writeInt(n3, true);
            TSocketDriver.this.socket.flush();
            if (TSocketDriver.this.Debug) {
                MainWin.appendToLog("TSocketDriver", "TSocketManager.requestData", Thread.currentThread(), null, 3, "Client: Requesting " + n3 + " records (" + Integer.toString(n) + " - " + Integer.toString(n + (n3 - 1)) + ") for field " + tDriverStructRecord.FullID);
            }
            while (n + n3 >= this.arRecordStatus.size()) {
                this.arRecordStatus.add(new TRecordStatus());
            }
            for (n4 = n; n4 < n + n3; ++n4) {
                ((TRecordStatus)this.arRecordStatus.get((int)n4)).arFieldRequested[n2] = true;
            }
        }

        public synchronized void requestCollection(String string, String string2, String string3, String string4, int n) {
            if (TSocketDriver.this.Debug) {
                MainWin.appendToLog("TSocketDriver", "getCollectionFromServer", Thread.currentThread(), null, 3, "Client: Requesting collection ID=" + string2 + " Filter=" + string3 + " DriverParams=" + string4 + " Record=" + n);
            }
            TSocketDriver.this.socket.writeCommand(13, false);
            TSocketDriver.this.socket.writeString(string, false);
            TSocketDriver.this.socket.writeString(string2, false);
            TSocketDriver.this.socket.writeString(string3, false);
            TSocketDriver.this.socket.writeString(string4, false);
            TSocketDriver.this.socket.writeInt(n, true);
        }

        public synchronized void sendData(int n, int n2, TDriverStructRecord tDriverStructRecord, Object object) {
            TSocketDriver.this.socket.writeCommand(9, false);
            TSocketDriver.this.socket.writeInt(1, false);
            TSocketDriver.this.socket.writeInt(n, false);
            TSocketDriver.this.socket.writeInt(n2, false);
            TSocketDriver.this.socket.writeData(tDriverStructRecord.FieldType, object, true);
        }

        @Override
        public void run() {
            block7: while (TSocketDriver.this.socket.isConnected()) {
                if (!TSocketDriver.this.socket.available()) continue;
                switch (TSocketDriver.this.socket.readCommand()) {
                    case 9: {
                        String string;
                        int n = TSocketDriver.this.socket.readInt();
                        int n2 = TSocketDriver.this.socket.readInt();
                        String string2 = TSocketDriver.this.socket.readString();
                        String[] stringArray = charutil.getSubStringArray(string2, ',', true);
                        TDriverStructRecord tDriverStructRecord = TSocketDriver.this.arDriverStructRecord[n2];
                        if (TSocketDriver.this.Debug) {
                            MainWin.appendToLog("TSocketDriver", "TSocketManager", Thread.currentThread(), null, 3, "Client: Ttl Bytes Recv:" + TSocketDriver.this.socket.getBytesRead() + " Sent:" + TSocketDriver.this.socket.getBytesWritten() + " Flushes:" + TSocketDriver.this.socket.getFlushCount() + " Receiving data (" + stringArray.length + " fields) for field " + tDriverStructRecord.FullID);
                        }
                        for (int i = 0; i < stringArray.length; ++i) {
                            int n3 = n + i;
                            string = charutil.replaceAllSubstrings(stringArray[i], "%22", "\"");
                            Object object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string, n3);
                            while (n3 >= TSocketDriver.this.FBuffer.getRecordCount()) {
                                TSocketDriver.this.initializeBufferRecords(n3);
                            }
                            TSocketDriver.this.FBuffer.putField(tDriverStructRecord, n3, object);
                            while (n3 >= this.arRecordStatus.size()) {
                                this.arRecordStatus.add(new TRecordStatus());
                            }
                            ((TRecordStatus)this.arRecordStatus.get((int)n3)).arFieldReceived[n2] = true;
                        }
                        continue block7;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        TSocketDriver.this.RecordCount = TSocketDriver.this.socket.readInt();
                        if (!TSocketDriver.this.Debug) continue block7;
                        MainWin.appendToLog("TSocketDriver", "TSocketManager", Thread.currentThread(), null, 3, "Client: Received record count (" + TSocketDriver.this.RecordCount + ")");
                        break;
                    }
                    case 13: {
                        String string;
                        String[] stringArray;
                        TComboBoxColl tComboBoxColl = new TComboBoxColl(false, 0);
                        String string3 = TSocketDriver.this.socket.readString();
                        if (TSocketDriver.this.Debug) {
                            MainWin.appendToLog("TSocketDriver", "TSocketManager", Thread.currentThread(), null, 3, "Client: Ttl Bytes Recv:" + TSocketDriver.this.socket.getBytesRead() + " Sent:" + TSocketDriver.this.socket.getBytesWritten() + " Flushes:" + TSocketDriver.this.socket.getFlushCount() + " Receiving collection (" + string3 + ")");
                        }
                        if ((stringArray = charutil.getSubStringArray(string = TSocketDriver.this.socket.readString(), '|', true)) != null) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                String[] stringArray2 = charutil.getSubStringArray(stringArray[i], ',', true);
                                if (stringArray2[0].indexOf("%22") >= 0) {
                                    stringArray2[0] = charutil.replaceAllSubstrings(stringArray2[0], "\"", "\"");
                                }
                                if (stringArray2[1].indexOf("%22") >= 0) {
                                    stringArray2[1] = charutil.replaceAllSubstrings(stringArray2[1], "\"", "\"");
                                }
                                if (stringArray2 == null || stringArray2.length != 2) continue;
                                tComboBoxColl.add(stringArray2[0], stringArray2[1]);
                            }
                        }
                        TSocketDriver.this.hashReceivedColl.put(string3, tComboBoxColl);
                        break;
                    }
                    case 8: {
                        TSocketDriver.this.Disconnected = true;
                        break;
                    }
                    default: {
                        MainWin.appendToLog("TSocketDriver", "TSocketManager.run", Thread.currentThread(), null, 4, "Client: Unrecognized command received from server in driver " + TSocketDriver.this.AppDriversObject.DriverID);
                    }
                }
            }
        }
    }

    private class TRecordStatus {
        boolean[] arFieldRequested;
        boolean[] arFieldReceived;

        public TRecordStatus() {
            int n = TSocketDriver.this.arFieldID.size();
            this.arFieldRequested = new boolean[n];
            this.arFieldReceived = new boolean[n];
            for (int i = 0; i < n; ++i) {
                this.arFieldRequested[i] = false;
                this.arFieldReceived[i] = false;
            }
        }
    }
}

