/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStructRecord;
import java.util.ArrayList;
import java.util.Collections;
import resources.TAppDisplaysObject;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.objectutil;

public class TSubtotalsDriver
extends TAbstractDriver
implements TDriverInterface {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTSubtotalsDriver");
    public static final String[] arSubtotalFunctionNames = new String[]{"Sum", "Count", "Minimum", "Maximum", "Average", "Standard Deviation"};
    private ArrayList arSubtotalGroups = new ArrayList();
    private ArrayList arConsolidatedTemplates = new ArrayList();
    public ArrayList arSubtotals = new ArrayList();
    private int cSubtotalFields;
    private int[] arSubtotalFields;

    public TSubtotalsDriver(TAspectDriver tAspectDriver) {
        Object object;
        int n;
        this.AspectDriver = tAspectDriver;
        this.FormulaEvaluator = new TFormulaEvaluator(TMainWin.Application, this.AspectDriver.DriverStruct, this);
        this.FormulaEvaluator.setAspectDriver(this.AspectDriver);
        String string = this.AspectDriver.strDriverParams.toString();
        String string2 = (String)this.AspectDriver.F.getFormulaEvaluator().getConstant("Params");
        if (string2 != null) {
            string = string + "|" + string2;
        }
        if ((string2 = (String)this.AspectDriver.F.getFormulaEvaluator().getConstant("DriverParams")) != null) {
            string = string + "|" + string2;
        }
        if (string.length() > 0) {
            this.FormulaEvaluator.setConstant("Params", string);
            String[] stringArray = charutil.getSubStringArray(string, '|', false);
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    String string3;
                    String[] stringArray2;
                    int n2;
                    object = charutil.getSubStringArray(stringArray[n], '=', false);
                    if (object == null || ((String[])object).length < 2) continue;
                    for (n2 = 2; n2 < ((String[])object).length; ++n2) {
                        object[1] = object[1] + "=" + object[n2];
                    }
                    this.FormulaEvaluator.setConstant("#" + object[0], object[1]);
                    if (!stringArray[n].toUpperCase().startsWith("DIMDRIVERPARAMS") || (n2 = stringArray[n].indexOf(61)) < 0 || (stringArray2 = charutil.getSubStringArray(string3 = stringArray[n].substring(n2 + 1), '^', false)) == null) continue;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        n2 = stringArray2[i].indexOf(61);
                        if (n2 < 0) continue;
                        String string4 = stringArray2[i].substring(0, n2);
                        String string5 = stringArray2[i].substring(n2 + 1);
                        if (this.FormulaEvaluator.getConstant("#" + string4) != null) continue;
                        this.FormulaEvaluator.setConstant("#" + string4, string5);
                    }
                }
            }
        }
        if (this.Debug) {
            this.MainWin.appendToLog("TSubtotalsDriver", "<init>", Thread.currentThread(), null, 10, "Initializing subtotals for " + this.AspectDriver.AppDriverObj.Description);
        }
        if (this.AspectDriver == null) {
            System.out.println("AspectDriver is null");
        }
        if (this.AspectDriver.DriverStruct == null) {
            System.out.println("DriverStruct is null");
        }
        this.arSubtotalFields = new int[this.AspectDriver.DriverStruct.FieldColl.size()];
        this.cSubtotalFields = 0;
        boolean bl = false;
        for (n = 0; n < this.AspectDriver.DriverStruct.FieldColl.size(); ++n) {
            object = (TDriverStructRecord)this.AspectDriver.DriverStruct.FieldColl.get(n);
            if (object.CalcSubtotal) {
                bl = true;
            }
            if (!object.CalcSubtotal) continue;
            this.arSubtotalFields[this.cSubtotalFields] = n;
            ++this.cSubtotalFields;
        }
        if (!bl) {
            this.cSubtotalFields = 0;
        }
    }

    @Override
    public int getRecordCount() {
        if (this.arSubtotals == null) {
            return 0;
        }
        return this.arSubtotals.size();
    }

    public int getGroupCount() {
        return this.arSubtotalGroups.size();
    }

    public boolean isGrandTotal(int n) {
        TSubtotal tSubtotal = (TSubtotal)this.arSubtotals.get(n);
        return tSubtotal.arKeyFields.length == 0;
    }

    public int getSubtotalLevel(int n) {
        int n2 = 0;
        for (int i = 0; i < this.arConsolidatedTemplates.size(); ++i) {
            n2 = Math.max(n2, ((TSubtotalTemplate)this.arConsolidatedTemplates.get((int)i)).arKeyFields.length);
        }
        TSubtotal tSubtotal = (TSubtotal)this.arSubtotals.get(n);
        return n2 - tSubtotal.arKeyFields.length;
    }

    @Override
    public String getKeyValue(int n) {
        TSubtotal tSubtotal = this.getSubtotal(n);
        if (tSubtotal == null) {
            return "error";
        }
        String string = "";
        for (int i = 0; i < tSubtotal.arKeyValues.length; ++i) {
            string = string + tSubtotal.arKeyValues[i].toString();
        }
        if (this.isGrandTotal(n)) {
            string = string + "GrandTotal";
        }
        return charutil.crc(string);
    }

    public void clearSubtotalTemplates() {
        this.arSubtotalGroups.clear();
        this.arSubtotalGroups.add(new TSubtotalGroup(0, 0, 0, null, 0));
        this.arSubtotalGroups.add(new TSubtotalGroup(1, 0, 0, null, 0));
        this.arSubtotalGroups.add(new TSubtotalGroup(2, 0, 0, null, 0));
    }

    public void addSubtotalTemplate(int n, int n2, String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.AspectDriver.DriverStruct.getFieldIndex(stringArray[i]);
        }
        this.arSubtotalGroups.add(new TSubtotalGroup(3, n, n2, nArray, nArray.length));
        this.createConsolidatedTemplates();
    }

    public void updateSubtotalTemplates(ArrayList arrayList) {
        if (this.cSubtotalFields == 0) {
            return;
        }
        int n = 0;
        this.arSubtotalGroups.clear();
        this.arSubtotalGroups.add(new TSubtotalGroup(0, 0, n, null, 0));
        this.arSubtotalGroups.add(new TSubtotalGroup(1, 0, n, null, 0));
        this.arSubtotalGroups.add(new TSubtotalGroup(2, 0, n, null, 0));
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < 6; ++i) {
            int n2 = 0;
            for (int j = 0; j < arrayList.size(); ++j) {
                TAppDisplaysObject tAppDisplaysObject = (TAppDisplaysObject)arrayList.get(j);
                if (j == 0) {
                    n = tAppDisplaysObject.SubtotalType[i];
                }
                if (!tAppDisplaysObject.Subtotal[i]) continue;
                nArray[n2] = tAppDisplaysObject.AbsoluteFieldIndex;
                ++n2;
            }
            if (n2 <= 0) continue;
            this.arSubtotalGroups.add(new TSubtotalGroup(3, i, n, nArray, n2));
        }
        this.createConsolidatedTemplates();
    }

    public void createConsolidatedTemplates() {
        this.arConsolidatedTemplates.clear();
        for (int i = 0; i < this.arSubtotalGroups.size(); ++i) {
            TSubtotalGroup tSubtotalGroup = (TSubtotalGroup)this.arSubtotalGroups.get(i);
            for (int j = 0; j < tSubtotalGroup.arTemplates.size(); ++j) {
                TSubtotalTemplate tSubtotalTemplate = (TSubtotalTemplate)tSubtotalGroup.arTemplates.get(j);
                int n = Collections.binarySearch(this.arConsolidatedTemplates, tSubtotalTemplate);
                if (n >= 0) continue;
                this.arConsolidatedTemplates.add(Math.abs(n + 1), tSubtotalTemplate);
            }
        }
    }

    public void calculateSubtotals() {
        if (this.cSubtotalFields == 0) {
            return;
        }
        Object[] objectArray = new String[this.AspectDriver.DriverStruct.FieldColl.size()];
        double[] dArray = new double[this.cSubtotalFields];
        this.arSubtotals.clear();
        if (this.Debug) {
            this.MainWin.appendToLog("TSubtotalsDriver", "calculateSubtotals", Thread.currentThread(), null, 10, "\tCalculating displayed totals for " + this.AspectDriver.AppDriverObj.Description);
        }
        for (int i = 0; i < this.AspectDriver.getRecordCount(); ++i) {
            Object object;
            TDriverStructRecord tDriverStructRecord;
            int n;
            for (n = 0; n < this.cSubtotalFields; ++n) {
                tDriverStructRecord = (TDriverStructRecord)this.AspectDriver.DriverStruct.FieldColl.get(this.arSubtotalFields[n]);
                object = this.AspectDriver.getField(tDriverStructRecord, i);
                dArray[n] = objectutil.convertToNumber(object);
            }
            for (n = 0; n < this.arConsolidatedTemplates.size(); ++n) {
                int n2;
                TSubtotal tSubtotal;
                TSubtotalTemplate tSubtotalTemplate = (TSubtotalTemplate)this.arConsolidatedTemplates.get(n);
                if (tSubtotalTemplate.IsFilteredTotal) {
                    tSubtotal = new TSubtotal(tSubtotalTemplate, null, dArray);
                    n2 = Collections.binarySearch(this.arSubtotals, tSubtotal);
                    if (n2 < 0) {
                        this.arSubtotals.add(Math.abs(n2 + 1), tSubtotal);
                        continue;
                    }
                    ((TSubtotal)this.arSubtotals.get(n2)).addValues(tSubtotal);
                    continue;
                }
                for (int j = 0; j < tSubtotalTemplate.arKeyFields.length; ++j) {
                    if (tSubtotalTemplate.arKeyFields[j] >= 0) {
                        tDriverStructRecord = (TDriverStructRecord)this.AspectDriver.DriverStruct.FieldColl.get(tSubtotalTemplate.arKeyFields[j]);
                        object = this.AspectDriver.getField(tDriverStructRecord, i);
                        objectArray[j] = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
                        continue;
                    }
                    objectArray[j] = "";
                }
                tSubtotal = new TSubtotal(tSubtotalTemplate, objectArray, dArray);
                n2 = Collections.binarySearch(this.arSubtotals, tSubtotal);
                if (n2 < 0) {
                    this.arSubtotals.add(Math.abs(n2 + 1), tSubtotal);
                    continue;
                }
                ((TSubtotal)this.arSubtotals.get(n2)).addValues(tSubtotal);
            }
        }
    }

    public TSubtotalGroup getSubtotalGroup(int n) {
        return (TSubtotalGroup)this.arSubtotalGroups.get(n);
    }

    public TSubtotal getSubtotal(int n) {
        return (TSubtotal)this.arSubtotals.get(n);
    }

    public String formatDisplayString(int n, String string) {
        TSubtotal tSubtotal = (TSubtotal)this.arSubtotals.get(n);
        return arSubtotalFunctionNames[tSubtotal.SubtotalType] + " of " + string;
    }

    @Override
    public boolean isInFilter(int n, String string) {
        boolean bl = super.isInFilter(n, string);
        return bl;
    }

    @Override
    public boolean isInFilter(int n, StringBuilder stringBuilder) {
        boolean bl = super.isInFilter(n, stringBuilder);
        return bl;
    }

    public boolean isSubtotalKeyDefined(TDriverStructRecord tDriverStructRecord, int n) {
        TSubtotal tSubtotal = (TSubtotal)this.arSubtotals.get(n);
        for (int i = 0; i < tSubtotal.arKeyFields.length; ++i) {
            if (tSubtotal.arKeyFields[i] != tDriverStructRecord.AbsoluteIndex) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object calculateField(TDriverStructRecord tDriverStructRecord, int n) {
        return super.calculateField(tDriverStructRecord, n);
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        int n2;
        if (n < 0 || n >= this.arSubtotals.size()) {
            return null;
        }
        Object object = null;
        int n3 = n;
        TSubtotal tSubtotal = (TSubtotal)this.arSubtotals.get(n);
        for (n2 = 0; n2 < tSubtotal.arKeyFields.length; ++n2) {
            if (tSubtotal.arKeyFields[n2] != tDriverStructRecord.AbsoluteIndex) continue;
            String string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, tSubtotal.arKeyValues[n2]);
            object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string, 0);
            return object;
        }
        if (tDriverStructRecord.SubtotalAsFormula) {
            return this.calculateField(tDriverStructRecord, n);
        }
        if (tDriverStructRecord.SubtotalAsFormula && tDriverStructRecord.IsCalculated && objectutil.isNumberField(tDriverStructRecord.FieldType)) {
            object = this.calculateField(tDriverStructRecord, n);
            return object;
        }
        for (n2 = 0; n2 < this.cSubtotalFields; ++n2) {
            if (this.arSubtotalFields[n2] != tDriverStructRecord.AbsoluteIndex) continue;
            String string = Double.toString(tSubtotal.getValue(n2));
            object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string, 0);
            return object;
        }
        return null;
    }

    public class TSubtotal
    extends TSubtotalTemplate
    implements Comparable {
        Object[] arKeyValues;
        double[] arValues;
        double[] arMinValue;
        double[] arMaxValue;
        int Count;

        public TSubtotal(TSubtotalTemplate tSubtotalTemplate, Object[] objectArray, double[] dArray) {
            int n;
            super(tSubtotalTemplate);
            this.arKeyValues = null;
            this.Count = 0;
            if (dArray != null) {
                this.arKeyValues = new Object[this.arKeyFields.length];
                for (n = 0; n < this.arKeyFields.length; ++n) {
                    this.arKeyValues[n] = objectArray[n];
                }
            }
            this.arValues = new double[TSubtotalsDriver.this.cSubtotalFields];
            this.arMinValue = new double[TSubtotalsDriver.this.cSubtotalFields];
            this.arMaxValue = new double[TSubtotalsDriver.this.cSubtotalFields];
            for (n = 0; n < TSubtotalsDriver.this.cSubtotalFields; ++n) {
                this.arValues[n] = dArray[n];
                this.arMinValue[n] = dArray[n];
                this.arMaxValue[n] = dArray[n];
            }
            this.Count = 1;
        }

        public void addValues(TSubtotal tSubtotal) {
            for (int i = 0; i < TSubtotalsDriver.this.cSubtotalFields; ++i) {
                int n = i;
                this.arValues[n] = this.arValues[n] + tSubtotal.arValues[i];
                this.arMinValue[i] = Math.min(this.arMinValue[i], tSubtotal.arValues[i]);
                this.arMaxValue[i] = Math.max(this.arMaxValue[i], tSubtotal.arValues[i]);
            }
            ++this.Count;
        }

        public double getValue(int n) {
            double d = 0.0;
            switch (this.SubtotalType) {
                case 0: {
                    d = this.arValues[n];
                    break;
                }
                case 1: {
                    d = this.Count;
                    break;
                }
                case 2: {
                    d = this.arMinValue[n];
                    break;
                }
                case 3: {
                    d = this.arMaxValue[n];
                    break;
                }
                case 4: {
                    d = charutil.divby(this.arValues[n], this.Count);
                    break;
                }
                case 5: {
                    d = 0.0;
                }
            }
            return d;
        }

        @Override
        public int compareTo(Object object) {
            TSubtotal tSubtotal = (TSubtotal)object;
            int n = super.compareTo(object);
            if (n == 0 && this.arKeyValues != null) {
                for (int i = 0; n == 0 && i < this.arKeyValues.length; ++i) {
                    n = this.arKeyValues[i] instanceof String ? ((String)this.arKeyValues[i]).compareToIgnoreCase((String)tSubtotal.arKeyValues[i]) : ((Comparable)this.arKeyValues[i]).compareTo((Comparable)tSubtotal.arKeyValues[i]);
                }
            }
            return n;
        }
    }

    public class TSubtotalTemplate
    implements Comparable {
        public int SubtotalType;
        public int[] arKeyFields;
        public boolean IsFilteredTotal;

        public TSubtotalTemplate(int n, boolean bl, int[] nArray, int n2) {
            this.SubtotalType = n;
            this.IsFilteredTotal = bl;
            this.arKeyFields = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.arKeyFields[i] = nArray[i];
            }
        }

        public TSubtotalTemplate(TSubtotalTemplate tSubtotalTemplate) {
            this.SubtotalType = tSubtotalTemplate.SubtotalType;
            this.IsFilteredTotal = tSubtotalTemplate.IsFilteredTotal;
            this.arKeyFields = new int[tSubtotalTemplate.arKeyFields.length];
            for (int i = 0; i < tSubtotalTemplate.arKeyFields.length; ++i) {
                this.arKeyFields[i] = tSubtotalTemplate.arKeyFields[i];
            }
        }

        public int compareTo(Object object) {
            TSubtotalTemplate tSubtotalTemplate = (TSubtotalTemplate)object;
            if (this.IsFilteredTotal && !tSubtotalTemplate.IsFilteredTotal) {
                return -1;
            }
            if (!this.IsFilteredTotal && tSubtotalTemplate.IsFilteredTotal) {
                return 1;
            }
            if (this.SubtotalType < tSubtotalTemplate.SubtotalType) {
                return -1;
            }
            if (this.SubtotalType > tSubtotalTemplate.SubtotalType) {
                return 1;
            }
            if (this.arKeyFields.length < tSubtotalTemplate.arKeyFields.length) {
                return -1;
            }
            if (this.arKeyFields.length > tSubtotalTemplate.arKeyFields.length) {
                return 1;
            }
            for (int i = 0; i < this.arKeyFields.length; ++i) {
                if (this.arKeyFields[i] < tSubtotalTemplate.arKeyFields[i]) {
                    return -1;
                }
                if (this.arKeyFields[i] <= tSubtotalTemplate.arKeyFields[i]) continue;
                return 1;
            }
            return 0;
        }
    }

    public class TSubtotalGroup {
        public int GroupNumber;
        public int GroupType;
        public int SubtotalType;
        public ArrayList arTemplates;

        public TSubtotalGroup(int n, int n2, int n3, int[] nArray, int n4) {
            int[] nArray2 = new int[n4];
            this.GroupType = n;
            this.GroupNumber = n2;
            this.SubtotalType = n3;
            this.arTemplates = new ArrayList();
            switch (this.GroupType) {
                case 1: {
                    for (int i = 0; i < arSubtotalFunctionNames.length; ++i) {
                        this.arTemplates.add(new TSubtotalTemplate(i, false, null, 0));
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < arSubtotalFunctionNames.length; ++i) {
                        this.arTemplates.add(new TSubtotalTemplate(i, true, null, 0));
                    }
                    break;
                }
                case 3: {
                    int n5 = 1;
                    while ((double)n5 < Math.pow(2.0, n4)) {
                        int n6 = 0;
                        int n7 = 1;
                        for (int i = 0; i < n4; ++i) {
                            if ((n5 & n7) > 0) {
                                nArray2[n6] = nArray[i];
                                ++n6;
                            }
                            n7 *= 2;
                        }
                        this.arTemplates.add(new TSubtotalTemplate(this.SubtotalType, false, nArray2, n6));
                        ++n5;
                    }
                    break;
                }
            }
        }

        public String getDescription() {
            String string = "";
            switch (this.GroupType) {
                case 0: {
                    string = "Show details";
                    break;
                }
                case 1: {
                    string = "Grand totals";
                    break;
                }
                case 2: {
                    string = "Displayed totals";
                    break;
                }
                case 3: {
                    TSubtotalTemplate tSubtotalTemplate = (TSubtotalTemplate)this.arTemplates.get(this.arTemplates.size() - 1);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < tSubtotalTemplate.arKeyFields.length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(" / ");
                        }
                        stringBuilder.append(TSubtotalsDriver.this.AspectDriver.DriverStruct.getFieldDescription(tSubtotalTemplate.arKeyFields[i]));
                    }
                    string = arSubtotalFunctionNames[this.SubtotalType] + " of " + stringBuilder.toString();
                }
            }
            return string;
        }

        public String getTemplateDescription(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            TSubtotalTemplate tSubtotalTemplate = (TSubtotalTemplate)this.arTemplates.get(n);
            stringBuilder.setLength(0);
            for (int i = 0; i < tSubtotalTemplate.arKeyFields.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" / ");
                }
                stringBuilder.append(TSubtotalsDriver.this.AspectDriver.DriverStruct.getFieldDescription(tSubtotalTemplate.arKeyFields[i]));
            }
            return stringBuilder.toString();
        }

        public TSubtotalTemplate getTemplate(int n) {
            return (TSubtotalTemplate)this.arTemplates.get(n);
        }
    }
}

