/*
 * Decompiled with CFR 0.152.
 */
package drivers.consolidated;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.consolidated.TEmbeddedDriver;
import drivers.consolidated.TKeyCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.objectutil;

public class TConsolidatedHorzDriver
extends TAbstractDriver {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = false;
    private ArrayList arEmbeddedDrivers = new ArrayList();
    private TKeyCollection arKeyCollection = null;
    private ArrayList arKeyFields = new ArrayList();
    private ArrayList arDriverDescriptions = new ArrayList();
    public Hashtable hashUniqueFields = new Hashtable();
    static String sOperators = "()+-*/=<>,'\"";

    public TConsolidatedHorzDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, 1, bl);
    }

    @Override
    public void dispose() {
        int n = -1;
        for (int i = 0; i < this.arEmbeddedDrivers.size(); ++i) {
            TEmbeddedDriver tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(i);
            tEmbeddedDriver.dispose();
        }
        this.arEmbeddedDrivers.clear();
        this.arKeyFields.clear();
        this.arKeyCollection.dispose();
        super.dispose();
    }

    public ArrayList getKeyFields() {
        return this.arKeyFields;
    }

    @Override
    public int makeEditableFile() {
        return 1;
    }

    public void addDriver(String string, String string2, String string3, String string4, String string5) {
        TAspectDriver tAspectDriver = TFormulaEvaluator.getSystemDriver(string);
        if (tAspectDriver != null) {
            this.addDriver(tAspectDriver.F, string2, string3, string4, string5);
        } else {
            MainWin.appendToLog("TConsolidatedVertDriver", "addDriver", Thread.currentThread(), null, 3, "Invalid driver: " + string);
        }
    }

    public void addDriver(TDriverInterface tDriverInterface, String string, String string2, String string3, String string4) {
        int n;
        TDriverStructRecord tDriverStructRecord;
        if (this.Debug) {
            MainWin.appendToLog("TConsolidatedVertDriver", "addDriver", Thread.currentThread(), null, 3, "Embedding horizontal driver");
        }
        TEmbeddedDriver tEmbeddedDriver = new TEmbeddedDriver(this.arEmbeddedDrivers.size(), tDriverInterface, string, string2, string3);
        this.arEmbeddedDrivers.add(tEmbeddedDriver);
        if (tEmbeddedDriver.driver == null) {
            return;
        }
        String string5 = tDriverInterface.getDriverParams();
        String string6 = charutil.getParamValue(string5, "ControllablesDriverID", '|');
        String[] stringArray = charutil.getSubStringArray(string4, '|', true);
        tEmbeddedDriver.updateKeyCollection(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.arKeyFields.contains(stringArray[i].toUpperCase())) continue;
            if (this.Debug) {
                MainWin.appendToLog("TConsolidatedVertDriver", "addDriver", Thread.currentThread(), null, 3, "Adding key field: " + stringArray[i].toUpperCase());
            }
            this.arKeyFields.add(stringArray[i].toUpperCase());
        }
        if (this.arKeyCollection == null) {
            this.arKeyCollection = new TKeyCollection(stringArray);
        }
        this.arKeyCollection.addKeys(tEmbeddedDriver.getKeyCollection());
        TDriverStruct tDriverStruct = tEmbeddedDriver.driver.getDriverStruct();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.DriverStruct.getField(stringArray[i]) != null) continue;
            String string7 = tEmbeddedDriver.getEmbeddedFieldID(stringArray[i]);
            tDriverStructRecord = tDriverStruct.getField(string7);
            tDriverStructRecord.HorzBaseFieldID = string7;
            tDriverStructRecord.FullID = stringArray[i];
            this.DriverStruct.FieldColl.add(tDriverStructRecord);
            this.DriverStruct.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            stringBuilder.setLength(0);
            stringBuilder.append(tDriverStructRecord.Description.toUpperCase());
            charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
            this.DriverStruct.HashDescriptions.put(stringBuilder.toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            if (this.hashUniqueFields.containsKey("DSRec.FullID")) continue;
            this.hashUniqueFields.put(tDriverStructRecord.FullID, tDriverStructRecord.Description);
        }
        String string8 = tEmbeddedDriver.getDriverDescription();
        if (string8.trim().length() > 0 && this.arDriverDescriptions.contains(string8.toUpperCase())) {
            string8 = string8 + " " + Integer.toString(tEmbeddedDriver.getDriverNumber());
        }
        this.arDriverDescriptions.add(string8.toUpperCase());
        for (n = 0; n < tDriverStruct.FieldColl.size(); ++n) {
            String string9;
            tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n);
            String string10 = tDriverStructRecord.FullID;
            tDriverStructRecord = new TDriverStructRecord(tDriverStructRecord);
            if (!tEmbeddedDriver.isIncludedField(tDriverStructRecord.FullID) || this.arKeyFields.contains((string9 = tEmbeddedDriver.getConsolidatedFieldID(tDriverStructRecord.FullID)).toUpperCase())) continue;
            tDriverStructRecord.ID = tDriverStructRecord.FullID = "CONSOLIDATEDHORZDRIVERFIELD" + Integer.toString(tEmbeddedDriver.getDriverNumber()) + "_" + string9;
            tDriverStructRecord.HorzConsolidateDriverNum = tEmbeddedDriver.getDriverNumber();
            tDriverStructRecord.HorzBaseFieldID = string10;
            if (string10.equalsIgnoreCase("controllables_amount") && string6.length() > 0) {
                tDriverStructRecord.ControllablesDriverID = string6;
            }
            String string11 = tDriverStructRecord.Description;
            String string12 = tDriverStructRecord.Formula;
            String string13 = tDriverStructRecord.Description = string8.trim().length() == 0 ? tDriverStructRecord.Description : string8 + "<br>" + tDriverStructRecord.Description;
            if (tDriverStructRecord.SubtotalAsFormula) {
                tDriverStructRecord.Formula = this.replaceFormulaVars(string12, tDriverStruct, tEmbeddedDriver.getDriverNumber(), "CONSOLIDATEDHORZDRIVERFIELD");
            }
            if (this.DriverStruct.getField(tDriverStructRecord.FullID) != null) continue;
            if (this.Debug) {
                System.out.println("TConsolidatedHorzDriver Adding field: " + tDriverStructRecord.FullID + " " + tDriverStructRecord.Description);
            }
            this.DriverStruct.FieldColl.add(tDriverStructRecord);
            this.DriverStruct.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            stringBuilder.setLength(0);
            stringBuilder.append(tDriverStructRecord.Description.toUpperCase());
            charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
            this.DriverStruct.HashDescriptions.put(stringBuilder.toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            if (!this.hashUniqueFields.containsKey(string9)) {
                this.hashUniqueFields.put(string9, string11);
            }
            if (!tDriverStructRecord.CalcSubtotal) continue;
            String string14 = "CONSOLIDATEDHORZDRIVERTOTAL_" + string9;
            TDriverStructRecord tDriverStructRecord2 = this.DriverStruct.getField(string14);
            if (tDriverStructRecord2 == null) {
                tDriverStructRecord2 = new TDriverStructRecord(tDriverStructRecord);
                tDriverStructRecord2.ID = string14;
                tDriverStructRecord2.FullID = string14;
                tDriverStructRecord2.Description = "Total<br>" + string11;
                tDriverStructRecord2.IsCalculated = true;
                tDriverStructRecord2.IsVirtual = true;
                tDriverStructRecord2.Formula = "";
                this.DriverStruct.FieldColl.add(tDriverStructRecord2);
                this.DriverStruct.HashFields.put(tDriverStructRecord2.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                stringBuilder.setLength(0);
                stringBuilder.append(tDriverStructRecord2.Description.toUpperCase());
                charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
                this.DriverStruct.HashDescriptions.put(stringBuilder.toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            }
            if (tDriverStructRecord2.Formula.length() > 1) {
                tDriverStructRecord2.Formula = tDriverStructRecord2.Formula + "+";
            }
            tDriverStructRecord2.Formula = tDriverStructRecord.SubtotalAsFormula ? this.replaceFormulaVars(string12, tDriverStruct, -1, "CONSOLIDATEDHORZDRIVERTOTAL") : tDriverStructRecord2.Formula + tDriverStructRecord.FullID;
        }
        n = 0;
        int n2 = 0;
        this.DriverStruct.RecordSize = 0;
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            tDriverStructRecord.AbsoluteIndex = n++;
            if (!tDriverStructRecord.IsVirtual) {
                tDriverStructRecord.PhysicalIndex = n2++;
            }
            if (tDriverStructRecord.FieldType == 16) {
                ++this.DriverStruct.RecordSize;
                continue;
            }
            this.DriverStruct.RecordSize += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        }
        if (TMainWin.Application.getTokenValue("ExecMode").equalsIgnoreCase("Development")) {
            System.out.println("Writing driverstruct to c:\\temp\\driverstruct.csv");
            this.DriverStruct.write_to_file(TMainWin.Application.getTemporaryFiles() + "driverstruct.csv");
        }
    }

    private String replaceFormulaVars(String string, TDriverStruct tDriverStruct, int n, String string2) {
        int n2;
        if (string.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string3 = string2;
        if (n >= 0) {
            string3 = string3 + Integer.toString(n);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (sOperators.indexOf(c) >= 0) {
                if (stringBuilder2.length() > 0) {
                    String string4 = stringBuilder2.toString();
                    n2 = 0;
                    for (int j = 0; n2 == 0 && j < tDriverStruct.FieldColl.size(); ++j) {
                        TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(j);
                        if (!tDriverStructRecord.ID.equalsIgnoreCase(string4) && !tDriverStructRecord.FullID.equalsIgnoreCase(string4)) continue;
                        string4 = string3 + "_" + tDriverStructRecord.ID;
                        n2 = 1;
                    }
                    stringBuilder.append(string4);
                    stringBuilder2.setLength(0);
                }
                stringBuilder.append(c);
                continue;
            }
            stringBuilder2.append(c);
        }
        if (stringBuilder2.length() > 0) {
            String string5 = stringBuilder2.toString();
            boolean bl = false;
            for (n2 = 0; !bl && n2 < tDriverStruct.FieldColl.size(); ++n2) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!tDriverStructRecord.ID.equalsIgnoreCase(string5) && !tDriverStructRecord.FullID.equalsIgnoreCase(string5)) continue;
                string5 = string3 + "_" + tDriverStructRecord.ID;
                bl = true;
            }
            stringBuilder.append(string5);
        }
        return stringBuilder.toString();
    }

    public String[] expandFieldList(String[] stringArray) {
        int n;
        if (stringArray == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            TDriverStructRecord tDriverStructRecord;
            for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
                tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
                if (tDriverStructRecord.FullID.startsWith("CONSOLIDATEDHORZDRIVERTOTAL")) continue;
                if (tDriverStructRecord.FullID.equals(stringArray[i])) {
                    arrayList.add(tDriverStructRecord.FullID);
                    continue;
                }
                n2 = tDriverStructRecord.FullID.indexOf("_");
                if (n2 < 0 || !tDriverStructRecord.FullID.substring(n2 + 1).equals(stringArray[i])) continue;
                arrayList.add(tDriverStructRecord.FullID);
            }
            for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
                tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
                if (!tDriverStructRecord.FullID.startsWith("CONSOLIDATEDHORZDRIVERTOTAL")) continue;
                if (tDriverStructRecord.FullID.equals(stringArray[i])) {
                    arrayList.add(tDriverStructRecord.FullID);
                    continue;
                }
                n2 = tDriverStructRecord.FullID.indexOf("_");
                if (n2 < 0 || !tDriverStructRecord.FullID.substring(n2 + 1).equals(stringArray[i])) continue;
                arrayList.add(tDriverStructRecord.FullID);
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray2[n] = (String)arrayList.get(n);
        }
        return stringArray2;
    }

    @Override
    public int getRecordCount() {
        if (this.arKeyCollection == null) {
            return 0;
        }
        return this.arKeyCollection.getKeyCollectionCount();
    }

    @Override
    public boolean isDeleted(int n, StringBuilder stringBuilder) {
        return false;
    }

    @Override
    public boolean isInFilter(int n, StringBuilder stringBuilder) {
        TKeyCollection.TKeyCombination tKeyCombination = this.arKeyCollection.getKeyAtIndex(n);
        return super.isInFilter(n, stringBuilder);
    }

    public int getEmbeddedDriverRecord(TDriverStructRecord tDriverStructRecord, int n) {
        TKeyCollection.TKeyCombination tKeyCombination = this.arKeyCollection.getKeyAtIndex(n);
        if (tKeyCombination == null) {
            return -1;
        }
        if (tDriverStructRecord.FullID.toUpperCase().startsWith("__CONSOLIDATEDHORZDRIVER__")) {
            return -1;
        }
        if (tDriverStructRecord.FullID.startsWith("CONSOLIDATEDHORZDRIVERTOTAL")) {
            return -1;
        }
        if (tDriverStructRecord.FullID.startsWith("CONSOLIDATEDHORZDRIVERFIELD")) {
            int n2 = tDriverStructRecord.HorzConsolidateDriverNum;
            TEmbeddedDriver tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(n2);
            TKeyCollection.TKeyCombination tKeyCombination2 = tEmbeddedDriver.getKeyCollection().getKeyCombination(tKeyCombination);
            if (tKeyCombination2 != null) {
                return tKeyCombination2.Index;
            }
            return -1;
        }
        return -1;
    }

    public TFormulaEvaluator getFormulaEvaluator(TDriverStructRecord tDriverStructRecord, int n) {
        int n2;
        TEmbeddedDriver tEmbeddedDriver;
        if (tDriverStructRecord.FullID.toUpperCase().startsWith("__CONSOLIDATEDHORZDRIVER__")) {
            return null;
        }
        if (tDriverStructRecord.FullID.startsWith("CONSOLIDATEDHORZDRIVERTOTAL")) {
            return null;
        }
        if (tDriverStructRecord.FullID.startsWith("CONSOLIDATEDHORZDRIVERFIELD") && (tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(n2 = tDriverStructRecord.HorzConsolidateDriverNum)) != null) {
            return tEmbeddedDriver.getFormulaEvaluator();
        }
        return null;
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        TKeyCollection.TKeyCombination tKeyCombination;
        boolean bl = false;
        if (bl) {
            System.out.println("----------------------------------------------------------");
        }
        if (bl) {
            System.out.println("getField ID=" + tDriverStructRecord.FullID + " Record=" + n);
        }
        if ((tKeyCombination = this.arKeyCollection.getKeyAtIndex(n)) == null) {
            if (bl) {
                System.out.print("Returning null because MasterKey is null");
            }
            if (bl) {
                System.out.println("----------------------------------------------------------");
            }
            return null;
        }
        if (tDriverStructRecord.FullID.toUpperCase().startsWith("__CONSOLIDATEDHORZDRIVER__")) {
            if (tDriverStructRecord.FullID.equalsIgnoreCase("__ConsolidatedHorzDriver__Record")) {
                if (bl) {
                    System.out.println("Returns " + n);
                }
                if (bl) {
                    System.out.println("----------------------------------------------------------");
                }
                return new Integer(n);
            }
        } else {
            if (tDriverStructRecord.FullID.startsWith("CONSOLIDATEDHORZDRIVERTOTAL")) {
                if (bl) {
                    System.out.println("Getting calculated field: " + tDriverStructRecord.Formula + " Record=" + n);
                }
                Object object = this.calculateField(tDriverStructRecord, n);
                if (bl) {
                    System.out.println("Calculation returns " + object);
                }
                if (bl) {
                    System.out.println("----------------------------------------------------------");
                }
                return object;
            }
            if (tDriverStructRecord.FullID.startsWith("CONSOLIDATEDHORZDRIVERFIELD")) {
                if (bl) {
                    System.out.println("MasterKey=" + tKeyCombination.toString());
                }
                int n2 = tDriverStructRecord.HorzConsolidateDriverNum;
                TEmbeddedDriver tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(n2);
                String string = tDriverStructRecord.FullID.substring(tDriverStructRecord.FullID.indexOf("_") + 1);
                TKeyCollection.TKeyCombination tKeyCombination2 = tEmbeddedDriver.getKeyCollection().getKeyCombination(tKeyCombination);
                if (tKeyCombination2 != null) {
                    TDriverStructRecord tDriverStructRecord2;
                    if (bl) {
                        System.out.println("EmbeddedKey=" + tKeyCombination2.toString());
                    }
                    String string2 = tEmbeddedDriver.getEmbeddedFieldID(string);
                    if (bl) {
                        System.out.println("EmbeddedFieldID=" + string2);
                    }
                    if ((tDriverStructRecord2 = tEmbeddedDriver.driver.DriverStruct.getField(string2)) != null) {
                        if (bl) {
                            System.out.println("EmbeddedDSRec.FullID=" + tDriverStructRecord2.FullID + " Index=" + tKeyCombination2.Index);
                        }
                        if (bl) {
                            System.out.println("Returns " + tEmbeddedDriver.getField(tDriverStructRecord2, tKeyCombination2.Index));
                        }
                        if (bl) {
                            System.out.println("----------------------------------------------------------");
                        }
                        return tEmbeddedDriver.getField(tDriverStructRecord2, tKeyCombination2.Index);
                    }
                    if (bl) {
                        System.out.println("EmbeddedDSRec=null.  Returning null.");
                    }
                    if (bl) {
                        System.out.println("----------------------------------------------------------");
                    }
                    return null;
                }
                if (bl) {
                    System.out.println("EmbeddedKey=null.  Returning 0.");
                }
                if (bl) {
                    System.out.println("----------------------------------------------------------");
                }
                if (objectutil.isNumberField(tDriverStructRecord.FieldType)) {
                    return new Double(0.0);
                }
                if (bl) {
                    System.out.println("Returning null.");
                }
                if (bl) {
                    System.out.println("----------------------------------------------------------");
                }
                return null;
            }
        }
        if (bl) {
            System.out.println("Returning key field value: " + tKeyCombination.getField(tDriverStructRecord.FullID));
        }
        if (bl) {
            System.out.println("----------------------------------------------------------");
        }
        return tKeyCombination.getField(tDriverStructRecord.FullID);
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        TKeyCollection.TKeyCombination tKeyCombination = this.arKeyCollection.getKeyAtIndex(n);
        if (tKeyCombination == null) {
            return 0;
        }
        System.out.println("ConsHorz putField ID=" + tDriverStructRecord.FullID + " Record=" + n + " Value=" + object.toString());
        if (tDriverStructRecord.FullID.startsWith("CONSOLIDATEDHORZDRIVERFIELD")) {
            int n2 = tDriverStructRecord.HorzConsolidateDriverNum;
            System.out.println("ConsHorz DriverNumber=" + n2);
            TEmbeddedDriver tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(n2);
            String string = tDriverStructRecord.FullID.substring(tDriverStructRecord.FullID.indexOf("_") + 1);
            System.out.println("ConsHorz FieldID=" + string);
            TKeyCollection.TKeyCombination tKeyCombination2 = tEmbeddedDriver.getKeyCollection().getKeyCombination(tKeyCombination);
            if (tKeyCombination2 != null) {
                String string2 = tEmbeddedDriver.getEmbeddedFieldID(string);
                System.out.println("ConsHorz EmbeddedFieldID=" + string2);
                TDriverStructRecord tDriverStructRecord2 = tEmbeddedDriver.driver.DriverStruct.getField(string2);
                if (tDriverStructRecord2 != null) {
                    System.out.println("ConsHorz EmbeddedDSRec ID=" + tDriverStructRecord2.FullID + " Index=" + tKeyCombination2.Index);
                    return tEmbeddedDriver.putField(tDriverStructRecord2, tKeyCombination2.Index, object);
                }
                System.out.println("ConsHorz EmbeddedDSRec is null");
            } else {
                System.out.println("ConsHorz EmbeddedKey=null");
            }
        }
        return 0;
    }
}

