/*
 * Decompiled with CFR 0.152.
 */
package drivers.consolidated;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStructRecord;
import drivers.consolidated.TKeyCollection;
import java.util.Hashtable;
import resources.TAppDriversObject;
import utility.TFormulaEvaluator;
import utility.charutil;

public class TEmbeddedDriver {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTConsolidatedEmbeddedDriver");
    TAbstractDriver driver = null;
    TKeyCollection KeyCollection = null;
    String DriverName = "";
    private String AliasFields = "";
    private String FieldList = "";
    private String strFilter = "";
    int DriverNumber = 0;
    Hashtable hashEmbeddedIDLookup = null;
    Hashtable hashConsolidatedIDLookup = null;
    String[] arIncludedFields = null;
    boolean InclusiveMode = true;

    TEmbeddedDriver(int n, TDriverInterface tDriverInterface, String string, String string2, String string3) {
        this.DriverNumber = n;
        if (((TAbstractDriver)tDriverInterface).AppDriversObject != null) {
            this.DriverName = ((TAbstractDriver)tDriverInterface).AppDriversObject.Description.toString();
        }
        this.AliasFields = string;
        this.FieldList = string2;
        this.driver = (TAbstractDriver)tDriverInterface;
        this.strFilter = string3;
        this.initialize();
    }

    public void dispose() {
        this.driver.dispose();
        if (this.KeyCollection != null) {
            this.KeyCollection.dispose();
        }
    }

    private void initialize() {
        if (this.AliasFields != null && this.AliasFields.length() > 0) {
            this.hashEmbeddedIDLookup = new Hashtable();
            this.hashConsolidatedIDLookup = new Hashtable();
            String[] stringArray = charutil.getSubStringArray(this.AliasFields, '|', true);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', true);
                    if (stringArray2 == null || stringArray2.length <= 1) continue;
                    this.hashEmbeddedIDLookup.put(stringArray2[0].toUpperCase(), stringArray2[1]);
                    this.hashConsolidatedIDLookup.put(stringArray2[1].toUpperCase(), stringArray2[0]);
                }
            }
        }
        if (this.FieldList != null && this.FieldList.length() > 0) {
            this.arIncludedFields = charutil.getSubStringArray(this.FieldList, '|', true);
            if (this.arIncludedFields != null) {
                for (int i = 0; i < this.arIncludedFields.length; ++i) {
                    if (!this.arIncludedFields[i].startsWith("-")) continue;
                    this.arIncludedFields[i] = this.arIncludedFields[i].substring(1);
                    this.InclusiveMode = false;
                }
            }
        }
    }

    public boolean isIncludedField(String string) {
        if (this.arIncludedFields == null || this.arIncludedFields.length == 0) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < this.arIncludedFields.length; ++i) {
            if (!this.arIncludedFields[i].equalsIgnoreCase(string)) continue;
            bl = true;
        }
        return this.InclusiveMode ? bl : !bl;
    }

    public String getEmbeddedFieldID(String string) {
        if (this.hashEmbeddedIDLookup == null) {
            return string;
        }
        Object v = this.hashEmbeddedIDLookup.get(string.toUpperCase());
        if (v == null) {
            return string;
        }
        return (String)v;
    }

    public String getConsolidatedFieldID(String string) {
        if (this.hashConsolidatedIDLookup == null) {
            return string;
        }
        Object v = this.hashConsolidatedIDLookup.get(string.toUpperCase());
        if (v == null) {
            return string;
        }
        return (String)v;
    }

    public TKeyCollection getKeyCollection() {
        return this.KeyCollection;
    }

    public void updateKeyCollection(String[] stringArray) {
        if (this.KeyCollection == null) {
            this.KeyCollection = new TKeyCollection(stringArray);
        } else {
            this.KeyCollection.clear();
        }
        TDriverStructRecord[] tDriverStructRecordArray = new TDriverStructRecord[stringArray.length];
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            tDriverStructRecordArray[i] = this.driver.DriverStruct.getField(stringArray[i]);
            if (tDriverStructRecordArray[i] != null) continue;
            MainWin.appendToLog("TEmbeddedDriver", "updateKeyCollection", Thread.currentThread(), null, 4, "Cannot locate field in structure for key: " + stringArray[i]);
        }
        StringBuilder stringBuilder = new StringBuilder("true");
        for (int i = 0; i < this.getRecordCount(); ++i) {
            if (!this.isInFilter(i, stringBuilder)) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                objectArray[j] = this.driver.getField(tDriverStructRecordArray[j], i);
            }
            this.KeyCollection.addKey(objectArray, i);
        }
    }

    public TFormulaEvaluator getFormulaEvaluator() {
        return this.driver.getFormulaEvaluator();
    }

    public String getDriverParams() {
        return this.driver.getDriverParams();
    }

    public String getDriverDescription() {
        String string = charutil.getParamValue(this.getDriverParams(), "Description", '|');
        String string2 = charutil.getParamValue(this.getDriverParams(), "SetName", '|');
        if (string2.length() > 0) {
            if (string.length() > 0) {
                string = string + "\\";
            }
            string = string + string2;
        }
        if (this.getDriverParams().toUpperCase().indexOf("DESCRIPTION=") < 0) {
            TAppDriversObject tAppDriversObject;
            if (string.length() == 0 && (tAppDriversObject = this.driver.getAppDriversObject()) != null) {
                string = tAppDriversObject.Description.toString();
            }
            if (string.length() == 0) {
                string = "Driver " + Integer.toString(this.DriverNumber);
            }
        }
        return string;
    }

    public int getDriverNumber() {
        return this.DriverNumber;
    }

    public int getRecordCount() {
        return this.driver.getRecordCount();
    }

    public boolean isInFilter(int n, StringBuilder stringBuilder) {
        if (this.driver.isInFilter(n, stringBuilder)) {
            if (this.strFilter.length() > 0) {
                return this.driver.isInFilter(n, this.strFilter);
            }
            return true;
        }
        return false;
    }

    public boolean isDeleted(int n, StringBuilder stringBuilder) {
        if (this.driver == null) {
            return false;
        }
        return this.driver.isDeleted(n, stringBuilder);
    }

    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (this.driver == null) {
            return null;
        }
        return this.driver.getField(tDriverStructRecord, n);
    }

    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        if (this.driver == null) {
            return 0;
        }
        return this.driver.putField(tDriverStructRecord, n, object);
    }

    public TComboBoxColl getComboBoxColl(String string, StringBuilder stringBuilder, TFormulaEvaluator tFormulaEvaluator, boolean bl, boolean bl2, int n) {
        if (this.driver == null) {
            return null;
        }
        return this.driver.getComboBoxColl(string, stringBuilder, tFormulaEvaluator, bl, bl2, n);
    }

    public TComboBoxColl getComboBoxColl(String string, String string2, TFormulaEvaluator tFormulaEvaluator, boolean bl, int n) {
        if (this.driver == null) {
            return null;
        }
        return this.driver.getComboBoxColl(string, string2, tFormulaEvaluator, bl, n);
    }
}

