/*
 * Decompiled with CFR 0.152.
 */
package drivers.files;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TProgressBar;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.files.TBinaryBuffer;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.objectutil;

public class TAsciiCsvFile
extends TBinaryBuffer
implements TDriverInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = false;
    public String StructID;
    private char chDelimiter = (char)44;

    public TAsciiCsvFile(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) throws IOException {
        super(tApplication, tAppDriversObject, n, bl);
        this.PerformanceMark.ClassName = "TAsciiCSVFile";
        this.StructID = tAppDriversObject.StructureIndex.toString();
        switch (this.AppDriversObject.Delimiter) {
            case 0: {
                this.chDelimiter = (char)44;
                break;
            }
            case 1: {
                this.chDelimiter = (char)124;
                break;
            }
            case 2: {
                this.chDelimiter = (char)9;
                break;
            }
            case 3: {
                this.chDelimiter = (char)61;
                break;
            }
            case 4: {
                this.chDelimiter = (char)32;
                break;
            }
            case 5: {
                this.chDelimiter = (char)126;
                break;
            }
            case 6: {
                this.chDelimiter = (char)94;
                break;
            }
            case 7: {
                this.chDelimiter = (char)96;
            }
        }
        if (this.Debug) {
            MainWin.appendToLog("TAsciiCsvFile", "<init>", Thread.currentThread(), null, 10, "Opening " + this.AppDriversObject.Description + " (" + this.AppDriversObject.FileName + ")");
        }
    }

    @Override
    public int makeEditableFile() throws IOException {
        TAsciiInput tAsciiInput;
        String string;
        TProgressBar tProgressBar = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        dosutil.formatURL(stringBuilder, new StringBuilder(this.FileName));
        String string2 = stringBuilder.toString();
        URL uRL = new URL(stringBuilder.toString());
        this.IsLocal = false;
        this.IsWriteable = true;
        if (charutil.strcmpi(uRL.getProtocol(), "FILE") == 0) {
            this.IsLocal = true;
        }
        if ((string = string2.toUpperCase()).indexOf(".ZIP") >= 0 || string.indexOf(".JAR") >= 0) {
            this.IsWriteable = false;
        }
        if ((tAsciiInput = new TAsciiInput(string2, this.chDelimiter, true)).isValid()) {
            String string3 = "Reading text file: " + this.FileName;
            if (!Thread.currentThread().getName().equals("TDriverServerSocket")) {
                // empty if block
            }
            long l = 0L;
            while (tAsciiInput.get_string(stringBuilder) > 0) {
                l += (long)stringBuilder.length();
                Thread.yield();
                ++n2;
                if (this.chDelimiter == ' ') {
                    charutil.trimstr(stringBuilder, stringBuilder);
                    charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "  ", " ");
                }
                String[] stringArray = this.AppDriversObject.DriverID.toString().equalsIgnoreCase("INVESTING_GENERIC_ASCII_FILE") ? new String[]{stringBuilder.toString()} : charutil.getSubStringArray(stringBuilder, this.chDelimiter, true);
                int n3 = 0;
                block22: for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
                    Object object;
                    TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                    if (tDriverStructRecord.IsVirtual) continue;
                    if (stringArray != null && n3 < stringArray.length) {
                        switch (tDriverStructRecord.FieldType) {
                            case 10: {
                                object = dateutil.parseDate(stringArray[n3]);
                                break;
                            }
                            case 18: {
                                object = dateutil.parseTime(stringArray[n3]);
                                break;
                            }
                            case 13: {
                                object = dateutil.parseDateTime(stringArray[n3]);
                                break;
                            }
                            case 21: {
                                object = dateutil.parseDateTime(stringArray[n3]);
                                if (stringArray[n3].indexOf("1969") >= 0 || ((Date)object).getTime() != 0L) break;
                                System.out.println("Cannot parse date for fieldID: " + tDriverStructRecord.ID + " Line=" + n2 + " Obj=[" + stringArray[n3] + "]");
                                break;
                            }
                            default: {
                                object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, stringArray[n3], n);
                            }
                        }
                        ++n3;
                    } else {
                        object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, "", n);
                    }
                    switch (tDriverStructRecord.FieldType) {
                        case 19: {
                            this.putBoolean(n, tDriverStructRecord.Offset, (Boolean)object);
                            continue block22;
                        }
                        case 1: {
                            this.putBool(n, tDriverStructRecord.Offset, (Boolean)object);
                            continue block22;
                        }
                        case 25: {
                            this.putBoolYN(n, tDriverStructRecord.Offset, (Boolean)object);
                            continue block22;
                        }
                        case 2: {
                            this.putByte(n, tDriverStructRecord.Offset, ((Integer)object).byteValue());
                            continue block22;
                        }
                        case 3: 
                        case 11: 
                        case 15: 
                        case 20: 
                        case 24: 
                        case 26: {
                            this.putChars(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                            continue block22;
                        }
                        case 22: {
                            this.putBinaryData(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                            continue block22;
                        }
                        case 4: 
                        case 5: {
                            this.putShort(n, tDriverStructRecord.Offset, ((Integer)object).shortValue());
                            continue block22;
                        }
                        case 6: 
                        case 7: {
                            this.putInt(n, tDriverStructRecord.Offset, (Integer)object);
                            continue block22;
                        }
                        case 8: {
                            this.putFloat(n, tDriverStructRecord.Offset, ((Float)object).floatValue());
                            continue block22;
                        }
                        case 9: 
                        case 12: {
                            this.putDouble(n, tDriverStructRecord.Offset, (Double)object);
                            continue block22;
                        }
                        case 10: 
                        case 13: 
                        case 18: {
                            gregorianCalendar.setTime((Date)object);
                            this.putDate(n, tDriverStructRecord.Offset, gregorianCalendar);
                            continue block22;
                        }
                        case 21: {
                            gregorianCalendar.setTime((Date)object);
                            this.putLong(n, tDriverStructRecord.Offset, gregorianCalendar.getTimeInMillis());
                            continue block22;
                        }
                        case 16: {
                            this.putByte(n, tDriverStructRecord.Offset, (byte)0);
                            continue block22;
                        }
                        default: {
                            System.out.println("Error in makeEditableFile.  FieldType=" + tDriverStructRecord.FieldType);
                        }
                    }
                }
                if (tProgressBar != null) {
                    tProgressBar.increment();
                }
                ++n;
            }
            if (tProgressBar != null) {
                tProgressBar.dispose();
            }
        }
        tAsciiInput.dispose();
        if (this.Debug) {
            MainWin.appendToLog("TAsciiCsvFile", "makeEditableFile", Thread.currentThread(), null, 10, "Buffer is initialized with " + this.getRecordCount() + " records");
        }
        return 0;
    }

    @Override
    public int updateSourceFile() {
        if (this.Modified) {
            TAsciiCsvFile.exportFile(this, this.getFileName(), this.DriverStruct, false, false, false, false, this.AppDriversObject.Delimiter);
        }
        return 0;
    }

    @Override
    public boolean verifySaveChanges() {
        int n = Aspect.MainWin.showConfirmDialog(null, "Save changes to " + this.AppDriversObject.Description + "?", "Confirm...", 0);
        return n == 0;
    }

    @Override
    public ArrayList getSupportedDriverCommands() {
        ArrayList arrayList = super.getSupportedDriverCommands();
        if (this.isLocal() && this.isWriteable()) {
            arrayList.add("/drivercmd/core/TDriverCmdSaveChangesNow.class");
        }
        return arrayList;
    }

    public static String exportFile(TDriverInterface tDriverInterface, String string, TDriverStruct tDriverStruct, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        TDriverStructRecord tDriverStructRecord;
        int n2;
        TProgressBar tProgressBar = null;
        StringBuilder stringBuilder = new StringBuilder();
        char c = ',';
        String string2 = "ok";
        switch (n) {
            case 0: {
                c = ',';
                break;
            }
            case 1: {
                c = '|';
                break;
            }
            case 2: {
                c = '\t';
                break;
            }
            case 3: {
                c = '=';
            }
        }
        TAsciiOutput tAsciiOutput = new TAsciiOutput(string, c, false);
        TDriverStruct tDriverStruct2 = tDriverInterface.getDriverStruct();
        if (tDriverStruct == null) {
            tDriverStruct = tDriverStruct2;
        }
        if (bl) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                tAsciiOutput.writeString(tDriverStructRecord.Description, true);
            }
            tAsciiOutput.write_crlf();
        }
        if (bl2) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                tAsciiOutput.writeString(tDriverStructRecord.FullID, true);
            }
            tAsciiOutput.write_crlf();
        }
        if (bl3) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                tAsciiOutput.writeString(TAbstractDriver.getFieldTypeName(tDriverStructRecord.FieldType), false);
            }
            tAsciiOutput.write_crlf();
        }
        ArrayList arrayList = tDriverStruct.getAssociatedRecords(tDriverStruct2);
        int n3 = tDriverInterface.getRecordCount();
        if (!TMainWin.IsClosing) {
            tProgressBar = new TProgressBar("Saving changes...", n3, 750);
        }
        long l = 0L;
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                int n4 = (Integer)arrayList.get(n2);
                if (n4 >= 0) {
                    TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)tDriverStruct2.FieldColl.get(n4);
                    Object object = tDriverInterface.getField(tDriverStructRecord2, i);
                    l += (long)tDriverStructRecord2.DataSize;
                    if (object != null) {
                        switch (tDriverStructRecord2.FieldType) {
                            case 1: 
                            case 19: 
                            case 25: {
                                tAsciiOutput.writeString(((Boolean)object).toString(), false);
                                break;
                            }
                            case 2: {
                                tAsciiOutput.writeString(((Integer)object).toString(), false);
                                break;
                            }
                            case 3: 
                            case 11: 
                            case 15: 
                            case 24: {
                                tAsciiOutput.writeString((String)object, true);
                                break;
                            }
                            case 26: {
                                String string3 = (String)object;
                                if (string3.trim().length() > 0) {
                                    string3 = charutil.encrypt(string3, "");
                                }
                                tAsciiOutput.writeString(string3, true);
                                break;
                            }
                            case 22: {
                                tAsciiOutput.writeString((String)object, true);
                                break;
                            }
                            case 4: 
                            case 5: {
                                tAsciiOutput.writeString(((Integer)object).toString(), false);
                                break;
                            }
                            case 6: 
                            case 7: {
                                tAsciiOutput.writeString(((Integer)object).toString(), false);
                                break;
                            }
                            case 8: {
                                tAsciiOutput.writeString(((Float)object).toString(), false);
                                break;
                            }
                            case 9: 
                            case 12: {
                                tAsciiOutput.writeString(((Double)object).toString(), false);
                                break;
                            }
                            case 21: {
                                String string4 = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:SS").format((Date)object);
                                tAsciiOutput.writeString(string4, false);
                                break;
                            }
                            case 13: {
                                String string4 = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss").format((Date)object);
                                tAsciiOutput.writeString(string4, false);
                                break;
                            }
                            case 18: {
                                String string4 = new SimpleDateFormat("HH:mm:ss").format((Date)object);
                                tAsciiOutput.writeString(string4, false);
                                break;
                            }
                            case 10: {
                                String string4 = new SimpleDateFormat("MM-dd-yyyy").format((Date)object);
                                tAsciiOutput.writeString(string4, false);
                                break;
                            }
                            default: {
                                tAsciiOutput.writeString("Error", false);
                                break;
                            }
                        }
                        continue;
                    }
                    tAsciiOutput.writeString("Error", false);
                    continue;
                }
                tAsciiOutput.writeString("", false);
            }
            tAsciiOutput.write_crlf();
            if (tProgressBar == null) continue;
            tProgressBar.increment();
        }
        tAsciiOutput.dispose();
        if (tProgressBar != null) {
            tProgressBar.dispose();
        }
        return string2;
    }
}

