/*
 * Decompiled with CFR 0.152.
 */
package drivers.files;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStructRecord;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import performance.TPerformanceFileMark;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.objectutil;

public class TBinaryBuffer
extends TAbstractDriver
implements TDriverInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTBinaryBuffer");
    public byte[] arBuffer = null;
    private GregorianCalendar calendar = new GregorianCalendar();
    public int cRecords = 0;
    private Hashtable hashedFields = new Hashtable();
    private boolean HashEmpty = true;
    private int RecsToAllocate = 100;

    public TBinaryBuffer(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        switch (n) {
            case 0: {
                this.IsWriteable = false;
                break;
            }
            case 1: {
                this.IsWriteable = true;
            }
        }
        this.PerformanceMark = new TPerformanceFileMark("TBinaryBuffer", this.AppDriversObject.DriverID.toString(), this.AppDriversObject.FileName.toString(), this.AppDriversObject.DriverParams);
        TFormulaEvaluator.Performance.addMark(this.PerformanceMark);
        this.arBuffer = new byte[this.RecordSize];
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.clearBuffer();
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public synchronized int makeEditableFile() throws IOException {
        return 0;
    }

    @Override
    public synchronized int updateSourceFile() {
        return 0;
    }

    @Override
    public synchronized boolean verifySaveChanges() {
        return true;
    }

    @Override
    public synchronized void f_create() {
        this.arBuffer = new byte[0];
        this.cRecords = 0;
        this.clearBuffer();
    }

    @Override
    public synchronized int getRecordCount() {
        return this.cRecords;
    }

    @Override
    public synchronized int initializeNewRecord(boolean bl) {
        if (this.arBuffer == null) {
            return -1;
        }
        int n = (this.cRecords + 1) * this.RecordSize;
        if (n >= this.arBuffer.length) {
            this.arBuffer = (byte[])charutil.arrayGrow(this.arBuffer, (this.cRecords + this.RecsToAllocate) * this.RecordSize);
        }
        int n2 = super.initializeNewRecord(bl);
        this.cRecords = Math.max(this.cRecords, n2 + 1);
        return n2;
    }

    public synchronized int writeBufferToFile(String string, boolean bl) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rwd");
            if (bl) {
                randomAccessFile.seek(randomAccessFile.length());
            }
            randomAccessFile.write(this.arBuffer, 0, this.getRecordCount() * this.RecordSize);
            randomAccessFile.close();
            return 1;
        }
        catch (Exception exception) {
            MainWin.appendToLog("TBinaryBuffer", "writeBufferToFile", Thread.currentThread(), exception, 4, "Error writing file:" + string);
            return 0;
        }
    }

    public synchronized int getReadOffset(int n, int n2) {
        return n * this.RecordSize + n2;
    }

    public synchronized int getWriteOffset(int n, int n2) {
        int n3 = this.getReadOffset(n, n2);
        if (n3 >= this.arBuffer.length) {
            this.arBuffer = (byte[])charutil.arrayGrow(this.arBuffer, (n + this.RecsToAllocate) * this.RecordSize);
        }
        if (n >= this.cRecords) {
            this.cRecords = n + 1;
        }
        return n3;
    }

    @Override
    public synchronized void clearBuffer() {
        this.hashedFields.clear();
        this.HashEmpty = true;
    }

    @Override
    public synchronized Object getField(String string, int n) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public synchronized Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (tDriverStructRecord == null) {
            return null;
        }
        Object object = null;
        String string = null;
        if (tDriverStructRecord.IsToken) {
            StringBuilder stringBuilder = new StringBuilder();
            TMainWin.Application.getTokenValue(stringBuilder, tDriverStructRecord.ID);
            object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, stringBuilder.toString(), 0);
            return object;
        }
        ++this.PerformanceMark.cRead;
        if (!tDriverStructRecord.IsCalculated) {
            this.PerformanceMark.cReadBytes += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        }
        Date date = new Date();
        if (this.BufferOn && (object = this.hashedFields.get(string = Integer.toString(n) + "|" + tDriverStructRecord.FullID)) != null) {
            ++this.PerformanceMark.cCached;
            this.PerformanceMark.cReadMs = (int)((long)this.PerformanceMark.cReadMs + (new Date().getTime() - date.getTime()));
            return object;
        }
        if (n >= this.getRecordCount()) {
            return null;
        }
        if (!tDriverStructRecord.IsVirtual && !tDriverStructRecord.IsCalculated) {
            switch (tDriverStructRecord.FieldType) {
                case 1: {
                    object = new Boolean(this.getBool(n, tDriverStructRecord.Offset));
                    break;
                }
                case 2: {
                    object = new Integer(charutil.unsignedByteToInt(this.getByte(n, tDriverStructRecord.Offset)));
                    break;
                }
                case 3: 
                case 24: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getChars(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 26: {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = new String(this.getChars(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    if (string2 != null && string2.trim().length() > 0) {
                        string2 = charutil.decrypt(string2, "");
                    }
                    object = string2;
                    break;
                }
                case 22: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getBinaryData(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 4: {
                    object = new Integer(this.getShort(n, tDriverStructRecord.Offset));
                    break;
                }
                case 5: {
                    object = new Integer(charutil.unsignedShortToInt(this.getShort(n, tDriverStructRecord.Offset)));
                    break;
                }
                case 6: {
                    object = new Integer(this.getInt(n, tDriverStructRecord.Offset));
                    break;
                }
                case 7: {
                    object = new Integer(this.getInt(n, tDriverStructRecord.Offset));
                    break;
                }
                case 8: {
                    object = new Float(this.getFloat(n, tDriverStructRecord.Offset));
                    break;
                }
                case 9: {
                    object = new Double(this.getDouble(n, tDriverStructRecord.Offset));
                    break;
                }
                case 10: 
                case 13: 
                case 18: {
                    GregorianCalendar gregorianCalendar = this.getDate(n, tDriverStructRecord.Offset);
                    object = new Date(gregorianCalendar.getTimeInMillis());
                    break;
                }
                case 21: {
                    object = new Date(this.getLong(n, tDriverStructRecord.Offset));
                    break;
                }
                case 11: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getPString(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 12: {
                    object = new Double(this.getReal(n, tDriverStructRecord.Offset));
                    break;
                }
                case 15: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getPString(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 19: {
                    object = new Boolean(this.getBoolean(n, tDriverStructRecord.Offset));
                    break;
                }
                case 25: {
                    object = new Boolean(this.getBoolYN(n, tDriverStructRecord.Offset));
                    break;
                }
                case 20: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getChars(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 16: {
                    int n2;
                    byte by = this.getByte(n, tDriverStructRecord.Offset);
                    int n3 = by & 0x7F;
                    if (by < 0) {
                        n3 |= 0x80;
                    }
                    if ((n3 & 1 << (n2 = tDriverStructRecord.ArrayIndex % 8)) > 0) {
                        object = new Boolean("true");
                        break;
                    }
                    object = new Boolean("false");
                    break;
                }
                default: {
                    object = new String("Error");
                }
            }
        }
        if (tDriverStructRecord.IsCalculated) {
            object = this.calculateField(tDriverStructRecord, n);
        }
        if (this.BufferOn && object != null && !tDriverStructRecord.NoBuffer) {
            if (this.hashedFields.size() > 40000) {
                this.hashedFields.clear();
            }
            this.hashedFields.put(string, object);
            this.HashEmpty = false;
        }
        ++this.PerformanceMark.cCached;
        this.PerformanceMark.cReadMs = (int)((long)this.PerformanceMark.cReadMs + (new Date().getTime() - date.getTime()));
        return object;
    }

    @Override
    public synchronized Object getFieldForTable(TDriverStructRecord tDriverStructRecord, int n) {
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public synchronized int putField(String string, int n, Object object) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.putField(tDriverStructRecord, n, object);
    }

    @Override
    public synchronized int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        if (tDriverStructRecord.IsToken) {
            String string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
            TMainWin.Application.setTokenValue(tDriverStructRecord.ID, string);
            return 1;
        }
        if (tDriverStructRecord.IsVirtual) {
            return 0;
        }
        if (object == null) {
            return 0;
        }
        ++this.PerformanceMark.cWrite;
        this.PerformanceMark.cWriteBytes += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        Date date = new Date();
        Object object2 = this.getField(tDriverStructRecord, n);
        this.recordUndoEvent(tDriverStructRecord, n, object2, object);
        switch (tDriverStructRecord.FieldType) {
            case 1: {
                this.putBool(n, tDriverStructRecord.Offset, (Boolean)object);
                break;
            }
            case 2: {
                this.putByte(n, tDriverStructRecord.Offset, ((Integer)object).byteValue());
                break;
            }
            case 3: 
            case 24: {
                if (!(object instanceof String)) {
                    System.out.println("Class cast error writing field: " + tDriverStructRecord.FullID);
                    break;
                }
                this.putChars(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                break;
            }
            case 26: {
                if (!(object instanceof String)) {
                    System.out.println("Class cast error writing field: " + tDriverStructRecord.FullID);
                    break;
                }
                String string = (String)object;
                if (string.trim().length() > 0) {
                    string = charutil.encrypt(string, "");
                }
                this.putChars(n, tDriverStructRecord.Offset, string, tDriverStructRecord.ArraySize);
                break;
            }
            case 22: {
                this.putBinaryData(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                break;
            }
            case 4: 
            case 5: {
                if (!(object instanceof Integer)) {
                    System.out.println("Class cast error writing field: " + tDriverStructRecord.FullID);
                    break;
                }
                this.putShort(n, tDriverStructRecord.Offset, ((Integer)object).shortValue());
                break;
            }
            case 6: 
            case 7: {
                this.putInt(n, tDriverStructRecord.Offset, (Integer)object);
                break;
            }
            case 8: {
                if (object instanceof Double) {
                    this.putFloat(n, tDriverStructRecord.Offset, ((Double)object).floatValue());
                    break;
                }
                if (object instanceof Float) {
                    this.putFloat(n, tDriverStructRecord.Offset, ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Integer) {
                    this.putFloat(n, tDriverStructRecord.Offset, ((Integer)object).floatValue());
                    break;
                }
                if (!(object instanceof Short)) break;
                this.putFloat(n, tDriverStructRecord.Offset, ((Short)object).floatValue());
                break;
            }
            case 9: {
                this.putDouble(n, tDriverStructRecord.Offset, (Double)object);
                break;
            }
            case 10: 
            case 13: 
            case 18: {
                this.calendar.setTime((Date)object);
                this.putDate(n, tDriverStructRecord.Offset, this.calendar);
                break;
            }
            case 21: {
                this.putLong(n, tDriverStructRecord.Offset, ((Date)object).getTime());
                break;
            }
            case 11: 
            case 15: {
                this.putPString(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                break;
            }
            case 12: {
                this.putReal(n, tDriverStructRecord.Offset, (Double)object);
                break;
            }
            case 19: {
                this.putBoolean(n, tDriverStructRecord.Offset, (Boolean)object);
                break;
            }
            case 25: {
                this.putBoolYN(n, tDriverStructRecord.Offset, (Boolean)object);
                break;
            }
            case 20: {
                this.putChars(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                break;
            }
            case 16: {
                byte by = this.getByte(n, tDriverStructRecord.Offset);
                int n2 = by & 0x7F;
                if (by < 0) {
                    n2 |= 0x80;
                }
                int n3 = tDriverStructRecord.ArrayIndex % 8;
                n2 = ((Boolean)object).booleanValue() ? (n2 |= 1 << n3) : (n2 &= ~(1 << n3));
                by = (byte)(n2 & 0x7F);
                if ((n2 & 0x80) > 0) {
                    by = (byte)(by | 0x80);
                }
                this.putByte(n, tDriverStructRecord.Offset, by);
                break;
            }
            default: {
                System.out.println("Error in TBinaryBuffer.putField(" + tDriverStructRecord.FullID + ")");
            }
        }
        this.Modified = true;
        if (this.BufferOn && object != null && !tDriverStructRecord.NoBuffer) {
            if (this.hashedFields.size() > 20000) {
                this.hashedFields.clear();
            }
            String string = Integer.toString(n) + "|" + tDriverStructRecord.FullID;
            this.hashedFields.put(string, object);
            this.HashEmpty = false;
        }
        this.PerformanceMark.cWriteMs = (int)((long)this.PerformanceMark.cWriteMs + (new Date().getTime() - date.getTime()));
        return 1;
    }

    @Override
    public synchronized byte[] getRecord(int n) {
        byte[] byArray = new byte[this.RecordSize];
        System.arraycopy(this.arBuffer, n * this.RecordSize, byArray, 0, this.RecordSize);
        return byArray;
    }

    @Override
    public synchronized void putRecord(int n, byte[] byArray) {
        System.arraycopy(byArray, 0, this.arBuffer, n * this.RecordSize, byArray.length);
    }

    public synchronized boolean getBoolean(int n, int n2) {
        int n3 = this.getReadOffset(n, n2);
        byte by = this.arBuffer[n3];
        return by != 0;
    }

    public synchronized void putBoolean(int n, int n2, boolean bl) {
        int n3 = this.getWriteOffset(n, n2);
        this.arBuffer[n3] = bl ? (byte)1 : 0;
    }

    public synchronized boolean getBoolYN(int n, int n2) {
        int n3 = this.getReadOffset(n, n2);
        byte by = this.arBuffer[n3];
        return (char)by != 'N' && (char)by != 'n';
    }

    public synchronized void putBoolYN(int n, int n2, boolean bl) {
        int n3 = 78;
        if (bl) {
            n3 = 89;
        }
        int n4 = this.getWriteOffset(n, n2);
        this.arBuffer[n4] = (byte)n3;
    }

    public synchronized boolean getBool(int n, int n2) {
        short s = this.getShort(n, n2);
        return s != 0;
    }

    public synchronized void putBool(int n, int n2, boolean bl) {
        if (bl) {
            this.putShort(n, n2, (short)1);
        } else {
            this.putShort(n, n2, (short)0);
        }
    }

    public synchronized byte getByte(int n, int n2) {
        int n3 = this.getReadOffset(n, n2);
        return this.arBuffer[n3];
    }

    public synchronized void putByte(int n, int n2, byte by) {
        int n3 = this.getWriteOffset(n, n2);
        this.arBuffer[n3] = by;
    }

    public synchronized String getChars(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4 = this.getReadOffset(n, n2);
        String string = new String(this.arBuffer, n4, n3);
        int n5 = string.indexOf(0);
        if (n5 >= 0) {
            string = string.substring(0, n5);
        }
        return string;
    }

    public synchronized void putChars(int n, int n2, String string, int n3) {
        if (string == null) {
            return;
        }
        int n4 = string.length();
        int n5 = this.getWriteOffset(n, n2);
        for (int i = 0; i < n3; ++i) {
            this.arBuffer[n5 + i] = 0;
            if (i >= n4) continue;
            this.arBuffer[n5 + i] = (byte)string.charAt(i);
        }
    }

    public synchronized String getBinaryData(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4 = this.getReadOffset(n, n2);
        int n5 = 0;
        stringBuilder.setLength(0);
        int n6 = n4;
        while (n5 < n3) {
            stringBuilder.append((char)this.arBuffer[n6]);
            ++n5;
            ++n6;
        }
        return stringBuilder.toString();
    }

    public synchronized void putBinaryData(int n, int n2, String string, int n3) {
        if (string == null) {
            return;
        }
        int n4 = string.length();
        int n5 = this.getWriteOffset(n, n2);
        for (int i = 0; i < n3 - 1; ++i) {
            this.arBuffer[n5 + i] = 0;
            this.arBuffer[n5 + i] = i < n4 ? (byte)string.charAt(i) : (byte)0;
        }
    }

    public synchronized String getPString(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4 = this.getReadOffset(n, n2);
        int n5 = this.arBuffer[n4];
        if (n5 < 0) {
            n5 += 129;
        }
        if (n5 > n3 - 1) {
            n5 = n3 - 1;
        }
        String string = new String(this.arBuffer, n4 + 1, n5);
        charutil.strcpy(stringBuilder, string);
        return string;
    }

    public synchronized void putPString(int n, int n2, String string, int n3) {
        int n4;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = string.getBytes();
        int n5 = byArray2.length;
        byArray[0] = (byte)n3;
        if (n5 < n3) {
            byArray[0] = (byte)n5;
        }
        for (n4 = 1; n4 < n3; ++n4) {
            byArray[n4] = 0;
            if (n4 >= n5 + 1) continue;
            byArray[n4] = byArray2[n4 - 1];
        }
        n4 = this.getWriteOffset(n, n2);
        System.arraycopy(byArray, 0, this.arBuffer, n4, byArray.length);
    }

    public synchronized GregorianCalendar getDate(int n, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n3 = this.getReadOffset(n, n2);
        short s = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3);
        short s2 = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 2);
        short s4 = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 4);
        short s5 = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 6);
        short s6 = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 8);
        short s7 = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 10);
        if (s < 100) {
            s = s < 50 ? (short)(s + 2000) : (short)(s + 1900);
        }
        if (s < 0) {
            s = 0;
        }
        if (s2 > 0) {
            s2 = (short)(s2 - 1);
        }
        if (s2 > 11) {
            s2 = 0;
        }
        if (s2 < 0) {
            s2 = 0;
        }
        if (s4 < 1) {
            s4 = 1;
        }
        if (s5 > 23) {
            s5 = 0;
        }
        if (s5 < 0) {
            s5 = 0;
        }
        if (s6 > 59) {
            s6 = 0;
        }
        if (s6 < 0) {
            s6 = 0;
        }
        if (s7 > 59) {
            s7 = 0;
        }
        if (s7 < 0) {
            s7 = 0;
        }
        gregorianCalendar.setLenient(false);
        gregorianCalendar.clear();
        gregorianCalendar.set(s, s2, s4, s5, s6, s7);
        boolean bl = true;
        try {
            if (gregorianCalendar.get(1) > gregorianCalendar.getMaximum(1) || gregorianCalendar.get(1) < gregorianCalendar.getMinimum(1)) {
                bl = false;
            }
            if (gregorianCalendar.get(2) > gregorianCalendar.getMaximum(2) || gregorianCalendar.get(2) < gregorianCalendar.getMinimum(2)) {
                bl = false;
            }
            if (gregorianCalendar.get(5) > gregorianCalendar.getMaximum(5) || gregorianCalendar.get(5) < gregorianCalendar.getMinimum(5)) {
                bl = false;
            }
            if (gregorianCalendar.get(11) > gregorianCalendar.getMaximum(11) || gregorianCalendar.get(11) < gregorianCalendar.getMinimum(11)) {
                bl = false;
            }
            if (gregorianCalendar.get(12) > gregorianCalendar.getMaximum(12) || gregorianCalendar.get(12) < gregorianCalendar.getMinimum(12)) {
                bl = false;
            }
            if (gregorianCalendar.get(13) > gregorianCalendar.getMaximum(13) || gregorianCalendar.get(13) < gregorianCalendar.getMinimum(13)) {
                bl = false;
            }
        }
        catch (Exception exception) {
            gregorianCalendar.clear();
        }
        if (!bl) {
            gregorianCalendar.clear();
        }
        return gregorianCalendar;
    }

    public synchronized void putDate(int n, int n2, GregorianCalendar gregorianCalendar) {
        int n3 = this.getWriteOffset(n, n2);
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(n3);
            byteBuffer.putShort((short)gregorianCalendar.get(1));
            byteBuffer.putShort((short)(gregorianCalendar.get(2) + 1));
            byteBuffer.putShort((short)gregorianCalendar.get(5));
            byteBuffer.putShort((short)gregorianCalendar.get(11));
            byteBuffer.putShort((short)gregorianCalendar.get(12));
            byteBuffer.putShort((short)gregorianCalendar.get(13));
        }
        catch (Exception exception) {
            byte[] byArray = new byte[12];
            for (int i = 0; i < 12; ++i) {
                byArray[i] = 0;
            }
            System.arraycopy(byArray, 0, this.arBuffer, n3, byArray.length);
        }
    }

    public synchronized int getInt(int n, int n2) {
        int n3 = this.getReadOffset(n, n2);
        return ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt(n3);
    }

    public synchronized void putInt(int n, int n2, int n3) {
        int n4 = this.getWriteOffset(n, n2);
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(n4, n3);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public synchronized short getShort(int n, int n2) {
        int n3 = this.getReadOffset(n, n2);
        if (n3 >= this.arBuffer.length - 1) {
            System.out.println("error in getShort()");
            return 0;
        }
        return ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3);
    }

    public synchronized void putShort(int n, int n2, short s) {
        int n3 = this.getWriteOffset(n, n2);
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putShort(n3, s);
        }
        catch (Exception exception) {
            System.out.println("TBinaryFile.putShort: " + exception.toString());
        }
    }

    public synchronized long getLong(int n, int n2) {
        int n3 = this.getReadOffset(n, n2);
        return ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getLong(n3);
    }

    public synchronized void putLong(int n, int n2, long l) {
        int n3 = this.getWriteOffset(n, n2);
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putLong(n3, l);
        }
        catch (Exception exception) {
            System.out.println("TBinaryFile.putLong: " + exception.toString());
        }
    }

    public synchronized float getFloat(int n, int n2) {
        int n3 = this.getReadOffset(n, n2);
        return ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getFloat(n3);
    }

    public synchronized void putFloat(int n, int n2, float f) {
        int n3 = this.getWriteOffset(n, n2);
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putFloat(n3, f);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private synchronized double twoto(int n) {
        double d;
        try {
            d = 1.0;
            for (int i = 1; i <= Math.abs(n); ++i) {
                d = 2.0 * d;
            }
            if (n < 0) {
                d = 1.0 / d;
            }
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    public synchronized double getReal(int n, int n2) {
        double d;
        int n3 = this.getReadOffset(n, n2);
        int[] nArray = new int[6];
        boolean bl = false;
        for (int i = 0; i < 6; ++i) {
            nArray[i] = this.arBuffer[n3 + i];
            if (nArray[i] >= 0) continue;
            nArray[i] = 128 + (this.arBuffer[n3 + i] & 0x7F);
        }
        double d2 = 0.00390625;
        if (nArray[0] == 0) {
            d = 0.0;
        } else {
            double d3 = 1.0 + 2.0 * (((((double)nArray[1] * d2 + (double)nArray[2]) * d2 + (double)nArray[3]) * d2 + (double)nArray[4]) * d2 + (double)(nArray[5] & 0x7F)) * d2;
            if (nArray[5] > 127) {
                d3 = -d3;
            }
            d = d3 * this.twoto((short)nArray[0] - 129);
        }
        return d;
    }

    public synchronized void putReal(int n, int n2, double d) {
        int n3;
        int n4;
        short[] sArray = new short[6];
        byte[] byArray = new byte[8];
        int[] nArray = new int[8];
        short[] sArray2 = new short[4];
        byte[] byArray2 = new byte[6];
        boolean bl = false;
        ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).putDouble(0, d);
        ShortBuffer shortBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        sArray2[0] = shortBuffer.get(0);
        sArray2[1] = shortBuffer.get(1);
        sArray2[2] = shortBuffer.get(2);
        sArray2[3] = shortBuffer.get(3);
        for (n4 = 0; n4 < 8; n4 = (int)((short)(n4 + 1))) {
            nArray[n4] = byArray[n4];
            if (nArray[n4] >= 0) continue;
            nArray[n4] = 128 + (byArray[n4] & 0x7F);
        }
        for (n4 = 0; n4 < 6; n4 = (int)((short)(n4 + 1))) {
            sArray[n4] = 0;
        }
        if (d != 0.0) {
            int n5 = 894;
            int n6 = (int)Math.floor(sArray2[3] / 16) & 0x7FF;
            if (n6 >= n5 && n6 <= n5 + 255) {
                sArray[0] = (short)(n6 - n5);
                for (n4 = 5; n4 > 0; n4 = (int)((short)(n4 - 1))) {
                    n3 = nArray[n4 + 1];
                    if (n3 < 0) {
                        n3 = 128 + (nArray[n4 + 1] & 0x7F);
                    }
                    int n7 = nArray[n4];
                    if (n3 < 0) {
                        n7 = 128 + (nArray[n4] & 0x7F);
                    }
                    sArray[n4] = (short)(n3 * 8 & 0xF8 | n7 / 32 & 7);
                }
                sArray[5] = d < 0.0 ? (short)(sArray[5] | 0x80) : (short)(sArray[5] & 0x7F);
            }
        }
        for (n4 = 0; n4 < 6; n4 = (int)((short)(n4 + 1))) {
            byArray2[n4] = (byte)sArray[n4];
        }
        try {
            n3 = this.getWriteOffset(n, n2);
            System.arraycopy(byArray2, 0, this.arBuffer, n3, byArray2.length);
        }
        catch (Exception exception) {
            System.out.println("TBinaryFile.putReal: " + exception.toString());
        }
    }

    public synchronized double getDouble(int n, int n2) {
        int n3 = this.getReadOffset(n, n2);
        return ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN).getDouble(n3);
    }

    public synchronized void putDouble(int n, int n2, double d) {
        int n3 = this.getWriteOffset(n, n2);
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.arBuffer).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putDouble(n3, d);
        }
        catch (Exception exception) {
            System.out.println("TBinaryFile.putDouble: " + exception.toString());
        }
    }

    @Override
    public synchronized void swapRecords(int n, int n2) {
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            if (tDriverStructRecord.IsVirtual) continue;
            Object object = this.getField(tDriverStructRecord, n);
            Object object2 = this.getField(tDriverStructRecord, n2);
            this.putField(tDriverStructRecord, n, object2);
            this.putField(tDriverStructRecord, n2, object);
        }
    }

    @Override
    public synchronized void packRecords(StringBuilder stringBuilder) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (this.undoManager != null) {
            bl2 = this.undoManager.getUndoRecording();
            this.undoManager.setUndoRecording(false);
            this.undoManager.clear();
        }
        int n4 = this.getRecordCount();
        while (n < n4 && !bl) {
            if (this.isDeleted(n, stringBuilder)) {
                if (n2 <= n) {
                    n2 = n + 1;
                }
                while (n2 < n4 && this.isDeleted(n2, stringBuilder)) {
                    ++n2;
                }
                if (n2 < n4) {
                    this.swapRecords(n, n2);
                    n3 = n++;
                    continue;
                }
                bl = true;
                continue;
            }
            n3 = n++;
        }
        this.cRecords = n3 + 1;
        if (this.undoManager != null) {
            this.undoManager.setUndoRecording(bl2);
        }
    }

    @Override
    public String copyDriver(TDriverInterface tDriverInterface, String[] stringArray, String[] stringArray2) {
        if (tDriverInterface instanceof TBinaryBuffer) {
            this.clearBuffer();
            int n = ((TBinaryBuffer)tDriverInterface).arBuffer.length;
            this.arBuffer = new byte[n];
            this.cRecords = ((TBinaryBuffer)tDriverInterface).cRecords;
            System.arraycopy(((TBinaryBuffer)tDriverInterface).arBuffer, 0, this.arBuffer, 0, n);
            return "Ok";
        }
        return super.copyDriver(tDriverInterface, stringArray, stringArray2);
    }
}

