/*
 * Decompiled with CFR 0.152.
 */
package drivers.files;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TProgressBar;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.files.TBinaryBuffer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.objectutil;

public class TFixedWidthFile
extends TBinaryBuffer
implements TDriverInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = false;
    public String StructID;
    private char chDelimiter = (char)44;

    public TFixedWidthFile(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) throws IOException {
        super(tApplication, tAppDriversObject, n, bl);
        this.PerformanceMark.ClassName = "TFixedWidthFile";
        this.StructID = tAppDriversObject.StructureIndex.toString();
        if (this.Debug) {
            MainWin.appendToLog("TFixedWidthFile", "<init>", Thread.currentThread(), null, 10, "Opening " + this.AppDriversObject.Description + " (" + this.AppDriversObject.FileName + ")");
        }
    }

    @Override
    public int makeEditableFile() throws IOException {
        TAsciiInput tAsciiInput;
        block39: {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            dosutil.formatURL(stringBuilder, new StringBuilder(this.FileName));
            String string2 = stringBuilder.toString();
            URL uRL = new URL(stringBuilder.toString());
            this.IsLocal = false;
            this.IsWriteable = true;
            if (charutil.strcmpi(uRL.getProtocol(), "FILE") == 0) {
                this.IsLocal = true;
            }
            if ((string = string2.toUpperCase()).indexOf(".ZIP") >= 0 || string.indexOf(".JAR") >= 0) {
                this.IsWriteable = false;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            tAsciiInput = new TAsciiInput(string2, this.chDelimiter, true);
            if (!tAsciiInput.isValid()) break block39;
            int n = 0;
            while (tAsciiInput.get_string(stringBuilder) > 0) {
                int n2 = 0;
                block22: for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
                    Object object;
                    TDriverStructRecord tDriverStructRecord;
                    block41: {
                        block40: {
                            tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                            if (tDriverStructRecord.IsVirtual || tDriverStructRecord.Fixed_Width_Length <= 0) continue;
                            String string3 = "";
                            if (stringBuilder.length() >= n2 + tDriverStructRecord.Fixed_Width_Length) {
                                string3 = stringBuilder.substring(n2, n2 + tDriverStructRecord.Fixed_Width_Length).trim();
                            }
                            n2 += tDriverStructRecord.Fixed_Width_Length;
                            String string4 = tDriverStructRecord.FormatPattern.trim();
                            object = null;
                            if (string3.length() <= 0) break block40;
                            switch (tDriverStructRecord.FieldType) {
                                case 10: {
                                    if (string4.length() == 0) {
                                        string4 = "MM-dd-yyyy";
                                    }
                                    Object object2 = object = string3.length() == 0 ? new Date(0L) : dateutil.parseDate(string3, string4);
                                    if (object == null) {
                                        object = dateutil.parseDate(string3);
                                    }
                                    if (object == null) {
                                        object = new Date(0L);
                                        break;
                                    }
                                    break block41;
                                }
                                case 18: {
                                    if (string4.length() == 0) {
                                        string4 = "HH:mm:ss";
                                    }
                                    Object object3 = object = string3.length() == 0 ? new Date(0L) : dateutil.parseDate(string3, string4);
                                    if (object == null) {
                                        object = dateutil.parseTime(string3);
                                    }
                                    if (object == null) {
                                        object = new Date(0L);
                                        break;
                                    }
                                    break block41;
                                }
                                case 13: {
                                    if (string4.length() == 0) {
                                        string4 = "MM-dd-yyyy HH:mm:ss";
                                    }
                                    Object object4 = object = string3.length() == 0 ? new Date(0L) : dateutil.parseDate(string3, string4);
                                    if (object == null) {
                                        object = dateutil.parseDate(string3);
                                    }
                                    if (object == null) {
                                        object = new Date(0L);
                                        break;
                                    }
                                    break block41;
                                }
                                case 21: {
                                    if (string4.length() == 0) {
                                        string4 = "MM-dd-yyyy HH:mm:ss:SS";
                                    }
                                    Object object5 = object = string3.length() == 0 ? new Date(0L) : dateutil.parseDate(string3, string4);
                                    if (object == null) {
                                        object = dateutil.parseDate(string3);
                                    }
                                    if (object == null) {
                                        object = new Date(0L);
                                        break;
                                    }
                                    break block41;
                                }
                                default: {
                                    object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string3, n);
                                    break;
                                }
                            }
                            break block41;
                        }
                        object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, "", n);
                    }
                    switch (tDriverStructRecord.FieldType) {
                        case 19: {
                            this.putBoolean(n, tDriverStructRecord.Offset, (Boolean)object);
                            continue block22;
                        }
                        case 1: {
                            this.putBool(n, tDriverStructRecord.Offset, (Boolean)object);
                            continue block22;
                        }
                        case 25: {
                            this.putBoolYN(n, tDriverStructRecord.Offset, (Boolean)object);
                            continue block22;
                        }
                        case 2: {
                            this.putByte(n, tDriverStructRecord.Offset, ((Integer)object).byteValue());
                            continue block22;
                        }
                        case 3: 
                        case 11: 
                        case 15: 
                        case 20: 
                        case 24: 
                        case 26: {
                            this.putChars(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                            continue block22;
                        }
                        case 22: {
                            this.putBinaryData(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                            continue block22;
                        }
                        case 4: 
                        case 5: {
                            this.putShort(n, tDriverStructRecord.Offset, ((Integer)object).shortValue());
                            continue block22;
                        }
                        case 6: 
                        case 7: {
                            this.putInt(n, tDriverStructRecord.Offset, (Integer)object);
                            continue block22;
                        }
                        case 8: {
                            this.putFloat(n, tDriverStructRecord.Offset, ((Float)object).floatValue());
                            continue block22;
                        }
                        case 9: 
                        case 12: {
                            this.putDouble(n, tDriverStructRecord.Offset, (Double)object);
                            continue block22;
                        }
                        case 10: 
                        case 13: 
                        case 18: {
                            gregorianCalendar.setTime((Date)object);
                            this.putDate(n, tDriverStructRecord.Offset, gregorianCalendar);
                            continue block22;
                        }
                        case 21: {
                            gregorianCalendar.setTime((Date)object);
                            this.putLong(n, tDriverStructRecord.Offset, gregorianCalendar.getTimeInMillis());
                            continue block22;
                        }
                        case 16: {
                            this.putByte(n, tDriverStructRecord.Offset, (byte)0);
                            continue block22;
                        }
                        default: {
                            System.out.println("Error in makeEditableFile.  FieldType=" + tDriverStructRecord.FieldType);
                        }
                    }
                }
                Thread.yield();
                ++n;
            }
        }
        tAsciiInput.dispose();
        if (this.Debug) {
            MainWin.appendToLog("TFixedWidthFile", "makeEditableFile", Thread.currentThread(), null, 10, "Buffer is initialized with " + this.getRecordCount() + " records");
        }
        return 0;
    }

    @Override
    public int updateSourceFile() {
        if (this.Modified) {
            TFixedWidthFile.exportFile(this, this.getFileName(), this.DriverStruct, false, false, false, false, this.AppDriversObject.Delimiter);
        }
        return 0;
    }

    @Override
    public boolean verifySaveChanges() {
        int n = Aspect.MainWin.showConfirmDialog(null, "Save changes to " + this.AppDriversObject.Description + "?", "Confirm...", 0);
        return n == 0;
    }

    @Override
    public ArrayList getSupportedDriverCommands() {
        ArrayList arrayList = super.getSupportedDriverCommands();
        if (this.isLocal() && this.isWriteable()) {
            arrayList.add("/drivercmd/core/TDriverCmdSaveChangesNow.class");
        }
        return arrayList;
    }

    public static String formatFixedWidthField(TDriverStructRecord tDriverStructRecord, String string) {
        String string2 = string;
        char c = ' ';
        switch (tDriverStructRecord.Fixed_Width_Padding_Character) {
            case 0: {
                c = ' ';
                break;
            }
            case 1: {
                c = '0';
            }
        }
        if (string2.length() > tDriverStructRecord.Fixed_Width_Length) {
            string2 = string2.substring(0, tDriverStructRecord.Fixed_Width_Length);
            return string2;
        }
        if (tDriverStructRecord.Fixed_Width_Padding_Direction == 0) {
            while (string2.length() < tDriverStructRecord.Fixed_Width_Length) {
                string2 = string2 + c;
            }
        } else {
            while (string2.length() < tDriverStructRecord.Fixed_Width_Length) {
                string2 = c + string2;
            }
        }
        return string2;
    }

    public static String exportFile(TDriverInterface tDriverInterface, String string, TDriverStruct tDriverStruct, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        TDriverStructRecord tDriverStructRecord;
        int n2;
        TProgressBar tProgressBar = null;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 44;
        String string2 = "ok";
        switch (n) {
            case 0: {
                n3 = 44;
                break;
            }
            case 1: {
                n3 = 124;
                break;
            }
            case 2: {
                n3 = 9;
                break;
            }
            case 3: {
                n3 = 61;
            }
        }
        TAsciiOutput tAsciiOutput = new TAsciiOutput(string, '\u0000', false);
        TDriverStruct tDriverStruct2 = tDriverInterface.getDriverStruct();
        if (tDriverStruct == null) {
            tDriverStruct = tDriverStruct2;
        }
        if (bl) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                tAsciiOutput.writeString(tDriverStructRecord.Description, true);
            }
            tAsciiOutput.write_crlf();
        }
        if (bl2) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                tAsciiOutput.writeString(tDriverStructRecord.FullID, true);
            }
            tAsciiOutput.write_crlf();
        }
        if (bl3) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                tAsciiOutput.writeString(TAbstractDriver.getFieldTypeName(tDriverStructRecord.FieldType), false);
            }
            tAsciiOutput.write_crlf();
        }
        ArrayList arrayList = tDriverStruct.getAssociatedRecords(tDriverStruct2);
        int n4 = tDriverInterface.getRecordCount();
        if (!TMainWin.IsClosing) {
            tProgressBar = new TProgressBar("Saving changes...", n4, 750);
        }
        long l = 0L;
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                if (tDriverStructRecord.Fixed_Width_Length > 0) {
                    int n5 = (Integer)arrayList.get(n2);
                    if (n5 >= 0) {
                        TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)tDriverStruct2.FieldColl.get(n5);
                        Object object = tDriverInterface.getField(tDriverStructRecord2, i);
                        l += (long)tDriverStructRecord2.DataSize;
                        String string3 = tDriverStructRecord.FormatPattern.trim();
                        if (object != null) {
                            String string4 = "";
                            switch (tDriverStructRecord2.FieldType) {
                                case 1: 
                                case 19: 
                                case 25: {
                                    string4 = string3.length() > 0 ? objectutil.applyPattern(object, string3) : ((Boolean)object).toString();
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 2: {
                                    string4 = TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, ((Integer)object).toString());
                                    tAsciiOutput.writeString(string4);
                                    break;
                                }
                                case 3: 
                                case 11: 
                                case 15: 
                                case 24: {
                                    string4 = string3.length() > 0 ? objectutil.applyPattern(object, string3) : (String)object;
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 26: {
                                    string4 = (String)object;
                                    if (string4.trim().length() > 0) {
                                        string4 = charutil.encrypt(string4, "");
                                    }
                                    if (string3.length() > 0) {
                                        string4 = objectutil.applyPattern(string4, string3);
                                    }
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 22: {
                                    string4 = TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, (String)object);
                                    tAsciiOutput.writeString(string4);
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    string4 = string3.length() > 0 ? objectutil.applyPattern(object, string3) : ((Integer)object).toString();
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 6: 
                                case 7: {
                                    string4 = string3.length() > 0 ? objectutil.applyPattern(object, string3) : ((Integer)object).toString();
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 8: {
                                    string4 = string3.length() > 0 ? objectutil.applyPattern(object, string3) : ((Float)object).toString();
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 9: 
                                case 12: {
                                    string4 = string3.length() > 0 ? objectutil.applyPattern(object, string3) : ((Double)object).toString();
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 21: {
                                    if (string3.length() == 0) {
                                        string3 = "MM-dd-yyyy HH:mm:ss:SS";
                                    }
                                    string4 = objectutil.applyPattern(object, string3);
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 13: {
                                    if (string3.length() == 0) {
                                        string3 = "MM-dd-yyyy HH:mm:ss";
                                    }
                                    string4 = objectutil.applyPattern(object, string3);
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 18: {
                                    if (string3.length() == 0) {
                                        string3 = "HH:mm:ss";
                                    }
                                    string4 = objectutil.applyPattern(object, string3);
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                case 10: {
                                    if (string3.length() == 0) {
                                        string3 = "MM-dd-yyyy";
                                    }
                                    string4 = objectutil.applyPattern(object, string3);
                                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, string4));
                                    break;
                                }
                                default: {
                                    string4 = TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, "Error");
                                    tAsciiOutput.writeString(string4);
                                    break;
                                }
                            }
                            continue;
                        }
                        tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, "Error"));
                        continue;
                    }
                    tAsciiOutput.writeString(TFixedWidthFile.formatFixedWidthField(tDriverStructRecord, ""));
                    continue;
                }
                MainWin.appendToLog("TFixedWidthFile", "exportFile", Thread.currentThread(), null, 4, "Error: Missing fixed-field width in field: " + tDriverStructRecord.FullID);
            }
            tAsciiOutput.write_crlf();
            if (tProgressBar == null) continue;
            tProgressBar.increment();
        }
        tAsciiOutput.dispose();
        if (tProgressBar != null) {
            tProgressBar.dispose();
        }
        return string2;
    }
}

