/*
 * Decompiled with CFR 0.152.
 */
package drivers.files;

import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import java.io.File;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;

public class TUnformattedText
extends TAbstractDriver {
    public TUnformattedText(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        this.DriverStruct = new TDriverStruct(tApplication, tAppDriversObject.StructureIndex.toString());
        this.FormulaEvaluator = new TFormulaEvaluator(TMainWin.Application, this.DriverStruct, this);
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getRecordCount() {
        return 1;
    }

    @Override
    public boolean isDeleted(int n, StringBuilder stringBuilder) {
        return false;
    }

    @Override
    public boolean isInFilter(int n, StringBuilder stringBuilder) {
        return true;
    }

    @Override
    public Object getField(String string, int n) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (tDriverStructRecord == null) {
            return null;
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("filecontent")) {
            File file = new File(this.FileName);
            if (file.isDirectory()) {
                return "File is a directory and cannot be edited: " + this.FileName;
            }
            return TAsciiInput.getContent(this.FileName);
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("filename")) {
            return this.FileName;
        }
        return super.getField(tDriverStructRecord, n);
    }

    @Override
    public int putField(String string, int n, Object object) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.putField(tDriverStructRecord, n, object);
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        File file;
        if (tDriverStructRecord.ID.equalsIgnoreCase("filecontent") && !(file = new File(this.FileName)).isDirectory()) {
            TAsciiOutput.writeContent(this.FileName, (String)object);
        }
        return 0;
    }
}

