/*
 * Decompiled with CFR 0.152.
 */
package drivers.other;

import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import java.io.IOException;
import java.util.Date;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.html.THtmlParser;
import utility.html.TParseHtmlTag;

public class THtmlDocumentDriver
extends TAbstractDriver {
    private THtmlParser HtmlParser = null;

    public THtmlDocumentDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        this.DriverStruct = new TDriverStruct(tApplication, tAppDriversObject.StructureIndex.toString());
        this.FormulaEvaluator = new TFormulaEvaluator(TMainWin.Application, this.DriverStruct, this);
    }

    @Override
    public void dispose() {
    }

    @Override
    public int makeEditableFile() throws IOException {
        this.HtmlParser = new THtmlParser(this.FileName);
        this.HtmlParser.parseDocument();
        return 0;
    }

    @Override
    public int getRecordCount() {
        return this.HtmlParser.getTagCount();
    }

    @Override
    public Object getField(String string, int n) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (tDriverStructRecord == null) {
            return null;
        }
        Object object = null;
        TParseHtmlTag tParseHtmlTag = this.HtmlParser.getTag(n);
        if (tParseHtmlTag == null) {
            return null;
        }
        if (tDriverStructRecord.IsCalculated) {
            object = this.calculateField(tDriverStructRecord, n);
        } else {
            if (tDriverStructRecord.ID.equalsIgnoreCase("TagType")) {
                return tParseHtmlTag.getTagType();
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("Properties")) {
                return tParseHtmlTag.getProperties("");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("Properties_Html")) {
                return tParseHtmlTag.getPropertiesHtml();
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("Text")) {
                return tParseHtmlTag.getText();
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IndexStart")) {
                return new Integer(tParseHtmlTag.getStartIndex());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IndexEnd")) {
                return new Integer(tParseHtmlTag.getEndIndex());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("LineNumber")) {
                return new Integer(tParseHtmlTag.LineNumber);
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("Indent_Count")) {
                return new Integer(Math.max(tParseHtmlTag.getIndent(), 0));
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsClosed")) {
                return new Boolean(tParseHtmlTag.isClosed());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsClosingTag")) {
                return new Boolean(tParseHtmlTag.isClosingTag());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("MemberOf")) {
                return tParseHtmlTag.getMemberOf();
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("ParentTag")) {
                return new Integer(tParseHtmlTag.ParentTag);
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("HasMembers")) {
                return new Boolean(tParseHtmlTag.HasMembers);
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsBlockStart")) {
                return tParseHtmlTag.IsBlockStart;
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsAspectTag")) {
                return new Boolean(tParseHtmlTag.isAspectTag());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IncludeType")) {
                return tParseHtmlTag.getIncludeType();
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("formatOutput")) {
                return tParseHtmlTag.getFormattedOutput();
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("BlockContent")) {
                return this.HtmlParser.getBlockContent(n);
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsExpressionInclude")) {
                return new Boolean(tParseHtmlTag.isExpressionInclude());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsFileInclude")) {
                return new Boolean(tParseHtmlTag.isFileInclude());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsDriverInclude")) {
                return new Boolean(tParseHtmlTag.isDriverInclude());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsScriptInclude")) {
                return new Boolean(tParseHtmlTag.isScriptInclude());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsWidgetInclude")) {
                return new Boolean(tParseHtmlTag.isWidgetInclude());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsConstantInclude")) {
                return new Boolean(tParseHtmlTag.isConstantInclude());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsTableElement")) {
                return new Boolean(tParseHtmlTag.getIsTableElement());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsHeadElement")) {
                return new Boolean(tParseHtmlTag.getIsHeadElement());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsBodyElement")) {
                return new Boolean(tParseHtmlTag.getIsBodyElement());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("IsScriptElement")) {
                return new Boolean(tParseHtmlTag.getIsScriptElement());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("ErrNoOpeningTag")) {
                return new Boolean(tParseHtmlTag.getErrNoOpeningTag());
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("ErrWrongIndent")) {
                return new Boolean(tParseHtmlTag.ErrWrongIndent);
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("ErrNotClosed")) {
                return new Boolean(tParseHtmlTag.ErrNotClosed);
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("PropComment")) {
                return tParseHtmlTag.getProperty("comment");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("propInterval")) {
                return tParseHtmlTag.getProperty("interval");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("propURL")) {
                return tParseHtmlTag.getProperty("url");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("propStyle")) {
                return tParseHtmlTag.getProperty("style");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("propSrc")) {
                return tParseHtmlTag.getProperty("src");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("propWidth")) {
                return tParseHtmlTag.getProperty("width");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("propHeight")) {
                return tParseHtmlTag.getProperty("height");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("propForSpan")) {
                return tParseHtmlTag.getProperties("interval|url|style");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("propForDiv")) {
                return tParseHtmlTag.getProperties("interval|url|style");
            }
            if (tDriverStructRecord.ID.equalsIgnoreCase("propForImg")) {
                return tParseHtmlTag.getProperties("src|width|height");
            }
            if (tDriverStructRecord.ID.toUpperCase().startsWith("PROPEXPRESSION")) {
                return tParseHtmlTag.getProperty(tDriverStructRecord.ID.substring("propExpression".length()));
            }
            if (tDriverStructRecord.ID.toUpperCase().startsWith("PROPFILE")) {
                return tParseHtmlTag.getProperty(tDriverStructRecord.ID.substring("propFile".length()));
            }
            if (tDriverStructRecord.ID.toUpperCase().startsWith("PROPDRIVER")) {
                return tParseHtmlTag.getProperty(tDriverStructRecord.ID.substring("propDriver".length()));
            }
            if (tDriverStructRecord.ID.toUpperCase().startsWith("PROPSCRIPT")) {
                return tParseHtmlTag.getProperty(tDriverStructRecord.ID.substring("propScript".length()));
            }
            if (tDriverStructRecord.ID.toUpperCase().startsWith("PROPWIDGET")) {
                return tParseHtmlTag.getProperty(tDriverStructRecord.ID.substring("propWidget".length()));
            }
            if (tDriverStructRecord.ID.toUpperCase().startsWith("PROPCONSTANT")) {
                return tParseHtmlTag.getProperty(tDriverStructRecord.ID.substring("propConstant".length()));
            }
        }
        return object;
    }

    @Override
    public synchronized Object getFieldForTable(TDriverStructRecord tDriverStructRecord, int n) {
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public int putField(String string, int n, Object object) {
        boolean bl = false;
        if (string.equalsIgnoreCase("submitProperties")) {
            if (bl) {
                System.out.println("putField: ID=" + string + " Record=" + n + " Obj=" + object);
            }
            String string2 = "|INSERTBEFORE|INSERTTAGTYPE|INSERTTAGSUBTYPE|FORMSUBMISSION|BACKUPFILENAME|DELETETAG|";
            TParseHtmlTag tParseHtmlTag = this.HtmlParser.getTag(n);
            String[] stringArray = charutil.getSubStringArray((String)object, '|', false);
            if (stringArray == null || stringArray.length == 0) {
                return 0;
            }
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            int n2 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                if (bl) {
                    System.out.println("arTemp[" + i + "]=" + stringArray[i]);
                }
                if ((stringArray2 = charutil.getSubStringArray(stringArray[i], '=', false)) == null || stringArray2.length <= 0) continue;
                if (string2.indexOf("|" + stringArray2[0].toUpperCase() + "|") >= 0) {
                    if (stringArray2[0].equalsIgnoreCase("InsertBefore")) {
                        n2 = charutil.ival(charutil.removeQuotes(stringArray2[1]));
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("InsertTagType")) {
                        string5 = charutil.removeQuotes(stringArray2[1]);
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("InsertTagSubtype")) {
                        string6 = charutil.removeQuotes(stringArray2[1]);
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("BackupFilename")) {
                        string4 = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("FormSubmission")) {
                        bl2 = true;
                        continue;
                    }
                    if (!stringArray2[0].equalsIgnoreCase("DeleteTag")) continue;
                    bl3 = true;
                    continue;
                }
                if (string3.length() > 0) {
                    string3 = string3 + "|";
                }
                string3 = string3 + stringArray[i];
            }
            String[] stringArray3 = charutil.getSubStringArray(string3, '|', false);
            if (bl) {
                System.out.println("Obj: " + object);
                System.out.println("Props: " + string3);
                System.out.println("BackupName: " + string4);
                System.out.println("InsertTagType: " + string5);
                System.out.println("InsertTagSubType: " + string6);
                System.out.println("InsertIndex: " + n2);
                System.out.println("DeleteTag: " + bl3);
                if (stringArray3 == null || stringArray3.length == 0) {
                    System.out.println("arProps is empty");
                } else {
                    for (int i = 0; i < stringArray3.length; ++i) {
                        System.out.println("Prop[" + i + "]=" + stringArray3[i]);
                    }
                }
            }
            TAsciiInput tAsciiInput = new TAsciiInput(this.HtmlParser.getUrl());
            StringBuilder stringBuilder = new StringBuilder(new String(tAsciiInput.get_entire_file()));
            tAsciiInput.dispose();
            if (n >= this.HtmlParser.getTagCount()) {
                if (string5.length() == 0) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (int i = 0; i < stringArray3.length; ++i) {
                        stringBuilder2.append(stringArray3[i]);
                    }
                    if (bl) {
                        System.out.println("Inserting at index: " + n2 + " " + stringBuilder2);
                    }
                    stringBuilder.insert(n2, stringBuilder2.toString());
                } else {
                    tParseHtmlTag = new TParseHtmlTag(string5);
                    if (string6.trim().length() > 0 && string6.toUpperCase().indexOf("__NEWTAGSUBTYPE__") < 0) {
                        tParseHtmlTag.setProperty("type", string6);
                    }
                    for (int i = 0; i < stringArray3.length; ++i) {
                        String[] stringArray4 = charutil.getSubStringArray(stringArray3[i], '=', false);
                        if (stringArray4 != null && stringArray4.length > 1 && charutil.removeQuotes(stringArray4[1]).length() > 0) {
                            tParseHtmlTag.setProperty(stringArray4[0], stringArray4[1]);
                            continue;
                        }
                        if (!TParseHtmlTag.isSimpleProperty(stringArray4[0])) continue;
                        tParseHtmlTag.setProperty(stringArray4[0], "");
                    }
                    String string7 = tParseHtmlTag.getFormattedOutput();
                    if (!tParseHtmlTag.isAspectTag() && !tParseHtmlTag.isSimpleTag()) {
                        string7 = string7 + "</" + tParseHtmlTag.getTagType() + ">";
                    }
                    if (bl) {
                        System.out.println("Inserting at index: " + n2 + " " + string7);
                    }
                    stringBuilder.insert(n2, string7);
                }
            } else if (bl3) {
                int n3 = (Integer)this.getField("DiskIndex", n);
                int n4 = tParseHtmlTag.getStartIndex();
                int n5 = tParseHtmlTag.getEndIndex();
                for (int i = 0; i < this.HtmlParser.getTagCount(); ++i) {
                    TParseHtmlTag tParseHtmlTag2 = this.HtmlParser.getTag(i);
                    String string8 = "|" + tParseHtmlTag2.getMemberOf() + "|";
                    if (string8.indexOf("|" + Integer.toString(n3) + "|") < 0) continue;
                    n5 = tParseHtmlTag2.getEndIndex();
                }
                if (bl) {
                    System.out.println("Delete: " + stringBuilder.substring(n4, n5 + 1));
                }
                stringBuilder.replace(n4, n5 + 1, "");
            } else if (tParseHtmlTag.isText()) {
                String[] stringArray5;
                if (bl) {
                    System.out.println("Replacing:");
                    System.out.println(stringBuilder.substring(tParseHtmlTag.getStartIndex(), tParseHtmlTag.getEndIndex() + 1));
                    System.out.println(string3);
                }
                if ((stringArray5 = charutil.getSubStringArray(string3, '=', true)) != null && stringArray5.length > 1) {
                    stringBuilder.replace(tParseHtmlTag.getStartIndex(), tParseHtmlTag.getEndIndex() + 1, stringArray5[1]);
                }
            } else {
                if (stringArray3 != null) {
                    for (int i = 0; i < stringArray3.length; ++i) {
                        String[] stringArray6 = charutil.getSubStringArray(stringArray3[i], '=', false);
                        if (stringArray6 != null) {
                            if (stringArray6.length == 1) {
                                tParseHtmlTag.setProperty(stringArray6[0], "");
                            } else if (stringArray6.length == 2) {
                                tParseHtmlTag.setProperty(stringArray6[0], stringArray6[1]);
                            } else {
                                System.out.println("Wrong number of property elements in tag: " + stringArray3[i]);
                            }
                        }
                        if (stringArray6 != null && stringArray6.length != 2) continue;
                    }
                }
                String string9 = tParseHtmlTag.getFormattedOutput();
                if (bl) {
                    System.out.println("Replacing:");
                    System.out.println(stringBuilder.substring(tParseHtmlTag.getStartIndex(), tParseHtmlTag.getEndIndex() + 1));
                    System.out.println(string9);
                }
                stringBuilder.replace(tParseHtmlTag.getStartIndex(), tParseHtmlTag.getEndIndex() + 1, string9);
            }
            TAsciiOutput.writeContent(this.HtmlParser.getUrl(), stringBuilder.toString());
            if (string4.length() > 0) {
                string4 = TMainWin.Application.getHomeDir() + "temporary_files/" + string4;
                string4 = string4 + "_" + dateutil.formatDate(new Date(), "yyyyMMdd_HHmmss") + ".bak";
                if (bl) {
                    System.out.println("copying " + this.HtmlParser.getUrl() + " to " + string4);
                }
                dosutil.copyFile(this.HtmlParser.getUrl(), string4, false);
            }
        }
        return 0;
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        return this.putField(tDriverStructRecord.ID, n, object);
    }

    @Override
    public void notifyRecordDelete() {
        super.notifyRecordDelete();
    }
}

