/*
 * Decompiled with CFR 0.152.
 */
package investing.DataSeries;

import aspect.Aspect;
import aspect.TMainWin;
import investing.DataSeries.DataSeriesInfo;
import investing.DataSeries.TSeriesValuesColl;
import investing.DataSeries.TSeriesValuesObj;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.objectutil;
import utility.statistics;

public class DataSeriesUtility {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TSeriesValuesColl SeriesValuesColl = new TSeriesValuesColl();
    private static Hashtable hashSeriesCRC = new Hashtable();
    private static Hashtable hashFirstDateInSeries = new Hashtable();
    private static Hashtable hashExDividendDate = new Hashtable();
    private static Hashtable hashLastDateInSeries = new Hashtable();

    public static ArrayList getIntervalStats(String string, Date date, Date date2, String string2, String string3, int n) {
        return DataSeriesUtility.getIntervalStats(string, date, date2, string2, string3, n, 0);
    }

    public static ArrayList getIntervalStats(String string, Date date, Date date2, String string2, String string3, int n, int n2) {
        ArrayList<TSeriesValuesObj> arrayList = new ArrayList<TSeriesValuesObj>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        int n3 = -1;
        if (string2.equalsIgnoreCase("day")) {
            n3 = 0;
        } else if (string2.equalsIgnoreCase("week")) {
            n3 = 1;
        } else if (string2.equalsIgnoreCase("month")) {
            n3 = 2;
        } else if (string2.equalsIgnoreCase("quarter")) {
            n3 = 3;
        } else if (string2.equalsIgnoreCase("semiannual")) {
            n3 = 4;
        } else if (string2.equalsIgnoreCase("year")) {
            n3 = 5;
        }
        ArrayList arrayList3 = SeriesValuesColl.getValues(string, date, date2, string3);
        String string4 = "";
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        int n4 = 0;
        double d = 0.0;
        while (gregorianCalendar.getTime().getTime() < date2.getTime()) {
            Object object;
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setTime(gregorianCalendar.getTime());
            switch (n3) {
                case 0: {
                    gregorianCalendar2.add(5, 1);
                    break;
                }
                case 1: {
                    gregorianCalendar2.add(5, 7);
                    break;
                }
                case 2: {
                    gregorianCalendar2.add(2, 1);
                    break;
                }
                case 3: {
                    gregorianCalendar2.add(2, 3);
                    break;
                }
                case 4: {
                    gregorianCalendar2.add(2, 6);
                    break;
                }
                case 5: {
                    gregorianCalendar2.add(1, 1);
                    break;
                }
                default: {
                    gregorianCalendar2.setTime(date2);
                    gregorianCalendar2.add(5, 1);
                }
            }
            arrayList4.clear();
            for (int i = n4; i < arrayList3.size(); ++i) {
                object = (TSeriesValuesObj)arrayList3.get(i);
                if (((TSeriesValuesObj)object).IsAddedDate || ((TSeriesValuesObj)object).date < gregorianCalendar.getTime().getTime()) continue;
                if (((TSeriesValuesObj)object).date < gregorianCalendar2.getTime().getTime()) {
                    arrayList4.add(new Double(((TSeriesValuesObj)object).DoubleValue()));
                    arrayList2.add(new Double(((TSeriesValuesObj)object).DoubleValue()));
                    if (arrayList2.size() <= n2) continue;
                    arrayList2.remove(0);
                    continue;
                }
                n4 = i;
                break;
            }
            GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
            gregorianCalendar3.setTime(gregorianCalendar2.getTime());
            gregorianCalendar3.add(5, -1);
            if (arrayList4.size() > 0) {
                object = statistics.toArray(arrayList4);
                double d2 = 0.0;
                switch (n) {
                    case 0: {
                        d2 = statistics.stddev((double[])object);
                        break;
                    }
                    case 1: {
                        d2 = statistics.mean((double[])object);
                        break;
                    }
                    case 2: {
                        d2 = statistics.max((double[])object);
                        break;
                    }
                    case 3: {
                        d2 = statistics.min((double[])object);
                        break;
                    }
                    case 4: {
                        d2 = statistics.sum((double[])object);
                        break;
                    }
                    case 5: {
                        d2 = (double)object[0];
                        break;
                    }
                    case 6: {
                        d2 = (double)object[((Object)object).length - 1];
                        break;
                    }
                    case 7: {
                        if (arrayList2.size() == n2) {
                            object = statistics.toArray(arrayList2);
                            d2 = statistics.mean((double[])object);
                            break;
                        }
                        d2 = 0.0;
                    }
                }
                arrayList.add(new TSeriesValuesObj(gregorianCalendar3.getTime().getTime(), d2));
                d = d2;
            } else {
                arrayList.add(new TSeriesValuesObj(gregorianCalendar3.getTime().getTime(), d));
            }
            gregorianCalendar.setTime(gregorianCalendar2.getTime());
        }
        return arrayList;
    }

    public static ArrayList getDerivative(ArrayList arrayList) {
        ArrayList<TSeriesValuesObj> arrayList2 = new ArrayList<TSeriesValuesObj>();
        System.out.println("getDerivative");
        for (int i = 1; i < arrayList.size(); ++i) {
            TSeriesValuesObj tSeriesValuesObj = (TSeriesValuesObj)arrayList.get(i - 1);
            TSeriesValuesObj tSeriesValuesObj2 = (TSeriesValuesObj)arrayList.get(i);
            double d = tSeriesValuesObj2.DoubleValue() - tSeriesValuesObj.DoubleValue();
            System.out.println("i=" + i + " d2=" + tSeriesValuesObj2.DoubleValue() + " d1=" + tSeriesValuesObj.DoubleValue() + " d=" + d);
            arrayList2.add(new TSeriesValuesObj(tSeriesValuesObj2.date, d));
        }
        return arrayList2;
    }

    public static ArrayList getSeriesValues(String string, Date date, Date date2, String string2, String string3, boolean bl) {
        if (bl && DataSeriesInfo.getFileModified(string) < date2.getTime()) {
            if (DataSeriesInfo.isFredDataSeries(string)) {
                TFormulaEvaluator.eval("updateDependentDriver(\"Investing_Fred_Time_Series\",\"SeriesID=" + string + "\",false)");
            } else if (DataSeriesInfo.isAlphaVantageDataSeries(string)) {
                TFormulaEvaluator.eval("updateDependentDriver(\"Investing_Alpha_Vantage_Stock_Quote\",\"SeriesID=" + string + "\",false)");
            }
        }
        return DataSeriesUtility.getSeriesValues(string, date, date2, string2, string3);
    }

    public static ArrayList getSeriesValues(String string, Date date, Date date2, String string2, String string3) {
        Object object;
        Comparable<Calendar> comparable;
        boolean bl;
        ArrayList<TSeriesValuesObj> arrayList = new ArrayList<TSeriesValuesObj>();
        boolean bl2 = false;
        if (bl2) {
            System.out.println("getSeriesValues\t" + string + "\t" + dateutil.formatDate(date) + "\t" + dateutil.formatDate(date2) + "\tInterval=" + string2 + "\tFieldID=" + string3);
        }
        ArrayList arrayList2 = SeriesValuesColl.getValues(string, date, date2, string3);
        if (bl2) {
            System.out.println("DataSeriesUtility.getSeriesValues arSeriesValues.size()=" + arrayList2.size());
        }
        if ((bl = string3.equalsIgnoreCase("Dividend_Amount")) && arrayList2.size() > 0) {
            comparable = (TSeriesValuesObj)arrayList2.get(arrayList2.size() - 1);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            object = new GregorianCalendar();
            Date date3 = dateutil.date(new Date());
            gregorianCalendar.setTime(new Date(((TSeriesValuesObj)comparable).date));
            while (gregorianCalendar.getTime().getTime() < dateutil.date(date2).getTime()) {
                gregorianCalendar.add(5, 1);
                TSeriesValuesObj tSeriesValuesObj = new TSeriesValuesObj(gregorianCalendar.getTime().getTime(), 0);
                ((Calendar)object).setTime(gregorianCalendar.getTime());
                int n = 0;
                while (((Calendar)object).getTime().getTime() >= date3.getTime()) {
                    ((GregorianCalendar)object).add(5, -364);
                    n += 364;
                }
                if (arrayList2.size() - n > 0) {
                    TSeriesValuesObj tSeriesValuesObj2 = (TSeriesValuesObj)arrayList2.get(arrayList2.size() - n);
                    tSeriesValuesObj.Value = tSeriesValuesObj2.Value;
                }
                arrayList2.add(tSeriesValuesObj);
            }
        }
        comparable = new GregorianCalendar();
        ((Calendar)comparable).setTime(dateutil.date(date));
        int n = 0;
        if (string2.equalsIgnoreCase("week")) {
            n = 1;
        } else if (string2.equalsIgnoreCase("month")) {
            n = 2;
        } else if (string2.equalsIgnoreCase("quarter")) {
            n = 3;
        } else if (string2.equalsIgnoreCase("semiannual")) {
            n = 4;
        } else if (string2.equalsIgnoreCase("year")) {
            n = 5;
        }
        object = "";
        int n2 = arrayList2.size();
        int n3 = 0;
        while (((Calendar)comparable).getTime().getTime() <= date2.getTime()) {
            Date date4 = new Date(0L);
            double d = 0.0;
            if (n3 < n2) {
                TSeriesValuesObj tSeriesValuesObj = (TSeriesValuesObj)arrayList2.get(n3);
                date4.setTime(tSeriesValuesObj.date);
                d = tSeriesValuesObj.DoubleValue();
                if (bl2) {
                    System.out.println("dt=" + dateutil.formatDate(date4, "MM-dd-yyyy") + "\tDbl=" + d);
                }
                while (date4.getTime() < ((Calendar)comparable).getTime().getTime() && n3 < n2) {
                    if (++n3 < n2) {
                        tSeriesValuesObj = (TSeriesValuesObj)arrayList2.get(n3);
                        date4.setTime(tSeriesValuesObj.date);
                        d = tSeriesValuesObj.DoubleValue();
                        continue;
                    }
                    d = 0.0;
                }
            }
            if (d != 0.0 || !bl) {
                arrayList.add(new TSeriesValuesObj(date4.getTime(), new Double(d)));
            }
            switch (n) {
                case 0: {
                    ((GregorianCalendar)comparable).add(5, 1);
                    break;
                }
                case 1: {
                    ((GregorianCalendar)comparable).add(5, 7);
                    break;
                }
                case 2: {
                    ((GregorianCalendar)comparable).add(2, 1);
                    break;
                }
                case 3: {
                    ((GregorianCalendar)comparable).add(2, 3);
                    break;
                }
                case 4: {
                    ((GregorianCalendar)comparable).add(2, 6);
                    break;
                }
                case 5: {
                    ((GregorianCalendar)comparable).add(1, 1);
                }
            }
            if (!bl2) continue;
            System.out.println("new cal=" + dateutil.formatDate(((Calendar)comparable).getTime()));
        }
        if (bl2) {
            System.out.println("getSeriesValues\t" + string + " complete");
        }
        return arrayList;
    }

    public static String getSeriesStats(String string, Date date, Date date2, String string2) {
        Date date3 = new Date();
        Date date4 = new Date();
        double d = 0.0;
        double d2 = 0.0;
        ArrayList arrayList = SeriesValuesColl.getValues(string, date, date2, string2);
        double[] dArray = new double[arrayList.size()];
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            TSeriesValuesObj tSeriesValuesObj = (TSeriesValuesObj)arrayList.get(i);
            if (tSeriesValuesObj.IsAddedDate) continue;
            dArray[n] = tSeriesValuesObj.DoubleValue();
            if (n == 0 || dArray[n] > d) {
                date3.setTime(tSeriesValuesObj.date);
                d = dArray[n];
            }
            if (n == 0 || dArray[n] < d2) {
                date4.setTime(tSeriesValuesObj.date);
                d2 = dArray[n];
            }
            ++n;
        }
        double d3 = statistics.stddev(dArray, n);
        double d4 = statistics.mean(dArray, n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Min=" + charutil.formatNumber(d2, "0.00"));
        stringBuilder.append("&MinDate=" + dateutil.formatDate(date4, "MM-dd-yyyy"));
        stringBuilder.append("&Max=" + charutil.formatNumber(d, "0.00"));
        stringBuilder.append("&MaxDate=" + dateutil.formatDate(date3, "MM-dd-yyyy"));
        stringBuilder.append("&Mean=" + charutil.formatNumber(d4, "0.00"));
        stringBuilder.append("&Stddev=" + charutil.formatNumber(d3, "0.00"));
        return stringBuilder.toString();
    }

    public static double getSeriesValuesCorrel(String string, String string2) {
        String[] stringArray = charutil.getSubStringArray(string, '|', false);
        String[] stringArray2 = charutil.getSubStringArray(string2, '|', false);
        if (stringArray == null) {
            System.out.println("Error: getSeriesValuesCorrel _series1 is null");
            return 0.0;
        }
        if (stringArray2 == null) {
            System.out.println("Error: getSeriesValuesCorrel _series2 is null");
            return 0.0;
        }
        if (stringArray.length != stringArray2.length) {
            System.out.println("Error: getSeriesValuesCorrel _series1 and _series2 size is different");
            return 0.0;
        }
        int n = stringArray.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i].substring(0, 10);
            double d = charutil.dval(stringArray[i].substring(11));
            String string4 = stringArray2[i].substring(0, 10);
            double d2 = charutil.dval(stringArray2[i].substring(11));
            if (!string3.equals(string4)) {
                System.out.println("Error: getSeriesValuesCorrel mismatched dates");
            }
            dArray[i] = d;
            dArray2[i] = d2;
        }
        return statistics.correlation(dArray, dArray2);
    }

    public static double getSeriesStat(String string, Date date, Date date2, String string2, int n) {
        ArrayList arrayList = SeriesValuesColl.getValues(string, date, date2, string2);
        double[] dArray = new double[arrayList.size()];
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            TSeriesValuesObj tSeriesValuesObj = (TSeriesValuesObj)arrayList.get(i);
            if (tSeriesValuesObj.IsAddedDate) continue;
            dArray[n2] = objectutil.convertToNumber(tSeriesValuesObj.Value);
            ++n2;
        }
        double d = 0.0;
        switch (n) {
            case 0: {
                d = statistics.mean(dArray, n2);
                break;
            }
            case 1: {
                d = statistics.max(dArray, n2);
                break;
            }
            case 2: {
                d = statistics.min(dArray, n2);
                break;
            }
            case 3: {
                d = statistics.stddev(dArray, n2);
                break;
            }
            case 4: {
                d = statistics.sum(dArray, n2);
            }
        }
        return d;
    }

    public static Date getLastDateInSeries(String string, boolean bl) {
        if (DataSeriesInfo.isFredDataSeries(string)) {
            int n;
            String string2;
            if (bl) {
                TFormulaEvaluator.eval("updateDependentDriver(\"Investing_Fred_Time_Series\",\"SeriesID=" + string + "\",false)");
            }
            if (!dosutil.fileExists(string2 = DataSeriesInfo.getFredFilename(string))) {
                return new Date(0L);
            }
            String string3 = string.toUpperCase();
            Long l = new Long(dosutil.getChecksum(string2));
            if (hashLastDateInSeries.containsKey(string3) && hashSeriesCRC.containsKey(string3) && l.equals((Long)hashSeriesCRC.get(string3))) {
                return (Date)hashLastDateInSeries.get(string3);
            }
            String string4 = TAsciiInput.getEntireFile(string2);
            if (!string4.endsWith("\r\n")) {
                string4 = string4 + "\r\n";
            }
            for (n = string4.length() - 3; n > 0 && string4.charAt(n) != '\n'; --n) {
            }
            if (string4.length() < n + 11) {
                return new Date(0L);
            }
            String string5 = string4.substring(n + 1, n + 11);
            Date date = dateutil.parseDate(string5);
            String string6 = (String)TFormulaEvaluator.eval("lookup(Investing_Fred_Series_Definition_Frequency_by_Series_ID,\"" + string + "\")");
            if (string6.equalsIgnoreCase("Quarterly, End of Period")) {
                date = dateutil.getQuarterEnd(0, date);
            }
            hashSeriesCRC.put(string3, l);
            hashLastDateInSeries.put(string3, date);
            return date;
        }
        if (DataSeriesInfo.isAlphaVantageDataSeries(string)) {
            String string7;
            if (bl) {
                TFormulaEvaluator.eval("updateDependentDriver(\"Investing_Alpha_Vantage_Stock_Quote\",\"SeriesID=" + string + "\",false)");
            }
            if (!dosutil.fileExists(string7 = DataSeriesInfo.getAlphaVantageFilename(string))) {
                return new Date(0L);
            }
            String string8 = string.toUpperCase();
            Long l = new Long(dosutil.getChecksum(string7));
            if (hashLastDateInSeries.containsKey(string8) && hashSeriesCRC.containsKey(string8) && l.equals((Long)hashSeriesCRC.get(string8))) {
                return (Date)hashLastDateInSeries.get(string8);
            }
            String string9 = TAsciiInput.getEntireFile(string7);
            if (!string9.endsWith("\r\n")) {
                string9 = string9 + "\r\n";
            }
            int n = string9.indexOf(10);
            if (string9.length() < n + 11) {
                return new Date(0L);
            }
            String string10 = string9.substring(n + 1, n + 11);
            if (string10.charAt(4) == '-') {
                Date date = dateutil.parseDate(string10);
                hashSeriesCRC.put(string8, l);
                hashLastDateInSeries.put(string8, date);
                return date;
            }
            return new Date(0L);
        }
        return new Date(0L);
    }

    public static Date getFirstDateInSeries(String string, boolean bl) {
        if (DataSeriesInfo.isFredDataSeries(string)) {
            String string2;
            if (bl) {
                TFormulaEvaluator.eval("updateDependentDriver(\"Investing_Fred_Time_Series\",\"SeriesID=" + string + "\",false)");
            }
            if (!dosutil.fileExists(string2 = DataSeriesInfo.getFredFilename(string))) {
                return new Date(0L);
            }
            String string3 = string.toUpperCase();
            Long l = new Long(dosutil.getChecksum(string2));
            if (hashFirstDateInSeries.containsKey(string3) && hashSeriesCRC.containsKey(string3) && l.equals((Long)hashSeriesCRC.get(string3))) {
                return (Date)hashFirstDateInSeries.get(string3);
            }
            String string4 = TAsciiInput.getEntireFile(string2);
            if (!string4.endsWith("\r\n")) {
                string4 = string4 + "\r\n";
            }
            int n = string4.indexOf(10);
            if (string4.length() < n + 11) {
                return new Date(0L);
            }
            String string5 = string4.substring(n + 1, n + 11);
            Date date = dateutil.parseDate(string5);
            hashSeriesCRC.put(string3, l);
            hashFirstDateInSeries.put(string3, date);
            return date;
        }
        if (DataSeriesInfo.isAlphaVantageDataSeries(string)) {
            int n;
            String string6;
            if (bl) {
                TFormulaEvaluator.eval("updateDependentDriver(\"Investing_Alpha_Vantage_Stock_Quote\",\"SeriesID=" + string + "\",false)");
            }
            if (!dosutil.fileExists(string6 = DataSeriesInfo.getAlphaVantageFilename(string))) {
                return new Date(0L);
            }
            String string7 = string.toUpperCase();
            Long l = new Long(dosutil.getChecksum(string6));
            if (hashFirstDateInSeries.containsKey(string7) && hashSeriesCRC.containsKey(string7) && l.equals((Long)hashSeriesCRC.get(string7))) {
                return (Date)hashFirstDateInSeries.get(string7);
            }
            String string8 = TAsciiInput.getEntireFile(string6);
            if (!string8.endsWith("\r\n")) {
                string8 = string8 + "\r\n";
            }
            for (n = string8.length() - 3; n > 0 && string8.charAt(n) != '\n'; --n) {
            }
            if (string8.length() < n + 11) {
                return new Date(0L);
            }
            String string9 = string8.substring(n + 1, n + 11);
            Date date = dateutil.parseDate(string9);
            hashSeriesCRC.put(string7, l);
            hashFirstDateInSeries.put(string7, date);
            return date;
        }
        return new Date(0L);
    }

    public static Date getExDividendDate(String string, boolean bl) {
        System.out.println("getExDividendDate _SeriesID=" + string + " _UpdateDependentDriver=" + bl);
        if (bl) {
            TFormulaEvaluator.eval("updateDependentDriver(\"Investing_Alpha_Vantage_Stock_Quote\",\"SeriesID=" + string + "\",false)");
        }
        String string2 = DataSeriesInfo.getAlphaVantageFilename(string);
        System.out.println("getExDividendDate Filename=" + string2);
        if (!dosutil.fileExists(string2)) {
            System.out.println("getExDividendDate file does not exist");
            return new Date(0L);
        }
        String string3 = string.toUpperCase();
        Long l = new Long(dosutil.getChecksum(string2));
        if (hashExDividendDate.containsKey(string3) && hashSeriesCRC.containsKey(string3) && l.equals((Long)hashSeriesCRC.get(string3))) {
            System.out.println("getExDividendDate returning hash value: " + (Date)hashExDividendDate.get(string3));
            return (Date)hashExDividendDate.get(string3);
        }
        String string4 = TAsciiInput.getEntireFile(string2);
        if (!string4.endsWith("\r\n")) {
            string4 = string4 + "\r\n";
        }
        Date date = new Date(0L);
        Date date2 = new Date(0L);
        String[] stringArray = charutil.getSubStringArray(string4, '\n', false);
        if (stringArray != null) {
            System.out.println("ar len=" + stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                double d;
                String[] stringArray2 = charutil.getSubStringArray(stringArray[i], ',', false);
                if (stringArray2 == null || stringArray2.length <= 0 || !((d = charutil.dval(stringArray2[7])) > 0.0)) continue;
                System.out.println("d=" + d);
                if (date.getTime() == 0L) {
                    date = dateutil.parseDate(stringArray2[0], "yyyy-MM-dd");
                    System.out.println("ar1[0]=" + stringArray2[0]);
                    continue;
                }
                date2 = dateutil.parseDate(stringArray2[0], "yyyy-MM-dd");
                long l2 = date.getTime() - date2.getTime();
                Date date3 = new Date();
                date3.setTime(date.getTime() + l2);
                hashSeriesCRC.put(string3, l);
                hashExDividendDate.put(string3, date3);
                return date3;
            }
        }
        hashSeriesCRC.put(string3, l);
        hashFirstDateInSeries.put(string3, new Date(0L));
        System.out.println("getExDividendDate returning date(0)");
        return new Date(0L);
    }

    public static int countTradingDays(Date date, Date date2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = 0;
        while (gregorianCalendar.getTime().getTime() <= date2.getTime()) {
            if (gregorianCalendar.get(7) >= 2 && gregorianCalendar.get(7) <= 6) {
                ++n;
            }
            gregorianCalendar.add(5, 1);
        }
        return n;
    }
}

