/*
 * Decompiled with CFR 0.152.
 */
package investing.DataSeries;

import java.util.Date;
import utility.dateutil;

class TDataSeriesObj
implements Comparable {
    long Date = 0L;
    double Open = 0.0;
    double High = 0.0;
    double Low = 0.0;
    double Close = 0.0;
    double Adjusted_Close = 0.0;
    long Volume = 0L;
    double DividendAmount = 0.0;
    double SplitCoefficient = 0.0;
    boolean IsAddedDate = false;

    TDataSeriesObj(Date date, double d) {
        this.Date = date.getTime();
        this.Close = d;
        this.Adjusted_Close = d;
    }

    TDataSeriesObj(Date date, double d, double d2, double d3, double d4, double d5, long l, double d6, double d7) {
        this.Date = date.getTime();
        this.Open = d;
        this.High = d2;
        this.Low = d3;
        this.Close = d4;
        this.Adjusted_Close = d5;
        this.Volume = l;
        this.DividendAmount = d6;
        this.SplitCoefficient = d7;
    }

    TDataSeriesObj(Date date, TDataSeriesObj tDataSeriesObj) {
        this.Date = date.getTime();
        this.Close = tDataSeriesObj.Close;
        this.Adjusted_Close = tDataSeriesObj.Adjusted_Close;
    }

    public static String getFredHeader() {
        return "observation_date\tDFF\trealtime_start_date\trealtime_end_date";
    }

    public String toFredString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dateutil.formatDate(new Date(this.Date), "yyyy-MM-dd"));
        stringBuilder.append("\t");
        stringBuilder.append(Double.toString(this.Close));
        stringBuilder.append("\t");
        stringBuilder.append("\t");
        stringBuilder.append("\t");
        stringBuilder.append(this.IsAddedDate);
        return stringBuilder.toString();
    }

    public static String getAlphaVantageHeader() {
        return "timestamp,open,high,low,close,adjusted_close,volume,dividend_amount,split_coefficient";
    }

    public String toAlphaVantageString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dateutil.formatDate(new Date(this.Date), "yyyy-MM-dd"));
        stringBuilder.append(",");
        stringBuilder.append(Double.toString(this.Open));
        stringBuilder.append(",");
        stringBuilder.append(Double.toString(this.High));
        stringBuilder.append(",");
        stringBuilder.append(Double.toString(this.Low));
        stringBuilder.append(",");
        stringBuilder.append(Double.toString(this.Close));
        stringBuilder.append(",");
        stringBuilder.append(Double.toString(this.Adjusted_Close));
        stringBuilder.append(",");
        stringBuilder.append(Double.toString(this.Volume));
        stringBuilder.append(",");
        stringBuilder.append(Double.toString(this.DividendAmount));
        stringBuilder.append(",");
        stringBuilder.append(Double.toString(this.SplitCoefficient));
        stringBuilder.append(",");
        stringBuilder.append(this.IsAddedDate);
        return stringBuilder.toString();
    }

    public int compareTo(Object object) {
        if (this.Date < ((TDataSeriesObj)object).Date) {
            return -1;
        }
        if (this.Date > ((TDataSeriesObj)object).Date) {
            return 1;
        }
        return 0;
    }
}

