/*
 * Decompiled with CFR 0.152.
 */
package investing.asset_pricing;

import investing.asset_pricing.TAssetDistribution;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import utility.charutil;
import utility.dateutil;
import utility.financial;

public class TAsset {
    public Date StartDate;
    public Date EndDate;
    public double StartPrice = 0.0;
    public double EndPrice = 0.0;
    public ArrayList Distributions = null;

    public TAsset(Date date, Date date2) {
        this.StartDate = dateutil.date(date);
        this.EndDate = dateutil.date(date2);
    }

    public void setStartValue(double d) {
        this.StartPrice = d;
    }

    public void setEndValue(double d) {
        this.EndPrice = d;
    }

    public static String getDistributionString(Date date, Date date2, int n, double d, double d2) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 12;
                break;
            }
            case 2: {
                n2 = 6;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 3;
            }
        }
        double d3 = d * d2;
        double d4 = d3 / (double)n;
        String string = "";
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(dateutil.date(date));
        while (gregorianCalendar.getTime().getTime() <= date2.getTime()) {
            if (string.length() > 0) {
                string = string + "|";
            }
            string = string + dateutil.formatDate(gregorianCalendar.getTime(), "MM-dd-yyyy") + "," + d4;
            gregorianCalendar.add(2, n2);
        }
        return string;
    }

    public void setDistributions(String string) {
        if (this.Distributions == null) {
            this.Distributions = new ArrayList();
        } else {
            this.Distributions.clear();
        }
        String[] stringArray = charutil.getSubStringArray(string, '|', false);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = charutil.getSubStringArray(stringArray[i], ',', false);
                if (stringArray2 == null || stringArray2.length != 2) continue;
                Date date = dateutil.parseDate(stringArray2[0]);
                double d = charutil.dval(stringArray2[1]);
                this.Distributions.add(new TAssetDistribution(date, d));
            }
        }
    }

    public double getTotalDistributionPresentValue(double d) {
        double d2 = 0.0;
        long l = 86400000L;
        if (this.Distributions != null) {
            for (int i = 0; i < this.Distributions.size(); ++i) {
                TAssetDistribution tAssetDistribution = (TAssetDistribution)this.Distributions.get(i);
                double d3 = (double)((tAssetDistribution.PaymentDate.getTime() - this.StartDate.getTime() - l) / l) / 365.0;
                d3 = (double)Math.round(d3 * 100.0) / 100.0;
                d2 += financial.pv(tAssetDistribution.Amount, d, d3);
            }
        }
        return d2;
    }

    public double presentValue(double d) {
        double d2 = this.getTotalDistributionPresentValue(d);
        long l = 86400000L;
        double d3 = (double)((this.EndDate.getTime() - this.StartDate.getTime() - l) / l) / 365.0;
        return d2 += financial.pv(this.EndPrice, d, d3);
    }

    public double futureValue(double d) {
        double d2 = this.getTotalDistributionPresentValue(d);
        double d3 = this.StartPrice - d2;
        long l = 86400000L;
        double d4 = (double)((this.EndDate.getTime() - this.StartDate.getTime()) / l) / 365.0;
        double d5 = d3 / Math.pow(1.0 + d, -d4);
        return d5;
    }

    public double getCagr() {
        double d = 9.0;
        double d2 = -9.0;
        while (d - d2 > 0.001) {
            double d3 = d - (d - d2) / 2.0;
            double d4 = this.presentValue(d3);
            if (d4 < this.StartPrice) {
                d = d3;
                continue;
            }
            d2 = d3;
        }
        return d - (d - d2) / 2.0;
    }
}

